/* state-connecting.c generated by valac 0.38.7, the Vala compiler
 * generated from state-connecting.vala, do not modify */

/*   FILE: state-connecting.vala -- A state machine implementing lcdgrilo's menu
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 14 December 2013 
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * stop:        stop currently playing and clear playlist.
 * pauseplay:   pause if playing else transition from paused to playing.
 * seekback:    no operation.
 * seekforward: no operation.
 * next:        no operation.
 * previous:    no operation.
 * transition:  transition to state given from state lower on the stack.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gee.h>
#include <grilo.h>


#define TYPE_STATE (state_get_type ())
#define STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE, State))
#define STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE, StateClass))
#define IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE))
#define IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE))
#define STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE, StateClass))

typedef struct _State State;
typedef struct _StateClass StateClass;
typedef struct _StatePrivate StatePrivate;

#define TYPE_LCD_PLAYER (lcd_player_get_type ())
#define LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LCD_PLAYER, LCDPlayer))
#define LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LCD_PLAYER, LCDPlayerClass))
#define IS_LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LCD_PLAYER))
#define IS_LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LCD_PLAYER))
#define LCD_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LCD_PLAYER, LCDPlayerClass))

typedef struct _LCDPlayer LCDPlayer;
typedef struct _LCDPlayerClass LCDPlayerClass;

#define TYPE_STATE_CONNECTING (state_connecting_get_type ())
#define STATE_CONNECTING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CONNECTING, StateConnecting))
#define STATE_CONNECTING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CONNECTING, StateConnectingClass))
#define IS_STATE_CONNECTING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CONNECTING))
#define IS_STATE_CONNECTING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CONNECTING))
#define STATE_CONNECTING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CONNECTING, StateConnectingClass))

typedef struct _StateConnecting StateConnecting;
typedef struct _StateConnectingClass StateConnectingClass;
typedef struct _StateConnectingPrivate StateConnectingPrivate;
enum  {
	STATE_CONNECTING_0_PROPERTY,
	STATE_CONNECTING_NUM_PROPERTIES
};
static GParamSpec* state_connecting_properties[STATE_CONNECTING_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _LCDPlayerPrivate LCDPlayerPrivate;

#define TYPE_INPUT_OUTPUT (input_output_get_type ())
#define INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_OUTPUT, InputOutput))
#define INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_OUTPUT, InputOutputClass))
#define IS_INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_OUTPUT))
#define IS_INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_OUTPUT))
#define INPUT_OUTPUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_OUTPUT, InputOutputClass))

typedef struct _InputOutput InputOutput;
typedef struct _InputOutputClass InputOutputClass;

struct _State {
	GObject parent_instance;
	StatePrivate * priv;
	LCDPlayer* player;
};

struct _StateClass {
	GObjectClass parent_class;
	void (*print_selected) (State* self);
	void (*seekback) (State* self);
	void (*seekforward) (State* self);
	void (*next) (State* self);
	void (*previous) (State* self);
	State* (*transition) (State* self);
};

struct _StateConnecting {
	State parent_instance;
	StateConnectingPrivate * priv;
};

struct _StateConnectingClass {
	StateClass parent_class;
};

struct _StateConnectingPrivate {
	gchar* target_name;
	State* next_state;
};

struct _LCDPlayer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LCDPlayerPrivate * priv;
	GstElement* element;
	GeeArrayList* playlist;
	InputOutput* io;
};

struct _LCDPlayerClass {
	GTypeClass parent_class;
	void (*finalize) (LCDPlayer *self);
};


static gpointer state_connecting_parent_class = NULL;

GType state_get_type (void) G_GNUC_CONST;
gpointer lcd_player_ref (gpointer instance);
void lcd_player_unref (gpointer instance);
GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lcd_player (GValue* value, gpointer v_object);
void value_take_lcd_player (GValue* value, gpointer v_object);
gpointer value_get_lcd_player (const GValue* value);
GType lcd_player_get_type (void) G_GNUC_CONST;
GType state_connecting_get_type (void) G_GNUC_CONST;
#define STATE_CONNECTING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATE_CONNECTING, StateConnectingPrivate))
StateConnecting* state_connecting_new (GMainLoop* loop, LCDPlayer* player, const gchar* target_name, State* next_state);
StateConnecting* state_connecting_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, const gchar* target_name, State* next_state);
State* state_construct (GType object_type);
void state_print_selected (State* self);
static void state_connecting_real_print_selected (State* base);
GType input_output_get_type (void) G_GNUC_CONST;
void input_output_output (InputOutput* self, const gchar* str);
static void state_connecting_real_seekback (State* base);
static void state_connecting_real_seekforward (State* base);
static void state_connecting_real_next (State* base);
static void state_connecting_real_previous (State* base);
static State* state_connecting_real_transition (State* base);
static void state_connecting_finalize (GObject * obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


StateConnecting* state_connecting_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, const gchar* target_name, State* next_state) {
	StateConnecting * self = NULL;
	LCDPlayer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	State* _tmp3_;
	State* _tmp4_;
	g_return_val_if_fail (loop != NULL, NULL);
	g_return_val_if_fail (player != NULL, NULL);
	g_return_val_if_fail (target_name != NULL, NULL);
	g_return_val_if_fail (next_state != NULL, NULL);
	self = (StateConnecting*) state_construct (object_type);
	_tmp0_ = player;
	((State*) self)->player = _tmp0_;
	_tmp1_ = target_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->target_name);
	self->priv->target_name = _tmp2_;
	_tmp3_ = next_state;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->next_state);
	self->priv->next_state = _tmp4_;
	state_print_selected ((State*) self);
	return self;
}


StateConnecting* state_connecting_new (GMainLoop* loop, LCDPlayer* player, const gchar* target_name, State* next_state) {
	return state_connecting_construct (TYPE_STATE_CONNECTING, loop, player, target_name, next_state);
}


static void state_connecting_real_print_selected (State* base) {
	StateConnecting * self;
	LCDPlayer* _tmp0_;
	InputOutput* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	self = (StateConnecting*) base;
	_tmp0_ = ((State*) self)->player;
	_tmp1_ = _tmp0_->io;
	_tmp2_ = self->priv->target_name;
	_tmp3_ = g_strconcat ("Connecting to ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "...", NULL);
	_tmp6_ = _tmp5_;
	input_output_output (_tmp1_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
}


static void state_connecting_real_seekback (State* base) {
	StateConnecting * self;
	self = (StateConnecting*) base;
}


static void state_connecting_real_seekforward (State* base) {
	StateConnecting * self;
	self = (StateConnecting*) base;
}


static void state_connecting_real_next (State* base) {
	StateConnecting * self;
	self = (StateConnecting*) base;
}


static void state_connecting_real_previous (State* base) {
	StateConnecting * self;
	self = (StateConnecting*) base;
}


static State* state_connecting_real_transition (State* base) {
	StateConnecting * self;
	State* result = NULL;
	State* _tmp0_;
	State* _tmp1_;
	self = (StateConnecting*) base;
	_tmp0_ = self->priv->next_state;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void state_connecting_class_init (StateConnectingClass * klass) {
	state_connecting_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StateConnectingPrivate));
	((StateClass *) klass)->print_selected = (void (*) (State *)) state_connecting_real_print_selected;
	((StateClass *) klass)->seekback = (void (*) (State *)) state_connecting_real_seekback;
	((StateClass *) klass)->seekforward = (void (*) (State *)) state_connecting_real_seekforward;
	((StateClass *) klass)->next = (void (*) (State *)) state_connecting_real_next;
	((StateClass *) klass)->previous = (void (*) (State *)) state_connecting_real_previous;
	((StateClass *) klass)->transition = (State* (*) (State *)) state_connecting_real_transition;
	G_OBJECT_CLASS (klass)->finalize = state_connecting_finalize;
}


static void state_connecting_instance_init (StateConnecting * self) {
	self->priv = STATE_CONNECTING_GET_PRIVATE (self);
}


static void state_connecting_finalize (GObject * obj) {
	StateConnecting * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATE_CONNECTING, StateConnecting);
	_g_free0 (self->priv->target_name);
	_g_object_unref0 (self->priv->next_state);
	G_OBJECT_CLASS (state_connecting_parent_class)->finalize (obj);
}


GType state_connecting_get_type (void) {
	static volatile gsize state_connecting_type_id__volatile = 0;
	if (g_once_init_enter (&state_connecting_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StateConnectingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) state_connecting_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StateConnecting), 0, (GInstanceInitFunc) state_connecting_instance_init, NULL };
		GType state_connecting_type_id;
		state_connecting_type_id = g_type_register_static (TYPE_STATE, "StateConnecting", &g_define_type_info, 0);
		g_once_init_leave (&state_connecting_type_id__volatile, state_connecting_type_id);
	}
	return state_connecting_type_id__volatile;
}



