/* state-choose-source.c generated by valac 0.38.7, the Vala compiler
 * generated from state-choose-source.vala, do not modify */

/*   FILE: state-choose-service.vala -- A state machine implementing lcdgrilo's menu
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 01 December 2013 
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * stop:        stop currently playing and clear playlist.
 * pauseplay:   pause if playing else transition from paused to playing.
 * seekback:    no operation.
 * seekforward: no operation.
 * next:        select next source in menu.
 * previous:    select previous source in menu.
 * transition:  connect to the selected source; state to
 *              StateConnecting (StateChooseCategory).
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <grilo.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_STATE (state_get_type ())
#define STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE, State))
#define STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE, StateClass))
#define IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE))
#define IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE))
#define STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE, StateClass))

typedef struct _State State;
typedef struct _StateClass StateClass;
typedef struct _StatePrivate StatePrivate;

#define TYPE_LCD_PLAYER (lcd_player_get_type ())
#define LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LCD_PLAYER, LCDPlayer))
#define LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LCD_PLAYER, LCDPlayerClass))
#define IS_LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LCD_PLAYER))
#define IS_LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LCD_PLAYER))
#define LCD_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LCD_PLAYER, LCDPlayerClass))

typedef struct _LCDPlayer LCDPlayer;
typedef struct _LCDPlayerClass LCDPlayerClass;

#define TYPE_STATE_CHOOSE_SOURCE (state_choose_source_get_type ())
#define STATE_CHOOSE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CHOOSE_SOURCE, StateChooseSource))
#define STATE_CHOOSE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CHOOSE_SOURCE, StateChooseSourceClass))
#define IS_STATE_CHOOSE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CHOOSE_SOURCE))
#define IS_STATE_CHOOSE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CHOOSE_SOURCE))
#define STATE_CHOOSE_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CHOOSE_SOURCE, StateChooseSourceClass))

typedef struct _StateChooseSource StateChooseSource;
typedef struct _StateChooseSourceClass StateChooseSourceClass;
typedef struct _StateChooseSourcePrivate StateChooseSourcePrivate;

#define STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER (state_choose_source_media_list_builder_get_type ())
#define STATE_CHOOSE_SOURCE_MEDIA_LIST_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER, StateChooseSourceMediaListBuilder))
#define STATE_CHOOSE_SOURCE_MEDIA_LIST_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER, StateChooseSourceMediaListBuilderClass))
#define STATE_CHOOSE_SOURCE_IS_MEDIA_LIST_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER))
#define STATE_CHOOSE_SOURCE_IS_MEDIA_LIST_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER))
#define STATE_CHOOSE_SOURCE_MEDIA_LIST_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER, StateChooseSourceMediaListBuilderClass))

typedef struct _StateChooseSourceMediaListBuilder StateChooseSourceMediaListBuilder;
typedef struct _StateChooseSourceMediaListBuilderClass StateChooseSourceMediaListBuilderClass;
enum  {
	STATE_CHOOSE_SOURCE_0_PROPERTY,
	STATE_CHOOSE_SOURCE_NUM_PROPERTIES
};
static GParamSpec* state_choose_source_properties[STATE_CHOOSE_SOURCE_NUM_PROPERTIES];
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _state_choose_source_media_list_builder_unref0(var) ((var == NULL) ? NULL : (var = (state_choose_source_media_list_builder_unref (var), NULL)))
typedef struct _LCDPlayerPrivate LCDPlayerPrivate;

#define TYPE_INPUT_OUTPUT (input_output_get_type ())
#define INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_OUTPUT, InputOutput))
#define INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_OUTPUT, InputOutputClass))
#define IS_INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_OUTPUT))
#define IS_INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_OUTPUT))
#define INPUT_OUTPUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_OUTPUT, InputOutputClass))

typedef struct _InputOutput InputOutput;
typedef struct _InputOutputClass InputOutputClass;

#define TYPE_STATE_CHOOSE_CATEGORY (state_choose_category_get_type ())
#define STATE_CHOOSE_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategory))
#define STATE_CHOOSE_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategoryClass))
#define IS_STATE_CHOOSE_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CHOOSE_CATEGORY))
#define IS_STATE_CHOOSE_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CHOOSE_CATEGORY))
#define STATE_CHOOSE_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategoryClass))

typedef struct _StateChooseCategory StateChooseCategory;
typedef struct _StateChooseCategoryClass StateChooseCategoryClass;

#define TYPE_STATE_CONNECTING (state_connecting_get_type ())
#define STATE_CONNECTING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CONNECTING, StateConnecting))
#define STATE_CONNECTING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CONNECTING, StateConnectingClass))
#define IS_STATE_CONNECTING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CONNECTING))
#define IS_STATE_CONNECTING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CONNECTING))
#define STATE_CONNECTING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CONNECTING, StateConnectingClass))

typedef struct _StateConnecting StateConnecting;
typedef struct _StateConnectingClass StateConnectingClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _StateChooseSourceMediaListBuilderPrivate StateChooseSourceMediaListBuilderPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _StateChooseSourceParamSpecMediaListBuilder StateChooseSourceParamSpecMediaListBuilder;

struct _State {
	GObject parent_instance;
	StatePrivate * priv;
	LCDPlayer* player;
};

struct _StateClass {
	GObjectClass parent_class;
	void (*print_selected) (State* self);
	void (*seekback) (State* self);
	void (*seekforward) (State* self);
	void (*next) (State* self);
	void (*previous) (State* self);
	State* (*transition) (State* self);
};

struct _StateChooseSource {
	State parent_instance;
	StateChooseSourcePrivate * priv;
};

struct _StateChooseSourceClass {
	StateClass parent_class;
};

struct _StateChooseSourcePrivate {
	GMainLoop* loop;
	GeeArrayList* sources;
	gint current;
	StateChooseSourceMediaListBuilder* media_list_builder;
};

struct _LCDPlayer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LCDPlayerPrivate * priv;
	GstElement* element;
	GeeArrayList* playlist;
	InputOutput* io;
};

struct _LCDPlayerClass {
	GTypeClass parent_class;
	void (*finalize) (LCDPlayer *self);
};

struct _StateChooseSourceMediaListBuilder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StateChooseSourceMediaListBuilderPrivate * priv;
};

struct _StateChooseSourceMediaListBuilderClass {
	GTypeClass parent_class;
	void (*finalize) (StateChooseSourceMediaListBuilder *self);
};

struct _StateChooseSourceMediaListBuilderPrivate {
	StateChooseCategory* state;
};

struct _StateChooseSourceParamSpecMediaListBuilder {
	GParamSpec parent_instance;
};


static gpointer state_choose_source_parent_class = NULL;
static gpointer state_choose_source_media_list_builder_parent_class = NULL;

GType state_get_type (void) G_GNUC_CONST;
gpointer lcd_player_ref (gpointer instance);
void lcd_player_unref (gpointer instance);
GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lcd_player (GValue* value, gpointer v_object);
void value_take_lcd_player (GValue* value, gpointer v_object);
gpointer value_get_lcd_player (const GValue* value);
GType lcd_player_get_type (void) G_GNUC_CONST;
GType state_choose_source_get_type (void) G_GNUC_CONST;
static gpointer state_choose_source_media_list_builder_ref (gpointer instance);
static void state_choose_source_media_list_builder_unref (gpointer instance);
static GParamSpec* state_choose_source_param_spec_media_list_builder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void state_choose_source_value_set_media_list_builder (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void state_choose_source_value_take_media_list_builder (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer state_choose_source_value_get_media_list_builder (const GValue* value) G_GNUC_UNUSED;
static GType state_choose_source_media_list_builder_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define STATE_CHOOSE_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATE_CHOOSE_SOURCE, StateChooseSourcePrivate))
StateChooseSource* state_choose_source_new (GMainLoop* loop, LCDPlayer* player, GeeArrayList* sources);
StateChooseSource* state_choose_source_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, GeeArrayList* sources);
State* state_construct (GType object_type);
void state_print_selected (State* self);
static void state_choose_source_real_print_selected (State* base);
GType input_output_get_type (void) G_GNUC_CONST;
void input_output_output (InputOutput* self, const gchar* str);
static void state_choose_source_real_seekback (State* base);
static void state_choose_source_real_seekforward (State* base);
static void state_choose_source_real_next (State* base);
static void state_choose_source_real_previous (State* base);
static State* state_choose_source_real_transition (State* base);
GType state_choose_category_get_type (void) G_GNUC_CONST;
StateChooseCategory* state_choose_category_new (GMainLoop* loop, LCDPlayer* player, GrlSource* source, GrlMedia* parent_selection);
StateChooseCategory* state_choose_category_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, GrlSource* source, GrlMedia* parent_selection);
static StateChooseSourceMediaListBuilder* state_choose_source_media_list_builder_new (StateChooseCategory* state);
static StateChooseSourceMediaListBuilder* state_choose_source_media_list_builder_construct (GType object_type, StateChooseCategory* state);
static void state_choose_source_media_list_builder_browse_cb (StateChooseSourceMediaListBuilder* self, GrlSource* source, guint operation_id, GrlMedia* media, guint remaining, GError* _error_);
static void _state_choose_source_media_list_builder_browse_cb_grl_source_result_cb (GrlSource* source, guint operation_id, GrlMedia* media, guint remaining, gpointer self, GError* _error_);
StateConnecting* state_connecting_new (GMainLoop* loop, LCDPlayer* player, const gchar* target_name, State* next_state);
StateConnecting* state_connecting_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, const gchar* target_name, State* next_state);
GType state_connecting_get_type (void) G_GNUC_CONST;
#define STATE_CHOOSE_SOURCE_MEDIA_LIST_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER, StateChooseSourceMediaListBuilderPrivate))
void state_choose_category_add_media (StateChooseCategory* self, GrlMedia* media);
void state_choose_category_connected_cb (StateChooseCategory* self, GrlSource* source);
static void state_choose_source_media_list_builder_finalize (StateChooseSourceMediaListBuilder * obj);
static void state_choose_source_finalize (GObject * obj);


static gpointer _g_main_loop_ref0 (gpointer self) {
	return self ? g_main_loop_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


StateChooseSource* state_choose_source_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, GeeArrayList* sources) {
	StateChooseSource * self = NULL;
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	LCDPlayer* _tmp4_;
	g_return_val_if_fail (loop != NULL, NULL);
	g_return_val_if_fail (player != NULL, NULL);
	g_return_val_if_fail (sources != NULL, NULL);
	self = (StateChooseSource*) state_construct (object_type);
	_tmp0_ = loop;
	_tmp1_ = _g_main_loop_ref0 (_tmp0_);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp1_;
	_tmp2_ = sources;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->sources);
	self->priv->sources = _tmp3_;
	_tmp4_ = player;
	((State*) self)->player = _tmp4_;
	state_print_selected ((State*) self);
	return self;
}


StateChooseSource* state_choose_source_new (GMainLoop* loop, LCDPlayer* player, GeeArrayList* sources) {
	return state_choose_source_construct (TYPE_STATE_CHOOSE_SOURCE, loop, player, sources);
}


static void state_choose_source_real_print_selected (State* base) {
	StateChooseSource * self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (StateChooseSource*) base;
	_tmp0_ = self->priv->sources;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (0 == _tmp2_) {
		LCDPlayer* _tmp3_;
		InputOutput* _tmp4_;
		_tmp3_ = ((State*) self)->player;
		_tmp4_ = _tmp3_->io;
		input_output_output (_tmp4_, "No media source found");
	} else {
		LCDPlayer* _tmp5_;
		InputOutput* _tmp6_;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gpointer _tmp9_;
		const gchar* _tmp10_;
		_tmp5_ = ((State*) self)->player;
		_tmp6_ = _tmp5_->io;
		_tmp7_ = self->priv->sources;
		_tmp8_ = self->priv->current;
		_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
		_tmp10_ = grl_source_get_name ((GrlSource*) _tmp9_);
		input_output_output (_tmp6_, _tmp10_);
	}
}


static void state_choose_source_real_seekback (State* base) {
	StateChooseSource * self;
	self = (StateChooseSource*) base;
}


static void state_choose_source_real_seekforward (State* base) {
	StateChooseSource * self;
	self = (StateChooseSource*) base;
}


static void state_choose_source_real_next (State* base) {
	StateChooseSource * self;
	gint _tmp0_ = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (StateChooseSource*) base;
	_tmp1_ = self->priv->sources;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		gint _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->sources;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = (_tmp4_ + 1) % _tmp7_;
	} else {
		_tmp0_ = 0;
	}
	self->priv->current = _tmp0_;
	state_print_selected ((State*) self);
}


static void state_choose_source_real_previous (State* base) {
	StateChooseSource * self;
	gint _tmp0_ = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (StateChooseSource*) base;
	_tmp1_ = self->priv->sources;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		gint _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->sources;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->sources;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = ((_tmp4_ + _tmp7_) - 1) % _tmp10_;
	} else {
		_tmp0_ = 0;
	}
	self->priv->current = _tmp0_;
	state_print_selected ((State*) self);
}


static void _state_choose_source_media_list_builder_browse_cb_grl_source_result_cb (GrlSource* source, guint operation_id, GrlMedia* media, guint remaining, gpointer self, GError* _error_) {
	state_choose_source_media_list_builder_browse_cb ((StateChooseSourceMediaListBuilder*) self, source, operation_id, media, remaining, _error_);
}


static State* state_choose_source_real_transition (State* base) {
	StateChooseSource * self;
	State* result = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GList* keys = NULL;
	GrlKeyID _tmp4_;
	GrlKeyID _tmp5_;
	GrlKeyID _tmp6_;
	GrlKeyID _tmp7_;
	GrlKeyID _tmp8_;
	GrlKeyID _tmp9_;
	GList* _tmp10_;
	GrlCaps* caps = NULL;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gpointer _tmp13_;
	GrlCaps* _tmp14_;
	GrlCaps* _tmp15_;
	GrlOperationOptions* options = NULL;
	GrlCaps* _tmp16_;
	GrlOperationOptions* _tmp17_;
	StateChooseCategory* next_state = NULL;
	GMainLoop* _tmp18_;
	LCDPlayer* _tmp19_;
	GeeArrayList* _tmp20_;
	gint _tmp21_;
	gpointer _tmp22_;
	StateChooseCategory* _tmp23_;
	StateChooseCategory* _tmp24_;
	StateChooseSourceMediaListBuilder* _tmp25_;
	GeeArrayList* _tmp26_;
	gint _tmp27_;
	gpointer _tmp28_;
	GList* _tmp29_;
	GrlOperationOptions* _tmp30_;
	StateChooseSourceMediaListBuilder* _tmp31_;
	GMainLoop* _tmp32_;
	LCDPlayer* _tmp33_;
	GeeArrayList* _tmp34_;
	gint _tmp35_;
	gpointer _tmp36_;
	const gchar* _tmp37_;
	StateChooseCategory* _tmp38_;
	StateConnecting* _tmp39_;
	self = (StateChooseSource*) base;
	_tmp0_ = self->priv->sources;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (0 == _tmp2_) {
		State* _tmp3_;
		_tmp3_ = _g_object_ref0 ((State*) self);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = GRL_METADATA_KEY_ALBUM;
	_tmp5_ = GRL_METADATA_KEY_ARTIST;
	_tmp6_ = GRL_METADATA_KEY_TITLE;
	_tmp7_ = GRL_METADATA_KEY_TRACK_NUMBER;
	_tmp8_ = GRL_METADATA_KEY_URL;
	_tmp9_ = GRL_METADATA_KEY_AUDIO_TRACK;
	_tmp10_ = grl_metadata_key_list_new (_tmp4_, _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, NULL);
	keys = _tmp10_;
	_tmp11_ = self->priv->sources;
	_tmp12_ = self->priv->current;
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
	_tmp14_ = grl_source_get_caps ((GrlSource*) _tmp13_, GRL_OP_BROWSE);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	caps = _tmp15_;
	_tmp16_ = caps;
	_tmp17_ = grl_operation_options_new (_tmp16_);
	options = _tmp17_;
	_tmp18_ = self->priv->loop;
	_tmp19_ = ((State*) self)->player;
	_tmp20_ = self->priv->sources;
	_tmp21_ = self->priv->current;
	_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
	_tmp23_ = state_choose_category_new (_tmp18_, _tmp19_, (GrlSource*) _tmp22_, NULL);
	next_state = _tmp23_;
	_tmp24_ = next_state;
	_tmp25_ = state_choose_source_media_list_builder_new (_tmp24_);
	_state_choose_source_media_list_builder_unref0 (self->priv->media_list_builder);
	self->priv->media_list_builder = _tmp25_;
	_tmp26_ = self->priv->sources;
	_tmp27_ = self->priv->current;
	_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _tmp27_);
	_tmp29_ = keys;
	_tmp30_ = options;
	_tmp31_ = self->priv->media_list_builder;
	grl_source_browse ((GrlSource*) _tmp28_, NULL, _tmp29_, _tmp30_, _state_choose_source_media_list_builder_browse_cb_grl_source_result_cb, _tmp31_);
	_tmp32_ = self->priv->loop;
	_tmp33_ = ((State*) self)->player;
	_tmp34_ = self->priv->sources;
	_tmp35_ = self->priv->current;
	_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
	_tmp37_ = grl_source_get_name ((GrlSource*) _tmp36_);
	_tmp38_ = next_state;
	_tmp39_ = state_connecting_new (_tmp32_, _tmp33_, _tmp37_, (State*) _tmp38_);
	result = (State*) _tmp39_;
	_g_object_unref0 (next_state);
	_g_object_unref0 (options);
	_g_object_unref0 (caps);
	_g_list_free0 (keys);
	return result;
}


static StateChooseSourceMediaListBuilder* state_choose_source_media_list_builder_construct (GType object_type, StateChooseCategory* state) {
	StateChooseSourceMediaListBuilder* self = NULL;
	StateChooseCategory* _tmp0_;
	StateChooseCategory* _tmp1_;
	g_return_val_if_fail (state != NULL, NULL);
	self = (StateChooseSourceMediaListBuilder*) g_type_create_instance (object_type);
	_tmp0_ = state;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp1_;
	return self;
}


static StateChooseSourceMediaListBuilder* state_choose_source_media_list_builder_new (StateChooseCategory* state) {
	return state_choose_source_media_list_builder_construct (STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER, state);
}


static void state_choose_source_media_list_builder_browse_cb (StateChooseSourceMediaListBuilder* self, GrlSource* source, guint operation_id, GrlMedia* media, guint remaining, GError* _error_) {
	GError* _tmp0_;
	GrlMedia* _tmp10_;
	guint _tmp13_;
	gboolean _tmp16_ = FALSE;
	GrlMedia* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = _error_;
	if (NULL != _tmp0_) {
		GString* builder = NULL;
		GString* _tmp1_;
		GString* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		StateChooseCategory* _tmp5_;
		LCDPlayer* _tmp6_;
		InputOutput* _tmp7_;
		GString* _tmp8_;
		const gchar* _tmp9_;
		_tmp1_ = g_string_new ("");
		builder = _tmp1_;
		_tmp2_ = builder;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_string_printf (_tmp2_, "Error browsing: %s\n", _tmp4_);
		_tmp5_ = self->priv->state;
		_tmp6_ = ((State*) _tmp5_)->player;
		_tmp7_ = _tmp6_->io;
		_tmp8_ = builder;
		_tmp9_ = _tmp8_->str;
		input_output_output (_tmp7_, _tmp9_);
		_g_string_free0 (builder);
		_g_object_unref0 (media);
		return;
	}
	_tmp10_ = media;
	if (NULL != _tmp10_) {
		StateChooseCategory* _tmp11_;
		GrlMedia* _tmp12_;
		_tmp11_ = self->priv->state;
		_tmp12_ = media;
		state_choose_category_add_media (_tmp11_, _tmp12_);
	}
	_tmp13_ = remaining;
	if (((guint) 0) == _tmp13_) {
		StateChooseCategory* _tmp14_;
		GrlSource* _tmp15_;
		_tmp14_ = self->priv->state;
		_tmp15_ = source;
		state_choose_category_connected_cb (_tmp14_, _tmp15_);
	}
	_tmp17_ = media;
	if (NULL == _tmp17_) {
		guint _tmp18_;
		_tmp18_ = remaining;
		_tmp16_ = _tmp18_ != ((guint) 0);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		StateChooseCategory* _tmp19_;
		LCDPlayer* _tmp20_;
		InputOutput* _tmp21_;
		_tmp19_ = self->priv->state;
		_tmp20_ = ((State*) _tmp19_)->player;
		_tmp21_ = _tmp20_->io;
		input_output_output (_tmp21_, "Error browsing");
		_g_object_unref0 (media);
		return;
	}
	_g_object_unref0 (media);
}


static void state_choose_source_value_media_list_builder_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void state_choose_source_value_media_list_builder_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		state_choose_source_media_list_builder_unref (value->data[0].v_pointer);
	}
}


static void state_choose_source_value_media_list_builder_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = state_choose_source_media_list_builder_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer state_choose_source_value_media_list_builder_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* state_choose_source_value_media_list_builder_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		StateChooseSourceMediaListBuilder * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = state_choose_source_media_list_builder_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* state_choose_source_value_media_list_builder_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	StateChooseSourceMediaListBuilder ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = state_choose_source_media_list_builder_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* state_choose_source_param_spec_media_list_builder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	StateChooseSourceParamSpecMediaListBuilder* spec;
	g_return_val_if_fail (g_type_is_a (object_type, STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer state_choose_source_value_get_media_list_builder (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER), NULL);
	return value->data[0].v_pointer;
}


static void state_choose_source_value_set_media_list_builder (GValue* value, gpointer v_object) {
	StateChooseSourceMediaListBuilder * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		state_choose_source_media_list_builder_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		state_choose_source_media_list_builder_unref (old);
	}
}


static void state_choose_source_value_take_media_list_builder (GValue* value, gpointer v_object) {
	StateChooseSourceMediaListBuilder * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		state_choose_source_media_list_builder_unref (old);
	}
}


static void state_choose_source_media_list_builder_class_init (StateChooseSourceMediaListBuilderClass * klass) {
	state_choose_source_media_list_builder_parent_class = g_type_class_peek_parent (klass);
	((StateChooseSourceMediaListBuilderClass *) klass)->finalize = state_choose_source_media_list_builder_finalize;
	g_type_class_add_private (klass, sizeof (StateChooseSourceMediaListBuilderPrivate));
}


static void state_choose_source_media_list_builder_instance_init (StateChooseSourceMediaListBuilder * self) {
	self->priv = STATE_CHOOSE_SOURCE_MEDIA_LIST_BUILDER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void state_choose_source_media_list_builder_finalize (StateChooseSourceMediaListBuilder * obj) {
	StateChooseSourceMediaListBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STATE_CHOOSE_SOURCE_TYPE_MEDIA_LIST_BUILDER, StateChooseSourceMediaListBuilder);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->state);
}


static GType state_choose_source_media_list_builder_get_type (void) {
	static volatile gsize state_choose_source_media_list_builder_type_id__volatile = 0;
	if (g_once_init_enter (&state_choose_source_media_list_builder_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { state_choose_source_value_media_list_builder_init, state_choose_source_value_media_list_builder_free_value, state_choose_source_value_media_list_builder_copy_value, state_choose_source_value_media_list_builder_peek_pointer, "p", state_choose_source_value_media_list_builder_collect_value, "p", state_choose_source_value_media_list_builder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (StateChooseSourceMediaListBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) state_choose_source_media_list_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StateChooseSourceMediaListBuilder), 0, (GInstanceInitFunc) state_choose_source_media_list_builder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType state_choose_source_media_list_builder_type_id;
		state_choose_source_media_list_builder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "StateChooseSourceMediaListBuilder", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&state_choose_source_media_list_builder_type_id__volatile, state_choose_source_media_list_builder_type_id);
	}
	return state_choose_source_media_list_builder_type_id__volatile;
}


static gpointer state_choose_source_media_list_builder_ref (gpointer instance) {
	StateChooseSourceMediaListBuilder * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void state_choose_source_media_list_builder_unref (gpointer instance) {
	StateChooseSourceMediaListBuilder * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		STATE_CHOOSE_SOURCE_MEDIA_LIST_BUILDER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void state_choose_source_class_init (StateChooseSourceClass * klass) {
	state_choose_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StateChooseSourcePrivate));
	((StateClass *) klass)->print_selected = (void (*) (State *)) state_choose_source_real_print_selected;
	((StateClass *) klass)->seekback = (void (*) (State *)) state_choose_source_real_seekback;
	((StateClass *) klass)->seekforward = (void (*) (State *)) state_choose_source_real_seekforward;
	((StateClass *) klass)->next = (void (*) (State *)) state_choose_source_real_next;
	((StateClass *) klass)->previous = (void (*) (State *)) state_choose_source_real_previous;
	((StateClass *) klass)->transition = (State* (*) (State *)) state_choose_source_real_transition;
	G_OBJECT_CLASS (klass)->finalize = state_choose_source_finalize;
}


static void state_choose_source_instance_init (StateChooseSource * self) {
	self->priv = STATE_CHOOSE_SOURCE_GET_PRIVATE (self);
	self->priv->current = 0;
}


static void state_choose_source_finalize (GObject * obj) {
	StateChooseSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATE_CHOOSE_SOURCE, StateChooseSource);
	_g_main_loop_unref0 (self->priv->loop);
	_g_object_unref0 (self->priv->sources);
	_state_choose_source_media_list_builder_unref0 (self->priv->media_list_builder);
	G_OBJECT_CLASS (state_choose_source_parent_class)->finalize (obj);
}


GType state_choose_source_get_type (void) {
	static volatile gsize state_choose_source_type_id__volatile = 0;
	if (g_once_init_enter (&state_choose_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StateChooseSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) state_choose_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StateChooseSource), 0, (GInstanceInitFunc) state_choose_source_instance_init, NULL };
		GType state_choose_source_type_id;
		state_choose_source_type_id = g_type_register_static (TYPE_STATE, "StateChooseSource", &g_define_type_info, 0);
		g_once_init_leave (&state_choose_source_type_id__volatile, state_choose_source_type_id);
	}
	return state_choose_source_type_id__volatile;
}



