import * as ESTree from 'estree';
import { TControlFlowCustomNodeFactory } from '../../types/container/custom-nodes/TControlFlowCustomNodeFactory';
import { TControlFlowReplacerFactory } from '../../types/container/node-transformers/TControlFlowReplacerFactory';
import { TControlFlowStorageFactory } from '../../types/container/node-transformers/TControlFlowStorageFactory';
import { IOptions } from '../../interfaces/options/IOptions';
import { IRandomGenerator } from '../../interfaces/utils/IRandomGenerator';
import { IVisitor } from '../../interfaces/node-transformers/IVisitor';
import { NodeTransformationStage } from '../../enums/node-transformers/NodeTransformationStage';
import { AbstractNodeTransformer } from '../AbstractNodeTransformer';
export declare class FunctionControlFlowTransformer extends AbstractNodeTransformer {
    private static readonly controlFlowReplacersMap;
    private static readonly hostNodeSearchMinDepth;
    private static readonly hostNodeSearchMaxDepth;
    private readonly controlFlowData;
    private readonly visitedFunctionNodes;
    private readonly hostNodesWithControlFlowNode;
    private readonly controlFlowReplacerFactory;
    private readonly controlFlowStorageFactory;
    private readonly controlFlowCustomNodeFactory;
    constructor(controlFlowStorageFactory: TControlFlowStorageFactory, controlFlowReplacerFactory: TControlFlowReplacerFactory, controlFlowCustomNodeFactory: TControlFlowCustomNodeFactory, randomGenerator: IRandomGenerator, options: IOptions);
    getVisitor(nodeTransformationStage: NodeTransformationStage): IVisitor | null;
    transformNode(functionNode: ESTree.Function, parentNode: ESTree.Node): ESTree.Function;
    private getControlFlowStorage;
    private getControlFlowStorageNode;
    private getHostNode;
    private isVisitedFunctionNode;
    private transformFunctionBody;
}
