/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.52
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _USBPHY_H
#define _USBPHY_H  1

#include "regs.h"

#ifndef REGS_USBPHY_BASE
#define REGS_USBPHY0_BASE (REGS_BASE + 0x7c000)
#define REGS_USBPHY1_BASE (REGS_BASE + 0x7e000)
#define REGS_USBPHY_BASE(x) ( x == 0 ? REGS_USBPHY0_BASE : x == 1 ? REGS_USBPHY1_BASE : 0xffff0000)
#endif

/*
 * HW_USBPHY_PWD - USB PHY Power-Down Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0       : 10;
        unsigned TXPWDFS     :  1;
        unsigned TXPWDIBIAS  :  1;
        unsigned TXPWDV2I    :  1;
        unsigned RSVD1       :  4;
        unsigned RXPWDENV    :  1;
        unsigned RXPWD1PT1   :  1;
        unsigned RXPWDDIFF   :  1;
        unsigned RXPWDRX     :  1;
        unsigned RSVD2       : 11;
    } B;
} hw_usbphy_pwd_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_PWD register
 */
#define HW_USBPHY_PWD_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x0)
#define HW_USBPHY_PWD_SET_ADDR(x)  (HW_USBPHY_PWD_ADDR(x) + 4)
#define HW_USBPHY_PWD_CLR_ADDR(x)  (HW_USBPHY_PWD_ADDR(x) + 8)
#define HW_USBPHY_PWD_TOG_ADDR(x)  (HW_USBPHY_PWD_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_PWD(x)           (*(volatile hw_usbphy_pwd_t *) HW_USBPHY_PWD_ADDR(x))
#define HW_USBPHY_PWD_RD(x)      (HW_USBPHY_PWD(x).U)
#define HW_USBPHY_PWD_WR(x, v)     (HW_USBPHY_PWD(x).U = (v))
#define HW_USBPHY_PWD_SET(x, v)    ((*(volatile reg32_t *) HW_USBPHY_PWD_SET_ADDR(x)) = (v))
#define HW_USBPHY_PWD_CLR(x, v)    ((*(volatile reg32_t *) HW_USBPHY_PWD_CLR_ADDR(x)) = (v))
#define HW_USBPHY_PWD_TOG(x, v)    ((*(volatile reg32_t *) HW_USBPHY_PWD_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_USBPHY_PWD bitfields
 */
/* --- Register HW_USBPHY_PWD, field RSVD2 */

#define BP_USBPHY_PWD_RSVD2      21
#define BM_USBPHY_PWD_RSVD2      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_PWD_RSVD2(v)   ((((reg32_t) v) << 21) & BM_USBPHY_PWD_RSVD2)
#else
#define BF_USBPHY_PWD_RSVD2(v)   (((v) << 21) & BM_USBPHY_PWD_RSVD2)
#endif
/* --- Register HW_USBPHY_PWD, field RXPWDRX */

#define BP_USBPHY_PWD_RXPWDRX      20
#define BM_USBPHY_PWD_RXPWDRX      0x00100000

#define BF_USBPHY_PWD_RXPWDRX(v)   (((v) << 20) & BM_USBPHY_PWD_RXPWDRX)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_RXPWDRX(n, v)   BFn_CS1(USBPHY_PWD, n, RXPWDRX, v)
#endif

/* --- Register HW_USBPHY_PWD, field RXPWDDIFF */

#define BP_USBPHY_PWD_RXPWDDIFF      19
#define BM_USBPHY_PWD_RXPWDDIFF      0x00080000

#define BF_USBPHY_PWD_RXPWDDIFF(v)   (((v) << 19) & BM_USBPHY_PWD_RXPWDDIFF)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_RXPWDDIFF(n, v)   BFn_CS1(USBPHY_PWD, n, RXPWDDIFF, v)
#endif

/* --- Register HW_USBPHY_PWD, field RXPWD1PT1 */

#define BP_USBPHY_PWD_RXPWD1PT1      18
#define BM_USBPHY_PWD_RXPWD1PT1      0x00040000

#define BF_USBPHY_PWD_RXPWD1PT1(v)   (((v) << 18) & BM_USBPHY_PWD_RXPWD1PT1)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_RXPWD1PT1(n, v)   BFn_CS1(USBPHY_PWD, n, RXPWD1PT1, v)
#endif

/* --- Register HW_USBPHY_PWD, field RXPWDENV */

#define BP_USBPHY_PWD_RXPWDENV      17
#define BM_USBPHY_PWD_RXPWDENV      0x00020000

#define BF_USBPHY_PWD_RXPWDENV(v)   (((v) << 17) & BM_USBPHY_PWD_RXPWDENV)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_RXPWDENV(n, v)   BFn_CS1(USBPHY_PWD, n, RXPWDENV, v)
#endif

/* --- Register HW_USBPHY_PWD, field RSVD1 */

#define BP_USBPHY_PWD_RSVD1      13
#define BM_USBPHY_PWD_RSVD1      0x0001E000

#define BF_USBPHY_PWD_RSVD1(v)   (((v) << 13) & BM_USBPHY_PWD_RSVD1)
/* --- Register HW_USBPHY_PWD, field TXPWDV2I */

#define BP_USBPHY_PWD_TXPWDV2I      12
#define BM_USBPHY_PWD_TXPWDV2I      0x00001000

#define BF_USBPHY_PWD_TXPWDV2I(v)   (((v) << 12) & BM_USBPHY_PWD_TXPWDV2I)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_TXPWDV2I(n, v)   BFn_CS1(USBPHY_PWD, n, TXPWDV2I, v)
#endif

/* --- Register HW_USBPHY_PWD, field TXPWDIBIAS */

#define BP_USBPHY_PWD_TXPWDIBIAS      11
#define BM_USBPHY_PWD_TXPWDIBIAS      0x00000800

#define BF_USBPHY_PWD_TXPWDIBIAS(v)   (((v) << 11) & BM_USBPHY_PWD_TXPWDIBIAS)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_TXPWDIBIAS(n, v)   BFn_CS1(USBPHY_PWD, n, TXPWDIBIAS, v)
#endif

/* --- Register HW_USBPHY_PWD, field TXPWDFS */

#define BP_USBPHY_PWD_TXPWDFS      10
#define BM_USBPHY_PWD_TXPWDFS      0x00000400

#define BF_USBPHY_PWD_TXPWDFS(v)   (((v) << 10) & BM_USBPHY_PWD_TXPWDFS)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_TXPWDFS(n, v)   BFn_CS1(USBPHY_PWD, n, TXPWDFS, v)
#endif

/* --- Register HW_USBPHY_PWD, field RSVD0 */

#define BP_USBPHY_PWD_RSVD0      0
#define BM_USBPHY_PWD_RSVD0      0x000003FF

#define BF_USBPHY_PWD_RSVD0(v)   (((v) << 0) & BM_USBPHY_PWD_RSVD0)


/*
 * HW_USBPHY_TX - USB PHY Transmitter Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned D_CAL                  :  4;
        unsigned RSVD0                  :  4;
        unsigned TXCAL45DN              :  4;
        unsigned RSVD1                  :  1;
        unsigned TXENCAL45DN            :  1;
        unsigned RSVD2                  :  2;
        unsigned TXCAL45DP              :  4;
        unsigned RSVD3                  :  1;
        unsigned TXENCAL45DP            :  1;
        unsigned RSVD4                  :  2;
        unsigned USBPHY_TX_SYNC_MUX     :  1;
        unsigned USBPHY_TX_SYNC_INVERT  :  1;
        unsigned USBPHY_TX_EDGECTRL     :  3;
        unsigned RSVD5                  :  3;
    } B;
} hw_usbphy_tx_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_TX register
 */
#define HW_USBPHY_TX_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x10)
#define HW_USBPHY_TX_SET_ADDR(x)  (HW_USBPHY_TX_ADDR(x) + 4)
#define HW_USBPHY_TX_CLR_ADDR(x)  (HW_USBPHY_TX_ADDR(x) + 8)
#define HW_USBPHY_TX_TOG_ADDR(x)  (HW_USBPHY_TX_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_TX(x)           (*(volatile hw_usbphy_tx_t *) HW_USBPHY_TX_ADDR(x))
#define HW_USBPHY_TX_RD(x)      (HW_USBPHY_TX(x).U)
#define HW_USBPHY_TX_WR(x, v)     (HW_USBPHY_TX(x).U = (v))
#define HW_USBPHY_TX_SET(x, v)    ((*(volatile reg32_t *) HW_USBPHY_TX_SET_ADDR(x)) = (v))
#define HW_USBPHY_TX_CLR(x, v)    ((*(volatile reg32_t *) HW_USBPHY_TX_CLR_ADDR(x)) = (v))
#define HW_USBPHY_TX_TOG(x, v)    ((*(volatile reg32_t *) HW_USBPHY_TX_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_USBPHY_TX bitfields
 */
/* --- Register HW_USBPHY_TX, field RSVD5 */

#define BP_USBPHY_TX_RSVD5      29
#define BM_USBPHY_TX_RSVD5      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_TX_RSVD5(v)   ((((reg32_t) v) << 29) & BM_USBPHY_TX_RSVD5)
#else
#define BF_USBPHY_TX_RSVD5(v)   (((v) << 29) & BM_USBPHY_TX_RSVD5)
#endif
/* --- Register HW_USBPHY_TX, field USBPHY_TX_EDGECTRL */

#define BP_USBPHY_TX_USBPHY_TX_EDGECTRL      26
#define BM_USBPHY_TX_USBPHY_TX_EDGECTRL      0x1C000000

#define BF_USBPHY_TX_USBPHY_TX_EDGECTRL(v)   (((v) << 26) & BM_USBPHY_TX_USBPHY_TX_EDGECTRL)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_USBPHY_TX_EDGECTRL(n, v)   BFn_CS1(USBPHY_TX, n, USBPHY_TX_EDGECTRL, v)
#endif

/* --- Register HW_USBPHY_TX, field USBPHY_TX_SYNC_INVERT */

#define BP_USBPHY_TX_USBPHY_TX_SYNC_INVERT      25
#define BM_USBPHY_TX_USBPHY_TX_SYNC_INVERT      0x02000000

#define BF_USBPHY_TX_USBPHY_TX_SYNC_INVERT(v)   (((v) << 25) & BM_USBPHY_TX_USBPHY_TX_SYNC_INVERT)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_USBPHY_TX_SYNC_INVERT(n, v)   BFn_CS1(USBPHY_TX, n, USBPHY_TX_SYNC_INVERT, v)
#endif

/* --- Register HW_USBPHY_TX, field USBPHY_TX_SYNC_MUX */

#define BP_USBPHY_TX_USBPHY_TX_SYNC_MUX      24
#define BM_USBPHY_TX_USBPHY_TX_SYNC_MUX      0x01000000

#define BF_USBPHY_TX_USBPHY_TX_SYNC_MUX(v)   (((v) << 24) & BM_USBPHY_TX_USBPHY_TX_SYNC_MUX)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_USBPHY_TX_SYNC_MUX(n, v)   BFn_CS1(USBPHY_TX, n, USBPHY_TX_SYNC_MUX, v)
#endif

/* --- Register HW_USBPHY_TX, field RSVD4 */

#define BP_USBPHY_TX_RSVD4      22
#define BM_USBPHY_TX_RSVD4      0x00C00000

#define BF_USBPHY_TX_RSVD4(v)   (((v) << 22) & BM_USBPHY_TX_RSVD4)
/* --- Register HW_USBPHY_TX, field TXENCAL45DP */

#define BP_USBPHY_TX_TXENCAL45DP      21
#define BM_USBPHY_TX_TXENCAL45DP      0x00200000

#define BF_USBPHY_TX_TXENCAL45DP(v)   (((v) << 21) & BM_USBPHY_TX_TXENCAL45DP)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_TXENCAL45DP(n, v)   BFn_CS1(USBPHY_TX, n, TXENCAL45DP, v)
#endif

/* --- Register HW_USBPHY_TX, field RSVD3 */

#define BP_USBPHY_TX_RSVD3      20
#define BM_USBPHY_TX_RSVD3      0x00100000

#define BF_USBPHY_TX_RSVD3(v)   (((v) << 20) & BM_USBPHY_TX_RSVD3)
/* --- Register HW_USBPHY_TX, field TXCAL45DP */

#define BP_USBPHY_TX_TXCAL45DP      16
#define BM_USBPHY_TX_TXCAL45DP      0x000F0000

#define BF_USBPHY_TX_TXCAL45DP(v)   (((v) << 16) & BM_USBPHY_TX_TXCAL45DP)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_TXCAL45DP(n, v)   BFn_CS1(USBPHY_TX, n, TXCAL45DP, v)
#endif

/* --- Register HW_USBPHY_TX, field RSVD2 */

#define BP_USBPHY_TX_RSVD2      14
#define BM_USBPHY_TX_RSVD2      0x0000C000

#define BF_USBPHY_TX_RSVD2(v)   (((v) << 14) & BM_USBPHY_TX_RSVD2)
/* --- Register HW_USBPHY_TX, field TXENCAL45DN */

#define BP_USBPHY_TX_TXENCAL45DN      13
#define BM_USBPHY_TX_TXENCAL45DN      0x00002000

#define BF_USBPHY_TX_TXENCAL45DN(v)   (((v) << 13) & BM_USBPHY_TX_TXENCAL45DN)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_TXENCAL45DN(n, v)   BFn_CS1(USBPHY_TX, n, TXENCAL45DN, v)
#endif

/* --- Register HW_USBPHY_TX, field RSVD1 */

#define BP_USBPHY_TX_RSVD1      12
#define BM_USBPHY_TX_RSVD1      0x00001000

#define BF_USBPHY_TX_RSVD1(v)   (((v) << 12) & BM_USBPHY_TX_RSVD1)
/* --- Register HW_USBPHY_TX, field TXCAL45DN */

#define BP_USBPHY_TX_TXCAL45DN      8
#define BM_USBPHY_TX_TXCAL45DN      0x00000F00

#define BF_USBPHY_TX_TXCAL45DN(v)   (((v) << 8) & BM_USBPHY_TX_TXCAL45DN)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_TXCAL45DN(n, v)   BFn_CS1(USBPHY_TX, n, TXCAL45DN, v)
#endif

/* --- Register HW_USBPHY_TX, field RSVD0 */

#define BP_USBPHY_TX_RSVD0      4
#define BM_USBPHY_TX_RSVD0      0x000000F0

#define BF_USBPHY_TX_RSVD0(v)   (((v) << 4) & BM_USBPHY_TX_RSVD0)
/* --- Register HW_USBPHY_TX, field D_CAL */

#define BP_USBPHY_TX_D_CAL      0
#define BM_USBPHY_TX_D_CAL      0x0000000F

#define BF_USBPHY_TX_D_CAL(v)   (((v) << 0) & BM_USBPHY_TX_D_CAL)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_D_CAL(n, v)   BFn_CS1(USBPHY_TX, n, D_CAL, v)
#endif



/*
 * HW_USBPHY_RX - USB PHY Receiver Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENVADJ     :  3;
        unsigned RSVD0      :  1;
        unsigned DISCONADJ  :  3;
        unsigned RSVD1      : 15;
        unsigned RXDBYPASS  :  1;
        unsigned RSVD2      :  9;
    } B;
} hw_usbphy_rx_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_RX register
 */
#define HW_USBPHY_RX_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x20)
#define HW_USBPHY_RX_SET_ADDR(x)  (HW_USBPHY_RX_ADDR(x) + 4)
#define HW_USBPHY_RX_CLR_ADDR(x)  (HW_USBPHY_RX_ADDR(x) + 8)
#define HW_USBPHY_RX_TOG_ADDR(x)  (HW_USBPHY_RX_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_RX(x)           (*(volatile hw_usbphy_rx_t *) HW_USBPHY_RX_ADDR(x))
#define HW_USBPHY_RX_RD(x)      (HW_USBPHY_RX(x).U)
#define HW_USBPHY_RX_WR(x, v)     (HW_USBPHY_RX(x).U = (v))
#define HW_USBPHY_RX_SET(x, v)    ((*(volatile reg32_t *) HW_USBPHY_RX_SET_ADDR(x)) = (v))
#define HW_USBPHY_RX_CLR(x, v)    ((*(volatile reg32_t *) HW_USBPHY_RX_CLR_ADDR(x)) = (v))
#define HW_USBPHY_RX_TOG(x, v)    ((*(volatile reg32_t *) HW_USBPHY_RX_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_USBPHY_RX bitfields
 */
/* --- Register HW_USBPHY_RX, field RSVD2 */

#define BP_USBPHY_RX_RSVD2      23
#define BM_USBPHY_RX_RSVD2      0xFF800000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_RX_RSVD2(v)   ((((reg32_t) v) << 23) & BM_USBPHY_RX_RSVD2)
#else
#define BF_USBPHY_RX_RSVD2(v)   (((v) << 23) & BM_USBPHY_RX_RSVD2)
#endif
/* --- Register HW_USBPHY_RX, field RXDBYPASS */

#define BP_USBPHY_RX_RXDBYPASS      22
#define BM_USBPHY_RX_RXDBYPASS      0x00400000

#define BF_USBPHY_RX_RXDBYPASS(v)   (((v) << 22) & BM_USBPHY_RX_RXDBYPASS)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_RX_RXDBYPASS(n, v)   BFn_CS1(USBPHY_RX, n, RXDBYPASS, v)
#endif

/* --- Register HW_USBPHY_RX, field RSVD1 */

#define BP_USBPHY_RX_RSVD1      7
#define BM_USBPHY_RX_RSVD1      0x003FFF80

#define BF_USBPHY_RX_RSVD1(v)   (((v) << 7) & BM_USBPHY_RX_RSVD1)
/* --- Register HW_USBPHY_RX, field DISCONADJ */

#define BP_USBPHY_RX_DISCONADJ      4
#define BM_USBPHY_RX_DISCONADJ      0x00000070

#define BF_USBPHY_RX_DISCONADJ(v)   (((v) << 4) & BM_USBPHY_RX_DISCONADJ)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_RX_DISCONADJ(n, v)   BFn_CS1(USBPHY_RX, n, DISCONADJ, v)
#endif

/* --- Register HW_USBPHY_RX, field RSVD0 */

#define BP_USBPHY_RX_RSVD0      3
#define BM_USBPHY_RX_RSVD0      0x00000008

#define BF_USBPHY_RX_RSVD0(v)   (((v) << 3) & BM_USBPHY_RX_RSVD0)
/* --- Register HW_USBPHY_RX, field ENVADJ */

#define BP_USBPHY_RX_ENVADJ      0
#define BM_USBPHY_RX_ENVADJ      0x00000007

#define BF_USBPHY_RX_ENVADJ(v)   (((v) << 0) & BM_USBPHY_RX_ENVADJ)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_RX_ENVADJ(n, v)   BFn_CS1(USBPHY_RX, n, ENVADJ, v)
#endif



/*
 * HW_USBPHY_CTRL - USB PHY General Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0                 :  1;
        unsigned ENHOSTDISCONDETECT    :  1;
        unsigned ENIRQHOSTDISCON       :  1;
        unsigned HOSTDISCONDETECT_IRQ  :  1;
        unsigned ENDEVPLUGINDETECT     :  1;
        unsigned DEVPLUGIN_POLARITY    :  1;
        unsigned RSVD1                 :  1;
        unsigned ENOTGIDDETECT         :  1;
        unsigned RESUMEIRQSTICKY       :  1;
        unsigned ENIRQRESUMEDETECT     :  1;
        unsigned RESUME_IRQ            :  1;
        unsigned ENIRQDEVPLUGIN        :  1;
        unsigned DEVPLUGIN_IRQ         :  1;
        unsigned DATA_ON_LRADC         :  1;
        unsigned ENUTMILEVEL2          :  1;
        unsigned ENUTMILEVEL3          :  1;
        unsigned ENIRQWAKEUP           :  1;
        unsigned WAKEUP_IRQ            :  1;
        unsigned ENAUTO_PWRON_PLL      :  1;
        unsigned ENAUTOCLR_CLKGATE     :  1;
        unsigned ENAUTOCLR_PHY_PWD     :  1;
        unsigned ENDPDMCHG_WKUP        :  1;
        unsigned ENIDCHG_WKUP          :  1;
        unsigned ENVBUSCHG_WKUP        :  1;
        unsigned FSDLL_RST_EN          :  1;
        unsigned ENAUTOCLR_USBCLKGATE  :  1;
        unsigned ENAUTOSET_USBCLKS     :  1;
        unsigned RSVD3                 :  1;
        unsigned HOST_FORCE_LS_SE0     :  1;
        unsigned UTMI_SUSPENDM         :  1;
        unsigned CLKGATE               :  1;
        unsigned SFTRST                :  1;
    } B;
} hw_usbphy_ctrl_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_CTRL register
 */
#define HW_USBPHY_CTRL_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x30)
#define HW_USBPHY_CTRL_SET_ADDR(x)  (HW_USBPHY_CTRL_ADDR(x) + 4)
#define HW_USBPHY_CTRL_CLR_ADDR(x)  (HW_USBPHY_CTRL_ADDR(x) + 8)
#define HW_USBPHY_CTRL_TOG_ADDR(x)  (HW_USBPHY_CTRL_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_CTRL(x)           (*(volatile hw_usbphy_ctrl_t *) HW_USBPHY_CTRL_ADDR(x))
#define HW_USBPHY_CTRL_RD(x)      (HW_USBPHY_CTRL(x).U)
#define HW_USBPHY_CTRL_WR(x, v)     (HW_USBPHY_CTRL(x).U = (v))
#define HW_USBPHY_CTRL_SET(x, v)    ((*(volatile reg32_t *) HW_USBPHY_CTRL_SET_ADDR(x)) = (v))
#define HW_USBPHY_CTRL_CLR(x, v)    ((*(volatile reg32_t *) HW_USBPHY_CTRL_CLR_ADDR(x)) = (v))
#define HW_USBPHY_CTRL_TOG(x, v)    ((*(volatile reg32_t *) HW_USBPHY_CTRL_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_USBPHY_CTRL bitfields
 */
/* --- Register HW_USBPHY_CTRL, field SFTRST */

#define BP_USBPHY_CTRL_SFTRST      31
#define BM_USBPHY_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_USBPHY_CTRL_SFTRST)
#else
#define BF_USBPHY_CTRL_SFTRST(v)   (((v) << 31) & BM_USBPHY_CTRL_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_SFTRST(n, v)   BFn_CS1(USBPHY_CTRL, n, SFTRST, v)
#endif

/* --- Register HW_USBPHY_CTRL, field CLKGATE */

#define BP_USBPHY_CTRL_CLKGATE      30
#define BM_USBPHY_CTRL_CLKGATE      0x40000000

#define BF_USBPHY_CTRL_CLKGATE(v)   (((v) << 30) & BM_USBPHY_CTRL_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_CLKGATE(n, v)   BFn_CS1(USBPHY_CTRL, n, CLKGATE, v)
#endif

/* --- Register HW_USBPHY_CTRL, field UTMI_SUSPENDM */

#define BP_USBPHY_CTRL_UTMI_SUSPENDM      29
#define BM_USBPHY_CTRL_UTMI_SUSPENDM      0x20000000

#define BF_USBPHY_CTRL_UTMI_SUSPENDM(v)   (((v) << 29) & BM_USBPHY_CTRL_UTMI_SUSPENDM)
/* --- Register HW_USBPHY_CTRL, field HOST_FORCE_LS_SE0 */

#define BP_USBPHY_CTRL_HOST_FORCE_LS_SE0      28
#define BM_USBPHY_CTRL_HOST_FORCE_LS_SE0      0x10000000

#define BF_USBPHY_CTRL_HOST_FORCE_LS_SE0(v)   (((v) << 28) & BM_USBPHY_CTRL_HOST_FORCE_LS_SE0)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_HOST_FORCE_LS_SE0(n, v)   BFn_CS1(USBPHY_CTRL, n, HOST_FORCE_LS_SE0, v)
#endif

/* --- Register HW_USBPHY_CTRL, field RSVD3 */

#define BP_USBPHY_CTRL_RSVD3      27
#define BM_USBPHY_CTRL_RSVD3      0x08000000

#define BF_USBPHY_CTRL_RSVD3(v)   (((v) << 27) & BM_USBPHY_CTRL_RSVD3)
/* --- Register HW_USBPHY_CTRL, field ENAUTOSET_USBCLKS */

#define BP_USBPHY_CTRL_ENAUTOSET_USBCLKS      26
#define BM_USBPHY_CTRL_ENAUTOSET_USBCLKS      0x04000000

#define BF_USBPHY_CTRL_ENAUTOSET_USBCLKS(v)   (((v) << 26) & BM_USBPHY_CTRL_ENAUTOSET_USBCLKS)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENAUTOSET_USBCLKS(n, v)   BFn_CS1(USBPHY_CTRL, n, ENAUTOSET_USBCLKS, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENAUTOCLR_USBCLKGATE */

#define BP_USBPHY_CTRL_ENAUTOCLR_USBCLKGATE      25
#define BM_USBPHY_CTRL_ENAUTOCLR_USBCLKGATE      0x02000000

#define BF_USBPHY_CTRL_ENAUTOCLR_USBCLKGATE(v)   (((v) << 25) & BM_USBPHY_CTRL_ENAUTOCLR_USBCLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENAUTOCLR_USBCLKGATE(n, v)   BFn_CS1(USBPHY_CTRL, n, ENAUTOCLR_USBCLKGATE, v)
#endif

/* --- Register HW_USBPHY_CTRL, field FSDLL_RST_EN */

#define BP_USBPHY_CTRL_FSDLL_RST_EN      24
#define BM_USBPHY_CTRL_FSDLL_RST_EN      0x01000000

#define BF_USBPHY_CTRL_FSDLL_RST_EN(v)   (((v) << 24) & BM_USBPHY_CTRL_FSDLL_RST_EN)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_FSDLL_RST_EN(n, v)   BFn_CS1(USBPHY_CTRL, n, FSDLL_RST_EN, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENVBUSCHG_WKUP */

#define BP_USBPHY_CTRL_ENVBUSCHG_WKUP      23
#define BM_USBPHY_CTRL_ENVBUSCHG_WKUP      0x00800000

#define BF_USBPHY_CTRL_ENVBUSCHG_WKUP(v)   (((v) << 23) & BM_USBPHY_CTRL_ENVBUSCHG_WKUP)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENVBUSCHG_WKUP(n, v)   BFn_CS1(USBPHY_CTRL, n, ENVBUSCHG_WKUP, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENIDCHG_WKUP */

#define BP_USBPHY_CTRL_ENIDCHG_WKUP      22
#define BM_USBPHY_CTRL_ENIDCHG_WKUP      0x00400000

#define BF_USBPHY_CTRL_ENIDCHG_WKUP(v)   (((v) << 22) & BM_USBPHY_CTRL_ENIDCHG_WKUP)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENIDCHG_WKUP(n, v)   BFn_CS1(USBPHY_CTRL, n, ENIDCHG_WKUP, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENDPDMCHG_WKUP */

#define BP_USBPHY_CTRL_ENDPDMCHG_WKUP      21
#define BM_USBPHY_CTRL_ENDPDMCHG_WKUP      0x00200000

#define BF_USBPHY_CTRL_ENDPDMCHG_WKUP(v)   (((v) << 21) & BM_USBPHY_CTRL_ENDPDMCHG_WKUP)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENDPDMCHG_WKUP(n, v)   BFn_CS1(USBPHY_CTRL, n, ENDPDMCHG_WKUP, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENAUTOCLR_PHY_PWD */

#define BP_USBPHY_CTRL_ENAUTOCLR_PHY_PWD      20
#define BM_USBPHY_CTRL_ENAUTOCLR_PHY_PWD      0x00100000

#define BF_USBPHY_CTRL_ENAUTOCLR_PHY_PWD(v)   (((v) << 20) & BM_USBPHY_CTRL_ENAUTOCLR_PHY_PWD)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENAUTOCLR_PHY_PWD(n, v)   BFn_CS1(USBPHY_CTRL, n, ENAUTOCLR_PHY_PWD, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENAUTOCLR_CLKGATE */

#define BP_USBPHY_CTRL_ENAUTOCLR_CLKGATE      19
#define BM_USBPHY_CTRL_ENAUTOCLR_CLKGATE      0x00080000

#define BF_USBPHY_CTRL_ENAUTOCLR_CLKGATE(v)   (((v) << 19) & BM_USBPHY_CTRL_ENAUTOCLR_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENAUTOCLR_CLKGATE(n, v)   BFn_CS1(USBPHY_CTRL, n, ENAUTOCLR_CLKGATE, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENAUTO_PWRON_PLL */

#define BP_USBPHY_CTRL_ENAUTO_PWRON_PLL      18
#define BM_USBPHY_CTRL_ENAUTO_PWRON_PLL      0x00040000

#define BF_USBPHY_CTRL_ENAUTO_PWRON_PLL(v)   (((v) << 18) & BM_USBPHY_CTRL_ENAUTO_PWRON_PLL)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENAUTO_PWRON_PLL(n, v)   BFn_CS1(USBPHY_CTRL, n, ENAUTO_PWRON_PLL, v)
#endif

/* --- Register HW_USBPHY_CTRL, field WAKEUP_IRQ */

#define BP_USBPHY_CTRL_WAKEUP_IRQ      17
#define BM_USBPHY_CTRL_WAKEUP_IRQ      0x00020000

#define BF_USBPHY_CTRL_WAKEUP_IRQ(v)   (((v) << 17) & BM_USBPHY_CTRL_WAKEUP_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_WAKEUP_IRQ(n, v)   BFn_CS1(USBPHY_CTRL, n, WAKEUP_IRQ, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENIRQWAKEUP */

#define BP_USBPHY_CTRL_ENIRQWAKEUP      16
#define BM_USBPHY_CTRL_ENIRQWAKEUP      0x00010000

#define BF_USBPHY_CTRL_ENIRQWAKEUP(v)   (((v) << 16) & BM_USBPHY_CTRL_ENIRQWAKEUP)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENIRQWAKEUP(n, v)   BFn_CS1(USBPHY_CTRL, n, ENIRQWAKEUP, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENUTMILEVEL3 */

#define BP_USBPHY_CTRL_ENUTMILEVEL3      15
#define BM_USBPHY_CTRL_ENUTMILEVEL3      0x00008000

#define BF_USBPHY_CTRL_ENUTMILEVEL3(v)   (((v) << 15) & BM_USBPHY_CTRL_ENUTMILEVEL3)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENUTMILEVEL3(n, v)   BFn_CS1(USBPHY_CTRL, n, ENUTMILEVEL3, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENUTMILEVEL2 */

#define BP_USBPHY_CTRL_ENUTMILEVEL2      14
#define BM_USBPHY_CTRL_ENUTMILEVEL2      0x00004000

#define BF_USBPHY_CTRL_ENUTMILEVEL2(v)   (((v) << 14) & BM_USBPHY_CTRL_ENUTMILEVEL2)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENUTMILEVEL2(n, v)   BFn_CS1(USBPHY_CTRL, n, ENUTMILEVEL2, v)
#endif

/* --- Register HW_USBPHY_CTRL, field DATA_ON_LRADC */

#define BP_USBPHY_CTRL_DATA_ON_LRADC      13
#define BM_USBPHY_CTRL_DATA_ON_LRADC      0x00002000

#define BF_USBPHY_CTRL_DATA_ON_LRADC(v)   (((v) << 13) & BM_USBPHY_CTRL_DATA_ON_LRADC)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_DATA_ON_LRADC(n, v)   BFn_CS1(USBPHY_CTRL, n, DATA_ON_LRADC, v)
#endif

/* --- Register HW_USBPHY_CTRL, field DEVPLUGIN_IRQ */

#define BP_USBPHY_CTRL_DEVPLUGIN_IRQ      12
#define BM_USBPHY_CTRL_DEVPLUGIN_IRQ      0x00001000

#define BF_USBPHY_CTRL_DEVPLUGIN_IRQ(v)   (((v) << 12) & BM_USBPHY_CTRL_DEVPLUGIN_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_DEVPLUGIN_IRQ(n, v)   BFn_CS1(USBPHY_CTRL, n, DEVPLUGIN_IRQ, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENIRQDEVPLUGIN */

#define BP_USBPHY_CTRL_ENIRQDEVPLUGIN      11
#define BM_USBPHY_CTRL_ENIRQDEVPLUGIN      0x00000800

#define BF_USBPHY_CTRL_ENIRQDEVPLUGIN(v)   (((v) << 11) & BM_USBPHY_CTRL_ENIRQDEVPLUGIN)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENIRQDEVPLUGIN(n, v)   BFn_CS1(USBPHY_CTRL, n, ENIRQDEVPLUGIN, v)
#endif

/* --- Register HW_USBPHY_CTRL, field RESUME_IRQ */

#define BP_USBPHY_CTRL_RESUME_IRQ      10
#define BM_USBPHY_CTRL_RESUME_IRQ      0x00000400

#define BF_USBPHY_CTRL_RESUME_IRQ(v)   (((v) << 10) & BM_USBPHY_CTRL_RESUME_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_RESUME_IRQ(n, v)   BFn_CS1(USBPHY_CTRL, n, RESUME_IRQ, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENIRQRESUMEDETECT */

#define BP_USBPHY_CTRL_ENIRQRESUMEDETECT      9
#define BM_USBPHY_CTRL_ENIRQRESUMEDETECT      0x00000200

#define BF_USBPHY_CTRL_ENIRQRESUMEDETECT(v)   (((v) << 9) & BM_USBPHY_CTRL_ENIRQRESUMEDETECT)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENIRQRESUMEDETECT(n, v)   BFn_CS1(USBPHY_CTRL, n, ENIRQRESUMEDETECT, v)
#endif

/* --- Register HW_USBPHY_CTRL, field RESUMEIRQSTICKY */

#define BP_USBPHY_CTRL_RESUMEIRQSTICKY      8
#define BM_USBPHY_CTRL_RESUMEIRQSTICKY      0x00000100

#define BF_USBPHY_CTRL_RESUMEIRQSTICKY(v)   (((v) << 8) & BM_USBPHY_CTRL_RESUMEIRQSTICKY)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_RESUMEIRQSTICKY(n, v)   BFn_CS1(USBPHY_CTRL, n, RESUMEIRQSTICKY, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENOTGIDDETECT */

#define BP_USBPHY_CTRL_ENOTGIDDETECT      7
#define BM_USBPHY_CTRL_ENOTGIDDETECT      0x00000080

#define BF_USBPHY_CTRL_ENOTGIDDETECT(v)   (((v) << 7) & BM_USBPHY_CTRL_ENOTGIDDETECT)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENOTGIDDETECT(n, v)   BFn_CS1(USBPHY_CTRL, n, ENOTGIDDETECT, v)
#endif

/* --- Register HW_USBPHY_CTRL, field RSVD1 */

#define BP_USBPHY_CTRL_RSVD1      6
#define BM_USBPHY_CTRL_RSVD1      0x00000040

#define BF_USBPHY_CTRL_RSVD1(v)   (((v) << 6) & BM_USBPHY_CTRL_RSVD1)
/* --- Register HW_USBPHY_CTRL, field DEVPLUGIN_POLARITY */

#define BP_USBPHY_CTRL_DEVPLUGIN_POLARITY      5
#define BM_USBPHY_CTRL_DEVPLUGIN_POLARITY      0x00000020

#define BF_USBPHY_CTRL_DEVPLUGIN_POLARITY(v)   (((v) << 5) & BM_USBPHY_CTRL_DEVPLUGIN_POLARITY)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_DEVPLUGIN_POLARITY(n, v)   BFn_CS1(USBPHY_CTRL, n, DEVPLUGIN_POLARITY, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENDEVPLUGINDETECT */

#define BP_USBPHY_CTRL_ENDEVPLUGINDETECT      4
#define BM_USBPHY_CTRL_ENDEVPLUGINDETECT      0x00000010

#define BF_USBPHY_CTRL_ENDEVPLUGINDETECT(v)   (((v) << 4) & BM_USBPHY_CTRL_ENDEVPLUGINDETECT)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENDEVPLUGINDETECT(n, v)   BFn_CS1(USBPHY_CTRL, n, ENDEVPLUGINDETECT, v)
#endif

/* --- Register HW_USBPHY_CTRL, field HOSTDISCONDETECT_IRQ */

#define BP_USBPHY_CTRL_HOSTDISCONDETECT_IRQ      3
#define BM_USBPHY_CTRL_HOSTDISCONDETECT_IRQ      0x00000008

#define BF_USBPHY_CTRL_HOSTDISCONDETECT_IRQ(v)   (((v) << 3) & BM_USBPHY_CTRL_HOSTDISCONDETECT_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_HOSTDISCONDETECT_IRQ(n, v)   BFn_CS1(USBPHY_CTRL, n, HOSTDISCONDETECT_IRQ, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENIRQHOSTDISCON */

#define BP_USBPHY_CTRL_ENIRQHOSTDISCON      2
#define BM_USBPHY_CTRL_ENIRQHOSTDISCON      0x00000004

#define BF_USBPHY_CTRL_ENIRQHOSTDISCON(v)   (((v) << 2) & BM_USBPHY_CTRL_ENIRQHOSTDISCON)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENIRQHOSTDISCON(n, v)   BFn_CS1(USBPHY_CTRL, n, ENIRQHOSTDISCON, v)
#endif

/* --- Register HW_USBPHY_CTRL, field ENHOSTDISCONDETECT */

#define BP_USBPHY_CTRL_ENHOSTDISCONDETECT      1
#define BM_USBPHY_CTRL_ENHOSTDISCONDETECT      0x00000002

#define BF_USBPHY_CTRL_ENHOSTDISCONDETECT(v)   (((v) << 1) & BM_USBPHY_CTRL_ENHOSTDISCONDETECT)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENHOSTDISCONDETECT(n, v)   BFn_CS1(USBPHY_CTRL, n, ENHOSTDISCONDETECT, v)
#endif

/* --- Register HW_USBPHY_CTRL, field RSVD0 */

#define BP_USBPHY_CTRL_RSVD0      0
#define BM_USBPHY_CTRL_RSVD0      0x00000001

#define BF_USBPHY_CTRL_RSVD0(v)   (((v) << 0) & BM_USBPHY_CTRL_RSVD0)


/*
 * HW_USBPHY_STATUS - USB PHY Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0                    :  3;
        unsigned HOSTDISCONDETECT_STATUS  :  1;
        unsigned RSVD1                    :  2;
        unsigned DEVPLUGIN_STATUS         :  1;
        unsigned RSVD2                    :  1;
        unsigned OTGID_STATUS             :  1;
        unsigned RSVD3                    :  1;
        unsigned RESUME_STATUS            :  1;
        unsigned RSVD4                    : 21;
    } B;
} hw_usbphy_status_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_STATUS register
 */
#define HW_USBPHY_STATUS_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_STATUS(x)           (*(volatile hw_usbphy_status_t *) HW_USBPHY_STATUS_ADDR(x))
#define HW_USBPHY_STATUS_RD(x)      (HW_USBPHY_STATUS(x).U)
#define HW_USBPHY_STATUS_WR(x, v)     (HW_USBPHY_STATUS(x).U = (v))
#define HW_USBPHY_STATUS_SET(x, v)    (HW_USBPHY_STATUS_WR(x, HW_USBPHY_STATUS_RD(x) |  (v)))
#define HW_USBPHY_STATUS_CLR(x, v)    (HW_USBPHY_STATUS_WR(x, HW_USBPHY_STATUS_RD(x) & ~(v)))
#define HW_USBPHY_STATUS_TOG(x, v)    (HW_USBPHY_STATUS_WR(x, HW_USBPHY_STATUS_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_USBPHY_STATUS bitfields
 */
/* --- Register HW_USBPHY_STATUS, field RSVD4 */

#define BP_USBPHY_STATUS_RSVD4      11
#define BM_USBPHY_STATUS_RSVD4      0xFFFFF800

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_STATUS_RSVD4(v)   ((((reg32_t) v) << 11) & BM_USBPHY_STATUS_RSVD4)
#else
#define BF_USBPHY_STATUS_RSVD4(v)   (((v) << 11) & BM_USBPHY_STATUS_RSVD4)
#endif
/* --- Register HW_USBPHY_STATUS, field RESUME_STATUS */

#define BP_USBPHY_STATUS_RESUME_STATUS      10
#define BM_USBPHY_STATUS_RESUME_STATUS      0x00000400

#define BF_USBPHY_STATUS_RESUME_STATUS(v)   (((v) << 10) & BM_USBPHY_STATUS_RESUME_STATUS)
/* --- Register HW_USBPHY_STATUS, field RSVD3 */

#define BP_USBPHY_STATUS_RSVD3      9
#define BM_USBPHY_STATUS_RSVD3      0x00000200

#define BF_USBPHY_STATUS_RSVD3(v)   (((v) << 9) & BM_USBPHY_STATUS_RSVD3)
/* --- Register HW_USBPHY_STATUS, field OTGID_STATUS */

#define BP_USBPHY_STATUS_OTGID_STATUS      8
#define BM_USBPHY_STATUS_OTGID_STATUS      0x00000100

#define BF_USBPHY_STATUS_OTGID_STATUS(v)   (((v) << 8) & BM_USBPHY_STATUS_OTGID_STATUS)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_STATUS_OTGID_STATUS(n, v)   BFn_CS1(USBPHY_STATUS, n, OTGID_STATUS, v)
#endif

/* --- Register HW_USBPHY_STATUS, field RSVD2 */

#define BP_USBPHY_STATUS_RSVD2      7
#define BM_USBPHY_STATUS_RSVD2      0x00000080

#define BF_USBPHY_STATUS_RSVD2(v)   (((v) << 7) & BM_USBPHY_STATUS_RSVD2)
/* --- Register HW_USBPHY_STATUS, field DEVPLUGIN_STATUS */

#define BP_USBPHY_STATUS_DEVPLUGIN_STATUS      6
#define BM_USBPHY_STATUS_DEVPLUGIN_STATUS      0x00000040

#define BF_USBPHY_STATUS_DEVPLUGIN_STATUS(v)   (((v) << 6) & BM_USBPHY_STATUS_DEVPLUGIN_STATUS)
/* --- Register HW_USBPHY_STATUS, field RSVD1 */

#define BP_USBPHY_STATUS_RSVD1      4
#define BM_USBPHY_STATUS_RSVD1      0x00000030

#define BF_USBPHY_STATUS_RSVD1(v)   (((v) << 4) & BM_USBPHY_STATUS_RSVD1)
/* --- Register HW_USBPHY_STATUS, field HOSTDISCONDETECT_STATUS */

#define BP_USBPHY_STATUS_HOSTDISCONDETECT_STATUS      3
#define BM_USBPHY_STATUS_HOSTDISCONDETECT_STATUS      0x00000008

#define BF_USBPHY_STATUS_HOSTDISCONDETECT_STATUS(v)   (((v) << 3) & BM_USBPHY_STATUS_HOSTDISCONDETECT_STATUS)
/* --- Register HW_USBPHY_STATUS, field RSVD0 */

#define BP_USBPHY_STATUS_RSVD0      0
#define BM_USBPHY_STATUS_RSVD0      0x00000007

#define BF_USBPHY_STATUS_RSVD0(v)   (((v) << 0) & BM_USBPHY_STATUS_RSVD0)


/*
 * HW_USBPHY_DEBUG - USB PHY Debug Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OTGIDPIOLOCK          :  1;
        unsigned DEBUG_INTERFACE_HOLD  :  1;
        unsigned HSTPULLDOWN           :  2;
        unsigned ENHSTPULLDOWN         :  2;
        unsigned RSVD0                 :  2;
        unsigned TX2RXCOUNT            :  4;
        unsigned ENTX2RXCOUNT          :  1;
        unsigned RSVD1                 :  3;
        unsigned SQUELCHRESETCOUNT     :  5;
        unsigned RSVD2                 :  3;
        unsigned ENSQUELCHRESET        :  1;
        unsigned SQUELCHRESETLENGTH    :  4;
        unsigned HOST_RESUME_DEBUG     :  1;
        unsigned CLKGATE               :  1;
        unsigned RSVD3                 :  1;
    } B;
} hw_usbphy_debug_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_DEBUG register
 */
#define HW_USBPHY_DEBUG_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x50)
#define HW_USBPHY_DEBUG_SET_ADDR(x)  (HW_USBPHY_DEBUG_ADDR(x) + 4)
#define HW_USBPHY_DEBUG_CLR_ADDR(x)  (HW_USBPHY_DEBUG_ADDR(x) + 8)
#define HW_USBPHY_DEBUG_TOG_ADDR(x)  (HW_USBPHY_DEBUG_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_DEBUG(x)           (*(volatile hw_usbphy_debug_t *) HW_USBPHY_DEBUG_ADDR(x))
#define HW_USBPHY_DEBUG_RD(x)      (HW_USBPHY_DEBUG(x).U)
#define HW_USBPHY_DEBUG_WR(x, v)     (HW_USBPHY_DEBUG(x).U = (v))
#define HW_USBPHY_DEBUG_SET(x, v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG_SET_ADDR(x)) = (v))
#define HW_USBPHY_DEBUG_CLR(x, v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG_CLR_ADDR(x)) = (v))
#define HW_USBPHY_DEBUG_TOG(x, v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_USBPHY_DEBUG bitfields
 */
/* --- Register HW_USBPHY_DEBUG, field RSVD3 */

#define BP_USBPHY_DEBUG_RSVD3      31
#define BM_USBPHY_DEBUG_RSVD3      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_DEBUG_RSVD3(v)   ((((reg32_t) v) << 31) & BM_USBPHY_DEBUG_RSVD3)
#else
#define BF_USBPHY_DEBUG_RSVD3(v)   (((v) << 31) & BM_USBPHY_DEBUG_RSVD3)
#endif
/* --- Register HW_USBPHY_DEBUG, field CLKGATE */

#define BP_USBPHY_DEBUG_CLKGATE      30
#define BM_USBPHY_DEBUG_CLKGATE      0x40000000

#define BF_USBPHY_DEBUG_CLKGATE(v)   (((v) << 30) & BM_USBPHY_DEBUG_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_CLKGATE(n, v)   BFn_CS1(USBPHY_DEBUG, n, CLKGATE, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field HOST_RESUME_DEBUG */

#define BP_USBPHY_DEBUG_HOST_RESUME_DEBUG      29
#define BM_USBPHY_DEBUG_HOST_RESUME_DEBUG      0x20000000

#define BF_USBPHY_DEBUG_HOST_RESUME_DEBUG(v)   (((v) << 29) & BM_USBPHY_DEBUG_HOST_RESUME_DEBUG)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_HOST_RESUME_DEBUG(n, v)   BFn_CS1(USBPHY_DEBUG, n, HOST_RESUME_DEBUG, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field SQUELCHRESETLENGTH */

#define BP_USBPHY_DEBUG_SQUELCHRESETLENGTH      25
#define BM_USBPHY_DEBUG_SQUELCHRESETLENGTH      0x1E000000

#define BF_USBPHY_DEBUG_SQUELCHRESETLENGTH(v)   (((v) << 25) & BM_USBPHY_DEBUG_SQUELCHRESETLENGTH)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_SQUELCHRESETLENGTH(n, v)   BFn_CS1(USBPHY_DEBUG, n, SQUELCHRESETLENGTH, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field ENSQUELCHRESET */

#define BP_USBPHY_DEBUG_ENSQUELCHRESET      24
#define BM_USBPHY_DEBUG_ENSQUELCHRESET      0x01000000

#define BF_USBPHY_DEBUG_ENSQUELCHRESET(v)   (((v) << 24) & BM_USBPHY_DEBUG_ENSQUELCHRESET)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_ENSQUELCHRESET(n, v)   BFn_CS1(USBPHY_DEBUG, n, ENSQUELCHRESET, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field RSVD2 */

#define BP_USBPHY_DEBUG_RSVD2      21
#define BM_USBPHY_DEBUG_RSVD2      0x00E00000

#define BF_USBPHY_DEBUG_RSVD2(v)   (((v) << 21) & BM_USBPHY_DEBUG_RSVD2)
/* --- Register HW_USBPHY_DEBUG, field SQUELCHRESETCOUNT */

#define BP_USBPHY_DEBUG_SQUELCHRESETCOUNT      16
#define BM_USBPHY_DEBUG_SQUELCHRESETCOUNT      0x001F0000

#define BF_USBPHY_DEBUG_SQUELCHRESETCOUNT(v)   (((v) << 16) & BM_USBPHY_DEBUG_SQUELCHRESETCOUNT)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_SQUELCHRESETCOUNT(n, v)   BFn_CS1(USBPHY_DEBUG, n, SQUELCHRESETCOUNT, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field RSVD1 */

#define BP_USBPHY_DEBUG_RSVD1      13
#define BM_USBPHY_DEBUG_RSVD1      0x0000E000

#define BF_USBPHY_DEBUG_RSVD1(v)   (((v) << 13) & BM_USBPHY_DEBUG_RSVD1)
/* --- Register HW_USBPHY_DEBUG, field ENTX2RXCOUNT */

#define BP_USBPHY_DEBUG_ENTX2RXCOUNT      12
#define BM_USBPHY_DEBUG_ENTX2RXCOUNT      0x00001000

#define BF_USBPHY_DEBUG_ENTX2RXCOUNT(v)   (((v) << 12) & BM_USBPHY_DEBUG_ENTX2RXCOUNT)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_ENTX2RXCOUNT(n, v)   BFn_CS1(USBPHY_DEBUG, n, ENTX2RXCOUNT, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field TX2RXCOUNT */

#define BP_USBPHY_DEBUG_TX2RXCOUNT      8
#define BM_USBPHY_DEBUG_TX2RXCOUNT      0x00000F00

#define BF_USBPHY_DEBUG_TX2RXCOUNT(v)   (((v) << 8) & BM_USBPHY_DEBUG_TX2RXCOUNT)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_TX2RXCOUNT(n, v)   BFn_CS1(USBPHY_DEBUG, n, TX2RXCOUNT, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field RSVD0 */

#define BP_USBPHY_DEBUG_RSVD0      6
#define BM_USBPHY_DEBUG_RSVD0      0x000000C0

#define BF_USBPHY_DEBUG_RSVD0(v)   (((v) << 6) & BM_USBPHY_DEBUG_RSVD0)
/* --- Register HW_USBPHY_DEBUG, field ENHSTPULLDOWN */

#define BP_USBPHY_DEBUG_ENHSTPULLDOWN      4
#define BM_USBPHY_DEBUG_ENHSTPULLDOWN      0x00000030

#define BF_USBPHY_DEBUG_ENHSTPULLDOWN(v)   (((v) << 4) & BM_USBPHY_DEBUG_ENHSTPULLDOWN)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_ENHSTPULLDOWN(n, v)   BFn_CS1(USBPHY_DEBUG, n, ENHSTPULLDOWN, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field HSTPULLDOWN */

#define BP_USBPHY_DEBUG_HSTPULLDOWN      2
#define BM_USBPHY_DEBUG_HSTPULLDOWN      0x0000000C

#define BF_USBPHY_DEBUG_HSTPULLDOWN(v)   (((v) << 2) & BM_USBPHY_DEBUG_HSTPULLDOWN)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_HSTPULLDOWN(n, v)   BFn_CS1(USBPHY_DEBUG, n, HSTPULLDOWN, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field DEBUG_INTERFACE_HOLD */

#define BP_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD      1
#define BM_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD      0x00000002

#define BF_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD(v)   (((v) << 1) & BM_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD(n, v)   BFn_CS1(USBPHY_DEBUG, n, DEBUG_INTERFACE_HOLD, v)
#endif

/* --- Register HW_USBPHY_DEBUG, field OTGIDPIOLOCK */

#define BP_USBPHY_DEBUG_OTGIDPIOLOCK      0
#define BM_USBPHY_DEBUG_OTGIDPIOLOCK      0x00000001

#define BF_USBPHY_DEBUG_OTGIDPIOLOCK(v)   (((v) << 0) & BM_USBPHY_DEBUG_OTGIDPIOLOCK)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_OTGIDPIOLOCK(n, v)   BFn_CS1(USBPHY_DEBUG, n, OTGIDPIOLOCK, v)
#endif



/*
 * HW_USBPHY_DEBUG0_STATUS - UTMI Debug Status Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOOP_BACK_FAIL_COUNT     : 16;
        unsigned UTMI_RXERROR_FAIL_COUNT  : 10;
        unsigned SQUELCH_COUNT            :  6;
    } B;
} hw_usbphy_debug0_status_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_DEBUG0_STATUS register
 */
#define HW_USBPHY_DEBUG0_STATUS_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_DEBUG0_STATUS(x)           (*(volatile hw_usbphy_debug0_status_t *) HW_USBPHY_DEBUG0_STATUS_ADDR(x))
#define HW_USBPHY_DEBUG0_STATUS_RD(x)      (HW_USBPHY_DEBUG0_STATUS(x).U)
#endif


/*
 * constants & macros for individual HW_USBPHY_DEBUG0_STATUS bitfields
 */
/* --- Register HW_USBPHY_DEBUG0_STATUS, field SQUELCH_COUNT */

#define BP_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT      26
#define BM_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT(v)   ((((reg32_t) v) << 26) & BM_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT)
#else
#define BF_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT(v)   (((v) << 26) & BM_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT)
#endif
/* --- Register HW_USBPHY_DEBUG0_STATUS, field UTMI_RXERROR_FAIL_COUNT */

#define BP_USBPHY_DEBUG0_STATUS_UTMI_RXERROR_FAIL_COUNT      16
#define BM_USBPHY_DEBUG0_STATUS_UTMI_RXERROR_FAIL_COUNT      0x03FF0000

#define BF_USBPHY_DEBUG0_STATUS_UTMI_RXERROR_FAIL_COUNT(v)   (((v) << 16) & BM_USBPHY_DEBUG0_STATUS_UTMI_RXERROR_FAIL_COUNT)
/* --- Register HW_USBPHY_DEBUG0_STATUS, field LOOP_BACK_FAIL_COUNT */

#define BP_USBPHY_DEBUG0_STATUS_LOOP_BACK_FAIL_COUNT      0
#define BM_USBPHY_DEBUG0_STATUS_LOOP_BACK_FAIL_COUNT      0x0000FFFF

#define BF_USBPHY_DEBUG0_STATUS_LOOP_BACK_FAIL_COUNT(v)   (((v) << 0) & BM_USBPHY_DEBUG0_STATUS_LOOP_BACK_FAIL_COUNT)


/*
 * HW_USBPHY_DEBUG1 - UTMI Debug Status Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DBG_ADDRESS  :  4;
        unsigned RSVD0        :  8;
        unsigned ENTX2TX      :  1;
        unsigned ENTAILADJVD  :  2;
        unsigned RSVD1        : 17;
    } B;
} hw_usbphy_debug1_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_DEBUG1 register
 */
#define HW_USBPHY_DEBUG1_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x70)
#define HW_USBPHY_DEBUG1_SET_ADDR(x)  (HW_USBPHY_DEBUG1_ADDR(x) + 4)
#define HW_USBPHY_DEBUG1_CLR_ADDR(x)  (HW_USBPHY_DEBUG1_ADDR(x) + 8)
#define HW_USBPHY_DEBUG1_TOG_ADDR(x)  (HW_USBPHY_DEBUG1_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_DEBUG1(x)           (*(volatile hw_usbphy_debug1_t *) HW_USBPHY_DEBUG1_ADDR(x))
#define HW_USBPHY_DEBUG1_RD(x)      (HW_USBPHY_DEBUG1(x).U)
#define HW_USBPHY_DEBUG1_WR(x, v)     (HW_USBPHY_DEBUG1(x).U = (v))
#define HW_USBPHY_DEBUG1_SET(x, v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG1_SET_ADDR(x)) = (v))
#define HW_USBPHY_DEBUG1_CLR(x, v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG1_CLR_ADDR(x)) = (v))
#define HW_USBPHY_DEBUG1_TOG(x, v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG1_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_USBPHY_DEBUG1 bitfields
 */
/* --- Register HW_USBPHY_DEBUG1, field RSVD1 */

#define BP_USBPHY_DEBUG1_RSVD1      15
#define BM_USBPHY_DEBUG1_RSVD1      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_DEBUG1_RSVD1(v)   ((((reg32_t) v) << 15) & BM_USBPHY_DEBUG1_RSVD1)
#else
#define BF_USBPHY_DEBUG1_RSVD1(v)   (((v) << 15) & BM_USBPHY_DEBUG1_RSVD1)
#endif
/* --- Register HW_USBPHY_DEBUG1, field ENTAILADJVD */

#define BP_USBPHY_DEBUG1_ENTAILADJVD      13
#define BM_USBPHY_DEBUG1_ENTAILADJVD      0x00006000

#define BF_USBPHY_DEBUG1_ENTAILADJVD(v)   (((v) << 13) & BM_USBPHY_DEBUG1_ENTAILADJVD)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG1_ENTAILADJVD(n, v)   BFn_CS1(USBPHY_DEBUG1, n, ENTAILADJVD, v)
#endif

/* --- Register HW_USBPHY_DEBUG1, field ENTX2TX */

#define BP_USBPHY_DEBUG1_ENTX2TX      12
#define BM_USBPHY_DEBUG1_ENTX2TX      0x00001000

#define BF_USBPHY_DEBUG1_ENTX2TX(v)   (((v) << 12) & BM_USBPHY_DEBUG1_ENTX2TX)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG1_ENTX2TX(n, v)   BFn_CS1(USBPHY_DEBUG1, n, ENTX2TX, v)
#endif

/* --- Register HW_USBPHY_DEBUG1, field RSVD0 */

#define BP_USBPHY_DEBUG1_RSVD0      4
#define BM_USBPHY_DEBUG1_RSVD0      0x00000FF0

#define BF_USBPHY_DEBUG1_RSVD0(v)   (((v) << 4) & BM_USBPHY_DEBUG1_RSVD0)
/* --- Register HW_USBPHY_DEBUG1, field DBG_ADDRESS */

#define BP_USBPHY_DEBUG1_DBG_ADDRESS      0
#define BM_USBPHY_DEBUG1_DBG_ADDRESS      0x0000000F

#define BF_USBPHY_DEBUG1_DBG_ADDRESS(v)   (((v) << 0) & BM_USBPHY_DEBUG1_DBG_ADDRESS)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG1_DBG_ADDRESS(n, v)   BFn_CS1(USBPHY_DEBUG1, n, DBG_ADDRESS, v)
#endif



/*
 * HW_USBPHY_VERSION - UTMI RTL Version
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_usbphy_version_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_VERSION register
 */
#define HW_USBPHY_VERSION_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x80)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_VERSION(x)           (*(volatile hw_usbphy_version_t *) HW_USBPHY_VERSION_ADDR(x))
#define HW_USBPHY_VERSION_RD(x)      (HW_USBPHY_VERSION(x).U)
#endif


/*
 * constants & macros for individual HW_USBPHY_VERSION bitfields
 */
/* --- Register HW_USBPHY_VERSION, field MAJOR */

#define BP_USBPHY_VERSION_MAJOR      24
#define BM_USBPHY_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_USBPHY_VERSION_MAJOR)
#else
#define BF_USBPHY_VERSION_MAJOR(v)   (((v) << 24) & BM_USBPHY_VERSION_MAJOR)
#endif
/* --- Register HW_USBPHY_VERSION, field MINOR */

#define BP_USBPHY_VERSION_MINOR      16
#define BM_USBPHY_VERSION_MINOR      0x00FF0000

#define BF_USBPHY_VERSION_MINOR(v)   (((v) << 16) & BM_USBPHY_VERSION_MINOR)
/* --- Register HW_USBPHY_VERSION, field STEP */

#define BP_USBPHY_VERSION_STEP      0
#define BM_USBPHY_VERSION_STEP      0x0000FFFF

#define BF_USBPHY_VERSION_STEP(v)   (((v) << 0) & BM_USBPHY_VERSION_STEP)


/*
 * HW_USBPHY_IP - USB PHY IP Block Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PLL_POWER        :  1;
        unsigned PLL_LOCKED       :  1;
        unsigned EN_USB_CLKS      :  1;
        unsigned RSVD0            : 13;
        unsigned ANALOG_TESTMODE  :  1;
        unsigned TSTI_TX_DM       :  1;
        unsigned TSTI_TX_DP       :  1;
        unsigned CP_SEL           :  2;
        unsigned LFR_SEL          :  2;
        unsigned DIV_SEL          :  2;
        unsigned RSVD1            :  7;
    } B;
} hw_usbphy_ip_t;
#endif

/*
 * constants & macros for entire multi-block HW_USBPHY_IP register
 */
#define HW_USBPHY_IP_ADDR(x)      (REGS_USBPHY_BASE(x) + 0x90)
#define HW_USBPHY_IP_SET_ADDR(x)  (HW_USBPHY_IP_ADDR(x) + 4)
#define HW_USBPHY_IP_CLR_ADDR(x)  (HW_USBPHY_IP_ADDR(x) + 8)
#define HW_USBPHY_IP_TOG_ADDR(x)  (HW_USBPHY_IP_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_IP(x)           (*(volatile hw_usbphy_ip_t *) HW_USBPHY_IP_ADDR(x))
#define HW_USBPHY_IP_RD(x)      (HW_USBPHY_IP(x).U)
#define HW_USBPHY_IP_WR(x, v)     (HW_USBPHY_IP(x).U = (v))
#define HW_USBPHY_IP_SET(x, v)    ((*(volatile reg32_t *) HW_USBPHY_IP_SET_ADDR(x)) = (v))
#define HW_USBPHY_IP_CLR(x, v)    ((*(volatile reg32_t *) HW_USBPHY_IP_CLR_ADDR(x)) = (v))
#define HW_USBPHY_IP_TOG(x, v)    ((*(volatile reg32_t *) HW_USBPHY_IP_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_USBPHY_IP bitfields
 */
/* --- Register HW_USBPHY_IP, field RSVD1 */

#define BP_USBPHY_IP_RSVD1      25
#define BM_USBPHY_IP_RSVD1      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_IP_RSVD1(v)   ((((reg32_t) v) << 25) & BM_USBPHY_IP_RSVD1)
#else
#define BF_USBPHY_IP_RSVD1(v)   (((v) << 25) & BM_USBPHY_IP_RSVD1)
#endif
/* --- Register HW_USBPHY_IP, field DIV_SEL */

#define BP_USBPHY_IP_DIV_SEL      23
#define BM_USBPHY_IP_DIV_SEL      0x01800000

#define BF_USBPHY_IP_DIV_SEL(v)   (((v) << 23) & BM_USBPHY_IP_DIV_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_DIV_SEL(n, v)   BFn_CS1(USBPHY_IP, n, DIV_SEL, v)
#endif

#define BV_USBPHY_IP_DIV_SEL__DEFAULT    0x0
#define BV_USBPHY_IP_DIV_SEL__LOWER      0x1
#define BV_USBPHY_IP_DIV_SEL__LOWEST     0x2
#define BV_USBPHY_IP_DIV_SEL__UNDEFINED  0x3

/* --- Register HW_USBPHY_IP, field LFR_SEL */

#define BP_USBPHY_IP_LFR_SEL      21
#define BM_USBPHY_IP_LFR_SEL      0x00600000

#define BF_USBPHY_IP_LFR_SEL(v)   (((v) << 21) & BM_USBPHY_IP_LFR_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_LFR_SEL(n, v)   BFn_CS1(USBPHY_IP, n, LFR_SEL, v)
#endif

#define BV_USBPHY_IP_LFR_SEL__DEFAULT    0x0
#define BV_USBPHY_IP_LFR_SEL__TIMES_2    0x1
#define BV_USBPHY_IP_LFR_SEL__TIMES_05   0x2
#define BV_USBPHY_IP_LFR_SEL__UNDEFINED  0x3

/* --- Register HW_USBPHY_IP, field CP_SEL */

#define BP_USBPHY_IP_CP_SEL      19
#define BM_USBPHY_IP_CP_SEL      0x00180000

#define BF_USBPHY_IP_CP_SEL(v)   (((v) << 19) & BM_USBPHY_IP_CP_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_CP_SEL(n, v)   BFn_CS1(USBPHY_IP, n, CP_SEL, v)
#endif

#define BV_USBPHY_IP_CP_SEL__DEFAULT    0x0
#define BV_USBPHY_IP_CP_SEL__TIMES_2    0x1
#define BV_USBPHY_IP_CP_SEL__TIMES_05   0x2
#define BV_USBPHY_IP_CP_SEL__UNDEFINED  0x3

/* --- Register HW_USBPHY_IP, field TSTI_TX_DP */

#define BP_USBPHY_IP_TSTI_TX_DP      18
#define BM_USBPHY_IP_TSTI_TX_DP      0x00040000

#define BF_USBPHY_IP_TSTI_TX_DP(v)   (((v) << 18) & BM_USBPHY_IP_TSTI_TX_DP)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_TSTI_TX_DP(n, v)   BFn_CS1(USBPHY_IP, n, TSTI_TX_DP, v)
#endif

/* --- Register HW_USBPHY_IP, field TSTI_TX_DM */

#define BP_USBPHY_IP_TSTI_TX_DM      17
#define BM_USBPHY_IP_TSTI_TX_DM      0x00020000

#define BF_USBPHY_IP_TSTI_TX_DM(v)   (((v) << 17) & BM_USBPHY_IP_TSTI_TX_DM)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_TSTI_TX_DM(n, v)   BFn_CS1(USBPHY_IP, n, TSTI_TX_DM, v)
#endif

/* --- Register HW_USBPHY_IP, field ANALOG_TESTMODE */

#define BP_USBPHY_IP_ANALOG_TESTMODE      16
#define BM_USBPHY_IP_ANALOG_TESTMODE      0x00010000

#define BF_USBPHY_IP_ANALOG_TESTMODE(v)   (((v) << 16) & BM_USBPHY_IP_ANALOG_TESTMODE)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_ANALOG_TESTMODE(n, v)   BFn_CS1(USBPHY_IP, n, ANALOG_TESTMODE, v)
#endif

/* --- Register HW_USBPHY_IP, field RSVD0 */

#define BP_USBPHY_IP_RSVD0      3
#define BM_USBPHY_IP_RSVD0      0x0000FFF8

#define BF_USBPHY_IP_RSVD0(v)   (((v) << 3) & BM_USBPHY_IP_RSVD0)
/* --- Register HW_USBPHY_IP, field EN_USB_CLKS */

#define BP_USBPHY_IP_EN_USB_CLKS      2
#define BM_USBPHY_IP_EN_USB_CLKS      0x00000004

#define BF_USBPHY_IP_EN_USB_CLKS(v)   (((v) << 2) & BM_USBPHY_IP_EN_USB_CLKS)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_EN_USB_CLKS(n, v)   BFn_CS1(USBPHY_IP, n, EN_USB_CLKS, v)
#endif

/* --- Register HW_USBPHY_IP, field PLL_LOCKED */

#define BP_USBPHY_IP_PLL_LOCKED      1
#define BM_USBPHY_IP_PLL_LOCKED      0x00000002

#define BF_USBPHY_IP_PLL_LOCKED(v)   (((v) << 1) & BM_USBPHY_IP_PLL_LOCKED)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_PLL_LOCKED(n, v)   BFn_CS1(USBPHY_IP, n, PLL_LOCKED, v)
#endif

/* --- Register HW_USBPHY_IP, field PLL_POWER */

#define BP_USBPHY_IP_PLL_POWER      0
#define BM_USBPHY_IP_PLL_POWER      0x00000001

#define BF_USBPHY_IP_PLL_POWER(v)   (((v) << 0) & BM_USBPHY_IP_PLL_POWER)
#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_PLL_POWER(n, v)   BFn_CS1(USBPHY_IP, n, PLL_POWER, v)
#endif


#endif /* _USBPHY_H */

////////////////////////////////////////////////////////////////////////////////
