/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.32
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _EMACC_H
#define _EMACC_H  1

#include "regs.h"

#ifndef REGS_ENET_BASE
#define REGS_ENET_BASE (REGS_BASE + 0xf0000)
#endif

/*
 * HW_ENET_MAC0_EIR - ENET MAC0 Interrupt Event Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1    : 15;
        unsigned TS_TIMER  :  1;
        unsigned TS_AVAIL  :  1;
        unsigned WAKEUP    :  1;
        unsigned PLR       :  1;
        unsigned UN        :  1;
        unsigned RL        :  1;
        unsigned LC        :  1;
        unsigned EBERR     :  1;
        unsigned MII       :  1;
        unsigned RXB       :  1;
        unsigned RXF       :  1;
        unsigned TXB       :  1;
        unsigned TXF       :  1;
        unsigned GRA       :  1;
        unsigned BABT      :  1;
        unsigned BABR      :  1;
        unsigned RSRVD0    :  1;
    } B;
} hw_enet_mac0_eir_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_EIR register
 */
#define HW_ENET_MAC0_EIR_ADDR         (REGS_ENET_BASE + 0x4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_EIR           (*(volatile hw_enet_mac0_eir_t *) HW_ENET_MAC0_EIR_ADDR)
#define HW_ENET_MAC0_EIR_RD()      (HW_ENET_MAC0_EIR.U)
#define HW_ENET_MAC0_EIR_WR(v)     (HW_ENET_MAC0_EIR.U = (v))
#define HW_ENET_MAC0_EIR_SET(v)    (HW_ENET_MAC0_EIR_WR(HW_ENET_MAC0_EIR_RD() |  (v)))
#define HW_ENET_MAC0_EIR_CLR(v)    (HW_ENET_MAC0_EIR_WR(HW_ENET_MAC0_EIR_RD() & ~(v)))
#define HW_ENET_MAC0_EIR_TOG(v)    (HW_ENET_MAC0_EIR_WR(HW_ENET_MAC0_EIR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_EIR bitfields
 */
/* --- Register HW_ENET_MAC0_EIR, field RSRVD0 */

#define BP_ENET_MAC0_EIR_RSRVD0      31
#define BM_ENET_MAC0_EIR_RSRVD0      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_EIR_RSRVD0(v)   ((((reg32_t) v) << 31) & BM_ENET_MAC0_EIR_RSRVD0)
#else
#define BF_ENET_MAC0_EIR_RSRVD0(v)   (((v) << 31) & BM_ENET_MAC0_EIR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_EIR, field BABR */

#define BP_ENET_MAC0_EIR_BABR      30
#define BM_ENET_MAC0_EIR_BABR      0x40000000

#define BF_ENET_MAC0_EIR_BABR(v)   (((v) << 30) & BM_ENET_MAC0_EIR_BABR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_BABR(v)   BF_CS1(ENET_MAC0_EIR, BABR, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field BABT */

#define BP_ENET_MAC0_EIR_BABT      29
#define BM_ENET_MAC0_EIR_BABT      0x20000000

#define BF_ENET_MAC0_EIR_BABT(v)   (((v) << 29) & BM_ENET_MAC0_EIR_BABT)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_BABT(v)   BF_CS1(ENET_MAC0_EIR, BABT, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field GRA */

#define BP_ENET_MAC0_EIR_GRA      28
#define BM_ENET_MAC0_EIR_GRA      0x10000000

#define BF_ENET_MAC0_EIR_GRA(v)   (((v) << 28) & BM_ENET_MAC0_EIR_GRA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_GRA(v)   BF_CS1(ENET_MAC0_EIR, GRA, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field TXF */

#define BP_ENET_MAC0_EIR_TXF      27
#define BM_ENET_MAC0_EIR_TXF      0x08000000

#define BF_ENET_MAC0_EIR_TXF(v)   (((v) << 27) & BM_ENET_MAC0_EIR_TXF)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_TXF(v)   BF_CS1(ENET_MAC0_EIR, TXF, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field TXB */

#define BP_ENET_MAC0_EIR_TXB      26
#define BM_ENET_MAC0_EIR_TXB      0x04000000

#define BF_ENET_MAC0_EIR_TXB(v)   (((v) << 26) & BM_ENET_MAC0_EIR_TXB)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_TXB(v)   BF_CS1(ENET_MAC0_EIR, TXB, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field RXF */

#define BP_ENET_MAC0_EIR_RXF      25
#define BM_ENET_MAC0_EIR_RXF      0x02000000

#define BF_ENET_MAC0_EIR_RXF(v)   (((v) << 25) & BM_ENET_MAC0_EIR_RXF)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_RXF(v)   BF_CS1(ENET_MAC0_EIR, RXF, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field RXB */

#define BP_ENET_MAC0_EIR_RXB      24
#define BM_ENET_MAC0_EIR_RXB      0x01000000

#define BF_ENET_MAC0_EIR_RXB(v)   (((v) << 24) & BM_ENET_MAC0_EIR_RXB)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_RXB(v)   BF_CS1(ENET_MAC0_EIR, RXB, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field MII */

#define BP_ENET_MAC0_EIR_MII      23
#define BM_ENET_MAC0_EIR_MII      0x00800000

#define BF_ENET_MAC0_EIR_MII(v)   (((v) << 23) & BM_ENET_MAC0_EIR_MII)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_MII(v)   BF_CS1(ENET_MAC0_EIR, MII, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field EBERR */

#define BP_ENET_MAC0_EIR_EBERR      22
#define BM_ENET_MAC0_EIR_EBERR      0x00400000

#define BF_ENET_MAC0_EIR_EBERR(v)   (((v) << 22) & BM_ENET_MAC0_EIR_EBERR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_EBERR(v)   BF_CS1(ENET_MAC0_EIR, EBERR, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field LC */

#define BP_ENET_MAC0_EIR_LC      21
#define BM_ENET_MAC0_EIR_LC      0x00200000

#define BF_ENET_MAC0_EIR_LC(v)   (((v) << 21) & BM_ENET_MAC0_EIR_LC)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_LC(v)   BF_CS1(ENET_MAC0_EIR, LC, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field RL */

#define BP_ENET_MAC0_EIR_RL      20
#define BM_ENET_MAC0_EIR_RL      0x00100000

#define BF_ENET_MAC0_EIR_RL(v)   (((v) << 20) & BM_ENET_MAC0_EIR_RL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_RL(v)   BF_CS1(ENET_MAC0_EIR, RL, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field UN */

#define BP_ENET_MAC0_EIR_UN      19
#define BM_ENET_MAC0_EIR_UN      0x00080000

#define BF_ENET_MAC0_EIR_UN(v)   (((v) << 19) & BM_ENET_MAC0_EIR_UN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_UN(v)   BF_CS1(ENET_MAC0_EIR, UN, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field PLR */

#define BP_ENET_MAC0_EIR_PLR      18
#define BM_ENET_MAC0_EIR_PLR      0x00040000

#define BF_ENET_MAC0_EIR_PLR(v)   (((v) << 18) & BM_ENET_MAC0_EIR_PLR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_PLR(v)   BF_CS1(ENET_MAC0_EIR, PLR, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field WAKEUP */

#define BP_ENET_MAC0_EIR_WAKEUP      17
#define BM_ENET_MAC0_EIR_WAKEUP      0x00020000

#define BF_ENET_MAC0_EIR_WAKEUP(v)   (((v) << 17) & BM_ENET_MAC0_EIR_WAKEUP)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_WAKEUP(v)   BF_CS1(ENET_MAC0_EIR, WAKEUP, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field TS_AVAIL */

#define BP_ENET_MAC0_EIR_TS_AVAIL      16
#define BM_ENET_MAC0_EIR_TS_AVAIL      0x00010000

#define BF_ENET_MAC0_EIR_TS_AVAIL(v)   (((v) << 16) & BM_ENET_MAC0_EIR_TS_AVAIL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_TS_AVAIL(v)   BF_CS1(ENET_MAC0_EIR, TS_AVAIL, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field TS_TIMER */

#define BP_ENET_MAC0_EIR_TS_TIMER      15
#define BM_ENET_MAC0_EIR_TS_TIMER      0x00008000

#define BF_ENET_MAC0_EIR_TS_TIMER(v)   (((v) << 15) & BM_ENET_MAC0_EIR_TS_TIMER)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIR_TS_TIMER(v)   BF_CS1(ENET_MAC0_EIR, TS_TIMER, v)
#endif

/* --- Register HW_ENET_MAC0_EIR, field RSRVD1 */

#define BP_ENET_MAC0_EIR_RSRVD1      0
#define BM_ENET_MAC0_EIR_RSRVD1      0x00007FFF

#define BF_ENET_MAC0_EIR_RSRVD1(v)   (((v) << 0) & BM_ENET_MAC0_EIR_RSRVD1)


/*
 * HW_ENET_MAC0_EIMR - ENET MAC0 Interrupt Mask Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned EIMR  : 32;
    } B;
} hw_enet_mac0_eimr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_EIMR register
 */
#define HW_ENET_MAC0_EIMR_ADDR         (REGS_ENET_BASE + 0x8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_EIMR           (*(volatile hw_enet_mac0_eimr_t *) HW_ENET_MAC0_EIMR_ADDR)
#define HW_ENET_MAC0_EIMR_RD()      (HW_ENET_MAC0_EIMR.U)
#define HW_ENET_MAC0_EIMR_WR(v)     (HW_ENET_MAC0_EIMR.U = (v))
#define HW_ENET_MAC0_EIMR_SET(v)    (HW_ENET_MAC0_EIMR_WR(HW_ENET_MAC0_EIMR_RD() |  (v)))
#define HW_ENET_MAC0_EIMR_CLR(v)    (HW_ENET_MAC0_EIMR_WR(HW_ENET_MAC0_EIMR_RD() & ~(v)))
#define HW_ENET_MAC0_EIMR_TOG(v)    (HW_ENET_MAC0_EIMR_WR(HW_ENET_MAC0_EIMR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_EIMR bitfields
 */
/* --- Register HW_ENET_MAC0_EIMR, field EIMR */

#define BP_ENET_MAC0_EIMR_EIMR      0
#define BM_ENET_MAC0_EIMR_EIMR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_EIMR_EIMR(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_EIMR_EIMR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EIMR_EIMR(v)   (HW_ENET_MAC0_EIMR.B.EIMR = (v))
#endif



/*
 * HW_ENET_MAC0_RDAR - ENET MAC0 Receive Descriptor Active Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1  : 24;
        unsigned RDAR    :  1;
        unsigned RSRVD0  :  7;
    } B;
} hw_enet_mac0_rdar_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RDAR register
 */
#define HW_ENET_MAC0_RDAR_ADDR         (REGS_ENET_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RDAR           (*(volatile hw_enet_mac0_rdar_t *) HW_ENET_MAC0_RDAR_ADDR)
#define HW_ENET_MAC0_RDAR_RD()      (HW_ENET_MAC0_RDAR.U)
#define HW_ENET_MAC0_RDAR_WR(v)     (HW_ENET_MAC0_RDAR.U = (v))
#define HW_ENET_MAC0_RDAR_SET(v)    (HW_ENET_MAC0_RDAR_WR(HW_ENET_MAC0_RDAR_RD() |  (v)))
#define HW_ENET_MAC0_RDAR_CLR(v)    (HW_ENET_MAC0_RDAR_WR(HW_ENET_MAC0_RDAR_RD() & ~(v)))
#define HW_ENET_MAC0_RDAR_TOG(v)    (HW_ENET_MAC0_RDAR_WR(HW_ENET_MAC0_RDAR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RDAR bitfields
 */
/* --- Register HW_ENET_MAC0_RDAR, field RSRVD0 */

#define BP_ENET_MAC0_RDAR_RSRVD0      25
#define BM_ENET_MAC0_RDAR_RSRVD0      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RDAR_RSRVD0(v)   ((((reg32_t) v) << 25) & BM_ENET_MAC0_RDAR_RSRVD0)
#else
#define BF_ENET_MAC0_RDAR_RSRVD0(v)   (((v) << 25) & BM_ENET_MAC0_RDAR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_RDAR, field RDAR */

#define BP_ENET_MAC0_RDAR_RDAR      24
#define BM_ENET_MAC0_RDAR_RDAR      0x01000000

#define BF_ENET_MAC0_RDAR_RDAR(v)   (((v) << 24) & BM_ENET_MAC0_RDAR_RDAR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RDAR_RDAR(v)   BF_CS1(ENET_MAC0_RDAR, RDAR, v)
#endif

/* --- Register HW_ENET_MAC0_RDAR, field RSRVD1 */

#define BP_ENET_MAC0_RDAR_RSRVD1      0
#define BM_ENET_MAC0_RDAR_RSRVD1      0x00FFFFFF

#define BF_ENET_MAC0_RDAR_RSRVD1(v)   (((v) << 0) & BM_ENET_MAC0_RDAR_RSRVD1)


/*
 * HW_ENET_MAC0_TDAR - ENET MAC0 Transmit Descriptor Active Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1  : 24;
        unsigned TDAR    :  1;
        unsigned RSRVD0  :  7;
    } B;
} hw_enet_mac0_tdar_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_TDAR register
 */
#define HW_ENET_MAC0_TDAR_ADDR         (REGS_ENET_BASE + 0x14)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_TDAR           (*(volatile hw_enet_mac0_tdar_t *) HW_ENET_MAC0_TDAR_ADDR)
#define HW_ENET_MAC0_TDAR_RD()      (HW_ENET_MAC0_TDAR.U)
#define HW_ENET_MAC0_TDAR_WR(v)     (HW_ENET_MAC0_TDAR.U = (v))
#define HW_ENET_MAC0_TDAR_SET(v)    (HW_ENET_MAC0_TDAR_WR(HW_ENET_MAC0_TDAR_RD() |  (v)))
#define HW_ENET_MAC0_TDAR_CLR(v)    (HW_ENET_MAC0_TDAR_WR(HW_ENET_MAC0_TDAR_RD() & ~(v)))
#define HW_ENET_MAC0_TDAR_TOG(v)    (HW_ENET_MAC0_TDAR_WR(HW_ENET_MAC0_TDAR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_TDAR bitfields
 */
/* --- Register HW_ENET_MAC0_TDAR, field RSRVD0 */

#define BP_ENET_MAC0_TDAR_RSRVD0      25
#define BM_ENET_MAC0_TDAR_RSRVD0      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_TDAR_RSRVD0(v)   ((((reg32_t) v) << 25) & BM_ENET_MAC0_TDAR_RSRVD0)
#else
#define BF_ENET_MAC0_TDAR_RSRVD0(v)   (((v) << 25) & BM_ENET_MAC0_TDAR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_TDAR, field TDAR */

#define BP_ENET_MAC0_TDAR_TDAR      24
#define BM_ENET_MAC0_TDAR_TDAR      0x01000000

#define BF_ENET_MAC0_TDAR_TDAR(v)   (((v) << 24) & BM_ENET_MAC0_TDAR_TDAR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TDAR_TDAR(v)   BF_CS1(ENET_MAC0_TDAR, TDAR, v)
#endif

/* --- Register HW_ENET_MAC0_TDAR, field RSRVD1 */

#define BP_ENET_MAC0_TDAR_RSRVD1      0
#define BM_ENET_MAC0_TDAR_RSRVD1      0x00FFFFFF

#define BF_ENET_MAC0_TDAR_RSRVD1(v)   (((v) << 0) & BM_ENET_MAC0_TDAR_RSRVD1)


/*
 * HW_ENET_MAC0_ECR - ENET MAC0 Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RESET      :  1;
        unsigned ETHER_EN   :  1;
        unsigned MAGIC_ENA  :  1;
        unsigned SLEEP      :  1;
        unsigned ENA_1588   :  1;
        unsigned ETH_SPEED  :  1;
        unsigned DBG_EN     :  1;
        unsigned RSRVD0     : 25;
    } B;
} hw_enet_mac0_ecr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_ECR register
 */
#define HW_ENET_MAC0_ECR_ADDR         (REGS_ENET_BASE + 0x24)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_ECR           (*(volatile hw_enet_mac0_ecr_t *) HW_ENET_MAC0_ECR_ADDR)
#define HW_ENET_MAC0_ECR_RD()      (HW_ENET_MAC0_ECR.U)
#define HW_ENET_MAC0_ECR_WR(v)     (HW_ENET_MAC0_ECR.U = (v))
#define HW_ENET_MAC0_ECR_SET(v)    (HW_ENET_MAC0_ECR_WR(HW_ENET_MAC0_ECR_RD() |  (v)))
#define HW_ENET_MAC0_ECR_CLR(v)    (HW_ENET_MAC0_ECR_WR(HW_ENET_MAC0_ECR_RD() & ~(v)))
#define HW_ENET_MAC0_ECR_TOG(v)    (HW_ENET_MAC0_ECR_WR(HW_ENET_MAC0_ECR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_ECR bitfields
 */
/* --- Register HW_ENET_MAC0_ECR, field RSRVD0 */

#define BP_ENET_MAC0_ECR_RSRVD0      7
#define BM_ENET_MAC0_ECR_RSRVD0      0xFFFFFF80

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_ECR_RSRVD0(v)   ((((reg32_t) v) << 7) & BM_ENET_MAC0_ECR_RSRVD0)
#else
#define BF_ENET_MAC0_ECR_RSRVD0(v)   (((v) << 7) & BM_ENET_MAC0_ECR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_ECR, field DBG_EN */

#define BP_ENET_MAC0_ECR_DBG_EN      6
#define BM_ENET_MAC0_ECR_DBG_EN      0x00000040

#define BF_ENET_MAC0_ECR_DBG_EN(v)   (((v) << 6) & BM_ENET_MAC0_ECR_DBG_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ECR_DBG_EN(v)   BF_CS1(ENET_MAC0_ECR, DBG_EN, v)
#endif

/* --- Register HW_ENET_MAC0_ECR, field ETH_SPEED */

#define BP_ENET_MAC0_ECR_ETH_SPEED      5
#define BM_ENET_MAC0_ECR_ETH_SPEED      0x00000020

#define BF_ENET_MAC0_ECR_ETH_SPEED(v)   (((v) << 5) & BM_ENET_MAC0_ECR_ETH_SPEED)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ECR_ETH_SPEED(v)   BF_CS1(ENET_MAC0_ECR, ETH_SPEED, v)
#endif

/* --- Register HW_ENET_MAC0_ECR, field ENA_1588 */

#define BP_ENET_MAC0_ECR_ENA_1588      4
#define BM_ENET_MAC0_ECR_ENA_1588      0x00000010

#define BF_ENET_MAC0_ECR_ENA_1588(v)   (((v) << 4) & BM_ENET_MAC0_ECR_ENA_1588)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ECR_ENA_1588(v)   BF_CS1(ENET_MAC0_ECR, ENA_1588, v)
#endif

/* --- Register HW_ENET_MAC0_ECR, field SLEEP */

#define BP_ENET_MAC0_ECR_SLEEP      3
#define BM_ENET_MAC0_ECR_SLEEP      0x00000008

#define BF_ENET_MAC0_ECR_SLEEP(v)   (((v) << 3) & BM_ENET_MAC0_ECR_SLEEP)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ECR_SLEEP(v)   BF_CS1(ENET_MAC0_ECR, SLEEP, v)
#endif

/* --- Register HW_ENET_MAC0_ECR, field MAGIC_ENA */

#define BP_ENET_MAC0_ECR_MAGIC_ENA      2
#define BM_ENET_MAC0_ECR_MAGIC_ENA      0x00000004

#define BF_ENET_MAC0_ECR_MAGIC_ENA(v)   (((v) << 2) & BM_ENET_MAC0_ECR_MAGIC_ENA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ECR_MAGIC_ENA(v)   BF_CS1(ENET_MAC0_ECR, MAGIC_ENA, v)
#endif

/* --- Register HW_ENET_MAC0_ECR, field ETHER_EN */

#define BP_ENET_MAC0_ECR_ETHER_EN      1
#define BM_ENET_MAC0_ECR_ETHER_EN      0x00000002

#define BF_ENET_MAC0_ECR_ETHER_EN(v)   (((v) << 1) & BM_ENET_MAC0_ECR_ETHER_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ECR_ETHER_EN(v)   BF_CS1(ENET_MAC0_ECR, ETHER_EN, v)
#endif

/* --- Register HW_ENET_MAC0_ECR, field RESET */

#define BP_ENET_MAC0_ECR_RESET      0
#define BM_ENET_MAC0_ECR_RESET      0x00000001

#define BF_ENET_MAC0_ECR_RESET(v)   (((v) << 0) & BM_ENET_MAC0_ECR_RESET)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ECR_RESET(v)   BF_CS1(ENET_MAC0_ECR, RESET, v)
#endif



/*
 * HW_ENET_MAC0_MMFR - ENET MAC0 MII Management Frame Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA  : 16;
        unsigned TA    :  2;
        unsigned RA    :  5;
        unsigned PA    :  5;
        unsigned OP    :  2;
        unsigned ST    :  2;
    } B;
} hw_enet_mac0_mmfr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_MMFR register
 */
#define HW_ENET_MAC0_MMFR_ADDR         (REGS_ENET_BASE + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_MMFR           (*(volatile hw_enet_mac0_mmfr_t *) HW_ENET_MAC0_MMFR_ADDR)
#define HW_ENET_MAC0_MMFR_RD()      (HW_ENET_MAC0_MMFR.U)
#define HW_ENET_MAC0_MMFR_WR(v)     (HW_ENET_MAC0_MMFR.U = (v))
#define HW_ENET_MAC0_MMFR_SET(v)    (HW_ENET_MAC0_MMFR_WR(HW_ENET_MAC0_MMFR_RD() |  (v)))
#define HW_ENET_MAC0_MMFR_CLR(v)    (HW_ENET_MAC0_MMFR_WR(HW_ENET_MAC0_MMFR_RD() & ~(v)))
#define HW_ENET_MAC0_MMFR_TOG(v)    (HW_ENET_MAC0_MMFR_WR(HW_ENET_MAC0_MMFR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_MMFR bitfields
 */
/* --- Register HW_ENET_MAC0_MMFR, field ST */

#define BP_ENET_MAC0_MMFR_ST      30
#define BM_ENET_MAC0_MMFR_ST      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_MMFR_ST(v)   ((((reg32_t) v) << 30) & BM_ENET_MAC0_MMFR_ST)
#else
#define BF_ENET_MAC0_MMFR_ST(v)   (((v) << 30) & BM_ENET_MAC0_MMFR_ST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MMFR_ST(v)   BF_CS1(ENET_MAC0_MMFR, ST, v)
#endif

/* --- Register HW_ENET_MAC0_MMFR, field OP */

#define BP_ENET_MAC0_MMFR_OP      28
#define BM_ENET_MAC0_MMFR_OP      0x30000000

#define BF_ENET_MAC0_MMFR_OP(v)   (((v) << 28) & BM_ENET_MAC0_MMFR_OP)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MMFR_OP(v)   BF_CS1(ENET_MAC0_MMFR, OP, v)
#endif

/* --- Register HW_ENET_MAC0_MMFR, field PA */

#define BP_ENET_MAC0_MMFR_PA      23
#define BM_ENET_MAC0_MMFR_PA      0x0F800000

#define BF_ENET_MAC0_MMFR_PA(v)   (((v) << 23) & BM_ENET_MAC0_MMFR_PA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MMFR_PA(v)   BF_CS1(ENET_MAC0_MMFR, PA, v)
#endif

/* --- Register HW_ENET_MAC0_MMFR, field RA */

#define BP_ENET_MAC0_MMFR_RA      18
#define BM_ENET_MAC0_MMFR_RA      0x007C0000

#define BF_ENET_MAC0_MMFR_RA(v)   (((v) << 18) & BM_ENET_MAC0_MMFR_RA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MMFR_RA(v)   BF_CS1(ENET_MAC0_MMFR, RA, v)
#endif

/* --- Register HW_ENET_MAC0_MMFR, field TA */

#define BP_ENET_MAC0_MMFR_TA      16
#define BM_ENET_MAC0_MMFR_TA      0x00030000

#define BF_ENET_MAC0_MMFR_TA(v)   (((v) << 16) & BM_ENET_MAC0_MMFR_TA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MMFR_TA(v)   BF_CS1(ENET_MAC0_MMFR, TA, v)
#endif

/* --- Register HW_ENET_MAC0_MMFR, field DATA */

#define BP_ENET_MAC0_MMFR_DATA      0
#define BM_ENET_MAC0_MMFR_DATA      0x0000FFFF

#define BF_ENET_MAC0_MMFR_DATA(v)   (((v) << 0) & BM_ENET_MAC0_MMFR_DATA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MMFR_DATA(v)   (HW_ENET_MAC0_MMFR.B.DATA = (v))
#endif



/*
 * HW_ENET_MAC0_MSCR - ENET MAC0 MII Speed Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1     :  1;
        unsigned MII_SPEED  :  6;
        unsigned DIS_PRE    :  1;
        unsigned HOLDTIME   :  3;
        unsigned RSRVD0     : 21;
    } B;
} hw_enet_mac0_mscr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_MSCR register
 */
#define HW_ENET_MAC0_MSCR_ADDR         (REGS_ENET_BASE + 0x44)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_MSCR           (*(volatile hw_enet_mac0_mscr_t *) HW_ENET_MAC0_MSCR_ADDR)
#define HW_ENET_MAC0_MSCR_RD()      (HW_ENET_MAC0_MSCR.U)
#define HW_ENET_MAC0_MSCR_WR(v)     (HW_ENET_MAC0_MSCR.U = (v))
#define HW_ENET_MAC0_MSCR_SET(v)    (HW_ENET_MAC0_MSCR_WR(HW_ENET_MAC0_MSCR_RD() |  (v)))
#define HW_ENET_MAC0_MSCR_CLR(v)    (HW_ENET_MAC0_MSCR_WR(HW_ENET_MAC0_MSCR_RD() & ~(v)))
#define HW_ENET_MAC0_MSCR_TOG(v)    (HW_ENET_MAC0_MSCR_WR(HW_ENET_MAC0_MSCR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_MSCR bitfields
 */
/* --- Register HW_ENET_MAC0_MSCR, field RSRVD0 */

#define BP_ENET_MAC0_MSCR_RSRVD0      11
#define BM_ENET_MAC0_MSCR_RSRVD0      0xFFFFF800

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_MSCR_RSRVD0(v)   ((((reg32_t) v) << 11) & BM_ENET_MAC0_MSCR_RSRVD0)
#else
#define BF_ENET_MAC0_MSCR_RSRVD0(v)   (((v) << 11) & BM_ENET_MAC0_MSCR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_MSCR, field HOLDTIME */

#define BP_ENET_MAC0_MSCR_HOLDTIME      8
#define BM_ENET_MAC0_MSCR_HOLDTIME      0x00000700

#define BF_ENET_MAC0_MSCR_HOLDTIME(v)   (((v) << 8) & BM_ENET_MAC0_MSCR_HOLDTIME)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MSCR_HOLDTIME(v)   BF_CS1(ENET_MAC0_MSCR, HOLDTIME, v)
#endif

/* --- Register HW_ENET_MAC0_MSCR, field DIS_PRE */

#define BP_ENET_MAC0_MSCR_DIS_PRE      7
#define BM_ENET_MAC0_MSCR_DIS_PRE      0x00000080

#define BF_ENET_MAC0_MSCR_DIS_PRE(v)   (((v) << 7) & BM_ENET_MAC0_MSCR_DIS_PRE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MSCR_DIS_PRE(v)   BF_CS1(ENET_MAC0_MSCR, DIS_PRE, v)
#endif

/* --- Register HW_ENET_MAC0_MSCR, field MII_SPEED */

#define BP_ENET_MAC0_MSCR_MII_SPEED      1
#define BM_ENET_MAC0_MSCR_MII_SPEED      0x0000007E

#define BF_ENET_MAC0_MSCR_MII_SPEED(v)   (((v) << 1) & BM_ENET_MAC0_MSCR_MII_SPEED)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MSCR_MII_SPEED(v)   BF_CS1(ENET_MAC0_MSCR, MII_SPEED, v)
#endif

/* --- Register HW_ENET_MAC0_MSCR, field RSRVD1 */

#define BP_ENET_MAC0_MSCR_RSRVD1      0
#define BM_ENET_MAC0_MSCR_RSRVD1      0x00000001

#define BF_ENET_MAC0_MSCR_RSRVD1(v)   (((v) << 0) & BM_ENET_MAC0_MSCR_RSRVD1)


/*
 * HW_ENET_MAC0_MIBC - ENET MAC0 MIB Control/Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0     : 29;
        unsigned MIB_CLEAR  :  1;
        unsigned MIB_IDLE   :  1;
        unsigned MIB_DIS    :  1;
    } B;
} hw_enet_mac0_mibc_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_MIBC register
 */
#define HW_ENET_MAC0_MIBC_ADDR         (REGS_ENET_BASE + 0x64)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_MIBC           (*(volatile hw_enet_mac0_mibc_t *) HW_ENET_MAC0_MIBC_ADDR)
#define HW_ENET_MAC0_MIBC_RD()      (HW_ENET_MAC0_MIBC.U)
#define HW_ENET_MAC0_MIBC_WR(v)     (HW_ENET_MAC0_MIBC.U = (v))
#define HW_ENET_MAC0_MIBC_SET(v)    (HW_ENET_MAC0_MIBC_WR(HW_ENET_MAC0_MIBC_RD() |  (v)))
#define HW_ENET_MAC0_MIBC_CLR(v)    (HW_ENET_MAC0_MIBC_WR(HW_ENET_MAC0_MIBC_RD() & ~(v)))
#define HW_ENET_MAC0_MIBC_TOG(v)    (HW_ENET_MAC0_MIBC_WR(HW_ENET_MAC0_MIBC_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_MIBC bitfields
 */
/* --- Register HW_ENET_MAC0_MIBC, field MIB_DIS */

#define BP_ENET_MAC0_MIBC_MIB_DIS      31
#define BM_ENET_MAC0_MIBC_MIB_DIS      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_MIBC_MIB_DIS(v)   ((((reg32_t) v) << 31) & BM_ENET_MAC0_MIBC_MIB_DIS)
#else
#define BF_ENET_MAC0_MIBC_MIB_DIS(v)   (((v) << 31) & BM_ENET_MAC0_MIBC_MIB_DIS)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MIBC_MIB_DIS(v)   BF_CS1(ENET_MAC0_MIBC, MIB_DIS, v)
#endif

/* --- Register HW_ENET_MAC0_MIBC, field MIB_IDLE */

#define BP_ENET_MAC0_MIBC_MIB_IDLE      30
#define BM_ENET_MAC0_MIBC_MIB_IDLE      0x40000000

#define BF_ENET_MAC0_MIBC_MIB_IDLE(v)   (((v) << 30) & BM_ENET_MAC0_MIBC_MIB_IDLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MIBC_MIB_IDLE(v)   BF_CS1(ENET_MAC0_MIBC, MIB_IDLE, v)
#endif

/* --- Register HW_ENET_MAC0_MIBC, field MIB_CLEAR */

#define BP_ENET_MAC0_MIBC_MIB_CLEAR      29
#define BM_ENET_MAC0_MIBC_MIB_CLEAR      0x20000000

#define BF_ENET_MAC0_MIBC_MIB_CLEAR(v)   (((v) << 29) & BM_ENET_MAC0_MIBC_MIB_CLEAR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_MIBC_MIB_CLEAR(v)   BF_CS1(ENET_MAC0_MIBC, MIB_CLEAR, v)
#endif

/* --- Register HW_ENET_MAC0_MIBC, field RSRVD0 */

#define BP_ENET_MAC0_MIBC_RSRVD0      0
#define BM_ENET_MAC0_MIBC_RSRVD0      0x1FFFFFFF

#define BF_ENET_MAC0_MIBC_RSRVD0(v)   (((v) << 0) & BM_ENET_MAC0_MIBC_RSRVD0)


/*
 * HW_ENET_MAC0_RCR - ENET RMAC0 eceive Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOOP           :  1;
        unsigned DRT            :  1;
        unsigned MII_MODE       :  1;
        unsigned PROM           :  1;
        unsigned BC_REJ         :  1;
        unsigned FCE            :  1;
        unsigned RGMII_ENA      :  1;
        unsigned SGMII_ENA      :  1;
        unsigned RMII_MODE      :  1;
        unsigned RMII_10T       :  1;
        unsigned RMII_LOOP      :  1;
        unsigned RMII_ECHO      :  1;
        unsigned PAD_EN         :  1;
        unsigned PAUSE_FWD      :  1;
        unsigned CRC_FWD        :  1;
        unsigned CNTL_FRM_ENA   :  1;
        unsigned MAX_FL         : 14;
        unsigned NO_LGTH_CHECK  :  1;
        unsigned GRS            :  1;
    } B;
} hw_enet_mac0_rcr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RCR register
 */
#define HW_ENET_MAC0_RCR_ADDR         (REGS_ENET_BASE + 0x84)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RCR           (*(volatile hw_enet_mac0_rcr_t *) HW_ENET_MAC0_RCR_ADDR)
#define HW_ENET_MAC0_RCR_RD()      (HW_ENET_MAC0_RCR.U)
#define HW_ENET_MAC0_RCR_WR(v)     (HW_ENET_MAC0_RCR.U = (v))
#define HW_ENET_MAC0_RCR_SET(v)    (HW_ENET_MAC0_RCR_WR(HW_ENET_MAC0_RCR_RD() |  (v)))
#define HW_ENET_MAC0_RCR_CLR(v)    (HW_ENET_MAC0_RCR_WR(HW_ENET_MAC0_RCR_RD() & ~(v)))
#define HW_ENET_MAC0_RCR_TOG(v)    (HW_ENET_MAC0_RCR_WR(HW_ENET_MAC0_RCR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RCR bitfields
 */
/* --- Register HW_ENET_MAC0_RCR, field GRS */

#define BP_ENET_MAC0_RCR_GRS      31
#define BM_ENET_MAC0_RCR_GRS      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RCR_GRS(v)   ((((reg32_t) v) << 31) & BM_ENET_MAC0_RCR_GRS)
#else
#define BF_ENET_MAC0_RCR_GRS(v)   (((v) << 31) & BM_ENET_MAC0_RCR_GRS)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_GRS(v)   BF_CS1(ENET_MAC0_RCR, GRS, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field NO_LGTH_CHECK */

#define BP_ENET_MAC0_RCR_NO_LGTH_CHECK      30
#define BM_ENET_MAC0_RCR_NO_LGTH_CHECK      0x40000000

#define BF_ENET_MAC0_RCR_NO_LGTH_CHECK(v)   (((v) << 30) & BM_ENET_MAC0_RCR_NO_LGTH_CHECK)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_NO_LGTH_CHECK(v)   BF_CS1(ENET_MAC0_RCR, NO_LGTH_CHECK, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field MAX_FL */

#define BP_ENET_MAC0_RCR_MAX_FL      16
#define BM_ENET_MAC0_RCR_MAX_FL      0x3FFF0000

#define BF_ENET_MAC0_RCR_MAX_FL(v)   (((v) << 16) & BM_ENET_MAC0_RCR_MAX_FL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_MAX_FL(v)   BF_CS1(ENET_MAC0_RCR, MAX_FL, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field CNTL_FRM_ENA */

#define BP_ENET_MAC0_RCR_CNTL_FRM_ENA      15
#define BM_ENET_MAC0_RCR_CNTL_FRM_ENA      0x00008000

#define BF_ENET_MAC0_RCR_CNTL_FRM_ENA(v)   (((v) << 15) & BM_ENET_MAC0_RCR_CNTL_FRM_ENA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_CNTL_FRM_ENA(v)   BF_CS1(ENET_MAC0_RCR, CNTL_FRM_ENA, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field CRC_FWD */

#define BP_ENET_MAC0_RCR_CRC_FWD      14
#define BM_ENET_MAC0_RCR_CRC_FWD      0x00004000

#define BF_ENET_MAC0_RCR_CRC_FWD(v)   (((v) << 14) & BM_ENET_MAC0_RCR_CRC_FWD)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_CRC_FWD(v)   BF_CS1(ENET_MAC0_RCR, CRC_FWD, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field PAUSE_FWD */

#define BP_ENET_MAC0_RCR_PAUSE_FWD      13
#define BM_ENET_MAC0_RCR_PAUSE_FWD      0x00002000

#define BF_ENET_MAC0_RCR_PAUSE_FWD(v)   (((v) << 13) & BM_ENET_MAC0_RCR_PAUSE_FWD)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_PAUSE_FWD(v)   BF_CS1(ENET_MAC0_RCR, PAUSE_FWD, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field PAD_EN */

#define BP_ENET_MAC0_RCR_PAD_EN      12
#define BM_ENET_MAC0_RCR_PAD_EN      0x00001000

#define BF_ENET_MAC0_RCR_PAD_EN(v)   (((v) << 12) & BM_ENET_MAC0_RCR_PAD_EN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_PAD_EN(v)   BF_CS1(ENET_MAC0_RCR, PAD_EN, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field RMII_ECHO */

#define BP_ENET_MAC0_RCR_RMII_ECHO      11
#define BM_ENET_MAC0_RCR_RMII_ECHO      0x00000800

#define BF_ENET_MAC0_RCR_RMII_ECHO(v)   (((v) << 11) & BM_ENET_MAC0_RCR_RMII_ECHO)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_RMII_ECHO(v)   BF_CS1(ENET_MAC0_RCR, RMII_ECHO, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field RMII_LOOP */

#define BP_ENET_MAC0_RCR_RMII_LOOP      10
#define BM_ENET_MAC0_RCR_RMII_LOOP      0x00000400

#define BF_ENET_MAC0_RCR_RMII_LOOP(v)   (((v) << 10) & BM_ENET_MAC0_RCR_RMII_LOOP)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_RMII_LOOP(v)   BF_CS1(ENET_MAC0_RCR, RMII_LOOP, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field RMII_10T */

#define BP_ENET_MAC0_RCR_RMII_10T      9
#define BM_ENET_MAC0_RCR_RMII_10T      0x00000200

#define BF_ENET_MAC0_RCR_RMII_10T(v)   (((v) << 9) & BM_ENET_MAC0_RCR_RMII_10T)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_RMII_10T(v)   BF_CS1(ENET_MAC0_RCR, RMII_10T, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field RMII_MODE */

#define BP_ENET_MAC0_RCR_RMII_MODE      8
#define BM_ENET_MAC0_RCR_RMII_MODE      0x00000100

#define BF_ENET_MAC0_RCR_RMII_MODE(v)   (((v) << 8) & BM_ENET_MAC0_RCR_RMII_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_RMII_MODE(v)   BF_CS1(ENET_MAC0_RCR, RMII_MODE, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field SGMII_ENA */

#define BP_ENET_MAC0_RCR_SGMII_ENA      7
#define BM_ENET_MAC0_RCR_SGMII_ENA      0x00000080

#define BF_ENET_MAC0_RCR_SGMII_ENA(v)   (((v) << 7) & BM_ENET_MAC0_RCR_SGMII_ENA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_SGMII_ENA(v)   BF_CS1(ENET_MAC0_RCR, SGMII_ENA, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field RGMII_ENA */

#define BP_ENET_MAC0_RCR_RGMII_ENA      6
#define BM_ENET_MAC0_RCR_RGMII_ENA      0x00000040

#define BF_ENET_MAC0_RCR_RGMII_ENA(v)   (((v) << 6) & BM_ENET_MAC0_RCR_RGMII_ENA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_RGMII_ENA(v)   BF_CS1(ENET_MAC0_RCR, RGMII_ENA, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field FCE */

#define BP_ENET_MAC0_RCR_FCE      5
#define BM_ENET_MAC0_RCR_FCE      0x00000020

#define BF_ENET_MAC0_RCR_FCE(v)   (((v) << 5) & BM_ENET_MAC0_RCR_FCE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_FCE(v)   BF_CS1(ENET_MAC0_RCR, FCE, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field BC_REJ */

#define BP_ENET_MAC0_RCR_BC_REJ      4
#define BM_ENET_MAC0_RCR_BC_REJ      0x00000010

#define BF_ENET_MAC0_RCR_BC_REJ(v)   (((v) << 4) & BM_ENET_MAC0_RCR_BC_REJ)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_BC_REJ(v)   BF_CS1(ENET_MAC0_RCR, BC_REJ, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field PROM */

#define BP_ENET_MAC0_RCR_PROM      3
#define BM_ENET_MAC0_RCR_PROM      0x00000008

#define BF_ENET_MAC0_RCR_PROM(v)   (((v) << 3) & BM_ENET_MAC0_RCR_PROM)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_PROM(v)   BF_CS1(ENET_MAC0_RCR, PROM, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field MII_MODE */

#define BP_ENET_MAC0_RCR_MII_MODE      2
#define BM_ENET_MAC0_RCR_MII_MODE      0x00000004

#define BF_ENET_MAC0_RCR_MII_MODE(v)   (((v) << 2) & BM_ENET_MAC0_RCR_MII_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_MII_MODE(v)   BF_CS1(ENET_MAC0_RCR, MII_MODE, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field DRT */

#define BP_ENET_MAC0_RCR_DRT      1
#define BM_ENET_MAC0_RCR_DRT      0x00000002

#define BF_ENET_MAC0_RCR_DRT(v)   (((v) << 1) & BM_ENET_MAC0_RCR_DRT)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_DRT(v)   BF_CS1(ENET_MAC0_RCR, DRT, v)
#endif

/* --- Register HW_ENET_MAC0_RCR, field LOOP */

#define BP_ENET_MAC0_RCR_LOOP      0
#define BM_ENET_MAC0_RCR_LOOP      0x00000001

#define BF_ENET_MAC0_RCR_LOOP(v)   (((v) << 0) & BM_ENET_MAC0_RCR_LOOP)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RCR_LOOP(v)   BF_CS1(ENET_MAC0_RCR, LOOP, v)
#endif



/*
 * HW_ENET_MAC0_TCR - ENET MAC0 Transmit Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned GTS          :  1;
        unsigned HBC          :  1;
        unsigned FEDN         :  1;
        unsigned TFC_PAUSE    :  1;
        unsigned RFC_PAUSE    :  1;
        unsigned TX_ADDR_SEL  :  3;
        unsigned TX_ADDR_INS  :  1;
        unsigned TX_CRC_FWD   :  1;
        unsigned RSRVD0       : 22;
    } B;
} hw_enet_mac0_tcr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_TCR register
 */
#define HW_ENET_MAC0_TCR_ADDR         (REGS_ENET_BASE + 0xc4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_TCR           (*(volatile hw_enet_mac0_tcr_t *) HW_ENET_MAC0_TCR_ADDR)
#define HW_ENET_MAC0_TCR_RD()      (HW_ENET_MAC0_TCR.U)
#define HW_ENET_MAC0_TCR_WR(v)     (HW_ENET_MAC0_TCR.U = (v))
#define HW_ENET_MAC0_TCR_SET(v)    (HW_ENET_MAC0_TCR_WR(HW_ENET_MAC0_TCR_RD() |  (v)))
#define HW_ENET_MAC0_TCR_CLR(v)    (HW_ENET_MAC0_TCR_WR(HW_ENET_MAC0_TCR_RD() & ~(v)))
#define HW_ENET_MAC0_TCR_TOG(v)    (HW_ENET_MAC0_TCR_WR(HW_ENET_MAC0_TCR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_TCR bitfields
 */
/* --- Register HW_ENET_MAC0_TCR, field RSRVD0 */

#define BP_ENET_MAC0_TCR_RSRVD0      10
#define BM_ENET_MAC0_TCR_RSRVD0      0xFFFFFC00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_TCR_RSRVD0(v)   ((((reg32_t) v) << 10) & BM_ENET_MAC0_TCR_RSRVD0)
#else
#define BF_ENET_MAC0_TCR_RSRVD0(v)   (((v) << 10) & BM_ENET_MAC0_TCR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_TCR, field TX_CRC_FWD */

#define BP_ENET_MAC0_TCR_TX_CRC_FWD      9
#define BM_ENET_MAC0_TCR_TX_CRC_FWD      0x00000200

#define BF_ENET_MAC0_TCR_TX_CRC_FWD(v)   (((v) << 9) & BM_ENET_MAC0_TCR_TX_CRC_FWD)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TCR_TX_CRC_FWD(v)   BF_CS1(ENET_MAC0_TCR, TX_CRC_FWD, v)
#endif

/* --- Register HW_ENET_MAC0_TCR, field TX_ADDR_INS */

#define BP_ENET_MAC0_TCR_TX_ADDR_INS      8
#define BM_ENET_MAC0_TCR_TX_ADDR_INS      0x00000100

#define BF_ENET_MAC0_TCR_TX_ADDR_INS(v)   (((v) << 8) & BM_ENET_MAC0_TCR_TX_ADDR_INS)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TCR_TX_ADDR_INS(v)   BF_CS1(ENET_MAC0_TCR, TX_ADDR_INS, v)
#endif

/* --- Register HW_ENET_MAC0_TCR, field TX_ADDR_SEL */

#define BP_ENET_MAC0_TCR_TX_ADDR_SEL      5
#define BM_ENET_MAC0_TCR_TX_ADDR_SEL      0x000000E0

#define BF_ENET_MAC0_TCR_TX_ADDR_SEL(v)   (((v) << 5) & BM_ENET_MAC0_TCR_TX_ADDR_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TCR_TX_ADDR_SEL(v)   BF_CS1(ENET_MAC0_TCR, TX_ADDR_SEL, v)
#endif

/* --- Register HW_ENET_MAC0_TCR, field RFC_PAUSE */

#define BP_ENET_MAC0_TCR_RFC_PAUSE      4
#define BM_ENET_MAC0_TCR_RFC_PAUSE      0x00000010

#define BF_ENET_MAC0_TCR_RFC_PAUSE(v)   (((v) << 4) & BM_ENET_MAC0_TCR_RFC_PAUSE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TCR_RFC_PAUSE(v)   BF_CS1(ENET_MAC0_TCR, RFC_PAUSE, v)
#endif

/* --- Register HW_ENET_MAC0_TCR, field TFC_PAUSE */

#define BP_ENET_MAC0_TCR_TFC_PAUSE      3
#define BM_ENET_MAC0_TCR_TFC_PAUSE      0x00000008

#define BF_ENET_MAC0_TCR_TFC_PAUSE(v)   (((v) << 3) & BM_ENET_MAC0_TCR_TFC_PAUSE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TCR_TFC_PAUSE(v)   BF_CS1(ENET_MAC0_TCR, TFC_PAUSE, v)
#endif

/* --- Register HW_ENET_MAC0_TCR, field FEDN */

#define BP_ENET_MAC0_TCR_FEDN      2
#define BM_ENET_MAC0_TCR_FEDN      0x00000004

#define BF_ENET_MAC0_TCR_FEDN(v)   (((v) << 2) & BM_ENET_MAC0_TCR_FEDN)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TCR_FEDN(v)   BF_CS1(ENET_MAC0_TCR, FEDN, v)
#endif

/* --- Register HW_ENET_MAC0_TCR, field HBC */

#define BP_ENET_MAC0_TCR_HBC      1
#define BM_ENET_MAC0_TCR_HBC      0x00000002

#define BF_ENET_MAC0_TCR_HBC(v)   (((v) << 1) & BM_ENET_MAC0_TCR_HBC)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TCR_HBC(v)   BF_CS1(ENET_MAC0_TCR, HBC, v)
#endif

/* --- Register HW_ENET_MAC0_TCR, field GTS */

#define BP_ENET_MAC0_TCR_GTS      0
#define BM_ENET_MAC0_TCR_GTS      0x00000001

#define BF_ENET_MAC0_TCR_GTS(v)   (((v) << 0) & BM_ENET_MAC0_TCR_GTS)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TCR_GTS(v)   BF_CS1(ENET_MAC0_TCR, GTS, v)
#endif



/*
 * HW_ENET_MAC0_PALR - ENET MAC0 Physical Address Low Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PADDR1  : 32;
    } B;
} hw_enet_mac0_palr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_PALR register
 */
#define HW_ENET_MAC0_PALR_ADDR         (REGS_ENET_BASE + 0xe4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_PALR           (*(volatile hw_enet_mac0_palr_t *) HW_ENET_MAC0_PALR_ADDR)
#define HW_ENET_MAC0_PALR_RD()      (HW_ENET_MAC0_PALR.U)
#define HW_ENET_MAC0_PALR_WR(v)     (HW_ENET_MAC0_PALR.U = (v))
#define HW_ENET_MAC0_PALR_SET(v)    (HW_ENET_MAC0_PALR_WR(HW_ENET_MAC0_PALR_RD() |  (v)))
#define HW_ENET_MAC0_PALR_CLR(v)    (HW_ENET_MAC0_PALR_WR(HW_ENET_MAC0_PALR_RD() & ~(v)))
#define HW_ENET_MAC0_PALR_TOG(v)    (HW_ENET_MAC0_PALR_WR(HW_ENET_MAC0_PALR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_PALR bitfields
 */
/* --- Register HW_ENET_MAC0_PALR, field PADDR1 */

#define BP_ENET_MAC0_PALR_PADDR1      0
#define BM_ENET_MAC0_PALR_PADDR1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_PALR_PADDR1(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_PALR_PADDR1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_PALR_PADDR1(v)   (HW_ENET_MAC0_PALR.B.PADDR1 = (v))
#endif



/*
 * HW_ENET_MAC0_PAUR - ENET MAC0 Physical Address High Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TYPE    : 16;
        unsigned PADDR2  : 16;
    } B;
} hw_enet_mac0_paur_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_PAUR register
 */
#define HW_ENET_MAC0_PAUR_ADDR         (REGS_ENET_BASE + 0xe8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_PAUR           (*(volatile hw_enet_mac0_paur_t *) HW_ENET_MAC0_PAUR_ADDR)
#define HW_ENET_MAC0_PAUR_RD()      (HW_ENET_MAC0_PAUR.U)
#define HW_ENET_MAC0_PAUR_WR(v)     (HW_ENET_MAC0_PAUR.U = (v))
#define HW_ENET_MAC0_PAUR_SET(v)    (HW_ENET_MAC0_PAUR_WR(HW_ENET_MAC0_PAUR_RD() |  (v)))
#define HW_ENET_MAC0_PAUR_CLR(v)    (HW_ENET_MAC0_PAUR_WR(HW_ENET_MAC0_PAUR_RD() & ~(v)))
#define HW_ENET_MAC0_PAUR_TOG(v)    (HW_ENET_MAC0_PAUR_WR(HW_ENET_MAC0_PAUR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_PAUR bitfields
 */
/* --- Register HW_ENET_MAC0_PAUR, field PADDR2 */

#define BP_ENET_MAC0_PAUR_PADDR2      16
#define BM_ENET_MAC0_PAUR_PADDR2      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_PAUR_PADDR2(v)   ((((reg32_t) v) << 16) & BM_ENET_MAC0_PAUR_PADDR2)
#else
#define BF_ENET_MAC0_PAUR_PADDR2(v)   (((v) << 16) & BM_ENET_MAC0_PAUR_PADDR2)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_PAUR_PADDR2(v)   (HW_ENET_MAC0_PAUR.B.PADDR2 = (v))
#endif

/* --- Register HW_ENET_MAC0_PAUR, field TYPE */

#define BP_ENET_MAC0_PAUR_TYPE      0
#define BM_ENET_MAC0_PAUR_TYPE      0x0000FFFF

#define BF_ENET_MAC0_PAUR_TYPE(v)   (((v) << 0) & BM_ENET_MAC0_PAUR_TYPE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_PAUR_TYPE(v)   (HW_ENET_MAC0_PAUR.B.TYPE = (v))
#endif



/*
 * HW_ENET_MAC0_OPD - ENET MAC0 Opcode/Pause Duration Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PAUSE_DUR  : 16;
        unsigned OPCODE     : 16;
    } B;
} hw_enet_mac0_opd_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_OPD register
 */
#define HW_ENET_MAC0_OPD_ADDR         (REGS_ENET_BASE + 0xec)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_OPD           (*(volatile hw_enet_mac0_opd_t *) HW_ENET_MAC0_OPD_ADDR)
#define HW_ENET_MAC0_OPD_RD()      (HW_ENET_MAC0_OPD.U)
#define HW_ENET_MAC0_OPD_WR(v)     (HW_ENET_MAC0_OPD.U = (v))
#define HW_ENET_MAC0_OPD_SET(v)    (HW_ENET_MAC0_OPD_WR(HW_ENET_MAC0_OPD_RD() |  (v)))
#define HW_ENET_MAC0_OPD_CLR(v)    (HW_ENET_MAC0_OPD_WR(HW_ENET_MAC0_OPD_RD() & ~(v)))
#define HW_ENET_MAC0_OPD_TOG(v)    (HW_ENET_MAC0_OPD_WR(HW_ENET_MAC0_OPD_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_OPD bitfields
 */
/* --- Register HW_ENET_MAC0_OPD, field OPCODE */

#define BP_ENET_MAC0_OPD_OPCODE      16
#define BM_ENET_MAC0_OPD_OPCODE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_OPD_OPCODE(v)   ((((reg32_t) v) << 16) & BM_ENET_MAC0_OPD_OPCODE)
#else
#define BF_ENET_MAC0_OPD_OPCODE(v)   (((v) << 16) & BM_ENET_MAC0_OPD_OPCODE)
#endif
/* --- Register HW_ENET_MAC0_OPD, field PAUSE_DUR */

#define BP_ENET_MAC0_OPD_PAUSE_DUR      0
#define BM_ENET_MAC0_OPD_PAUSE_DUR      0x0000FFFF

#define BF_ENET_MAC0_OPD_PAUSE_DUR(v)   (((v) << 0) & BM_ENET_MAC0_OPD_PAUSE_DUR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_OPD_PAUSE_DUR(v)   (HW_ENET_MAC0_OPD.B.PAUSE_DUR = (v))
#endif



/*
 * HW_ENET_MAC0_IAUR - ENET MAC0 Descriptor Individual Upper Address Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IADDR1  : 32;
    } B;
} hw_enet_mac0_iaur_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IAUR register
 */
#define HW_ENET_MAC0_IAUR_ADDR         (REGS_ENET_BASE + 0x118)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IAUR           (*(volatile hw_enet_mac0_iaur_t *) HW_ENET_MAC0_IAUR_ADDR)
#define HW_ENET_MAC0_IAUR_RD()      (HW_ENET_MAC0_IAUR.U)
#define HW_ENET_MAC0_IAUR_WR(v)     (HW_ENET_MAC0_IAUR.U = (v))
#define HW_ENET_MAC0_IAUR_SET(v)    (HW_ENET_MAC0_IAUR_WR(HW_ENET_MAC0_IAUR_RD() |  (v)))
#define HW_ENET_MAC0_IAUR_CLR(v)    (HW_ENET_MAC0_IAUR_WR(HW_ENET_MAC0_IAUR_RD() & ~(v)))
#define HW_ENET_MAC0_IAUR_TOG(v)    (HW_ENET_MAC0_IAUR_WR(HW_ENET_MAC0_IAUR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IAUR bitfields
 */
/* --- Register HW_ENET_MAC0_IAUR, field IADDR1 */

#define BP_ENET_MAC0_IAUR_IADDR1      0
#define BM_ENET_MAC0_IAUR_IADDR1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IAUR_IADDR1(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IAUR_IADDR1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IAUR_IADDR1(v)   (HW_ENET_MAC0_IAUR.B.IADDR1 = (v))
#endif



/*
 * HW_ENET_MAC0_IALR - ENET MAC0 Descriptor Individual Lower Address Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IADDR2  : 32;
    } B;
} hw_enet_mac0_ialr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IALR register
 */
#define HW_ENET_MAC0_IALR_ADDR         (REGS_ENET_BASE + 0x11c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IALR           (*(volatile hw_enet_mac0_ialr_t *) HW_ENET_MAC0_IALR_ADDR)
#define HW_ENET_MAC0_IALR_RD()      (HW_ENET_MAC0_IALR.U)
#define HW_ENET_MAC0_IALR_WR(v)     (HW_ENET_MAC0_IALR.U = (v))
#define HW_ENET_MAC0_IALR_SET(v)    (HW_ENET_MAC0_IALR_WR(HW_ENET_MAC0_IALR_RD() |  (v)))
#define HW_ENET_MAC0_IALR_CLR(v)    (HW_ENET_MAC0_IALR_WR(HW_ENET_MAC0_IALR_RD() & ~(v)))
#define HW_ENET_MAC0_IALR_TOG(v)    (HW_ENET_MAC0_IALR_WR(HW_ENET_MAC0_IALR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IALR bitfields
 */
/* --- Register HW_ENET_MAC0_IALR, field IADDR2 */

#define BP_ENET_MAC0_IALR_IADDR2      0
#define BM_ENET_MAC0_IALR_IADDR2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IALR_IADDR2(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IALR_IADDR2(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IALR_IADDR2(v)   (HW_ENET_MAC0_IALR.B.IADDR2 = (v))
#endif



/*
 * HW_ENET_MAC0_GAUR - ENET MAC0 Descriptor Group Upper Address Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned GADDR1  : 32;
    } B;
} hw_enet_mac0_gaur_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_GAUR register
 */
#define HW_ENET_MAC0_GAUR_ADDR         (REGS_ENET_BASE + 0x120)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_GAUR           (*(volatile hw_enet_mac0_gaur_t *) HW_ENET_MAC0_GAUR_ADDR)
#define HW_ENET_MAC0_GAUR_RD()      (HW_ENET_MAC0_GAUR.U)
#define HW_ENET_MAC0_GAUR_WR(v)     (HW_ENET_MAC0_GAUR.U = (v))
#define HW_ENET_MAC0_GAUR_SET(v)    (HW_ENET_MAC0_GAUR_WR(HW_ENET_MAC0_GAUR_RD() |  (v)))
#define HW_ENET_MAC0_GAUR_CLR(v)    (HW_ENET_MAC0_GAUR_WR(HW_ENET_MAC0_GAUR_RD() & ~(v)))
#define HW_ENET_MAC0_GAUR_TOG(v)    (HW_ENET_MAC0_GAUR_WR(HW_ENET_MAC0_GAUR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_GAUR bitfields
 */
/* --- Register HW_ENET_MAC0_GAUR, field GADDR1 */

#define BP_ENET_MAC0_GAUR_GADDR1      0
#define BM_ENET_MAC0_GAUR_GADDR1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_GAUR_GADDR1(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_GAUR_GADDR1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_GAUR_GADDR1(v)   (HW_ENET_MAC0_GAUR.B.GADDR1 = (v))
#endif



/*
 * HW_ENET_MAC0_GALR - ENET MAC0 Descriptor Group Lower Address Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned GADDR2  : 32;
    } B;
} hw_enet_mac0_galr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_GALR register
 */
#define HW_ENET_MAC0_GALR_ADDR         (REGS_ENET_BASE + 0x124)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_GALR           (*(volatile hw_enet_mac0_galr_t *) HW_ENET_MAC0_GALR_ADDR)
#define HW_ENET_MAC0_GALR_RD()      (HW_ENET_MAC0_GALR.U)
#define HW_ENET_MAC0_GALR_WR(v)     (HW_ENET_MAC0_GALR.U = (v))
#define HW_ENET_MAC0_GALR_SET(v)    (HW_ENET_MAC0_GALR_WR(HW_ENET_MAC0_GALR_RD() |  (v)))
#define HW_ENET_MAC0_GALR_CLR(v)    (HW_ENET_MAC0_GALR_WR(HW_ENET_MAC0_GALR_RD() & ~(v)))
#define HW_ENET_MAC0_GALR_TOG(v)    (HW_ENET_MAC0_GALR_WR(HW_ENET_MAC0_GALR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_GALR bitfields
 */
/* --- Register HW_ENET_MAC0_GALR, field GADDR2 */

#define BP_ENET_MAC0_GALR_GADDR2      0
#define BM_ENET_MAC0_GALR_GADDR2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_GALR_GADDR2(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_GALR_GADDR2(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_GALR_GADDR2(v)   (HW_ENET_MAC0_GALR.B.GADDR2 = (v))
#endif



/*
 * HW_ENET_MAC0_TFW_SFCR - ENET MAC0 Transmit FIFO Watermark and Store and Forward Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TFWR     :  6;
        unsigned RSRVD1   :  2;
        unsigned STR_FWD  :  1;
        unsigned RSRVD0   : 23;
    } B;
} hw_enet_mac0_tfw_sfcr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_TFW_SFCR register
 */
#define HW_ENET_MAC0_TFW_SFCR_ADDR         (REGS_ENET_BASE + 0x144)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_TFW_SFCR           (*(volatile hw_enet_mac0_tfw_sfcr_t *) HW_ENET_MAC0_TFW_SFCR_ADDR)
#define HW_ENET_MAC0_TFW_SFCR_RD()      (HW_ENET_MAC0_TFW_SFCR.U)
#define HW_ENET_MAC0_TFW_SFCR_WR(v)     (HW_ENET_MAC0_TFW_SFCR.U = (v))
#define HW_ENET_MAC0_TFW_SFCR_SET(v)    (HW_ENET_MAC0_TFW_SFCR_WR(HW_ENET_MAC0_TFW_SFCR_RD() |  (v)))
#define HW_ENET_MAC0_TFW_SFCR_CLR(v)    (HW_ENET_MAC0_TFW_SFCR_WR(HW_ENET_MAC0_TFW_SFCR_RD() & ~(v)))
#define HW_ENET_MAC0_TFW_SFCR_TOG(v)    (HW_ENET_MAC0_TFW_SFCR_WR(HW_ENET_MAC0_TFW_SFCR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_TFW_SFCR bitfields
 */
/* --- Register HW_ENET_MAC0_TFW_SFCR, field RSRVD0 */

#define BP_ENET_MAC0_TFW_SFCR_RSRVD0      9
#define BM_ENET_MAC0_TFW_SFCR_RSRVD0      0xFFFFFE00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_TFW_SFCR_RSRVD0(v)   ((((reg32_t) v) << 9) & BM_ENET_MAC0_TFW_SFCR_RSRVD0)
#else
#define BF_ENET_MAC0_TFW_SFCR_RSRVD0(v)   (((v) << 9) & BM_ENET_MAC0_TFW_SFCR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_TFW_SFCR, field STR_FWD */

#define BP_ENET_MAC0_TFW_SFCR_STR_FWD      8
#define BM_ENET_MAC0_TFW_SFCR_STR_FWD      0x00000100

#define BF_ENET_MAC0_TFW_SFCR_STR_FWD(v)   (((v) << 8) & BM_ENET_MAC0_TFW_SFCR_STR_FWD)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TFW_SFCR_STR_FWD(v)   BF_CS1(ENET_MAC0_TFW_SFCR, STR_FWD, v)
#endif

/* --- Register HW_ENET_MAC0_TFW_SFCR, field RSRVD1 */

#define BP_ENET_MAC0_TFW_SFCR_RSRVD1      6
#define BM_ENET_MAC0_TFW_SFCR_RSRVD1      0x000000C0

#define BF_ENET_MAC0_TFW_SFCR_RSRVD1(v)   (((v) << 6) & BM_ENET_MAC0_TFW_SFCR_RSRVD1)
/* --- Register HW_ENET_MAC0_TFW_SFCR, field TFWR */

#define BP_ENET_MAC0_TFW_SFCR_TFWR      0
#define BM_ENET_MAC0_TFW_SFCR_TFWR      0x0000003F

#define BF_ENET_MAC0_TFW_SFCR_TFWR(v)   (((v) << 0) & BM_ENET_MAC0_TFW_SFCR_TFWR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TFW_SFCR_TFWR(v)   BF_CS1(ENET_MAC0_TFW_SFCR, TFWR, v)
#endif



/*
 * HW_ENET_MAC0_FRBR - ENET MAC0 FIFO Receive Bound Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1   :  2;
        unsigned R_BOUND  :  8;
        unsigned RSRVD0   : 22;
    } B;
} hw_enet_mac0_frbr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_FRBR register
 */
#define HW_ENET_MAC0_FRBR_ADDR         (REGS_ENET_BASE + 0x14c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_FRBR           (*(volatile hw_enet_mac0_frbr_t *) HW_ENET_MAC0_FRBR_ADDR)
#define HW_ENET_MAC0_FRBR_RD()      (HW_ENET_MAC0_FRBR.U)
#define HW_ENET_MAC0_FRBR_WR(v)     (HW_ENET_MAC0_FRBR.U = (v))
#define HW_ENET_MAC0_FRBR_SET(v)    (HW_ENET_MAC0_FRBR_WR(HW_ENET_MAC0_FRBR_RD() |  (v)))
#define HW_ENET_MAC0_FRBR_CLR(v)    (HW_ENET_MAC0_FRBR_WR(HW_ENET_MAC0_FRBR_RD() & ~(v)))
#define HW_ENET_MAC0_FRBR_TOG(v)    (HW_ENET_MAC0_FRBR_WR(HW_ENET_MAC0_FRBR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_FRBR bitfields
 */
/* --- Register HW_ENET_MAC0_FRBR, field RSRVD0 */

#define BP_ENET_MAC0_FRBR_RSRVD0      10
#define BM_ENET_MAC0_FRBR_RSRVD0      0xFFFFFC00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_FRBR_RSRVD0(v)   ((((reg32_t) v) << 10) & BM_ENET_MAC0_FRBR_RSRVD0)
#else
#define BF_ENET_MAC0_FRBR_RSRVD0(v)   (((v) << 10) & BM_ENET_MAC0_FRBR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_FRBR, field R_BOUND */

#define BP_ENET_MAC0_FRBR_R_BOUND      2
#define BM_ENET_MAC0_FRBR_R_BOUND      0x000003FC

#define BF_ENET_MAC0_FRBR_R_BOUND(v)   (((v) << 2) & BM_ENET_MAC0_FRBR_R_BOUND)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_FRBR_R_BOUND(v)   BF_CS1(ENET_MAC0_FRBR, R_BOUND, v)
#endif

/* --- Register HW_ENET_MAC0_FRBR, field RSRVD1 */

#define BP_ENET_MAC0_FRBR_RSRVD1      0
#define BM_ENET_MAC0_FRBR_RSRVD1      0x00000003

#define BF_ENET_MAC0_FRBR_RSRVD1(v)   (((v) << 0) & BM_ENET_MAC0_FRBR_RSRVD1)


/*
 * HW_ENET_MAC0_FRSR - ENET MAC0 FIFO Receive FIFO Start Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD2    :  2;
        unsigned R_FSTART  :  8;
        unsigned RSRVD1    :  1;
        unsigned RSRVD0    : 21;
    } B;
} hw_enet_mac0_frsr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_FRSR register
 */
#define HW_ENET_MAC0_FRSR_ADDR         (REGS_ENET_BASE + 0x150)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_FRSR           (*(volatile hw_enet_mac0_frsr_t *) HW_ENET_MAC0_FRSR_ADDR)
#define HW_ENET_MAC0_FRSR_RD()      (HW_ENET_MAC0_FRSR.U)
#define HW_ENET_MAC0_FRSR_WR(v)     (HW_ENET_MAC0_FRSR.U = (v))
#define HW_ENET_MAC0_FRSR_SET(v)    (HW_ENET_MAC0_FRSR_WR(HW_ENET_MAC0_FRSR_RD() |  (v)))
#define HW_ENET_MAC0_FRSR_CLR(v)    (HW_ENET_MAC0_FRSR_WR(HW_ENET_MAC0_FRSR_RD() & ~(v)))
#define HW_ENET_MAC0_FRSR_TOG(v)    (HW_ENET_MAC0_FRSR_WR(HW_ENET_MAC0_FRSR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_FRSR bitfields
 */
/* --- Register HW_ENET_MAC0_FRSR, field RSRVD0 */

#define BP_ENET_MAC0_FRSR_RSRVD0      11
#define BM_ENET_MAC0_FRSR_RSRVD0      0xFFFFF800

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_FRSR_RSRVD0(v)   ((((reg32_t) v) << 11) & BM_ENET_MAC0_FRSR_RSRVD0)
#else
#define BF_ENET_MAC0_FRSR_RSRVD0(v)   (((v) << 11) & BM_ENET_MAC0_FRSR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_FRSR, field RSRVD1 */

#define BP_ENET_MAC0_FRSR_RSRVD1      10
#define BM_ENET_MAC0_FRSR_RSRVD1      0x00000400

#define BF_ENET_MAC0_FRSR_RSRVD1(v)   (((v) << 10) & BM_ENET_MAC0_FRSR_RSRVD1)
/* --- Register HW_ENET_MAC0_FRSR, field R_FSTART */

#define BP_ENET_MAC0_FRSR_R_FSTART      2
#define BM_ENET_MAC0_FRSR_R_FSTART      0x000003FC

#define BF_ENET_MAC0_FRSR_R_FSTART(v)   (((v) << 2) & BM_ENET_MAC0_FRSR_R_FSTART)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_FRSR_R_FSTART(v)   BF_CS1(ENET_MAC0_FRSR, R_FSTART, v)
#endif

/* --- Register HW_ENET_MAC0_FRSR, field RSRVD2 */

#define BP_ENET_MAC0_FRSR_RSRVD2      0
#define BM_ENET_MAC0_FRSR_RSRVD2      0x00000003

#define BF_ENET_MAC0_FRSR_RSRVD2(v)   (((v) << 0) & BM_ENET_MAC0_FRSR_RSRVD2)


/*
 * HW_ENET_MAC0_ERDSR - ENET MAC0 Pointer to Receive Descriptor Ring Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0       :  2;
        unsigned R_DES_START  : 30;
    } B;
} hw_enet_mac0_erdsr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_ERDSR register
 */
#define HW_ENET_MAC0_ERDSR_ADDR         (REGS_ENET_BASE + 0x180)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_ERDSR           (*(volatile hw_enet_mac0_erdsr_t *) HW_ENET_MAC0_ERDSR_ADDR)
#define HW_ENET_MAC0_ERDSR_RD()      (HW_ENET_MAC0_ERDSR.U)
#define HW_ENET_MAC0_ERDSR_WR(v)     (HW_ENET_MAC0_ERDSR.U = (v))
#define HW_ENET_MAC0_ERDSR_SET(v)    (HW_ENET_MAC0_ERDSR_WR(HW_ENET_MAC0_ERDSR_RD() |  (v)))
#define HW_ENET_MAC0_ERDSR_CLR(v)    (HW_ENET_MAC0_ERDSR_WR(HW_ENET_MAC0_ERDSR_RD() & ~(v)))
#define HW_ENET_MAC0_ERDSR_TOG(v)    (HW_ENET_MAC0_ERDSR_WR(HW_ENET_MAC0_ERDSR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_ERDSR bitfields
 */
/* --- Register HW_ENET_MAC0_ERDSR, field R_DES_START */

#define BP_ENET_MAC0_ERDSR_R_DES_START      2
#define BM_ENET_MAC0_ERDSR_R_DES_START      0xFFFFFFFC

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_ERDSR_R_DES_START(v)   ((((reg32_t) v) << 2) & BM_ENET_MAC0_ERDSR_R_DES_START)
#else
#define BF_ENET_MAC0_ERDSR_R_DES_START(v)   (((v) << 2) & BM_ENET_MAC0_ERDSR_R_DES_START)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ERDSR_R_DES_START(v)   BF_CS1(ENET_MAC0_ERDSR, R_DES_START, v)
#endif

/* --- Register HW_ENET_MAC0_ERDSR, field RSRVD0 */

#define BP_ENET_MAC0_ERDSR_RSRVD0      0
#define BM_ENET_MAC0_ERDSR_RSRVD0      0x00000003

#define BF_ENET_MAC0_ERDSR_RSRVD0(v)   (((v) << 0) & BM_ENET_MAC0_ERDSR_RSRVD0)


/*
 * HW_ENET_MAC0_ETDSR - ENET MAC0 Pointer to Transmit Descriptor Ring Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0       :  2;
        unsigned X_DES_START  : 30;
    } B;
} hw_enet_mac0_etdsr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_ETDSR register
 */
#define HW_ENET_MAC0_ETDSR_ADDR         (REGS_ENET_BASE + 0x184)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_ETDSR           (*(volatile hw_enet_mac0_etdsr_t *) HW_ENET_MAC0_ETDSR_ADDR)
#define HW_ENET_MAC0_ETDSR_RD()      (HW_ENET_MAC0_ETDSR.U)
#define HW_ENET_MAC0_ETDSR_WR(v)     (HW_ENET_MAC0_ETDSR.U = (v))
#define HW_ENET_MAC0_ETDSR_SET(v)    (HW_ENET_MAC0_ETDSR_WR(HW_ENET_MAC0_ETDSR_RD() |  (v)))
#define HW_ENET_MAC0_ETDSR_CLR(v)    (HW_ENET_MAC0_ETDSR_WR(HW_ENET_MAC0_ETDSR_RD() & ~(v)))
#define HW_ENET_MAC0_ETDSR_TOG(v)    (HW_ENET_MAC0_ETDSR_WR(HW_ENET_MAC0_ETDSR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_ETDSR bitfields
 */
/* --- Register HW_ENET_MAC0_ETDSR, field X_DES_START */

#define BP_ENET_MAC0_ETDSR_X_DES_START      2
#define BM_ENET_MAC0_ETDSR_X_DES_START      0xFFFFFFFC

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_ETDSR_X_DES_START(v)   ((((reg32_t) v) << 2) & BM_ENET_MAC0_ETDSR_X_DES_START)
#else
#define BF_ENET_MAC0_ETDSR_X_DES_START(v)   (((v) << 2) & BM_ENET_MAC0_ETDSR_X_DES_START)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ETDSR_X_DES_START(v)   BF_CS1(ENET_MAC0_ETDSR, X_DES_START, v)
#endif

/* --- Register HW_ENET_MAC0_ETDSR, field RSRVD0 */

#define BP_ENET_MAC0_ETDSR_RSRVD0      0
#define BM_ENET_MAC0_ETDSR_RSRVD0      0x00000003

#define BF_ENET_MAC0_ETDSR_RSRVD0(v)   (((v) << 0) & BM_ENET_MAC0_ETDSR_RSRVD0)


/*
 * HW_ENET_MAC0_EMRBR - ENET MAC0 Maximum Receive Buffer Size Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1      :  4;
        unsigned R_BUF_SIZE  :  7;
        unsigned RSRVD0      : 21;
    } B;
} hw_enet_mac0_emrbr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_EMRBR register
 */
#define HW_ENET_MAC0_EMRBR_ADDR         (REGS_ENET_BASE + 0x188)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_EMRBR           (*(volatile hw_enet_mac0_emrbr_t *) HW_ENET_MAC0_EMRBR_ADDR)
#define HW_ENET_MAC0_EMRBR_RD()      (HW_ENET_MAC0_EMRBR.U)
#define HW_ENET_MAC0_EMRBR_WR(v)     (HW_ENET_MAC0_EMRBR.U = (v))
#define HW_ENET_MAC0_EMRBR_SET(v)    (HW_ENET_MAC0_EMRBR_WR(HW_ENET_MAC0_EMRBR_RD() |  (v)))
#define HW_ENET_MAC0_EMRBR_CLR(v)    (HW_ENET_MAC0_EMRBR_WR(HW_ENET_MAC0_EMRBR_RD() & ~(v)))
#define HW_ENET_MAC0_EMRBR_TOG(v)    (HW_ENET_MAC0_EMRBR_WR(HW_ENET_MAC0_EMRBR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_EMRBR bitfields
 */
/* --- Register HW_ENET_MAC0_EMRBR, field RSRVD0 */

#define BP_ENET_MAC0_EMRBR_RSRVD0      11
#define BM_ENET_MAC0_EMRBR_RSRVD0      0xFFFFF800

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_EMRBR_RSRVD0(v)   ((((reg32_t) v) << 11) & BM_ENET_MAC0_EMRBR_RSRVD0)
#else
#define BF_ENET_MAC0_EMRBR_RSRVD0(v)   (((v) << 11) & BM_ENET_MAC0_EMRBR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_EMRBR, field R_BUF_SIZE */

#define BP_ENET_MAC0_EMRBR_R_BUF_SIZE      4
#define BM_ENET_MAC0_EMRBR_R_BUF_SIZE      0x000007F0

#define BF_ENET_MAC0_EMRBR_R_BUF_SIZE(v)   (((v) << 4) & BM_ENET_MAC0_EMRBR_R_BUF_SIZE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_EMRBR_R_BUF_SIZE(v)   BF_CS1(ENET_MAC0_EMRBR, R_BUF_SIZE, v)
#endif

/* --- Register HW_ENET_MAC0_EMRBR, field RSRVD1 */

#define BP_ENET_MAC0_EMRBR_RSRVD1      0
#define BM_ENET_MAC0_EMRBR_RSRVD1      0x0000000F

#define BF_ENET_MAC0_EMRBR_RSRVD1(v)   (((v) << 0) & BM_ENET_MAC0_EMRBR_RSRVD1)


/*
 * HW_ENET_MAC0_RX_SECTION_FULL - ENET MAC0 Receive FIFO Section Full Threshold Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RX_SECTION_FULL  :  8;
        unsigned RSRVD0           : 24;
    } B;
} hw_enet_mac0_rx_section_full_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RX_SECTION_FULL register
 */
#define HW_ENET_MAC0_RX_SECTION_FULL_ADDR         (REGS_ENET_BASE + 0x190)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RX_SECTION_FULL           (*(volatile hw_enet_mac0_rx_section_full_t *) HW_ENET_MAC0_RX_SECTION_FULL_ADDR)
#define HW_ENET_MAC0_RX_SECTION_FULL_RD()      (HW_ENET_MAC0_RX_SECTION_FULL.U)
#define HW_ENET_MAC0_RX_SECTION_FULL_WR(v)     (HW_ENET_MAC0_RX_SECTION_FULL.U = (v))
#define HW_ENET_MAC0_RX_SECTION_FULL_SET(v)    (HW_ENET_MAC0_RX_SECTION_FULL_WR(HW_ENET_MAC0_RX_SECTION_FULL_RD() |  (v)))
#define HW_ENET_MAC0_RX_SECTION_FULL_CLR(v)    (HW_ENET_MAC0_RX_SECTION_FULL_WR(HW_ENET_MAC0_RX_SECTION_FULL_RD() & ~(v)))
#define HW_ENET_MAC0_RX_SECTION_FULL_TOG(v)    (HW_ENET_MAC0_RX_SECTION_FULL_WR(HW_ENET_MAC0_RX_SECTION_FULL_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RX_SECTION_FULL bitfields
 */
/* --- Register HW_ENET_MAC0_RX_SECTION_FULL, field RSRVD0 */

#define BP_ENET_MAC0_RX_SECTION_FULL_RSRVD0      8
#define BM_ENET_MAC0_RX_SECTION_FULL_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RX_SECTION_FULL_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_MAC0_RX_SECTION_FULL_RSRVD0)
#else
#define BF_ENET_MAC0_RX_SECTION_FULL_RSRVD0(v)   (((v) << 8) & BM_ENET_MAC0_RX_SECTION_FULL_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_RX_SECTION_FULL, field RX_SECTION_FULL */

#define BP_ENET_MAC0_RX_SECTION_FULL_RX_SECTION_FULL      0
#define BM_ENET_MAC0_RX_SECTION_FULL_RX_SECTION_FULL      0x000000FF

#define BF_ENET_MAC0_RX_SECTION_FULL_RX_SECTION_FULL(v)   (((v) << 0) & BM_ENET_MAC0_RX_SECTION_FULL_RX_SECTION_FULL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RX_SECTION_FULL_RX_SECTION_FULL(v)   (HW_ENET_MAC0_RX_SECTION_FULL.B.RX_SECTION_FULL = (v))
#endif



/*
 * HW_ENET_MAC0_RX_SECTION_EMPTY - ENET MAC0 Receive FIFO Section Empty Threshold Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RX_SECTION_EMPTY  :  8;
        unsigned RSRVD0            : 24;
    } B;
} hw_enet_mac0_rx_section_empty_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RX_SECTION_EMPTY register
 */
#define HW_ENET_MAC0_RX_SECTION_EMPTY_ADDR         (REGS_ENET_BASE + 0x194)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RX_SECTION_EMPTY           (*(volatile hw_enet_mac0_rx_section_empty_t *) HW_ENET_MAC0_RX_SECTION_EMPTY_ADDR)
#define HW_ENET_MAC0_RX_SECTION_EMPTY_RD()      (HW_ENET_MAC0_RX_SECTION_EMPTY.U)
#define HW_ENET_MAC0_RX_SECTION_EMPTY_WR(v)     (HW_ENET_MAC0_RX_SECTION_EMPTY.U = (v))
#define HW_ENET_MAC0_RX_SECTION_EMPTY_SET(v)    (HW_ENET_MAC0_RX_SECTION_EMPTY_WR(HW_ENET_MAC0_RX_SECTION_EMPTY_RD() |  (v)))
#define HW_ENET_MAC0_RX_SECTION_EMPTY_CLR(v)    (HW_ENET_MAC0_RX_SECTION_EMPTY_WR(HW_ENET_MAC0_RX_SECTION_EMPTY_RD() & ~(v)))
#define HW_ENET_MAC0_RX_SECTION_EMPTY_TOG(v)    (HW_ENET_MAC0_RX_SECTION_EMPTY_WR(HW_ENET_MAC0_RX_SECTION_EMPTY_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RX_SECTION_EMPTY bitfields
 */
/* --- Register HW_ENET_MAC0_RX_SECTION_EMPTY, field RSRVD0 */

#define BP_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0      8
#define BM_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0)
#else
#define BF_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0(v)   (((v) << 8) & BM_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_RX_SECTION_EMPTY, field RX_SECTION_EMPTY */

#define BP_ENET_MAC0_RX_SECTION_EMPTY_RX_SECTION_EMPTY      0
#define BM_ENET_MAC0_RX_SECTION_EMPTY_RX_SECTION_EMPTY      0x000000FF

#define BF_ENET_MAC0_RX_SECTION_EMPTY_RX_SECTION_EMPTY(v)   (((v) << 0) & BM_ENET_MAC0_RX_SECTION_EMPTY_RX_SECTION_EMPTY)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RX_SECTION_EMPTY_RX_SECTION_EMPTY(v)   (HW_ENET_MAC0_RX_SECTION_EMPTY.B.RX_SECTION_EMPTY = (v))
#endif



/*
 * HW_ENET_MAC0_RX_ALMOST_EMPTY - ENET MAC0 Receive FIFO Almost Empty Threshold Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RX_ALMOST_EMPTY  :  8;
        unsigned RSRVD0           : 24;
    } B;
} hw_enet_mac0_rx_almost_empty_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RX_ALMOST_EMPTY register
 */
#define HW_ENET_MAC0_RX_ALMOST_EMPTY_ADDR         (REGS_ENET_BASE + 0x198)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RX_ALMOST_EMPTY           (*(volatile hw_enet_mac0_rx_almost_empty_t *) HW_ENET_MAC0_RX_ALMOST_EMPTY_ADDR)
#define HW_ENET_MAC0_RX_ALMOST_EMPTY_RD()      (HW_ENET_MAC0_RX_ALMOST_EMPTY.U)
#define HW_ENET_MAC0_RX_ALMOST_EMPTY_WR(v)     (HW_ENET_MAC0_RX_ALMOST_EMPTY.U = (v))
#define HW_ENET_MAC0_RX_ALMOST_EMPTY_SET(v)    (HW_ENET_MAC0_RX_ALMOST_EMPTY_WR(HW_ENET_MAC0_RX_ALMOST_EMPTY_RD() |  (v)))
#define HW_ENET_MAC0_RX_ALMOST_EMPTY_CLR(v)    (HW_ENET_MAC0_RX_ALMOST_EMPTY_WR(HW_ENET_MAC0_RX_ALMOST_EMPTY_RD() & ~(v)))
#define HW_ENET_MAC0_RX_ALMOST_EMPTY_TOG(v)    (HW_ENET_MAC0_RX_ALMOST_EMPTY_WR(HW_ENET_MAC0_RX_ALMOST_EMPTY_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RX_ALMOST_EMPTY bitfields
 */
/* --- Register HW_ENET_MAC0_RX_ALMOST_EMPTY, field RSRVD0 */

#define BP_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0      8
#define BM_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0)
#else
#define BF_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0(v)   (((v) << 8) & BM_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_RX_ALMOST_EMPTY, field RX_ALMOST_EMPTY */

#define BP_ENET_MAC0_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY      0
#define BM_ENET_MAC0_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY      0x000000FF

#define BF_ENET_MAC0_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY(v)   (((v) << 0) & BM_ENET_MAC0_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY(v)   (HW_ENET_MAC0_RX_ALMOST_EMPTY.B.RX_ALMOST_EMPTY = (v))
#endif



/*
 * HW_ENET_MAC0_RX_ALMOST_FULL - ENET MAC0 Receive FIFO Almost Full Thresholdt Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RX_ALMOST_FULL  :  8;
        unsigned RSRVD0          : 24;
    } B;
} hw_enet_mac0_rx_almost_full_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RX_ALMOST_FULL register
 */
#define HW_ENET_MAC0_RX_ALMOST_FULL_ADDR         (REGS_ENET_BASE + 0x19c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RX_ALMOST_FULL           (*(volatile hw_enet_mac0_rx_almost_full_t *) HW_ENET_MAC0_RX_ALMOST_FULL_ADDR)
#define HW_ENET_MAC0_RX_ALMOST_FULL_RD()      (HW_ENET_MAC0_RX_ALMOST_FULL.U)
#define HW_ENET_MAC0_RX_ALMOST_FULL_WR(v)     (HW_ENET_MAC0_RX_ALMOST_FULL.U = (v))
#define HW_ENET_MAC0_RX_ALMOST_FULL_SET(v)    (HW_ENET_MAC0_RX_ALMOST_FULL_WR(HW_ENET_MAC0_RX_ALMOST_FULL_RD() |  (v)))
#define HW_ENET_MAC0_RX_ALMOST_FULL_CLR(v)    (HW_ENET_MAC0_RX_ALMOST_FULL_WR(HW_ENET_MAC0_RX_ALMOST_FULL_RD() & ~(v)))
#define HW_ENET_MAC0_RX_ALMOST_FULL_TOG(v)    (HW_ENET_MAC0_RX_ALMOST_FULL_WR(HW_ENET_MAC0_RX_ALMOST_FULL_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RX_ALMOST_FULL bitfields
 */
/* --- Register HW_ENET_MAC0_RX_ALMOST_FULL, field RSRVD0 */

#define BP_ENET_MAC0_RX_ALMOST_FULL_RSRVD0      8
#define BM_ENET_MAC0_RX_ALMOST_FULL_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RX_ALMOST_FULL_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_MAC0_RX_ALMOST_FULL_RSRVD0)
#else
#define BF_ENET_MAC0_RX_ALMOST_FULL_RSRVD0(v)   (((v) << 8) & BM_ENET_MAC0_RX_ALMOST_FULL_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_RX_ALMOST_FULL, field RX_ALMOST_FULL */

#define BP_ENET_MAC0_RX_ALMOST_FULL_RX_ALMOST_FULL      0
#define BM_ENET_MAC0_RX_ALMOST_FULL_RX_ALMOST_FULL      0x000000FF

#define BF_ENET_MAC0_RX_ALMOST_FULL_RX_ALMOST_FULL(v)   (((v) << 0) & BM_ENET_MAC0_RX_ALMOST_FULL_RX_ALMOST_FULL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_RX_ALMOST_FULL_RX_ALMOST_FULL(v)   (HW_ENET_MAC0_RX_ALMOST_FULL.B.RX_ALMOST_FULL = (v))
#endif



/*
 * HW_ENET_MAC0_TX_SECTION_EMPTY - ENET MAC0 Transmit FIFO Section Empty Threshold Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TX_SECTION_EMPTY  :  8;
        unsigned RSRVD0            : 24;
    } B;
} hw_enet_mac0_tx_section_empty_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_TX_SECTION_EMPTY register
 */
#define HW_ENET_MAC0_TX_SECTION_EMPTY_ADDR         (REGS_ENET_BASE + 0x1a0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_TX_SECTION_EMPTY           (*(volatile hw_enet_mac0_tx_section_empty_t *) HW_ENET_MAC0_TX_SECTION_EMPTY_ADDR)
#define HW_ENET_MAC0_TX_SECTION_EMPTY_RD()      (HW_ENET_MAC0_TX_SECTION_EMPTY.U)
#define HW_ENET_MAC0_TX_SECTION_EMPTY_WR(v)     (HW_ENET_MAC0_TX_SECTION_EMPTY.U = (v))
#define HW_ENET_MAC0_TX_SECTION_EMPTY_SET(v)    (HW_ENET_MAC0_TX_SECTION_EMPTY_WR(HW_ENET_MAC0_TX_SECTION_EMPTY_RD() |  (v)))
#define HW_ENET_MAC0_TX_SECTION_EMPTY_CLR(v)    (HW_ENET_MAC0_TX_SECTION_EMPTY_WR(HW_ENET_MAC0_TX_SECTION_EMPTY_RD() & ~(v)))
#define HW_ENET_MAC0_TX_SECTION_EMPTY_TOG(v)    (HW_ENET_MAC0_TX_SECTION_EMPTY_WR(HW_ENET_MAC0_TX_SECTION_EMPTY_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_TX_SECTION_EMPTY bitfields
 */
/* --- Register HW_ENET_MAC0_TX_SECTION_EMPTY, field RSRVD0 */

#define BP_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0      8
#define BM_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0)
#else
#define BF_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0(v)   (((v) << 8) & BM_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_TX_SECTION_EMPTY, field TX_SECTION_EMPTY */

#define BP_ENET_MAC0_TX_SECTION_EMPTY_TX_SECTION_EMPTY      0
#define BM_ENET_MAC0_TX_SECTION_EMPTY_TX_SECTION_EMPTY      0x000000FF

#define BF_ENET_MAC0_TX_SECTION_EMPTY_TX_SECTION_EMPTY(v)   (((v) << 0) & BM_ENET_MAC0_TX_SECTION_EMPTY_TX_SECTION_EMPTY)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TX_SECTION_EMPTY_TX_SECTION_EMPTY(v)   (HW_ENET_MAC0_TX_SECTION_EMPTY.B.TX_SECTION_EMPTY = (v))
#endif



/*
 * HW_ENET_MAC0_TX_ALMOST_EMPTY - ENET MAC0 Transmit FIFO Almost Empty Threshold Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TX_ALMOST_EMPTY  :  8;
        unsigned RSRVD0           : 24;
    } B;
} hw_enet_mac0_tx_almost_empty_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_TX_ALMOST_EMPTY register
 */
#define HW_ENET_MAC0_TX_ALMOST_EMPTY_ADDR         (REGS_ENET_BASE + 0x1a4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_TX_ALMOST_EMPTY           (*(volatile hw_enet_mac0_tx_almost_empty_t *) HW_ENET_MAC0_TX_ALMOST_EMPTY_ADDR)
#define HW_ENET_MAC0_TX_ALMOST_EMPTY_RD()      (HW_ENET_MAC0_TX_ALMOST_EMPTY.U)
#define HW_ENET_MAC0_TX_ALMOST_EMPTY_WR(v)     (HW_ENET_MAC0_TX_ALMOST_EMPTY.U = (v))
#define HW_ENET_MAC0_TX_ALMOST_EMPTY_SET(v)    (HW_ENET_MAC0_TX_ALMOST_EMPTY_WR(HW_ENET_MAC0_TX_ALMOST_EMPTY_RD() |  (v)))
#define HW_ENET_MAC0_TX_ALMOST_EMPTY_CLR(v)    (HW_ENET_MAC0_TX_ALMOST_EMPTY_WR(HW_ENET_MAC0_TX_ALMOST_EMPTY_RD() & ~(v)))
#define HW_ENET_MAC0_TX_ALMOST_EMPTY_TOG(v)    (HW_ENET_MAC0_TX_ALMOST_EMPTY_WR(HW_ENET_MAC0_TX_ALMOST_EMPTY_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_TX_ALMOST_EMPTY bitfields
 */
/* --- Register HW_ENET_MAC0_TX_ALMOST_EMPTY, field RSRVD0 */

#define BP_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0      8
#define BM_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0)
#else
#define BF_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0(v)   (((v) << 8) & BM_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_TX_ALMOST_EMPTY, field TX_ALMOST_EMPTY */

#define BP_ENET_MAC0_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY      0
#define BM_ENET_MAC0_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY      0x000000FF

#define BF_ENET_MAC0_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY(v)   (((v) << 0) & BM_ENET_MAC0_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY(v)   (HW_ENET_MAC0_TX_ALMOST_EMPTY.B.TX_ALMOST_EMPTY = (v))
#endif



/*
 * HW_ENET_MAC0_TX_ALMOST_FULL - ENET MAC0 Transmit FIFO Almost Full Threshold Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TX_ALMOST_FULL  :  8;
        unsigned RSRVD0          : 24;
    } B;
} hw_enet_mac0_tx_almost_full_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_TX_ALMOST_FULL register
 */
#define HW_ENET_MAC0_TX_ALMOST_FULL_ADDR         (REGS_ENET_BASE + 0x1a8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_TX_ALMOST_FULL           (*(volatile hw_enet_mac0_tx_almost_full_t *) HW_ENET_MAC0_TX_ALMOST_FULL_ADDR)
#define HW_ENET_MAC0_TX_ALMOST_FULL_RD()      (HW_ENET_MAC0_TX_ALMOST_FULL.U)
#define HW_ENET_MAC0_TX_ALMOST_FULL_WR(v)     (HW_ENET_MAC0_TX_ALMOST_FULL.U = (v))
#define HW_ENET_MAC0_TX_ALMOST_FULL_SET(v)    (HW_ENET_MAC0_TX_ALMOST_FULL_WR(HW_ENET_MAC0_TX_ALMOST_FULL_RD() |  (v)))
#define HW_ENET_MAC0_TX_ALMOST_FULL_CLR(v)    (HW_ENET_MAC0_TX_ALMOST_FULL_WR(HW_ENET_MAC0_TX_ALMOST_FULL_RD() & ~(v)))
#define HW_ENET_MAC0_TX_ALMOST_FULL_TOG(v)    (HW_ENET_MAC0_TX_ALMOST_FULL_WR(HW_ENET_MAC0_TX_ALMOST_FULL_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_TX_ALMOST_FULL bitfields
 */
/* --- Register HW_ENET_MAC0_TX_ALMOST_FULL, field RSRVD0 */

#define BP_ENET_MAC0_TX_ALMOST_FULL_RSRVD0      8
#define BM_ENET_MAC0_TX_ALMOST_FULL_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_TX_ALMOST_FULL_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_MAC0_TX_ALMOST_FULL_RSRVD0)
#else
#define BF_ENET_MAC0_TX_ALMOST_FULL_RSRVD0(v)   (((v) << 8) & BM_ENET_MAC0_TX_ALMOST_FULL_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_TX_ALMOST_FULL, field TX_ALMOST_FULL */

#define BP_ENET_MAC0_TX_ALMOST_FULL_TX_ALMOST_FULL      0
#define BM_ENET_MAC0_TX_ALMOST_FULL_TX_ALMOST_FULL      0x000000FF

#define BF_ENET_MAC0_TX_ALMOST_FULL_TX_ALMOST_FULL(v)   (((v) << 0) & BM_ENET_MAC0_TX_ALMOST_FULL_TX_ALMOST_FULL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TX_ALMOST_FULL_TX_ALMOST_FULL(v)   (HW_ENET_MAC0_TX_ALMOST_FULL.B.TX_ALMOST_FULL = (v))
#endif



/*
 * HW_ENET_MAC0_TX_IPG_LENGTH - ENET MAC0 Transmit Inter-Packet Gap Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TX_IPG_LENGTH  :  5;
        unsigned RSRVD0         : 27;
    } B;
} hw_enet_mac0_tx_ipg_length_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_TX_IPG_LENGTH register
 */
#define HW_ENET_MAC0_TX_IPG_LENGTH_ADDR         (REGS_ENET_BASE + 0x1ac)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_TX_IPG_LENGTH           (*(volatile hw_enet_mac0_tx_ipg_length_t *) HW_ENET_MAC0_TX_IPG_LENGTH_ADDR)
#define HW_ENET_MAC0_TX_IPG_LENGTH_RD()      (HW_ENET_MAC0_TX_IPG_LENGTH.U)
#define HW_ENET_MAC0_TX_IPG_LENGTH_WR(v)     (HW_ENET_MAC0_TX_IPG_LENGTH.U = (v))
#define HW_ENET_MAC0_TX_IPG_LENGTH_SET(v)    (HW_ENET_MAC0_TX_IPG_LENGTH_WR(HW_ENET_MAC0_TX_IPG_LENGTH_RD() |  (v)))
#define HW_ENET_MAC0_TX_IPG_LENGTH_CLR(v)    (HW_ENET_MAC0_TX_IPG_LENGTH_WR(HW_ENET_MAC0_TX_IPG_LENGTH_RD() & ~(v)))
#define HW_ENET_MAC0_TX_IPG_LENGTH_TOG(v)    (HW_ENET_MAC0_TX_IPG_LENGTH_WR(HW_ENET_MAC0_TX_IPG_LENGTH_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_TX_IPG_LENGTH bitfields
 */
/* --- Register HW_ENET_MAC0_TX_IPG_LENGTH, field RSRVD0 */

#define BP_ENET_MAC0_TX_IPG_LENGTH_RSRVD0      5
#define BM_ENET_MAC0_TX_IPG_LENGTH_RSRVD0      0xFFFFFFE0

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_TX_IPG_LENGTH_RSRVD0(v)   ((((reg32_t) v) << 5) & BM_ENET_MAC0_TX_IPG_LENGTH_RSRVD0)
#else
#define BF_ENET_MAC0_TX_IPG_LENGTH_RSRVD0(v)   (((v) << 5) & BM_ENET_MAC0_TX_IPG_LENGTH_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_TX_IPG_LENGTH, field TX_IPG_LENGTH */

#define BP_ENET_MAC0_TX_IPG_LENGTH_TX_IPG_LENGTH      0
#define BM_ENET_MAC0_TX_IPG_LENGTH_TX_IPG_LENGTH      0x0000001F

#define BF_ENET_MAC0_TX_IPG_LENGTH_TX_IPG_LENGTH(v)   (((v) << 0) & BM_ENET_MAC0_TX_IPG_LENGTH_TX_IPG_LENGTH)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TX_IPG_LENGTH_TX_IPG_LENGTH(v)   BF_CS1(ENET_MAC0_TX_IPG_LENGTH, TX_IPG_LENGTH, v)
#endif



/*
 * HW_ENET_MAC0_TRUNC_FL - ENET MAC0 Frame Truncation Length Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRUNC_FL  : 14;
        unsigned RSRVD0    : 18;
    } B;
} hw_enet_mac0_trunc_fl_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_TRUNC_FL register
 */
#define HW_ENET_MAC0_TRUNC_FL_ADDR         (REGS_ENET_BASE + 0x1b0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_TRUNC_FL           (*(volatile hw_enet_mac0_trunc_fl_t *) HW_ENET_MAC0_TRUNC_FL_ADDR)
#define HW_ENET_MAC0_TRUNC_FL_RD()      (HW_ENET_MAC0_TRUNC_FL.U)
#define HW_ENET_MAC0_TRUNC_FL_WR(v)     (HW_ENET_MAC0_TRUNC_FL.U = (v))
#define HW_ENET_MAC0_TRUNC_FL_SET(v)    (HW_ENET_MAC0_TRUNC_FL_WR(HW_ENET_MAC0_TRUNC_FL_RD() |  (v)))
#define HW_ENET_MAC0_TRUNC_FL_CLR(v)    (HW_ENET_MAC0_TRUNC_FL_WR(HW_ENET_MAC0_TRUNC_FL_RD() & ~(v)))
#define HW_ENET_MAC0_TRUNC_FL_TOG(v)    (HW_ENET_MAC0_TRUNC_FL_WR(HW_ENET_MAC0_TRUNC_FL_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_TRUNC_FL bitfields
 */
/* --- Register HW_ENET_MAC0_TRUNC_FL, field RSRVD0 */

#define BP_ENET_MAC0_TRUNC_FL_RSRVD0      14
#define BM_ENET_MAC0_TRUNC_FL_RSRVD0      0xFFFFC000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_TRUNC_FL_RSRVD0(v)   ((((reg32_t) v) << 14) & BM_ENET_MAC0_TRUNC_FL_RSRVD0)
#else
#define BF_ENET_MAC0_TRUNC_FL_RSRVD0(v)   (((v) << 14) & BM_ENET_MAC0_TRUNC_FL_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_TRUNC_FL, field TRUNC_FL */

#define BP_ENET_MAC0_TRUNC_FL_TRUNC_FL      0
#define BM_ENET_MAC0_TRUNC_FL_TRUNC_FL      0x00003FFF

#define BF_ENET_MAC0_TRUNC_FL_TRUNC_FL(v)   (((v) << 0) & BM_ENET_MAC0_TRUNC_FL_TRUNC_FL)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_TRUNC_FL_TRUNC_FL(v)   BF_CS1(ENET_MAC0_TRUNC_FL, TRUNC_FL, v)
#endif



/*
 * HW_ENET_MAC0_IPACCTXCONF - ENET MAC0 Accelerator Transmit Function Configuration Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SHIFT16         :  1;
        unsigned RSRVD1          :  2;
        unsigned TX_IPCHK_INS    :  1;
        unsigned TX_PROTCHK_INS  :  1;
        unsigned RSRVD0          : 27;
    } B;
} hw_enet_mac0_ipacctxconf_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IPACCTXCONF register
 */
#define HW_ENET_MAC0_IPACCTXCONF_ADDR         (REGS_ENET_BASE + 0x1c0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IPACCTXCONF           (*(volatile hw_enet_mac0_ipacctxconf_t *) HW_ENET_MAC0_IPACCTXCONF_ADDR)
#define HW_ENET_MAC0_IPACCTXCONF_RD()      (HW_ENET_MAC0_IPACCTXCONF.U)
#define HW_ENET_MAC0_IPACCTXCONF_WR(v)     (HW_ENET_MAC0_IPACCTXCONF.U = (v))
#define HW_ENET_MAC0_IPACCTXCONF_SET(v)    (HW_ENET_MAC0_IPACCTXCONF_WR(HW_ENET_MAC0_IPACCTXCONF_RD() |  (v)))
#define HW_ENET_MAC0_IPACCTXCONF_CLR(v)    (HW_ENET_MAC0_IPACCTXCONF_WR(HW_ENET_MAC0_IPACCTXCONF_RD() & ~(v)))
#define HW_ENET_MAC0_IPACCTXCONF_TOG(v)    (HW_ENET_MAC0_IPACCTXCONF_WR(HW_ENET_MAC0_IPACCTXCONF_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IPACCTXCONF bitfields
 */
/* --- Register HW_ENET_MAC0_IPACCTXCONF, field RSRVD0 */

#define BP_ENET_MAC0_IPACCTXCONF_RSRVD0      5
#define BM_ENET_MAC0_IPACCTXCONF_RSRVD0      0xFFFFFFE0

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IPACCTXCONF_RSRVD0(v)   ((((reg32_t) v) << 5) & BM_ENET_MAC0_IPACCTXCONF_RSRVD0)
#else
#define BF_ENET_MAC0_IPACCTXCONF_RSRVD0(v)   (((v) << 5) & BM_ENET_MAC0_IPACCTXCONF_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_IPACCTXCONF, field TX_PROTCHK_INS */

#define BP_ENET_MAC0_IPACCTXCONF_TX_PROTCHK_INS      4
#define BM_ENET_MAC0_IPACCTXCONF_TX_PROTCHK_INS      0x00000010

#define BF_ENET_MAC0_IPACCTXCONF_TX_PROTCHK_INS(v)   (((v) << 4) & BM_ENET_MAC0_IPACCTXCONF_TX_PROTCHK_INS)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IPACCTXCONF_TX_PROTCHK_INS(v)   BF_CS1(ENET_MAC0_IPACCTXCONF, TX_PROTCHK_INS, v)
#endif

/* --- Register HW_ENET_MAC0_IPACCTXCONF, field TX_IPCHK_INS */

#define BP_ENET_MAC0_IPACCTXCONF_TX_IPCHK_INS      3
#define BM_ENET_MAC0_IPACCTXCONF_TX_IPCHK_INS      0x00000008

#define BF_ENET_MAC0_IPACCTXCONF_TX_IPCHK_INS(v)   (((v) << 3) & BM_ENET_MAC0_IPACCTXCONF_TX_IPCHK_INS)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IPACCTXCONF_TX_IPCHK_INS(v)   BF_CS1(ENET_MAC0_IPACCTXCONF, TX_IPCHK_INS, v)
#endif

/* --- Register HW_ENET_MAC0_IPACCTXCONF, field RSRVD1 */

#define BP_ENET_MAC0_IPACCTXCONF_RSRVD1      1
#define BM_ENET_MAC0_IPACCTXCONF_RSRVD1      0x00000006

#define BF_ENET_MAC0_IPACCTXCONF_RSRVD1(v)   (((v) << 1) & BM_ENET_MAC0_IPACCTXCONF_RSRVD1)
/* --- Register HW_ENET_MAC0_IPACCTXCONF, field SHIFT16 */

#define BP_ENET_MAC0_IPACCTXCONF_SHIFT16      0
#define BM_ENET_MAC0_IPACCTXCONF_SHIFT16      0x00000001

#define BF_ENET_MAC0_IPACCTXCONF_SHIFT16(v)   (((v) << 0) & BM_ENET_MAC0_IPACCTXCONF_SHIFT16)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IPACCTXCONF_SHIFT16(v)   BF_CS1(ENET_MAC0_IPACCTXCONF, SHIFT16, v)
#endif



/*
 * HW_ENET_MAC0_IPACCRXCONF - ENET MAC0 Accelerator Receive Function Configuration Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RX_IP_PAD_REMOVE    :  1;
        unsigned RX_IPERR_DISCARD    :  1;
        unsigned RX_PROTERR_DISCARD  :  1;
        unsigned RSRVD1              :  3;
        unsigned RX_LINEERR_DISC     :  1;
        unsigned SHIFT16             :  1;
        unsigned RSRVD0              : 24;
    } B;
} hw_enet_mac0_ipaccrxconf_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IPACCRXCONF register
 */
#define HW_ENET_MAC0_IPACCRXCONF_ADDR         (REGS_ENET_BASE + 0x1c4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IPACCRXCONF           (*(volatile hw_enet_mac0_ipaccrxconf_t *) HW_ENET_MAC0_IPACCRXCONF_ADDR)
#define HW_ENET_MAC0_IPACCRXCONF_RD()      (HW_ENET_MAC0_IPACCRXCONF.U)
#define HW_ENET_MAC0_IPACCRXCONF_WR(v)     (HW_ENET_MAC0_IPACCRXCONF.U = (v))
#define HW_ENET_MAC0_IPACCRXCONF_SET(v)    (HW_ENET_MAC0_IPACCRXCONF_WR(HW_ENET_MAC0_IPACCRXCONF_RD() |  (v)))
#define HW_ENET_MAC0_IPACCRXCONF_CLR(v)    (HW_ENET_MAC0_IPACCRXCONF_WR(HW_ENET_MAC0_IPACCRXCONF_RD() & ~(v)))
#define HW_ENET_MAC0_IPACCRXCONF_TOG(v)    (HW_ENET_MAC0_IPACCRXCONF_WR(HW_ENET_MAC0_IPACCRXCONF_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IPACCRXCONF bitfields
 */
/* --- Register HW_ENET_MAC0_IPACCRXCONF, field RSRVD0 */

#define BP_ENET_MAC0_IPACCRXCONF_RSRVD0      8
#define BM_ENET_MAC0_IPACCRXCONF_RSRVD0      0xFFFFFF00

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IPACCRXCONF_RSRVD0(v)   ((((reg32_t) v) << 8) & BM_ENET_MAC0_IPACCRXCONF_RSRVD0)
#else
#define BF_ENET_MAC0_IPACCRXCONF_RSRVD0(v)   (((v) << 8) & BM_ENET_MAC0_IPACCRXCONF_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_IPACCRXCONF, field SHIFT16 */

#define BP_ENET_MAC0_IPACCRXCONF_SHIFT16      7
#define BM_ENET_MAC0_IPACCRXCONF_SHIFT16      0x00000080

#define BF_ENET_MAC0_IPACCRXCONF_SHIFT16(v)   (((v) << 7) & BM_ENET_MAC0_IPACCRXCONF_SHIFT16)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IPACCRXCONF_SHIFT16(v)   BF_CS1(ENET_MAC0_IPACCRXCONF, SHIFT16, v)
#endif

/* --- Register HW_ENET_MAC0_IPACCRXCONF, field RX_LINEERR_DISC */

#define BP_ENET_MAC0_IPACCRXCONF_RX_LINEERR_DISC      6
#define BM_ENET_MAC0_IPACCRXCONF_RX_LINEERR_DISC      0x00000040

#define BF_ENET_MAC0_IPACCRXCONF_RX_LINEERR_DISC(v)   (((v) << 6) & BM_ENET_MAC0_IPACCRXCONF_RX_LINEERR_DISC)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IPACCRXCONF_RX_LINEERR_DISC(v)   BF_CS1(ENET_MAC0_IPACCRXCONF, RX_LINEERR_DISC, v)
#endif

/* --- Register HW_ENET_MAC0_IPACCRXCONF, field RSRVD1 */

#define BP_ENET_MAC0_IPACCRXCONF_RSRVD1      3
#define BM_ENET_MAC0_IPACCRXCONF_RSRVD1      0x00000038

#define BF_ENET_MAC0_IPACCRXCONF_RSRVD1(v)   (((v) << 3) & BM_ENET_MAC0_IPACCRXCONF_RSRVD1)
/* --- Register HW_ENET_MAC0_IPACCRXCONF, field RX_PROTERR_DISCARD */

#define BP_ENET_MAC0_IPACCRXCONF_RX_PROTERR_DISCARD      2
#define BM_ENET_MAC0_IPACCRXCONF_RX_PROTERR_DISCARD      0x00000004

#define BF_ENET_MAC0_IPACCRXCONF_RX_PROTERR_DISCARD(v)   (((v) << 2) & BM_ENET_MAC0_IPACCRXCONF_RX_PROTERR_DISCARD)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IPACCRXCONF_RX_PROTERR_DISCARD(v)   BF_CS1(ENET_MAC0_IPACCRXCONF, RX_PROTERR_DISCARD, v)
#endif

/* --- Register HW_ENET_MAC0_IPACCRXCONF, field RX_IPERR_DISCARD */

#define BP_ENET_MAC0_IPACCRXCONF_RX_IPERR_DISCARD      1
#define BM_ENET_MAC0_IPACCRXCONF_RX_IPERR_DISCARD      0x00000002

#define BF_ENET_MAC0_IPACCRXCONF_RX_IPERR_DISCARD(v)   (((v) << 1) & BM_ENET_MAC0_IPACCRXCONF_RX_IPERR_DISCARD)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IPACCRXCONF_RX_IPERR_DISCARD(v)   BF_CS1(ENET_MAC0_IPACCRXCONF, RX_IPERR_DISCARD, v)
#endif

/* --- Register HW_ENET_MAC0_IPACCRXCONF, field RX_IP_PAD_REMOVE */

#define BP_ENET_MAC0_IPACCRXCONF_RX_IP_PAD_REMOVE      0
#define BM_ENET_MAC0_IPACCRXCONF_RX_IP_PAD_REMOVE      0x00000001

#define BF_ENET_MAC0_IPACCRXCONF_RX_IP_PAD_REMOVE(v)   (((v) << 0) & BM_ENET_MAC0_IPACCRXCONF_RX_IP_PAD_REMOVE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_IPACCRXCONF_RX_IP_PAD_REMOVE(v)   BF_CS1(ENET_MAC0_IPACCRXCONF, RX_IP_PAD_REMOVE, v)
#endif



/*
 * HW_ENET_MAC0_RMON_T_DROP - ENET MAC0 RMON Tx packet drop
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_DROP  : 32;
    } B;
} hw_enet_mac0_rmon_t_drop_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_DROP register
 */
#define HW_ENET_MAC0_RMON_T_DROP_ADDR         (REGS_ENET_BASE + 0x200)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_DROP           (*(volatile hw_enet_mac0_rmon_t_drop_t *) HW_ENET_MAC0_RMON_T_DROP_ADDR)
#define HW_ENET_MAC0_RMON_T_DROP_RD()      (HW_ENET_MAC0_RMON_T_DROP.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_DROP bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_DROP, field RMON_T_DROP */

#define BP_ENET_MAC0_RMON_T_DROP_RMON_T_DROP      0
#define BM_ENET_MAC0_RMON_T_DROP_RMON_T_DROP      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_DROP_RMON_T_DROP(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_DROP_RMON_T_DROP(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_PACKETS - ENET MAC0 RMON Tx packet count
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_PACKETS  : 32;
    } B;
} hw_enet_mac0_rmon_t_packets_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_PACKETS register
 */
#define HW_ENET_MAC0_RMON_T_PACKETS_ADDR         (REGS_ENET_BASE + 0x204)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_PACKETS           (*(volatile hw_enet_mac0_rmon_t_packets_t *) HW_ENET_MAC0_RMON_T_PACKETS_ADDR)
#define HW_ENET_MAC0_RMON_T_PACKETS_RD()      (HW_ENET_MAC0_RMON_T_PACKETS.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_PACKETS bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_PACKETS, field RMON_T_PACKETS */

#define BP_ENET_MAC0_RMON_T_PACKETS_RMON_T_PACKETS      0
#define BM_ENET_MAC0_RMON_T_PACKETS_RMON_T_PACKETS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_PACKETS_RMON_T_PACKETS(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_PACKETS_RMON_T_PACKETS(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_BC_PKT - ENET MAC0 RMON Tx Broadcast Packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_BC_PKT  : 32;
    } B;
} hw_enet_mac0_rmon_t_bc_pkt_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_BC_PKT register
 */
#define HW_ENET_MAC0_RMON_T_BC_PKT_ADDR         (REGS_ENET_BASE + 0x208)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_BC_PKT           (*(volatile hw_enet_mac0_rmon_t_bc_pkt_t *) HW_ENET_MAC0_RMON_T_BC_PKT_ADDR)
#define HW_ENET_MAC0_RMON_T_BC_PKT_RD()      (HW_ENET_MAC0_RMON_T_BC_PKT.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_BC_PKT bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_BC_PKT, field RMON_T_BC_PKT */

#define BP_ENET_MAC0_RMON_T_BC_PKT_RMON_T_BC_PKT      0
#define BM_ENET_MAC0_RMON_T_BC_PKT_RMON_T_BC_PKT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_BC_PKT_RMON_T_BC_PKT(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_BC_PKT_RMON_T_BC_PKT(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_MC_PKT - ENET MAC0 RMON Tx Multicast Packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_MC_PKT  : 32;
    } B;
} hw_enet_mac0_rmon_t_mc_pkt_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_MC_PKT register
 */
#define HW_ENET_MAC0_RMON_T_MC_PKT_ADDR         (REGS_ENET_BASE + 0x20c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_MC_PKT           (*(volatile hw_enet_mac0_rmon_t_mc_pkt_t *) HW_ENET_MAC0_RMON_T_MC_PKT_ADDR)
#define HW_ENET_MAC0_RMON_T_MC_PKT_RD()      (HW_ENET_MAC0_RMON_T_MC_PKT.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_MC_PKT bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_MC_PKT, field RMON_T_MC_PKT */

#define BP_ENET_MAC0_RMON_T_MC_PKT_RMON_T_MC_PKT      0
#define BM_ENET_MAC0_RMON_T_MC_PKT_RMON_T_MC_PKT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_MC_PKT_RMON_T_MC_PKT(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_MC_PKT_RMON_T_MC_PKT(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_CRC_ALIGN - ENET MAC0 RMON Tx Packets w CRC/Align error
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_CRC_ALIGN  : 32;
    } B;
} hw_enet_mac0_rmon_t_crc_align_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_CRC_ALIGN register
 */
#define HW_ENET_MAC0_RMON_T_CRC_ALIGN_ADDR         (REGS_ENET_BASE + 0x210)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_CRC_ALIGN           (*(volatile hw_enet_mac0_rmon_t_crc_align_t *) HW_ENET_MAC0_RMON_T_CRC_ALIGN_ADDR)
#define HW_ENET_MAC0_RMON_T_CRC_ALIGN_RD()      (HW_ENET_MAC0_RMON_T_CRC_ALIGN.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_CRC_ALIGN bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_CRC_ALIGN, field RMON_T_CRC_ALIGN */

#define BP_ENET_MAC0_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN      0
#define BM_ENET_MAC0_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_UNDERSIZE - ENET MAC0 RMON Tx Packets < 64 bytes, good CRC
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_UNDERSIZE  : 32;
    } B;
} hw_enet_mac0_rmon_t_undersize_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_UNDERSIZE register
 */
#define HW_ENET_MAC0_RMON_T_UNDERSIZE_ADDR         (REGS_ENET_BASE + 0x214)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_UNDERSIZE           (*(volatile hw_enet_mac0_rmon_t_undersize_t *) HW_ENET_MAC0_RMON_T_UNDERSIZE_ADDR)
#define HW_ENET_MAC0_RMON_T_UNDERSIZE_RD()      (HW_ENET_MAC0_RMON_T_UNDERSIZE.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_UNDERSIZE bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_UNDERSIZE, field RMON_T_UNDERSIZE */

#define BP_ENET_MAC0_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE      0
#define BM_ENET_MAC0_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_OVERSIZE - ENET MAC0 RMON Tx Packets > MAX_FL bytes, good CRC
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_OVERSIZE  : 32;
    } B;
} hw_enet_mac0_rmon_t_oversize_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_OVERSIZE register
 */
#define HW_ENET_MAC0_RMON_T_OVERSIZE_ADDR         (REGS_ENET_BASE + 0x218)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_OVERSIZE           (*(volatile hw_enet_mac0_rmon_t_oversize_t *) HW_ENET_MAC0_RMON_T_OVERSIZE_ADDR)
#define HW_ENET_MAC0_RMON_T_OVERSIZE_RD()      (HW_ENET_MAC0_RMON_T_OVERSIZE.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_OVERSIZE bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_OVERSIZE, field RMON_T_OVERSIZE */

#define BP_ENET_MAC0_RMON_T_OVERSIZE_RMON_T_OVERSIZE      0
#define BM_ENET_MAC0_RMON_T_OVERSIZE_RMON_T_OVERSIZE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_OVERSIZE_RMON_T_OVERSIZE(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_OVERSIZE_RMON_T_OVERSIZE(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_FRAG - ENET MAC0 RMON Tx Packets < 64 bytes, bad CRC
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_FRAG  : 32;
    } B;
} hw_enet_mac0_rmon_t_frag_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_FRAG register
 */
#define HW_ENET_MAC0_RMON_T_FRAG_ADDR         (REGS_ENET_BASE + 0x21c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_FRAG           (*(volatile hw_enet_mac0_rmon_t_frag_t *) HW_ENET_MAC0_RMON_T_FRAG_ADDR)
#define HW_ENET_MAC0_RMON_T_FRAG_RD()      (HW_ENET_MAC0_RMON_T_FRAG.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_FRAG bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_FRAG, field RMON_T_FRAG */

#define BP_ENET_MAC0_RMON_T_FRAG_RMON_T_FRAG      0
#define BM_ENET_MAC0_RMON_T_FRAG_RMON_T_FRAG      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_FRAG_RMON_T_FRAG(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_FRAG_RMON_T_FRAG(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_JAB - ENET MAC0 RMON Tx Packets > MAX_FL bytes, bad CRC
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_JAB  : 32;
    } B;
} hw_enet_mac0_rmon_t_jab_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_JAB register
 */
#define HW_ENET_MAC0_RMON_T_JAB_ADDR         (REGS_ENET_BASE + 0x220)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_JAB           (*(volatile hw_enet_mac0_rmon_t_jab_t *) HW_ENET_MAC0_RMON_T_JAB_ADDR)
#define HW_ENET_MAC0_RMON_T_JAB_RD()      (HW_ENET_MAC0_RMON_T_JAB.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_JAB bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_JAB, field RMON_T_JAB */

#define BP_ENET_MAC0_RMON_T_JAB_RMON_T_JAB      0
#define BM_ENET_MAC0_RMON_T_JAB_RMON_T_JAB      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_JAB_RMON_T_JAB(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_JAB_RMON_T_JAB(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_COL - ENET MAC0 RMON Tx collision count
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_COL  : 32;
    } B;
} hw_enet_mac0_rmon_t_col_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_COL register
 */
#define HW_ENET_MAC0_RMON_T_COL_ADDR         (REGS_ENET_BASE + 0x224)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_COL           (*(volatile hw_enet_mac0_rmon_t_col_t *) HW_ENET_MAC0_RMON_T_COL_ADDR)
#define HW_ENET_MAC0_RMON_T_COL_RD()      (HW_ENET_MAC0_RMON_T_COL.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_COL bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_COL, field RMON_T_COL */

#define BP_ENET_MAC0_RMON_T_COL_RMON_T_COL      0
#define BM_ENET_MAC0_RMON_T_COL_RMON_T_COL      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_COL_RMON_T_COL(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_COL_RMON_T_COL(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_P64 - ENET MAC0 RMON Tx 64 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_P64  : 32;
    } B;
} hw_enet_mac0_rmon_t_p64_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_P64 register
 */
#define HW_ENET_MAC0_RMON_T_P64_ADDR         (REGS_ENET_BASE + 0x228)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_P64           (*(volatile hw_enet_mac0_rmon_t_p64_t *) HW_ENET_MAC0_RMON_T_P64_ADDR)
#define HW_ENET_MAC0_RMON_T_P64_RD()      (HW_ENET_MAC0_RMON_T_P64.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_P64 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_P64, field RMON_T_P64 */

#define BP_ENET_MAC0_RMON_T_P64_RMON_T_P64      0
#define BM_ENET_MAC0_RMON_T_P64_RMON_T_P64      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_P64_RMON_T_P64(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_P64_RMON_T_P64(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_P65TO127N - ENET MAC0 RMON Tx 65 to 127 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_P65TO127N  : 32;
    } B;
} hw_enet_mac0_rmon_t_p65to127n_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_P65TO127N register
 */
#define HW_ENET_MAC0_RMON_T_P65TO127N_ADDR         (REGS_ENET_BASE + 0x22c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_P65TO127N           (*(volatile hw_enet_mac0_rmon_t_p65to127n_t *) HW_ENET_MAC0_RMON_T_P65TO127N_ADDR)
#define HW_ENET_MAC0_RMON_T_P65TO127N_RD()      (HW_ENET_MAC0_RMON_T_P65TO127N.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_P65TO127N bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_P65TO127N, field RMON_T_P65TO127N */

#define BP_ENET_MAC0_RMON_T_P65TO127N_RMON_T_P65TO127N      0
#define BM_ENET_MAC0_RMON_T_P65TO127N_RMON_T_P65TO127N      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_P65TO127N_RMON_T_P65TO127N(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_P65TO127N_RMON_T_P65TO127N(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_P128TO255N - ENET MAC0 RMON Tx 128 to 255 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_P128TO255N  : 32;
    } B;
} hw_enet_mac0_rmon_t_p128to255n_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_P128TO255N register
 */
#define HW_ENET_MAC0_RMON_T_P128TO255N_ADDR         (REGS_ENET_BASE + 0x230)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_P128TO255N           (*(volatile hw_enet_mac0_rmon_t_p128to255n_t *) HW_ENET_MAC0_RMON_T_P128TO255N_ADDR)
#define HW_ENET_MAC0_RMON_T_P128TO255N_RD()      (HW_ENET_MAC0_RMON_T_P128TO255N.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_P128TO255N bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_P128TO255N, field RMON_T_P128TO255N */

#define BP_ENET_MAC0_RMON_T_P128TO255N_RMON_T_P128TO255N      0
#define BM_ENET_MAC0_RMON_T_P128TO255N_RMON_T_P128TO255N      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_P128TO255N_RMON_T_P128TO255N(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_P128TO255N_RMON_T_P128TO255N(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_P256TO511 - ENET MAC0 RMON Tx 256 to 511 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_P256TO511  : 32;
    } B;
} hw_enet_mac0_rmon_t_p256to511_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_P256TO511 register
 */
#define HW_ENET_MAC0_RMON_T_P256TO511_ADDR         (REGS_ENET_BASE + 0x234)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_P256TO511           (*(volatile hw_enet_mac0_rmon_t_p256to511_t *) HW_ENET_MAC0_RMON_T_P256TO511_ADDR)
#define HW_ENET_MAC0_RMON_T_P256TO511_RD()      (HW_ENET_MAC0_RMON_T_P256TO511.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_P256TO511 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_P256TO511, field RMON_T_P256TO511 */

#define BP_ENET_MAC0_RMON_T_P256TO511_RMON_T_P256TO511      0
#define BM_ENET_MAC0_RMON_T_P256TO511_RMON_T_P256TO511      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_P256TO511_RMON_T_P256TO511(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_P256TO511_RMON_T_P256TO511(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_P512TO1023 - ENET MAC0 RMON Tx 512 to 1023 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_P512TO1023  : 32;
    } B;
} hw_enet_mac0_rmon_t_p512to1023_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_P512TO1023 register
 */
#define HW_ENET_MAC0_RMON_T_P512TO1023_ADDR         (REGS_ENET_BASE + 0x238)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_P512TO1023           (*(volatile hw_enet_mac0_rmon_t_p512to1023_t *) HW_ENET_MAC0_RMON_T_P512TO1023_ADDR)
#define HW_ENET_MAC0_RMON_T_P512TO1023_RD()      (HW_ENET_MAC0_RMON_T_P512TO1023.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_P512TO1023 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_P512TO1023, field RMON_T_P512TO1023 */

#define BP_ENET_MAC0_RMON_T_P512TO1023_RMON_T_P512TO1023      0
#define BM_ENET_MAC0_RMON_T_P512TO1023_RMON_T_P512TO1023      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_P512TO1023_RMON_T_P512TO1023(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_P512TO1023_RMON_T_P512TO1023(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_P1024TO2047 - ENET MAC0 RMON Tx 1024 to 2047 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_P1024TO2047  : 32;
    } B;
} hw_enet_mac0_rmon_t_p1024to2047_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_P1024TO2047 register
 */
#define HW_ENET_MAC0_RMON_T_P1024TO2047_ADDR         (REGS_ENET_BASE + 0x23c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_P1024TO2047           (*(volatile hw_enet_mac0_rmon_t_p1024to2047_t *) HW_ENET_MAC0_RMON_T_P1024TO2047_ADDR)
#define HW_ENET_MAC0_RMON_T_P1024TO2047_RD()      (HW_ENET_MAC0_RMON_T_P1024TO2047.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_P1024TO2047 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_P1024TO2047, field RMON_T_P1024TO2047 */

#define BP_ENET_MAC0_RMON_T_P1024TO2047_RMON_T_P1024TO2047      0
#define BM_ENET_MAC0_RMON_T_P1024TO2047_RMON_T_P1024TO2047      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_P1024TO2047_RMON_T_P1024TO2047(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_P1024TO2047_RMON_T_P1024TO2047(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_P_GTE2048 - ENET MAC0 RMON Tx packets w > 2048 bytes
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_P_GTE2048  : 32;
    } B;
} hw_enet_mac0_rmon_t_p_gte2048_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_P_GTE2048 register
 */
#define HW_ENET_MAC0_RMON_T_P_GTE2048_ADDR         (REGS_ENET_BASE + 0x240)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_P_GTE2048           (*(volatile hw_enet_mac0_rmon_t_p_gte2048_t *) HW_ENET_MAC0_RMON_T_P_GTE2048_ADDR)
#define HW_ENET_MAC0_RMON_T_P_GTE2048_RD()      (HW_ENET_MAC0_RMON_T_P_GTE2048.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_P_GTE2048 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_P_GTE2048, field RMON_T_P_GTE2048 */

#define BP_ENET_MAC0_RMON_T_P_GTE2048_RMON_T_P_GTE2048      0
#define BM_ENET_MAC0_RMON_T_P_GTE2048_RMON_T_P_GTE2048      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_P_GTE2048_RMON_T_P_GTE2048(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_P_GTE2048_RMON_T_P_GTE2048(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_T_OCTETS - ENET MAC0 RMON Tx Octets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_T_OCTETS  : 32;
    } B;
} hw_enet_mac0_rmon_t_octets_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_T_OCTETS register
 */
#define HW_ENET_MAC0_RMON_T_OCTETS_ADDR         (REGS_ENET_BASE + 0x244)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_T_OCTETS           (*(volatile hw_enet_mac0_rmon_t_octets_t *) HW_ENET_MAC0_RMON_T_OCTETS_ADDR)
#define HW_ENET_MAC0_RMON_T_OCTETS_RD()      (HW_ENET_MAC0_RMON_T_OCTETS.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_T_OCTETS bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_T_OCTETS, field RMON_T_OCTETS */

#define BP_ENET_MAC0_RMON_T_OCTETS_RMON_T_OCTETS      0
#define BM_ENET_MAC0_RMON_T_OCTETS_RMON_T_OCTETS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_T_OCTETS_RMON_T_OCTETS(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_T_OCTETS_RMON_T_OCTETS(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_DROP - ENET MAC0 Frames Transmitted count drop
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_DROP  : 32;
    } B;
} hw_enet_mac0_ieee_t_drop_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_DROP register
 */
#define HW_ENET_MAC0_IEEE_T_DROP_ADDR         (REGS_ENET_BASE + 0x248)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_DROP           (*(volatile hw_enet_mac0_ieee_t_drop_t *) HW_ENET_MAC0_IEEE_T_DROP_ADDR)
#define HW_ENET_MAC0_IEEE_T_DROP_RD()      (HW_ENET_MAC0_IEEE_T_DROP.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_DROP bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_DROP, field IEEE_T_DROP */

#define BP_ENET_MAC0_IEEE_T_DROP_IEEE_T_DROP      0
#define BM_ENET_MAC0_IEEE_T_DROP_IEEE_T_DROP      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_DROP_IEEE_T_DROP(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_DROP_IEEE_T_DROP(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_FRAME_OK - ENET MAC0 Frames Transmitted OK
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_FRAME_OK  : 32;
    } B;
} hw_enet_mac0_ieee_t_frame_ok_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_FRAME_OK register
 */
#define HW_ENET_MAC0_IEEE_T_FRAME_OK_ADDR         (REGS_ENET_BASE + 0x24c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_FRAME_OK           (*(volatile hw_enet_mac0_ieee_t_frame_ok_t *) HW_ENET_MAC0_IEEE_T_FRAME_OK_ADDR)
#define HW_ENET_MAC0_IEEE_T_FRAME_OK_RD()      (HW_ENET_MAC0_IEEE_T_FRAME_OK.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_FRAME_OK bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_FRAME_OK, field IEEE_T_FRAME_OK */

#define BP_ENET_MAC0_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK      0
#define BM_ENET_MAC0_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_1COL - ENET MAC0 Frames Transmitted with Single Collision
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_1COL  : 32;
    } B;
} hw_enet_mac0_ieee_t_1col_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_1COL register
 */
#define HW_ENET_MAC0_IEEE_T_1COL_ADDR         (REGS_ENET_BASE + 0x250)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_1COL           (*(volatile hw_enet_mac0_ieee_t_1col_t *) HW_ENET_MAC0_IEEE_T_1COL_ADDR)
#define HW_ENET_MAC0_IEEE_T_1COL_RD()      (HW_ENET_MAC0_IEEE_T_1COL.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_1COL bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_1COL, field IEEE_T_1COL */

#define BP_ENET_MAC0_IEEE_T_1COL_IEEE_T_1COL      0
#define BM_ENET_MAC0_IEEE_T_1COL_IEEE_T_1COL      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_1COL_IEEE_T_1COL(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_1COL_IEEE_T_1COL(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_MCOL - ENET MAC0 Frames Transmitted with Multiple Collisions
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_MCOL  : 32;
    } B;
} hw_enet_mac0_ieee_t_mcol_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_MCOL register
 */
#define HW_ENET_MAC0_IEEE_T_MCOL_ADDR         (REGS_ENET_BASE + 0x254)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_MCOL           (*(volatile hw_enet_mac0_ieee_t_mcol_t *) HW_ENET_MAC0_IEEE_T_MCOL_ADDR)
#define HW_ENET_MAC0_IEEE_T_MCOL_RD()      (HW_ENET_MAC0_IEEE_T_MCOL.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_MCOL bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_MCOL, field IEEE_T_MCOL */

#define BP_ENET_MAC0_IEEE_T_MCOL_IEEE_T_MCOL      0
#define BM_ENET_MAC0_IEEE_T_MCOL_IEEE_T_MCOL      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_MCOL_IEEE_T_MCOL(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_MCOL_IEEE_T_MCOL(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_DEF - ENET MAC0 Frames Transmitted after Deferral Delay
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_DEF  : 32;
    } B;
} hw_enet_mac0_ieee_t_def_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_DEF register
 */
#define HW_ENET_MAC0_IEEE_T_DEF_ADDR         (REGS_ENET_BASE + 0x258)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_DEF           (*(volatile hw_enet_mac0_ieee_t_def_t *) HW_ENET_MAC0_IEEE_T_DEF_ADDR)
#define HW_ENET_MAC0_IEEE_T_DEF_RD()      (HW_ENET_MAC0_IEEE_T_DEF.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_DEF bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_DEF, field IEEE_T_DEF */

#define BP_ENET_MAC0_IEEE_T_DEF_IEEE_T_DEF      0
#define BM_ENET_MAC0_IEEE_T_DEF_IEEE_T_DEF      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_DEF_IEEE_T_DEF(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_DEF_IEEE_T_DEF(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_LCOL - ENET MAC0 Frames Transmitted with Late Collision
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_LCOL  : 32;
    } B;
} hw_enet_mac0_ieee_t_lcol_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_LCOL register
 */
#define HW_ENET_MAC0_IEEE_T_LCOL_ADDR         (REGS_ENET_BASE + 0x25c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_LCOL           (*(volatile hw_enet_mac0_ieee_t_lcol_t *) HW_ENET_MAC0_IEEE_T_LCOL_ADDR)
#define HW_ENET_MAC0_IEEE_T_LCOL_RD()      (HW_ENET_MAC0_IEEE_T_LCOL.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_LCOL bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_LCOL, field IEEE_T_LCOL */

#define BP_ENET_MAC0_IEEE_T_LCOL_IEEE_T_LCOL      0
#define BM_ENET_MAC0_IEEE_T_LCOL_IEEE_T_LCOL      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_LCOL_IEEE_T_LCOL(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_LCOL_IEEE_T_LCOL(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_EXCOL - ENET MAC0 Frames Transmitted with Excessive Collisions
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_EXCOL  : 32;
    } B;
} hw_enet_mac0_ieee_t_excol_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_EXCOL register
 */
#define HW_ENET_MAC0_IEEE_T_EXCOL_ADDR         (REGS_ENET_BASE + 0x260)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_EXCOL           (*(volatile hw_enet_mac0_ieee_t_excol_t *) HW_ENET_MAC0_IEEE_T_EXCOL_ADDR)
#define HW_ENET_MAC0_IEEE_T_EXCOL_RD()      (HW_ENET_MAC0_IEEE_T_EXCOL.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_EXCOL bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_EXCOL, field IEEE_T_EXCOL */

#define BP_ENET_MAC0_IEEE_T_EXCOL_IEEE_T_EXCOL      0
#define BM_ENET_MAC0_IEEE_T_EXCOL_IEEE_T_EXCOL      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_EXCOL_IEEE_T_EXCOL(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_EXCOL_IEEE_T_EXCOL(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_MACERR - ENET MAC0 Frames Transmitted with Tx FIFO Underrun
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_MACERR  : 32;
    } B;
} hw_enet_mac0_ieee_t_macerr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_MACERR register
 */
#define HW_ENET_MAC0_IEEE_T_MACERR_ADDR         (REGS_ENET_BASE + 0x264)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_MACERR           (*(volatile hw_enet_mac0_ieee_t_macerr_t *) HW_ENET_MAC0_IEEE_T_MACERR_ADDR)
#define HW_ENET_MAC0_IEEE_T_MACERR_RD()      (HW_ENET_MAC0_IEEE_T_MACERR.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_MACERR bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_MACERR, field IEEE_T_MACERR */

#define BP_ENET_MAC0_IEEE_T_MACERR_IEEE_T_MACERR      0
#define BM_ENET_MAC0_IEEE_T_MACERR_IEEE_T_MACERR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_MACERR_IEEE_T_MACERR(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_MACERR_IEEE_T_MACERR(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_CSERR - ENET MAC0 Frames Transmitted with Carrier Sense Error
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_CSERR  : 32;
    } B;
} hw_enet_mac0_ieee_t_cserr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_CSERR register
 */
#define HW_ENET_MAC0_IEEE_T_CSERR_ADDR         (REGS_ENET_BASE + 0x268)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_CSERR           (*(volatile hw_enet_mac0_ieee_t_cserr_t *) HW_ENET_MAC0_IEEE_T_CSERR_ADDR)
#define HW_ENET_MAC0_IEEE_T_CSERR_RD()      (HW_ENET_MAC0_IEEE_T_CSERR.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_CSERR bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_CSERR, field IEEE_T_CSERR */

#define BP_ENET_MAC0_IEEE_T_CSERR_IEEE_T_CSERR      0
#define BM_ENET_MAC0_IEEE_T_CSERR_IEEE_T_CSERR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_CSERR_IEEE_T_CSERR(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_CSERR_IEEE_T_CSERR(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_SQE - ENET MAC0 Frames Transmitted with SQE Error
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_SQE  : 32;
    } B;
} hw_enet_mac0_ieee_t_sqe_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_SQE register
 */
#define HW_ENET_MAC0_IEEE_T_SQE_ADDR         (REGS_ENET_BASE + 0x26c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_SQE           (*(volatile hw_enet_mac0_ieee_t_sqe_t *) HW_ENET_MAC0_IEEE_T_SQE_ADDR)
#define HW_ENET_MAC0_IEEE_T_SQE_RD()      (HW_ENET_MAC0_IEEE_T_SQE.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_SQE bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_SQE, field IEEE_T_SQE */

#define BP_ENET_MAC0_IEEE_T_SQE_IEEE_T_SQE      0
#define BM_ENET_MAC0_IEEE_T_SQE_IEEE_T_SQE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_SQE_IEEE_T_SQE(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_SQE_IEEE_T_SQE(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_FDXFC - ENET MAC0 Frames Transmitted flow control
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_FDXFC  : 32;
    } B;
} hw_enet_mac0_ieee_t_fdxfc_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_FDXFC register
 */
#define HW_ENET_MAC0_IEEE_T_FDXFC_ADDR         (REGS_ENET_BASE + 0x270)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_FDXFC           (*(volatile hw_enet_mac0_ieee_t_fdxfc_t *) HW_ENET_MAC0_IEEE_T_FDXFC_ADDR)
#define HW_ENET_MAC0_IEEE_T_FDXFC_RD()      (HW_ENET_MAC0_IEEE_T_FDXFC.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_FDXFC bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_FDXFC, field IEEE_T_FDXFC */

#define BP_ENET_MAC0_IEEE_T_FDXFC_IEEE_T_FDXFC      0
#define BM_ENET_MAC0_IEEE_T_FDXFC_IEEE_T_FDXFC      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_FDXFC_IEEE_T_FDXFC(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_FDXFC_IEEE_T_FDXFC(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_T_OCTETS_OK - ENET MAC0 Frames Transmitted error
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_T_OCTETS_OK  : 32;
    } B;
} hw_enet_mac0_ieee_t_octets_ok_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_T_OCTETS_OK register
 */
#define HW_ENET_MAC0_IEEE_T_OCTETS_OK_ADDR         (REGS_ENET_BASE + 0x274)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_T_OCTETS_OK           (*(volatile hw_enet_mac0_ieee_t_octets_ok_t *) HW_ENET_MAC0_IEEE_T_OCTETS_OK_ADDR)
#define HW_ENET_MAC0_IEEE_T_OCTETS_OK_RD()      (HW_ENET_MAC0_IEEE_T_OCTETS_OK.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_T_OCTETS_OK bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_T_OCTETS_OK, field IEEE_T_OCTETS_OK */

#define BP_ENET_MAC0_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK      0
#define BM_ENET_MAC0_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_PACKETS - ENET MAC0 RMON Rx packet count
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_PACKETS  : 32;
    } B;
} hw_enet_mac0_rmon_r_packets_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_PACKETS register
 */
#define HW_ENET_MAC0_RMON_R_PACKETS_ADDR         (REGS_ENET_BASE + 0x284)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_PACKETS           (*(volatile hw_enet_mac0_rmon_r_packets_t *) HW_ENET_MAC0_RMON_R_PACKETS_ADDR)
#define HW_ENET_MAC0_RMON_R_PACKETS_RD()      (HW_ENET_MAC0_RMON_R_PACKETS.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_PACKETS bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_PACKETS, field RMON_R_PACKETS */

#define BP_ENET_MAC0_RMON_R_PACKETS_RMON_R_PACKETS      0
#define BM_ENET_MAC0_RMON_R_PACKETS_RMON_R_PACKETS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_PACKETS_RMON_R_PACKETS(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_PACKETS_RMON_R_PACKETS(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_BC_PKT - ENET MAC0 RMON Rx Broadcast Packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_BC_PKT  : 32;
    } B;
} hw_enet_mac0_rmon_r_bc_pkt_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_BC_PKT register
 */
#define HW_ENET_MAC0_RMON_R_BC_PKT_ADDR         (REGS_ENET_BASE + 0x288)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_BC_PKT           (*(volatile hw_enet_mac0_rmon_r_bc_pkt_t *) HW_ENET_MAC0_RMON_R_BC_PKT_ADDR)
#define HW_ENET_MAC0_RMON_R_BC_PKT_RD()      (HW_ENET_MAC0_RMON_R_BC_PKT.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_BC_PKT bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_BC_PKT, field RMON_R_BC_PKT */

#define BP_ENET_MAC0_RMON_R_BC_PKT_RMON_R_BC_PKT      0
#define BM_ENET_MAC0_RMON_R_BC_PKT_RMON_R_BC_PKT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_BC_PKT_RMON_R_BC_PKT(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_BC_PKT_RMON_R_BC_PKT(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_MC_PKT - ENET MAC0 RMON Rx Multicast Packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_MC_PKT  : 32;
    } B;
} hw_enet_mac0_rmon_r_mc_pkt_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_MC_PKT register
 */
#define HW_ENET_MAC0_RMON_R_MC_PKT_ADDR         (REGS_ENET_BASE + 0x28c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_MC_PKT           (*(volatile hw_enet_mac0_rmon_r_mc_pkt_t *) HW_ENET_MAC0_RMON_R_MC_PKT_ADDR)
#define HW_ENET_MAC0_RMON_R_MC_PKT_RD()      (HW_ENET_MAC0_RMON_R_MC_PKT.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_MC_PKT bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_MC_PKT, field RMON_R_MC_PKT */

#define BP_ENET_MAC0_RMON_R_MC_PKT_RMON_R_MC_PKT      0
#define BM_ENET_MAC0_RMON_R_MC_PKT_RMON_R_MC_PKT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_MC_PKT_RMON_R_MC_PKT(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_MC_PKT_RMON_R_MC_PKT(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_CRC_ALIGN - ENET MAC0 RMON Rx Packets w CRC/Align error
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_CRC_ALIGN  : 32;
    } B;
} hw_enet_mac0_rmon_r_crc_align_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_CRC_ALIGN register
 */
#define HW_ENET_MAC0_RMON_R_CRC_ALIGN_ADDR         (REGS_ENET_BASE + 0x290)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_CRC_ALIGN           (*(volatile hw_enet_mac0_rmon_r_crc_align_t *) HW_ENET_MAC0_RMON_R_CRC_ALIGN_ADDR)
#define HW_ENET_MAC0_RMON_R_CRC_ALIGN_RD()      (HW_ENET_MAC0_RMON_R_CRC_ALIGN.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_CRC_ALIGN bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_CRC_ALIGN, field RMON_R_CRC_ALIGN */

#define BP_ENET_MAC0_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN      0
#define BM_ENET_MAC0_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_UNDERSIZE - ENET MAC0 RMON Rx Packets < 64 bytes, good CRC
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_UNDERSIZE  : 32;
    } B;
} hw_enet_mac0_rmon_r_undersize_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_UNDERSIZE register
 */
#define HW_ENET_MAC0_RMON_R_UNDERSIZE_ADDR         (REGS_ENET_BASE + 0x294)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_UNDERSIZE           (*(volatile hw_enet_mac0_rmon_r_undersize_t *) HW_ENET_MAC0_RMON_R_UNDERSIZE_ADDR)
#define HW_ENET_MAC0_RMON_R_UNDERSIZE_RD()      (HW_ENET_MAC0_RMON_R_UNDERSIZE.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_UNDERSIZE bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_UNDERSIZE, field RMON_R_UNDERSIZE */

#define BP_ENET_MAC0_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE      0
#define BM_ENET_MAC0_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_OVERSIZE - ENET MAC0 RMON Rx Packets > MAX_FL, good CRC
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_OVERSIZE  : 32;
    } B;
} hw_enet_mac0_rmon_r_oversize_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_OVERSIZE register
 */
#define HW_ENET_MAC0_RMON_R_OVERSIZE_ADDR         (REGS_ENET_BASE + 0x298)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_OVERSIZE           (*(volatile hw_enet_mac0_rmon_r_oversize_t *) HW_ENET_MAC0_RMON_R_OVERSIZE_ADDR)
#define HW_ENET_MAC0_RMON_R_OVERSIZE_RD()      (HW_ENET_MAC0_RMON_R_OVERSIZE.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_OVERSIZE bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_OVERSIZE, field RMON_R_OVERSIZE */

#define BP_ENET_MAC0_RMON_R_OVERSIZE_RMON_R_OVERSIZE      0
#define BM_ENET_MAC0_RMON_R_OVERSIZE_RMON_R_OVERSIZE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_OVERSIZE_RMON_R_OVERSIZE(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_OVERSIZE_RMON_R_OVERSIZE(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_FRAG - ENET MAC0 RMON Rx Packets < 64 bytes, bad CRC
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_FRAG  : 32;
    } B;
} hw_enet_mac0_rmon_r_frag_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_FRAG register
 */
#define HW_ENET_MAC0_RMON_R_FRAG_ADDR         (REGS_ENET_BASE + 0x29c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_FRAG           (*(volatile hw_enet_mac0_rmon_r_frag_t *) HW_ENET_MAC0_RMON_R_FRAG_ADDR)
#define HW_ENET_MAC0_RMON_R_FRAG_RD()      (HW_ENET_MAC0_RMON_R_FRAG.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_FRAG bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_FRAG, field RMON_R_FRAG */

#define BP_ENET_MAC0_RMON_R_FRAG_RMON_R_FRAG      0
#define BM_ENET_MAC0_RMON_R_FRAG_RMON_R_FRAG      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_FRAG_RMON_R_FRAG(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_FRAG_RMON_R_FRAG(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_JAB - ENET MAC0 RMON Rx Packets > MAX_FL bytes, bad CRC
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_JAB  : 32;
    } B;
} hw_enet_mac0_rmon_r_jab_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_JAB register
 */
#define HW_ENET_MAC0_RMON_R_JAB_ADDR         (REGS_ENET_BASE + 0x2a0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_JAB           (*(volatile hw_enet_mac0_rmon_r_jab_t *) HW_ENET_MAC0_RMON_R_JAB_ADDR)
#define HW_ENET_MAC0_RMON_R_JAB_RD()      (HW_ENET_MAC0_RMON_R_JAB.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_JAB bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_JAB, field RMON_R_JAB */

#define BP_ENET_MAC0_RMON_R_JAB_RMON_R_JAB      0
#define BM_ENET_MAC0_RMON_R_JAB_RMON_R_JAB      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_JAB_RMON_R_JAB(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_JAB_RMON_R_JAB(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_P64 - ENET MAC0 RMON Rx 64 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_P64  : 32;
    } B;
} hw_enet_mac0_rmon_r_p64_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_P64 register
 */
#define HW_ENET_MAC0_RMON_R_P64_ADDR         (REGS_ENET_BASE + 0x2a8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_P64           (*(volatile hw_enet_mac0_rmon_r_p64_t *) HW_ENET_MAC0_RMON_R_P64_ADDR)
#define HW_ENET_MAC0_RMON_R_P64_RD()      (HW_ENET_MAC0_RMON_R_P64.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_P64 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_P64, field RMON_R_P64 */

#define BP_ENET_MAC0_RMON_R_P64_RMON_R_P64      0
#define BM_ENET_MAC0_RMON_R_P64_RMON_R_P64      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_P64_RMON_R_P64(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_P64_RMON_R_P64(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_P65TO127 - ENET MAC0 RMON Rx 65 to 127 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_P65TO127  : 32;
    } B;
} hw_enet_mac0_rmon_r_p65to127_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_P65TO127 register
 */
#define HW_ENET_MAC0_RMON_R_P65TO127_ADDR         (REGS_ENET_BASE + 0x2ac)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_P65TO127           (*(volatile hw_enet_mac0_rmon_r_p65to127_t *) HW_ENET_MAC0_RMON_R_P65TO127_ADDR)
#define HW_ENET_MAC0_RMON_R_P65TO127_RD()      (HW_ENET_MAC0_RMON_R_P65TO127.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_P65TO127 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_P65TO127, field RMON_R_P65TO127 */

#define BP_ENET_MAC0_RMON_R_P65TO127_RMON_R_P65TO127      0
#define BM_ENET_MAC0_RMON_R_P65TO127_RMON_R_P65TO127      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_P65TO127_RMON_R_P65TO127(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_P65TO127_RMON_R_P65TO127(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_P128TO255 - ENET MAC0 RMON Rx 128 to 255 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_P128TO255  : 32;
    } B;
} hw_enet_mac0_rmon_r_p128to255_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_P128TO255 register
 */
#define HW_ENET_MAC0_RMON_R_P128TO255_ADDR         (REGS_ENET_BASE + 0x2b0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_P128TO255           (*(volatile hw_enet_mac0_rmon_r_p128to255_t *) HW_ENET_MAC0_RMON_R_P128TO255_ADDR)
#define HW_ENET_MAC0_RMON_R_P128TO255_RD()      (HW_ENET_MAC0_RMON_R_P128TO255.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_P128TO255 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_P128TO255, field RMON_R_P128TO255 */

#define BP_ENET_MAC0_RMON_R_P128TO255_RMON_R_P128TO255      0
#define BM_ENET_MAC0_RMON_R_P128TO255_RMON_R_P128TO255      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_P128TO255_RMON_R_P128TO255(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_P128TO255_RMON_R_P128TO255(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_P256TO511 - ENET MAC0 RMON Rx 256 to 511 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_P256TO511  : 32;
    } B;
} hw_enet_mac0_rmon_r_p256to511_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_P256TO511 register
 */
#define HW_ENET_MAC0_RMON_R_P256TO511_ADDR         (REGS_ENET_BASE + 0x2b4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_P256TO511           (*(volatile hw_enet_mac0_rmon_r_p256to511_t *) HW_ENET_MAC0_RMON_R_P256TO511_ADDR)
#define HW_ENET_MAC0_RMON_R_P256TO511_RD()      (HW_ENET_MAC0_RMON_R_P256TO511.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_P256TO511 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_P256TO511, field RMON_R_P256TO511 */

#define BP_ENET_MAC0_RMON_R_P256TO511_RMON_R_P256TO511      0
#define BM_ENET_MAC0_RMON_R_P256TO511_RMON_R_P256TO511      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_P256TO511_RMON_R_P256TO511(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_P256TO511_RMON_R_P256TO511(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_P512TO1023 - ENET MAC0 RMON Rx 512 to 1023 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_P512TO1023  : 32;
    } B;
} hw_enet_mac0_rmon_r_p512to1023_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_P512TO1023 register
 */
#define HW_ENET_MAC0_RMON_R_P512TO1023_ADDR         (REGS_ENET_BASE + 0x2b8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_P512TO1023           (*(volatile hw_enet_mac0_rmon_r_p512to1023_t *) HW_ENET_MAC0_RMON_R_P512TO1023_ADDR)
#define HW_ENET_MAC0_RMON_R_P512TO1023_RD()      (HW_ENET_MAC0_RMON_R_P512TO1023.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_P512TO1023 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_P512TO1023, field RMON_R_P512TO1023 */

#define BP_ENET_MAC0_RMON_R_P512TO1023_RMON_R_P512TO1023      0
#define BM_ENET_MAC0_RMON_R_P512TO1023_RMON_R_P512TO1023      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_P512TO1023_RMON_R_P512TO1023(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_P512TO1023_RMON_R_P512TO1023(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_P1024TO2047 - ENET MAC0 RMON Rx 1024 to 2047 byte packets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_P1024TO2047  : 32;
    } B;
} hw_enet_mac0_rmon_r_p1024to2047_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_P1024TO2047 register
 */
#define HW_ENET_MAC0_RMON_R_P1024TO2047_ADDR         (REGS_ENET_BASE + 0x2bc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_P1024TO2047           (*(volatile hw_enet_mac0_rmon_r_p1024to2047_t *) HW_ENET_MAC0_RMON_R_P1024TO2047_ADDR)
#define HW_ENET_MAC0_RMON_R_P1024TO2047_RD()      (HW_ENET_MAC0_RMON_R_P1024TO2047.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_P1024TO2047 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_P1024TO2047, field RMON_R_P1024TO2047 */

#define BP_ENET_MAC0_RMON_R_P1024TO2047_RMON_R_P1024TO2047      0
#define BM_ENET_MAC0_RMON_R_P1024TO2047_RMON_R_P1024TO2047      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_P1024TO2047_RMON_R_P1024TO2047(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_P1024TO2047_RMON_R_P1024TO2047(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_P_GTE2048 - ENET MAC0 RMON Rx packets w > 2048 bytes
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_P_GTE2048  : 32;
    } B;
} hw_enet_mac0_rmon_r_p_gte2048_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_P_GTE2048 register
 */
#define HW_ENET_MAC0_RMON_R_P_GTE2048_ADDR         (REGS_ENET_BASE + 0x2c0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_P_GTE2048           (*(volatile hw_enet_mac0_rmon_r_p_gte2048_t *) HW_ENET_MAC0_RMON_R_P_GTE2048_ADDR)
#define HW_ENET_MAC0_RMON_R_P_GTE2048_RD()      (HW_ENET_MAC0_RMON_R_P_GTE2048.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_P_GTE2048 bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_P_GTE2048, field RMON_R_P_GTE2048 */

#define BP_ENET_MAC0_RMON_R_P_GTE2048_RMON_R_P_GTE2048      0
#define BM_ENET_MAC0_RMON_R_P_GTE2048_RMON_R_P_GTE2048      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_P_GTE2048_RMON_R_P_GTE2048(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_P_GTE2048_RMON_R_P_GTE2048(v)   (v)
#endif


/*
 * HW_ENET_MAC0_RMON_R_OCTETS - ENET MAC0 RMON Rx Octets
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RMON_R_OCTETS  : 32;
    } B;
} hw_enet_mac0_rmon_r_octets_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_RMON_R_OCTETS register
 */
#define HW_ENET_MAC0_RMON_R_OCTETS_ADDR         (REGS_ENET_BASE + 0x2c4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_RMON_R_OCTETS           (*(volatile hw_enet_mac0_rmon_r_octets_t *) HW_ENET_MAC0_RMON_R_OCTETS_ADDR)
#define HW_ENET_MAC0_RMON_R_OCTETS_RD()      (HW_ENET_MAC0_RMON_R_OCTETS.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_RMON_R_OCTETS bitfields
 */
/* --- Register HW_ENET_MAC0_RMON_R_OCTETS, field RMON_R_OCTETS */

#define BP_ENET_MAC0_RMON_R_OCTETS_RMON_R_OCTETS      0
#define BM_ENET_MAC0_RMON_R_OCTETS_RMON_R_OCTETS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_RMON_R_OCTETS_RMON_R_OCTETS(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_RMON_R_OCTETS_RMON_R_OCTETS(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_R_DROP - ENET MAC0 Frames Received count
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_R_DROP  : 32;
    } B;
} hw_enet_mac0_ieee_r_drop_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_R_DROP register
 */
#define HW_ENET_MAC0_IEEE_R_DROP_ADDR         (REGS_ENET_BASE + 0x2c8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_R_DROP           (*(volatile hw_enet_mac0_ieee_r_drop_t *) HW_ENET_MAC0_IEEE_R_DROP_ADDR)
#define HW_ENET_MAC0_IEEE_R_DROP_RD()      (HW_ENET_MAC0_IEEE_R_DROP.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_R_DROP bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_R_DROP, field IEEE_R_DROP */

#define BP_ENET_MAC0_IEEE_R_DROP_IEEE_R_DROP      0
#define BM_ENET_MAC0_IEEE_R_DROP_IEEE_R_DROP      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_R_DROP_IEEE_R_DROP(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_R_DROP_IEEE_R_DROP(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_R_FRAME_OK - ENET MAC0 Frames Received OK
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_R_FRAME_OK  : 32;
    } B;
} hw_enet_mac0_ieee_r_frame_ok_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_R_FRAME_OK register
 */
#define HW_ENET_MAC0_IEEE_R_FRAME_OK_ADDR         (REGS_ENET_BASE + 0x2cc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_R_FRAME_OK           (*(volatile hw_enet_mac0_ieee_r_frame_ok_t *) HW_ENET_MAC0_IEEE_R_FRAME_OK_ADDR)
#define HW_ENET_MAC0_IEEE_R_FRAME_OK_RD()      (HW_ENET_MAC0_IEEE_R_FRAME_OK.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_R_FRAME_OK bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_R_FRAME_OK, field IEEE_R_FRAME_OK */

#define BP_ENET_MAC0_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK      0
#define BM_ENET_MAC0_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_R_CRC - ENET MAC0 Frames Received with CRC Error
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_R_CRC  : 32;
    } B;
} hw_enet_mac0_ieee_r_crc_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_R_CRC register
 */
#define HW_ENET_MAC0_IEEE_R_CRC_ADDR         (REGS_ENET_BASE + 0x2d0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_R_CRC           (*(volatile hw_enet_mac0_ieee_r_crc_t *) HW_ENET_MAC0_IEEE_R_CRC_ADDR)
#define HW_ENET_MAC0_IEEE_R_CRC_RD()      (HW_ENET_MAC0_IEEE_R_CRC.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_R_CRC bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_R_CRC, field IEEE_R_CRC */

#define BP_ENET_MAC0_IEEE_R_CRC_IEEE_R_CRC      0
#define BM_ENET_MAC0_IEEE_R_CRC_IEEE_R_CRC      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_R_CRC_IEEE_R_CRC(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_R_CRC_IEEE_R_CRC(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_R_ALIGN - ENET MAC0 Frames Received with Alignment Error
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_R_ALIGN  : 32;
    } B;
} hw_enet_mac0_ieee_r_align_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_R_ALIGN register
 */
#define HW_ENET_MAC0_IEEE_R_ALIGN_ADDR         (REGS_ENET_BASE + 0x2d4)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_R_ALIGN           (*(volatile hw_enet_mac0_ieee_r_align_t *) HW_ENET_MAC0_IEEE_R_ALIGN_ADDR)
#define HW_ENET_MAC0_IEEE_R_ALIGN_RD()      (HW_ENET_MAC0_IEEE_R_ALIGN.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_R_ALIGN bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_R_ALIGN, field IEEE_R_ALIGN */

#define BP_ENET_MAC0_IEEE_R_ALIGN_IEEE_R_ALIGN      0
#define BM_ENET_MAC0_IEEE_R_ALIGN_IEEE_R_ALIGN      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_R_ALIGN_IEEE_R_ALIGN(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_R_ALIGN_IEEE_R_ALIGN(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_R_MACERR - ENET MAC0 Frames Received overflow
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_R_MACERR  : 32;
    } B;
} hw_enet_mac0_ieee_r_macerr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_R_MACERR register
 */
#define HW_ENET_MAC0_IEEE_R_MACERR_ADDR         (REGS_ENET_BASE + 0x2d8)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_R_MACERR           (*(volatile hw_enet_mac0_ieee_r_macerr_t *) HW_ENET_MAC0_IEEE_R_MACERR_ADDR)
#define HW_ENET_MAC0_IEEE_R_MACERR_RD()      (HW_ENET_MAC0_IEEE_R_MACERR.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_R_MACERR bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_R_MACERR, field IEEE_R_MACERR */

#define BP_ENET_MAC0_IEEE_R_MACERR_IEEE_R_MACERR      0
#define BM_ENET_MAC0_IEEE_R_MACERR_IEEE_R_MACERR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_R_MACERR_IEEE_R_MACERR(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_R_MACERR_IEEE_R_MACERR(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_R_FDXFC - ENET MAC0 Frames Received flow control
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_R_FDXFC  : 32;
    } B;
} hw_enet_mac0_ieee_r_fdxfc_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_R_FDXFC register
 */
#define HW_ENET_MAC0_IEEE_R_FDXFC_ADDR         (REGS_ENET_BASE + 0x2dc)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_R_FDXFC           (*(volatile hw_enet_mac0_ieee_r_fdxfc_t *) HW_ENET_MAC0_IEEE_R_FDXFC_ADDR)
#define HW_ENET_MAC0_IEEE_R_FDXFC_RD()      (HW_ENET_MAC0_IEEE_R_FDXFC.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_R_FDXFC bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_R_FDXFC, field IEEE_R_FDXFC */

#define BP_ENET_MAC0_IEEE_R_FDXFC_IEEE_R_FDXFC      0
#define BM_ENET_MAC0_IEEE_R_FDXFC_IEEE_R_FDXFC      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_R_FDXFC_IEEE_R_FDXFC(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_R_FDXFC_IEEE_R_FDXFC(v)   (v)
#endif


/*
 * HW_ENET_MAC0_IEEE_R_OCTETS_OK - ENET MAC0 Frames Received error
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IEEE_R_OCTETS_OK  : 32;
    } B;
} hw_enet_mac0_ieee_r_octets_ok_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_IEEE_R_OCTETS_OK register
 */
#define HW_ENET_MAC0_IEEE_R_OCTETS_OK_ADDR         (REGS_ENET_BASE + 0x2e0)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_IEEE_R_OCTETS_OK           (*(volatile hw_enet_mac0_ieee_r_octets_ok_t *) HW_ENET_MAC0_IEEE_R_OCTETS_OK_ADDR)
#define HW_ENET_MAC0_IEEE_R_OCTETS_OK_RD()      (HW_ENET_MAC0_IEEE_R_OCTETS_OK.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_IEEE_R_OCTETS_OK bitfields
 */
/* --- Register HW_ENET_MAC0_IEEE_R_OCTETS_OK, field IEEE_R_OCTETS_OK */

#define BP_ENET_MAC0_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK      0
#define BM_ENET_MAC0_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK(v)   (v)
#endif


/*
 * HW_ENET_MAC0_ATIME_CTRL - ENET MAC0 IEEE1588 Timer Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE          :  1;
        unsigned ONE_SHOT        :  1;
        unsigned EVT_OFFSET_ENA  :  1;
        unsigned EVT_OFFSET_RST  :  1;
        unsigned EVT_PERIOD_ENA  :  1;
        unsigned EVT_PERIOD_RST  :  1;
        unsigned RSRVD4          :  1;
        unsigned PIN_PERIOD_ENA  :  1;
        unsigned RSRVD3          :  1;
        unsigned RESTART         :  1;
        unsigned RSRVD2          :  1;
        unsigned CAPTURE         :  1;
        unsigned RSRVD1          :  1;
        unsigned FRC_SLAVE       :  1;
        unsigned RSRVD0          : 18;
    } B;
} hw_enet_mac0_atime_ctrl_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_ATIME_CTRL register
 */
#define HW_ENET_MAC0_ATIME_CTRL_ADDR         (REGS_ENET_BASE + 0x400)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_ATIME_CTRL           (*(volatile hw_enet_mac0_atime_ctrl_t *) HW_ENET_MAC0_ATIME_CTRL_ADDR)
#define HW_ENET_MAC0_ATIME_CTRL_RD()      (HW_ENET_MAC0_ATIME_CTRL.U)
#define HW_ENET_MAC0_ATIME_CTRL_WR(v)     (HW_ENET_MAC0_ATIME_CTRL.U = (v))
#define HW_ENET_MAC0_ATIME_CTRL_SET(v)    (HW_ENET_MAC0_ATIME_CTRL_WR(HW_ENET_MAC0_ATIME_CTRL_RD() |  (v)))
#define HW_ENET_MAC0_ATIME_CTRL_CLR(v)    (HW_ENET_MAC0_ATIME_CTRL_WR(HW_ENET_MAC0_ATIME_CTRL_RD() & ~(v)))
#define HW_ENET_MAC0_ATIME_CTRL_TOG(v)    (HW_ENET_MAC0_ATIME_CTRL_WR(HW_ENET_MAC0_ATIME_CTRL_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_ATIME_CTRL bitfields
 */
/* --- Register HW_ENET_MAC0_ATIME_CTRL, field RSRVD0 */

#define BP_ENET_MAC0_ATIME_CTRL_RSRVD0      14
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD0      0xFFFFC000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_ATIME_CTRL_RSRVD0(v)   ((((reg32_t) v) << 14) & BM_ENET_MAC0_ATIME_CTRL_RSRVD0)
#else
#define BF_ENET_MAC0_ATIME_CTRL_RSRVD0(v)   (((v) << 14) & BM_ENET_MAC0_ATIME_CTRL_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_ATIME_CTRL, field FRC_SLAVE */

#define BP_ENET_MAC0_ATIME_CTRL_FRC_SLAVE      13
#define BM_ENET_MAC0_ATIME_CTRL_FRC_SLAVE      0x00002000

#define BF_ENET_MAC0_ATIME_CTRL_FRC_SLAVE(v)   (((v) << 13) & BM_ENET_MAC0_ATIME_CTRL_FRC_SLAVE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_FRC_SLAVE(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, FRC_SLAVE, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_CTRL, field RSRVD1 */

#define BP_ENET_MAC0_ATIME_CTRL_RSRVD1      12
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD1      0x00001000

#define BF_ENET_MAC0_ATIME_CTRL_RSRVD1(v)   (((v) << 12) & BM_ENET_MAC0_ATIME_CTRL_RSRVD1)
/* --- Register HW_ENET_MAC0_ATIME_CTRL, field CAPTURE */

#define BP_ENET_MAC0_ATIME_CTRL_CAPTURE      11
#define BM_ENET_MAC0_ATIME_CTRL_CAPTURE      0x00000800

#define BF_ENET_MAC0_ATIME_CTRL_CAPTURE(v)   (((v) << 11) & BM_ENET_MAC0_ATIME_CTRL_CAPTURE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_CAPTURE(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, CAPTURE, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_CTRL, field RSRVD2 */

#define BP_ENET_MAC0_ATIME_CTRL_RSRVD2      10
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD2      0x00000400

#define BF_ENET_MAC0_ATIME_CTRL_RSRVD2(v)   (((v) << 10) & BM_ENET_MAC0_ATIME_CTRL_RSRVD2)
/* --- Register HW_ENET_MAC0_ATIME_CTRL, field RESTART */

#define BP_ENET_MAC0_ATIME_CTRL_RESTART      9
#define BM_ENET_MAC0_ATIME_CTRL_RESTART      0x00000200

#define BF_ENET_MAC0_ATIME_CTRL_RESTART(v)   (((v) << 9) & BM_ENET_MAC0_ATIME_CTRL_RESTART)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_RESTART(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, RESTART, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_CTRL, field RSRVD3 */

#define BP_ENET_MAC0_ATIME_CTRL_RSRVD3      8
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD3      0x00000100

#define BF_ENET_MAC0_ATIME_CTRL_RSRVD3(v)   (((v) << 8) & BM_ENET_MAC0_ATIME_CTRL_RSRVD3)
/* --- Register HW_ENET_MAC0_ATIME_CTRL, field PIN_PERIOD_ENA */

#define BP_ENET_MAC0_ATIME_CTRL_PIN_PERIOD_ENA      7
#define BM_ENET_MAC0_ATIME_CTRL_PIN_PERIOD_ENA      0x00000080

#define BF_ENET_MAC0_ATIME_CTRL_PIN_PERIOD_ENA(v)   (((v) << 7) & BM_ENET_MAC0_ATIME_CTRL_PIN_PERIOD_ENA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_PIN_PERIOD_ENA(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, PIN_PERIOD_ENA, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_CTRL, field RSRVD4 */

#define BP_ENET_MAC0_ATIME_CTRL_RSRVD4      6
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD4      0x00000040

#define BF_ENET_MAC0_ATIME_CTRL_RSRVD4(v)   (((v) << 6) & BM_ENET_MAC0_ATIME_CTRL_RSRVD4)
/* --- Register HW_ENET_MAC0_ATIME_CTRL, field EVT_PERIOD_RST */

#define BP_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_RST      5
#define BM_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_RST      0x00000020

#define BF_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_RST(v)   (((v) << 5) & BM_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_RST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_RST(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, EVT_PERIOD_RST, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_CTRL, field EVT_PERIOD_ENA */

#define BP_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_ENA      4
#define BM_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_ENA      0x00000010

#define BF_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_ENA(v)   (((v) << 4) & BM_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_ENA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_ENA(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, EVT_PERIOD_ENA, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_CTRL, field EVT_OFFSET_RST */

#define BP_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_RST      3
#define BM_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_RST      0x00000008

#define BF_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_RST(v)   (((v) << 3) & BM_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_RST)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_RST(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, EVT_OFFSET_RST, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_CTRL, field EVT_OFFSET_ENA */

#define BP_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_ENA      2
#define BM_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_ENA      0x00000004

#define BF_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_ENA(v)   (((v) << 2) & BM_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_ENA)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_ENA(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, EVT_OFFSET_ENA, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_CTRL, field ONE_SHOT */

#define BP_ENET_MAC0_ATIME_CTRL_ONE_SHOT      1
#define BM_ENET_MAC0_ATIME_CTRL_ONE_SHOT      0x00000002

#define BF_ENET_MAC0_ATIME_CTRL_ONE_SHOT(v)   (((v) << 1) & BM_ENET_MAC0_ATIME_CTRL_ONE_SHOT)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_ONE_SHOT(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, ONE_SHOT, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_CTRL, field ENABLE */

#define BP_ENET_MAC0_ATIME_CTRL_ENABLE      0
#define BM_ENET_MAC0_ATIME_CTRL_ENABLE      0x00000001

#define BF_ENET_MAC0_ATIME_CTRL_ENABLE(v)   (((v) << 0) & BM_ENET_MAC0_ATIME_CTRL_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CTRL_ENABLE(v)   BF_CS1(ENET_MAC0_ATIME_CTRL, ENABLE, v)
#endif



/*
 * HW_ENET_MAC0_ATIME - ENET MAC0 IEEE1588 Timer value Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ATIME  : 32;
    } B;
} hw_enet_mac0_atime_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_ATIME register
 */
#define HW_ENET_MAC0_ATIME_ADDR         (REGS_ENET_BASE + 0x404)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_ATIME           (*(volatile hw_enet_mac0_atime_t *) HW_ENET_MAC0_ATIME_ADDR)
#define HW_ENET_MAC0_ATIME_RD()      (HW_ENET_MAC0_ATIME.U)
#define HW_ENET_MAC0_ATIME_WR(v)     (HW_ENET_MAC0_ATIME.U = (v))
#define HW_ENET_MAC0_ATIME_SET(v)    (HW_ENET_MAC0_ATIME_WR(HW_ENET_MAC0_ATIME_RD() |  (v)))
#define HW_ENET_MAC0_ATIME_CLR(v)    (HW_ENET_MAC0_ATIME_WR(HW_ENET_MAC0_ATIME_RD() & ~(v)))
#define HW_ENET_MAC0_ATIME_TOG(v)    (HW_ENET_MAC0_ATIME_WR(HW_ENET_MAC0_ATIME_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_ATIME bitfields
 */
/* --- Register HW_ENET_MAC0_ATIME, field ATIME */

#define BP_ENET_MAC0_ATIME_ATIME      0
#define BM_ENET_MAC0_ATIME_ATIME      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_ATIME_ATIME(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_ATIME_ATIME(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_ATIME(v)   (HW_ENET_MAC0_ATIME.B.ATIME = (v))
#endif



/*
 * HW_ENET_MAC0_ATIME_EVT_OFFSET - ENET MAC0 IEEE1588 Offsetvalue for one-shot event generation Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ATIME_EVT_OFFSET  : 32;
    } B;
} hw_enet_mac0_atime_evt_offset_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_ATIME_EVT_OFFSET register
 */
#define HW_ENET_MAC0_ATIME_EVT_OFFSET_ADDR         (REGS_ENET_BASE + 0x408)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_ATIME_EVT_OFFSET           (*(volatile hw_enet_mac0_atime_evt_offset_t *) HW_ENET_MAC0_ATIME_EVT_OFFSET_ADDR)
#define HW_ENET_MAC0_ATIME_EVT_OFFSET_RD()      (HW_ENET_MAC0_ATIME_EVT_OFFSET.U)
#define HW_ENET_MAC0_ATIME_EVT_OFFSET_WR(v)     (HW_ENET_MAC0_ATIME_EVT_OFFSET.U = (v))
#define HW_ENET_MAC0_ATIME_EVT_OFFSET_SET(v)    (HW_ENET_MAC0_ATIME_EVT_OFFSET_WR(HW_ENET_MAC0_ATIME_EVT_OFFSET_RD() |  (v)))
#define HW_ENET_MAC0_ATIME_EVT_OFFSET_CLR(v)    (HW_ENET_MAC0_ATIME_EVT_OFFSET_WR(HW_ENET_MAC0_ATIME_EVT_OFFSET_RD() & ~(v)))
#define HW_ENET_MAC0_ATIME_EVT_OFFSET_TOG(v)    (HW_ENET_MAC0_ATIME_EVT_OFFSET_WR(HW_ENET_MAC0_ATIME_EVT_OFFSET_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_ATIME_EVT_OFFSET bitfields
 */
/* --- Register HW_ENET_MAC0_ATIME_EVT_OFFSET, field ATIME_EVT_OFFSET */

#define BP_ENET_MAC0_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET      0
#define BM_ENET_MAC0_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET(v)   (HW_ENET_MAC0_ATIME_EVT_OFFSET.B.ATIME_EVT_OFFSET = (v))
#endif



/*
 * HW_ENET_MAC0_ATIME_EVT_PERIOD - ENET MAC0 IEEE1588 Timer Period Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ATIME_EVT_PERIOD  : 32;
    } B;
} hw_enet_mac0_atime_evt_period_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_ATIME_EVT_PERIOD register
 */
#define HW_ENET_MAC0_ATIME_EVT_PERIOD_ADDR         (REGS_ENET_BASE + 0x40c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_ATIME_EVT_PERIOD           (*(volatile hw_enet_mac0_atime_evt_period_t *) HW_ENET_MAC0_ATIME_EVT_PERIOD_ADDR)
#define HW_ENET_MAC0_ATIME_EVT_PERIOD_RD()      (HW_ENET_MAC0_ATIME_EVT_PERIOD.U)
#define HW_ENET_MAC0_ATIME_EVT_PERIOD_WR(v)     (HW_ENET_MAC0_ATIME_EVT_PERIOD.U = (v))
#define HW_ENET_MAC0_ATIME_EVT_PERIOD_SET(v)    (HW_ENET_MAC0_ATIME_EVT_PERIOD_WR(HW_ENET_MAC0_ATIME_EVT_PERIOD_RD() |  (v)))
#define HW_ENET_MAC0_ATIME_EVT_PERIOD_CLR(v)    (HW_ENET_MAC0_ATIME_EVT_PERIOD_WR(HW_ENET_MAC0_ATIME_EVT_PERIOD_RD() & ~(v)))
#define HW_ENET_MAC0_ATIME_EVT_PERIOD_TOG(v)    (HW_ENET_MAC0_ATIME_EVT_PERIOD_WR(HW_ENET_MAC0_ATIME_EVT_PERIOD_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_ATIME_EVT_PERIOD bitfields
 */
/* --- Register HW_ENET_MAC0_ATIME_EVT_PERIOD, field ATIME_EVT_PERIOD */

#define BP_ENET_MAC0_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD      0
#define BM_ENET_MAC0_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD(v)   (HW_ENET_MAC0_ATIME_EVT_PERIOD.B.ATIME_EVT_PERIOD = (v))
#endif



/*
 * HW_ENET_MAC0_ATIME_CORR - ENET MAC0 IEEE1588 Correction counter wrap around value Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ATIME_CORR  : 31;
        unsigned RSRVD0      :  1;
    } B;
} hw_enet_mac0_atime_corr_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_ATIME_CORR register
 */
#define HW_ENET_MAC0_ATIME_CORR_ADDR         (REGS_ENET_BASE + 0x410)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_ATIME_CORR           (*(volatile hw_enet_mac0_atime_corr_t *) HW_ENET_MAC0_ATIME_CORR_ADDR)
#define HW_ENET_MAC0_ATIME_CORR_RD()      (HW_ENET_MAC0_ATIME_CORR.U)
#define HW_ENET_MAC0_ATIME_CORR_WR(v)     (HW_ENET_MAC0_ATIME_CORR.U = (v))
#define HW_ENET_MAC0_ATIME_CORR_SET(v)    (HW_ENET_MAC0_ATIME_CORR_WR(HW_ENET_MAC0_ATIME_CORR_RD() |  (v)))
#define HW_ENET_MAC0_ATIME_CORR_CLR(v)    (HW_ENET_MAC0_ATIME_CORR_WR(HW_ENET_MAC0_ATIME_CORR_RD() & ~(v)))
#define HW_ENET_MAC0_ATIME_CORR_TOG(v)    (HW_ENET_MAC0_ATIME_CORR_WR(HW_ENET_MAC0_ATIME_CORR_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_ATIME_CORR bitfields
 */
/* --- Register HW_ENET_MAC0_ATIME_CORR, field RSRVD0 */

#define BP_ENET_MAC0_ATIME_CORR_RSRVD0      31
#define BM_ENET_MAC0_ATIME_CORR_RSRVD0      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_ATIME_CORR_RSRVD0(v)   ((((reg32_t) v) << 31) & BM_ENET_MAC0_ATIME_CORR_RSRVD0)
#else
#define BF_ENET_MAC0_ATIME_CORR_RSRVD0(v)   (((v) << 31) & BM_ENET_MAC0_ATIME_CORR_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_ATIME_CORR, field ATIME_CORR */

#define BP_ENET_MAC0_ATIME_CORR_ATIME_CORR      0
#define BM_ENET_MAC0_ATIME_CORR_ATIME_CORR      0x7FFFFFFF

#define BF_ENET_MAC0_ATIME_CORR_ATIME_CORR(v)   (((v) << 0) & BM_ENET_MAC0_ATIME_CORR_ATIME_CORR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_CORR_ATIME_CORR(v)   BF_CS1(ENET_MAC0_ATIME_CORR, ATIME_CORR, v)
#endif



/*
 * HW_ENET_MAC0_ATIME_INC - ENET MAC0 IEEE1588 Clock period of the timestamping clock (ts_clk) in nanoseconds and correction increment Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ATIME_INC       :  7;
        unsigned RSRVD1          :  1;
        unsigned ATIME_INC_CORR  :  7;
        unsigned RSRVD0          : 17;
    } B;
} hw_enet_mac0_atime_inc_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_ATIME_INC register
 */
#define HW_ENET_MAC0_ATIME_INC_ADDR         (REGS_ENET_BASE + 0x414)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_ATIME_INC           (*(volatile hw_enet_mac0_atime_inc_t *) HW_ENET_MAC0_ATIME_INC_ADDR)
#define HW_ENET_MAC0_ATIME_INC_RD()      (HW_ENET_MAC0_ATIME_INC.U)
#define HW_ENET_MAC0_ATIME_INC_WR(v)     (HW_ENET_MAC0_ATIME_INC.U = (v))
#define HW_ENET_MAC0_ATIME_INC_SET(v)    (HW_ENET_MAC0_ATIME_INC_WR(HW_ENET_MAC0_ATIME_INC_RD() |  (v)))
#define HW_ENET_MAC0_ATIME_INC_CLR(v)    (HW_ENET_MAC0_ATIME_INC_WR(HW_ENET_MAC0_ATIME_INC_RD() & ~(v)))
#define HW_ENET_MAC0_ATIME_INC_TOG(v)    (HW_ENET_MAC0_ATIME_INC_WR(HW_ENET_MAC0_ATIME_INC_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_ATIME_INC bitfields
 */
/* --- Register HW_ENET_MAC0_ATIME_INC, field RSRVD0 */

#define BP_ENET_MAC0_ATIME_INC_RSRVD0      15
#define BM_ENET_MAC0_ATIME_INC_RSRVD0      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_ATIME_INC_RSRVD0(v)   ((((reg32_t) v) << 15) & BM_ENET_MAC0_ATIME_INC_RSRVD0)
#else
#define BF_ENET_MAC0_ATIME_INC_RSRVD0(v)   (((v) << 15) & BM_ENET_MAC0_ATIME_INC_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_ATIME_INC, field ATIME_INC_CORR */

#define BP_ENET_MAC0_ATIME_INC_ATIME_INC_CORR      8
#define BM_ENET_MAC0_ATIME_INC_ATIME_INC_CORR      0x00007F00

#define BF_ENET_MAC0_ATIME_INC_ATIME_INC_CORR(v)   (((v) << 8) & BM_ENET_MAC0_ATIME_INC_ATIME_INC_CORR)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_INC_ATIME_INC_CORR(v)   BF_CS1(ENET_MAC0_ATIME_INC, ATIME_INC_CORR, v)
#endif

/* --- Register HW_ENET_MAC0_ATIME_INC, field RSRVD1 */

#define BP_ENET_MAC0_ATIME_INC_RSRVD1      7
#define BM_ENET_MAC0_ATIME_INC_RSRVD1      0x00000080

#define BF_ENET_MAC0_ATIME_INC_RSRVD1(v)   (((v) << 7) & BM_ENET_MAC0_ATIME_INC_RSRVD1)
/* --- Register HW_ENET_MAC0_ATIME_INC, field ATIME_INC */

#define BP_ENET_MAC0_ATIME_INC_ATIME_INC      0
#define BM_ENET_MAC0_ATIME_INC_ATIME_INC      0x0000007F

#define BF_ENET_MAC0_ATIME_INC_ATIME_INC(v)   (((v) << 0) & BM_ENET_MAC0_ATIME_INC_ATIME_INC)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_ATIME_INC_ATIME_INC(v)   BF_CS1(ENET_MAC0_ATIME_INC, ATIME_INC, v)
#endif



/*
 * HW_ENET_MAC0_TS_TIMESTAMP - ENET MAC0 IEEE1588 Timestamp of the last Frame Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TS_TIMESTAMP  : 32;
    } B;
} hw_enet_mac0_ts_timestamp_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_TS_TIMESTAMP register
 */
#define HW_ENET_MAC0_TS_TIMESTAMP_ADDR         (REGS_ENET_BASE + 0x418)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_TS_TIMESTAMP           (*(volatile hw_enet_mac0_ts_timestamp_t *) HW_ENET_MAC0_TS_TIMESTAMP_ADDR)
#define HW_ENET_MAC0_TS_TIMESTAMP_RD()      (HW_ENET_MAC0_TS_TIMESTAMP.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_TS_TIMESTAMP bitfields
 */
/* --- Register HW_ENET_MAC0_TS_TIMESTAMP, field TS_TIMESTAMP */

#define BP_ENET_MAC0_TS_TIMESTAMP_TS_TIMESTAMP      0
#define BM_ENET_MAC0_TS_TIMESTAMP_TS_TIMESTAMP      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_TS_TIMESTAMP_TS_TIMESTAMP(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_TS_TIMESTAMP_TS_TIMESTAMP(v)   (v)
#endif


/*
 * HW_ENET_MAC0_SMAC_0_0 - ENET MAC0 Supplemental MAC Address 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SMAC_0_0  : 32;
    } B;
} hw_enet_mac0_smac_0_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_SMAC_0_0 register
 */
#define HW_ENET_MAC0_SMAC_0_0_ADDR         (REGS_ENET_BASE + 0x500)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_SMAC_0_0           (*(volatile hw_enet_mac0_smac_0_0_t *) HW_ENET_MAC0_SMAC_0_0_ADDR)
#define HW_ENET_MAC0_SMAC_0_0_RD()      (HW_ENET_MAC0_SMAC_0_0.U)
#define HW_ENET_MAC0_SMAC_0_0_WR(v)     (HW_ENET_MAC0_SMAC_0_0.U = (v))
#define HW_ENET_MAC0_SMAC_0_0_SET(v)    (HW_ENET_MAC0_SMAC_0_0_WR(HW_ENET_MAC0_SMAC_0_0_RD() |  (v)))
#define HW_ENET_MAC0_SMAC_0_0_CLR(v)    (HW_ENET_MAC0_SMAC_0_0_WR(HW_ENET_MAC0_SMAC_0_0_RD() & ~(v)))
#define HW_ENET_MAC0_SMAC_0_0_TOG(v)    (HW_ENET_MAC0_SMAC_0_0_WR(HW_ENET_MAC0_SMAC_0_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_SMAC_0_0 bitfields
 */
/* --- Register HW_ENET_MAC0_SMAC_0_0, field SMAC_0_0 */

#define BP_ENET_MAC0_SMAC_0_0_SMAC_0_0      0
#define BM_ENET_MAC0_SMAC_0_0_SMAC_0_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_SMAC_0_0_SMAC_0_0(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_SMAC_0_0_SMAC_0_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_SMAC_0_0_SMAC_0_0(v)   (HW_ENET_MAC0_SMAC_0_0.B.SMAC_0_0 = (v))
#endif



/*
 * HW_ENET_MAC0_SMAC_0_1 - ENET MAC0 Supplemental MAC Address 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SMAC_0_1  : 32;
    } B;
} hw_enet_mac0_smac_0_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_SMAC_0_1 register
 */
#define HW_ENET_MAC0_SMAC_0_1_ADDR         (REGS_ENET_BASE + 0x504)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_SMAC_0_1           (*(volatile hw_enet_mac0_smac_0_1_t *) HW_ENET_MAC0_SMAC_0_1_ADDR)
#define HW_ENET_MAC0_SMAC_0_1_RD()      (HW_ENET_MAC0_SMAC_0_1.U)
#define HW_ENET_MAC0_SMAC_0_1_WR(v)     (HW_ENET_MAC0_SMAC_0_1.U = (v))
#define HW_ENET_MAC0_SMAC_0_1_SET(v)    (HW_ENET_MAC0_SMAC_0_1_WR(HW_ENET_MAC0_SMAC_0_1_RD() |  (v)))
#define HW_ENET_MAC0_SMAC_0_1_CLR(v)    (HW_ENET_MAC0_SMAC_0_1_WR(HW_ENET_MAC0_SMAC_0_1_RD() & ~(v)))
#define HW_ENET_MAC0_SMAC_0_1_TOG(v)    (HW_ENET_MAC0_SMAC_0_1_WR(HW_ENET_MAC0_SMAC_0_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_SMAC_0_1 bitfields
 */
/* --- Register HW_ENET_MAC0_SMAC_0_1, field SMAC_0_1 */

#define BP_ENET_MAC0_SMAC_0_1_SMAC_0_1      0
#define BM_ENET_MAC0_SMAC_0_1_SMAC_0_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_SMAC_0_1_SMAC_0_1(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_SMAC_0_1_SMAC_0_1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_SMAC_0_1_SMAC_0_1(v)   (HW_ENET_MAC0_SMAC_0_1.B.SMAC_0_1 = (v))
#endif



/*
 * HW_ENET_MAC0_SMAC_1_0 - ENET MAC0 Supplemental MAC Address 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SMAC_1_0  : 32;
    } B;
} hw_enet_mac0_smac_1_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_SMAC_1_0 register
 */
#define HW_ENET_MAC0_SMAC_1_0_ADDR         (REGS_ENET_BASE + 0x508)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_SMAC_1_0           (*(volatile hw_enet_mac0_smac_1_0_t *) HW_ENET_MAC0_SMAC_1_0_ADDR)
#define HW_ENET_MAC0_SMAC_1_0_RD()      (HW_ENET_MAC0_SMAC_1_0.U)
#define HW_ENET_MAC0_SMAC_1_0_WR(v)     (HW_ENET_MAC0_SMAC_1_0.U = (v))
#define HW_ENET_MAC0_SMAC_1_0_SET(v)    (HW_ENET_MAC0_SMAC_1_0_WR(HW_ENET_MAC0_SMAC_1_0_RD() |  (v)))
#define HW_ENET_MAC0_SMAC_1_0_CLR(v)    (HW_ENET_MAC0_SMAC_1_0_WR(HW_ENET_MAC0_SMAC_1_0_RD() & ~(v)))
#define HW_ENET_MAC0_SMAC_1_0_TOG(v)    (HW_ENET_MAC0_SMAC_1_0_WR(HW_ENET_MAC0_SMAC_1_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_SMAC_1_0 bitfields
 */
/* --- Register HW_ENET_MAC0_SMAC_1_0, field SMAC_1_0 */

#define BP_ENET_MAC0_SMAC_1_0_SMAC_1_0      0
#define BM_ENET_MAC0_SMAC_1_0_SMAC_1_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_SMAC_1_0_SMAC_1_0(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_SMAC_1_0_SMAC_1_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_SMAC_1_0_SMAC_1_0(v)   (HW_ENET_MAC0_SMAC_1_0.B.SMAC_1_0 = (v))
#endif



/*
 * HW_ENET_MAC0_SMAC_1_1 - ENET MAC0 Supplemental MAC Address 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SMAC_1_1  : 32;
    } B;
} hw_enet_mac0_smac_1_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_SMAC_1_1 register
 */
#define HW_ENET_MAC0_SMAC_1_1_ADDR         (REGS_ENET_BASE + 0x50c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_SMAC_1_1           (*(volatile hw_enet_mac0_smac_1_1_t *) HW_ENET_MAC0_SMAC_1_1_ADDR)
#define HW_ENET_MAC0_SMAC_1_1_RD()      (HW_ENET_MAC0_SMAC_1_1.U)
#define HW_ENET_MAC0_SMAC_1_1_WR(v)     (HW_ENET_MAC0_SMAC_1_1.U = (v))
#define HW_ENET_MAC0_SMAC_1_1_SET(v)    (HW_ENET_MAC0_SMAC_1_1_WR(HW_ENET_MAC0_SMAC_1_1_RD() |  (v)))
#define HW_ENET_MAC0_SMAC_1_1_CLR(v)    (HW_ENET_MAC0_SMAC_1_1_WR(HW_ENET_MAC0_SMAC_1_1_RD() & ~(v)))
#define HW_ENET_MAC0_SMAC_1_1_TOG(v)    (HW_ENET_MAC0_SMAC_1_1_WR(HW_ENET_MAC0_SMAC_1_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_SMAC_1_1 bitfields
 */
/* --- Register HW_ENET_MAC0_SMAC_1_1, field SMAC_1_1 */

#define BP_ENET_MAC0_SMAC_1_1_SMAC_1_1      0
#define BM_ENET_MAC0_SMAC_1_1_SMAC_1_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_SMAC_1_1_SMAC_1_1(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_SMAC_1_1_SMAC_1_1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_SMAC_1_1_SMAC_1_1(v)   (HW_ENET_MAC0_SMAC_1_1.B.SMAC_1_1 = (v))
#endif



/*
 * HW_ENET_MAC0_SMAC_2_0 - ENET MAC0 Supplemental MAC Address 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SMAC_2_0  : 32;
    } B;
} hw_enet_mac0_smac_2_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_SMAC_2_0 register
 */
#define HW_ENET_MAC0_SMAC_2_0_ADDR         (REGS_ENET_BASE + 0x510)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_SMAC_2_0           (*(volatile hw_enet_mac0_smac_2_0_t *) HW_ENET_MAC0_SMAC_2_0_ADDR)
#define HW_ENET_MAC0_SMAC_2_0_RD()      (HW_ENET_MAC0_SMAC_2_0.U)
#define HW_ENET_MAC0_SMAC_2_0_WR(v)     (HW_ENET_MAC0_SMAC_2_0.U = (v))
#define HW_ENET_MAC0_SMAC_2_0_SET(v)    (HW_ENET_MAC0_SMAC_2_0_WR(HW_ENET_MAC0_SMAC_2_0_RD() |  (v)))
#define HW_ENET_MAC0_SMAC_2_0_CLR(v)    (HW_ENET_MAC0_SMAC_2_0_WR(HW_ENET_MAC0_SMAC_2_0_RD() & ~(v)))
#define HW_ENET_MAC0_SMAC_2_0_TOG(v)    (HW_ENET_MAC0_SMAC_2_0_WR(HW_ENET_MAC0_SMAC_2_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_SMAC_2_0 bitfields
 */
/* --- Register HW_ENET_MAC0_SMAC_2_0, field SMAC_2_0 */

#define BP_ENET_MAC0_SMAC_2_0_SMAC_2_0      0
#define BM_ENET_MAC0_SMAC_2_0_SMAC_2_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_SMAC_2_0_SMAC_2_0(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_SMAC_2_0_SMAC_2_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_SMAC_2_0_SMAC_2_0(v)   (HW_ENET_MAC0_SMAC_2_0.B.SMAC_2_0 = (v))
#endif



/*
 * HW_ENET_MAC0_SMAC_2_1 - ENET MAC0 Supplemental MAC Address 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SMAC_2_1  : 32;
    } B;
} hw_enet_mac0_smac_2_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_SMAC_2_1 register
 */
#define HW_ENET_MAC0_SMAC_2_1_ADDR         (REGS_ENET_BASE + 0x514)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_SMAC_2_1           (*(volatile hw_enet_mac0_smac_2_1_t *) HW_ENET_MAC0_SMAC_2_1_ADDR)
#define HW_ENET_MAC0_SMAC_2_1_RD()      (HW_ENET_MAC0_SMAC_2_1.U)
#define HW_ENET_MAC0_SMAC_2_1_WR(v)     (HW_ENET_MAC0_SMAC_2_1.U = (v))
#define HW_ENET_MAC0_SMAC_2_1_SET(v)    (HW_ENET_MAC0_SMAC_2_1_WR(HW_ENET_MAC0_SMAC_2_1_RD() |  (v)))
#define HW_ENET_MAC0_SMAC_2_1_CLR(v)    (HW_ENET_MAC0_SMAC_2_1_WR(HW_ENET_MAC0_SMAC_2_1_RD() & ~(v)))
#define HW_ENET_MAC0_SMAC_2_1_TOG(v)    (HW_ENET_MAC0_SMAC_2_1_WR(HW_ENET_MAC0_SMAC_2_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_SMAC_2_1 bitfields
 */
/* --- Register HW_ENET_MAC0_SMAC_2_1, field SMAC_2_1 */

#define BP_ENET_MAC0_SMAC_2_1_SMAC_2_1      0
#define BM_ENET_MAC0_SMAC_2_1_SMAC_2_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_SMAC_2_1_SMAC_2_1(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_SMAC_2_1_SMAC_2_1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_SMAC_2_1_SMAC_2_1(v)   (HW_ENET_MAC0_SMAC_2_1.B.SMAC_2_1 = (v))
#endif



/*
 * HW_ENET_MAC0_SMAC_3_0 - ENET MAC0 Supplemental MAC Address 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SMAC_3_0  : 32;
    } B;
} hw_enet_mac0_smac_3_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_SMAC_3_0 register
 */
#define HW_ENET_MAC0_SMAC_3_0_ADDR         (REGS_ENET_BASE + 0x518)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_SMAC_3_0           (*(volatile hw_enet_mac0_smac_3_0_t *) HW_ENET_MAC0_SMAC_3_0_ADDR)
#define HW_ENET_MAC0_SMAC_3_0_RD()      (HW_ENET_MAC0_SMAC_3_0.U)
#define HW_ENET_MAC0_SMAC_3_0_WR(v)     (HW_ENET_MAC0_SMAC_3_0.U = (v))
#define HW_ENET_MAC0_SMAC_3_0_SET(v)    (HW_ENET_MAC0_SMAC_3_0_WR(HW_ENET_MAC0_SMAC_3_0_RD() |  (v)))
#define HW_ENET_MAC0_SMAC_3_0_CLR(v)    (HW_ENET_MAC0_SMAC_3_0_WR(HW_ENET_MAC0_SMAC_3_0_RD() & ~(v)))
#define HW_ENET_MAC0_SMAC_3_0_TOG(v)    (HW_ENET_MAC0_SMAC_3_0_WR(HW_ENET_MAC0_SMAC_3_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_SMAC_3_0 bitfields
 */
/* --- Register HW_ENET_MAC0_SMAC_3_0, field SMAC_3_0 */

#define BP_ENET_MAC0_SMAC_3_0_SMAC_3_0      0
#define BM_ENET_MAC0_SMAC_3_0_SMAC_3_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_SMAC_3_0_SMAC_3_0(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_SMAC_3_0_SMAC_3_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_SMAC_3_0_SMAC_3_0(v)   (HW_ENET_MAC0_SMAC_3_0.B.SMAC_3_0 = (v))
#endif



/*
 * HW_ENET_MAC0_SMAC_3_1 - ENET MAC0 Supplemental MAC Address 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SMAC_3_1  : 32;
    } B;
} hw_enet_mac0_smac_3_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_SMAC_3_1 register
 */
#define HW_ENET_MAC0_SMAC_3_1_ADDR         (REGS_ENET_BASE + 0x51c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_SMAC_3_1           (*(volatile hw_enet_mac0_smac_3_1_t *) HW_ENET_MAC0_SMAC_3_1_ADDR)
#define HW_ENET_MAC0_SMAC_3_1_RD()      (HW_ENET_MAC0_SMAC_3_1.U)
#define HW_ENET_MAC0_SMAC_3_1_WR(v)     (HW_ENET_MAC0_SMAC_3_1.U = (v))
#define HW_ENET_MAC0_SMAC_3_1_SET(v)    (HW_ENET_MAC0_SMAC_3_1_WR(HW_ENET_MAC0_SMAC_3_1_RD() |  (v)))
#define HW_ENET_MAC0_SMAC_3_1_CLR(v)    (HW_ENET_MAC0_SMAC_3_1_WR(HW_ENET_MAC0_SMAC_3_1_RD() & ~(v)))
#define HW_ENET_MAC0_SMAC_3_1_TOG(v)    (HW_ENET_MAC0_SMAC_3_1_WR(HW_ENET_MAC0_SMAC_3_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_SMAC_3_1 bitfields
 */
/* --- Register HW_ENET_MAC0_SMAC_3_1, field SMAC_3_1 */

#define BP_ENET_MAC0_SMAC_3_1_SMAC_3_1      0
#define BM_ENET_MAC0_SMAC_3_1_SMAC_3_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_SMAC_3_1_SMAC_3_1(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_SMAC_3_1_SMAC_3_1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_SMAC_3_1_SMAC_3_1(v)   (HW_ENET_MAC0_SMAC_3_1.B.SMAC_3_1 = (v))
#endif



/*
 * HW_ENET_MAC0_COMP_REG_0 - ENET MAC0 Compare register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COMP_REG_0  : 32;
    } B;
} hw_enet_mac0_comp_reg_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_COMP_REG_0 register
 */
#define HW_ENET_MAC0_COMP_REG_0_ADDR         (REGS_ENET_BASE + 0x600)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_COMP_REG_0           (*(volatile hw_enet_mac0_comp_reg_0_t *) HW_ENET_MAC0_COMP_REG_0_ADDR)
#define HW_ENET_MAC0_COMP_REG_0_RD()      (HW_ENET_MAC0_COMP_REG_0.U)
#define HW_ENET_MAC0_COMP_REG_0_WR(v)     (HW_ENET_MAC0_COMP_REG_0.U = (v))
#define HW_ENET_MAC0_COMP_REG_0_SET(v)    (HW_ENET_MAC0_COMP_REG_0_WR(HW_ENET_MAC0_COMP_REG_0_RD() |  (v)))
#define HW_ENET_MAC0_COMP_REG_0_CLR(v)    (HW_ENET_MAC0_COMP_REG_0_WR(HW_ENET_MAC0_COMP_REG_0_RD() & ~(v)))
#define HW_ENET_MAC0_COMP_REG_0_TOG(v)    (HW_ENET_MAC0_COMP_REG_0_WR(HW_ENET_MAC0_COMP_REG_0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_COMP_REG_0 bitfields
 */
/* --- Register HW_ENET_MAC0_COMP_REG_0, field COMP_REG_0 */

#define BP_ENET_MAC0_COMP_REG_0_COMP_REG_0      0
#define BM_ENET_MAC0_COMP_REG_0_COMP_REG_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_COMP_REG_0_COMP_REG_0(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_COMP_REG_0_COMP_REG_0(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_COMP_REG_0_COMP_REG_0(v)   (HW_ENET_MAC0_COMP_REG_0.B.COMP_REG_0 = (v))
#endif



/*
 * HW_ENET_MAC0_COMP_REG_1 - ENET MAC0 Compare register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COMP_REG_1  : 32;
    } B;
} hw_enet_mac0_comp_reg_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_COMP_REG_1 register
 */
#define HW_ENET_MAC0_COMP_REG_1_ADDR         (REGS_ENET_BASE + 0x604)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_COMP_REG_1           (*(volatile hw_enet_mac0_comp_reg_1_t *) HW_ENET_MAC0_COMP_REG_1_ADDR)
#define HW_ENET_MAC0_COMP_REG_1_RD()      (HW_ENET_MAC0_COMP_REG_1.U)
#define HW_ENET_MAC0_COMP_REG_1_WR(v)     (HW_ENET_MAC0_COMP_REG_1.U = (v))
#define HW_ENET_MAC0_COMP_REG_1_SET(v)    (HW_ENET_MAC0_COMP_REG_1_WR(HW_ENET_MAC0_COMP_REG_1_RD() |  (v)))
#define HW_ENET_MAC0_COMP_REG_1_CLR(v)    (HW_ENET_MAC0_COMP_REG_1_WR(HW_ENET_MAC0_COMP_REG_1_RD() & ~(v)))
#define HW_ENET_MAC0_COMP_REG_1_TOG(v)    (HW_ENET_MAC0_COMP_REG_1_WR(HW_ENET_MAC0_COMP_REG_1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_COMP_REG_1 bitfields
 */
/* --- Register HW_ENET_MAC0_COMP_REG_1, field COMP_REG_1 */

#define BP_ENET_MAC0_COMP_REG_1_COMP_REG_1      0
#define BM_ENET_MAC0_COMP_REG_1_COMP_REG_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_COMP_REG_1_COMP_REG_1(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_COMP_REG_1_COMP_REG_1(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_COMP_REG_1_COMP_REG_1(v)   (HW_ENET_MAC0_COMP_REG_1.B.COMP_REG_1 = (v))
#endif



/*
 * HW_ENET_MAC0_COMP_REG_2 - ENET MAC0 Compare register 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COMP_REG_2  : 32;
    } B;
} hw_enet_mac0_comp_reg_2_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_COMP_REG_2 register
 */
#define HW_ENET_MAC0_COMP_REG_2_ADDR         (REGS_ENET_BASE + 0x608)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_COMP_REG_2           (*(volatile hw_enet_mac0_comp_reg_2_t *) HW_ENET_MAC0_COMP_REG_2_ADDR)
#define HW_ENET_MAC0_COMP_REG_2_RD()      (HW_ENET_MAC0_COMP_REG_2.U)
#define HW_ENET_MAC0_COMP_REG_2_WR(v)     (HW_ENET_MAC0_COMP_REG_2.U = (v))
#define HW_ENET_MAC0_COMP_REG_2_SET(v)    (HW_ENET_MAC0_COMP_REG_2_WR(HW_ENET_MAC0_COMP_REG_2_RD() |  (v)))
#define HW_ENET_MAC0_COMP_REG_2_CLR(v)    (HW_ENET_MAC0_COMP_REG_2_WR(HW_ENET_MAC0_COMP_REG_2_RD() & ~(v)))
#define HW_ENET_MAC0_COMP_REG_2_TOG(v)    (HW_ENET_MAC0_COMP_REG_2_WR(HW_ENET_MAC0_COMP_REG_2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_COMP_REG_2 bitfields
 */
/* --- Register HW_ENET_MAC0_COMP_REG_2, field COMP_REG_2 */

#define BP_ENET_MAC0_COMP_REG_2_COMP_REG_2      0
#define BM_ENET_MAC0_COMP_REG_2_COMP_REG_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_COMP_REG_2_COMP_REG_2(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_COMP_REG_2_COMP_REG_2(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_COMP_REG_2_COMP_REG_2(v)   (HW_ENET_MAC0_COMP_REG_2.B.COMP_REG_2 = (v))
#endif



/*
 * HW_ENET_MAC0_COMP_REG_3 - ENET MAC0 Compare register 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COMP_REG_3  : 32;
    } B;
} hw_enet_mac0_comp_reg_3_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_COMP_REG_3 register
 */
#define HW_ENET_MAC0_COMP_REG_3_ADDR         (REGS_ENET_BASE + 0x60c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_COMP_REG_3           (*(volatile hw_enet_mac0_comp_reg_3_t *) HW_ENET_MAC0_COMP_REG_3_ADDR)
#define HW_ENET_MAC0_COMP_REG_3_RD()      (HW_ENET_MAC0_COMP_REG_3.U)
#define HW_ENET_MAC0_COMP_REG_3_WR(v)     (HW_ENET_MAC0_COMP_REG_3.U = (v))
#define HW_ENET_MAC0_COMP_REG_3_SET(v)    (HW_ENET_MAC0_COMP_REG_3_WR(HW_ENET_MAC0_COMP_REG_3_RD() |  (v)))
#define HW_ENET_MAC0_COMP_REG_3_CLR(v)    (HW_ENET_MAC0_COMP_REG_3_WR(HW_ENET_MAC0_COMP_REG_3_RD() & ~(v)))
#define HW_ENET_MAC0_COMP_REG_3_TOG(v)    (HW_ENET_MAC0_COMP_REG_3_WR(HW_ENET_MAC0_COMP_REG_3_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_COMP_REG_3 bitfields
 */
/* --- Register HW_ENET_MAC0_COMP_REG_3, field COMP_REG_3 */

#define BP_ENET_MAC0_COMP_REG_3_COMP_REG_3      0
#define BM_ENET_MAC0_COMP_REG_3_COMP_REG_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_COMP_REG_3_COMP_REG_3(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_COMP_REG_3_COMP_REG_3(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_COMP_REG_3_COMP_REG_3(v)   (HW_ENET_MAC0_COMP_REG_3.B.COMP_REG_3 = (v))
#endif



/*
 * HW_ENET_MAC0_CAPT_REG_0 - ENET MAC0 Capture register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CAPT_REG_0  : 32;
    } B;
} hw_enet_mac0_capt_reg_0_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_CAPT_REG_0 register
 */
#define HW_ENET_MAC0_CAPT_REG_0_ADDR         (REGS_ENET_BASE + 0x640)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_CAPT_REG_0           (*(volatile hw_enet_mac0_capt_reg_0_t *) HW_ENET_MAC0_CAPT_REG_0_ADDR)
#define HW_ENET_MAC0_CAPT_REG_0_RD()      (HW_ENET_MAC0_CAPT_REG_0.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_CAPT_REG_0 bitfields
 */
/* --- Register HW_ENET_MAC0_CAPT_REG_0, field CAPT_REG_0 */

#define BP_ENET_MAC0_CAPT_REG_0_CAPT_REG_0      0
#define BM_ENET_MAC0_CAPT_REG_0_CAPT_REG_0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_CAPT_REG_0_CAPT_REG_0(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_CAPT_REG_0_CAPT_REG_0(v)   (v)
#endif


/*
 * HW_ENET_MAC0_CAPT_REG_1 - ENET MAC0 Capture register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CAPT_REG_1  : 32;
    } B;
} hw_enet_mac0_capt_reg_1_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_CAPT_REG_1 register
 */
#define HW_ENET_MAC0_CAPT_REG_1_ADDR         (REGS_ENET_BASE + 0x644)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_CAPT_REG_1           (*(volatile hw_enet_mac0_capt_reg_1_t *) HW_ENET_MAC0_CAPT_REG_1_ADDR)
#define HW_ENET_MAC0_CAPT_REG_1_RD()      (HW_ENET_MAC0_CAPT_REG_1.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_CAPT_REG_1 bitfields
 */
/* --- Register HW_ENET_MAC0_CAPT_REG_1, field CAPT_REG_1 */

#define BP_ENET_MAC0_CAPT_REG_1_CAPT_REG_1      0
#define BM_ENET_MAC0_CAPT_REG_1_CAPT_REG_1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_CAPT_REG_1_CAPT_REG_1(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_CAPT_REG_1_CAPT_REG_1(v)   (v)
#endif


/*
 * HW_ENET_MAC0_CAPT_REG_2 - ENET MAC0 Capture register 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CAPT_REG_2  : 32;
    } B;
} hw_enet_mac0_capt_reg_2_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_CAPT_REG_2 register
 */
#define HW_ENET_MAC0_CAPT_REG_2_ADDR         (REGS_ENET_BASE + 0x648)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_CAPT_REG_2           (*(volatile hw_enet_mac0_capt_reg_2_t *) HW_ENET_MAC0_CAPT_REG_2_ADDR)
#define HW_ENET_MAC0_CAPT_REG_2_RD()      (HW_ENET_MAC0_CAPT_REG_2.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_CAPT_REG_2 bitfields
 */
/* --- Register HW_ENET_MAC0_CAPT_REG_2, field CAPT_REG_2 */

#define BP_ENET_MAC0_CAPT_REG_2_CAPT_REG_2      0
#define BM_ENET_MAC0_CAPT_REG_2_CAPT_REG_2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_CAPT_REG_2_CAPT_REG_2(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_CAPT_REG_2_CAPT_REG_2(v)   (v)
#endif


/*
 * HW_ENET_MAC0_CAPT_REG_3 - ENET MAC0 Capture register 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CAPT_REG_3  : 32;
    } B;
} hw_enet_mac0_capt_reg_3_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_CAPT_REG_3 register
 */
#define HW_ENET_MAC0_CAPT_REG_3_ADDR         (REGS_ENET_BASE + 0x64c)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_CAPT_REG_3           (*(volatile hw_enet_mac0_capt_reg_3_t *) HW_ENET_MAC0_CAPT_REG_3_ADDR)
#define HW_ENET_MAC0_CAPT_REG_3_RD()      (HW_ENET_MAC0_CAPT_REG_3.U)
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_CAPT_REG_3 bitfields
 */
/* --- Register HW_ENET_MAC0_CAPT_REG_3, field CAPT_REG_3 */

#define BP_ENET_MAC0_CAPT_REG_3_CAPT_REG_3      0
#define BM_ENET_MAC0_CAPT_REG_3_CAPT_REG_3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_CAPT_REG_3_CAPT_REG_3(v)   ((reg32_t) v)
#else
#define BF_ENET_MAC0_CAPT_REG_3_CAPT_REG_3(v)   (v)
#endif


/*
 * HW_ENET_MAC0_CCB_INT - ENET MAC0 IEEE1588 Interrupt register.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CAPTURE0  :  1;
        unsigned CAPTURE1  :  1;
        unsigned CAPTURE2  :  1;
        unsigned CAPTURE3  :  1;
        unsigned RSRVD1    : 12;
        unsigned COMPARE0  :  1;
        unsigned COMPARE1  :  1;
        unsigned COMPARE2  :  1;
        unsigned COMPARE3  :  1;
        unsigned RSRVD0    : 12;
    } B;
} hw_enet_mac0_ccb_int_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_CCB_INT register
 */
#define HW_ENET_MAC0_CCB_INT_ADDR         (REGS_ENET_BASE + 0x680)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_CCB_INT           (*(volatile hw_enet_mac0_ccb_int_t *) HW_ENET_MAC0_CCB_INT_ADDR)
#define HW_ENET_MAC0_CCB_INT_RD()      (HW_ENET_MAC0_CCB_INT.U)
#define HW_ENET_MAC0_CCB_INT_WR(v)     (HW_ENET_MAC0_CCB_INT.U = (v))
#define HW_ENET_MAC0_CCB_INT_SET(v)    (HW_ENET_MAC0_CCB_INT_WR(HW_ENET_MAC0_CCB_INT_RD() |  (v)))
#define HW_ENET_MAC0_CCB_INT_CLR(v)    (HW_ENET_MAC0_CCB_INT_WR(HW_ENET_MAC0_CCB_INT_RD() & ~(v)))
#define HW_ENET_MAC0_CCB_INT_TOG(v)    (HW_ENET_MAC0_CCB_INT_WR(HW_ENET_MAC0_CCB_INT_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_CCB_INT bitfields
 */
/* --- Register HW_ENET_MAC0_CCB_INT, field RSRVD0 */

#define BP_ENET_MAC0_CCB_INT_RSRVD0      20
#define BM_ENET_MAC0_CCB_INT_RSRVD0      0xFFF00000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_CCB_INT_RSRVD0(v)   ((((reg32_t) v) << 20) & BM_ENET_MAC0_CCB_INT_RSRVD0)
#else
#define BF_ENET_MAC0_CCB_INT_RSRVD0(v)   (((v) << 20) & BM_ENET_MAC0_CCB_INT_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_CCB_INT, field COMPARE3 */

#define BP_ENET_MAC0_CCB_INT_COMPARE3      19
#define BM_ENET_MAC0_CCB_INT_COMPARE3      0x00080000

#define BF_ENET_MAC0_CCB_INT_COMPARE3(v)   (((v) << 19) & BM_ENET_MAC0_CCB_INT_COMPARE3)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_COMPARE3(v)   BF_CS1(ENET_MAC0_CCB_INT, COMPARE3, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT, field COMPARE2 */

#define BP_ENET_MAC0_CCB_INT_COMPARE2      18
#define BM_ENET_MAC0_CCB_INT_COMPARE2      0x00040000

#define BF_ENET_MAC0_CCB_INT_COMPARE2(v)   (((v) << 18) & BM_ENET_MAC0_CCB_INT_COMPARE2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_COMPARE2(v)   BF_CS1(ENET_MAC0_CCB_INT, COMPARE2, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT, field COMPARE1 */

#define BP_ENET_MAC0_CCB_INT_COMPARE1      17
#define BM_ENET_MAC0_CCB_INT_COMPARE1      0x00020000

#define BF_ENET_MAC0_CCB_INT_COMPARE1(v)   (((v) << 17) & BM_ENET_MAC0_CCB_INT_COMPARE1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_COMPARE1(v)   BF_CS1(ENET_MAC0_CCB_INT, COMPARE1, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT, field COMPARE0 */

#define BP_ENET_MAC0_CCB_INT_COMPARE0      16
#define BM_ENET_MAC0_CCB_INT_COMPARE0      0x00010000

#define BF_ENET_MAC0_CCB_INT_COMPARE0(v)   (((v) << 16) & BM_ENET_MAC0_CCB_INT_COMPARE0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_COMPARE0(v)   BF_CS1(ENET_MAC0_CCB_INT, COMPARE0, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT, field RSRVD1 */

#define BP_ENET_MAC0_CCB_INT_RSRVD1      4
#define BM_ENET_MAC0_CCB_INT_RSRVD1      0x0000FFF0

#define BF_ENET_MAC0_CCB_INT_RSRVD1(v)   (((v) << 4) & BM_ENET_MAC0_CCB_INT_RSRVD1)
/* --- Register HW_ENET_MAC0_CCB_INT, field CAPTURE3 */

#define BP_ENET_MAC0_CCB_INT_CAPTURE3      3
#define BM_ENET_MAC0_CCB_INT_CAPTURE3      0x00000008

#define BF_ENET_MAC0_CCB_INT_CAPTURE3(v)   (((v) << 3) & BM_ENET_MAC0_CCB_INT_CAPTURE3)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_CAPTURE3(v)   BF_CS1(ENET_MAC0_CCB_INT, CAPTURE3, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT, field CAPTURE2 */

#define BP_ENET_MAC0_CCB_INT_CAPTURE2      2
#define BM_ENET_MAC0_CCB_INT_CAPTURE2      0x00000004

#define BF_ENET_MAC0_CCB_INT_CAPTURE2(v)   (((v) << 2) & BM_ENET_MAC0_CCB_INT_CAPTURE2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_CAPTURE2(v)   BF_CS1(ENET_MAC0_CCB_INT, CAPTURE2, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT, field CAPTURE1 */

#define BP_ENET_MAC0_CCB_INT_CAPTURE1      1
#define BM_ENET_MAC0_CCB_INT_CAPTURE1      0x00000002

#define BF_ENET_MAC0_CCB_INT_CAPTURE1(v)   (((v) << 1) & BM_ENET_MAC0_CCB_INT_CAPTURE1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_CAPTURE1(v)   BF_CS1(ENET_MAC0_CCB_INT, CAPTURE1, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT, field CAPTURE0 */

#define BP_ENET_MAC0_CCB_INT_CAPTURE0      0
#define BM_ENET_MAC0_CCB_INT_CAPTURE0      0x00000001

#define BF_ENET_MAC0_CCB_INT_CAPTURE0(v)   (((v) << 0) & BM_ENET_MAC0_CCB_INT_CAPTURE0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_CAPTURE0(v)   BF_CS1(ENET_MAC0_CCB_INT, CAPTURE0, v)
#endif



/*
 * HW_ENET_MAC0_CCB_INT_MASK - ENET MAC0 IEEE1588 Interrupt enable mask register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CAPTURE0  :  1;
        unsigned CAPTURE1  :  1;
        unsigned CAPTURE2  :  1;
        unsigned CAPTURE3  :  1;
        unsigned RSRVD1    : 12;
        unsigned COMPARE0  :  1;
        unsigned COMPARE1  :  1;
        unsigned COMPARE2  :  1;
        unsigned COMPARE3  :  1;
        unsigned RSRVD0    : 12;
    } B;
} hw_enet_mac0_ccb_int_mask_t;
#endif

/*
 * constants & macros for entire HW_ENET_MAC0_CCB_INT_MASK register
 */
#define HW_ENET_MAC0_CCB_INT_MASK_ADDR         (REGS_ENET_BASE + 0x684)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MAC0_CCB_INT_MASK           (*(volatile hw_enet_mac0_ccb_int_mask_t *) HW_ENET_MAC0_CCB_INT_MASK_ADDR)
#define HW_ENET_MAC0_CCB_INT_MASK_RD()      (HW_ENET_MAC0_CCB_INT_MASK.U)
#define HW_ENET_MAC0_CCB_INT_MASK_WR(v)     (HW_ENET_MAC0_CCB_INT_MASK.U = (v))
#define HW_ENET_MAC0_CCB_INT_MASK_SET(v)    (HW_ENET_MAC0_CCB_INT_MASK_WR(HW_ENET_MAC0_CCB_INT_MASK_RD() |  (v)))
#define HW_ENET_MAC0_CCB_INT_MASK_CLR(v)    (HW_ENET_MAC0_CCB_INT_MASK_WR(HW_ENET_MAC0_CCB_INT_MASK_RD() & ~(v)))
#define HW_ENET_MAC0_CCB_INT_MASK_TOG(v)    (HW_ENET_MAC0_CCB_INT_MASK_WR(HW_ENET_MAC0_CCB_INT_MASK_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ENET_MAC0_CCB_INT_MASK bitfields
 */
/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field RSRVD0 */

#define BP_ENET_MAC0_CCB_INT_MASK_RSRVD0      20
#define BM_ENET_MAC0_CCB_INT_MASK_RSRVD0      0xFFF00000

#ifndef __LANGUAGE_ASM__
#define BF_ENET_MAC0_CCB_INT_MASK_RSRVD0(v)   ((((reg32_t) v) << 20) & BM_ENET_MAC0_CCB_INT_MASK_RSRVD0)
#else
#define BF_ENET_MAC0_CCB_INT_MASK_RSRVD0(v)   (((v) << 20) & BM_ENET_MAC0_CCB_INT_MASK_RSRVD0)
#endif
/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field COMPARE3 */

#define BP_ENET_MAC0_CCB_INT_MASK_COMPARE3      19
#define BM_ENET_MAC0_CCB_INT_MASK_COMPARE3      0x00080000

#define BF_ENET_MAC0_CCB_INT_MASK_COMPARE3(v)   (((v) << 19) & BM_ENET_MAC0_CCB_INT_MASK_COMPARE3)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_MASK_COMPARE3(v)   BF_CS1(ENET_MAC0_CCB_INT_MASK, COMPARE3, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field COMPARE2 */

#define BP_ENET_MAC0_CCB_INT_MASK_COMPARE2      18
#define BM_ENET_MAC0_CCB_INT_MASK_COMPARE2      0x00040000

#define BF_ENET_MAC0_CCB_INT_MASK_COMPARE2(v)   (((v) << 18) & BM_ENET_MAC0_CCB_INT_MASK_COMPARE2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_MASK_COMPARE2(v)   BF_CS1(ENET_MAC0_CCB_INT_MASK, COMPARE2, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field COMPARE1 */

#define BP_ENET_MAC0_CCB_INT_MASK_COMPARE1      17
#define BM_ENET_MAC0_CCB_INT_MASK_COMPARE1      0x00020000

#define BF_ENET_MAC0_CCB_INT_MASK_COMPARE1(v)   (((v) << 17) & BM_ENET_MAC0_CCB_INT_MASK_COMPARE1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_MASK_COMPARE1(v)   BF_CS1(ENET_MAC0_CCB_INT_MASK, COMPARE1, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field COMPARE0 */

#define BP_ENET_MAC0_CCB_INT_MASK_COMPARE0      16
#define BM_ENET_MAC0_CCB_INT_MASK_COMPARE0      0x00010000

#define BF_ENET_MAC0_CCB_INT_MASK_COMPARE0(v)   (((v) << 16) & BM_ENET_MAC0_CCB_INT_MASK_COMPARE0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_MASK_COMPARE0(v)   BF_CS1(ENET_MAC0_CCB_INT_MASK, COMPARE0, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field RSRVD1 */

#define BP_ENET_MAC0_CCB_INT_MASK_RSRVD1      4
#define BM_ENET_MAC0_CCB_INT_MASK_RSRVD1      0x0000FFF0

#define BF_ENET_MAC0_CCB_INT_MASK_RSRVD1(v)   (((v) << 4) & BM_ENET_MAC0_CCB_INT_MASK_RSRVD1)
/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field CAPTURE3 */

#define BP_ENET_MAC0_CCB_INT_MASK_CAPTURE3      3
#define BM_ENET_MAC0_CCB_INT_MASK_CAPTURE3      0x00000008

#define BF_ENET_MAC0_CCB_INT_MASK_CAPTURE3(v)   (((v) << 3) & BM_ENET_MAC0_CCB_INT_MASK_CAPTURE3)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_MASK_CAPTURE3(v)   BF_CS1(ENET_MAC0_CCB_INT_MASK, CAPTURE3, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field CAPTURE2 */

#define BP_ENET_MAC0_CCB_INT_MASK_CAPTURE2      2
#define BM_ENET_MAC0_CCB_INT_MASK_CAPTURE2      0x00000004

#define BF_ENET_MAC0_CCB_INT_MASK_CAPTURE2(v)   (((v) << 2) & BM_ENET_MAC0_CCB_INT_MASK_CAPTURE2)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_MASK_CAPTURE2(v)   BF_CS1(ENET_MAC0_CCB_INT_MASK, CAPTURE2, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field CAPTURE1 */

#define BP_ENET_MAC0_CCB_INT_MASK_CAPTURE1      1
#define BM_ENET_MAC0_CCB_INT_MASK_CAPTURE1      0x00000002

#define BF_ENET_MAC0_CCB_INT_MASK_CAPTURE1(v)   (((v) << 1) & BM_ENET_MAC0_CCB_INT_MASK_CAPTURE1)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_MASK_CAPTURE1(v)   BF_CS1(ENET_MAC0_CCB_INT_MASK, CAPTURE1, v)
#endif

/* --- Register HW_ENET_MAC0_CCB_INT_MASK, field CAPTURE0 */

#define BP_ENET_MAC0_CCB_INT_MASK_CAPTURE0      0
#define BM_ENET_MAC0_CCB_INT_MASK_CAPTURE0      0x00000001

#define BF_ENET_MAC0_CCB_INT_MASK_CAPTURE0(v)   (((v) << 0) & BM_ENET_MAC0_CCB_INT_MASK_CAPTURE0)
#ifndef __LANGUAGE_ASM__
#define BW_ENET_MAC0_CCB_INT_MASK_CAPTURE0(v)   BF_CS1(ENET_MAC0_CCB_INT_MASK, CAPTURE0, v)
#endif


#endif /* _EMACC_H */

////////////////////////////////////////////////////////////////////////////////
