/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.0
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _DIGCTL_H
#define _DIGCTL_H  1

#include "regs.h"

#ifndef REGS_DIGCTL_BASE
#define REGS_DIGCTL_BASE (REGS_BASE + 0x1c000)
#endif

/*
 * HW_DIGCTL_CTRL - DIGCTL Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LATCH_ENTROPY            :  1;
        unsigned JTAG_SHIELD              :  1;
        unsigned USB0_CLKGATE             :  1;
        unsigned DEBUG_DISABLE            :  1;
        unsigned RSVD0                    :  6;
        unsigned SAIF_CLKMUX_SEL          :  2;
        unsigned RSVD1                    :  1;
        unsigned AUART01_LOOPBACK         :  1;
        unsigned DUART_LOOPBACK           :  1;
        unsigned SAIF_LOOPBACK            :  1;
        unsigned USB1_CLKGATE             :  1;
        unsigned DIGITAL_TESTMODE         :  1;
        unsigned ANALOG_TESTMODE          :  1;
        unsigned USB0_TESTMODE            :  1;
        unsigned USB1_TESTMODE            :  1;
        unsigned USB0_OVERCURRENT_POL     :  1;
        unsigned USB1_OVERCURRENT_POL     :  1;
        unsigned USB0_OVERCURRENT_ENABLE  :  1;
        unsigned USB1_OVERCURRENT_ENABLE  :  1;
        unsigned RSVD2                    :  5;
        unsigned XTAL24M_GATE             :  1;
        unsigned RSVD3                    :  1;
    } B;
} hw_digctl_ctrl_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_CTRL register
 */
#define HW_DIGCTL_CTRL_ADDR         (REGS_DIGCTL_BASE + 0x0)
#define HW_DIGCTL_CTRL_SET_ADDR     (HW_DIGCTL_CTRL_ADDR + 4)
#define HW_DIGCTL_CTRL_CLR_ADDR     (HW_DIGCTL_CTRL_ADDR + 8)
#define HW_DIGCTL_CTRL_TOG_ADDR     (HW_DIGCTL_CTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_CTRL           (*(volatile hw_digctl_ctrl_t *) HW_DIGCTL_CTRL_ADDR)
#define HW_DIGCTL_CTRL_RD()      (HW_DIGCTL_CTRL.U)
#define HW_DIGCTL_CTRL_WR(v)     (HW_DIGCTL_CTRL.U = (v))
#define HW_DIGCTL_CTRL_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_CTRL_SET_ADDR) = (v))
#define HW_DIGCTL_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_CTRL_CLR_ADDR) = (v))
#define HW_DIGCTL_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_CTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DIGCTL_CTRL bitfields
 */
/* --- Register HW_DIGCTL_CTRL, field RSVD3 */

#define BP_DIGCTL_CTRL_RSVD3      31
#define BM_DIGCTL_CTRL_RSVD3      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_CTRL_RSVD3(v)   ((((reg32_t) v) << 31) & BM_DIGCTL_CTRL_RSVD3)
#else
#define BF_DIGCTL_CTRL_RSVD3(v)   (((v) << 31) & BM_DIGCTL_CTRL_RSVD3)
#endif
/* --- Register HW_DIGCTL_CTRL, field XTAL24M_GATE */

#define BP_DIGCTL_CTRL_XTAL24M_GATE      30
#define BM_DIGCTL_CTRL_XTAL24M_GATE      0x40000000

#define BF_DIGCTL_CTRL_XTAL24M_GATE(v)   (((v) << 30) & BM_DIGCTL_CTRL_XTAL24M_GATE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_XTAL24M_GATE(v)   BF_CS1(DIGCTL_CTRL, XTAL24M_GATE, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field RSVD2 */

#define BP_DIGCTL_CTRL_RSVD2      25
#define BM_DIGCTL_CTRL_RSVD2      0x3E000000

#define BF_DIGCTL_CTRL_RSVD2(v)   (((v) << 25) & BM_DIGCTL_CTRL_RSVD2)
/* --- Register HW_DIGCTL_CTRL, field USB1_OVERCURRENT_ENABLE */

#define BP_DIGCTL_CTRL_USB1_OVERCURRENT_ENABLE      24
#define BM_DIGCTL_CTRL_USB1_OVERCURRENT_ENABLE      0x01000000

#define BF_DIGCTL_CTRL_USB1_OVERCURRENT_ENABLE(v)   (((v) << 24) & BM_DIGCTL_CTRL_USB1_OVERCURRENT_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB1_OVERCURRENT_ENABLE(v)   BF_CS1(DIGCTL_CTRL, USB1_OVERCURRENT_ENABLE, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field USB0_OVERCURRENT_ENABLE */

#define BP_DIGCTL_CTRL_USB0_OVERCURRENT_ENABLE      23
#define BM_DIGCTL_CTRL_USB0_OVERCURRENT_ENABLE      0x00800000

#define BF_DIGCTL_CTRL_USB0_OVERCURRENT_ENABLE(v)   (((v) << 23) & BM_DIGCTL_CTRL_USB0_OVERCURRENT_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB0_OVERCURRENT_ENABLE(v)   BF_CS1(DIGCTL_CTRL, USB0_OVERCURRENT_ENABLE, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field USB1_OVERCURRENT_POL */

#define BP_DIGCTL_CTRL_USB1_OVERCURRENT_POL      22
#define BM_DIGCTL_CTRL_USB1_OVERCURRENT_POL      0x00400000

#define BF_DIGCTL_CTRL_USB1_OVERCURRENT_POL(v)   (((v) << 22) & BM_DIGCTL_CTRL_USB1_OVERCURRENT_POL)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB1_OVERCURRENT_POL(v)   BF_CS1(DIGCTL_CTRL, USB1_OVERCURRENT_POL, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field USB0_OVERCURRENT_POL */

#define BP_DIGCTL_CTRL_USB0_OVERCURRENT_POL      21
#define BM_DIGCTL_CTRL_USB0_OVERCURRENT_POL      0x00200000

#define BF_DIGCTL_CTRL_USB0_OVERCURRENT_POL(v)   (((v) << 21) & BM_DIGCTL_CTRL_USB0_OVERCURRENT_POL)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB0_OVERCURRENT_POL(v)   BF_CS1(DIGCTL_CTRL, USB0_OVERCURRENT_POL, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field USB1_TESTMODE */

#define BP_DIGCTL_CTRL_USB1_TESTMODE      20
#define BM_DIGCTL_CTRL_USB1_TESTMODE      0x00100000

#define BF_DIGCTL_CTRL_USB1_TESTMODE(v)   (((v) << 20) & BM_DIGCTL_CTRL_USB1_TESTMODE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB1_TESTMODE(v)   BF_CS1(DIGCTL_CTRL, USB1_TESTMODE, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field USB0_TESTMODE */

#define BP_DIGCTL_CTRL_USB0_TESTMODE      19
#define BM_DIGCTL_CTRL_USB0_TESTMODE      0x00080000

#define BF_DIGCTL_CTRL_USB0_TESTMODE(v)   (((v) << 19) & BM_DIGCTL_CTRL_USB0_TESTMODE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB0_TESTMODE(v)   BF_CS1(DIGCTL_CTRL, USB0_TESTMODE, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field ANALOG_TESTMODE */

#define BP_DIGCTL_CTRL_ANALOG_TESTMODE      18
#define BM_DIGCTL_CTRL_ANALOG_TESTMODE      0x00040000

#define BF_DIGCTL_CTRL_ANALOG_TESTMODE(v)   (((v) << 18) & BM_DIGCTL_CTRL_ANALOG_TESTMODE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_ANALOG_TESTMODE(v)   BF_CS1(DIGCTL_CTRL, ANALOG_TESTMODE, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field DIGITAL_TESTMODE */

#define BP_DIGCTL_CTRL_DIGITAL_TESTMODE      17
#define BM_DIGCTL_CTRL_DIGITAL_TESTMODE      0x00020000

#define BF_DIGCTL_CTRL_DIGITAL_TESTMODE(v)   (((v) << 17) & BM_DIGCTL_CTRL_DIGITAL_TESTMODE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_DIGITAL_TESTMODE(v)   BF_CS1(DIGCTL_CTRL, DIGITAL_TESTMODE, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field USB1_CLKGATE */

#define BP_DIGCTL_CTRL_USB1_CLKGATE      16
#define BM_DIGCTL_CTRL_USB1_CLKGATE      0x00010000

#define BF_DIGCTL_CTRL_USB1_CLKGATE(v)   (((v) << 16) & BM_DIGCTL_CTRL_USB1_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB1_CLKGATE(v)   BF_CS1(DIGCTL_CTRL, USB1_CLKGATE, v)
#endif

#define BV_DIGCTL_CTRL_USB1_CLKGATE__RUN      0x0
#define BV_DIGCTL_CTRL_USB1_CLKGATE__NO_CLKS  0x1

/* --- Register HW_DIGCTL_CTRL, field SAIF_LOOPBACK */

#define BP_DIGCTL_CTRL_SAIF_LOOPBACK      15
#define BM_DIGCTL_CTRL_SAIF_LOOPBACK      0x00008000

#define BF_DIGCTL_CTRL_SAIF_LOOPBACK(v)   (((v) << 15) & BM_DIGCTL_CTRL_SAIF_LOOPBACK)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_SAIF_LOOPBACK(v)   BF_CS1(DIGCTL_CTRL, SAIF_LOOPBACK, v)
#endif

#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__NORMAL  0x0
#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__LOOPIT  0x1

/* --- Register HW_DIGCTL_CTRL, field DUART_LOOPBACK */

#define BP_DIGCTL_CTRL_DUART_LOOPBACK      14
#define BM_DIGCTL_CTRL_DUART_LOOPBACK      0x00004000

#define BF_DIGCTL_CTRL_DUART_LOOPBACK(v)   (((v) << 14) & BM_DIGCTL_CTRL_DUART_LOOPBACK)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_DUART_LOOPBACK(v)   BF_CS1(DIGCTL_CTRL, DUART_LOOPBACK, v)
#endif

#define BV_DIGCTL_CTRL_DUART_LOOPBACK__NORMAL  0x0
#define BV_DIGCTL_CTRL_DUART_LOOPBACK__LOOPIT  0x1

/* --- Register HW_DIGCTL_CTRL, field AUART01_LOOPBACK */

#define BP_DIGCTL_CTRL_AUART01_LOOPBACK      13
#define BM_DIGCTL_CTRL_AUART01_LOOPBACK      0x00002000

#define BF_DIGCTL_CTRL_AUART01_LOOPBACK(v)   (((v) << 13) & BM_DIGCTL_CTRL_AUART01_LOOPBACK)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_AUART01_LOOPBACK(v)   BF_CS1(DIGCTL_CTRL, AUART01_LOOPBACK, v)
#endif

#define BV_DIGCTL_CTRL_AUART01_LOOPBACK__NORMAL  0x0
#define BV_DIGCTL_CTRL_AUART01_LOOPBACK__LOOPIT  0x1

/* --- Register HW_DIGCTL_CTRL, field RSVD1 */

#define BP_DIGCTL_CTRL_RSVD1      12
#define BM_DIGCTL_CTRL_RSVD1      0x00001000

#define BF_DIGCTL_CTRL_RSVD1(v)   (((v) << 12) & BM_DIGCTL_CTRL_RSVD1)
/* --- Register HW_DIGCTL_CTRL, field SAIF_CLKMUX_SEL */

#define BP_DIGCTL_CTRL_SAIF_CLKMUX_SEL      10
#define BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL      0x00000C00

#define BF_DIGCTL_CTRL_SAIF_CLKMUX_SEL(v)   (((v) << 10) & BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_SAIF_CLKMUX_SEL(v)   BF_CS1(DIGCTL_CTRL, SAIF_CLKMUX_SEL, v)
#endif

#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__DIRECT          0x0
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__CROSSINPUT      0x1
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__CLKSRCSAIF0PIN  0x2
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__CLKSRCSAIF1PIN  0x3

/* --- Register HW_DIGCTL_CTRL, field RSVD0 */

#define BP_DIGCTL_CTRL_RSVD0      4
#define BM_DIGCTL_CTRL_RSVD0      0x000003F0

#define BF_DIGCTL_CTRL_RSVD0(v)   (((v) << 4) & BM_DIGCTL_CTRL_RSVD0)
/* --- Register HW_DIGCTL_CTRL, field DEBUG_DISABLE */

#define BP_DIGCTL_CTRL_DEBUG_DISABLE      3
#define BM_DIGCTL_CTRL_DEBUG_DISABLE      0x00000008

#define BF_DIGCTL_CTRL_DEBUG_DISABLE(v)   (((v) << 3) & BM_DIGCTL_CTRL_DEBUG_DISABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_DEBUG_DISABLE(v)   BF_CS1(DIGCTL_CTRL, DEBUG_DISABLE, v)
#endif

/* --- Register HW_DIGCTL_CTRL, field USB0_CLKGATE */

#define BP_DIGCTL_CTRL_USB0_CLKGATE      2
#define BM_DIGCTL_CTRL_USB0_CLKGATE      0x00000004

#define BF_DIGCTL_CTRL_USB0_CLKGATE(v)   (((v) << 2) & BM_DIGCTL_CTRL_USB0_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_USB0_CLKGATE(v)   BF_CS1(DIGCTL_CTRL, USB0_CLKGATE, v)
#endif

#define BV_DIGCTL_CTRL_USB0_CLKGATE__RUN      0x0
#define BV_DIGCTL_CTRL_USB0_CLKGATE__NO_CLKS  0x1

/* --- Register HW_DIGCTL_CTRL, field JTAG_SHIELD */

#define BP_DIGCTL_CTRL_JTAG_SHIELD      1
#define BM_DIGCTL_CTRL_JTAG_SHIELD      0x00000002

#define BF_DIGCTL_CTRL_JTAG_SHIELD(v)   (((v) << 1) & BM_DIGCTL_CTRL_JTAG_SHIELD)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_JTAG_SHIELD(v)   BF_CS1(DIGCTL_CTRL, JTAG_SHIELD, v)
#endif

#define BV_DIGCTL_CTRL_JTAG_SHIELD__NORMAL      0x0
#define BV_DIGCTL_CTRL_JTAG_SHIELD__SHIELDS_UP  0x1

/* --- Register HW_DIGCTL_CTRL, field LATCH_ENTROPY */

#define BP_DIGCTL_CTRL_LATCH_ENTROPY      0
#define BM_DIGCTL_CTRL_LATCH_ENTROPY      0x00000001

#define BF_DIGCTL_CTRL_LATCH_ENTROPY(v)   (((v) << 0) & BM_DIGCTL_CTRL_LATCH_ENTROPY)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_CTRL_LATCH_ENTROPY(v)   BF_CS1(DIGCTL_CTRL, LATCH_ENTROPY, v)
#endif



/*
 * HW_DIGCTL_STATUS - DIGCTL Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WRITTEN              :  1;
        unsigned PACKAGE_TYPE         :  3;
        unsigned JTAG_IN_USE          :  1;
        unsigned RSVD0                : 19;
        unsigned USB1_DEVICE_PRESENT  :  1;
        unsigned USB1_HOST_PRESENT    :  1;
        unsigned USB1_OTG_PRESENT     :  1;
        unsigned USB1_HS_PRESENT      :  1;
        unsigned USB0_DEVICE_PRESENT  :  1;
        unsigned USB0_HOST_PRESENT    :  1;
        unsigned USB0_OTG_PRESENT     :  1;
        unsigned USB0_HS_PRESENT      :  1;
    } B;
} hw_digctl_status_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_STATUS register
 */
#define HW_DIGCTL_STATUS_ADDR         (REGS_DIGCTL_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_STATUS           (*(volatile hw_digctl_status_t *) HW_DIGCTL_STATUS_ADDR)
#define HW_DIGCTL_STATUS_RD()      (HW_DIGCTL_STATUS.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_STATUS bitfields
 */
/* --- Register HW_DIGCTL_STATUS, field USB0_HS_PRESENT */

#define BP_DIGCTL_STATUS_USB0_HS_PRESENT      31
#define BM_DIGCTL_STATUS_USB0_HS_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_STATUS_USB0_HS_PRESENT(v)   ((((reg32_t) v) << 31) & BM_DIGCTL_STATUS_USB0_HS_PRESENT)
#else
#define BF_DIGCTL_STATUS_USB0_HS_PRESENT(v)   (((v) << 31) & BM_DIGCTL_STATUS_USB0_HS_PRESENT)
#endif
/* --- Register HW_DIGCTL_STATUS, field USB0_OTG_PRESENT */

#define BP_DIGCTL_STATUS_USB0_OTG_PRESENT      30
#define BM_DIGCTL_STATUS_USB0_OTG_PRESENT      0x40000000

#define BF_DIGCTL_STATUS_USB0_OTG_PRESENT(v)   (((v) << 30) & BM_DIGCTL_STATUS_USB0_OTG_PRESENT)
/* --- Register HW_DIGCTL_STATUS, field USB0_HOST_PRESENT */

#define BP_DIGCTL_STATUS_USB0_HOST_PRESENT      29
#define BM_DIGCTL_STATUS_USB0_HOST_PRESENT      0x20000000

#define BF_DIGCTL_STATUS_USB0_HOST_PRESENT(v)   (((v) << 29) & BM_DIGCTL_STATUS_USB0_HOST_PRESENT)
/* --- Register HW_DIGCTL_STATUS, field USB0_DEVICE_PRESENT */

#define BP_DIGCTL_STATUS_USB0_DEVICE_PRESENT      28
#define BM_DIGCTL_STATUS_USB0_DEVICE_PRESENT      0x10000000

#define BF_DIGCTL_STATUS_USB0_DEVICE_PRESENT(v)   (((v) << 28) & BM_DIGCTL_STATUS_USB0_DEVICE_PRESENT)
/* --- Register HW_DIGCTL_STATUS, field USB1_HS_PRESENT */

#define BP_DIGCTL_STATUS_USB1_HS_PRESENT      27
#define BM_DIGCTL_STATUS_USB1_HS_PRESENT      0x08000000

#define BF_DIGCTL_STATUS_USB1_HS_PRESENT(v)   (((v) << 27) & BM_DIGCTL_STATUS_USB1_HS_PRESENT)
/* --- Register HW_DIGCTL_STATUS, field USB1_OTG_PRESENT */

#define BP_DIGCTL_STATUS_USB1_OTG_PRESENT      26
#define BM_DIGCTL_STATUS_USB1_OTG_PRESENT      0x04000000

#define BF_DIGCTL_STATUS_USB1_OTG_PRESENT(v)   (((v) << 26) & BM_DIGCTL_STATUS_USB1_OTG_PRESENT)
/* --- Register HW_DIGCTL_STATUS, field USB1_HOST_PRESENT */

#define BP_DIGCTL_STATUS_USB1_HOST_PRESENT      25
#define BM_DIGCTL_STATUS_USB1_HOST_PRESENT      0x02000000

#define BF_DIGCTL_STATUS_USB1_HOST_PRESENT(v)   (((v) << 25) & BM_DIGCTL_STATUS_USB1_HOST_PRESENT)
/* --- Register HW_DIGCTL_STATUS, field USB1_DEVICE_PRESENT */

#define BP_DIGCTL_STATUS_USB1_DEVICE_PRESENT      24
#define BM_DIGCTL_STATUS_USB1_DEVICE_PRESENT      0x01000000

#define BF_DIGCTL_STATUS_USB1_DEVICE_PRESENT(v)   (((v) << 24) & BM_DIGCTL_STATUS_USB1_DEVICE_PRESENT)
/* --- Register HW_DIGCTL_STATUS, field RSVD0 */

#define BP_DIGCTL_STATUS_RSVD0      5
#define BM_DIGCTL_STATUS_RSVD0      0x00FFFFE0

#define BF_DIGCTL_STATUS_RSVD0(v)   (((v) << 5) & BM_DIGCTL_STATUS_RSVD0)
/* --- Register HW_DIGCTL_STATUS, field JTAG_IN_USE */

#define BP_DIGCTL_STATUS_JTAG_IN_USE      4
#define BM_DIGCTL_STATUS_JTAG_IN_USE      0x00000010

#define BF_DIGCTL_STATUS_JTAG_IN_USE(v)   (((v) << 4) & BM_DIGCTL_STATUS_JTAG_IN_USE)
/* --- Register HW_DIGCTL_STATUS, field PACKAGE_TYPE */

#define BP_DIGCTL_STATUS_PACKAGE_TYPE      1
#define BM_DIGCTL_STATUS_PACKAGE_TYPE      0x0000000E

#define BF_DIGCTL_STATUS_PACKAGE_TYPE(v)   (((v) << 1) & BM_DIGCTL_STATUS_PACKAGE_TYPE)
/* --- Register HW_DIGCTL_STATUS, field WRITTEN */

#define BP_DIGCTL_STATUS_WRITTEN      0
#define BM_DIGCTL_STATUS_WRITTEN      0x00000001

#define BF_DIGCTL_STATUS_WRITTEN(v)   (((v) << 0) & BM_DIGCTL_STATUS_WRITTEN)


/*
 * HW_DIGCTL_HCLKCOUNT - Free-Running HCLK Counter Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_hclkcount_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_HCLKCOUNT register
 */
#define HW_DIGCTL_HCLKCOUNT_ADDR         (REGS_DIGCTL_BASE + 0x20)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_HCLKCOUNT           (*(volatile hw_digctl_hclkcount_t *) HW_DIGCTL_HCLKCOUNT_ADDR)
#define HW_DIGCTL_HCLKCOUNT_RD()      (HW_DIGCTL_HCLKCOUNT.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_HCLKCOUNT bitfields
 */
/* --- Register HW_DIGCTL_HCLKCOUNT, field COUNT */

#define BP_DIGCTL_HCLKCOUNT_COUNT      0
#define BM_DIGCTL_HCLKCOUNT_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_HCLKCOUNT_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_HCLKCOUNT_COUNT(v)   (v)
#endif


/*
 * HW_DIGCTL_RAMCTRL - On-Chip RAM Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0         :  8;
        unsigned DEBUG_CODE    :  5;
        unsigned DEBUG_ENABLE  :  1;
        unsigned TBYPASS       :  1;
        unsigned RSVD1         : 17;
    } B;
} hw_digctl_ramctrl_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_RAMCTRL register
 */
#define HW_DIGCTL_RAMCTRL_ADDR         (REGS_DIGCTL_BASE + 0x30)
#define HW_DIGCTL_RAMCTRL_SET_ADDR     (HW_DIGCTL_RAMCTRL_ADDR + 4)
#define HW_DIGCTL_RAMCTRL_CLR_ADDR     (HW_DIGCTL_RAMCTRL_ADDR + 8)
#define HW_DIGCTL_RAMCTRL_TOG_ADDR     (HW_DIGCTL_RAMCTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_RAMCTRL           (*(volatile hw_digctl_ramctrl_t *) HW_DIGCTL_RAMCTRL_ADDR)
#define HW_DIGCTL_RAMCTRL_RD()      (HW_DIGCTL_RAMCTRL.U)
#define HW_DIGCTL_RAMCTRL_WR(v)     (HW_DIGCTL_RAMCTRL.U = (v))
#define HW_DIGCTL_RAMCTRL_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_RAMCTRL_SET_ADDR) = (v))
#define HW_DIGCTL_RAMCTRL_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_RAMCTRL_CLR_ADDR) = (v))
#define HW_DIGCTL_RAMCTRL_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_RAMCTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DIGCTL_RAMCTRL bitfields
 */
/* --- Register HW_DIGCTL_RAMCTRL, field RSVD1 */

#define BP_DIGCTL_RAMCTRL_RSVD1      15
#define BM_DIGCTL_RAMCTRL_RSVD1      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_RAMCTRL_RSVD1(v)   ((((reg32_t) v) << 15) & BM_DIGCTL_RAMCTRL_RSVD1)
#else
#define BF_DIGCTL_RAMCTRL_RSVD1(v)   (((v) << 15) & BM_DIGCTL_RAMCTRL_RSVD1)
#endif
/* --- Register HW_DIGCTL_RAMCTRL, field TBYPASS */

#define BP_DIGCTL_RAMCTRL_TBYPASS      14
#define BM_DIGCTL_RAMCTRL_TBYPASS      0x00004000

#define BF_DIGCTL_RAMCTRL_TBYPASS(v)   (((v) << 14) & BM_DIGCTL_RAMCTRL_TBYPASS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_RAMCTRL_TBYPASS(v)   BF_CS1(DIGCTL_RAMCTRL, TBYPASS, v)
#endif

/* --- Register HW_DIGCTL_RAMCTRL, field DEBUG_ENABLE */

#define BP_DIGCTL_RAMCTRL_DEBUG_ENABLE      13
#define BM_DIGCTL_RAMCTRL_DEBUG_ENABLE      0x00002000

#define BF_DIGCTL_RAMCTRL_DEBUG_ENABLE(v)   (((v) << 13) & BM_DIGCTL_RAMCTRL_DEBUG_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_RAMCTRL_DEBUG_ENABLE(v)   BF_CS1(DIGCTL_RAMCTRL, DEBUG_ENABLE, v)
#endif

/* --- Register HW_DIGCTL_RAMCTRL, field DEBUG_CODE */

#define BP_DIGCTL_RAMCTRL_DEBUG_CODE      8
#define BM_DIGCTL_RAMCTRL_DEBUG_CODE      0x00001F00

#define BF_DIGCTL_RAMCTRL_DEBUG_CODE(v)   (((v) << 8) & BM_DIGCTL_RAMCTRL_DEBUG_CODE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_RAMCTRL_DEBUG_CODE(v)   BF_CS1(DIGCTL_RAMCTRL, DEBUG_CODE, v)
#endif

#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__NORMAL  0x0
#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__DELAY1  0x4
#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__DELAY2  0x5
#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__DELAY3  0x6
#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__DELAY4  0x7

/* --- Register HW_DIGCTL_RAMCTRL, field RSVD0 */

#define BP_DIGCTL_RAMCTRL_RSVD0      0
#define BM_DIGCTL_RAMCTRL_RSVD0      0x000000FF

#define BF_DIGCTL_RAMCTRL_RSVD0(v)   (((v) << 0) & BM_DIGCTL_RAMCTRL_RSVD0)


/*
 * HW_DIGCTL_EMI_STATUS - EMI Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned POWER_MODE  :  5;
        unsigned RSVD0       : 27;
    } B;
} hw_digctl_emi_status_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_EMI_STATUS register
 */
#define HW_DIGCTL_EMI_STATUS_ADDR         (REGS_DIGCTL_BASE + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_EMI_STATUS           (*(volatile hw_digctl_emi_status_t *) HW_DIGCTL_EMI_STATUS_ADDR)
#define HW_DIGCTL_EMI_STATUS_RD()      (HW_DIGCTL_EMI_STATUS.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_EMI_STATUS bitfields
 */
/* --- Register HW_DIGCTL_EMI_STATUS, field RSVD0 */

#define BP_DIGCTL_EMI_STATUS_RSVD0      5
#define BM_DIGCTL_EMI_STATUS_RSVD0      0xFFFFFFE0

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_EMI_STATUS_RSVD0(v)   ((((reg32_t) v) << 5) & BM_DIGCTL_EMI_STATUS_RSVD0)
#else
#define BF_DIGCTL_EMI_STATUS_RSVD0(v)   (((v) << 5) & BM_DIGCTL_EMI_STATUS_RSVD0)
#endif
/* --- Register HW_DIGCTL_EMI_STATUS, field POWER_MODE */

#define BP_DIGCTL_EMI_STATUS_POWER_MODE      0
#define BM_DIGCTL_EMI_STATUS_POWER_MODE      0x0000001F

#define BF_DIGCTL_EMI_STATUS_POWER_MODE(v)   (((v) << 0) & BM_DIGCTL_EMI_STATUS_POWER_MODE)
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM5     0x1
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM4     0x2
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM3     0x4
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM2     0x8
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM1     0x10
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__NORMAL  0x0



/*
 * HW_DIGCTL_READ_MARGIN - On-Chip Memories Read Margin Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ROM    :  4;
        unsigned RSVD0  : 28;
    } B;
} hw_digctl_read_margin_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_READ_MARGIN register
 */
#define HW_DIGCTL_READ_MARGIN_ADDR         (REGS_DIGCTL_BASE + 0x50)
#define HW_DIGCTL_READ_MARGIN_SET_ADDR     (HW_DIGCTL_READ_MARGIN_ADDR + 4)
#define HW_DIGCTL_READ_MARGIN_CLR_ADDR     (HW_DIGCTL_READ_MARGIN_ADDR + 8)
#define HW_DIGCTL_READ_MARGIN_TOG_ADDR     (HW_DIGCTL_READ_MARGIN_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_READ_MARGIN           (*(volatile hw_digctl_read_margin_t *) HW_DIGCTL_READ_MARGIN_ADDR)
#define HW_DIGCTL_READ_MARGIN_RD()      (HW_DIGCTL_READ_MARGIN.U)
#define HW_DIGCTL_READ_MARGIN_WR(v)     (HW_DIGCTL_READ_MARGIN.U = (v))
#define HW_DIGCTL_READ_MARGIN_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_READ_MARGIN_SET_ADDR) = (v))
#define HW_DIGCTL_READ_MARGIN_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_READ_MARGIN_CLR_ADDR) = (v))
#define HW_DIGCTL_READ_MARGIN_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_READ_MARGIN_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DIGCTL_READ_MARGIN bitfields
 */
/* --- Register HW_DIGCTL_READ_MARGIN, field RSVD0 */

#define BP_DIGCTL_READ_MARGIN_RSVD0      4
#define BM_DIGCTL_READ_MARGIN_RSVD0      0xFFFFFFF0

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_READ_MARGIN_RSVD0(v)   ((((reg32_t) v) << 4) & BM_DIGCTL_READ_MARGIN_RSVD0)
#else
#define BF_DIGCTL_READ_MARGIN_RSVD0(v)   (((v) << 4) & BM_DIGCTL_READ_MARGIN_RSVD0)
#endif
/* --- Register HW_DIGCTL_READ_MARGIN, field ROM */

#define BP_DIGCTL_READ_MARGIN_ROM      0
#define BM_DIGCTL_READ_MARGIN_ROM      0x0000000F

#define BF_DIGCTL_READ_MARGIN_ROM(v)   (((v) << 0) & BM_DIGCTL_READ_MARGIN_ROM)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_READ_MARGIN_ROM(v)   BF_CS1(DIGCTL_READ_MARGIN, ROM, v)
#endif



/*
 * HW_DIGCTL_WRITEONCE - Software Write-Once Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BITS  : 32;
    } B;
} hw_digctl_writeonce_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_WRITEONCE register
 */
#define HW_DIGCTL_WRITEONCE_ADDR         (REGS_DIGCTL_BASE + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_WRITEONCE           (*(volatile hw_digctl_writeonce_t *) HW_DIGCTL_WRITEONCE_ADDR)
#define HW_DIGCTL_WRITEONCE_RD()      (HW_DIGCTL_WRITEONCE.U)
#define HW_DIGCTL_WRITEONCE_WR(v)     (HW_DIGCTL_WRITEONCE.U = (v))
#define HW_DIGCTL_WRITEONCE_SET(v)    (HW_DIGCTL_WRITEONCE_WR(HW_DIGCTL_WRITEONCE_RD() |  (v)))
#define HW_DIGCTL_WRITEONCE_CLR(v)    (HW_DIGCTL_WRITEONCE_WR(HW_DIGCTL_WRITEONCE_RD() & ~(v)))
#define HW_DIGCTL_WRITEONCE_TOG(v)    (HW_DIGCTL_WRITEONCE_WR(HW_DIGCTL_WRITEONCE_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_WRITEONCE bitfields
 */
/* --- Register HW_DIGCTL_WRITEONCE, field BITS */

#define BP_DIGCTL_WRITEONCE_BITS      0
#define BM_DIGCTL_WRITEONCE_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_WRITEONCE_BITS(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_WRITEONCE_BITS(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_WRITEONCE_BITS(v)   (HW_DIGCTL_WRITEONCE.B.BITS = (v))
#endif



/*
 * HW_DIGCTL_BIST_CTL - BIST Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CAN_BIST_START        :  1;
        unsigned CACHE_BIST_START      :  1;
        unsigned DMA0_BIST_START       :  1;
        unsigned DMA1_BIST_START       :  1;
        unsigned USB0_BIST_START       :  1;
        unsigned USB1_BIST_START       :  1;
        unsigned ENET_BIST_START       :  1;
        unsigned DCP_BIST_START        :  1;
        unsigned LCDIF_BIST_START      :  1;
        unsigned PXP_BIST_START        :  1;
        unsigned OCRAM_BIST_START      :  1;
        unsigned OCRAM_BIST_DONE       :  1;
        unsigned OCRAM_BIST_FAIL       :  1;
        unsigned OCRAM_BIST_PASS       :  1;
        unsigned OCRAM_BIST_RETENTION  :  1;
        unsigned RSVD0                 : 12;
        unsigned BIST_RESUME           :  1;
        unsigned BIST_CHECKB           :  1;
        unsigned BIST_DEBUGZ           :  1;
        unsigned BIST_RESETN           :  1;
        unsigned BIST_TESTMODE         :  1;
    } B;
} hw_digctl_bist_ctl_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_BIST_CTL register
 */
#define HW_DIGCTL_BIST_CTL_ADDR         (REGS_DIGCTL_BASE + 0x70)
#define HW_DIGCTL_BIST_CTL_SET_ADDR     (HW_DIGCTL_BIST_CTL_ADDR + 4)
#define HW_DIGCTL_BIST_CTL_CLR_ADDR     (HW_DIGCTL_BIST_CTL_ADDR + 8)
#define HW_DIGCTL_BIST_CTL_TOG_ADDR     (HW_DIGCTL_BIST_CTL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_BIST_CTL           (*(volatile hw_digctl_bist_ctl_t *) HW_DIGCTL_BIST_CTL_ADDR)
#define HW_DIGCTL_BIST_CTL_RD()      (HW_DIGCTL_BIST_CTL.U)
#define HW_DIGCTL_BIST_CTL_WR(v)     (HW_DIGCTL_BIST_CTL.U = (v))
#define HW_DIGCTL_BIST_CTL_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_BIST_CTL_SET_ADDR) = (v))
#define HW_DIGCTL_BIST_CTL_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_BIST_CTL_CLR_ADDR) = (v))
#define HW_DIGCTL_BIST_CTL_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_BIST_CTL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DIGCTL_BIST_CTL bitfields
 */
/* --- Register HW_DIGCTL_BIST_CTL, field BIST_TESTMODE */

#define BP_DIGCTL_BIST_CTL_BIST_TESTMODE      31
#define BM_DIGCTL_BIST_CTL_BIST_TESTMODE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_BIST_CTL_BIST_TESTMODE(v)   ((((reg32_t) v) << 31) & BM_DIGCTL_BIST_CTL_BIST_TESTMODE)
#else
#define BF_DIGCTL_BIST_CTL_BIST_TESTMODE(v)   (((v) << 31) & BM_DIGCTL_BIST_CTL_BIST_TESTMODE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_BIST_TESTMODE(v)   BF_CS1(DIGCTL_BIST_CTL, BIST_TESTMODE, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field BIST_RESETN */

#define BP_DIGCTL_BIST_CTL_BIST_RESETN      30
#define BM_DIGCTL_BIST_CTL_BIST_RESETN      0x40000000

#define BF_DIGCTL_BIST_CTL_BIST_RESETN(v)   (((v) << 30) & BM_DIGCTL_BIST_CTL_BIST_RESETN)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_BIST_RESETN(v)   BF_CS1(DIGCTL_BIST_CTL, BIST_RESETN, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field BIST_DEBUGZ */

#define BP_DIGCTL_BIST_CTL_BIST_DEBUGZ      29
#define BM_DIGCTL_BIST_CTL_BIST_DEBUGZ      0x20000000

#define BF_DIGCTL_BIST_CTL_BIST_DEBUGZ(v)   (((v) << 29) & BM_DIGCTL_BIST_CTL_BIST_DEBUGZ)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_BIST_DEBUGZ(v)   BF_CS1(DIGCTL_BIST_CTL, BIST_DEBUGZ, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field BIST_CHECKB */

#define BP_DIGCTL_BIST_CTL_BIST_CHECKB      28
#define BM_DIGCTL_BIST_CTL_BIST_CHECKB      0x10000000

#define BF_DIGCTL_BIST_CTL_BIST_CHECKB(v)   (((v) << 28) & BM_DIGCTL_BIST_CTL_BIST_CHECKB)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_BIST_CHECKB(v)   BF_CS1(DIGCTL_BIST_CTL, BIST_CHECKB, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field BIST_RESUME */

#define BP_DIGCTL_BIST_CTL_BIST_RESUME      27
#define BM_DIGCTL_BIST_CTL_BIST_RESUME      0x08000000

#define BF_DIGCTL_BIST_CTL_BIST_RESUME(v)   (((v) << 27) & BM_DIGCTL_BIST_CTL_BIST_RESUME)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_BIST_RESUME(v)   BF_CS1(DIGCTL_BIST_CTL, BIST_RESUME, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field RSVD0 */

#define BP_DIGCTL_BIST_CTL_RSVD0      15
#define BM_DIGCTL_BIST_CTL_RSVD0      0x07FF8000

#define BF_DIGCTL_BIST_CTL_RSVD0(v)   (((v) << 15) & BM_DIGCTL_BIST_CTL_RSVD0)
/* --- Register HW_DIGCTL_BIST_CTL, field OCRAM_BIST_RETENTION */

#define BP_DIGCTL_BIST_CTL_OCRAM_BIST_RETENTION      14
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_RETENTION      0x00004000

#define BF_DIGCTL_BIST_CTL_OCRAM_BIST_RETENTION(v)   (((v) << 14) & BM_DIGCTL_BIST_CTL_OCRAM_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_CTL, field OCRAM_BIST_PASS */

#define BP_DIGCTL_BIST_CTL_OCRAM_BIST_PASS      13
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_PASS      0x00002000

#define BF_DIGCTL_BIST_CTL_OCRAM_BIST_PASS(v)   (((v) << 13) & BM_DIGCTL_BIST_CTL_OCRAM_BIST_PASS)
/* --- Register HW_DIGCTL_BIST_CTL, field OCRAM_BIST_FAIL */

#define BP_DIGCTL_BIST_CTL_OCRAM_BIST_FAIL      12
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_FAIL      0x00001000

#define BF_DIGCTL_BIST_CTL_OCRAM_BIST_FAIL(v)   (((v) << 12) & BM_DIGCTL_BIST_CTL_OCRAM_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_CTL, field OCRAM_BIST_DONE */

#define BP_DIGCTL_BIST_CTL_OCRAM_BIST_DONE      11
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_DONE      0x00000800

#define BF_DIGCTL_BIST_CTL_OCRAM_BIST_DONE(v)   (((v) << 11) & BM_DIGCTL_BIST_CTL_OCRAM_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_CTL, field OCRAM_BIST_START */

#define BP_DIGCTL_BIST_CTL_OCRAM_BIST_START      10
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_START      0x00000400

#define BF_DIGCTL_BIST_CTL_OCRAM_BIST_START(v)   (((v) << 10) & BM_DIGCTL_BIST_CTL_OCRAM_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_OCRAM_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, OCRAM_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field PXP_BIST_START */

#define BP_DIGCTL_BIST_CTL_PXP_BIST_START      9
#define BM_DIGCTL_BIST_CTL_PXP_BIST_START      0x00000200

#define BF_DIGCTL_BIST_CTL_PXP_BIST_START(v)   (((v) << 9) & BM_DIGCTL_BIST_CTL_PXP_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_PXP_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, PXP_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field LCDIF_BIST_START */

#define BP_DIGCTL_BIST_CTL_LCDIF_BIST_START      8
#define BM_DIGCTL_BIST_CTL_LCDIF_BIST_START      0x00000100

#define BF_DIGCTL_BIST_CTL_LCDIF_BIST_START(v)   (((v) << 8) & BM_DIGCTL_BIST_CTL_LCDIF_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_LCDIF_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, LCDIF_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field DCP_BIST_START */

#define BP_DIGCTL_BIST_CTL_DCP_BIST_START      7
#define BM_DIGCTL_BIST_CTL_DCP_BIST_START      0x00000080

#define BF_DIGCTL_BIST_CTL_DCP_BIST_START(v)   (((v) << 7) & BM_DIGCTL_BIST_CTL_DCP_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_DCP_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, DCP_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field ENET_BIST_START */

#define BP_DIGCTL_BIST_CTL_ENET_BIST_START      6
#define BM_DIGCTL_BIST_CTL_ENET_BIST_START      0x00000040

#define BF_DIGCTL_BIST_CTL_ENET_BIST_START(v)   (((v) << 6) & BM_DIGCTL_BIST_CTL_ENET_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_ENET_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, ENET_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field USB1_BIST_START */

#define BP_DIGCTL_BIST_CTL_USB1_BIST_START      5
#define BM_DIGCTL_BIST_CTL_USB1_BIST_START      0x00000020

#define BF_DIGCTL_BIST_CTL_USB1_BIST_START(v)   (((v) << 5) & BM_DIGCTL_BIST_CTL_USB1_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_USB1_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, USB1_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field USB0_BIST_START */

#define BP_DIGCTL_BIST_CTL_USB0_BIST_START      4
#define BM_DIGCTL_BIST_CTL_USB0_BIST_START      0x00000010

#define BF_DIGCTL_BIST_CTL_USB0_BIST_START(v)   (((v) << 4) & BM_DIGCTL_BIST_CTL_USB0_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_USB0_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, USB0_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field DMA1_BIST_START */

#define BP_DIGCTL_BIST_CTL_DMA1_BIST_START      3
#define BM_DIGCTL_BIST_CTL_DMA1_BIST_START      0x00000008

#define BF_DIGCTL_BIST_CTL_DMA1_BIST_START(v)   (((v) << 3) & BM_DIGCTL_BIST_CTL_DMA1_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_DMA1_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, DMA1_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field DMA0_BIST_START */

#define BP_DIGCTL_BIST_CTL_DMA0_BIST_START      2
#define BM_DIGCTL_BIST_CTL_DMA0_BIST_START      0x00000004

#define BF_DIGCTL_BIST_CTL_DMA0_BIST_START(v)   (((v) << 2) & BM_DIGCTL_BIST_CTL_DMA0_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_DMA0_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, DMA0_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field CACHE_BIST_START */

#define BP_DIGCTL_BIST_CTL_CACHE_BIST_START      1
#define BM_DIGCTL_BIST_CTL_CACHE_BIST_START      0x00000002

#define BF_DIGCTL_BIST_CTL_CACHE_BIST_START(v)   (((v) << 1) & BM_DIGCTL_BIST_CTL_CACHE_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_CACHE_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, CACHE_BIST_START, v)
#endif

/* --- Register HW_DIGCTL_BIST_CTL, field CAN_BIST_START */

#define BP_DIGCTL_BIST_CTL_CAN_BIST_START      0
#define BM_DIGCTL_BIST_CTL_CAN_BIST_START      0x00000001

#define BF_DIGCTL_BIST_CTL_CAN_BIST_START(v)   (((v) << 0) & BM_DIGCTL_BIST_CTL_CAN_BIST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_BIST_CTL_CAN_BIST_START(v)   BF_CS1(DIGCTL_BIST_CTL, CAN_BIST_START, v)
#endif



/*
 * HW_DIGCTL_BIST_STATUS - DIGCTL Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CAN_BIST_DONE         :  1;
        unsigned CACHE_BIST_DONE       :  1;
        unsigned DMA0_BIST_DONE        :  1;
        unsigned DMA1_BIST_DONE        :  1;
        unsigned USB0_BIST_DONE        :  1;
        unsigned USB1_BIST_DONE        :  1;
        unsigned ENET_BIST_DONE        :  1;
        unsigned DCP_BIST_DONE         :  1;
        unsigned LCDIF_BIST_DONE       :  1;
        unsigned PXP_BIST_DONE         :  1;
        unsigned CAN_BIST_FAIL         :  1;
        unsigned CACHE_BIST_FAIL       :  1;
        unsigned DMA0_BIST_FAIL        :  1;
        unsigned DMA1_BIST_FAIL        :  1;
        unsigned USB0_BIST_FAIL        :  1;
        unsigned USB1_BIST_FAIL        :  1;
        unsigned ENET_BIST_FAIL        :  1;
        unsigned DCP_BIST_FAIL         :  1;
        unsigned LCDIF_BIST_FAIL       :  1;
        unsigned PXP_BIST_FAIL         :  1;
        unsigned CAN_BIST_RETENTION    :  1;
        unsigned CACHE_BIST_RETENTION  :  1;
        unsigned DMA0_BIST_RETENTION   :  1;
        unsigned DMA1_BIST_RETENTION   :  1;
        unsigned USB0_BIST_RETENTION   :  1;
        unsigned USB1_BIST_RETENTION   :  1;
        unsigned ENET_BIST_RETENTION   :  1;
        unsigned DCP_BIST_RETENTION    :  1;
        unsigned LCDIF_BIST_RETENTION  :  1;
        unsigned PXP_BIST_RETENTION    :  1;
        unsigned RSVD0                 :  2;
    } B;
} hw_digctl_bist_status_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_BIST_STATUS register
 */
#define HW_DIGCTL_BIST_STATUS_ADDR         (REGS_DIGCTL_BASE + 0x80)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_BIST_STATUS           (*(volatile hw_digctl_bist_status_t *) HW_DIGCTL_BIST_STATUS_ADDR)
#define HW_DIGCTL_BIST_STATUS_RD()      (HW_DIGCTL_BIST_STATUS.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_BIST_STATUS bitfields
 */
/* --- Register HW_DIGCTL_BIST_STATUS, field RSVD0 */

#define BP_DIGCTL_BIST_STATUS_RSVD0      30
#define BM_DIGCTL_BIST_STATUS_RSVD0      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_BIST_STATUS_RSVD0(v)   ((((reg32_t) v) << 30) & BM_DIGCTL_BIST_STATUS_RSVD0)
#else
#define BF_DIGCTL_BIST_STATUS_RSVD0(v)   (((v) << 30) & BM_DIGCTL_BIST_STATUS_RSVD0)
#endif
/* --- Register HW_DIGCTL_BIST_STATUS, field PXP_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_PXP_BIST_RETENTION      29
#define BM_DIGCTL_BIST_STATUS_PXP_BIST_RETENTION      0x20000000

#define BF_DIGCTL_BIST_STATUS_PXP_BIST_RETENTION(v)   (((v) << 29) & BM_DIGCTL_BIST_STATUS_PXP_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field LCDIF_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_LCDIF_BIST_RETENTION      28
#define BM_DIGCTL_BIST_STATUS_LCDIF_BIST_RETENTION      0x10000000

#define BF_DIGCTL_BIST_STATUS_LCDIF_BIST_RETENTION(v)   (((v) << 28) & BM_DIGCTL_BIST_STATUS_LCDIF_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field DCP_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_DCP_BIST_RETENTION      27
#define BM_DIGCTL_BIST_STATUS_DCP_BIST_RETENTION      0x08000000

#define BF_DIGCTL_BIST_STATUS_DCP_BIST_RETENTION(v)   (((v) << 27) & BM_DIGCTL_BIST_STATUS_DCP_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field ENET_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_ENET_BIST_RETENTION      26
#define BM_DIGCTL_BIST_STATUS_ENET_BIST_RETENTION      0x04000000

#define BF_DIGCTL_BIST_STATUS_ENET_BIST_RETENTION(v)   (((v) << 26) & BM_DIGCTL_BIST_STATUS_ENET_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field USB1_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_USB1_BIST_RETENTION      25
#define BM_DIGCTL_BIST_STATUS_USB1_BIST_RETENTION      0x02000000

#define BF_DIGCTL_BIST_STATUS_USB1_BIST_RETENTION(v)   (((v) << 25) & BM_DIGCTL_BIST_STATUS_USB1_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field USB0_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_USB0_BIST_RETENTION      24
#define BM_DIGCTL_BIST_STATUS_USB0_BIST_RETENTION      0x01000000

#define BF_DIGCTL_BIST_STATUS_USB0_BIST_RETENTION(v)   (((v) << 24) & BM_DIGCTL_BIST_STATUS_USB0_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field DMA1_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_DMA1_BIST_RETENTION      23
#define BM_DIGCTL_BIST_STATUS_DMA1_BIST_RETENTION      0x00800000

#define BF_DIGCTL_BIST_STATUS_DMA1_BIST_RETENTION(v)   (((v) << 23) & BM_DIGCTL_BIST_STATUS_DMA1_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field DMA0_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_DMA0_BIST_RETENTION      22
#define BM_DIGCTL_BIST_STATUS_DMA0_BIST_RETENTION      0x00400000

#define BF_DIGCTL_BIST_STATUS_DMA0_BIST_RETENTION(v)   (((v) << 22) & BM_DIGCTL_BIST_STATUS_DMA0_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field CACHE_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_CACHE_BIST_RETENTION      21
#define BM_DIGCTL_BIST_STATUS_CACHE_BIST_RETENTION      0x00200000

#define BF_DIGCTL_BIST_STATUS_CACHE_BIST_RETENTION(v)   (((v) << 21) & BM_DIGCTL_BIST_STATUS_CACHE_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field CAN_BIST_RETENTION */

#define BP_DIGCTL_BIST_STATUS_CAN_BIST_RETENTION      20
#define BM_DIGCTL_BIST_STATUS_CAN_BIST_RETENTION      0x00100000

#define BF_DIGCTL_BIST_STATUS_CAN_BIST_RETENTION(v)   (((v) << 20) & BM_DIGCTL_BIST_STATUS_CAN_BIST_RETENTION)
/* --- Register HW_DIGCTL_BIST_STATUS, field PXP_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_PXP_BIST_FAIL      19
#define BM_DIGCTL_BIST_STATUS_PXP_BIST_FAIL      0x00080000

#define BF_DIGCTL_BIST_STATUS_PXP_BIST_FAIL(v)   (((v) << 19) & BM_DIGCTL_BIST_STATUS_PXP_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field LCDIF_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_LCDIF_BIST_FAIL      18
#define BM_DIGCTL_BIST_STATUS_LCDIF_BIST_FAIL      0x00040000

#define BF_DIGCTL_BIST_STATUS_LCDIF_BIST_FAIL(v)   (((v) << 18) & BM_DIGCTL_BIST_STATUS_LCDIF_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field DCP_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_DCP_BIST_FAIL      17
#define BM_DIGCTL_BIST_STATUS_DCP_BIST_FAIL      0x00020000

#define BF_DIGCTL_BIST_STATUS_DCP_BIST_FAIL(v)   (((v) << 17) & BM_DIGCTL_BIST_STATUS_DCP_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field ENET_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_ENET_BIST_FAIL      16
#define BM_DIGCTL_BIST_STATUS_ENET_BIST_FAIL      0x00010000

#define BF_DIGCTL_BIST_STATUS_ENET_BIST_FAIL(v)   (((v) << 16) & BM_DIGCTL_BIST_STATUS_ENET_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field USB1_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_USB1_BIST_FAIL      15
#define BM_DIGCTL_BIST_STATUS_USB1_BIST_FAIL      0x00008000

#define BF_DIGCTL_BIST_STATUS_USB1_BIST_FAIL(v)   (((v) << 15) & BM_DIGCTL_BIST_STATUS_USB1_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field USB0_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_USB0_BIST_FAIL      14
#define BM_DIGCTL_BIST_STATUS_USB0_BIST_FAIL      0x00004000

#define BF_DIGCTL_BIST_STATUS_USB0_BIST_FAIL(v)   (((v) << 14) & BM_DIGCTL_BIST_STATUS_USB0_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field DMA1_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_DMA1_BIST_FAIL      13
#define BM_DIGCTL_BIST_STATUS_DMA1_BIST_FAIL      0x00002000

#define BF_DIGCTL_BIST_STATUS_DMA1_BIST_FAIL(v)   (((v) << 13) & BM_DIGCTL_BIST_STATUS_DMA1_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field DMA0_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_DMA0_BIST_FAIL      12
#define BM_DIGCTL_BIST_STATUS_DMA0_BIST_FAIL      0x00001000

#define BF_DIGCTL_BIST_STATUS_DMA0_BIST_FAIL(v)   (((v) << 12) & BM_DIGCTL_BIST_STATUS_DMA0_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field CACHE_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_CACHE_BIST_FAIL      11
#define BM_DIGCTL_BIST_STATUS_CACHE_BIST_FAIL      0x00000800

#define BF_DIGCTL_BIST_STATUS_CACHE_BIST_FAIL(v)   (((v) << 11) & BM_DIGCTL_BIST_STATUS_CACHE_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field CAN_BIST_FAIL */

#define BP_DIGCTL_BIST_STATUS_CAN_BIST_FAIL      10
#define BM_DIGCTL_BIST_STATUS_CAN_BIST_FAIL      0x00000400

#define BF_DIGCTL_BIST_STATUS_CAN_BIST_FAIL(v)   (((v) << 10) & BM_DIGCTL_BIST_STATUS_CAN_BIST_FAIL)
/* --- Register HW_DIGCTL_BIST_STATUS, field PXP_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_PXP_BIST_DONE      9
#define BM_DIGCTL_BIST_STATUS_PXP_BIST_DONE      0x00000200

#define BF_DIGCTL_BIST_STATUS_PXP_BIST_DONE(v)   (((v) << 9) & BM_DIGCTL_BIST_STATUS_PXP_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_STATUS, field LCDIF_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_LCDIF_BIST_DONE      8
#define BM_DIGCTL_BIST_STATUS_LCDIF_BIST_DONE      0x00000100

#define BF_DIGCTL_BIST_STATUS_LCDIF_BIST_DONE(v)   (((v) << 8) & BM_DIGCTL_BIST_STATUS_LCDIF_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_STATUS, field DCP_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_DCP_BIST_DONE      7
#define BM_DIGCTL_BIST_STATUS_DCP_BIST_DONE      0x00000080

#define BF_DIGCTL_BIST_STATUS_DCP_BIST_DONE(v)   (((v) << 7) & BM_DIGCTL_BIST_STATUS_DCP_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_STATUS, field ENET_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_ENET_BIST_DONE      6
#define BM_DIGCTL_BIST_STATUS_ENET_BIST_DONE      0x00000040

#define BF_DIGCTL_BIST_STATUS_ENET_BIST_DONE(v)   (((v) << 6) & BM_DIGCTL_BIST_STATUS_ENET_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_STATUS, field USB1_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_USB1_BIST_DONE      5
#define BM_DIGCTL_BIST_STATUS_USB1_BIST_DONE      0x00000020

#define BF_DIGCTL_BIST_STATUS_USB1_BIST_DONE(v)   (((v) << 5) & BM_DIGCTL_BIST_STATUS_USB1_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_STATUS, field USB0_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_USB0_BIST_DONE      4
#define BM_DIGCTL_BIST_STATUS_USB0_BIST_DONE      0x00000010

#define BF_DIGCTL_BIST_STATUS_USB0_BIST_DONE(v)   (((v) << 4) & BM_DIGCTL_BIST_STATUS_USB0_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_STATUS, field DMA1_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_DMA1_BIST_DONE      3
#define BM_DIGCTL_BIST_STATUS_DMA1_BIST_DONE      0x00000008

#define BF_DIGCTL_BIST_STATUS_DMA1_BIST_DONE(v)   (((v) << 3) & BM_DIGCTL_BIST_STATUS_DMA1_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_STATUS, field DMA0_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_DMA0_BIST_DONE      2
#define BM_DIGCTL_BIST_STATUS_DMA0_BIST_DONE      0x00000004

#define BF_DIGCTL_BIST_STATUS_DMA0_BIST_DONE(v)   (((v) << 2) & BM_DIGCTL_BIST_STATUS_DMA0_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_STATUS, field CACHE_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_CACHE_BIST_DONE      1
#define BM_DIGCTL_BIST_STATUS_CACHE_BIST_DONE      0x00000002

#define BF_DIGCTL_BIST_STATUS_CACHE_BIST_DONE(v)   (((v) << 1) & BM_DIGCTL_BIST_STATUS_CACHE_BIST_DONE)
/* --- Register HW_DIGCTL_BIST_STATUS, field CAN_BIST_DONE */

#define BP_DIGCTL_BIST_STATUS_CAN_BIST_DONE      0
#define BM_DIGCTL_BIST_STATUS_CAN_BIST_DONE      0x00000001

#define BF_DIGCTL_BIST_STATUS_CAN_BIST_DONE(v)   (((v) << 0) & BM_DIGCTL_BIST_STATUS_CAN_BIST_DONE)


/*
 * HW_DIGCTL_ENTROPY - Entropy Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VALUE  : 32;
    } B;
} hw_digctl_entropy_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_ENTROPY register
 */
#define HW_DIGCTL_ENTROPY_ADDR         (REGS_DIGCTL_BASE + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_ENTROPY           (*(volatile hw_digctl_entropy_t *) HW_DIGCTL_ENTROPY_ADDR)
#define HW_DIGCTL_ENTROPY_RD()      (HW_DIGCTL_ENTROPY.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_ENTROPY bitfields
 */
/* --- Register HW_DIGCTL_ENTROPY, field VALUE */

#define BP_DIGCTL_ENTROPY_VALUE      0
#define BM_DIGCTL_ENTROPY_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_ENTROPY_VALUE(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_ENTROPY_VALUE(v)   (v)
#endif


/*
 * HW_DIGCTL_ENTROPY_LATCHED - Entropy Latched Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VALUE  : 32;
    } B;
} hw_digctl_entropy_latched_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_ENTROPY_LATCHED register
 */
#define HW_DIGCTL_ENTROPY_LATCHED_ADDR         (REGS_DIGCTL_BASE + 0xa0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_ENTROPY_LATCHED           (*(volatile hw_digctl_entropy_latched_t *) HW_DIGCTL_ENTROPY_LATCHED_ADDR)
#define HW_DIGCTL_ENTROPY_LATCHED_RD()      (HW_DIGCTL_ENTROPY_LATCHED.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_ENTROPY_LATCHED bitfields
 */
/* --- Register HW_DIGCTL_ENTROPY_LATCHED, field VALUE */

#define BP_DIGCTL_ENTROPY_LATCHED_VALUE      0
#define BM_DIGCTL_ENTROPY_LATCHED_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_ENTROPY_LATCHED_VALUE(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_ENTROPY_LATCHED_VALUE(v)   (v)
#endif


/*
 * HW_DIGCTL_MICROSECONDS - Digital Control Microseconds Counter Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VALUE  : 32;
    } B;
} hw_digctl_microseconds_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_MICROSECONDS register
 */
#define HW_DIGCTL_MICROSECONDS_ADDR         (REGS_DIGCTL_BASE + 0xc0)
#define HW_DIGCTL_MICROSECONDS_SET_ADDR     (HW_DIGCTL_MICROSECONDS_ADDR + 4)
#define HW_DIGCTL_MICROSECONDS_CLR_ADDR     (HW_DIGCTL_MICROSECONDS_ADDR + 8)
#define HW_DIGCTL_MICROSECONDS_TOG_ADDR     (HW_DIGCTL_MICROSECONDS_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_MICROSECONDS           (*(volatile hw_digctl_microseconds_t *) HW_DIGCTL_MICROSECONDS_ADDR)
#define HW_DIGCTL_MICROSECONDS_RD()      (HW_DIGCTL_MICROSECONDS.U)
#define HW_DIGCTL_MICROSECONDS_WR(v)     (HW_DIGCTL_MICROSECONDS.U = (v))
#define HW_DIGCTL_MICROSECONDS_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_MICROSECONDS_SET_ADDR) = (v))
#define HW_DIGCTL_MICROSECONDS_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_MICROSECONDS_CLR_ADDR) = (v))
#define HW_DIGCTL_MICROSECONDS_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_MICROSECONDS_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DIGCTL_MICROSECONDS bitfields
 */
/* --- Register HW_DIGCTL_MICROSECONDS, field VALUE */

#define BP_DIGCTL_MICROSECONDS_VALUE      0
#define BM_DIGCTL_MICROSECONDS_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_MICROSECONDS_VALUE(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_MICROSECONDS_VALUE(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_MICROSECONDS_VALUE(v)   (HW_DIGCTL_MICROSECONDS.B.VALUE = (v))
#endif



/*
 * HW_DIGCTL_DBGRD - Digital Control Debug Read Test Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COMPLEMENT  : 32;
    } B;
} hw_digctl_dbgrd_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_DBGRD register
 */
#define HW_DIGCTL_DBGRD_ADDR         (REGS_DIGCTL_BASE + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DBGRD           (*(volatile hw_digctl_dbgrd_t *) HW_DIGCTL_DBGRD_ADDR)
#define HW_DIGCTL_DBGRD_RD()      (HW_DIGCTL_DBGRD.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_DBGRD bitfields
 */
/* --- Register HW_DIGCTL_DBGRD, field COMPLEMENT */

#define BP_DIGCTL_DBGRD_COMPLEMENT      0
#define BM_DIGCTL_DBGRD_COMPLEMENT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DBGRD_COMPLEMENT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DBGRD_COMPLEMENT(v)   (v)
#endif


/*
 * HW_DIGCTL_DBG - Digital Control Debug Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VALUE  : 32;
    } B;
} hw_digctl_dbg_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_DBG register
 */
#define HW_DIGCTL_DBG_ADDR         (REGS_DIGCTL_BASE + 0xe0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DBG           (*(volatile hw_digctl_dbg_t *) HW_DIGCTL_DBG_ADDR)
#define HW_DIGCTL_DBG_RD()      (HW_DIGCTL_DBG.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_DBG bitfields
 */
/* --- Register HW_DIGCTL_DBG, field VALUE */

#define BP_DIGCTL_DBG_VALUE      0
#define BM_DIGCTL_DBG_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DBG_VALUE(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DBG_VALUE(v)   (v)
#endif


/*
 * HW_DIGCTL_USB_LOOPBACK - USB LOOP BACK
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned UTMO0_DIG_TST0  :  1;
        unsigned UTMO0_DIG_TST1  :  1;
        unsigned UTMO1_DIG_TST0  :  1;
        unsigned UTMO1_DIG_TST1  :  1;
        unsigned UTMI0_DIG_TST0  :  1;
        unsigned UTMI0_DIG_TST1  :  1;
        unsigned TSTI0_TX_HIZ    :  1;
        unsigned TSTI0_TX_EN     :  1;
        unsigned TSTI0_TX_HS     :  1;
        unsigned TSTI0_TX_LS     :  1;
        unsigned USB0_TST_START  :  1;
        unsigned UTMI1_DIG_TST0  :  1;
        unsigned UTMI1_DIG_TST1  :  1;
        unsigned TSTI1_TX_HIZ    :  1;
        unsigned TSTI1_TX_EN     :  1;
        unsigned TSTI1_TX_HS     :  1;
        unsigned TSTI1_TX_LS     :  1;
        unsigned USB1_TST_START  :  1;
        unsigned RSVD0           : 14;
    } B;
} hw_digctl_usb_loopback_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_USB_LOOPBACK register
 */
#define HW_DIGCTL_USB_LOOPBACK_ADDR         (REGS_DIGCTL_BASE + 0x100)
#define HW_DIGCTL_USB_LOOPBACK_SET_ADDR     (HW_DIGCTL_USB_LOOPBACK_ADDR + 4)
#define HW_DIGCTL_USB_LOOPBACK_CLR_ADDR     (HW_DIGCTL_USB_LOOPBACK_ADDR + 8)
#define HW_DIGCTL_USB_LOOPBACK_TOG_ADDR     (HW_DIGCTL_USB_LOOPBACK_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_USB_LOOPBACK           (*(volatile hw_digctl_usb_loopback_t *) HW_DIGCTL_USB_LOOPBACK_ADDR)
#define HW_DIGCTL_USB_LOOPBACK_RD()      (HW_DIGCTL_USB_LOOPBACK.U)
#define HW_DIGCTL_USB_LOOPBACK_WR(v)     (HW_DIGCTL_USB_LOOPBACK.U = (v))
#define HW_DIGCTL_USB_LOOPBACK_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_USB_LOOPBACK_SET_ADDR) = (v))
#define HW_DIGCTL_USB_LOOPBACK_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_USB_LOOPBACK_CLR_ADDR) = (v))
#define HW_DIGCTL_USB_LOOPBACK_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_USB_LOOPBACK_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DIGCTL_USB_LOOPBACK bitfields
 */
/* --- Register HW_DIGCTL_USB_LOOPBACK, field RSVD0 */

#define BP_DIGCTL_USB_LOOPBACK_RSVD0      18
#define BM_DIGCTL_USB_LOOPBACK_RSVD0      0xFFFC0000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_USB_LOOPBACK_RSVD0(v)   ((((reg32_t) v) << 18) & BM_DIGCTL_USB_LOOPBACK_RSVD0)
#else
#define BF_DIGCTL_USB_LOOPBACK_RSVD0(v)   (((v) << 18) & BM_DIGCTL_USB_LOOPBACK_RSVD0)
#endif
/* --- Register HW_DIGCTL_USB_LOOPBACK, field USB1_TST_START */

#define BP_DIGCTL_USB_LOOPBACK_USB1_TST_START      17
#define BM_DIGCTL_USB_LOOPBACK_USB1_TST_START      0x00020000

#define BF_DIGCTL_USB_LOOPBACK_USB1_TST_START(v)   (((v) << 17) & BM_DIGCTL_USB_LOOPBACK_USB1_TST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_USB1_TST_START(v)   BF_CS1(DIGCTL_USB_LOOPBACK, USB1_TST_START, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field TSTI1_TX_LS */

#define BP_DIGCTL_USB_LOOPBACK_TSTI1_TX_LS      16
#define BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_LS      0x00010000

#define BF_DIGCTL_USB_LOOPBACK_TSTI1_TX_LS(v)   (((v) << 16) & BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_LS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_TSTI1_TX_LS(v)   BF_CS1(DIGCTL_USB_LOOPBACK, TSTI1_TX_LS, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field TSTI1_TX_HS */

#define BP_DIGCTL_USB_LOOPBACK_TSTI1_TX_HS      15
#define BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_HS      0x00008000

#define BF_DIGCTL_USB_LOOPBACK_TSTI1_TX_HS(v)   (((v) << 15) & BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_HS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_TSTI1_TX_HS(v)   BF_CS1(DIGCTL_USB_LOOPBACK, TSTI1_TX_HS, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field TSTI1_TX_EN */

#define BP_DIGCTL_USB_LOOPBACK_TSTI1_TX_EN      14
#define BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_EN      0x00004000

#define BF_DIGCTL_USB_LOOPBACK_TSTI1_TX_EN(v)   (((v) << 14) & BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_TSTI1_TX_EN(v)   BF_CS1(DIGCTL_USB_LOOPBACK, TSTI1_TX_EN, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field TSTI1_TX_HIZ */

#define BP_DIGCTL_USB_LOOPBACK_TSTI1_TX_HIZ      13
#define BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_HIZ      0x00002000

#define BF_DIGCTL_USB_LOOPBACK_TSTI1_TX_HIZ(v)   (((v) << 13) & BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_HIZ)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_TSTI1_TX_HIZ(v)   BF_CS1(DIGCTL_USB_LOOPBACK, TSTI1_TX_HIZ, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field UTMI1_DIG_TST1 */

#define BP_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST1      12
#define BM_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST1      0x00001000

#define BF_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST1(v)   (((v) << 12) & BM_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST1)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST1(v)   BF_CS1(DIGCTL_USB_LOOPBACK, UTMI1_DIG_TST1, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field UTMI1_DIG_TST0 */

#define BP_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST0      11
#define BM_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST0      0x00000800

#define BF_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST0(v)   (((v) << 11) & BM_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST0)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST0(v)   BF_CS1(DIGCTL_USB_LOOPBACK, UTMI1_DIG_TST0, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field USB0_TST_START */

#define BP_DIGCTL_USB_LOOPBACK_USB0_TST_START      10
#define BM_DIGCTL_USB_LOOPBACK_USB0_TST_START      0x00000400

#define BF_DIGCTL_USB_LOOPBACK_USB0_TST_START(v)   (((v) << 10) & BM_DIGCTL_USB_LOOPBACK_USB0_TST_START)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_USB0_TST_START(v)   BF_CS1(DIGCTL_USB_LOOPBACK, USB0_TST_START, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field TSTI0_TX_LS */

#define BP_DIGCTL_USB_LOOPBACK_TSTI0_TX_LS      9
#define BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_LS      0x00000200

#define BF_DIGCTL_USB_LOOPBACK_TSTI0_TX_LS(v)   (((v) << 9) & BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_LS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_TSTI0_TX_LS(v)   BF_CS1(DIGCTL_USB_LOOPBACK, TSTI0_TX_LS, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field TSTI0_TX_HS */

#define BP_DIGCTL_USB_LOOPBACK_TSTI0_TX_HS      8
#define BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_HS      0x00000100

#define BF_DIGCTL_USB_LOOPBACK_TSTI0_TX_HS(v)   (((v) << 8) & BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_HS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_TSTI0_TX_HS(v)   BF_CS1(DIGCTL_USB_LOOPBACK, TSTI0_TX_HS, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field TSTI0_TX_EN */

#define BP_DIGCTL_USB_LOOPBACK_TSTI0_TX_EN      7
#define BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_EN      0x00000080

#define BF_DIGCTL_USB_LOOPBACK_TSTI0_TX_EN(v)   (((v) << 7) & BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_EN)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_TSTI0_TX_EN(v)   BF_CS1(DIGCTL_USB_LOOPBACK, TSTI0_TX_EN, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field TSTI0_TX_HIZ */

#define BP_DIGCTL_USB_LOOPBACK_TSTI0_TX_HIZ      6
#define BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_HIZ      0x00000040

#define BF_DIGCTL_USB_LOOPBACK_TSTI0_TX_HIZ(v)   (((v) << 6) & BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_HIZ)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_TSTI0_TX_HIZ(v)   BF_CS1(DIGCTL_USB_LOOPBACK, TSTI0_TX_HIZ, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field UTMI0_DIG_TST1 */

#define BP_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST1      5
#define BM_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST1      0x00000020

#define BF_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST1(v)   (((v) << 5) & BM_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST1)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST1(v)   BF_CS1(DIGCTL_USB_LOOPBACK, UTMI0_DIG_TST1, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field UTMI0_DIG_TST0 */

#define BP_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST0      4
#define BM_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST0      0x00000010

#define BF_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST0(v)   (((v) << 4) & BM_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST0)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST0(v)   BF_CS1(DIGCTL_USB_LOOPBACK, UTMI0_DIG_TST0, v)
#endif

/* --- Register HW_DIGCTL_USB_LOOPBACK, field UTMO1_DIG_TST1 */

#define BP_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST1      3
#define BM_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST1      0x00000008

#define BF_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST1(v)   (((v) << 3) & BM_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST1)
/* --- Register HW_DIGCTL_USB_LOOPBACK, field UTMO1_DIG_TST0 */

#define BP_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST0      2
#define BM_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST0      0x00000004

#define BF_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST0(v)   (((v) << 2) & BM_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST0)
/* --- Register HW_DIGCTL_USB_LOOPBACK, field UTMO0_DIG_TST1 */

#define BP_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST1      1
#define BM_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST1      0x00000002

#define BF_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST1(v)   (((v) << 1) & BM_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST1)
/* --- Register HW_DIGCTL_USB_LOOPBACK, field UTMO0_DIG_TST0 */

#define BP_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST0      0
#define BM_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST0      0x00000001

#define BF_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST0(v)   (((v) << 0) & BM_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST0)


/*
 * HW_DIGCTL_OCRAM_STATUS0 - SRAM Status Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILDATA00  : 32;
    } B;
} hw_digctl_ocram_status0_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS0 register
 */
#define HW_DIGCTL_OCRAM_STATUS0_ADDR         (REGS_DIGCTL_BASE + 0x110)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS0           (*(volatile hw_digctl_ocram_status0_t *) HW_DIGCTL_OCRAM_STATUS0_ADDR)
#define HW_DIGCTL_OCRAM_STATUS0_RD()      (HW_DIGCTL_OCRAM_STATUS0.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS0 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS0, field FAILDATA00 */

#define BP_DIGCTL_OCRAM_STATUS0_FAILDATA00      0
#define BM_DIGCTL_OCRAM_STATUS0_FAILDATA00      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS0_FAILDATA00(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS0_FAILDATA00(v)   (v)
#endif


/*
 * HW_DIGCTL_OCRAM_STATUS1 - SRAM Status Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILDATA01  : 32;
    } B;
} hw_digctl_ocram_status1_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS1 register
 */
#define HW_DIGCTL_OCRAM_STATUS1_ADDR         (REGS_DIGCTL_BASE + 0x120)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS1           (*(volatile hw_digctl_ocram_status1_t *) HW_DIGCTL_OCRAM_STATUS1_ADDR)
#define HW_DIGCTL_OCRAM_STATUS1_RD()      (HW_DIGCTL_OCRAM_STATUS1.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS1 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS1, field FAILDATA01 */

#define BP_DIGCTL_OCRAM_STATUS1_FAILDATA01      0
#define BM_DIGCTL_OCRAM_STATUS1_FAILDATA01      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS1_FAILDATA01(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS1_FAILDATA01(v)   (v)
#endif


/*
 * HW_DIGCTL_OCRAM_STATUS2 - SRAM Status Register 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILDATA10  : 32;
    } B;
} hw_digctl_ocram_status2_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS2 register
 */
#define HW_DIGCTL_OCRAM_STATUS2_ADDR         (REGS_DIGCTL_BASE + 0x130)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS2           (*(volatile hw_digctl_ocram_status2_t *) HW_DIGCTL_OCRAM_STATUS2_ADDR)
#define HW_DIGCTL_OCRAM_STATUS2_RD()      (HW_DIGCTL_OCRAM_STATUS2.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS2 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS2, field FAILDATA10 */

#define BP_DIGCTL_OCRAM_STATUS2_FAILDATA10      0
#define BM_DIGCTL_OCRAM_STATUS2_FAILDATA10      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS2_FAILDATA10(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS2_FAILDATA10(v)   (v)
#endif


/*
 * HW_DIGCTL_OCRAM_STATUS3 - SRAM Status Register 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILDATA11  : 32;
    } B;
} hw_digctl_ocram_status3_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS3 register
 */
#define HW_DIGCTL_OCRAM_STATUS3_ADDR         (REGS_DIGCTL_BASE + 0x140)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS3           (*(volatile hw_digctl_ocram_status3_t *) HW_DIGCTL_OCRAM_STATUS3_ADDR)
#define HW_DIGCTL_OCRAM_STATUS3_RD()      (HW_DIGCTL_OCRAM_STATUS3.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS3 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS3, field FAILDATA11 */

#define BP_DIGCTL_OCRAM_STATUS3_FAILDATA11      0
#define BM_DIGCTL_OCRAM_STATUS3_FAILDATA11      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS3_FAILDATA11(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS3_FAILDATA11(v)   (v)
#endif


/*
 * HW_DIGCTL_OCRAM_STATUS4 - SRAM Status Register 4
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILDATA20  : 32;
    } B;
} hw_digctl_ocram_status4_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS4 register
 */
#define HW_DIGCTL_OCRAM_STATUS4_ADDR         (REGS_DIGCTL_BASE + 0x150)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS4           (*(volatile hw_digctl_ocram_status4_t *) HW_DIGCTL_OCRAM_STATUS4_ADDR)
#define HW_DIGCTL_OCRAM_STATUS4_RD()      (HW_DIGCTL_OCRAM_STATUS4.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS4 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS4, field FAILDATA20 */

#define BP_DIGCTL_OCRAM_STATUS4_FAILDATA20      0
#define BM_DIGCTL_OCRAM_STATUS4_FAILDATA20      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS4_FAILDATA20(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS4_FAILDATA20(v)   (v)
#endif


/*
 * HW_DIGCTL_OCRAM_STATUS5 - SRAM Status Register 5
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILDATA21  : 32;
    } B;
} hw_digctl_ocram_status5_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS5 register
 */
#define HW_DIGCTL_OCRAM_STATUS5_ADDR         (REGS_DIGCTL_BASE + 0x160)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS5           (*(volatile hw_digctl_ocram_status5_t *) HW_DIGCTL_OCRAM_STATUS5_ADDR)
#define HW_DIGCTL_OCRAM_STATUS5_RD()      (HW_DIGCTL_OCRAM_STATUS5.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS5 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS5, field FAILDATA21 */

#define BP_DIGCTL_OCRAM_STATUS5_FAILDATA21      0
#define BM_DIGCTL_OCRAM_STATUS5_FAILDATA21      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS5_FAILDATA21(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS5_FAILDATA21(v)   (v)
#endif


/*
 * HW_DIGCTL_OCRAM_STATUS6 - SRAM Status Register 6
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILDATA30  : 32;
    } B;
} hw_digctl_ocram_status6_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS6 register
 */
#define HW_DIGCTL_OCRAM_STATUS6_ADDR         (REGS_DIGCTL_BASE + 0x170)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS6           (*(volatile hw_digctl_ocram_status6_t *) HW_DIGCTL_OCRAM_STATUS6_ADDR)
#define HW_DIGCTL_OCRAM_STATUS6_RD()      (HW_DIGCTL_OCRAM_STATUS6.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS6 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS6, field FAILDATA30 */

#define BP_DIGCTL_OCRAM_STATUS6_FAILDATA30      0
#define BM_DIGCTL_OCRAM_STATUS6_FAILDATA30      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS6_FAILDATA30(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS6_FAILDATA30(v)   (v)
#endif


/*
 * HW_DIGCTL_OCRAM_STATUS7 - SRAM Status Register 7
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILDATA31  : 32;
    } B;
} hw_digctl_ocram_status7_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS7 register
 */
#define HW_DIGCTL_OCRAM_STATUS7_ADDR         (REGS_DIGCTL_BASE + 0x180)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS7           (*(volatile hw_digctl_ocram_status7_t *) HW_DIGCTL_OCRAM_STATUS7_ADDR)
#define HW_DIGCTL_OCRAM_STATUS7_RD()      (HW_DIGCTL_OCRAM_STATUS7.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS7 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS7, field FAILDATA31 */

#define BP_DIGCTL_OCRAM_STATUS7_FAILDATA31      0
#define BM_DIGCTL_OCRAM_STATUS7_FAILDATA31      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS7_FAILDATA31(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_OCRAM_STATUS7_FAILDATA31(v)   (v)
#endif


/*
 * HW_DIGCTL_OCRAM_STATUS8 - SRAM Status Register 8
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILADDR00  : 16;
        unsigned FAILADDR01  : 16;
    } B;
} hw_digctl_ocram_status8_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS8 register
 */
#define HW_DIGCTL_OCRAM_STATUS8_ADDR         (REGS_DIGCTL_BASE + 0x190)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS8           (*(volatile hw_digctl_ocram_status8_t *) HW_DIGCTL_OCRAM_STATUS8_ADDR)
#define HW_DIGCTL_OCRAM_STATUS8_RD()      (HW_DIGCTL_OCRAM_STATUS8.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS8 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS8, field FAILADDR01 */

#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR01      16
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR01      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR01(v)   ((((reg32_t) v) << 16) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR01)
#else
#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR01(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR01)
#endif
/* --- Register HW_DIGCTL_OCRAM_STATUS8, field FAILADDR00 */

#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR00      0
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR00      0x0000FFFF

#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR00(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR00)


/*
 * HW_DIGCTL_OCRAM_STATUS9 - SRAM Status Register 9
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILADDR10  : 16;
        unsigned FAILADDR11  : 16;
    } B;
} hw_digctl_ocram_status9_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS9 register
 */
#define HW_DIGCTL_OCRAM_STATUS9_ADDR         (REGS_DIGCTL_BASE + 0x1a0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS9           (*(volatile hw_digctl_ocram_status9_t *) HW_DIGCTL_OCRAM_STATUS9_ADDR)
#define HW_DIGCTL_OCRAM_STATUS9_RD()      (HW_DIGCTL_OCRAM_STATUS9.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS9 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS9, field FAILADDR11 */

#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR11      16
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR11      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR11(v)   ((((reg32_t) v) << 16) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR11)
#else
#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR11(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR11)
#endif
/* --- Register HW_DIGCTL_OCRAM_STATUS9, field FAILADDR10 */

#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR10      0
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR10      0x0000FFFF

#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR10(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR10)


/*
 * HW_DIGCTL_OCRAM_STATUS10 - SRAM Status Register 10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILADDR20  : 16;
        unsigned FAILADDR21  : 16;
    } B;
} hw_digctl_ocram_status10_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS10 register
 */
#define HW_DIGCTL_OCRAM_STATUS10_ADDR         (REGS_DIGCTL_BASE + 0x1b0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS10           (*(volatile hw_digctl_ocram_status10_t *) HW_DIGCTL_OCRAM_STATUS10_ADDR)
#define HW_DIGCTL_OCRAM_STATUS10_RD()      (HW_DIGCTL_OCRAM_STATUS10.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS10 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS10, field FAILADDR21 */

#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR21      16
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR21      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR21(v)   ((((reg32_t) v) << 16) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR21)
#else
#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR21(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR21)
#endif
/* --- Register HW_DIGCTL_OCRAM_STATUS10, field FAILADDR20 */

#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR20      0
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR20      0x0000FFFF

#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR20(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR20)


/*
 * HW_DIGCTL_OCRAM_STATUS11 - SRAM Status Register 11
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILADDR30  : 16;
        unsigned FAILADDR31  : 16;
    } B;
} hw_digctl_ocram_status11_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS11 register
 */
#define HW_DIGCTL_OCRAM_STATUS11_ADDR         (REGS_DIGCTL_BASE + 0x1c0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS11           (*(volatile hw_digctl_ocram_status11_t *) HW_DIGCTL_OCRAM_STATUS11_ADDR)
#define HW_DIGCTL_OCRAM_STATUS11_RD()      (HW_DIGCTL_OCRAM_STATUS11.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS11 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS11, field FAILADDR31 */

#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR31      16
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR31      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR31(v)   ((((reg32_t) v) << 16) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR31)
#else
#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR31(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR31)
#endif
/* --- Register HW_DIGCTL_OCRAM_STATUS11, field FAILADDR30 */

#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR30      0
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR30      0x0000FFFF

#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR30(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR30)


/*
 * HW_DIGCTL_OCRAM_STATUS12 - SRAM Status Register 12
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILSTATE00  :  7;
        unsigned RSVD0        :  1;
        unsigned FAILSTATE01  :  7;
        unsigned RSVD1        :  1;
        unsigned FAILSTATE10  :  7;
        unsigned RSVD2        :  1;
        unsigned FAILSTATE11  :  7;
        unsigned RSVD3        :  1;
    } B;
} hw_digctl_ocram_status12_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS12 register
 */
#define HW_DIGCTL_OCRAM_STATUS12_ADDR         (REGS_DIGCTL_BASE + 0x1d0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS12           (*(volatile hw_digctl_ocram_status12_t *) HW_DIGCTL_OCRAM_STATUS12_ADDR)
#define HW_DIGCTL_OCRAM_STATUS12_RD()      (HW_DIGCTL_OCRAM_STATUS12.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS12 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS12, field RSVD3 */

#define BP_DIGCTL_OCRAM_STATUS12_RSVD3      31
#define BM_DIGCTL_OCRAM_STATUS12_RSVD3      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS12_RSVD3(v)   ((((reg32_t) v) << 31) & BM_DIGCTL_OCRAM_STATUS12_RSVD3)
#else
#define BF_DIGCTL_OCRAM_STATUS12_RSVD3(v)   (((v) << 31) & BM_DIGCTL_OCRAM_STATUS12_RSVD3)
#endif
/* --- Register HW_DIGCTL_OCRAM_STATUS12, field FAILSTATE11 */

#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE11      24
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11      0x7F000000

#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE11(v)   (((v) << 24) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11)
/* --- Register HW_DIGCTL_OCRAM_STATUS12, field RSVD2 */

#define BP_DIGCTL_OCRAM_STATUS12_RSVD2      23
#define BM_DIGCTL_OCRAM_STATUS12_RSVD2      0x00800000

#define BF_DIGCTL_OCRAM_STATUS12_RSVD2(v)   (((v) << 23) & BM_DIGCTL_OCRAM_STATUS12_RSVD2)
/* --- Register HW_DIGCTL_OCRAM_STATUS12, field FAILSTATE10 */

#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE10      16
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10      0x007F0000

#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE10(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10)
/* --- Register HW_DIGCTL_OCRAM_STATUS12, field RSVD1 */

#define BP_DIGCTL_OCRAM_STATUS12_RSVD1      15
#define BM_DIGCTL_OCRAM_STATUS12_RSVD1      0x00008000

#define BF_DIGCTL_OCRAM_STATUS12_RSVD1(v)   (((v) << 15) & BM_DIGCTL_OCRAM_STATUS12_RSVD1)
/* --- Register HW_DIGCTL_OCRAM_STATUS12, field FAILSTATE01 */

#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE01      8
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01      0x00007F00

#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE01(v)   (((v) << 8) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01)
/* --- Register HW_DIGCTL_OCRAM_STATUS12, field RSVD0 */

#define BP_DIGCTL_OCRAM_STATUS12_RSVD0      7
#define BM_DIGCTL_OCRAM_STATUS12_RSVD0      0x00000080

#define BF_DIGCTL_OCRAM_STATUS12_RSVD0(v)   (((v) << 7) & BM_DIGCTL_OCRAM_STATUS12_RSVD0)
/* --- Register HW_DIGCTL_OCRAM_STATUS12, field FAILSTATE00 */

#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE00      0
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00      0x0000007F

#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE00(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00)


/*
 * HW_DIGCTL_OCRAM_STATUS13 - SRAM Status Register 13
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FAILSTATE20  :  7;
        unsigned RSVD0        :  1;
        unsigned FAILSTATE21  :  7;
        unsigned RSVD1        :  1;
        unsigned FAILSTATE30  :  7;
        unsigned RSVD2        :  1;
        unsigned FAILSTATE31  :  7;
        unsigned RSVD3        :  1;
    } B;
} hw_digctl_ocram_status13_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_OCRAM_STATUS13 register
 */
#define HW_DIGCTL_OCRAM_STATUS13_ADDR         (REGS_DIGCTL_BASE + 0x1e0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_OCRAM_STATUS13           (*(volatile hw_digctl_ocram_status13_t *) HW_DIGCTL_OCRAM_STATUS13_ADDR)
#define HW_DIGCTL_OCRAM_STATUS13_RD()      (HW_DIGCTL_OCRAM_STATUS13.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_OCRAM_STATUS13 bitfields
 */
/* --- Register HW_DIGCTL_OCRAM_STATUS13, field RSVD3 */

#define BP_DIGCTL_OCRAM_STATUS13_RSVD3      31
#define BM_DIGCTL_OCRAM_STATUS13_RSVD3      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_OCRAM_STATUS13_RSVD3(v)   ((((reg32_t) v) << 31) & BM_DIGCTL_OCRAM_STATUS13_RSVD3)
#else
#define BF_DIGCTL_OCRAM_STATUS13_RSVD3(v)   (((v) << 31) & BM_DIGCTL_OCRAM_STATUS13_RSVD3)
#endif
/* --- Register HW_DIGCTL_OCRAM_STATUS13, field FAILSTATE31 */

#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE31      24
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31      0x7F000000

#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE31(v)   (((v) << 24) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31)
/* --- Register HW_DIGCTL_OCRAM_STATUS13, field RSVD2 */

#define BP_DIGCTL_OCRAM_STATUS13_RSVD2      23
#define BM_DIGCTL_OCRAM_STATUS13_RSVD2      0x00800000

#define BF_DIGCTL_OCRAM_STATUS13_RSVD2(v)   (((v) << 23) & BM_DIGCTL_OCRAM_STATUS13_RSVD2)
/* --- Register HW_DIGCTL_OCRAM_STATUS13, field FAILSTATE30 */

#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE30      16
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30      0x007F0000

#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE30(v)   (((v) << 16) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30)
/* --- Register HW_DIGCTL_OCRAM_STATUS13, field RSVD1 */

#define BP_DIGCTL_OCRAM_STATUS13_RSVD1      15
#define BM_DIGCTL_OCRAM_STATUS13_RSVD1      0x00008000

#define BF_DIGCTL_OCRAM_STATUS13_RSVD1(v)   (((v) << 15) & BM_DIGCTL_OCRAM_STATUS13_RSVD1)
/* --- Register HW_DIGCTL_OCRAM_STATUS13, field FAILSTATE21 */

#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE21      8
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21      0x00007F00

#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE21(v)   (((v) << 8) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21)
/* --- Register HW_DIGCTL_OCRAM_STATUS13, field RSVD0 */

#define BP_DIGCTL_OCRAM_STATUS13_RSVD0      7
#define BM_DIGCTL_OCRAM_STATUS13_RSVD0      0x00000080

#define BF_DIGCTL_OCRAM_STATUS13_RSVD0(v)   (((v) << 7) & BM_DIGCTL_OCRAM_STATUS13_RSVD0)
/* --- Register HW_DIGCTL_OCRAM_STATUS13, field FAILSTATE20 */

#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE20      0
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20      0x0000007F

#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE20(v)   (((v) << 0) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20)


/*
 * HW_DIGCTL_SCRATCH0 - Digital Control Scratch Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PTR  : 32;
    } B;
} hw_digctl_scratch0_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_SCRATCH0 register
 */
#define HW_DIGCTL_SCRATCH0_ADDR         (REGS_DIGCTL_BASE + 0x280)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_SCRATCH0           (*(volatile hw_digctl_scratch0_t *) HW_DIGCTL_SCRATCH0_ADDR)
#define HW_DIGCTL_SCRATCH0_RD()      (HW_DIGCTL_SCRATCH0.U)
#define HW_DIGCTL_SCRATCH0_WR(v)     (HW_DIGCTL_SCRATCH0.U = (v))
#define HW_DIGCTL_SCRATCH0_SET(v)    (HW_DIGCTL_SCRATCH0_WR(HW_DIGCTL_SCRATCH0_RD() |  (v)))
#define HW_DIGCTL_SCRATCH0_CLR(v)    (HW_DIGCTL_SCRATCH0_WR(HW_DIGCTL_SCRATCH0_RD() & ~(v)))
#define HW_DIGCTL_SCRATCH0_TOG(v)    (HW_DIGCTL_SCRATCH0_WR(HW_DIGCTL_SCRATCH0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_SCRATCH0 bitfields
 */
/* --- Register HW_DIGCTL_SCRATCH0, field PTR */

#define BP_DIGCTL_SCRATCH0_PTR      0
#define BM_DIGCTL_SCRATCH0_PTR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_SCRATCH0_PTR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_SCRATCH0_PTR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_SCRATCH0_PTR(v)   (HW_DIGCTL_SCRATCH0.B.PTR = (v))
#endif



/*
 * HW_DIGCTL_SCRATCH1 - Digital Control Scratch Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PTR  : 32;
    } B;
} hw_digctl_scratch1_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_SCRATCH1 register
 */
#define HW_DIGCTL_SCRATCH1_ADDR         (REGS_DIGCTL_BASE + 0x290)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_SCRATCH1           (*(volatile hw_digctl_scratch1_t *) HW_DIGCTL_SCRATCH1_ADDR)
#define HW_DIGCTL_SCRATCH1_RD()      (HW_DIGCTL_SCRATCH1.U)
#define HW_DIGCTL_SCRATCH1_WR(v)     (HW_DIGCTL_SCRATCH1.U = (v))
#define HW_DIGCTL_SCRATCH1_SET(v)    (HW_DIGCTL_SCRATCH1_WR(HW_DIGCTL_SCRATCH1_RD() |  (v)))
#define HW_DIGCTL_SCRATCH1_CLR(v)    (HW_DIGCTL_SCRATCH1_WR(HW_DIGCTL_SCRATCH1_RD() & ~(v)))
#define HW_DIGCTL_SCRATCH1_TOG(v)    (HW_DIGCTL_SCRATCH1_WR(HW_DIGCTL_SCRATCH1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_SCRATCH1 bitfields
 */
/* --- Register HW_DIGCTL_SCRATCH1, field PTR */

#define BP_DIGCTL_SCRATCH1_PTR      0
#define BM_DIGCTL_SCRATCH1_PTR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_SCRATCH1_PTR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_SCRATCH1_PTR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_SCRATCH1_PTR(v)   (HW_DIGCTL_SCRATCH1.B.PTR = (v))
#endif



/*
 * HW_DIGCTL_ARMCACHE - Digital Control ARM Cache Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ITAG_SS   :  2;
        unsigned RSVD0     :  2;
        unsigned DTAG_SS   :  2;
        unsigned RSVD1     :  2;
        unsigned CACHE_SS  :  2;
        unsigned RSVD2     :  2;
        unsigned DRTY_SS   :  2;
        unsigned RSVD3     :  2;
        unsigned VALID_SS  :  2;
        unsigned RSVD4     : 14;
    } B;
} hw_digctl_armcache_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_ARMCACHE register
 */
#define HW_DIGCTL_ARMCACHE_ADDR         (REGS_DIGCTL_BASE + 0x2a0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_ARMCACHE           (*(volatile hw_digctl_armcache_t *) HW_DIGCTL_ARMCACHE_ADDR)
#define HW_DIGCTL_ARMCACHE_RD()      (HW_DIGCTL_ARMCACHE.U)
#define HW_DIGCTL_ARMCACHE_WR(v)     (HW_DIGCTL_ARMCACHE.U = (v))
#define HW_DIGCTL_ARMCACHE_SET(v)    (HW_DIGCTL_ARMCACHE_WR(HW_DIGCTL_ARMCACHE_RD() |  (v)))
#define HW_DIGCTL_ARMCACHE_CLR(v)    (HW_DIGCTL_ARMCACHE_WR(HW_DIGCTL_ARMCACHE_RD() & ~(v)))
#define HW_DIGCTL_ARMCACHE_TOG(v)    (HW_DIGCTL_ARMCACHE_WR(HW_DIGCTL_ARMCACHE_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_ARMCACHE bitfields
 */
/* --- Register HW_DIGCTL_ARMCACHE, field RSVD4 */

#define BP_DIGCTL_ARMCACHE_RSVD4      18
#define BM_DIGCTL_ARMCACHE_RSVD4      0xFFFC0000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_ARMCACHE_RSVD4(v)   ((((reg32_t) v) << 18) & BM_DIGCTL_ARMCACHE_RSVD4)
#else
#define BF_DIGCTL_ARMCACHE_RSVD4(v)   (((v) << 18) & BM_DIGCTL_ARMCACHE_RSVD4)
#endif
/* --- Register HW_DIGCTL_ARMCACHE, field VALID_SS */

#define BP_DIGCTL_ARMCACHE_VALID_SS      16
#define BM_DIGCTL_ARMCACHE_VALID_SS      0x00030000

#define BF_DIGCTL_ARMCACHE_VALID_SS(v)   (((v) << 16) & BM_DIGCTL_ARMCACHE_VALID_SS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_VALID_SS(v)   BF_CS1(DIGCTL_ARMCACHE, VALID_SS, v)
#endif

/* --- Register HW_DIGCTL_ARMCACHE, field RSVD3 */

#define BP_DIGCTL_ARMCACHE_RSVD3      14
#define BM_DIGCTL_ARMCACHE_RSVD3      0x0000C000

#define BF_DIGCTL_ARMCACHE_RSVD3(v)   (((v) << 14) & BM_DIGCTL_ARMCACHE_RSVD3)
/* --- Register HW_DIGCTL_ARMCACHE, field DRTY_SS */

#define BP_DIGCTL_ARMCACHE_DRTY_SS      12
#define BM_DIGCTL_ARMCACHE_DRTY_SS      0x00003000

#define BF_DIGCTL_ARMCACHE_DRTY_SS(v)   (((v) << 12) & BM_DIGCTL_ARMCACHE_DRTY_SS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_DRTY_SS(v)   BF_CS1(DIGCTL_ARMCACHE, DRTY_SS, v)
#endif

/* --- Register HW_DIGCTL_ARMCACHE, field RSVD2 */

#define BP_DIGCTL_ARMCACHE_RSVD2      10
#define BM_DIGCTL_ARMCACHE_RSVD2      0x00000C00

#define BF_DIGCTL_ARMCACHE_RSVD2(v)   (((v) << 10) & BM_DIGCTL_ARMCACHE_RSVD2)
/* --- Register HW_DIGCTL_ARMCACHE, field CACHE_SS */

#define BP_DIGCTL_ARMCACHE_CACHE_SS      8
#define BM_DIGCTL_ARMCACHE_CACHE_SS      0x00000300

#define BF_DIGCTL_ARMCACHE_CACHE_SS(v)   (((v) << 8) & BM_DIGCTL_ARMCACHE_CACHE_SS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_CACHE_SS(v)   BF_CS1(DIGCTL_ARMCACHE, CACHE_SS, v)
#endif

/* --- Register HW_DIGCTL_ARMCACHE, field RSVD1 */

#define BP_DIGCTL_ARMCACHE_RSVD1      6
#define BM_DIGCTL_ARMCACHE_RSVD1      0x000000C0

#define BF_DIGCTL_ARMCACHE_RSVD1(v)   (((v) << 6) & BM_DIGCTL_ARMCACHE_RSVD1)
/* --- Register HW_DIGCTL_ARMCACHE, field DTAG_SS */

#define BP_DIGCTL_ARMCACHE_DTAG_SS      4
#define BM_DIGCTL_ARMCACHE_DTAG_SS      0x00000030

#define BF_DIGCTL_ARMCACHE_DTAG_SS(v)   (((v) << 4) & BM_DIGCTL_ARMCACHE_DTAG_SS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_DTAG_SS(v)   BF_CS1(DIGCTL_ARMCACHE, DTAG_SS, v)
#endif

/* --- Register HW_DIGCTL_ARMCACHE, field RSVD0 */

#define BP_DIGCTL_ARMCACHE_RSVD0      2
#define BM_DIGCTL_ARMCACHE_RSVD0      0x0000000C

#define BF_DIGCTL_ARMCACHE_RSVD0(v)   (((v) << 2) & BM_DIGCTL_ARMCACHE_RSVD0)
/* --- Register HW_DIGCTL_ARMCACHE, field ITAG_SS */

#define BP_DIGCTL_ARMCACHE_ITAG_SS      0
#define BM_DIGCTL_ARMCACHE_ITAG_SS      0x00000003

#define BF_DIGCTL_ARMCACHE_ITAG_SS(v)   (((v) << 0) & BM_DIGCTL_ARMCACHE_ITAG_SS)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_ARMCACHE_ITAG_SS(v)   BF_CS1(DIGCTL_ARMCACHE, ITAG_SS, v)
#endif



/*
 * HW_DIGCTL_DEBUG_TRAP - Debug Trap Control and Status for AHB Layer 0 and 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRAP_ENABLE        :  1;
        unsigned TRAP_IN_RANGE      :  1;
        unsigned TRAP_L0_IRQ        :  1;
        unsigned TRAP_L3_IRQ        :  1;
        unsigned TRAP_L3_MASTER_ID  :  3;
        unsigned RSVD0              :  1;
        unsigned TRAP_L0_MASTER_ID  :  2;
        unsigned RSVD1              :  2;
        unsigned RSVD2              : 20;
    } B;
} hw_digctl_debug_trap_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_DEBUG_TRAP register
 */
#define HW_DIGCTL_DEBUG_TRAP_ADDR         (REGS_DIGCTL_BASE + 0x2b0)
#define HW_DIGCTL_DEBUG_TRAP_SET_ADDR     (HW_DIGCTL_DEBUG_TRAP_ADDR + 4)
#define HW_DIGCTL_DEBUG_TRAP_CLR_ADDR     (HW_DIGCTL_DEBUG_TRAP_ADDR + 8)
#define HW_DIGCTL_DEBUG_TRAP_TOG_ADDR     (HW_DIGCTL_DEBUG_TRAP_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DEBUG_TRAP           (*(volatile hw_digctl_debug_trap_t *) HW_DIGCTL_DEBUG_TRAP_ADDR)
#define HW_DIGCTL_DEBUG_TRAP_RD()      (HW_DIGCTL_DEBUG_TRAP.U)
#define HW_DIGCTL_DEBUG_TRAP_WR(v)     (HW_DIGCTL_DEBUG_TRAP.U = (v))
#define HW_DIGCTL_DEBUG_TRAP_SET(v)    ((*(volatile reg32_t *) HW_DIGCTL_DEBUG_TRAP_SET_ADDR) = (v))
#define HW_DIGCTL_DEBUG_TRAP_CLR(v)    ((*(volatile reg32_t *) HW_DIGCTL_DEBUG_TRAP_CLR_ADDR) = (v))
#define HW_DIGCTL_DEBUG_TRAP_TOG(v)    ((*(volatile reg32_t *) HW_DIGCTL_DEBUG_TRAP_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_DIGCTL_DEBUG_TRAP bitfields
 */
/* --- Register HW_DIGCTL_DEBUG_TRAP, field RSVD2 */

#define BP_DIGCTL_DEBUG_TRAP_RSVD2      12
#define BM_DIGCTL_DEBUG_TRAP_RSVD2      0xFFFFF000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DEBUG_TRAP_RSVD2(v)   ((((reg32_t) v) << 12) & BM_DIGCTL_DEBUG_TRAP_RSVD2)
#else
#define BF_DIGCTL_DEBUG_TRAP_RSVD2(v)   (((v) << 12) & BM_DIGCTL_DEBUG_TRAP_RSVD2)
#endif
/* --- Register HW_DIGCTL_DEBUG_TRAP, field RSVD1 */

#define BP_DIGCTL_DEBUG_TRAP_RSVD1      10
#define BM_DIGCTL_DEBUG_TRAP_RSVD1      0x00000C00

#define BF_DIGCTL_DEBUG_TRAP_RSVD1(v)   (((v) << 10) & BM_DIGCTL_DEBUG_TRAP_RSVD1)
/* --- Register HW_DIGCTL_DEBUG_TRAP, field TRAP_L0_MASTER_ID */

#define BP_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID      8
#define BM_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID      0x00000300

#define BF_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID(v)   (((v) << 8) & BM_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID)
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID__PXP    0x0
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID__LCDIF  0x1
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID__BCH    0x2
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID__DCP    0x3

/* --- Register HW_DIGCTL_DEBUG_TRAP, field RSVD0 */

#define BP_DIGCTL_DEBUG_TRAP_RSVD0      7
#define BM_DIGCTL_DEBUG_TRAP_RSVD0      0x00000080

#define BF_DIGCTL_DEBUG_TRAP_RSVD0(v)   (((v) << 7) & BM_DIGCTL_DEBUG_TRAP_RSVD0)
/* --- Register HW_DIGCTL_DEBUG_TRAP, field TRAP_L3_MASTER_ID */

#define BP_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID      4
#define BM_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID      0x00000070

#define BF_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID(v)   (((v) << 4) & BM_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID)
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__APBH_BRIDE_DMA  0x0
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__APBX_BRIDE_DMA  0x1
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__USB0            0x2
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__USB1            0x3
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__ENET_M0         0x4
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__ENET_M1         0x5

/* --- Register HW_DIGCTL_DEBUG_TRAP, field TRAP_L3_IRQ */

#define BP_DIGCTL_DEBUG_TRAP_TRAP_L3_IRQ      3
#define BM_DIGCTL_DEBUG_TRAP_TRAP_L3_IRQ      0x00000008

#define BF_DIGCTL_DEBUG_TRAP_TRAP_L3_IRQ(v)   (((v) << 3) & BM_DIGCTL_DEBUG_TRAP_TRAP_L3_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_TRAP_L3_IRQ(v)   BF_CS1(DIGCTL_DEBUG_TRAP, TRAP_L3_IRQ, v)
#endif

/* --- Register HW_DIGCTL_DEBUG_TRAP, field TRAP_L0_IRQ */

#define BP_DIGCTL_DEBUG_TRAP_TRAP_L0_IRQ      2
#define BM_DIGCTL_DEBUG_TRAP_TRAP_L0_IRQ      0x00000004

#define BF_DIGCTL_DEBUG_TRAP_TRAP_L0_IRQ(v)   (((v) << 2) & BM_DIGCTL_DEBUG_TRAP_TRAP_L0_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_TRAP_L0_IRQ(v)   BF_CS1(DIGCTL_DEBUG_TRAP, TRAP_L0_IRQ, v)
#endif

/* --- Register HW_DIGCTL_DEBUG_TRAP, field TRAP_IN_RANGE */

#define BP_DIGCTL_DEBUG_TRAP_TRAP_IN_RANGE      1
#define BM_DIGCTL_DEBUG_TRAP_TRAP_IN_RANGE      0x00000002

#define BF_DIGCTL_DEBUG_TRAP_TRAP_IN_RANGE(v)   (((v) << 1) & BM_DIGCTL_DEBUG_TRAP_TRAP_IN_RANGE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_TRAP_IN_RANGE(v)   BF_CS1(DIGCTL_DEBUG_TRAP, TRAP_IN_RANGE, v)
#endif

/* --- Register HW_DIGCTL_DEBUG_TRAP, field TRAP_ENABLE */

#define BP_DIGCTL_DEBUG_TRAP_TRAP_ENABLE      0
#define BM_DIGCTL_DEBUG_TRAP_TRAP_ENABLE      0x00000001

#define BF_DIGCTL_DEBUG_TRAP_TRAP_ENABLE(v)   (((v) << 0) & BM_DIGCTL_DEBUG_TRAP_TRAP_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_TRAP_ENABLE(v)   BF_CS1(DIGCTL_DEBUG_TRAP, TRAP_ENABLE, v)
#endif



/*
 * HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW - Debug Trap Range Low Address for AHB Layer 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_digctl_debug_trap_l0_addr_low_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW register
 */
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR         (REGS_DIGCTL_BASE + 0x2c0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW           (*(volatile hw_digctl_debug_trap_l0_addr_low_t *) HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR)
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_RD()      (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW.U)
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_WR(v)     (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW.U = (v))
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_SET(v)    (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_WR(HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_RD() |  (v)))
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_CLR(v)    (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_WR(HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_RD() & ~(v)))
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_TOG(v)    (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_WR(HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW bitfields
 */
/* --- Register HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW, field ADDR */

#define BP_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR      0
#define BM_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR(v)   (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW.B.ADDR = (v))
#endif



/*
 * HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH - Debug Trap Range High Address for AHB Layer 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_digctl_debug_trap_l0_addr_high_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH register
 */
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR         (REGS_DIGCTL_BASE + 0x2d0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH           (*(volatile hw_digctl_debug_trap_l0_addr_high_t *) HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR)
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_RD()      (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH.U)
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_WR(v)     (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH.U = (v))
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_SET(v)    (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_WR(HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_RD() |  (v)))
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_CLR(v)    (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_WR(HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_RD() & ~(v)))
#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_TOG(v)    (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_WR(HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH bitfields
 */
/* --- Register HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH, field ADDR */

#define BP_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR      0
#define BM_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR(v)   (HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH.B.ADDR = (v))
#endif



/*
 * HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW - Debug Trap Range Low Address for AHB Layer 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_digctl_debug_trap_l3_addr_low_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW register
 */
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR         (REGS_DIGCTL_BASE + 0x2e0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW           (*(volatile hw_digctl_debug_trap_l3_addr_low_t *) HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR)
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_RD()      (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW.U)
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_WR(v)     (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW.U = (v))
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_SET(v)    (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_WR(HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_RD() |  (v)))
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_CLR(v)    (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_WR(HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_RD() & ~(v)))
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_TOG(v)    (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_WR(HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW bitfields
 */
/* --- Register HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW, field ADDR */

#define BP_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR      0
#define BM_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR(v)   (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW.B.ADDR = (v))
#endif



/*
 * HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH - Debug Trap Range High Address for AHB Layer 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_digctl_debug_trap_l3_addr_high_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH register
 */
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR         (REGS_DIGCTL_BASE + 0x2f0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH           (*(volatile hw_digctl_debug_trap_l3_addr_high_t *) HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR)
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_RD()      (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH.U)
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_WR(v)     (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH.U = (v))
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_SET(v)    (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_WR(HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_RD() |  (v)))
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_CLR(v)    (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_WR(HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_RD() & ~(v)))
#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_TOG(v)    (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_WR(HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH bitfields
 */
/* --- Register HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH, field ADDR */

#define BP_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR      0
#define BM_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR(v)   (HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH.B.ADDR = (v))
#endif



/*
 * HW_DIGCTL_FSL - Freescale Copyright Identifier Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COPYRIGHT  : 32;
    } B;
} hw_digctl_fsl_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_FSL register
 */
#define HW_DIGCTL_FSL_ADDR         (REGS_DIGCTL_BASE + 0x300)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_FSL           (*(volatile hw_digctl_fsl_t *) HW_DIGCTL_FSL_ADDR)
#define HW_DIGCTL_FSL_RD()      (HW_DIGCTL_FSL.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_FSL bitfields
 */
/* --- Register HW_DIGCTL_FSL, field COPYRIGHT */

#define BP_DIGCTL_FSL_COPYRIGHT      0
#define BM_DIGCTL_FSL_COPYRIGHT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_FSL_COPYRIGHT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_FSL_COPYRIGHT(v)   (v)
#endif


/*
 * HW_DIGCTL_CHIPID - Digital Control Chip Revision Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned REVISION      :  8;
        unsigned RSVD0         :  8;
        unsigned PRODUCT_CODE  : 16;
    } B;
} hw_digctl_chipid_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_CHIPID register
 */
#define HW_DIGCTL_CHIPID_ADDR         (REGS_DIGCTL_BASE + 0x310)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_CHIPID           (*(volatile hw_digctl_chipid_t *) HW_DIGCTL_CHIPID_ADDR)
#define HW_DIGCTL_CHIPID_RD()      (HW_DIGCTL_CHIPID.U)
#endif


/*
 * constants & macros for individual HW_DIGCTL_CHIPID bitfields
 */
/* --- Register HW_DIGCTL_CHIPID, field PRODUCT_CODE */

#define BP_DIGCTL_CHIPID_PRODUCT_CODE      16
#define BM_DIGCTL_CHIPID_PRODUCT_CODE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_CHIPID_PRODUCT_CODE(v)   ((((reg32_t) v) << 16) & BM_DIGCTL_CHIPID_PRODUCT_CODE)
#else
#define BF_DIGCTL_CHIPID_PRODUCT_CODE(v)   (((v) << 16) & BM_DIGCTL_CHIPID_PRODUCT_CODE)
#endif
/* --- Register HW_DIGCTL_CHIPID, field RSVD0 */

#define BP_DIGCTL_CHIPID_RSVD0      8
#define BM_DIGCTL_CHIPID_RSVD0      0x0000FF00

#define BF_DIGCTL_CHIPID_RSVD0(v)   (((v) << 8) & BM_DIGCTL_CHIPID_RSVD0)
/* --- Register HW_DIGCTL_CHIPID, field REVISION */

#define BP_DIGCTL_CHIPID_REVISION      0
#define BM_DIGCTL_CHIPID_REVISION      0x000000FF

#define BF_DIGCTL_CHIPID_REVISION(v)   (((v) << 0) & BM_DIGCTL_CHIPID_REVISION)


/*
 * HW_DIGCTL_AHB_STATS_SELECT - AHB Statistics Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned L1_MASTER_SELECT  :  8;
        unsigned L2_MASTER_SELECT  :  8;
        unsigned L3_MASTER_SELECT  :  8;
        unsigned RSVD0             :  8;
    } B;
} hw_digctl_ahb_stats_select_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_AHB_STATS_SELECT register
 */
#define HW_DIGCTL_AHB_STATS_SELECT_ADDR         (REGS_DIGCTL_BASE + 0x330)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_AHB_STATS_SELECT           (*(volatile hw_digctl_ahb_stats_select_t *) HW_DIGCTL_AHB_STATS_SELECT_ADDR)
#define HW_DIGCTL_AHB_STATS_SELECT_RD()      (HW_DIGCTL_AHB_STATS_SELECT.U)
#define HW_DIGCTL_AHB_STATS_SELECT_WR(v)     (HW_DIGCTL_AHB_STATS_SELECT.U = (v))
#define HW_DIGCTL_AHB_STATS_SELECT_SET(v)    (HW_DIGCTL_AHB_STATS_SELECT_WR(HW_DIGCTL_AHB_STATS_SELECT_RD() |  (v)))
#define HW_DIGCTL_AHB_STATS_SELECT_CLR(v)    (HW_DIGCTL_AHB_STATS_SELECT_WR(HW_DIGCTL_AHB_STATS_SELECT_RD() & ~(v)))
#define HW_DIGCTL_AHB_STATS_SELECT_TOG(v)    (HW_DIGCTL_AHB_STATS_SELECT_WR(HW_DIGCTL_AHB_STATS_SELECT_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_AHB_STATS_SELECT bitfields
 */
/* --- Register HW_DIGCTL_AHB_STATS_SELECT, field RSVD0 */

#define BP_DIGCTL_AHB_STATS_SELECT_RSVD0      24
#define BM_DIGCTL_AHB_STATS_SELECT_RSVD0      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_AHB_STATS_SELECT_RSVD0(v)   ((((reg32_t) v) << 24) & BM_DIGCTL_AHB_STATS_SELECT_RSVD0)
#else
#define BF_DIGCTL_AHB_STATS_SELECT_RSVD0(v)   (((v) << 24) & BM_DIGCTL_AHB_STATS_SELECT_RSVD0)
#endif
/* --- Register HW_DIGCTL_AHB_STATS_SELECT, field L3_MASTER_SELECT */

#define BP_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT      16
#define BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT      0x00FF0000

#define BF_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT(v)   (((v) << 16) & BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT(v)   (HW_DIGCTL_AHB_STATS_SELECT.B.L3_MASTER_SELECT = (v))
#endif

#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBHDMA  0x1
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBXDMA  0x2
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__USB0     0x4
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__USB1     0x8
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__UDMA0    0x10
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__UDMA1    0x20

/* --- Register HW_DIGCTL_AHB_STATS_SELECT, field L2_MASTER_SELECT */

#define BP_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT      8
#define BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT      0x0000FF00

#define BF_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT(v)   (((v) << 8) & BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT(v)   (HW_DIGCTL_AHB_STATS_SELECT.B.L2_MASTER_SELECT = (v))
#endif

#define BV_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT__ARMD  0x1

/* --- Register HW_DIGCTL_AHB_STATS_SELECT, field L1_MASTER_SELECT */

#define BP_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT      0
#define BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT      0x000000FF

#define BF_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT(v)   (((v) << 0) & BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT(v)   (HW_DIGCTL_AHB_STATS_SELECT.B.L1_MASTER_SELECT = (v))
#endif

#define BV_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT__ARMI  0x1



/*
 * HW_DIGCTL_L1_AHB_ACTIVE_CYCLES - AHB Layer 1 Transfer Count Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_l1_ahb_active_cycles_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_L1_AHB_ACTIVE_CYCLES register
 */
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_ADDR         (REGS_DIGCTL_BASE + 0x370)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES           (*(volatile hw_digctl_l1_ahb_active_cycles_t *) HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_ADDR)
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_RD()      (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES.U)
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_WR(v)     (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES.U = (v))
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_SET(v)    (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_CLR(v)    (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_TOG(v)    (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_L1_AHB_ACTIVE_CYCLES bitfields
 */
/* --- Register HW_DIGCTL_L1_AHB_ACTIVE_CYCLES, field COUNT */

#define BP_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT(v)   (HW_DIGCTL_L1_AHB_ACTIVE_CYCLES.B.COUNT = (v))
#endif



/*
 * HW_DIGCTL_L1_AHB_DATA_STALLED - AHB Layer 1 Performance Metric for Stalled Bus Cycles Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_l1_ahb_data_stalled_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_L1_AHB_DATA_STALLED register
 */
#define HW_DIGCTL_L1_AHB_DATA_STALLED_ADDR         (REGS_DIGCTL_BASE + 0x380)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L1_AHB_DATA_STALLED           (*(volatile hw_digctl_l1_ahb_data_stalled_t *) HW_DIGCTL_L1_AHB_DATA_STALLED_ADDR)
#define HW_DIGCTL_L1_AHB_DATA_STALLED_RD()      (HW_DIGCTL_L1_AHB_DATA_STALLED.U)
#define HW_DIGCTL_L1_AHB_DATA_STALLED_WR(v)     (HW_DIGCTL_L1_AHB_DATA_STALLED.U = (v))
#define HW_DIGCTL_L1_AHB_DATA_STALLED_SET(v)    (HW_DIGCTL_L1_AHB_DATA_STALLED_WR(HW_DIGCTL_L1_AHB_DATA_STALLED_RD() |  (v)))
#define HW_DIGCTL_L1_AHB_DATA_STALLED_CLR(v)    (HW_DIGCTL_L1_AHB_DATA_STALLED_WR(HW_DIGCTL_L1_AHB_DATA_STALLED_RD() & ~(v)))
#define HW_DIGCTL_L1_AHB_DATA_STALLED_TOG(v)    (HW_DIGCTL_L1_AHB_DATA_STALLED_WR(HW_DIGCTL_L1_AHB_DATA_STALLED_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_L1_AHB_DATA_STALLED bitfields
 */
/* --- Register HW_DIGCTL_L1_AHB_DATA_STALLED, field COUNT */

#define BP_DIGCTL_L1_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L1_AHB_DATA_STALLED_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L1_AHB_DATA_STALLED_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L1_AHB_DATA_STALLED_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L1_AHB_DATA_STALLED_COUNT(v)   (HW_DIGCTL_L1_AHB_DATA_STALLED.B.COUNT = (v))
#endif



/*
 * HW_DIGCTL_L1_AHB_DATA_CYCLES - AHB Layer 1 Performance Metric for Valid Bus Cycles Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_l1_ahb_data_cycles_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_L1_AHB_DATA_CYCLES register
 */
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_ADDR         (REGS_DIGCTL_BASE + 0x390)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L1_AHB_DATA_CYCLES           (*(volatile hw_digctl_l1_ahb_data_cycles_t *) HW_DIGCTL_L1_AHB_DATA_CYCLES_ADDR)
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_RD()      (HW_DIGCTL_L1_AHB_DATA_CYCLES.U)
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_WR(v)     (HW_DIGCTL_L1_AHB_DATA_CYCLES.U = (v))
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_SET(v)    (HW_DIGCTL_L1_AHB_DATA_CYCLES_WR(HW_DIGCTL_L1_AHB_DATA_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_CLR(v)    (HW_DIGCTL_L1_AHB_DATA_CYCLES_WR(HW_DIGCTL_L1_AHB_DATA_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_TOG(v)    (HW_DIGCTL_L1_AHB_DATA_CYCLES_WR(HW_DIGCTL_L1_AHB_DATA_CYCLES_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_L1_AHB_DATA_CYCLES bitfields
 */
/* --- Register HW_DIGCTL_L1_AHB_DATA_CYCLES, field COUNT */

#define BP_DIGCTL_L1_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L1_AHB_DATA_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L1_AHB_DATA_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L1_AHB_DATA_CYCLES_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L1_AHB_DATA_CYCLES_COUNT(v)   (HW_DIGCTL_L1_AHB_DATA_CYCLES.B.COUNT = (v))
#endif



/*
 * HW_DIGCTL_L2_AHB_ACTIVE_CYCLES - AHB Layer 2 Transfer Count Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_l2_ahb_active_cycles_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_L2_AHB_ACTIVE_CYCLES register
 */
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_ADDR         (REGS_DIGCTL_BASE + 0x3a0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES           (*(volatile hw_digctl_l2_ahb_active_cycles_t *) HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_ADDR)
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_RD()      (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES.U)
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_WR(v)     (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES.U = (v))
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_SET(v)    (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_CLR(v)    (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_TOG(v)    (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_L2_AHB_ACTIVE_CYCLES bitfields
 */
/* --- Register HW_DIGCTL_L2_AHB_ACTIVE_CYCLES, field COUNT */

#define BP_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT(v)   (HW_DIGCTL_L2_AHB_ACTIVE_CYCLES.B.COUNT = (v))
#endif



/*
 * HW_DIGCTL_L2_AHB_DATA_STALLED - AHB Layer 2 Performance Metric for Stalled Bus Cycles Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_l2_ahb_data_stalled_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_L2_AHB_DATA_STALLED register
 */
#define HW_DIGCTL_L2_AHB_DATA_STALLED_ADDR         (REGS_DIGCTL_BASE + 0x3b0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L2_AHB_DATA_STALLED           (*(volatile hw_digctl_l2_ahb_data_stalled_t *) HW_DIGCTL_L2_AHB_DATA_STALLED_ADDR)
#define HW_DIGCTL_L2_AHB_DATA_STALLED_RD()      (HW_DIGCTL_L2_AHB_DATA_STALLED.U)
#define HW_DIGCTL_L2_AHB_DATA_STALLED_WR(v)     (HW_DIGCTL_L2_AHB_DATA_STALLED.U = (v))
#define HW_DIGCTL_L2_AHB_DATA_STALLED_SET(v)    (HW_DIGCTL_L2_AHB_DATA_STALLED_WR(HW_DIGCTL_L2_AHB_DATA_STALLED_RD() |  (v)))
#define HW_DIGCTL_L2_AHB_DATA_STALLED_CLR(v)    (HW_DIGCTL_L2_AHB_DATA_STALLED_WR(HW_DIGCTL_L2_AHB_DATA_STALLED_RD() & ~(v)))
#define HW_DIGCTL_L2_AHB_DATA_STALLED_TOG(v)    (HW_DIGCTL_L2_AHB_DATA_STALLED_WR(HW_DIGCTL_L2_AHB_DATA_STALLED_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_L2_AHB_DATA_STALLED bitfields
 */
/* --- Register HW_DIGCTL_L2_AHB_DATA_STALLED, field COUNT */

#define BP_DIGCTL_L2_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L2_AHB_DATA_STALLED_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L2_AHB_DATA_STALLED_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L2_AHB_DATA_STALLED_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L2_AHB_DATA_STALLED_COUNT(v)   (HW_DIGCTL_L2_AHB_DATA_STALLED.B.COUNT = (v))
#endif



/*
 * HW_DIGCTL_L2_AHB_DATA_CYCLES - AHB Layer 2 Performance Metric for Valid Bus Cycles Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_l2_ahb_data_cycles_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_L2_AHB_DATA_CYCLES register
 */
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_ADDR         (REGS_DIGCTL_BASE + 0x3c0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L2_AHB_DATA_CYCLES           (*(volatile hw_digctl_l2_ahb_data_cycles_t *) HW_DIGCTL_L2_AHB_DATA_CYCLES_ADDR)
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_RD()      (HW_DIGCTL_L2_AHB_DATA_CYCLES.U)
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_WR(v)     (HW_DIGCTL_L2_AHB_DATA_CYCLES.U = (v))
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_SET(v)    (HW_DIGCTL_L2_AHB_DATA_CYCLES_WR(HW_DIGCTL_L2_AHB_DATA_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_CLR(v)    (HW_DIGCTL_L2_AHB_DATA_CYCLES_WR(HW_DIGCTL_L2_AHB_DATA_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_TOG(v)    (HW_DIGCTL_L2_AHB_DATA_CYCLES_WR(HW_DIGCTL_L2_AHB_DATA_CYCLES_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_L2_AHB_DATA_CYCLES bitfields
 */
/* --- Register HW_DIGCTL_L2_AHB_DATA_CYCLES, field COUNT */

#define BP_DIGCTL_L2_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L2_AHB_DATA_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L2_AHB_DATA_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L2_AHB_DATA_CYCLES_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L2_AHB_DATA_CYCLES_COUNT(v)   (HW_DIGCTL_L2_AHB_DATA_CYCLES.B.COUNT = (v))
#endif



/*
 * HW_DIGCTL_L3_AHB_ACTIVE_CYCLES - AHB Layer 3 Transfer Count Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_l3_ahb_active_cycles_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_L3_AHB_ACTIVE_CYCLES register
 */
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_ADDR         (REGS_DIGCTL_BASE + 0x3d0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES           (*(volatile hw_digctl_l3_ahb_active_cycles_t *) HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_ADDR)
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_RD()      (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES.U)
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_WR(v)     (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES.U = (v))
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_SET(v)    (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_CLR(v)    (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_TOG(v)    (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_WR(HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_L3_AHB_ACTIVE_CYCLES bitfields
 */
/* --- Register HW_DIGCTL_L3_AHB_ACTIVE_CYCLES, field COUNT */

#define BP_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT(v)   (HW_DIGCTL_L3_AHB_ACTIVE_CYCLES.B.COUNT = (v))
#endif



/*
 * HW_DIGCTL_L3_AHB_DATA_STALLED - AHB Layer 3 Performance Metric for Stalled Bus Cycles Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_l3_ahb_data_stalled_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_L3_AHB_DATA_STALLED register
 */
#define HW_DIGCTL_L3_AHB_DATA_STALLED_ADDR         (REGS_DIGCTL_BASE + 0x3e0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L3_AHB_DATA_STALLED           (*(volatile hw_digctl_l3_ahb_data_stalled_t *) HW_DIGCTL_L3_AHB_DATA_STALLED_ADDR)
#define HW_DIGCTL_L3_AHB_DATA_STALLED_RD()      (HW_DIGCTL_L3_AHB_DATA_STALLED.U)
#define HW_DIGCTL_L3_AHB_DATA_STALLED_WR(v)     (HW_DIGCTL_L3_AHB_DATA_STALLED.U = (v))
#define HW_DIGCTL_L3_AHB_DATA_STALLED_SET(v)    (HW_DIGCTL_L3_AHB_DATA_STALLED_WR(HW_DIGCTL_L3_AHB_DATA_STALLED_RD() |  (v)))
#define HW_DIGCTL_L3_AHB_DATA_STALLED_CLR(v)    (HW_DIGCTL_L3_AHB_DATA_STALLED_WR(HW_DIGCTL_L3_AHB_DATA_STALLED_RD() & ~(v)))
#define HW_DIGCTL_L3_AHB_DATA_STALLED_TOG(v)    (HW_DIGCTL_L3_AHB_DATA_STALLED_WR(HW_DIGCTL_L3_AHB_DATA_STALLED_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_L3_AHB_DATA_STALLED bitfields
 */
/* --- Register HW_DIGCTL_L3_AHB_DATA_STALLED, field COUNT */

#define BP_DIGCTL_L3_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L3_AHB_DATA_STALLED_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L3_AHB_DATA_STALLED_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L3_AHB_DATA_STALLED_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L3_AHB_DATA_STALLED_COUNT(v)   (HW_DIGCTL_L3_AHB_DATA_STALLED.B.COUNT = (v))
#endif



/*
 * HW_DIGCTL_L3_AHB_DATA_CYCLES - AHB Layer 3 Performance Metric for Valid Bus Cycles Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COUNT  : 32;
    } B;
} hw_digctl_l3_ahb_data_cycles_t;
#endif

/*
 * constants & macros for entire HW_DIGCTL_L3_AHB_DATA_CYCLES register
 */
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_ADDR         (REGS_DIGCTL_BASE + 0x3f0)

#ifndef __LANGUAGE_ASM__
#define HW_DIGCTL_L3_AHB_DATA_CYCLES           (*(volatile hw_digctl_l3_ahb_data_cycles_t *) HW_DIGCTL_L3_AHB_DATA_CYCLES_ADDR)
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_RD()      (HW_DIGCTL_L3_AHB_DATA_CYCLES.U)
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_WR(v)     (HW_DIGCTL_L3_AHB_DATA_CYCLES.U = (v))
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_SET(v)    (HW_DIGCTL_L3_AHB_DATA_CYCLES_WR(HW_DIGCTL_L3_AHB_DATA_CYCLES_RD() |  (v)))
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_CLR(v)    (HW_DIGCTL_L3_AHB_DATA_CYCLES_WR(HW_DIGCTL_L3_AHB_DATA_CYCLES_RD() & ~(v)))
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_TOG(v)    (HW_DIGCTL_L3_AHB_DATA_CYCLES_WR(HW_DIGCTL_L3_AHB_DATA_CYCLES_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_DIGCTL_L3_AHB_DATA_CYCLES bitfields
 */
/* --- Register HW_DIGCTL_L3_AHB_DATA_CYCLES, field COUNT */

#define BP_DIGCTL_L3_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L3_AHB_DATA_CYCLES_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_L3_AHB_DATA_CYCLES_COUNT(v)   ((reg32_t) v)
#else
#define BF_DIGCTL_L3_AHB_DATA_CYCLES_COUNT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_L3_AHB_DATA_CYCLES_COUNT(v)   (HW_DIGCTL_L3_AHB_DATA_CYCLES.B.COUNT = (v))
#endif



/*
 *  multi-register-define name HW_DIGCTL_MPTEn_LOC
 *              base 0x00000500
 *              count 16
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOC    : 12;
        unsigned RSVD0  : 12;
        unsigned SPAN   :  3;
        unsigned RSVD1  :  4;
        unsigned DIS    :  1;
    } B;
} hw_digctl_mpten_loc_t;
#endif

    /*
     * constants & macros for entire HW_DIGCTL_MPTEn_LOC multi-register
     */
    #define HW_DIGCTL_MPTEn_LOC_COUNT        16
    #define HW_DIGCTL_MPTEn_LOC_ADDR(n)      (REGS_DIGCTL_BASE + 0x500 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_DIGCTL_MPTEn_LOC(n)           (*(volatile hw_digctl_mpten_loc_t *) HW_DIGCTL_MPTEn_LOC_ADDR(n))
    #define HW_DIGCTL_MPTEn_LOC_RD(n)        (HW_DIGCTL_MPTEn_LOC(n).U)
    #define HW_DIGCTL_MPTEn_LOC_WR(n, v)     (HW_DIGCTL_MPTEn_LOC(n).U = (v))
    #define HW_DIGCTL_MPTEn_LOC_SET(n, v)    (HW_DIGCTL_MPTEn_LOC_WR(n, HW_DIGCTL_MPTEn_LOC_RD(n) |  (v)))
    #define HW_DIGCTL_MPTEn_LOC_CLR(n, v)    (HW_DIGCTL_MPTEn_LOC_WR(n, HW_DIGCTL_MPTEn_LOC_RD(n) & ~(v)))
    #define HW_DIGCTL_MPTEn_LOC_TOG(n, v)    (HW_DIGCTL_MPTEn_LOC_WR(n, HW_DIGCTL_MPTEn_LOC_RD(n) ^  (v)))
    #endif


/*
 * constants & macros for individual HW_DIGCTL_MPTEn_LOC multi-register bitfields
 */
/* --- Register HW_DIGCTL_MPTEn_LOC, field DIS */

#define BP_DIGCTL_MPTEn_LOC_DIS      31
#define BM_DIGCTL_MPTEn_LOC_DIS      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DIGCTL_MPTEn_LOC_DIS(v)   ((((reg32_t) v) << 31) & BM_DIGCTL_MPTEn_LOC_DIS)
#else
#define BF_DIGCTL_MPTEn_LOC_DIS(v)   (((v) << 31) & BM_DIGCTL_MPTEn_LOC_DIS)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_MPTEn_LOC_DIS(n, v)  BF_CS1n(DIGCTL_MPTEn_LOC, n, DIS, v)
#endif

/* --- Register HW_DIGCTL_MPTEn_LOC, field RSVD1 */

#define BP_DIGCTL_MPTEn_LOC_RSVD1      27
#define BM_DIGCTL_MPTEn_LOC_RSVD1      0x78000000

#define BF_DIGCTL_MPTEn_LOC_RSVD1(v)   (((v) << 27) & BM_DIGCTL_MPTEn_LOC_RSVD1)
/* --- Register HW_DIGCTL_MPTEn_LOC, field SPAN */

#define BP_DIGCTL_MPTEn_LOC_SPAN      24
#define BM_DIGCTL_MPTEn_LOC_SPAN      0x07000000

#define BF_DIGCTL_MPTEn_LOC_SPAN(v)   (((v) << 24) & BM_DIGCTL_MPTEn_LOC_SPAN)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_MPTEn_LOC_SPAN(n, v)  BF_CS1n(DIGCTL_MPTEn_LOC, n, SPAN, v)
#endif

/* --- Register HW_DIGCTL_MPTEn_LOC, field RSVD0 */

#define BP_DIGCTL_MPTEn_LOC_RSVD0      12
#define BM_DIGCTL_MPTEn_LOC_RSVD0      0x00FFF000

#define BF_DIGCTL_MPTEn_LOC_RSVD0(v)   (((v) << 12) & BM_DIGCTL_MPTEn_LOC_RSVD0)
/* --- Register HW_DIGCTL_MPTEn_LOC, field LOC */

#define BP_DIGCTL_MPTEn_LOC_LOC      0
#define BM_DIGCTL_MPTEn_LOC_LOC      0x00000FFF

#define BF_DIGCTL_MPTEn_LOC_LOC(v)   (((v) << 0) & BM_DIGCTL_MPTEn_LOC_LOC)
#ifndef __LANGUAGE_ASM__
#define BW_DIGCTL_MPTEn_LOC_LOC(n, v)  BF_CS1n(DIGCTL_MPTEn_LOC, n, LOC, v)
#endif


#endif /* _DIGCTL_H */

////////////////////////////////////////////////////////////////////////////////
