/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 *
 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _UARTAPP_H
#define _UARTAPP_H  1

#include "regs.h"

//#ifndef REGS_UARTAPP_BASE
#define REGS_UARTAPP1_BASE (REGS_BASE + 0x6c000)
#define REGS_UARTAPP2_BASE (REGS_BASE + 0x6e000)
#define REGS_UARTAPP_BASE(x) ( x == 1 ? REGS_UARTAPP1_BASE : x == 2 ? REGS_UARTAPP2_BASE : 0xffff0000)
//#endif

/*
 * HW_UARTAPP_CTRL0 - UART Receive DMA Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XFER_COUNT   : 16;
        unsigned RXTIMEOUT    : 11;
        unsigned RXTO_ENABLE  :  1;
        unsigned RX_SOURCE    :  1;
        unsigned RUN          :  1;
        unsigned CLKGATE      :  1;
        unsigned SFTRST       :  1;
    } B;
} hw_uartapp_ctrl0_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_CTRL0 register
 */
#define HW_UARTAPP_CTRL0_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x0)
#define HW_UARTAPP_CTRL0_SET_ADDR(x)  (HW_UARTAPP_CTRL0_ADDR(x) + 4)
#define HW_UARTAPP_CTRL0_CLR_ADDR(x)  (HW_UARTAPP_CTRL0_ADDR(x) + 8)
#define HW_UARTAPP_CTRL0_TOG_ADDR(x)  (HW_UARTAPP_CTRL0_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_CTRL0(x)           (*(volatile hw_uartapp_ctrl0_t *) HW_UARTAPP_CTRL0_ADDR(x))
#define HW_UARTAPP_CTRL0_RD(x)      (HW_UARTAPP_CTRL0(x).U)
#define HW_UARTAPP_CTRL0_WR(x, v)     (HW_UARTAPP_CTRL0(x).U = (v))
#define HW_UARTAPP_CTRL0_SET(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_CTRL0_SET_ADDR(x)) = (v))
#define HW_UARTAPP_CTRL0_CLR(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_CTRL0_CLR_ADDR(x)) = (v))
#define HW_UARTAPP_CTRL0_TOG(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_CTRL0_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_UARTAPP_CTRL0 bitfields
 */
/* --- Register HW_UARTAPP_CTRL0, field SFTRST */

#define BP_UARTAPP_CTRL0_SFTRST      31
#define BM_UARTAPP_CTRL0_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_UARTAPP_CTRL0_SFTRST(v)   ((((reg32_t) v) << 31) & BM_UARTAPP_CTRL0_SFTRST)
#else
#define BF_UARTAPP_CTRL0_SFTRST(v)   (((v) << 31) & BM_UARTAPP_CTRL0_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL0_SFTRST(n, v)   BF_CS1(UARTAPP_CTRL0, n, SFTRST, v)
#endif

/* --- Register HW_UARTAPP_CTRL0, field CLKGATE */

#define BP_UARTAPP_CTRL0_CLKGATE      30
#define BM_UARTAPP_CTRL0_CLKGATE      0x40000000

#define BF_UARTAPP_CTRL0_CLKGATE(v)   (((v) << 30) & BM_UARTAPP_CTRL0_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL0_CLKGATE(n, v)   BF_CS1(UARTAPP_CTRL0, n, CLKGATE, v)
#endif

/* --- Register HW_UARTAPP_CTRL0, field RUN */

#define BP_UARTAPP_CTRL0_RUN      29
#define BM_UARTAPP_CTRL0_RUN      0x20000000

#define BF_UARTAPP_CTRL0_RUN(v)   (((v) << 29) & BM_UARTAPP_CTRL0_RUN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL0_RUN(n, v)   BF_CS1(UARTAPP_CTRL0, n, RUN, v)
#endif

/* --- Register HW_UARTAPP_CTRL0, field RX_SOURCE */

#define BP_UARTAPP_CTRL0_RX_SOURCE      28
#define BM_UARTAPP_CTRL0_RX_SOURCE      0x10000000

#define BF_UARTAPP_CTRL0_RX_SOURCE(v)   (((v) << 28) & BM_UARTAPP_CTRL0_RX_SOURCE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL0_RX_SOURCE(n, v)   BF_CS1(UARTAPP_CTRL0, n, RX_SOURCE, v)
#endif

/* --- Register HW_UARTAPP_CTRL0, field RXTO_ENABLE */

#define BP_UARTAPP_CTRL0_RXTO_ENABLE      27
#define BM_UARTAPP_CTRL0_RXTO_ENABLE      0x08000000

#define BF_UARTAPP_CTRL0_RXTO_ENABLE(v)   (((v) << 27) & BM_UARTAPP_CTRL0_RXTO_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL0_RXTO_ENABLE(n, v)   BF_CS1(UARTAPP_CTRL0, n, RXTO_ENABLE, v)
#endif

/* --- Register HW_UARTAPP_CTRL0, field RXTIMEOUT */

#define BP_UARTAPP_CTRL0_RXTIMEOUT      16
#define BM_UARTAPP_CTRL0_RXTIMEOUT      0x07FF0000

#define BF_UARTAPP_CTRL0_RXTIMEOUT(v)   (((v) << 16) & BM_UARTAPP_CTRL0_RXTIMEOUT)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL0_RXTIMEOUT(n, v)   BF_CS1(UARTAPP_CTRL0, n, RXTIMEOUT, v)
#endif

/* --- Register HW_UARTAPP_CTRL0, field XFER_COUNT */

#define BP_UARTAPP_CTRL0_XFER_COUNT      0
#define BM_UARTAPP_CTRL0_XFER_COUNT      0x0000FFFF

#define BF_UARTAPP_CTRL0_XFER_COUNT(v)   (((v) << 0) & BM_UARTAPP_CTRL0_XFER_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL0_XFER_COUNT(n, v)   (HW_UARTAPP_CTRL0(n).B.XFER_COUNT = (v))
#endif



/*
 * HW_UARTAPP_CTRL1 - UART Transmit DMA Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XFER_COUNT  : 16;
        unsigned RSVD1       : 12;
        unsigned RUN         :  1;
        unsigned RSVD2       :  3;
    } B;
} hw_uartapp_ctrl1_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_CTRL1 register
 */
#define HW_UARTAPP_CTRL1_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x10)
#define HW_UARTAPP_CTRL1_SET_ADDR(x)  (HW_UARTAPP_CTRL1_ADDR(x) + 4)
#define HW_UARTAPP_CTRL1_CLR_ADDR(x)  (HW_UARTAPP_CTRL1_ADDR(x) + 8)
#define HW_UARTAPP_CTRL1_TOG_ADDR(x)  (HW_UARTAPP_CTRL1_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_CTRL1(x)           (*(volatile hw_uartapp_ctrl1_t *) HW_UARTAPP_CTRL1_ADDR(x))
#define HW_UARTAPP_CTRL1_RD(x)      (HW_UARTAPP_CTRL1(x).U)
#define HW_UARTAPP_CTRL1_WR(x, v)     (HW_UARTAPP_CTRL1(x).U = (v))
#define HW_UARTAPP_CTRL1_SET(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_CTRL1_SET_ADDR(x)) = (v))
#define HW_UARTAPP_CTRL1_CLR(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_CTRL1_CLR_ADDR(x)) = (v))
#define HW_UARTAPP_CTRL1_TOG(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_CTRL1_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_UARTAPP_CTRL1 bitfields
 */
/* --- Register HW_UARTAPP_CTRL1, field RUN */

#define BP_UARTAPP_CTRL1_RUN      28
#define BM_UARTAPP_CTRL1_RUN      0x10000000

#define BF_UARTAPP_CTRL1_RUN(v)   (((v) << 28) & BM_UARTAPP_CTRL1_RUN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL1_RUN(n, v)   BF_CS1(UARTAPP_CTRL1, n, RUN, v)
#endif

/* --- Register HW_UARTAPP_CTRL1, field XFER_COUNT */

#define BP_UARTAPP_CTRL1_XFER_COUNT      0
#define BM_UARTAPP_CTRL1_XFER_COUNT      0x0000FFFF

#define BF_UARTAPP_CTRL1_XFER_COUNT(v)   (((v) << 0) & BM_UARTAPP_CTRL1_XFER_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL1_XFER_COUNT(n, v)   (HW_UARTAPP_CTRL1(n).B.XFER_COUNT = (v))
#endif



/*
 * HW_UARTAPP_CTRL2 - UART Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned UARTEN         :  1;
        unsigned SIREN          :  1;
        unsigned SIRLP          :  1;
        unsigned RSVD4          :  3;
        unsigned USE_LCR2       :  1;
        unsigned LBE            :  1;
        unsigned TXE            :  1;
        unsigned RXE            :  1;
        unsigned DTR            :  1;
        unsigned RTS            :  1;
        unsigned OUT1           :  1;
        unsigned OUT2           :  1;
        unsigned RTSEN          :  1;
        unsigned CTSEN          :  1;
        unsigned TXIFLSEL       :  3;
        unsigned RSVD3          :  1;
        unsigned RXIFLSEL       :  3;
        unsigned RSVD2          :  1;
        unsigned RXDMAE         :  1;
        unsigned TXDMAE         :  1;
        unsigned DMAONERR       :  1;
        unsigned RTS_SEMAPHORE  :  1;
        unsigned INVERT_RX      :  1;
        unsigned INVERT_TX      :  1;
        unsigned INVERT_CTS     :  1;
        unsigned INVERT_RTS     :  1;
    } B;
} hw_uartapp_ctrl2_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_CTRL2 register
 */
#define HW_UARTAPP_CTRL2_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x20)
#define HW_UARTAPP_CTRL2_SET_ADDR(x)  (HW_UARTAPP_CTRL2_ADDR(x) + 4)
#define HW_UARTAPP_CTRL2_CLR_ADDR(x)  (HW_UARTAPP_CTRL2_ADDR(x) + 8)
#define HW_UARTAPP_CTRL2_TOG_ADDR(x)  (HW_UARTAPP_CTRL2_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_CTRL2(x)           (*(volatile hw_uartapp_ctrl2_t *) HW_UARTAPP_CTRL2_ADDR(x))
#define HW_UARTAPP_CTRL2_RD(x)      (HW_UARTAPP_CTRL2(x).U)
#define HW_UARTAPP_CTRL2_WR(x, v)     (HW_UARTAPP_CTRL2(x).U = (v))
#define HW_UARTAPP_CTRL2_SET(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_CTRL2_SET_ADDR(x)) = (v))
#define HW_UARTAPP_CTRL2_CLR(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_CTRL2_CLR_ADDR(x)) = (v))
#define HW_UARTAPP_CTRL2_TOG(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_CTRL2_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_UARTAPP_CTRL2 bitfields
 */
/* --- Register HW_UARTAPP_CTRL2, field INVERT_RTS */

#define BP_UARTAPP_CTRL2_INVERT_RTS      31
#define BM_UARTAPP_CTRL2_INVERT_RTS      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_UARTAPP_CTRL2_INVERT_RTS(v)   ((((reg32_t) v) << 31) & BM_UARTAPP_CTRL2_INVERT_RTS)
#else
#define BF_UARTAPP_CTRL2_INVERT_RTS(v)   (((v) << 31) & BM_UARTAPP_CTRL2_INVERT_RTS)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_INVERT_RTS(n, v)   BF_CS1(UARTAPP_CTRL2, n, INVERT_RTS, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field INVERT_CTS */

#define BP_UARTAPP_CTRL2_INVERT_CTS      30
#define BM_UARTAPP_CTRL2_INVERT_CTS      0x40000000

#define BF_UARTAPP_CTRL2_INVERT_CTS(v)   (((v) << 30) & BM_UARTAPP_CTRL2_INVERT_CTS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_INVERT_CTS(n, v)   BF_CS1(UARTAPP_CTRL2, n, INVERT_CTS, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field INVERT_TX */

#define BP_UARTAPP_CTRL2_INVERT_TX      29
#define BM_UARTAPP_CTRL2_INVERT_TX      0x20000000

#define BF_UARTAPP_CTRL2_INVERT_TX(v)   (((v) << 29) & BM_UARTAPP_CTRL2_INVERT_TX)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_INVERT_TX(n, v)   BF_CS1(UARTAPP_CTRL2, n, INVERT_TX, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field INVERT_RX */

#define BP_UARTAPP_CTRL2_INVERT_RX      28
#define BM_UARTAPP_CTRL2_INVERT_RX      0x10000000

#define BF_UARTAPP_CTRL2_INVERT_RX(v)   (((v) << 28) & BM_UARTAPP_CTRL2_INVERT_RX)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_INVERT_RX(n, v)   BF_CS1(UARTAPP_CTRL2, n, INVERT_RX, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field RTS_SEMAPHORE */

#define BP_UARTAPP_CTRL2_RTS_SEMAPHORE      27
#define BM_UARTAPP_CTRL2_RTS_SEMAPHORE      0x08000000

#define BF_UARTAPP_CTRL2_RTS_SEMAPHORE(v)   (((v) << 27) & BM_UARTAPP_CTRL2_RTS_SEMAPHORE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_RTS_SEMAPHORE(n, v)   BF_CS1(UARTAPP_CTRL2, n, RTS_SEMAPHORE, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field DMAONERR */

#define BP_UARTAPP_CTRL2_DMAONERR      26
#define BM_UARTAPP_CTRL2_DMAONERR      0x04000000

#define BF_UARTAPP_CTRL2_DMAONERR(v)   (((v) << 26) & BM_UARTAPP_CTRL2_DMAONERR)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_DMAONERR(n, v)   BF_CS1(UARTAPP_CTRL2, n, DMAONERR, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field TXDMAE */

#define BP_UARTAPP_CTRL2_TXDMAE      25
#define BM_UARTAPP_CTRL2_TXDMAE      0x02000000

#define BF_UARTAPP_CTRL2_TXDMAE(v)   (((v) << 25) & BM_UARTAPP_CTRL2_TXDMAE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_TXDMAE(n, v)   BF_CS1(UARTAPP_CTRL2, n, TXDMAE, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field RXDMAE */

#define BP_UARTAPP_CTRL2_RXDMAE      24
#define BM_UARTAPP_CTRL2_RXDMAE      0x01000000

#define BF_UARTAPP_CTRL2_RXDMAE(v)   (((v) << 24) & BM_UARTAPP_CTRL2_RXDMAE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_RXDMAE(n, v)   BF_CS1(UARTAPP_CTRL2, n, RXDMAE, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field RXIFLSEL */

#define BP_UARTAPP_CTRL2_RXIFLSEL      20
#define BM_UARTAPP_CTRL2_RXIFLSEL      0x00700000

#define BF_UARTAPP_CTRL2_RXIFLSEL(v)   (((v) << 20) & BM_UARTAPP_CTRL2_RXIFLSEL)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_RXIFLSEL(n, v)   BF_CS1(UARTAPP_CTRL2, n, RXIFLSEL, v)
#endif

#define BV_UARTAPP_CTRL2_RXIFLSEL__NOT_EMPTY       0x0
#define BV_UARTAPP_CTRL2_RXIFLSEL__ONE_QUARTER     0x1
#define BV_UARTAPP_CTRL2_RXIFLSEL__ONE_HALF        0x2
#define BV_UARTAPP_CTRL2_RXIFLSEL__THREE_QUARTERS  0x3
#define BV_UARTAPP_CTRL2_RXIFLSEL__SEVEN_EIGHTHS   0x4
#define BV_UARTAPP_CTRL2_RXIFLSEL__INVALID5        0x5
#define BV_UARTAPP_CTRL2_RXIFLSEL__INVALID6        0x6
#define BV_UARTAPP_CTRL2_RXIFLSEL__INVALID7        0x7

/* --- Register HW_UARTAPP_CTRL2, field TXIFLSEL */

#define BP_UARTAPP_CTRL2_TXIFLSEL      16
#define BM_UARTAPP_CTRL2_TXIFLSEL      0x00070000

#define BF_UARTAPP_CTRL2_TXIFLSEL(v)   (((v) << 16) & BM_UARTAPP_CTRL2_TXIFLSEL)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_TXIFLSEL(n, v)   BF_CS1(UARTAPP_CTRL2, n, TXIFLSEL, v)
#endif

#define BV_UARTAPP_CTRL2_TXIFLSEL__EMPTY           0x0
#define BV_UARTAPP_CTRL2_TXIFLSEL__ONE_QUARTER     0x1
#define BV_UARTAPP_CTRL2_TXIFLSEL__ONE_HALF        0x2
#define BV_UARTAPP_CTRL2_TXIFLSEL__THREE_QUARTERS  0x3
#define BV_UARTAPP_CTRL2_TXIFLSEL__SEVEN_EIGHTHS   0x4
#define BV_UARTAPP_CTRL2_TXIFLSEL__INVALID5        0x5
#define BV_UARTAPP_CTRL2_TXIFLSEL__INVALID6        0x6
#define BV_UARTAPP_CTRL2_TXIFLSEL__INVALID7        0x7

/* --- Register HW_UARTAPP_CTRL2, field CTSEN */

#define BP_UARTAPP_CTRL2_CTSEN      15
#define BM_UARTAPP_CTRL2_CTSEN      0x00008000

#define BF_UARTAPP_CTRL2_CTSEN(v)   (((v) << 15) & BM_UARTAPP_CTRL2_CTSEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_CTSEN(n, v)   BF_CS1(UARTAPP_CTRL2, n, CTSEN, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field RTSEN */

#define BP_UARTAPP_CTRL2_RTSEN      14
#define BM_UARTAPP_CTRL2_RTSEN      0x00004000

#define BF_UARTAPP_CTRL2_RTSEN(v)   (((v) << 14) & BM_UARTAPP_CTRL2_RTSEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_RTSEN(n, v)   BF_CS1(UARTAPP_CTRL2, n, RTSEN, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field OUT2 */

#define BP_UARTAPP_CTRL2_OUT2      13
#define BM_UARTAPP_CTRL2_OUT2      0x00002000

#define BF_UARTAPP_CTRL2_OUT2(v)   (((v) << 13) & BM_UARTAPP_CTRL2_OUT2)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_OUT2(n, v)   BF_CS1(UARTAPP_CTRL2, n, OUT2, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field OUT1 */

#define BP_UARTAPP_CTRL2_OUT1      12
#define BM_UARTAPP_CTRL2_OUT1      0x00001000

#define BF_UARTAPP_CTRL2_OUT1(v)   (((v) << 12) & BM_UARTAPP_CTRL2_OUT1)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_OUT1(n, v)   BF_CS1(UARTAPP_CTRL2, n, OUT1, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field RTS */

#define BP_UARTAPP_CTRL2_RTS      11
#define BM_UARTAPP_CTRL2_RTS      0x00000800

#define BF_UARTAPP_CTRL2_RTS(v)   (((v) << 11) & BM_UARTAPP_CTRL2_RTS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_RTS(n, v)   BF_CS1(UARTAPP_CTRL2, n, RTS, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field DTR */

#define BP_UARTAPP_CTRL2_DTR      10
#define BM_UARTAPP_CTRL2_DTR      0x00000400

#define BF_UARTAPP_CTRL2_DTR(v)   (((v) << 10) & BM_UARTAPP_CTRL2_DTR)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_DTR(n, v)   BF_CS1(UARTAPP_CTRL2, n, DTR, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field RXE */

#define BP_UARTAPP_CTRL2_RXE      9
#define BM_UARTAPP_CTRL2_RXE      0x00000200

#define BF_UARTAPP_CTRL2_RXE(v)   (((v) << 9) & BM_UARTAPP_CTRL2_RXE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_RXE(n, v)   BF_CS1(UARTAPP_CTRL2, n, RXE, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field TXE */

#define BP_UARTAPP_CTRL2_TXE      8
#define BM_UARTAPP_CTRL2_TXE      0x00000100

#define BF_UARTAPP_CTRL2_TXE(v)   (((v) << 8) & BM_UARTAPP_CTRL2_TXE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_TXE(n, v)   BF_CS1(UARTAPP_CTRL2, n, TXE, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field LBE */

#define BP_UARTAPP_CTRL2_LBE      7
#define BM_UARTAPP_CTRL2_LBE      0x00000080

#define BF_UARTAPP_CTRL2_LBE(v)   (((v) << 7) & BM_UARTAPP_CTRL2_LBE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_LBE(n, v)   BF_CS1(UARTAPP_CTRL2, n, LBE, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field USE_LCR2 */

#define BP_UARTAPP_CTRL2_USE_LCR2      6
#define BM_UARTAPP_CTRL2_USE_LCR2      0x00000040

#define BF_UARTAPP_CTRL2_USE_LCR2(v)   (((v) << 6) & BM_UARTAPP_CTRL2_USE_LCR2)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_USE_LCR2(n, v)   BF_CS1(UARTAPP_CTRL2, n, USE_LCR2, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field SIRLP */

#define BP_UARTAPP_CTRL2_SIRLP      2
#define BM_UARTAPP_CTRL2_SIRLP      0x00000004

#define BF_UARTAPP_CTRL2_SIRLP(v)   (((v) << 2) & BM_UARTAPP_CTRL2_SIRLP)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_SIRLP(n, v)   BF_CS1(UARTAPP_CTRL2, n, SIRLP, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field SIREN */

#define BP_UARTAPP_CTRL2_SIREN      1
#define BM_UARTAPP_CTRL2_SIREN      0x00000002

#define BF_UARTAPP_CTRL2_SIREN(v)   (((v) << 1) & BM_UARTAPP_CTRL2_SIREN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_SIREN(n, v)   BF_CS1(UARTAPP_CTRL2, n, SIREN, v)
#endif

/* --- Register HW_UARTAPP_CTRL2, field UARTEN */

#define BP_UARTAPP_CTRL2_UARTEN      0
#define BM_UARTAPP_CTRL2_UARTEN      0x00000001

#define BF_UARTAPP_CTRL2_UARTEN(v)   (((v) << 0) & BM_UARTAPP_CTRL2_UARTEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_CTRL2_UARTEN(n, v)   BF_CS1(UARTAPP_CTRL2, n, UARTEN, v)
#endif



/*
 * HW_UARTAPP_LINECTRL - UART Line Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BRK           :  1;
        unsigned PEN           :  1;
        unsigned EPS           :  1;
        unsigned STP2          :  1;
        unsigned FEN           :  1;
        unsigned WLEN          :  2;
        unsigned SPS           :  1;
        unsigned BAUD_DIVFRAC  :  6;
        unsigned RSVD          :  2;
        unsigned BAUD_DIVINT   : 16;
    } B;
} hw_uartapp_linectrl_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_LINECTRL register
 */
#define HW_UARTAPP_LINECTRL_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x30)
#define HW_UARTAPP_LINECTRL_SET_ADDR(x)  (HW_UARTAPP_LINECTRL_ADDR(x) + 4)
#define HW_UARTAPP_LINECTRL_CLR_ADDR(x)  (HW_UARTAPP_LINECTRL_ADDR(x) + 8)
#define HW_UARTAPP_LINECTRL_TOG_ADDR(x)  (HW_UARTAPP_LINECTRL_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_LINECTRL(x)           (*(volatile hw_uartapp_linectrl_t *) HW_UARTAPP_LINECTRL_ADDR(x))
#define HW_UARTAPP_LINECTRL_RD(x)      (HW_UARTAPP_LINECTRL(x).U)
#define HW_UARTAPP_LINECTRL_WR(x, v)     (HW_UARTAPP_LINECTRL(x).U = (v))
#define HW_UARTAPP_LINECTRL_SET(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_LINECTRL_SET_ADDR(x)) = (v))
#define HW_UARTAPP_LINECTRL_CLR(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_LINECTRL_CLR_ADDR(x)) = (v))
#define HW_UARTAPP_LINECTRL_TOG(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_LINECTRL_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_UARTAPP_LINECTRL bitfields
 */
/* --- Register HW_UARTAPP_LINECTRL, field BAUD_DIVINT */

#define BP_UARTAPP_LINECTRL_BAUD_DIVINT      16
#define BM_UARTAPP_LINECTRL_BAUD_DIVINT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_UARTAPP_LINECTRL_BAUD_DIVINT(v)   ((((reg32_t) v) << 16) & BM_UARTAPP_LINECTRL_BAUD_DIVINT)
#else
#define BF_UARTAPP_LINECTRL_BAUD_DIVINT(v)   (((v) << 16) & BM_UARTAPP_LINECTRL_BAUD_DIVINT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL_BAUD_DIVINT(n, v)   (HW_UARTAPP_LINECTRL(n).B.BAUD_DIVINT = (v))
#endif

/* --- Register HW_UARTAPP_LINECTRL, field BAUD_DIVFRAC */

#define BP_UARTAPP_LINECTRL_BAUD_DIVFRAC      8
#define BM_UARTAPP_LINECTRL_BAUD_DIVFRAC      0x00003F00

#define BF_UARTAPP_LINECTRL_BAUD_DIVFRAC(v)   (((v) << 8) & BM_UARTAPP_LINECTRL_BAUD_DIVFRAC)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL_BAUD_DIVFRAC(n, v)   BF_CS1(UARTAPP_LINECTRL, n, BAUD_DIVFRAC, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL, field SPS */

#define BP_UARTAPP_LINECTRL_SPS      7
#define BM_UARTAPP_LINECTRL_SPS      0x00000080

#define BF_UARTAPP_LINECTRL_SPS(v)   (((v) << 7) & BM_UARTAPP_LINECTRL_SPS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL_SPS(n, v)   BF_CS1(UARTAPP_LINECTRL, n, SPS, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL, field WLEN */

#define BP_UARTAPP_LINECTRL_WLEN      5
#define BM_UARTAPP_LINECTRL_WLEN      0x00000060

#define BF_UARTAPP_LINECTRL_WLEN(v)   (((v) << 5) & BM_UARTAPP_LINECTRL_WLEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL_WLEN(n, v)   BF_CS1(UARTAPP_LINECTRL, n, WLEN, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL, field FEN */

#define BP_UARTAPP_LINECTRL_FEN      4
#define BM_UARTAPP_LINECTRL_FEN      0x00000010

#define BF_UARTAPP_LINECTRL_FEN(v)   (((v) << 4) & BM_UARTAPP_LINECTRL_FEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL_FEN(n, v)   BF_CS1(UARTAPP_LINECTRL, n, FEN, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL, field STP2 */

#define BP_UARTAPP_LINECTRL_STP2      3
#define BM_UARTAPP_LINECTRL_STP2      0x00000008

#define BF_UARTAPP_LINECTRL_STP2(v)   (((v) << 3) & BM_UARTAPP_LINECTRL_STP2)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL_STP2(n, v)   BF_CS1(UARTAPP_LINECTRL, n, STP2, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL, field EPS */

#define BP_UARTAPP_LINECTRL_EPS      2
#define BM_UARTAPP_LINECTRL_EPS      0x00000004

#define BF_UARTAPP_LINECTRL_EPS(v)   (((v) << 2) & BM_UARTAPP_LINECTRL_EPS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL_EPS(n, v)   BF_CS1(UARTAPP_LINECTRL, n, EPS, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL, field PEN */

#define BP_UARTAPP_LINECTRL_PEN      1
#define BM_UARTAPP_LINECTRL_PEN      0x00000002

#define BF_UARTAPP_LINECTRL_PEN(v)   (((v) << 1) & BM_UARTAPP_LINECTRL_PEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL_PEN(n, v)   BF_CS1(UARTAPP_LINECTRL, n, PEN, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL, field BRK */

#define BP_UARTAPP_LINECTRL_BRK      0
#define BM_UARTAPP_LINECTRL_BRK      0x00000001

#define BF_UARTAPP_LINECTRL_BRK(v)   (((v) << 0) & BM_UARTAPP_LINECTRL_BRK)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL_BRK(n, v)   BF_CS1(UARTAPP_LINECTRL, n, BRK, v)
#endif



/*
 * HW_UARTAPP_LINECTRL2 - UART Line Control 2 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD1         :  1;
        unsigned PEN           :  1;
        unsigned EPS           :  1;
        unsigned STP2          :  1;
        unsigned FEN           :  1;
        unsigned WLEN          :  2;
        unsigned SPS           :  1;
        unsigned BAUD_DIVFRAC  :  6;
        unsigned RSVD          :  2;
        unsigned BAUD_DIVINT   : 16;
    } B;
} hw_uartapp_linectrl2_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_LINECTRL2 register
 */
#define HW_UARTAPP_LINECTRL2_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x40)
#define HW_UARTAPP_LINECTRL2_SET_ADDR(x)  (HW_UARTAPP_LINECTRL2_ADDR(x) + 4)
#define HW_UARTAPP_LINECTRL2_CLR_ADDR(x)  (HW_UARTAPP_LINECTRL2_ADDR(x) + 8)
#define HW_UARTAPP_LINECTRL2_TOG_ADDR(x)  (HW_UARTAPP_LINECTRL2_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_LINECTRL2(x)           (*(volatile hw_uartapp_linectrl2_t *) HW_UARTAPP_LINECTRL2_ADDR(x))
#define HW_UARTAPP_LINECTRL2_RD(x)      (HW_UARTAPP_LINECTRL2(x).U)
#define HW_UARTAPP_LINECTRL2_WR(x, v)     (HW_UARTAPP_LINECTRL2(x).U = (v))
#define HW_UARTAPP_LINECTRL2_SET(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_LINECTRL2_SET_ADDR(x)) = (v))
#define HW_UARTAPP_LINECTRL2_CLR(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_LINECTRL2_CLR_ADDR(x)) = (v))
#define HW_UARTAPP_LINECTRL2_TOG(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_LINECTRL2_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_UARTAPP_LINECTRL2 bitfields
 */
/* --- Register HW_UARTAPP_LINECTRL2, field BAUD_DIVINT */

#define BP_UARTAPP_LINECTRL2_BAUD_DIVINT      16
#define BM_UARTAPP_LINECTRL2_BAUD_DIVINT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_UARTAPP_LINECTRL2_BAUD_DIVINT(v)   ((((reg32_t) v) << 16) & BM_UARTAPP_LINECTRL2_BAUD_DIVINT)
#else
#define BF_UARTAPP_LINECTRL2_BAUD_DIVINT(v)   (((v) << 16) & BM_UARTAPP_LINECTRL2_BAUD_DIVINT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL2_BAUD_DIVINT(n, v)   (HW_UARTAPP_LINECTRL2(n).B.BAUD_DIVINT = (v))
#endif

/* --- Register HW_UARTAPP_LINECTRL2, field BAUD_DIVFRAC */

#define BP_UARTAPP_LINECTRL2_BAUD_DIVFRAC      8
#define BM_UARTAPP_LINECTRL2_BAUD_DIVFRAC      0x00003F00

#define BF_UARTAPP_LINECTRL2_BAUD_DIVFRAC(v)   (((v) << 8) & BM_UARTAPP_LINECTRL2_BAUD_DIVFRAC)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL2_BAUD_DIVFRAC(n, v)   BF_CS1(UARTAPP_LINECTRL2, n, BAUD_DIVFRAC, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL2, field SPS */

#define BP_UARTAPP_LINECTRL2_SPS      7
#define BM_UARTAPP_LINECTRL2_SPS      0x00000080

#define BF_UARTAPP_LINECTRL2_SPS(v)   (((v) << 7) & BM_UARTAPP_LINECTRL2_SPS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL2_SPS(n, v)   BF_CS1(UARTAPP_LINECTRL2, n, SPS, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL2, field WLEN */

#define BP_UARTAPP_LINECTRL2_WLEN      5
#define BM_UARTAPP_LINECTRL2_WLEN      0x00000060

#define BF_UARTAPP_LINECTRL2_WLEN(v)   (((v) << 5) & BM_UARTAPP_LINECTRL2_WLEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL2_WLEN(n, v)   BF_CS1(UARTAPP_LINECTRL2, n, WLEN, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL2, field FEN */

#define BP_UARTAPP_LINECTRL2_FEN      4
#define BM_UARTAPP_LINECTRL2_FEN      0x00000010

#define BF_UARTAPP_LINECTRL2_FEN(v)   (((v) << 4) & BM_UARTAPP_LINECTRL2_FEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL2_FEN(n, v)   BF_CS1(UARTAPP_LINECTRL2, n, FEN, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL2, field STP2 */

#define BP_UARTAPP_LINECTRL2_STP2      3
#define BM_UARTAPP_LINECTRL2_STP2      0x00000008

#define BF_UARTAPP_LINECTRL2_STP2(v)   (((v) << 3) & BM_UARTAPP_LINECTRL2_STP2)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL2_STP2(n, v)   BF_CS1(UARTAPP_LINECTRL2, n, STP2, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL2, field EPS */

#define BP_UARTAPP_LINECTRL2_EPS      2
#define BM_UARTAPP_LINECTRL2_EPS      0x00000004

#define BF_UARTAPP_LINECTRL2_EPS(v)   (((v) << 2) & BM_UARTAPP_LINECTRL2_EPS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL2_EPS(n, v)   BF_CS1(UARTAPP_LINECTRL2, n, EPS, v)
#endif

/* --- Register HW_UARTAPP_LINECTRL2, field PEN */

#define BP_UARTAPP_LINECTRL2_PEN      1
#define BM_UARTAPP_LINECTRL2_PEN      0x00000002

#define BF_UARTAPP_LINECTRL2_PEN(v)   (((v) << 1) & BM_UARTAPP_LINECTRL2_PEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_LINECTRL2_PEN(n, v)   BF_CS1(UARTAPP_LINECTRL2, n, PEN, v)
#endif



/*
 * HW_UARTAPP_INTR - UART Interrupt Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RIMIS    :  1;
        unsigned CTSMIS   :  1;
        unsigned DCDMIS   :  1;
        unsigned DSRMIS   :  1;
        unsigned RXIS     :  1;
        unsigned TXIS     :  1;
        unsigned RTIS     :  1;
        unsigned FEIS     :  1;
        unsigned PEIS     :  1;
        unsigned BEIS     :  1;
        unsigned OEIS     :  1;
        unsigned RSVD2    :  5;
        unsigned RIMIEN   :  1;
        unsigned CTSMIEN  :  1;
        unsigned DCDMIEN  :  1;
        unsigned DSRMIEN  :  1;
        unsigned RXIEN    :  1;
        unsigned TXIEN    :  1;
        unsigned RTIEN    :  1;
        unsigned FEIEN    :  1;
        unsigned PEIEN    :  1;
        unsigned BEIEN    :  1;
        unsigned OEIEN    :  1;
        unsigned RSVD1    :  5;
    } B;
} hw_uartapp_intr_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_INTR register
 */
#define HW_UARTAPP_INTR_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x50)
#define HW_UARTAPP_INTR_SET_ADDR(x)  (HW_UARTAPP_INTR_ADDR(x) + 4)
#define HW_UARTAPP_INTR_CLR_ADDR(x)  (HW_UARTAPP_INTR_ADDR(x) + 8)
#define HW_UARTAPP_INTR_TOG_ADDR(x)  (HW_UARTAPP_INTR_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_INTR(x)           (*(volatile hw_uartapp_intr_t *) HW_UARTAPP_INTR_ADDR(x))
#define HW_UARTAPP_INTR_RD(x)      (HW_UARTAPP_INTR(x).U)
#define HW_UARTAPP_INTR_WR(x, v)     (HW_UARTAPP_INTR(x).U = (v))
#define HW_UARTAPP_INTR_SET(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_INTR_SET_ADDR(x)) = (v))
#define HW_UARTAPP_INTR_CLR(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_INTR_CLR_ADDR(x)) = (v))
#define HW_UARTAPP_INTR_TOG(x, v)    ((*(volatile reg32_t *) HW_UARTAPP_INTR_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_UARTAPP_INTR bitfields
 */
/* --- Register HW_UARTAPP_INTR, field OEIEN */

#define BP_UARTAPP_INTR_OEIEN      26
#define BM_UARTAPP_INTR_OEIEN      0x04000000

#define BF_UARTAPP_INTR_OEIEN(v)   (((v) << 26) & BM_UARTAPP_INTR_OEIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_OEIEN(n, v)   BF_CS1(UARTAPP_INTR, n, OEIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field BEIEN */

#define BP_UARTAPP_INTR_BEIEN      25
#define BM_UARTAPP_INTR_BEIEN      0x02000000

#define BF_UARTAPP_INTR_BEIEN(v)   (((v) << 25) & BM_UARTAPP_INTR_BEIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_BEIEN(n, v)   BF_CS1(UARTAPP_INTR, n, BEIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field PEIEN */

#define BP_UARTAPP_INTR_PEIEN      24
#define BM_UARTAPP_INTR_PEIEN      0x01000000

#define BF_UARTAPP_INTR_PEIEN(v)   (((v) << 24) & BM_UARTAPP_INTR_PEIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_PEIEN(n, v)   BF_CS1(UARTAPP_INTR, n, PEIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field FEIEN */

#define BP_UARTAPP_INTR_FEIEN      23
#define BM_UARTAPP_INTR_FEIEN      0x00800000

#define BF_UARTAPP_INTR_FEIEN(v)   (((v) << 23) & BM_UARTAPP_INTR_FEIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_FEIEN(n, v)   BF_CS1(UARTAPP_INTR, n, FEIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field RTIEN */

#define BP_UARTAPP_INTR_RTIEN      22
#define BM_UARTAPP_INTR_RTIEN      0x00400000

#define BF_UARTAPP_INTR_RTIEN(v)   (((v) << 22) & BM_UARTAPP_INTR_RTIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_RTIEN(n, v)   BF_CS1(UARTAPP_INTR, n, RTIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field TXIEN */

#define BP_UARTAPP_INTR_TXIEN      21
#define BM_UARTAPP_INTR_TXIEN      0x00200000

#define BF_UARTAPP_INTR_TXIEN(v)   (((v) << 21) & BM_UARTAPP_INTR_TXIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_TXIEN(n, v)   BF_CS1(UARTAPP_INTR, n, TXIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field RXIEN */

#define BP_UARTAPP_INTR_RXIEN      20
#define BM_UARTAPP_INTR_RXIEN      0x00100000

#define BF_UARTAPP_INTR_RXIEN(v)   (((v) << 20) & BM_UARTAPP_INTR_RXIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_RXIEN(n, v)   BF_CS1(UARTAPP_INTR, n, RXIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field DSRMIEN */

#define BP_UARTAPP_INTR_DSRMIEN      19
#define BM_UARTAPP_INTR_DSRMIEN      0x00080000

#define BF_UARTAPP_INTR_DSRMIEN(v)   (((v) << 19) & BM_UARTAPP_INTR_DSRMIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_DSRMIEN(n, v)   BF_CS1(UARTAPP_INTR, n, DSRMIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field DCDMIEN */

#define BP_UARTAPP_INTR_DCDMIEN      18
#define BM_UARTAPP_INTR_DCDMIEN      0x00040000

#define BF_UARTAPP_INTR_DCDMIEN(v)   (((v) << 18) & BM_UARTAPP_INTR_DCDMIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_DCDMIEN(n, v)   BF_CS1(UARTAPP_INTR, n, DCDMIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field CTSMIEN */

#define BP_UARTAPP_INTR_CTSMIEN      17
#define BM_UARTAPP_INTR_CTSMIEN      0x00020000

#define BF_UARTAPP_INTR_CTSMIEN(v)   (((v) << 17) & BM_UARTAPP_INTR_CTSMIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_CTSMIEN(n, v)   BF_CS1(UARTAPP_INTR, n, CTSMIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field RIMIEN */

#define BP_UARTAPP_INTR_RIMIEN      16
#define BM_UARTAPP_INTR_RIMIEN      0x00010000

#define BF_UARTAPP_INTR_RIMIEN(v)   (((v) << 16) & BM_UARTAPP_INTR_RIMIEN)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_RIMIEN(n, v)   BF_CS1(UARTAPP_INTR, n, RIMIEN, v)
#endif

/* --- Register HW_UARTAPP_INTR, field OEIS */

#define BP_UARTAPP_INTR_OEIS      10
#define BM_UARTAPP_INTR_OEIS      0x00000400

#define BF_UARTAPP_INTR_OEIS(v)   (((v) << 10) & BM_UARTAPP_INTR_OEIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_OEIS(n, v)   BF_CS1(UARTAPP_INTR, n, OEIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field BEIS */

#define BP_UARTAPP_INTR_BEIS      9
#define BM_UARTAPP_INTR_BEIS      0x00000200

#define BF_UARTAPP_INTR_BEIS(v)   (((v) << 9) & BM_UARTAPP_INTR_BEIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_BEIS(n, v)   BF_CS1(UARTAPP_INTR, n, BEIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field PEIS */

#define BP_UARTAPP_INTR_PEIS      8
#define BM_UARTAPP_INTR_PEIS      0x00000100

#define BF_UARTAPP_INTR_PEIS(v)   (((v) << 8) & BM_UARTAPP_INTR_PEIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_PEIS(n, v)   BF_CS1(UARTAPP_INTR, n, PEIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field FEIS */

#define BP_UARTAPP_INTR_FEIS      7
#define BM_UARTAPP_INTR_FEIS      0x00000080

#define BF_UARTAPP_INTR_FEIS(v)   (((v) << 7) & BM_UARTAPP_INTR_FEIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_FEIS(n, v)   BF_CS1(UARTAPP_INTR, n, FEIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field RTIS */

#define BP_UARTAPP_INTR_RTIS      6
#define BM_UARTAPP_INTR_RTIS      0x00000040

#define BF_UARTAPP_INTR_RTIS(v)   (((v) << 6) & BM_UARTAPP_INTR_RTIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_RTIS(n, v)   BF_CS1(UARTAPP_INTR, n, RTIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field TXIS */

#define BP_UARTAPP_INTR_TXIS      5
#define BM_UARTAPP_INTR_TXIS      0x00000020

#define BF_UARTAPP_INTR_TXIS(v)   (((v) << 5) & BM_UARTAPP_INTR_TXIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_TXIS(n, v)   BF_CS1(UARTAPP_INTR, n, TXIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field RXIS */

#define BP_UARTAPP_INTR_RXIS      4
#define BM_UARTAPP_INTR_RXIS      0x00000010

#define BF_UARTAPP_INTR_RXIS(v)   (((v) << 4) & BM_UARTAPP_INTR_RXIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_RXIS(n, v)   BF_CS1(UARTAPP_INTR, n, RXIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field DSRMIS */

#define BP_UARTAPP_INTR_DSRMIS      3
#define BM_UARTAPP_INTR_DSRMIS      0x00000008

#define BF_UARTAPP_INTR_DSRMIS(v)   (((v) << 3) & BM_UARTAPP_INTR_DSRMIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_DSRMIS(n, v)   BF_CS1(UARTAPP_INTR, n, DSRMIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field DCDMIS */

#define BP_UARTAPP_INTR_DCDMIS      2
#define BM_UARTAPP_INTR_DCDMIS      0x00000004

#define BF_UARTAPP_INTR_DCDMIS(v)   (((v) << 2) & BM_UARTAPP_INTR_DCDMIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_DCDMIS(n, v)   BF_CS1(UARTAPP_INTR, n, DCDMIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field CTSMIS */

#define BP_UARTAPP_INTR_CTSMIS      1
#define BM_UARTAPP_INTR_CTSMIS      0x00000002

#define BF_UARTAPP_INTR_CTSMIS(v)   (((v) << 1) & BM_UARTAPP_INTR_CTSMIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_CTSMIS(n, v)   BF_CS1(UARTAPP_INTR, n, CTSMIS, v)
#endif

/* --- Register HW_UARTAPP_INTR, field RIMIS */

#define BP_UARTAPP_INTR_RIMIS      0
#define BM_UARTAPP_INTR_RIMIS      0x00000001

#define BF_UARTAPP_INTR_RIMIS(v)   (((v) << 0) & BM_UARTAPP_INTR_RIMIS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_INTR_RIMIS(n, v)   BF_CS1(UARTAPP_INTR, n, RIMIS, v)
#endif



/*
 * HW_UARTAPP_DATA - UART Data Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA  : 32;
    } B;
} hw_uartapp_data_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_DATA register
 */
#define HW_UARTAPP_DATA_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_DATA(x)           (*(volatile hw_uartapp_data_t *) HW_UARTAPP_DATA_ADDR(x))
#define HW_UARTAPP_DATA_RD(x)      (HW_UARTAPP_DATA(x).U)
#define HW_UARTAPP_DATA_WR(x, v)     (HW_UARTAPP_DATA(x).U = (v))
#define HW_UARTAPP_DATA_SET(x, v)    (HW_UARTAPP_DATA_WR(x, HW_UARTAPP_DATA_RD(x) |  (v)))
#define HW_UARTAPP_DATA_CLR(x, v)    (HW_UARTAPP_DATA_WR(x, HW_UARTAPP_DATA_RD(x) & ~(v)))
#define HW_UARTAPP_DATA_TOG(x, v)    (HW_UARTAPP_DATA_WR(x, HW_UARTAPP_DATA_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_UARTAPP_DATA bitfields
 */
/* --- Register HW_UARTAPP_DATA, field DATA */

#define BP_UARTAPP_DATA_DATA      0
#define BM_UARTAPP_DATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_UARTAPP_DATA_DATA(v)   ((reg32_t) v)
#else
#define BF_UARTAPP_DATA_DATA(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_DATA_DATA(n, v)   (HW_UARTAPP_DATA(n).B.DATA = (v))
#endif



/*
 * HW_UARTAPP_STAT - UART Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RXCOUNT         : 16;
        unsigned FERR            :  1;
        unsigned PERR            :  1;
        unsigned BERR            :  1;
        unsigned OERR            :  1;
        unsigned RXBYTE_INVALID  :  4;
        unsigned RXFE            :  1;
        unsigned TXFF            :  1;
        unsigned RXFF            :  1;
        unsigned TXFE            :  1;
        unsigned CTS             :  1;
        unsigned BUSY            :  1;
        unsigned HISPEED         :  1;
        unsigned PRESENT         :  1;
    } B;
} hw_uartapp_stat_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_STAT register
 */
#define HW_UARTAPP_STAT_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_STAT(x)           (*(volatile hw_uartapp_stat_t *) HW_UARTAPP_STAT_ADDR(x))
#define HW_UARTAPP_STAT_RD(x)      (HW_UARTAPP_STAT(x).U)
#define HW_UARTAPP_STAT_WR(x, v)     (HW_UARTAPP_STAT(x).U = (v))
#define HW_UARTAPP_STAT_SET(x, v)    (HW_UARTAPP_STAT_WR(x, HW_UARTAPP_STAT_RD(x) |  (v)))
#define HW_UARTAPP_STAT_CLR(x, v)    (HW_UARTAPP_STAT_WR(x, HW_UARTAPP_STAT_RD(x) & ~(v)))
#define HW_UARTAPP_STAT_TOG(x, v)    (HW_UARTAPP_STAT_WR(x, HW_UARTAPP_STAT_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_UARTAPP_STAT bitfields
 */
/* --- Register HW_UARTAPP_STAT, field PRESENT */

#define BP_UARTAPP_STAT_PRESENT      31
#define BM_UARTAPP_STAT_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_UARTAPP_STAT_PRESENT(v)   ((((reg32_t) v) << 31) & BM_UARTAPP_STAT_PRESENT)
#else
#define BF_UARTAPP_STAT_PRESENT(v)   (((v) << 31) & BM_UARTAPP_STAT_PRESENT)
#endif
#define BV_UARTAPP_STAT_PRESENT__UNAVAILABLE  0x0
#define BV_UARTAPP_STAT_PRESENT__AVAILABLE    0x1

/* --- Register HW_UARTAPP_STAT, field HISPEED */

#define BP_UARTAPP_STAT_HISPEED      30
#define BM_UARTAPP_STAT_HISPEED      0x40000000

#define BF_UARTAPP_STAT_HISPEED(v)   (((v) << 30) & BM_UARTAPP_STAT_HISPEED)
#define BV_UARTAPP_STAT_HISPEED__UNAVAILABLE  0x0
#define BV_UARTAPP_STAT_HISPEED__AVAILABLE    0x1

/* --- Register HW_UARTAPP_STAT, field BUSY */

#define BP_UARTAPP_STAT_BUSY      29
#define BM_UARTAPP_STAT_BUSY      0x20000000

#define BF_UARTAPP_STAT_BUSY(v)   (((v) << 29) & BM_UARTAPP_STAT_BUSY)
/* --- Register HW_UARTAPP_STAT, field CTS */

#define BP_UARTAPP_STAT_CTS      28
#define BM_UARTAPP_STAT_CTS      0x10000000

#define BF_UARTAPP_STAT_CTS(v)   (((v) << 28) & BM_UARTAPP_STAT_CTS)
/* --- Register HW_UARTAPP_STAT, field TXFE */

#define BP_UARTAPP_STAT_TXFE      27
#define BM_UARTAPP_STAT_TXFE      0x08000000

#define BF_UARTAPP_STAT_TXFE(v)   (((v) << 27) & BM_UARTAPP_STAT_TXFE)
/* --- Register HW_UARTAPP_STAT, field RXFF */

#define BP_UARTAPP_STAT_RXFF      26
#define BM_UARTAPP_STAT_RXFF      0x04000000

#define BF_UARTAPP_STAT_RXFF(v)   (((v) << 26) & BM_UARTAPP_STAT_RXFF)
/* --- Register HW_UARTAPP_STAT, field TXFF */

#define BP_UARTAPP_STAT_TXFF      25
#define BM_UARTAPP_STAT_TXFF      0x02000000

#define BF_UARTAPP_STAT_TXFF(v)   (((v) << 25) & BM_UARTAPP_STAT_TXFF)
/* --- Register HW_UARTAPP_STAT, field RXFE */

#define BP_UARTAPP_STAT_RXFE      24
#define BM_UARTAPP_STAT_RXFE      0x01000000

#define BF_UARTAPP_STAT_RXFE(v)   (((v) << 24) & BM_UARTAPP_STAT_RXFE)
/* --- Register HW_UARTAPP_STAT, field RXBYTE_INVALID */

#define BP_UARTAPP_STAT_RXBYTE_INVALID      20
#define BM_UARTAPP_STAT_RXBYTE_INVALID      0x00F00000

#define BF_UARTAPP_STAT_RXBYTE_INVALID(v)   (((v) << 20) & BM_UARTAPP_STAT_RXBYTE_INVALID)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_STAT_RXBYTE_INVALID(n, v)   BF_CS1(UARTAPP_STAT, n, RXBYTE_INVALID, v)
#endif

/* --- Register HW_UARTAPP_STAT, field OERR */

#define BP_UARTAPP_STAT_OERR      19
#define BM_UARTAPP_STAT_OERR      0x00080000

#define BF_UARTAPP_STAT_OERR(v)   (((v) << 19) & BM_UARTAPP_STAT_OERR)
/* --- Register HW_UARTAPP_STAT, field BERR */

#define BP_UARTAPP_STAT_BERR      18
#define BM_UARTAPP_STAT_BERR      0x00040000

#define BF_UARTAPP_STAT_BERR(v)   (((v) << 18) & BM_UARTAPP_STAT_BERR)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_STAT_BERR(n, v)   BF_CS1(UARTAPP_STAT, n, BERR, v)
#endif

/* --- Register HW_UARTAPP_STAT, field PERR */

#define BP_UARTAPP_STAT_PERR      17
#define BM_UARTAPP_STAT_PERR      0x00020000

#define BF_UARTAPP_STAT_PERR(v)   (((v) << 17) & BM_UARTAPP_STAT_PERR)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_STAT_PERR(n, v)   BF_CS1(UARTAPP_STAT, n, PERR, v)
#endif

/* --- Register HW_UARTAPP_STAT, field FERR */

#define BP_UARTAPP_STAT_FERR      16
#define BM_UARTAPP_STAT_FERR      0x00010000

#define BF_UARTAPP_STAT_FERR(v)   (((v) << 16) & BM_UARTAPP_STAT_FERR)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_STAT_FERR(n, v)   BF_CS1(UARTAPP_STAT, n, FERR, v)
#endif

/* --- Register HW_UARTAPP_STAT, field RXCOUNT */

#define BP_UARTAPP_STAT_RXCOUNT      0
#define BM_UARTAPP_STAT_RXCOUNT      0x0000FFFF

#define BF_UARTAPP_STAT_RXCOUNT(v)   (((v) << 0) & BM_UARTAPP_STAT_RXCOUNT)


/*
 * HW_UARTAPP_DEBUG - UART Debug Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RXDMARQ      :  1;
        unsigned TXDMARQ      :  1;
        unsigned RXCMDEND     :  1;
        unsigned TXCMDEND     :  1;
        unsigned RXDMARUN     :  1;
        unsigned TXDMARUN     :  1;
        unsigned RSVD1        :  4;
        unsigned RXFBAUD_DIV  :  6;
        unsigned RXIBAUD_DIV  : 16;
    } B;
} hw_uartapp_debug_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_DEBUG register
 */
#define HW_UARTAPP_DEBUG_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x80)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_DEBUG(x)           (*(volatile hw_uartapp_debug_t *) HW_UARTAPP_DEBUG_ADDR(x))
#define HW_UARTAPP_DEBUG_RD(x)      (HW_UARTAPP_DEBUG(x).U)
#endif


/*
 * constants & macros for individual HW_UARTAPP_DEBUG bitfields
 */
/* --- Register HW_UARTAPP_DEBUG, field RXIBAUD_DIV */

#define BP_UARTAPP_DEBUG_RXIBAUD_DIV      16
#define BM_UARTAPP_DEBUG_RXIBAUD_DIV      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_UARTAPP_DEBUG_RXIBAUD_DIV(v)   ((((reg32_t) v) << 16) & BM_UARTAPP_DEBUG_RXIBAUD_DIV)
#else
#define BF_UARTAPP_DEBUG_RXIBAUD_DIV(v)   (((v) << 16) & BM_UARTAPP_DEBUG_RXIBAUD_DIV)
#endif
/* --- Register HW_UARTAPP_DEBUG, field RXFBAUD_DIV */

#define BP_UARTAPP_DEBUG_RXFBAUD_DIV      10
#define BM_UARTAPP_DEBUG_RXFBAUD_DIV      0x0000FC00

#define BF_UARTAPP_DEBUG_RXFBAUD_DIV(v)   (((v) << 10) & BM_UARTAPP_DEBUG_RXFBAUD_DIV)
/* --- Register HW_UARTAPP_DEBUG, field TXDMARUN */

#define BP_UARTAPP_DEBUG_TXDMARUN      5
#define BM_UARTAPP_DEBUG_TXDMARUN      0x00000020

#define BF_UARTAPP_DEBUG_TXDMARUN(v)   (((v) << 5) & BM_UARTAPP_DEBUG_TXDMARUN)
/* --- Register HW_UARTAPP_DEBUG, field RXDMARUN */

#define BP_UARTAPP_DEBUG_RXDMARUN      4
#define BM_UARTAPP_DEBUG_RXDMARUN      0x00000010

#define BF_UARTAPP_DEBUG_RXDMARUN(v)   (((v) << 4) & BM_UARTAPP_DEBUG_RXDMARUN)
/* --- Register HW_UARTAPP_DEBUG, field TXCMDEND */

#define BP_UARTAPP_DEBUG_TXCMDEND      3
#define BM_UARTAPP_DEBUG_TXCMDEND      0x00000008

#define BF_UARTAPP_DEBUG_TXCMDEND(v)   (((v) << 3) & BM_UARTAPP_DEBUG_TXCMDEND)
/* --- Register HW_UARTAPP_DEBUG, field RXCMDEND */

#define BP_UARTAPP_DEBUG_RXCMDEND      2
#define BM_UARTAPP_DEBUG_RXCMDEND      0x00000004

#define BF_UARTAPP_DEBUG_RXCMDEND(v)   (((v) << 2) & BM_UARTAPP_DEBUG_RXCMDEND)
/* --- Register HW_UARTAPP_DEBUG, field TXDMARQ */

#define BP_UARTAPP_DEBUG_TXDMARQ      1
#define BM_UARTAPP_DEBUG_TXDMARQ      0x00000002

#define BF_UARTAPP_DEBUG_TXDMARQ(v)   (((v) << 1) & BM_UARTAPP_DEBUG_TXDMARQ)
/* --- Register HW_UARTAPP_DEBUG, field RXDMARQ */

#define BP_UARTAPP_DEBUG_RXDMARQ      0
#define BM_UARTAPP_DEBUG_RXDMARQ      0x00000001

#define BF_UARTAPP_DEBUG_RXDMARQ(v)   (((v) << 0) & BM_UARTAPP_DEBUG_RXDMARQ)


/*
 * HW_UARTAPP_VERSION - UART Version Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_uartapp_version_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_VERSION register
 */
#define HW_UARTAPP_VERSION_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_VERSION(x)           (*(volatile hw_uartapp_version_t *) HW_UARTAPP_VERSION_ADDR(x))
#define HW_UARTAPP_VERSION_RD(x)      (HW_UARTAPP_VERSION(x).U)
#endif


/*
 * constants & macros for individual HW_UARTAPP_VERSION bitfields
 */
/* --- Register HW_UARTAPP_VERSION, field MAJOR */

#define BP_UARTAPP_VERSION_MAJOR      24
#define BM_UARTAPP_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_UARTAPP_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_UARTAPP_VERSION_MAJOR)
#else
#define BF_UARTAPP_VERSION_MAJOR(v)   (((v) << 24) & BM_UARTAPP_VERSION_MAJOR)
#endif
/* --- Register HW_UARTAPP_VERSION, field MINOR */

#define BP_UARTAPP_VERSION_MINOR      16
#define BM_UARTAPP_VERSION_MINOR      0x00FF0000

#define BF_UARTAPP_VERSION_MINOR(v)   (((v) << 16) & BM_UARTAPP_VERSION_MINOR)
/* --- Register HW_UARTAPP_VERSION, field STEP */

#define BP_UARTAPP_VERSION_STEP      0
#define BM_UARTAPP_VERSION_STEP      0x0000FFFF

#define BF_UARTAPP_VERSION_STEP(v)   (((v) << 0) & BM_UARTAPP_VERSION_STEP)


/*
 * HW_UARTAPP_AUTOBAUD - UART AutoBaud Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BAUD_DETECT_ENABLE  :  1;
        unsigned START_BAUD_DETECT   :  1;
        unsigned START_WITH_RUNBIT   :  1;
        unsigned TWO_REF_CHARS       :  1;
        unsigned UPDATE_TX           :  1;
        unsigned RSVD1               : 11;
        unsigned REFCHAR0            :  8;
        unsigned REFCHAR1            :  8;
    } B;
} hw_uartapp_autobaud_t;
#endif

/*
 * constants & macros for entire multi-block HW_UARTAPP_AUTOBAUD register
 */
#define HW_UARTAPP_AUTOBAUD_ADDR(x)      (REGS_UARTAPP_BASE(x) + 0xa0)

#ifndef __LANGUAGE_ASM__
#define HW_UARTAPP_AUTOBAUD(x)           (*(volatile hw_uartapp_autobaud_t *) HW_UARTAPP_AUTOBAUD_ADDR(x))
#define HW_UARTAPP_AUTOBAUD_RD(x)      (HW_UARTAPP_AUTOBAUD(x).U)
#define HW_UARTAPP_AUTOBAUD_WR(x, v)     (HW_UARTAPP_AUTOBAUD(x).U = (v))
#define HW_UARTAPP_AUTOBAUD_SET(x, v)    (HW_UARTAPP_AUTOBAUD_WR(x, HW_UARTAPP_AUTOBAUD_RD(x) |  (v)))
#define HW_UARTAPP_AUTOBAUD_CLR(x, v)    (HW_UARTAPP_AUTOBAUD_WR(x, HW_UARTAPP_AUTOBAUD_RD(x) & ~(v)))
#define HW_UARTAPP_AUTOBAUD_TOG(x, v)    (HW_UARTAPP_AUTOBAUD_WR(x, HW_UARTAPP_AUTOBAUD_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_UARTAPP_AUTOBAUD bitfields
 */
/* --- Register HW_UARTAPP_AUTOBAUD, field REFCHAR1 */

#define BP_UARTAPP_AUTOBAUD_REFCHAR1      24
#define BM_UARTAPP_AUTOBAUD_REFCHAR1      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_UARTAPP_AUTOBAUD_REFCHAR1(v)   ((((reg32_t) v) << 24) & BM_UARTAPP_AUTOBAUD_REFCHAR1)
#else
#define BF_UARTAPP_AUTOBAUD_REFCHAR1(v)   (((v) << 24) & BM_UARTAPP_AUTOBAUD_REFCHAR1)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_AUTOBAUD_REFCHAR1(n, v)   (HW_UARTAPP_AUTOBAUD(n).B.REFCHAR1 = (v))
#endif

/* --- Register HW_UARTAPP_AUTOBAUD, field REFCHAR0 */

#define BP_UARTAPP_AUTOBAUD_REFCHAR0      16
#define BM_UARTAPP_AUTOBAUD_REFCHAR0      0x00FF0000

#define BF_UARTAPP_AUTOBAUD_REFCHAR0(v)   (((v) << 16) & BM_UARTAPP_AUTOBAUD_REFCHAR0)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_AUTOBAUD_REFCHAR0(n, v)   (HW_UARTAPP_AUTOBAUD(n).B.REFCHAR0 = (v))
#endif

/* --- Register HW_UARTAPP_AUTOBAUD, field UPDATE_TX */

#define BP_UARTAPP_AUTOBAUD_UPDATE_TX      4
#define BM_UARTAPP_AUTOBAUD_UPDATE_TX      0x00000010

#define BF_UARTAPP_AUTOBAUD_UPDATE_TX(v)   (((v) << 4) & BM_UARTAPP_AUTOBAUD_UPDATE_TX)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_AUTOBAUD_UPDATE_TX(n, v)   BF_CS1(UARTAPP_AUTOBAUD, n, UPDATE_TX, v)
#endif

/* --- Register HW_UARTAPP_AUTOBAUD, field TWO_REF_CHARS */

#define BP_UARTAPP_AUTOBAUD_TWO_REF_CHARS      3
#define BM_UARTAPP_AUTOBAUD_TWO_REF_CHARS      0x00000008

#define BF_UARTAPP_AUTOBAUD_TWO_REF_CHARS(v)   (((v) << 3) & BM_UARTAPP_AUTOBAUD_TWO_REF_CHARS)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_AUTOBAUD_TWO_REF_CHARS(n, v)   BF_CS1(UARTAPP_AUTOBAUD, n, TWO_REF_CHARS, v)
#endif

/* --- Register HW_UARTAPP_AUTOBAUD, field START_WITH_RUNBIT */

#define BP_UARTAPP_AUTOBAUD_START_WITH_RUNBIT      2
#define BM_UARTAPP_AUTOBAUD_START_WITH_RUNBIT      0x00000004

#define BF_UARTAPP_AUTOBAUD_START_WITH_RUNBIT(v)   (((v) << 2) & BM_UARTAPP_AUTOBAUD_START_WITH_RUNBIT)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_AUTOBAUD_START_WITH_RUNBIT(n, v)   BF_CS1(UARTAPP_AUTOBAUD, n, START_WITH_RUNBIT, v)
#endif

/* --- Register HW_UARTAPP_AUTOBAUD, field START_BAUD_DETECT */

#define BP_UARTAPP_AUTOBAUD_START_BAUD_DETECT      1
#define BM_UARTAPP_AUTOBAUD_START_BAUD_DETECT      0x00000002

#define BF_UARTAPP_AUTOBAUD_START_BAUD_DETECT(v)   (((v) << 1) & BM_UARTAPP_AUTOBAUD_START_BAUD_DETECT)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_AUTOBAUD_START_BAUD_DETECT(n, v)   BF_CS1(UARTAPP_AUTOBAUD, n, START_BAUD_DETECT, v)
#endif

/* --- Register HW_UARTAPP_AUTOBAUD, field BAUD_DETECT_ENABLE */

#define BP_UARTAPP_AUTOBAUD_BAUD_DETECT_ENABLE      0
#define BM_UARTAPP_AUTOBAUD_BAUD_DETECT_ENABLE      0x00000001

#define BF_UARTAPP_AUTOBAUD_BAUD_DETECT_ENABLE(v)   (((v) << 0) & BM_UARTAPP_AUTOBAUD_BAUD_DETECT_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_UARTAPP_AUTOBAUD_BAUD_DETECT_ENABLE(n, v)   BF_CS1(UARTAPP_AUTOBAUD, n, BAUD_DETECT_ENABLE, v)
#endif


#endif /* _UARTAPP_H */

////////////////////////////////////////////////////////////////////////////////
