/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSSIMMEMSEL_H
#define _REGSSIMMEMSEL_H  1

#include "regs.h"

#ifndef REGS_SIMMEMSEL_BASE
#define REGS_SIMMEMSEL_BASE (REGS_BASE + 0x0003C070)
#endif

////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_SIMMEMSEL_CHANn_CFG : base 0x8003C070 : count 2 : offset 0x4
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  DEV_CODE;
        unsigned DEV_CLASS  :  4;
        unsigned CE_SRC     :  4;
        reg8_t   WIDTH;
    } B;
} hw_simmemsel_chann_cfg_t;
#endif


//
// constants & macros for entire HW_SIMMEMSEL_CHANn_CFG multi-register
//

#define HW_SIMMEMSEL_CHANn_CFG_COUNT        2
#define HW_SIMMEMSEL_CHANn_CFG_ADDR(n)      (REGS_SIMMEMSEL_BASE + 0x00000000 + ((n) * 0x4))

#ifndef __LANGUAGE_ASM__
#define HW_SIMMEMSEL_CHANn_CFG(n)           (*(volatile hw_simmemsel_chann_cfg_t *) HW_SIMMEMSEL_CHANn_CFG_ADDR(n))
#define HW_SIMMEMSEL_CHANn_CFG_RD(n)        (HW_SIMMEMSEL_CHANn_CFG(n).U)
#define HW_SIMMEMSEL_CHANn_CFG_WR(n, v)     (HW_SIMMEMSEL_CHANn_CFG(n).U = (v))
#define HW_SIMMEMSEL_CHANn_CFG_SET(n, v)    (HW_SIMMEMSEL_CHANn_CFG_WR(n, HW_SIMMEMSEL_CHANn_CFG_RD(n) |  (v)))
#define HW_SIMMEMSEL_CHANn_CFG_CLR(n, v)    (HW_SIMMEMSEL_CHANn_CFG_WR(n, HW_SIMMEMSEL_CHANn_CFG_RD(n) & ~(v)))
#define HW_SIMMEMSEL_CHANn_CFG_TOG(n, v)    (HW_SIMMEMSEL_CHANn_CFG_WR(n, HW_SIMMEMSEL_CHANn_CFG_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_SIMMEMSEL_CHANn_CFG multi-register bitfields
//

//--- Register HW_SIMMEMSEL_CHANn_CFG, field WIDTH

#define BP_SIMMEMSEL_CHANn_CFG_WIDTH      24
#define BM_SIMMEMSEL_CHANn_CFG_WIDTH      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_SIMMEMSEL_CHANn_CFG_WIDTH(v)   ((((reg32_t) v) << 24) & BM_SIMMEMSEL_CHANn_CFG_WIDTH)
#else
#define BF_SIMMEMSEL_CHANn_CFG_WIDTH(v)   (((v) << 24) & BM_SIMMEMSEL_CHANn_CFG_WIDTH)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SIMMEMSEL_CHANn_CFG_WIDTH(n, v)  (HW_SIMMEMSEL_CHANn_CFG(n).B.WIDTH = (v))
#endif

//--- Register HW_SIMMEMSEL_CHANn_CFG, field CE_SRC

#define BP_SIMMEMSEL_CHANn_CFG_CE_SRC      20
#define BM_SIMMEMSEL_CHANn_CFG_CE_SRC      0x00F00000

#define BF_SIMMEMSEL_CHANn_CFG_CE_SRC(v)   (((v) << 20) & BM_SIMMEMSEL_CHANn_CFG_CE_SRC)

#ifndef __LANGUAGE_ASM__
#define BW_SIMMEMSEL_CHANn_CFG_CE_SRC(n, v)  BF_CS1n(SIMMEMSEL_CHANn_CFG, n, CE_SRC, v)
#endif

#define BV_SIMMEMSEL_CHANn_CFG_CE_SRC__PRIMARY  0x0

//--- Register HW_SIMMEMSEL_CHANn_CFG, field DEV_CLASS

#define BP_SIMMEMSEL_CHANn_CFG_DEV_CLASS      16
#define BM_SIMMEMSEL_CHANn_CFG_DEV_CLASS      0x000F0000

#define BF_SIMMEMSEL_CHANn_CFG_DEV_CLASS(v)   (((v) << 16) & BM_SIMMEMSEL_CHANn_CFG_DEV_CLASS)

#ifndef __LANGUAGE_ASM__
#define BW_SIMMEMSEL_CHANn_CFG_DEV_CLASS(n, v)  BF_CS1n(SIMMEMSEL_CHANn_CFG, n, DEV_CLASS, v)
#endif

#define BV_SIMMEMSEL_CHANn_CFG_DEV_CLASS__RSRVD      0x0
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CLASS__SDRAM_32   0x1
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CLASS__SDRAM_16   0x2
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CLASS__MSDRAM_32  0x3
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CLASS__MSDRAM_16  0x4
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CLASS__MDDR_32    0x5
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CLASS__MDDR_16    0x6
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CLASS__DDR_16     0x7

//--- Register HW_SIMMEMSEL_CHANn_CFG, field DEV_CODE

#define BP_SIMMEMSEL_CHANn_CFG_DEV_CODE      0
#define BM_SIMMEMSEL_CHANn_CFG_DEV_CODE      0x0000FFFF

#define BF_SIMMEMSEL_CHANn_CFG_DEV_CODE(v)   (((v) << 0) & BM_SIMMEMSEL_CHANn_CFG_DEV_CODE)

#ifndef __LANGUAGE_ASM__
#define BW_SIMMEMSEL_CHANn_CFG_DEV_CODE(n, v)  (HW_SIMMEMSEL_CHANn_CFG(n).B.DEV_CODE = (v))
#endif

#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__RSRVD                    0x0
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__SDRAM_16_MT48LC16M16A2   0x1
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__SDRAM_16_MT48LC4M16A2    0x2
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__SDRAM_32_K4S643232F_60   0x1
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__MSDRAM_16_K4M28163LF_75  0x1
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__MSDRAM_16_MT48H4M16LF_8  0x2
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__MSDRAM_16_K4M56163PG_75  0x3
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__MSDRAM_32_K4M28323LF_60  0x1
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__MDDR_16_MT46H16M16LF_6   0x1
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__MDDR_16_MT46H8M16_75     0x2
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__MDDR_16_MT46H16M16LF_75  0x3
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__MDDR_32_MT46H8M32LF_6    0x1
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__MDDR_32_MT46H8M32LF_75   0x2
#define BV_SIMMEMSEL_CHANn_CFG_DEV_CODE__DDR_16_MT46V8M16_6       0x1


////////////////////////////////////////////////////////////////////////////////
//// HW_OLD_SIMMEMSEL_REG - Old SIMMEMSEL register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  RSRVD1;
    } B;
} hw_old_simmemsel_reg_t;
#endif


//
// constants & macros for entire HW_OLD_SIMMEMSEL_REG register
//

#define HW_OLD_SIMMEMSEL_REG_ADDR      (REGS_SIMMEMSEL_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_OLD_SIMMEMSEL_REG           (*(volatile hw_old_simmemsel_reg_t *) HW_OLD_SIMMEMSEL_REG_ADDR)
#define HW_OLD_SIMMEMSEL_REG_RD()      (HW_OLD_SIMMEMSEL_REG.U)
#endif


//
// constants & macros for individual HW_OLD_SIMMEMSEL_REG bitfields
//


#endif // _REGSSIMMEMSEL_H

////////////////////////////////////////////////////////////////////////////////
