/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSDRI_H
#define _REGSDRI_H  1

#include "regs.h"

#ifndef REGS_DRI_BASE
#define REGS_DRI_BASE (REGS_BASE + 0x00074000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_DRI_CTRL - DRI Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RUN                     :  1;
        unsigned ATTENTION_IRQ           :  1;
        unsigned PILOT_SYNC_LOSS_IRQ     :  1;
        unsigned OVERFLOW_IRQ            :  1;
        unsigned RSVD1                   :  5;
        unsigned ATTENTION_IRQ_EN        :  1;
        unsigned PILOT_SYNC_LOSS_IRQ_EN  :  1;
        unsigned OVERFLOW_IRQ_EN         :  1;
        unsigned RSVD2                   :  3;
        unsigned REACQUIRE_PHASE         :  1;
        unsigned DMA_DELAY_COUNT         :  5;
        unsigned RSVD3                   :  4;
        unsigned STOP_ON_PILOT_ERROR     :  1;
        unsigned STOP_ON_OFLOW_ERROR     :  1;
        unsigned RSVD4                   :  2;
        unsigned ENABLE_INPUTS           :  1;
        unsigned CLKGATE                 :  1;
        unsigned SFTRST                  :  1;
    } B;
} hw_dri_ctrl_t;
#endif


//
// constants & macros for entire HW_DRI_CTRL register
//

#define HW_DRI_CTRL_ADDR      (REGS_DRI_BASE + 0x00000000)
#define HW_DRI_CTRL_SET_ADDR  (REGS_DRI_BASE + 0x00000004)
#define HW_DRI_CTRL_CLR_ADDR  (REGS_DRI_BASE + 0x00000008)
#define HW_DRI_CTRL_TOG_ADDR  (REGS_DRI_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_DRI_CTRL           (*(volatile hw_dri_ctrl_t *) HW_DRI_CTRL_ADDR)
#define HW_DRI_CTRL_RD()      (HW_DRI_CTRL.U)
#define HW_DRI_CTRL_WR(v)     (HW_DRI_CTRL.U = (v))
#define HW_DRI_CTRL_SET(v)    ((*(volatile reg32_t *) HW_DRI_CTRL_SET_ADDR) = (v))
#define HW_DRI_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_DRI_CTRL_CLR_ADDR) = (v))
#define HW_DRI_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_DRI_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DRI_CTRL bitfields
//

//--- Register HW_DRI_CTRL, field SFTRST

#define BP_DRI_CTRL_SFTRST      31
#define BM_DRI_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRI_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_DRI_CTRL_SFTRST)
#else
#define BF_DRI_CTRL_SFTRST(v)   (((v) << 31) & BM_DRI_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_SFTRST(v)   BF_CS1(DRI_CTRL, SFTRST, v)
#endif

#define BV_DRI_CTRL_SFTRST__RUN    0x0
#define BV_DRI_CTRL_SFTRST__RESET  0x1

//--- Register HW_DRI_CTRL, field CLKGATE

#define BP_DRI_CTRL_CLKGATE      30
#define BM_DRI_CTRL_CLKGATE      0x40000000

#define BF_DRI_CTRL_CLKGATE(v)   (((v) << 30) & BM_DRI_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_CLKGATE(v)   BF_CS1(DRI_CTRL, CLKGATE, v)
#endif

#define BV_DRI_CTRL_CLKGATE__RUN      0x0
#define BV_DRI_CTRL_CLKGATE__NO_CLKS  0x1

//--- Register HW_DRI_CTRL, field ENABLE_INPUTS

#define BP_DRI_CTRL_ENABLE_INPUTS      29
#define BM_DRI_CTRL_ENABLE_INPUTS      0x20000000

#define BF_DRI_CTRL_ENABLE_INPUTS(v)   (((v) << 29) & BM_DRI_CTRL_ENABLE_INPUTS)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_ENABLE_INPUTS(v)   BF_CS1(DRI_CTRL, ENABLE_INPUTS, v)
#endif

#define BV_DRI_CTRL_ENABLE_INPUTS__ANALOG_LINE_IN  0x0
#define BV_DRI_CTRL_ENABLE_INPUTS__DRI_DIGITAL_IN  0x1

//--- Register HW_DRI_CTRL, field STOP_ON_OFLOW_ERROR

#define BP_DRI_CTRL_STOP_ON_OFLOW_ERROR      26
#define BM_DRI_CTRL_STOP_ON_OFLOW_ERROR      0x04000000

#define BF_DRI_CTRL_STOP_ON_OFLOW_ERROR(v)   (((v) << 26) & BM_DRI_CTRL_STOP_ON_OFLOW_ERROR)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_STOP_ON_OFLOW_ERROR(v)   BF_CS1(DRI_CTRL, STOP_ON_OFLOW_ERROR, v)
#endif

#define BV_DRI_CTRL_STOP_ON_OFLOW_ERROR__IGNORE  0x0
#define BV_DRI_CTRL_STOP_ON_OFLOW_ERROR__STOP    0x1

//--- Register HW_DRI_CTRL, field STOP_ON_PILOT_ERROR

#define BP_DRI_CTRL_STOP_ON_PILOT_ERROR      25
#define BM_DRI_CTRL_STOP_ON_PILOT_ERROR      0x02000000

#define BF_DRI_CTRL_STOP_ON_PILOT_ERROR(v)   (((v) << 25) & BM_DRI_CTRL_STOP_ON_PILOT_ERROR)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_STOP_ON_PILOT_ERROR(v)   BF_CS1(DRI_CTRL, STOP_ON_PILOT_ERROR, v)
#endif

#define BV_DRI_CTRL_STOP_ON_PILOT_ERROR__IGNORE  0x0
#define BV_DRI_CTRL_STOP_ON_PILOT_ERROR__STOP    0x1

//--- Register HW_DRI_CTRL, field DMA_DELAY_COUNT

#define BP_DRI_CTRL_DMA_DELAY_COUNT      16
#define BM_DRI_CTRL_DMA_DELAY_COUNT      0x001F0000

#define BF_DRI_CTRL_DMA_DELAY_COUNT(v)   (((v) << 16) & BM_DRI_CTRL_DMA_DELAY_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_DMA_DELAY_COUNT(v)   BF_CS1(DRI_CTRL, DMA_DELAY_COUNT, v)
#endif

//--- Register HW_DRI_CTRL, field REACQUIRE_PHASE

#define BP_DRI_CTRL_REACQUIRE_PHASE      15
#define BM_DRI_CTRL_REACQUIRE_PHASE      0x00008000

#define BF_DRI_CTRL_REACQUIRE_PHASE(v)   (((v) << 15) & BM_DRI_CTRL_REACQUIRE_PHASE)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_REACQUIRE_PHASE(v)   BF_CS1(DRI_CTRL, REACQUIRE_PHASE, v)
#endif

#define BV_DRI_CTRL_REACQUIRE_PHASE__NORMAL     0x0
#define BV_DRI_CTRL_REACQUIRE_PHASE__NEW_PHASE  0x1

//--- Register HW_DRI_CTRL, field OVERFLOW_IRQ_EN

#define BP_DRI_CTRL_OVERFLOW_IRQ_EN      11
#define BM_DRI_CTRL_OVERFLOW_IRQ_EN      0x00000800

#define BF_DRI_CTRL_OVERFLOW_IRQ_EN(v)   (((v) << 11) & BM_DRI_CTRL_OVERFLOW_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_OVERFLOW_IRQ_EN(v)   BF_CS1(DRI_CTRL, OVERFLOW_IRQ_EN, v)
#endif

#define BV_DRI_CTRL_OVERFLOW_IRQ_EN__DISABLED  0x0
#define BV_DRI_CTRL_OVERFLOW_IRQ_EN__ENABLED   0x1

//--- Register HW_DRI_CTRL, field PILOT_SYNC_LOSS_IRQ_EN

#define BP_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN      10
#define BM_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN      0x00000400

#define BF_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN(v)   (((v) << 10) & BM_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN(v)   BF_CS1(DRI_CTRL, PILOT_SYNC_LOSS_IRQ_EN, v)
#endif

#define BV_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN__DISABLED  0x0
#define BV_DRI_CTRL_PILOT_SYNC_LOSS_IRQ_EN__ENABLED   0x1

//--- Register HW_DRI_CTRL, field ATTENTION_IRQ_EN

#define BP_DRI_CTRL_ATTENTION_IRQ_EN      9
#define BM_DRI_CTRL_ATTENTION_IRQ_EN      0x00000200

#define BF_DRI_CTRL_ATTENTION_IRQ_EN(v)   (((v) << 9) & BM_DRI_CTRL_ATTENTION_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_ATTENTION_IRQ_EN(v)   BF_CS1(DRI_CTRL, ATTENTION_IRQ_EN, v)
#endif

#define BV_DRI_CTRL_ATTENTION_IRQ_EN__DISABLED  0x0
#define BV_DRI_CTRL_ATTENTION_IRQ_EN__ENABLED   0x1

//--- Register HW_DRI_CTRL, field OVERFLOW_IRQ

#define BP_DRI_CTRL_OVERFLOW_IRQ      3
#define BM_DRI_CTRL_OVERFLOW_IRQ      0x00000008

#define BF_DRI_CTRL_OVERFLOW_IRQ(v)   (((v) << 3) & BM_DRI_CTRL_OVERFLOW_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_OVERFLOW_IRQ(v)   BF_CS1(DRI_CTRL, OVERFLOW_IRQ, v)
#endif

#define BV_DRI_CTRL_OVERFLOW_IRQ__NO_REQUEST  0x0
#define BV_DRI_CTRL_OVERFLOW_IRQ__REQUEST     0x1

//--- Register HW_DRI_CTRL, field PILOT_SYNC_LOSS_IRQ

#define BP_DRI_CTRL_PILOT_SYNC_LOSS_IRQ      2
#define BM_DRI_CTRL_PILOT_SYNC_LOSS_IRQ      0x00000004

#define BF_DRI_CTRL_PILOT_SYNC_LOSS_IRQ(v)   (((v) << 2) & BM_DRI_CTRL_PILOT_SYNC_LOSS_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_PILOT_SYNC_LOSS_IRQ(v)   BF_CS1(DRI_CTRL, PILOT_SYNC_LOSS_IRQ, v)
#endif

#define BV_DRI_CTRL_PILOT_SYNC_LOSS_IRQ__NO_REQUEST  0x0
#define BV_DRI_CTRL_PILOT_SYNC_LOSS_IRQ__REQUEST     0x1

//--- Register HW_DRI_CTRL, field ATTENTION_IRQ

#define BP_DRI_CTRL_ATTENTION_IRQ      1
#define BM_DRI_CTRL_ATTENTION_IRQ      0x00000002

#define BF_DRI_CTRL_ATTENTION_IRQ(v)   (((v) << 1) & BM_DRI_CTRL_ATTENTION_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_ATTENTION_IRQ(v)   BF_CS1(DRI_CTRL, ATTENTION_IRQ, v)
#endif

#define BV_DRI_CTRL_ATTENTION_IRQ__NO_REQUEST  0x0
#define BV_DRI_CTRL_ATTENTION_IRQ__REQUEST     0x1

//--- Register HW_DRI_CTRL, field RUN

#define BP_DRI_CTRL_RUN      0
#define BM_DRI_CTRL_RUN      0x00000001

#define BF_DRI_CTRL_RUN(v)   (((v) << 0) & BM_DRI_CTRL_RUN)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_CTRL_RUN(v)   BF_CS1(DRI_CTRL, RUN, v)
#endif

#define BV_DRI_CTRL_RUN__HALT  0x0
#define BV_DRI_CTRL_RUN__RUN   0x1


////////////////////////////////////////////////////////////////////////////////
//// HW_DRI_TIMING - DRI Timing Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   GAP_DETECTION_INTERVAL;
        reg8_t   RSVD1;
        unsigned PILOT_REP_RATE          :  4;
        unsigned RSVD2                   : 12;
    } B;
} hw_dri_timing_t;
#endif


//
// constants & macros for entire HW_DRI_TIMING register
//

#define HW_DRI_TIMING_ADDR      (REGS_DRI_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_DRI_TIMING           (*(volatile hw_dri_timing_t *) HW_DRI_TIMING_ADDR)
#define HW_DRI_TIMING_RD()      (HW_DRI_TIMING.U)
#define HW_DRI_TIMING_WR(v)     (HW_DRI_TIMING.U = (v))
#define HW_DRI_TIMING_SET(v)    (HW_DRI_TIMING_WR(HW_DRI_TIMING_RD() |  (v)))
#define HW_DRI_TIMING_CLR(v)    (HW_DRI_TIMING_WR(HW_DRI_TIMING_RD() & ~(v)))
#define HW_DRI_TIMING_TOG(v)    (HW_DRI_TIMING_WR(HW_DRI_TIMING_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRI_TIMING bitfields
//

//--- Register HW_DRI_TIMING, field PILOT_REP_RATE

#define BP_DRI_TIMING_PILOT_REP_RATE      16
#define BM_DRI_TIMING_PILOT_REP_RATE      0x000F0000

#define BF_DRI_TIMING_PILOT_REP_RATE(v)   (((v) << 16) & BM_DRI_TIMING_PILOT_REP_RATE)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_TIMING_PILOT_REP_RATE(v)   BF_CS1(DRI_TIMING, PILOT_REP_RATE, v)
#endif

//--- Register HW_DRI_TIMING, field GAP_DETECTION_INTERVAL

#define BP_DRI_TIMING_GAP_DETECTION_INTERVAL      0
#define BM_DRI_TIMING_GAP_DETECTION_INTERVAL      0x000000FF

#define BF_DRI_TIMING_GAP_DETECTION_INTERVAL(v)   (((v) << 0) & BM_DRI_TIMING_GAP_DETECTION_INTERVAL)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_TIMING_GAP_DETECTION_INTERVAL(v)   (HW_DRI_TIMING.B.GAP_DETECTION_INTERVAL = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRI_STAT - DRI Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD1                        :  1;
        unsigned ATTENTION_IRQ_SUMMARY        :  1;
        unsigned PILOT_SYNC_LOSS_IRQ_SUMMARY  :  1;
        unsigned OVERFLOW_IRQ_SUMMARY         :  1;
        unsigned RSVD2                        : 12;
        unsigned PILOT_PHASE                  :  4;
        unsigned RSVD3                        : 11;
        unsigned DRI_PRESENT                  :  1;
    } B;
} hw_dri_stat_t;
#endif


//
// constants & macros for entire HW_DRI_STAT register
//

#define HW_DRI_STAT_ADDR      (REGS_DRI_BASE + 0x00000020)

#ifndef __LANGUAGE_ASM__
#define HW_DRI_STAT           (*(volatile hw_dri_stat_t *) HW_DRI_STAT_ADDR)
#define HW_DRI_STAT_RD()      (HW_DRI_STAT.U)
#endif


//
// constants & macros for individual HW_DRI_STAT bitfields
//

//--- Register HW_DRI_STAT, field DRI_PRESENT

#define BP_DRI_STAT_DRI_PRESENT      31
#define BM_DRI_STAT_DRI_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRI_STAT_DRI_PRESENT(v)   ((((reg32_t) v) << 31) & BM_DRI_STAT_DRI_PRESENT)
#else
#define BF_DRI_STAT_DRI_PRESENT(v)   (((v) << 31) & BM_DRI_STAT_DRI_PRESENT)
#endif

#define BV_DRI_STAT_DRI_PRESENT__UNAVAILABLE  0x0
#define BV_DRI_STAT_DRI_PRESENT__AVAILABLE    0x1

//--- Register HW_DRI_STAT, field PILOT_PHASE

#define BP_DRI_STAT_PILOT_PHASE      16
#define BM_DRI_STAT_PILOT_PHASE      0x000F0000

#define BF_DRI_STAT_PILOT_PHASE(v)   (((v) << 16) & BM_DRI_STAT_PILOT_PHASE)

//--- Register HW_DRI_STAT, field OVERFLOW_IRQ_SUMMARY

#define BP_DRI_STAT_OVERFLOW_IRQ_SUMMARY      3
#define BM_DRI_STAT_OVERFLOW_IRQ_SUMMARY      0x00000008

#define BF_DRI_STAT_OVERFLOW_IRQ_SUMMARY(v)   (((v) << 3) & BM_DRI_STAT_OVERFLOW_IRQ_SUMMARY)

#define BV_DRI_STAT_OVERFLOW_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_DRI_STAT_OVERFLOW_IRQ_SUMMARY__REQUEST     0x1

//--- Register HW_DRI_STAT, field PILOT_SYNC_LOSS_IRQ_SUMMARY

#define BP_DRI_STAT_PILOT_SYNC_LOSS_IRQ_SUMMARY      2
#define BM_DRI_STAT_PILOT_SYNC_LOSS_IRQ_SUMMARY      0x00000004

#define BF_DRI_STAT_PILOT_SYNC_LOSS_IRQ_SUMMARY(v)   (((v) << 2) & BM_DRI_STAT_PILOT_SYNC_LOSS_IRQ_SUMMARY)

#define BV_DRI_STAT_PILOT_SYNC_LOSS_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_DRI_STAT_PILOT_SYNC_LOSS_IRQ_SUMMARY__REQUEST     0x1

//--- Register HW_DRI_STAT, field ATTENTION_IRQ_SUMMARY

#define BP_DRI_STAT_ATTENTION_IRQ_SUMMARY      1
#define BM_DRI_STAT_ATTENTION_IRQ_SUMMARY      0x00000002

#define BF_DRI_STAT_ATTENTION_IRQ_SUMMARY(v)   (((v) << 1) & BM_DRI_STAT_ATTENTION_IRQ_SUMMARY)

#define BV_DRI_STAT_ATTENTION_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_DRI_STAT_ATTENTION_IRQ_SUMMARY__REQUEST     0x1


////////////////////////////////////////////////////////////////////////////////
//// HW_DRI_DATA - DRI Controller DMA Read Data Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_dri_data_t;
#endif


//
// constants & macros for entire HW_DRI_DATA register
//

#define HW_DRI_DATA_ADDR      (REGS_DRI_BASE + 0x00000030)

#ifndef __LANGUAGE_ASM__
#define HW_DRI_DATA           (*(volatile hw_dri_data_t *) HW_DRI_DATA_ADDR)
#define HW_DRI_DATA_RD()      (HW_DRI_DATA.U)
#define HW_DRI_DATA_WR(v)     (HW_DRI_DATA.U = (v))
#define HW_DRI_DATA_SET(v)    (HW_DRI_DATA_WR(HW_DRI_DATA_RD() |  (v)))
#define HW_DRI_DATA_CLR(v)    (HW_DRI_DATA_WR(HW_DRI_DATA_RD() & ~(v)))
#define HW_DRI_DATA_TOG(v)    (HW_DRI_DATA_WR(HW_DRI_DATA_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRI_DATA bitfields
//

//--- Register HW_DRI_DATA, field DATA

#define BP_DRI_DATA_DATA      0
#define BM_DRI_DATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DRI_DATA_DATA(v)   ((reg32_t) v)
#else
#define BF_DRI_DATA_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRI_DATA_DATA(v)   (HW_DRI_DATA.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRI_DEBUG0 - DRI Device Debug Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FRAME           : 18;
        unsigned SPARE           :  8;
        unsigned PILOT_REP_RATE  :  1;
        unsigned TEST_MODE       :  1;
        unsigned DRI_DATA_INPUT  :  1;
        unsigned DRI_CLK_INPUT   :  1;
        unsigned DMACMDKICK      :  1;
        unsigned DMAREQ          :  1;
    } B;
} hw_dri_debug0_t;
#endif


//
// constants & macros for entire HW_DRI_DEBUG0 register
//

#define HW_DRI_DEBUG0_ADDR      (REGS_DRI_BASE + 0x00000040)
#define HW_DRI_DEBUG0_SET_ADDR  (REGS_DRI_BASE + 0x00000044)
#define HW_DRI_DEBUG0_CLR_ADDR  (REGS_DRI_BASE + 0x00000048)
#define HW_DRI_DEBUG0_TOG_ADDR  (REGS_DRI_BASE + 0x0000004C)

#ifndef __LANGUAGE_ASM__
#define HW_DRI_DEBUG0           (*(volatile hw_dri_debug0_t *) HW_DRI_DEBUG0_ADDR)
#define HW_DRI_DEBUG0_RD()      (HW_DRI_DEBUG0.U)
#define HW_DRI_DEBUG0_WR(v)     (HW_DRI_DEBUG0.U = (v))
#define HW_DRI_DEBUG0_SET(v)    ((*(volatile reg32_t *) HW_DRI_DEBUG0_SET_ADDR) = (v))
#define HW_DRI_DEBUG0_CLR(v)    ((*(volatile reg32_t *) HW_DRI_DEBUG0_CLR_ADDR) = (v))
#define HW_DRI_DEBUG0_TOG(v)    ((*(volatile reg32_t *) HW_DRI_DEBUG0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DRI_DEBUG0 bitfields
//

//--- Register HW_DRI_DEBUG0, field DMAREQ

#define BP_DRI_DEBUG0_DMAREQ      31
#define BM_DRI_DEBUG0_DMAREQ      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRI_DEBUG0_DMAREQ(v)   ((((reg32_t) v) << 31) & BM_DRI_DEBUG0_DMAREQ)
#else
#define BF_DRI_DEBUG0_DMAREQ(v)   (((v) << 31) & BM_DRI_DEBUG0_DMAREQ)
#endif

//--- Register HW_DRI_DEBUG0, field DMACMDKICK

#define BP_DRI_DEBUG0_DMACMDKICK      30
#define BM_DRI_DEBUG0_DMACMDKICK      0x40000000

#define BF_DRI_DEBUG0_DMACMDKICK(v)   (((v) << 30) & BM_DRI_DEBUG0_DMACMDKICK)

//--- Register HW_DRI_DEBUG0, field DRI_CLK_INPUT

#define BP_DRI_DEBUG0_DRI_CLK_INPUT      29
#define BM_DRI_DEBUG0_DRI_CLK_INPUT      0x20000000

#define BF_DRI_DEBUG0_DRI_CLK_INPUT(v)   (((v) << 29) & BM_DRI_DEBUG0_DRI_CLK_INPUT)

//--- Register HW_DRI_DEBUG0, field DRI_DATA_INPUT

#define BP_DRI_DEBUG0_DRI_DATA_INPUT      28
#define BM_DRI_DEBUG0_DRI_DATA_INPUT      0x10000000

#define BF_DRI_DEBUG0_DRI_DATA_INPUT(v)   (((v) << 28) & BM_DRI_DEBUG0_DRI_DATA_INPUT)

//--- Register HW_DRI_DEBUG0, field TEST_MODE

#define BP_DRI_DEBUG0_TEST_MODE      27
#define BM_DRI_DEBUG0_TEST_MODE      0x08000000

#define BF_DRI_DEBUG0_TEST_MODE(v)   (((v) << 27) & BM_DRI_DEBUG0_TEST_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_DEBUG0_TEST_MODE(v)   BF_CS1(DRI_DEBUG0, TEST_MODE, v)
#endif

//--- Register HW_DRI_DEBUG0, field PILOT_REP_RATE

#define BP_DRI_DEBUG0_PILOT_REP_RATE      26
#define BM_DRI_DEBUG0_PILOT_REP_RATE      0x04000000

#define BF_DRI_DEBUG0_PILOT_REP_RATE(v)   (((v) << 26) & BM_DRI_DEBUG0_PILOT_REP_RATE)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_DEBUG0_PILOT_REP_RATE(v)   BF_CS1(DRI_DEBUG0, PILOT_REP_RATE, v)
#endif

#define BV_DRI_DEBUG0_PILOT_REP_RATE__8_AT_4MHZ   0x0
#define BV_DRI_DEBUG0_PILOT_REP_RATE__12_AT_6MHZ  0x1

//--- Register HW_DRI_DEBUG0, field SPARE

#define BP_DRI_DEBUG0_SPARE      18
#define BM_DRI_DEBUG0_SPARE      0x03FC0000

#define BF_DRI_DEBUG0_SPARE(v)   (((v) << 18) & BM_DRI_DEBUG0_SPARE)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_DEBUG0_SPARE(v)   BF_CS1(DRI_DEBUG0, SPARE, v)
#endif

//--- Register HW_DRI_DEBUG0, field FRAME

#define BP_DRI_DEBUG0_FRAME      0
#define BM_DRI_DEBUG0_FRAME      0x0003FFFF

#define BF_DRI_DEBUG0_FRAME(v)   (((v) << 0) & BM_DRI_DEBUG0_FRAME)


////////////////////////////////////////////////////////////////////////////////
//// HW_DRI_DEBUG1 - DRI Device Debug Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SWIZZLED_FRAME    : 18;
        unsigned RSVD1             :  9;
        unsigned REVERSE_FRAME     :  1;
        unsigned INVERT_DRI_CLOCK  :  1;
        unsigned INVERT_DRI_DATA   :  1;
        unsigned INVERT_ATTENTION  :  1;
        unsigned INVERT_PILOT      :  1;
    } B;
} hw_dri_debug1_t;
#endif


//
// constants & macros for entire HW_DRI_DEBUG1 register
//

#define HW_DRI_DEBUG1_ADDR      (REGS_DRI_BASE + 0x00000050)
#define HW_DRI_DEBUG1_SET_ADDR  (REGS_DRI_BASE + 0x00000054)
#define HW_DRI_DEBUG1_CLR_ADDR  (REGS_DRI_BASE + 0x00000058)
#define HW_DRI_DEBUG1_TOG_ADDR  (REGS_DRI_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_DRI_DEBUG1           (*(volatile hw_dri_debug1_t *) HW_DRI_DEBUG1_ADDR)
#define HW_DRI_DEBUG1_RD()      (HW_DRI_DEBUG1.U)
#define HW_DRI_DEBUG1_WR(v)     (HW_DRI_DEBUG1.U = (v))
#define HW_DRI_DEBUG1_SET(v)    ((*(volatile reg32_t *) HW_DRI_DEBUG1_SET_ADDR) = (v))
#define HW_DRI_DEBUG1_CLR(v)    ((*(volatile reg32_t *) HW_DRI_DEBUG1_CLR_ADDR) = (v))
#define HW_DRI_DEBUG1_TOG(v)    ((*(volatile reg32_t *) HW_DRI_DEBUG1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DRI_DEBUG1 bitfields
//

//--- Register HW_DRI_DEBUG1, field INVERT_PILOT

#define BP_DRI_DEBUG1_INVERT_PILOT      31
#define BM_DRI_DEBUG1_INVERT_PILOT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DRI_DEBUG1_INVERT_PILOT(v)   ((((reg32_t) v) << 31) & BM_DRI_DEBUG1_INVERT_PILOT)
#else
#define BF_DRI_DEBUG1_INVERT_PILOT(v)   (((v) << 31) & BM_DRI_DEBUG1_INVERT_PILOT)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRI_DEBUG1_INVERT_PILOT(v)   BF_CS1(DRI_DEBUG1, INVERT_PILOT, v)
#endif

#define BV_DRI_DEBUG1_INVERT_PILOT__NORMAL    0x0
#define BV_DRI_DEBUG1_INVERT_PILOT__INVERTED  0x1

//--- Register HW_DRI_DEBUG1, field INVERT_ATTENTION

#define BP_DRI_DEBUG1_INVERT_ATTENTION      30
#define BM_DRI_DEBUG1_INVERT_ATTENTION      0x40000000

#define BF_DRI_DEBUG1_INVERT_ATTENTION(v)   (((v) << 30) & BM_DRI_DEBUG1_INVERT_ATTENTION)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_DEBUG1_INVERT_ATTENTION(v)   BF_CS1(DRI_DEBUG1, INVERT_ATTENTION, v)
#endif

#define BV_DRI_DEBUG1_INVERT_ATTENTION__NORMAL    0x0
#define BV_DRI_DEBUG1_INVERT_ATTENTION__INVERTED  0x1

//--- Register HW_DRI_DEBUG1, field INVERT_DRI_DATA

#define BP_DRI_DEBUG1_INVERT_DRI_DATA      29
#define BM_DRI_DEBUG1_INVERT_DRI_DATA      0x20000000

#define BF_DRI_DEBUG1_INVERT_DRI_DATA(v)   (((v) << 29) & BM_DRI_DEBUG1_INVERT_DRI_DATA)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_DEBUG1_INVERT_DRI_DATA(v)   BF_CS1(DRI_DEBUG1, INVERT_DRI_DATA, v)
#endif

#define BV_DRI_DEBUG1_INVERT_DRI_DATA__NORMAL    0x0
#define BV_DRI_DEBUG1_INVERT_DRI_DATA__INVERTED  0x1

//--- Register HW_DRI_DEBUG1, field INVERT_DRI_CLOCK

#define BP_DRI_DEBUG1_INVERT_DRI_CLOCK      28
#define BM_DRI_DEBUG1_INVERT_DRI_CLOCK      0x10000000

#define BF_DRI_DEBUG1_INVERT_DRI_CLOCK(v)   (((v) << 28) & BM_DRI_DEBUG1_INVERT_DRI_CLOCK)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_DEBUG1_INVERT_DRI_CLOCK(v)   BF_CS1(DRI_DEBUG1, INVERT_DRI_CLOCK, v)
#endif

#define BV_DRI_DEBUG1_INVERT_DRI_CLOCK__NORMAL    0x0
#define BV_DRI_DEBUG1_INVERT_DRI_CLOCK__INVERTED  0x1

//--- Register HW_DRI_DEBUG1, field REVERSE_FRAME

#define BP_DRI_DEBUG1_REVERSE_FRAME      27
#define BM_DRI_DEBUG1_REVERSE_FRAME      0x08000000

#define BF_DRI_DEBUG1_REVERSE_FRAME(v)   (((v) << 27) & BM_DRI_DEBUG1_REVERSE_FRAME)

#ifndef __LANGUAGE_ASM__
#define BW_DRI_DEBUG1_REVERSE_FRAME(v)   BF_CS1(DRI_DEBUG1, REVERSE_FRAME, v)
#endif

#define BV_DRI_DEBUG1_REVERSE_FRAME__NORMAL    0x0
#define BV_DRI_DEBUG1_REVERSE_FRAME__REVERSED  0x1

//--- Register HW_DRI_DEBUG1, field SWIZZLED_FRAME

#define BP_DRI_DEBUG1_SWIZZLED_FRAME      0
#define BM_DRI_DEBUG1_SWIZZLED_FRAME      0x0003FFFF

#define BF_DRI_DEBUG1_SWIZZLED_FRAME(v)   (((v) << 0) & BM_DRI_DEBUG1_SWIZZLED_FRAME)


////////////////////////////////////////////////////////////////////////////////
//// HW_DRI_VERSION - DRI Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_dri_version_t;
#endif


//
// constants & macros for entire HW_DRI_VERSION register
//

#define HW_DRI_VERSION_ADDR      (REGS_DRI_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_DRI_VERSION           (*(volatile hw_dri_version_t *) HW_DRI_VERSION_ADDR)
#define HW_DRI_VERSION_RD()      (HW_DRI_VERSION.U)
#endif


//
// constants & macros for individual HW_DRI_VERSION bitfields
//

//--- Register HW_DRI_VERSION, field MAJOR

#define BP_DRI_VERSION_MAJOR      24
#define BM_DRI_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRI_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_DRI_VERSION_MAJOR)
#else
#define BF_DRI_VERSION_MAJOR(v)   (((v) << 24) & BM_DRI_VERSION_MAJOR)
#endif

//--- Register HW_DRI_VERSION, field MINOR

#define BP_DRI_VERSION_MINOR      16
#define BM_DRI_VERSION_MINOR      0x00FF0000

#define BF_DRI_VERSION_MINOR(v)   (((v) << 16) & BM_DRI_VERSION_MINOR)

//--- Register HW_DRI_VERSION, field STEP

#define BP_DRI_VERSION_STEP      0
#define BM_DRI_VERSION_STEP      0x0000FFFF

#define BF_DRI_VERSION_STEP(v)   (((v) << 0) & BM_DRI_VERSION_STEP)


#endif // _REGSDRI_H

////////////////////////////////////////////////////////////////////////////////
