/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSAUDIOIN_H
#define _REGSAUDIOIN_H  1

#include "regs.h"

#ifndef REGS_AUDIOIN_BASE
#define REGS_AUDIOIN_BASE (REGS_BASE + 0x0004C000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOIN_CTRL - AUDIOIN Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RUN                 :  1;
        unsigned FIFO_ERROR_IRQ_EN   :  1;
        unsigned FIFO_OVERFLOW_IRQ   :  1;
        unsigned FIFO_UNDERFLOW_IRQ  :  1;
        unsigned LOOPBACK            :  1;
        unsigned WORD_LENGTH         :  1;
        unsigned HPF_ENABLE          :  1;
        unsigned OFFSET_ENABLE       :  1;
        unsigned INVERT_1BIT         :  1;
        unsigned EDGE_SYNC           :  1;
        unsigned LR_SWAP             :  1;
        unsigned RSRVD1              :  5;
        unsigned DMAWAIT_COUNT       :  5;
        unsigned RSRVD3              :  9;
        unsigned CLKGATE             :  1;
        unsigned SFTRST              :  1;
    } B;
} hw_audioin_ctrl_t;
#endif


//
// constants & macros for entire HW_AUDIOIN_CTRL register
//

#define HW_AUDIOIN_CTRL_ADDR      (REGS_AUDIOIN_BASE + 0x00000000)
#define HW_AUDIOIN_CTRL_SET_ADDR  (REGS_AUDIOIN_BASE + 0x00000004)
#define HW_AUDIOIN_CTRL_CLR_ADDR  (REGS_AUDIOIN_BASE + 0x00000008)
#define HW_AUDIOIN_CTRL_TOG_ADDR  (REGS_AUDIOIN_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOIN_CTRL           (*(volatile hw_audioin_ctrl_t *) HW_AUDIOIN_CTRL_ADDR)
#define HW_AUDIOIN_CTRL_RD()      (HW_AUDIOIN_CTRL.U)
#define HW_AUDIOIN_CTRL_WR(v)     (HW_AUDIOIN_CTRL.U = (v))
#define HW_AUDIOIN_CTRL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOIN_CTRL_SET_ADDR) = (v))
#define HW_AUDIOIN_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOIN_CTRL_CLR_ADDR) = (v))
#define HW_AUDIOIN_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOIN_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOIN_CTRL bitfields
//

//--- Register HW_AUDIOIN_CTRL, field SFTRST

#define BP_AUDIOIN_CTRL_SFTRST      31
#define BM_AUDIOIN_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOIN_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_AUDIOIN_CTRL_SFTRST)
#else
#define BF_AUDIOIN_CTRL_SFTRST(v)   (((v) << 31) & BM_AUDIOIN_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_SFTRST(v)   BF_CS1(AUDIOIN_CTRL, SFTRST, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field CLKGATE

#define BP_AUDIOIN_CTRL_CLKGATE      30
#define BM_AUDIOIN_CTRL_CLKGATE      0x40000000

#define BF_AUDIOIN_CTRL_CLKGATE(v)   (((v) << 30) & BM_AUDIOIN_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_CLKGATE(v)   BF_CS1(AUDIOIN_CTRL, CLKGATE, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field DMAWAIT_COUNT

#define BP_AUDIOIN_CTRL_DMAWAIT_COUNT      16
#define BM_AUDIOIN_CTRL_DMAWAIT_COUNT      0x001F0000

#define BF_AUDIOIN_CTRL_DMAWAIT_COUNT(v)   (((v) << 16) & BM_AUDIOIN_CTRL_DMAWAIT_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_DMAWAIT_COUNT(v)   BF_CS1(AUDIOIN_CTRL, DMAWAIT_COUNT, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field LR_SWAP

#define BP_AUDIOIN_CTRL_LR_SWAP      10
#define BM_AUDIOIN_CTRL_LR_SWAP      0x00000400

#define BF_AUDIOIN_CTRL_LR_SWAP(v)   (((v) << 10) & BM_AUDIOIN_CTRL_LR_SWAP)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_LR_SWAP(v)   BF_CS1(AUDIOIN_CTRL, LR_SWAP, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field EDGE_SYNC

#define BP_AUDIOIN_CTRL_EDGE_SYNC      9
#define BM_AUDIOIN_CTRL_EDGE_SYNC      0x00000200

#define BF_AUDIOIN_CTRL_EDGE_SYNC(v)   (((v) << 9) & BM_AUDIOIN_CTRL_EDGE_SYNC)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_EDGE_SYNC(v)   BF_CS1(AUDIOIN_CTRL, EDGE_SYNC, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field INVERT_1BIT

#define BP_AUDIOIN_CTRL_INVERT_1BIT      8
#define BM_AUDIOIN_CTRL_INVERT_1BIT      0x00000100

#define BF_AUDIOIN_CTRL_INVERT_1BIT(v)   (((v) << 8) & BM_AUDIOIN_CTRL_INVERT_1BIT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_INVERT_1BIT(v)   BF_CS1(AUDIOIN_CTRL, INVERT_1BIT, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field OFFSET_ENABLE

#define BP_AUDIOIN_CTRL_OFFSET_ENABLE      7
#define BM_AUDIOIN_CTRL_OFFSET_ENABLE      0x00000080

#define BF_AUDIOIN_CTRL_OFFSET_ENABLE(v)   (((v) << 7) & BM_AUDIOIN_CTRL_OFFSET_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_OFFSET_ENABLE(v)   BF_CS1(AUDIOIN_CTRL, OFFSET_ENABLE, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field HPF_ENABLE

#define BP_AUDIOIN_CTRL_HPF_ENABLE      6
#define BM_AUDIOIN_CTRL_HPF_ENABLE      0x00000040

#define BF_AUDIOIN_CTRL_HPF_ENABLE(v)   (((v) << 6) & BM_AUDIOIN_CTRL_HPF_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_HPF_ENABLE(v)   BF_CS1(AUDIOIN_CTRL, HPF_ENABLE, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field WORD_LENGTH

#define BP_AUDIOIN_CTRL_WORD_LENGTH      5
#define BM_AUDIOIN_CTRL_WORD_LENGTH      0x00000020

#define BF_AUDIOIN_CTRL_WORD_LENGTH(v)   (((v) << 5) & BM_AUDIOIN_CTRL_WORD_LENGTH)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_WORD_LENGTH(v)   BF_CS1(AUDIOIN_CTRL, WORD_LENGTH, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field LOOPBACK

#define BP_AUDIOIN_CTRL_LOOPBACK      4
#define BM_AUDIOIN_CTRL_LOOPBACK      0x00000010

#define BF_AUDIOIN_CTRL_LOOPBACK(v)   (((v) << 4) & BM_AUDIOIN_CTRL_LOOPBACK)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_LOOPBACK(v)   BF_CS1(AUDIOIN_CTRL, LOOPBACK, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field FIFO_UNDERFLOW_IRQ

#define BP_AUDIOIN_CTRL_FIFO_UNDERFLOW_IRQ      3
#define BM_AUDIOIN_CTRL_FIFO_UNDERFLOW_IRQ      0x00000008

#define BF_AUDIOIN_CTRL_FIFO_UNDERFLOW_IRQ(v)   (((v) << 3) & BM_AUDIOIN_CTRL_FIFO_UNDERFLOW_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_FIFO_UNDERFLOW_IRQ(v)   BF_CS1(AUDIOIN_CTRL, FIFO_UNDERFLOW_IRQ, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field FIFO_OVERFLOW_IRQ

#define BP_AUDIOIN_CTRL_FIFO_OVERFLOW_IRQ      2
#define BM_AUDIOIN_CTRL_FIFO_OVERFLOW_IRQ      0x00000004

#define BF_AUDIOIN_CTRL_FIFO_OVERFLOW_IRQ(v)   (((v) << 2) & BM_AUDIOIN_CTRL_FIFO_OVERFLOW_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_FIFO_OVERFLOW_IRQ(v)   BF_CS1(AUDIOIN_CTRL, FIFO_OVERFLOW_IRQ, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field FIFO_ERROR_IRQ_EN

#define BP_AUDIOIN_CTRL_FIFO_ERROR_IRQ_EN      1
#define BM_AUDIOIN_CTRL_FIFO_ERROR_IRQ_EN      0x00000002

#define BF_AUDIOIN_CTRL_FIFO_ERROR_IRQ_EN(v)   (((v) << 1) & BM_AUDIOIN_CTRL_FIFO_ERROR_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_FIFO_ERROR_IRQ_EN(v)   BF_CS1(AUDIOIN_CTRL, FIFO_ERROR_IRQ_EN, v)
#endif

//--- Register HW_AUDIOIN_CTRL, field RUN

#define BP_AUDIOIN_CTRL_RUN      0
#define BM_AUDIOIN_CTRL_RUN      0x00000001

#define BF_AUDIOIN_CTRL_RUN(v)   (((v) << 0) & BM_AUDIOIN_CTRL_RUN)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_CTRL_RUN(v)   BF_CS1(AUDIOIN_CTRL, RUN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOIN_STAT - AUDIOIN Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD3       : 31;
        unsigned ADC_PRESENT  :  1;
    } B;
} hw_audioin_stat_t;
#endif


//
// constants & macros for entire HW_AUDIOIN_STAT register
//

#define HW_AUDIOIN_STAT_ADDR      (REGS_AUDIOIN_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOIN_STAT           (*(volatile hw_audioin_stat_t *) HW_AUDIOIN_STAT_ADDR)
#define HW_AUDIOIN_STAT_RD()      (HW_AUDIOIN_STAT.U)
#endif


//
// constants & macros for individual HW_AUDIOIN_STAT bitfields
//

//--- Register HW_AUDIOIN_STAT, field ADC_PRESENT

#define BP_AUDIOIN_STAT_ADC_PRESENT      31
#define BM_AUDIOIN_STAT_ADC_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOIN_STAT_ADC_PRESENT(v)   ((((reg32_t) v) << 31) & BM_AUDIOIN_STAT_ADC_PRESENT)
#else
#define BF_AUDIOIN_STAT_ADC_PRESENT(v)   (((v) << 31) & BM_AUDIOIN_STAT_ADC_PRESENT)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOIN_ADCSRR - AUDIOIN Sample Rate Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SRC_FRAC  : 13;
        unsigned RSRVD0    :  3;
        unsigned SRC_INT   :  5;
        unsigned RSRVD1    :  3;
        unsigned SRC_HOLD  :  3;
        unsigned RSRVD2    :  1;
        unsigned BASEMULT  :  3;
        unsigned OSR       :  1;
    } B;
} hw_audioin_adcsrr_t;
#endif


//
// constants & macros for entire HW_AUDIOIN_ADCSRR register
//

#define HW_AUDIOIN_ADCSRR_ADDR      (REGS_AUDIOIN_BASE + 0x00000020)
#define HW_AUDIOIN_ADCSRR_SET_ADDR  (REGS_AUDIOIN_BASE + 0x00000024)
#define HW_AUDIOIN_ADCSRR_CLR_ADDR  (REGS_AUDIOIN_BASE + 0x00000028)
#define HW_AUDIOIN_ADCSRR_TOG_ADDR  (REGS_AUDIOIN_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOIN_ADCSRR           (*(volatile hw_audioin_adcsrr_t *) HW_AUDIOIN_ADCSRR_ADDR)
#define HW_AUDIOIN_ADCSRR_RD()      (HW_AUDIOIN_ADCSRR.U)
#define HW_AUDIOIN_ADCSRR_WR(v)     (HW_AUDIOIN_ADCSRR.U = (v))
#define HW_AUDIOIN_ADCSRR_SET(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCSRR_SET_ADDR) = (v))
#define HW_AUDIOIN_ADCSRR_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCSRR_CLR_ADDR) = (v))
#define HW_AUDIOIN_ADCSRR_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCSRR_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOIN_ADCSRR bitfields
//

//--- Register HW_AUDIOIN_ADCSRR, field OSR

#define BP_AUDIOIN_ADCSRR_OSR      31
#define BM_AUDIOIN_ADCSRR_OSR      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOIN_ADCSRR_OSR(v)   ((((reg32_t) v) << 31) & BM_AUDIOIN_ADCSRR_OSR)
#else
#define BF_AUDIOIN_ADCSRR_OSR(v)   (((v) << 31) & BM_AUDIOIN_ADCSRR_OSR)
#endif

#define BV_AUDIOIN_ADCSRR_OSR__OSR6   0x0
#define BV_AUDIOIN_ADCSRR_OSR__OSR12  0x1

//--- Register HW_AUDIOIN_ADCSRR, field BASEMULT

#define BP_AUDIOIN_ADCSRR_BASEMULT      28
#define BM_AUDIOIN_ADCSRR_BASEMULT      0x70000000

#define BF_AUDIOIN_ADCSRR_BASEMULT(v)   (((v) << 28) & BM_AUDIOIN_ADCSRR_BASEMULT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCSRR_BASEMULT(v)   BF_CS1(AUDIOIN_ADCSRR, BASEMULT, v)
#endif

#define BV_AUDIOIN_ADCSRR_BASEMULT__SINGLE_RATE  0x1
#define BV_AUDIOIN_ADCSRR_BASEMULT__DOUBLE_RATE  0x2
#define BV_AUDIOIN_ADCSRR_BASEMULT__QUAD_RATE    0x4

//--- Register HW_AUDIOIN_ADCSRR, field SRC_HOLD

#define BP_AUDIOIN_ADCSRR_SRC_HOLD      24
#define BM_AUDIOIN_ADCSRR_SRC_HOLD      0x07000000

#define BF_AUDIOIN_ADCSRR_SRC_HOLD(v)   (((v) << 24) & BM_AUDIOIN_ADCSRR_SRC_HOLD)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCSRR_SRC_HOLD(v)   BF_CS1(AUDIOIN_ADCSRR, SRC_HOLD, v)
#endif

//--- Register HW_AUDIOIN_ADCSRR, field SRC_INT

#define BP_AUDIOIN_ADCSRR_SRC_INT      16
#define BM_AUDIOIN_ADCSRR_SRC_INT      0x001F0000

#define BF_AUDIOIN_ADCSRR_SRC_INT(v)   (((v) << 16) & BM_AUDIOIN_ADCSRR_SRC_INT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCSRR_SRC_INT(v)   BF_CS1(AUDIOIN_ADCSRR, SRC_INT, v)
#endif

//--- Register HW_AUDIOIN_ADCSRR, field SRC_FRAC

#define BP_AUDIOIN_ADCSRR_SRC_FRAC      0
#define BM_AUDIOIN_ADCSRR_SRC_FRAC      0x00001FFF

#define BF_AUDIOIN_ADCSRR_SRC_FRAC(v)   (((v) << 0) & BM_AUDIOIN_ADCSRR_SRC_FRAC)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCSRR_SRC_FRAC(v)   BF_CS1(AUDIOIN_ADCSRR, SRC_FRAC, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOIN_ADCVOLUME - AUDIOIN Volume Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   VOLUME_RIGHT;
        unsigned RSRVD1               :  4;
        unsigned VOLUME_UPDATE_RIGHT  :  1;
        unsigned RSRVD2               :  3;
        reg8_t   VOLUME_LEFT;
        unsigned RSRVD3               :  1;
        unsigned EN_ZCD               :  1;
        unsigned RSRVD4               :  2;
        unsigned VOLUME_UPDATE_LEFT   :  1;
        unsigned RSRVD5               :  3;
    } B;
} hw_audioin_adcvolume_t;
#endif


//
// constants & macros for entire HW_AUDIOIN_ADCVOLUME register
//

#define HW_AUDIOIN_ADCVOLUME_ADDR      (REGS_AUDIOIN_BASE + 0x00000030)
#define HW_AUDIOIN_ADCVOLUME_SET_ADDR  (REGS_AUDIOIN_BASE + 0x00000034)
#define HW_AUDIOIN_ADCVOLUME_CLR_ADDR  (REGS_AUDIOIN_BASE + 0x00000038)
#define HW_AUDIOIN_ADCVOLUME_TOG_ADDR  (REGS_AUDIOIN_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOIN_ADCVOLUME           (*(volatile hw_audioin_adcvolume_t *) HW_AUDIOIN_ADCVOLUME_ADDR)
#define HW_AUDIOIN_ADCVOLUME_RD()      (HW_AUDIOIN_ADCVOLUME.U)
#define HW_AUDIOIN_ADCVOLUME_WR(v)     (HW_AUDIOIN_ADCVOLUME.U = (v))
#define HW_AUDIOIN_ADCVOLUME_SET(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCVOLUME_SET_ADDR) = (v))
#define HW_AUDIOIN_ADCVOLUME_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCVOLUME_CLR_ADDR) = (v))
#define HW_AUDIOIN_ADCVOLUME_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCVOLUME_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOIN_ADCVOLUME bitfields
//

//--- Register HW_AUDIOIN_ADCVOLUME, field VOLUME_UPDATE_LEFT

#define BP_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_LEFT      28
#define BM_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_LEFT      0x10000000

#define BF_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_LEFT(v)   (((v) << 28) & BM_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_LEFT)

//--- Register HW_AUDIOIN_ADCVOLUME, field EN_ZCD

#define BP_AUDIOIN_ADCVOLUME_EN_ZCD      25
#define BM_AUDIOIN_ADCVOLUME_EN_ZCD      0x02000000

#define BF_AUDIOIN_ADCVOLUME_EN_ZCD(v)   (((v) << 25) & BM_AUDIOIN_ADCVOLUME_EN_ZCD)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCVOLUME_EN_ZCD(v)   BF_CS1(AUDIOIN_ADCVOLUME, EN_ZCD, v)
#endif

//--- Register HW_AUDIOIN_ADCVOLUME, field VOLUME_LEFT

#define BP_AUDIOIN_ADCVOLUME_VOLUME_LEFT      16
#define BM_AUDIOIN_ADCVOLUME_VOLUME_LEFT      0x00FF0000

#define BF_AUDIOIN_ADCVOLUME_VOLUME_LEFT(v)   (((v) << 16) & BM_AUDIOIN_ADCVOLUME_VOLUME_LEFT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCVOLUME_VOLUME_LEFT(v)   (HW_AUDIOIN_ADCVOLUME.B.VOLUME_LEFT = (v))
#endif

//--- Register HW_AUDIOIN_ADCVOLUME, field VOLUME_UPDATE_RIGHT

#define BP_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_RIGHT      12
#define BM_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_RIGHT      0x00001000

#define BF_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_RIGHT(v)   (((v) << 12) & BM_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_RIGHT)

//--- Register HW_AUDIOIN_ADCVOLUME, field VOLUME_RIGHT

#define BP_AUDIOIN_ADCVOLUME_VOLUME_RIGHT      0
#define BM_AUDIOIN_ADCVOLUME_VOLUME_RIGHT      0x000000FF

#define BF_AUDIOIN_ADCVOLUME_VOLUME_RIGHT(v)   (((v) << 0) & BM_AUDIOIN_ADCVOLUME_VOLUME_RIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCVOLUME_VOLUME_RIGHT(v)   (HW_AUDIOIN_ADCVOLUME.B.VOLUME_RIGHT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOIN_ADCDEBUG - AUDIOIN Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FIFO_STATUS                       :  1;
        unsigned DMA_PREQ                          :  1;
        unsigned SET_INTERRUPT3_HAND_SHAKE         :  1;
        unsigned ADC_DMA_REQ_HAND_SHAKE_CLK_CROSS  :  1;
        unsigned RSRVD1                            : 27;
        unsigned ENABLE_ADCDMA                     :  1;
    } B;
} hw_audioin_adcdebug_t;
#endif


//
// constants & macros for entire HW_AUDIOIN_ADCDEBUG register
//

#define HW_AUDIOIN_ADCDEBUG_ADDR      (REGS_AUDIOIN_BASE + 0x00000040)
#define HW_AUDIOIN_ADCDEBUG_SET_ADDR  (REGS_AUDIOIN_BASE + 0x00000044)
#define HW_AUDIOIN_ADCDEBUG_CLR_ADDR  (REGS_AUDIOIN_BASE + 0x00000048)
#define HW_AUDIOIN_ADCDEBUG_TOG_ADDR  (REGS_AUDIOIN_BASE + 0x0000004C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOIN_ADCDEBUG           (*(volatile hw_audioin_adcdebug_t *) HW_AUDIOIN_ADCDEBUG_ADDR)
#define HW_AUDIOIN_ADCDEBUG_RD()      (HW_AUDIOIN_ADCDEBUG.U)
#define HW_AUDIOIN_ADCDEBUG_WR(v)     (HW_AUDIOIN_ADCDEBUG.U = (v))
#define HW_AUDIOIN_ADCDEBUG_SET(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCDEBUG_SET_ADDR) = (v))
#define HW_AUDIOIN_ADCDEBUG_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCDEBUG_CLR_ADDR) = (v))
#define HW_AUDIOIN_ADCDEBUG_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCDEBUG_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOIN_ADCDEBUG bitfields
//

//--- Register HW_AUDIOIN_ADCDEBUG, field ENABLE_ADCDMA

#define BP_AUDIOIN_ADCDEBUG_ENABLE_ADCDMA      31
#define BM_AUDIOIN_ADCDEBUG_ENABLE_ADCDMA      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOIN_ADCDEBUG_ENABLE_ADCDMA(v)   ((((reg32_t) v) << 31) & BM_AUDIOIN_ADCDEBUG_ENABLE_ADCDMA)
#else
#define BF_AUDIOIN_ADCDEBUG_ENABLE_ADCDMA(v)   (((v) << 31) & BM_AUDIOIN_ADCDEBUG_ENABLE_ADCDMA)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCDEBUG_ENABLE_ADCDMA(v)   BF_CS1(AUDIOIN_ADCDEBUG, ENABLE_ADCDMA, v)
#endif

//--- Register HW_AUDIOIN_ADCDEBUG, field ADC_DMA_REQ_HAND_SHAKE_CLK_CROSS

#define BP_AUDIOIN_ADCDEBUG_ADC_DMA_REQ_HAND_SHAKE_CLK_CROSS      3
#define BM_AUDIOIN_ADCDEBUG_ADC_DMA_REQ_HAND_SHAKE_CLK_CROSS      0x00000008

#define BF_AUDIOIN_ADCDEBUG_ADC_DMA_REQ_HAND_SHAKE_CLK_CROSS(v)   (((v) << 3) & BM_AUDIOIN_ADCDEBUG_ADC_DMA_REQ_HAND_SHAKE_CLK_CROSS)

//--- Register HW_AUDIOIN_ADCDEBUG, field SET_INTERRUPT3_HAND_SHAKE

#define BP_AUDIOIN_ADCDEBUG_SET_INTERRUPT3_HAND_SHAKE      2
#define BM_AUDIOIN_ADCDEBUG_SET_INTERRUPT3_HAND_SHAKE      0x00000004

#define BF_AUDIOIN_ADCDEBUG_SET_INTERRUPT3_HAND_SHAKE(v)   (((v) << 2) & BM_AUDIOIN_ADCDEBUG_SET_INTERRUPT3_HAND_SHAKE)

//--- Register HW_AUDIOIN_ADCDEBUG, field DMA_PREQ

#define BP_AUDIOIN_ADCDEBUG_DMA_PREQ      1
#define BM_AUDIOIN_ADCDEBUG_DMA_PREQ      0x00000002

#define BF_AUDIOIN_ADCDEBUG_DMA_PREQ(v)   (((v) << 1) & BM_AUDIOIN_ADCDEBUG_DMA_PREQ)

//--- Register HW_AUDIOIN_ADCDEBUG, field FIFO_STATUS

#define BP_AUDIOIN_ADCDEBUG_FIFO_STATUS      0
#define BM_AUDIOIN_ADCDEBUG_FIFO_STATUS      0x00000001

#define BF_AUDIOIN_ADCDEBUG_FIFO_STATUS(v)   (((v) << 0) & BM_AUDIOIN_ADCDEBUG_FIFO_STATUS)


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOIN_ADCVOL - ADC Mux Volume and Select Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned GAIN_RIGHT             :  4;
        unsigned SELECT_RIGHT           :  2;
        unsigned RSRVD1                 :  2;
        unsigned GAIN_LEFT              :  4;
        unsigned SELECT_LEFT            :  2;
        unsigned RSRVD2                 : 10;
        unsigned MUTE                   :  1;
        unsigned EN_ADC_ZCD             :  1;
        unsigned RSRVD3                 :  2;
        unsigned VOLUME_UPDATE_PENDING  :  1;
        unsigned RSRVD4                 :  3;
    } B;
} hw_audioin_adcvol_t;
#endif


//
// constants & macros for entire HW_AUDIOIN_ADCVOL register
//

#define HW_AUDIOIN_ADCVOL_ADDR      (REGS_AUDIOIN_BASE + 0x00000050)
#define HW_AUDIOIN_ADCVOL_SET_ADDR  (REGS_AUDIOIN_BASE + 0x00000054)
#define HW_AUDIOIN_ADCVOL_CLR_ADDR  (REGS_AUDIOIN_BASE + 0x00000058)
#define HW_AUDIOIN_ADCVOL_TOG_ADDR  (REGS_AUDIOIN_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOIN_ADCVOL           (*(volatile hw_audioin_adcvol_t *) HW_AUDIOIN_ADCVOL_ADDR)
#define HW_AUDIOIN_ADCVOL_RD()      (HW_AUDIOIN_ADCVOL.U)
#define HW_AUDIOIN_ADCVOL_WR(v)     (HW_AUDIOIN_ADCVOL.U = (v))
#define HW_AUDIOIN_ADCVOL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCVOL_SET_ADDR) = (v))
#define HW_AUDIOIN_ADCVOL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCVOL_CLR_ADDR) = (v))
#define HW_AUDIOIN_ADCVOL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ADCVOL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOIN_ADCVOL bitfields
//

//--- Register HW_AUDIOIN_ADCVOL, field VOLUME_UPDATE_PENDING

#define BP_AUDIOIN_ADCVOL_VOLUME_UPDATE_PENDING      28
#define BM_AUDIOIN_ADCVOL_VOLUME_UPDATE_PENDING      0x10000000

#define BF_AUDIOIN_ADCVOL_VOLUME_UPDATE_PENDING(v)   (((v) << 28) & BM_AUDIOIN_ADCVOL_VOLUME_UPDATE_PENDING)

//--- Register HW_AUDIOIN_ADCVOL, field EN_ADC_ZCD

#define BP_AUDIOIN_ADCVOL_EN_ADC_ZCD      25
#define BM_AUDIOIN_ADCVOL_EN_ADC_ZCD      0x02000000

#define BF_AUDIOIN_ADCVOL_EN_ADC_ZCD(v)   (((v) << 25) & BM_AUDIOIN_ADCVOL_EN_ADC_ZCD)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCVOL_EN_ADC_ZCD(v)   BF_CS1(AUDIOIN_ADCVOL, EN_ADC_ZCD, v)
#endif

//--- Register HW_AUDIOIN_ADCVOL, field MUTE

#define BP_AUDIOIN_ADCVOL_MUTE      24
#define BM_AUDIOIN_ADCVOL_MUTE      0x01000000

#define BF_AUDIOIN_ADCVOL_MUTE(v)   (((v) << 24) & BM_AUDIOIN_ADCVOL_MUTE)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCVOL_MUTE(v)   BF_CS1(AUDIOIN_ADCVOL, MUTE, v)
#endif

//--- Register HW_AUDIOIN_ADCVOL, field SELECT_LEFT

#define BP_AUDIOIN_ADCVOL_SELECT_LEFT      12
#define BM_AUDIOIN_ADCVOL_SELECT_LEFT      0x00003000

#define BF_AUDIOIN_ADCVOL_SELECT_LEFT(v)   (((v) << 12) & BM_AUDIOIN_ADCVOL_SELECT_LEFT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCVOL_SELECT_LEFT(v)   BF_CS1(AUDIOIN_ADCVOL, SELECT_LEFT, v)
#endif

//--- Register HW_AUDIOIN_ADCVOL, field GAIN_LEFT

#define BP_AUDIOIN_ADCVOL_GAIN_LEFT      8
#define BM_AUDIOIN_ADCVOL_GAIN_LEFT      0x00000F00

#define BF_AUDIOIN_ADCVOL_GAIN_LEFT(v)   (((v) << 8) & BM_AUDIOIN_ADCVOL_GAIN_LEFT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCVOL_GAIN_LEFT(v)   BF_CS1(AUDIOIN_ADCVOL, GAIN_LEFT, v)
#endif

//--- Register HW_AUDIOIN_ADCVOL, field SELECT_RIGHT

#define BP_AUDIOIN_ADCVOL_SELECT_RIGHT      4
#define BM_AUDIOIN_ADCVOL_SELECT_RIGHT      0x00000030

#define BF_AUDIOIN_ADCVOL_SELECT_RIGHT(v)   (((v) << 4) & BM_AUDIOIN_ADCVOL_SELECT_RIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCVOL_SELECT_RIGHT(v)   BF_CS1(AUDIOIN_ADCVOL, SELECT_RIGHT, v)
#endif

//--- Register HW_AUDIOIN_ADCVOL, field GAIN_RIGHT

#define BP_AUDIOIN_ADCVOL_GAIN_RIGHT      0
#define BM_AUDIOIN_ADCVOL_GAIN_RIGHT      0x0000000F

#define BF_AUDIOIN_ADCVOL_GAIN_RIGHT(v)   (((v) << 0) & BM_AUDIOIN_ADCVOL_GAIN_RIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ADCVOL_GAIN_RIGHT(v)   BF_CS1(AUDIOIN_ADCVOL, GAIN_RIGHT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOIN_MICLINE - Microphone and Line Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIC_GAIN      :  2;
        unsigned RSRVD1        :  2;
        unsigned MIC_CHOPCLK   :  2;
        unsigned RSRVD2        : 10;
        unsigned MIC_BIAS      :  3;
        unsigned RSRVD3        :  1;
        unsigned MIC_RESISTOR  :  2;
        unsigned RSRVD4        :  2;
        unsigned MIC_SELECT    :  1;
        unsigned RSRVD5        :  3;
        unsigned DIVIDE_LINE2  :  1;
        unsigned DIVIDE_LINE1  :  1;
        unsigned RSRVD6        :  2;
    } B;
} hw_audioin_micline_t;
#endif


//
// constants & macros for entire HW_AUDIOIN_MICLINE register
//

#define HW_AUDIOIN_MICLINE_ADDR      (REGS_AUDIOIN_BASE + 0x00000060)
#define HW_AUDIOIN_MICLINE_SET_ADDR  (REGS_AUDIOIN_BASE + 0x00000064)
#define HW_AUDIOIN_MICLINE_CLR_ADDR  (REGS_AUDIOIN_BASE + 0x00000068)
#define HW_AUDIOIN_MICLINE_TOG_ADDR  (REGS_AUDIOIN_BASE + 0x0000006C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOIN_MICLINE           (*(volatile hw_audioin_micline_t *) HW_AUDIOIN_MICLINE_ADDR)
#define HW_AUDIOIN_MICLINE_RD()      (HW_AUDIOIN_MICLINE.U)
#define HW_AUDIOIN_MICLINE_WR(v)     (HW_AUDIOIN_MICLINE.U = (v))
#define HW_AUDIOIN_MICLINE_SET(v)    ((*(volatile reg32_t *) HW_AUDIOIN_MICLINE_SET_ADDR) = (v))
#define HW_AUDIOIN_MICLINE_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOIN_MICLINE_CLR_ADDR) = (v))
#define HW_AUDIOIN_MICLINE_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOIN_MICLINE_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOIN_MICLINE bitfields
//

//--- Register HW_AUDIOIN_MICLINE, field DIVIDE_LINE1

#define BP_AUDIOIN_MICLINE_DIVIDE_LINE1      29
#define BM_AUDIOIN_MICLINE_DIVIDE_LINE1      0x20000000

#define BF_AUDIOIN_MICLINE_DIVIDE_LINE1(v)   (((v) << 29) & BM_AUDIOIN_MICLINE_DIVIDE_LINE1)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_MICLINE_DIVIDE_LINE1(v)   BF_CS1(AUDIOIN_MICLINE, DIVIDE_LINE1, v)
#endif

//--- Register HW_AUDIOIN_MICLINE, field DIVIDE_LINE2

#define BP_AUDIOIN_MICLINE_DIVIDE_LINE2      28
#define BM_AUDIOIN_MICLINE_DIVIDE_LINE2      0x10000000

#define BF_AUDIOIN_MICLINE_DIVIDE_LINE2(v)   (((v) << 28) & BM_AUDIOIN_MICLINE_DIVIDE_LINE2)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_MICLINE_DIVIDE_LINE2(v)   BF_CS1(AUDIOIN_MICLINE, DIVIDE_LINE2, v)
#endif

//--- Register HW_AUDIOIN_MICLINE, field MIC_SELECT

#define BP_AUDIOIN_MICLINE_MIC_SELECT      24
#define BM_AUDIOIN_MICLINE_MIC_SELECT      0x01000000

#define BF_AUDIOIN_MICLINE_MIC_SELECT(v)   (((v) << 24) & BM_AUDIOIN_MICLINE_MIC_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_MICLINE_MIC_SELECT(v)   BF_CS1(AUDIOIN_MICLINE, MIC_SELECT, v)
#endif

//--- Register HW_AUDIOIN_MICLINE, field MIC_RESISTOR

#define BP_AUDIOIN_MICLINE_MIC_RESISTOR      20
#define BM_AUDIOIN_MICLINE_MIC_RESISTOR      0x00300000

#define BF_AUDIOIN_MICLINE_MIC_RESISTOR(v)   (((v) << 20) & BM_AUDIOIN_MICLINE_MIC_RESISTOR)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_MICLINE_MIC_RESISTOR(v)   BF_CS1(AUDIOIN_MICLINE, MIC_RESISTOR, v)
#endif

//--- Register HW_AUDIOIN_MICLINE, field MIC_BIAS

#define BP_AUDIOIN_MICLINE_MIC_BIAS      16
#define BM_AUDIOIN_MICLINE_MIC_BIAS      0x00070000

#define BF_AUDIOIN_MICLINE_MIC_BIAS(v)   (((v) << 16) & BM_AUDIOIN_MICLINE_MIC_BIAS)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_MICLINE_MIC_BIAS(v)   BF_CS1(AUDIOIN_MICLINE, MIC_BIAS, v)
#endif

//--- Register HW_AUDIOIN_MICLINE, field MIC_CHOPCLK

#define BP_AUDIOIN_MICLINE_MIC_CHOPCLK      4
#define BM_AUDIOIN_MICLINE_MIC_CHOPCLK      0x00000030

#define BF_AUDIOIN_MICLINE_MIC_CHOPCLK(v)   (((v) << 4) & BM_AUDIOIN_MICLINE_MIC_CHOPCLK)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_MICLINE_MIC_CHOPCLK(v)   BF_CS1(AUDIOIN_MICLINE, MIC_CHOPCLK, v)
#endif

//--- Register HW_AUDIOIN_MICLINE, field MIC_GAIN

#define BP_AUDIOIN_MICLINE_MIC_GAIN      0
#define BM_AUDIOIN_MICLINE_MIC_GAIN      0x00000003

#define BF_AUDIOIN_MICLINE_MIC_GAIN(v)   (((v) << 0) & BM_AUDIOIN_MICLINE_MIC_GAIN)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_MICLINE_MIC_GAIN(v)   BF_CS1(AUDIOIN_MICLINE, MIC_GAIN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOIN_ANACLKCTRL - Analog Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADCDIV         :  3;
        unsigned RSRVD2         :  1;
        unsigned ADCCLK_SHIFT   :  2;
        unsigned RSRVD3         :  2;
        unsigned INVERT_ADCCLK  :  1;
        unsigned SLOW_DITHER    :  1;
        unsigned DITHER_OFF     :  1;
        unsigned RSRVD4         : 20;
        unsigned CLKGATE        :  1;
    } B;
} hw_audioin_anaclkctrl_t;
#endif


//
// constants & macros for entire HW_AUDIOIN_ANACLKCTRL register
//

#define HW_AUDIOIN_ANACLKCTRL_ADDR      (REGS_AUDIOIN_BASE + 0x00000070)
#define HW_AUDIOIN_ANACLKCTRL_SET_ADDR  (REGS_AUDIOIN_BASE + 0x00000074)
#define HW_AUDIOIN_ANACLKCTRL_CLR_ADDR  (REGS_AUDIOIN_BASE + 0x00000078)
#define HW_AUDIOIN_ANACLKCTRL_TOG_ADDR  (REGS_AUDIOIN_BASE + 0x0000007C)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOIN_ANACLKCTRL           (*(volatile hw_audioin_anaclkctrl_t *) HW_AUDIOIN_ANACLKCTRL_ADDR)
#define HW_AUDIOIN_ANACLKCTRL_RD()      (HW_AUDIOIN_ANACLKCTRL.U)
#define HW_AUDIOIN_ANACLKCTRL_WR(v)     (HW_AUDIOIN_ANACLKCTRL.U = (v))
#define HW_AUDIOIN_ANACLKCTRL_SET(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ANACLKCTRL_SET_ADDR) = (v))
#define HW_AUDIOIN_ANACLKCTRL_CLR(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ANACLKCTRL_CLR_ADDR) = (v))
#define HW_AUDIOIN_ANACLKCTRL_TOG(v)    ((*(volatile reg32_t *) HW_AUDIOIN_ANACLKCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_AUDIOIN_ANACLKCTRL bitfields
//

//--- Register HW_AUDIOIN_ANACLKCTRL, field CLKGATE

#define BP_AUDIOIN_ANACLKCTRL_CLKGATE      31
#define BM_AUDIOIN_ANACLKCTRL_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOIN_ANACLKCTRL_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_AUDIOIN_ANACLKCTRL_CLKGATE)
#else
#define BF_AUDIOIN_ANACLKCTRL_CLKGATE(v)   (((v) << 31) & BM_AUDIOIN_ANACLKCTRL_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ANACLKCTRL_CLKGATE(v)   BF_CS1(AUDIOIN_ANACLKCTRL, CLKGATE, v)
#endif

//--- Register HW_AUDIOIN_ANACLKCTRL, field DITHER_OFF

#define BP_AUDIOIN_ANACLKCTRL_DITHER_OFF      10
#define BM_AUDIOIN_ANACLKCTRL_DITHER_OFF      0x00000400

#define BF_AUDIOIN_ANACLKCTRL_DITHER_OFF(v)   (((v) << 10) & BM_AUDIOIN_ANACLKCTRL_DITHER_OFF)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ANACLKCTRL_DITHER_OFF(v)   BF_CS1(AUDIOIN_ANACLKCTRL, DITHER_OFF, v)
#endif

//--- Register HW_AUDIOIN_ANACLKCTRL, field SLOW_DITHER

#define BP_AUDIOIN_ANACLKCTRL_SLOW_DITHER      9
#define BM_AUDIOIN_ANACLKCTRL_SLOW_DITHER      0x00000200

#define BF_AUDIOIN_ANACLKCTRL_SLOW_DITHER(v)   (((v) << 9) & BM_AUDIOIN_ANACLKCTRL_SLOW_DITHER)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ANACLKCTRL_SLOW_DITHER(v)   BF_CS1(AUDIOIN_ANACLKCTRL, SLOW_DITHER, v)
#endif

//--- Register HW_AUDIOIN_ANACLKCTRL, field INVERT_ADCCLK

#define BP_AUDIOIN_ANACLKCTRL_INVERT_ADCCLK      8
#define BM_AUDIOIN_ANACLKCTRL_INVERT_ADCCLK      0x00000100

#define BF_AUDIOIN_ANACLKCTRL_INVERT_ADCCLK(v)   (((v) << 8) & BM_AUDIOIN_ANACLKCTRL_INVERT_ADCCLK)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ANACLKCTRL_INVERT_ADCCLK(v)   BF_CS1(AUDIOIN_ANACLKCTRL, INVERT_ADCCLK, v)
#endif

//--- Register HW_AUDIOIN_ANACLKCTRL, field ADCCLK_SHIFT

#define BP_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT      4
#define BM_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT      0x00000030

#define BF_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT(v)   (((v) << 4) & BM_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT(v)   BF_CS1(AUDIOIN_ANACLKCTRL, ADCCLK_SHIFT, v)
#endif

//--- Register HW_AUDIOIN_ANACLKCTRL, field ADCDIV

#define BP_AUDIOIN_ANACLKCTRL_ADCDIV      0
#define BM_AUDIOIN_ANACLKCTRL_ADCDIV      0x00000007

#define BF_AUDIOIN_ANACLKCTRL_ADCDIV(v)   (((v) << 0) & BM_AUDIOIN_ANACLKCTRL_ADCDIV)

#ifndef __LANGUAGE_ASM__
#define BW_AUDIOIN_ANACLKCTRL_ADCDIV(v)   BF_CS1(AUDIOIN_ANACLKCTRL, ADCDIV, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_AUDIOIN_DATA - AUDIOIN Read Data Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  LOW;
        reg16_t  HIGH;
    } B;
} hw_audioin_data_t;
#endif


//
// constants & macros for entire HW_AUDIOIN_DATA register
//

#define HW_AUDIOIN_DATA_ADDR      (REGS_AUDIOIN_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_AUDIOIN_DATA           (*(volatile hw_audioin_data_t *) HW_AUDIOIN_DATA_ADDR)
#define HW_AUDIOIN_DATA_RD()      (HW_AUDIOIN_DATA.U)
#endif


//
// constants & macros for individual HW_AUDIOIN_DATA bitfields
//

//--- Register HW_AUDIOIN_DATA, field HIGH

#define BP_AUDIOIN_DATA_HIGH      16
#define BM_AUDIOIN_DATA_HIGH      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_AUDIOIN_DATA_HIGH(v)   ((((reg32_t) v) << 16) & BM_AUDIOIN_DATA_HIGH)
#else
#define BF_AUDIOIN_DATA_HIGH(v)   (((v) << 16) & BM_AUDIOIN_DATA_HIGH)
#endif

//--- Register HW_AUDIOIN_DATA, field LOW

#define BP_AUDIOIN_DATA_LOW      0
#define BM_AUDIOIN_DATA_LOW      0x0000FFFF

#define BF_AUDIOIN_DATA_LOW(v)   (((v) << 0) & BM_AUDIOIN_DATA_LOW)


#endif // _REGSAUDIOIN_H

////////////////////////////////////////////////////////////////////////////////
