/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSAPBX_H
#define _REGSAPBX_H  1

#include "regs.h"

#ifndef REGS_APBX_BASE
#define REGS_APBX_BASE (REGS_BASE + 0x00024000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_APBX_CTRL0 - AHB to APBX Bridge Control Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0    : 30;
        unsigned CLKGATE  :  1;
        unsigned SFTRST   :  1;
    } B;
} hw_apbx_ctrl0_t;
#endif


//
// constants & macros for entire HW_APBX_CTRL0 register
//

#define HW_APBX_CTRL0_ADDR      (REGS_APBX_BASE + 0x00000000)
#define HW_APBX_CTRL0_SET_ADDR  (REGS_APBX_BASE + 0x00000004)
#define HW_APBX_CTRL0_CLR_ADDR  (REGS_APBX_BASE + 0x00000008)
#define HW_APBX_CTRL0_TOG_ADDR  (REGS_APBX_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CTRL0           (*(volatile hw_apbx_ctrl0_t *) HW_APBX_CTRL0_ADDR)
#define HW_APBX_CTRL0_RD()      (HW_APBX_CTRL0.U)
#define HW_APBX_CTRL0_WR(v)     (HW_APBX_CTRL0.U = (v))
#define HW_APBX_CTRL0_SET(v)    ((*(volatile reg32_t *) HW_APBX_CTRL0_SET_ADDR) = (v))
#define HW_APBX_CTRL0_CLR(v)    ((*(volatile reg32_t *) HW_APBX_CTRL0_CLR_ADDR) = (v))
#define HW_APBX_CTRL0_TOG(v)    ((*(volatile reg32_t *) HW_APBX_CTRL0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_APBX_CTRL0 bitfields
//

//--- Register HW_APBX_CTRL0, field SFTRST

#define BP_APBX_CTRL0_SFTRST      31
#define BM_APBX_CTRL0_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CTRL0_SFTRST(v)   ((((reg32_t) v) << 31) & BM_APBX_CTRL0_SFTRST)
#else
#define BF_APBX_CTRL0_SFTRST(v)   (((v) << 31) & BM_APBX_CTRL0_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL0_SFTRST(v)   BF_CS1(APBX_CTRL0, SFTRST, v)
#endif

//--- Register HW_APBX_CTRL0, field CLKGATE

#define BP_APBX_CTRL0_CLKGATE      30
#define BM_APBX_CTRL0_CLKGATE      0x40000000

#define BF_APBX_CTRL0_CLKGATE(v)   (((v) << 30) & BM_APBX_CTRL0_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL0_CLKGATE(v)   BF_CS1(APBX_CTRL0, CLKGATE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_APBX_CTRL1 - AHB to APBX Bridge Control Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CH0_CMDCMPLT_IRQ      :  1;
        unsigned CH1_CMDCMPLT_IRQ      :  1;
        unsigned CH2_CMDCMPLT_IRQ      :  1;
        unsigned CH3_CMDCMPLT_IRQ      :  1;
        unsigned CH4_CMDCMPLT_IRQ      :  1;
        unsigned CH5_CMDCMPLT_IRQ      :  1;
        unsigned CH6_CMDCMPLT_IRQ      :  1;
        unsigned CH7_CMDCMPLT_IRQ      :  1;
        unsigned CH8_CMDCMPLT_IRQ      :  1;
        unsigned CH9_CMDCMPLT_IRQ      :  1;
        unsigned CH10_CMDCMPLT_IRQ     :  1;
        unsigned CH11_CMDCMPLT_IRQ     :  1;
        unsigned CH12_CMDCMPLT_IRQ     :  1;
        unsigned CH13_CMDCMPLT_IRQ     :  1;
        unsigned CH14_CMDCMPLT_IRQ     :  1;
        unsigned CH15_CMDCMPLT_IRQ     :  1;
        unsigned CH0_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH1_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH2_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH3_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH4_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH5_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH6_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH7_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH8_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH9_CMDCMPLT_IRQ_EN   :  1;
        unsigned CH10_CMDCMPLT_IRQ_EN  :  1;
        unsigned CH11_CMDCMPLT_IRQ_EN  :  1;
        unsigned CH12_CMDCMPLT_IRQ_EN  :  1;
        unsigned CH13_CMDCMPLT_IRQ_EN  :  1;
        unsigned CH14_CMDCMPLT_IRQ_EN  :  1;
        unsigned CH15_CMDCMPLT_IRQ_EN  :  1;
    } B;
} hw_apbx_ctrl1_t;
#endif


//
// constants & macros for entire HW_APBX_CTRL1 register
//

#define HW_APBX_CTRL1_ADDR      (REGS_APBX_BASE + 0x00000010)
#define HW_APBX_CTRL1_SET_ADDR  (REGS_APBX_BASE + 0x00000014)
#define HW_APBX_CTRL1_CLR_ADDR  (REGS_APBX_BASE + 0x00000018)
#define HW_APBX_CTRL1_TOG_ADDR  (REGS_APBX_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CTRL1           (*(volatile hw_apbx_ctrl1_t *) HW_APBX_CTRL1_ADDR)
#define HW_APBX_CTRL1_RD()      (HW_APBX_CTRL1.U)
#define HW_APBX_CTRL1_WR(v)     (HW_APBX_CTRL1.U = (v))
#define HW_APBX_CTRL1_SET(v)    ((*(volatile reg32_t *) HW_APBX_CTRL1_SET_ADDR) = (v))
#define HW_APBX_CTRL1_CLR(v)    ((*(volatile reg32_t *) HW_APBX_CTRL1_CLR_ADDR) = (v))
#define HW_APBX_CTRL1_TOG(v)    ((*(volatile reg32_t *) HW_APBX_CTRL1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_APBX_CTRL1 bitfields
//

//--- Register HW_APBX_CTRL1, field CH15_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH15_CMDCMPLT_IRQ_EN      31
#define BM_APBX_CTRL1_CH15_CMDCMPLT_IRQ_EN      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CTRL1_CH15_CMDCMPLT_IRQ_EN(v)   ((((reg32_t) v) << 31) & BM_APBX_CTRL1_CH15_CMDCMPLT_IRQ_EN)
#else
#define BF_APBX_CTRL1_CH15_CMDCMPLT_IRQ_EN(v)   (((v) << 31) & BM_APBX_CTRL1_CH15_CMDCMPLT_IRQ_EN)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH15_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH15_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH14_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH14_CMDCMPLT_IRQ_EN      30
#define BM_APBX_CTRL1_CH14_CMDCMPLT_IRQ_EN      0x40000000

#define BF_APBX_CTRL1_CH14_CMDCMPLT_IRQ_EN(v)   (((v) << 30) & BM_APBX_CTRL1_CH14_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH14_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH14_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH13_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH13_CMDCMPLT_IRQ_EN      29
#define BM_APBX_CTRL1_CH13_CMDCMPLT_IRQ_EN      0x20000000

#define BF_APBX_CTRL1_CH13_CMDCMPLT_IRQ_EN(v)   (((v) << 29) & BM_APBX_CTRL1_CH13_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH13_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH13_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH12_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH12_CMDCMPLT_IRQ_EN      28
#define BM_APBX_CTRL1_CH12_CMDCMPLT_IRQ_EN      0x10000000

#define BF_APBX_CTRL1_CH12_CMDCMPLT_IRQ_EN(v)   (((v) << 28) & BM_APBX_CTRL1_CH12_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH12_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH12_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH11_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH11_CMDCMPLT_IRQ_EN      27
#define BM_APBX_CTRL1_CH11_CMDCMPLT_IRQ_EN      0x08000000

#define BF_APBX_CTRL1_CH11_CMDCMPLT_IRQ_EN(v)   (((v) << 27) & BM_APBX_CTRL1_CH11_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH11_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH11_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH10_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH10_CMDCMPLT_IRQ_EN      26
#define BM_APBX_CTRL1_CH10_CMDCMPLT_IRQ_EN      0x04000000

#define BF_APBX_CTRL1_CH10_CMDCMPLT_IRQ_EN(v)   (((v) << 26) & BM_APBX_CTRL1_CH10_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH10_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH10_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH9_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH9_CMDCMPLT_IRQ_EN      25
#define BM_APBX_CTRL1_CH9_CMDCMPLT_IRQ_EN      0x02000000

#define BF_APBX_CTRL1_CH9_CMDCMPLT_IRQ_EN(v)   (((v) << 25) & BM_APBX_CTRL1_CH9_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH9_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH9_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH8_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH8_CMDCMPLT_IRQ_EN      24
#define BM_APBX_CTRL1_CH8_CMDCMPLT_IRQ_EN      0x01000000

#define BF_APBX_CTRL1_CH8_CMDCMPLT_IRQ_EN(v)   (((v) << 24) & BM_APBX_CTRL1_CH8_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH8_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH8_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH7_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH7_CMDCMPLT_IRQ_EN      23
#define BM_APBX_CTRL1_CH7_CMDCMPLT_IRQ_EN      0x00800000

#define BF_APBX_CTRL1_CH7_CMDCMPLT_IRQ_EN(v)   (((v) << 23) & BM_APBX_CTRL1_CH7_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH7_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH7_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH6_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH6_CMDCMPLT_IRQ_EN      22
#define BM_APBX_CTRL1_CH6_CMDCMPLT_IRQ_EN      0x00400000

#define BF_APBX_CTRL1_CH6_CMDCMPLT_IRQ_EN(v)   (((v) << 22) & BM_APBX_CTRL1_CH6_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH6_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH6_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH5_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH5_CMDCMPLT_IRQ_EN      21
#define BM_APBX_CTRL1_CH5_CMDCMPLT_IRQ_EN      0x00200000

#define BF_APBX_CTRL1_CH5_CMDCMPLT_IRQ_EN(v)   (((v) << 21) & BM_APBX_CTRL1_CH5_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH5_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH5_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH4_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH4_CMDCMPLT_IRQ_EN      20
#define BM_APBX_CTRL1_CH4_CMDCMPLT_IRQ_EN      0x00100000

#define BF_APBX_CTRL1_CH4_CMDCMPLT_IRQ_EN(v)   (((v) << 20) & BM_APBX_CTRL1_CH4_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH4_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH4_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH3_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH3_CMDCMPLT_IRQ_EN      19
#define BM_APBX_CTRL1_CH3_CMDCMPLT_IRQ_EN      0x00080000

#define BF_APBX_CTRL1_CH3_CMDCMPLT_IRQ_EN(v)   (((v) << 19) & BM_APBX_CTRL1_CH3_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH3_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH3_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH2_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH2_CMDCMPLT_IRQ_EN      18
#define BM_APBX_CTRL1_CH2_CMDCMPLT_IRQ_EN      0x00040000

#define BF_APBX_CTRL1_CH2_CMDCMPLT_IRQ_EN(v)   (((v) << 18) & BM_APBX_CTRL1_CH2_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH2_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH2_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH1_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH1_CMDCMPLT_IRQ_EN      17
#define BM_APBX_CTRL1_CH1_CMDCMPLT_IRQ_EN      0x00020000

#define BF_APBX_CTRL1_CH1_CMDCMPLT_IRQ_EN(v)   (((v) << 17) & BM_APBX_CTRL1_CH1_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH1_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH1_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH0_CMDCMPLT_IRQ_EN

#define BP_APBX_CTRL1_CH0_CMDCMPLT_IRQ_EN      16
#define BM_APBX_CTRL1_CH0_CMDCMPLT_IRQ_EN      0x00010000

#define BF_APBX_CTRL1_CH0_CMDCMPLT_IRQ_EN(v)   (((v) << 16) & BM_APBX_CTRL1_CH0_CMDCMPLT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH0_CMDCMPLT_IRQ_EN(v)   BF_CS1(APBX_CTRL1, CH0_CMDCMPLT_IRQ_EN, v)
#endif

//--- Register HW_APBX_CTRL1, field CH15_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH15_CMDCMPLT_IRQ      15
#define BM_APBX_CTRL1_CH15_CMDCMPLT_IRQ      0x00008000

#define BF_APBX_CTRL1_CH15_CMDCMPLT_IRQ(v)   (((v) << 15) & BM_APBX_CTRL1_CH15_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH15_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH15_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH14_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH14_CMDCMPLT_IRQ      14
#define BM_APBX_CTRL1_CH14_CMDCMPLT_IRQ      0x00004000

#define BF_APBX_CTRL1_CH14_CMDCMPLT_IRQ(v)   (((v) << 14) & BM_APBX_CTRL1_CH14_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH14_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH14_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH13_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH13_CMDCMPLT_IRQ      13
#define BM_APBX_CTRL1_CH13_CMDCMPLT_IRQ      0x00002000

#define BF_APBX_CTRL1_CH13_CMDCMPLT_IRQ(v)   (((v) << 13) & BM_APBX_CTRL1_CH13_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH13_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH13_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH12_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH12_CMDCMPLT_IRQ      12
#define BM_APBX_CTRL1_CH12_CMDCMPLT_IRQ      0x00001000

#define BF_APBX_CTRL1_CH12_CMDCMPLT_IRQ(v)   (((v) << 12) & BM_APBX_CTRL1_CH12_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH12_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH12_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH11_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH11_CMDCMPLT_IRQ      11
#define BM_APBX_CTRL1_CH11_CMDCMPLT_IRQ      0x00000800

#define BF_APBX_CTRL1_CH11_CMDCMPLT_IRQ(v)   (((v) << 11) & BM_APBX_CTRL1_CH11_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH11_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH11_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH10_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH10_CMDCMPLT_IRQ      10
#define BM_APBX_CTRL1_CH10_CMDCMPLT_IRQ      0x00000400

#define BF_APBX_CTRL1_CH10_CMDCMPLT_IRQ(v)   (((v) << 10) & BM_APBX_CTRL1_CH10_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH10_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH10_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH9_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH9_CMDCMPLT_IRQ      9
#define BM_APBX_CTRL1_CH9_CMDCMPLT_IRQ      0x00000200

#define BF_APBX_CTRL1_CH9_CMDCMPLT_IRQ(v)   (((v) << 9) & BM_APBX_CTRL1_CH9_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH9_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH9_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH8_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH8_CMDCMPLT_IRQ      8
#define BM_APBX_CTRL1_CH8_CMDCMPLT_IRQ      0x00000100

#define BF_APBX_CTRL1_CH8_CMDCMPLT_IRQ(v)   (((v) << 8) & BM_APBX_CTRL1_CH8_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH8_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH8_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH7_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH7_CMDCMPLT_IRQ      7
#define BM_APBX_CTRL1_CH7_CMDCMPLT_IRQ      0x00000080

#define BF_APBX_CTRL1_CH7_CMDCMPLT_IRQ(v)   (((v) << 7) & BM_APBX_CTRL1_CH7_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH7_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH7_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH6_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH6_CMDCMPLT_IRQ      6
#define BM_APBX_CTRL1_CH6_CMDCMPLT_IRQ      0x00000040

#define BF_APBX_CTRL1_CH6_CMDCMPLT_IRQ(v)   (((v) << 6) & BM_APBX_CTRL1_CH6_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH6_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH6_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH5_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH5_CMDCMPLT_IRQ      5
#define BM_APBX_CTRL1_CH5_CMDCMPLT_IRQ      0x00000020

#define BF_APBX_CTRL1_CH5_CMDCMPLT_IRQ(v)   (((v) << 5) & BM_APBX_CTRL1_CH5_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH5_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH5_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH4_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH4_CMDCMPLT_IRQ      4
#define BM_APBX_CTRL1_CH4_CMDCMPLT_IRQ      0x00000010

#define BF_APBX_CTRL1_CH4_CMDCMPLT_IRQ(v)   (((v) << 4) & BM_APBX_CTRL1_CH4_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH4_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH4_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH3_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH3_CMDCMPLT_IRQ      3
#define BM_APBX_CTRL1_CH3_CMDCMPLT_IRQ      0x00000008

#define BF_APBX_CTRL1_CH3_CMDCMPLT_IRQ(v)   (((v) << 3) & BM_APBX_CTRL1_CH3_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH3_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH3_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH2_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH2_CMDCMPLT_IRQ      2
#define BM_APBX_CTRL1_CH2_CMDCMPLT_IRQ      0x00000004

#define BF_APBX_CTRL1_CH2_CMDCMPLT_IRQ(v)   (((v) << 2) & BM_APBX_CTRL1_CH2_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH2_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH2_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH1_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH1_CMDCMPLT_IRQ      1
#define BM_APBX_CTRL1_CH1_CMDCMPLT_IRQ      0x00000002

#define BF_APBX_CTRL1_CH1_CMDCMPLT_IRQ(v)   (((v) << 1) & BM_APBX_CTRL1_CH1_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH1_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH1_CMDCMPLT_IRQ, v)
#endif

//--- Register HW_APBX_CTRL1, field CH0_CMDCMPLT_IRQ

#define BP_APBX_CTRL1_CH0_CMDCMPLT_IRQ      0
#define BM_APBX_CTRL1_CH0_CMDCMPLT_IRQ      0x00000001

#define BF_APBX_CTRL1_CH0_CMDCMPLT_IRQ(v)   (((v) << 0) & BM_APBX_CTRL1_CH0_CMDCMPLT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL1_CH0_CMDCMPLT_IRQ(v)   BF_CS1(APBX_CTRL1, CH0_CMDCMPLT_IRQ, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_APBX_CTRL2 - AHB to APBX Bridge Control and Status Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CH0_ERROR_IRQ      :  1;
        unsigned CH1_ERROR_IRQ      :  1;
        unsigned CH2_ERROR_IRQ      :  1;
        unsigned CH3_ERROR_IRQ      :  1;
        unsigned CH4_ERROR_IRQ      :  1;
        unsigned CH5_ERROR_IRQ      :  1;
        unsigned CH6_ERROR_IRQ      :  1;
        unsigned CH7_ERROR_IRQ      :  1;
        unsigned CH8_ERROR_IRQ      :  1;
        unsigned CH9_ERROR_IRQ      :  1;
        unsigned CH10_ERROR_IRQ     :  1;
        unsigned CH11_ERROR_IRQ     :  1;
        unsigned CH12_ERROR_IRQ     :  1;
        unsigned CH13_ERROR_IRQ     :  1;
        unsigned CH14_ERROR_IRQ     :  1;
        unsigned CH15_ERROR_IRQ     :  1;
        unsigned CH0_ERROR_STATUS   :  1;
        unsigned CH1_ERROR_STATUS   :  1;
        unsigned CH2_ERROR_STATUS   :  1;
        unsigned CH3_ERROR_STATUS   :  1;
        unsigned CH4_ERROR_STATUS   :  1;
        unsigned CH5_ERROR_STATUS   :  1;
        unsigned CH6_ERROR_STATUS   :  1;
        unsigned CH7_ERROR_STATUS   :  1;
        unsigned CH8_ERROR_STATUS   :  1;
        unsigned CH9_ERROR_STATUS   :  1;
        unsigned CH10_ERROR_STATUS  :  1;
        unsigned CH11_ERROR_STATUS  :  1;
        unsigned CH12_ERROR_STATUS  :  1;
        unsigned CH13_ERROR_STATUS  :  1;
        unsigned CH14_ERROR_STATUS  :  1;
        unsigned CH15_ERROR_STATUS  :  1;
    } B;
} hw_apbx_ctrl2_t;
#endif


//
// constants & macros for entire HW_APBX_CTRL2 register
//

#define HW_APBX_CTRL2_ADDR      (REGS_APBX_BASE + 0x00000020)
#define HW_APBX_CTRL2_SET_ADDR  (REGS_APBX_BASE + 0x00000024)
#define HW_APBX_CTRL2_CLR_ADDR  (REGS_APBX_BASE + 0x00000028)
#define HW_APBX_CTRL2_TOG_ADDR  (REGS_APBX_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CTRL2           (*(volatile hw_apbx_ctrl2_t *) HW_APBX_CTRL2_ADDR)
#define HW_APBX_CTRL2_RD()      (HW_APBX_CTRL2.U)
#define HW_APBX_CTRL2_WR(v)     (HW_APBX_CTRL2.U = (v))
#define HW_APBX_CTRL2_SET(v)    ((*(volatile reg32_t *) HW_APBX_CTRL2_SET_ADDR) = (v))
#define HW_APBX_CTRL2_CLR(v)    ((*(volatile reg32_t *) HW_APBX_CTRL2_CLR_ADDR) = (v))
#define HW_APBX_CTRL2_TOG(v)    ((*(volatile reg32_t *) HW_APBX_CTRL2_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_APBX_CTRL2 bitfields
//

//--- Register HW_APBX_CTRL2, field CH15_ERROR_STATUS

#define BP_APBX_CTRL2_CH15_ERROR_STATUS      31
#define BM_APBX_CTRL2_CH15_ERROR_STATUS      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CTRL2_CH15_ERROR_STATUS(v)   ((((reg32_t) v) << 31) & BM_APBX_CTRL2_CH15_ERROR_STATUS)
#else
#define BF_APBX_CTRL2_CH15_ERROR_STATUS(v)   (((v) << 31) & BM_APBX_CTRL2_CH15_ERROR_STATUS)
#endif

#define BV_APBX_CTRL2_CH15_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH15_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH14_ERROR_STATUS

#define BP_APBX_CTRL2_CH14_ERROR_STATUS      30
#define BM_APBX_CTRL2_CH14_ERROR_STATUS      0x40000000

#define BF_APBX_CTRL2_CH14_ERROR_STATUS(v)   (((v) << 30) & BM_APBX_CTRL2_CH14_ERROR_STATUS)

#define BV_APBX_CTRL2_CH14_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH14_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH13_ERROR_STATUS

#define BP_APBX_CTRL2_CH13_ERROR_STATUS      29
#define BM_APBX_CTRL2_CH13_ERROR_STATUS      0x20000000

#define BF_APBX_CTRL2_CH13_ERROR_STATUS(v)   (((v) << 29) & BM_APBX_CTRL2_CH13_ERROR_STATUS)

#define BV_APBX_CTRL2_CH13_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH13_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH12_ERROR_STATUS

#define BP_APBX_CTRL2_CH12_ERROR_STATUS      28
#define BM_APBX_CTRL2_CH12_ERROR_STATUS      0x10000000

#define BF_APBX_CTRL2_CH12_ERROR_STATUS(v)   (((v) << 28) & BM_APBX_CTRL2_CH12_ERROR_STATUS)

#define BV_APBX_CTRL2_CH12_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH12_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH11_ERROR_STATUS

#define BP_APBX_CTRL2_CH11_ERROR_STATUS      27
#define BM_APBX_CTRL2_CH11_ERROR_STATUS      0x08000000

#define BF_APBX_CTRL2_CH11_ERROR_STATUS(v)   (((v) << 27) & BM_APBX_CTRL2_CH11_ERROR_STATUS)

#define BV_APBX_CTRL2_CH11_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH11_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH10_ERROR_STATUS

#define BP_APBX_CTRL2_CH10_ERROR_STATUS      26
#define BM_APBX_CTRL2_CH10_ERROR_STATUS      0x04000000

#define BF_APBX_CTRL2_CH10_ERROR_STATUS(v)   (((v) << 26) & BM_APBX_CTRL2_CH10_ERROR_STATUS)

#define BV_APBX_CTRL2_CH10_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH10_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH9_ERROR_STATUS

#define BP_APBX_CTRL2_CH9_ERROR_STATUS      25
#define BM_APBX_CTRL2_CH9_ERROR_STATUS      0x02000000

#define BF_APBX_CTRL2_CH9_ERROR_STATUS(v)   (((v) << 25) & BM_APBX_CTRL2_CH9_ERROR_STATUS)

#define BV_APBX_CTRL2_CH9_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH9_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH8_ERROR_STATUS

#define BP_APBX_CTRL2_CH8_ERROR_STATUS      24
#define BM_APBX_CTRL2_CH8_ERROR_STATUS      0x01000000

#define BF_APBX_CTRL2_CH8_ERROR_STATUS(v)   (((v) << 24) & BM_APBX_CTRL2_CH8_ERROR_STATUS)

#define BV_APBX_CTRL2_CH8_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH8_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH7_ERROR_STATUS

#define BP_APBX_CTRL2_CH7_ERROR_STATUS      23
#define BM_APBX_CTRL2_CH7_ERROR_STATUS      0x00800000

#define BF_APBX_CTRL2_CH7_ERROR_STATUS(v)   (((v) << 23) & BM_APBX_CTRL2_CH7_ERROR_STATUS)

#define BV_APBX_CTRL2_CH7_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH7_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH6_ERROR_STATUS

#define BP_APBX_CTRL2_CH6_ERROR_STATUS      22
#define BM_APBX_CTRL2_CH6_ERROR_STATUS      0x00400000

#define BF_APBX_CTRL2_CH6_ERROR_STATUS(v)   (((v) << 22) & BM_APBX_CTRL2_CH6_ERROR_STATUS)

#define BV_APBX_CTRL2_CH6_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH6_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH5_ERROR_STATUS

#define BP_APBX_CTRL2_CH5_ERROR_STATUS      21
#define BM_APBX_CTRL2_CH5_ERROR_STATUS      0x00200000

#define BF_APBX_CTRL2_CH5_ERROR_STATUS(v)   (((v) << 21) & BM_APBX_CTRL2_CH5_ERROR_STATUS)

#define BV_APBX_CTRL2_CH5_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH5_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH4_ERROR_STATUS

#define BP_APBX_CTRL2_CH4_ERROR_STATUS      20
#define BM_APBX_CTRL2_CH4_ERROR_STATUS      0x00100000

#define BF_APBX_CTRL2_CH4_ERROR_STATUS(v)   (((v) << 20) & BM_APBX_CTRL2_CH4_ERROR_STATUS)

#define BV_APBX_CTRL2_CH4_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH4_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH3_ERROR_STATUS

#define BP_APBX_CTRL2_CH3_ERROR_STATUS      19
#define BM_APBX_CTRL2_CH3_ERROR_STATUS      0x00080000

#define BF_APBX_CTRL2_CH3_ERROR_STATUS(v)   (((v) << 19) & BM_APBX_CTRL2_CH3_ERROR_STATUS)

#define BV_APBX_CTRL2_CH3_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH3_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH2_ERROR_STATUS

#define BP_APBX_CTRL2_CH2_ERROR_STATUS      18
#define BM_APBX_CTRL2_CH2_ERROR_STATUS      0x00040000

#define BF_APBX_CTRL2_CH2_ERROR_STATUS(v)   (((v) << 18) & BM_APBX_CTRL2_CH2_ERROR_STATUS)

#define BV_APBX_CTRL2_CH2_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH2_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH1_ERROR_STATUS

#define BP_APBX_CTRL2_CH1_ERROR_STATUS      17
#define BM_APBX_CTRL2_CH1_ERROR_STATUS      0x00020000

#define BF_APBX_CTRL2_CH1_ERROR_STATUS(v)   (((v) << 17) & BM_APBX_CTRL2_CH1_ERROR_STATUS)

#define BV_APBX_CTRL2_CH1_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH1_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH0_ERROR_STATUS

#define BP_APBX_CTRL2_CH0_ERROR_STATUS      16
#define BM_APBX_CTRL2_CH0_ERROR_STATUS      0x00010000

#define BF_APBX_CTRL2_CH0_ERROR_STATUS(v)   (((v) << 16) & BM_APBX_CTRL2_CH0_ERROR_STATUS)

#define BV_APBX_CTRL2_CH0_ERROR_STATUS__TERMINATION  0x0
#define BV_APBX_CTRL2_CH0_ERROR_STATUS__BUS_ERROR    0x1

//--- Register HW_APBX_CTRL2, field CH15_ERROR_IRQ

#define BP_APBX_CTRL2_CH15_ERROR_IRQ      15
#define BM_APBX_CTRL2_CH15_ERROR_IRQ      0x00008000

#define BF_APBX_CTRL2_CH15_ERROR_IRQ(v)   (((v) << 15) & BM_APBX_CTRL2_CH15_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH15_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH15_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH14_ERROR_IRQ

#define BP_APBX_CTRL2_CH14_ERROR_IRQ      14
#define BM_APBX_CTRL2_CH14_ERROR_IRQ      0x00004000

#define BF_APBX_CTRL2_CH14_ERROR_IRQ(v)   (((v) << 14) & BM_APBX_CTRL2_CH14_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH14_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH14_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH13_ERROR_IRQ

#define BP_APBX_CTRL2_CH13_ERROR_IRQ      13
#define BM_APBX_CTRL2_CH13_ERROR_IRQ      0x00002000

#define BF_APBX_CTRL2_CH13_ERROR_IRQ(v)   (((v) << 13) & BM_APBX_CTRL2_CH13_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH13_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH13_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH12_ERROR_IRQ

#define BP_APBX_CTRL2_CH12_ERROR_IRQ      12
#define BM_APBX_CTRL2_CH12_ERROR_IRQ      0x00001000

#define BF_APBX_CTRL2_CH12_ERROR_IRQ(v)   (((v) << 12) & BM_APBX_CTRL2_CH12_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH12_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH12_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH11_ERROR_IRQ

#define BP_APBX_CTRL2_CH11_ERROR_IRQ      11
#define BM_APBX_CTRL2_CH11_ERROR_IRQ      0x00000800

#define BF_APBX_CTRL2_CH11_ERROR_IRQ(v)   (((v) << 11) & BM_APBX_CTRL2_CH11_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH11_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH11_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH10_ERROR_IRQ

#define BP_APBX_CTRL2_CH10_ERROR_IRQ      10
#define BM_APBX_CTRL2_CH10_ERROR_IRQ      0x00000400

#define BF_APBX_CTRL2_CH10_ERROR_IRQ(v)   (((v) << 10) & BM_APBX_CTRL2_CH10_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH10_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH10_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH9_ERROR_IRQ

#define BP_APBX_CTRL2_CH9_ERROR_IRQ      9
#define BM_APBX_CTRL2_CH9_ERROR_IRQ      0x00000200

#define BF_APBX_CTRL2_CH9_ERROR_IRQ(v)   (((v) << 9) & BM_APBX_CTRL2_CH9_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH9_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH9_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH8_ERROR_IRQ

#define BP_APBX_CTRL2_CH8_ERROR_IRQ      8
#define BM_APBX_CTRL2_CH8_ERROR_IRQ      0x00000100

#define BF_APBX_CTRL2_CH8_ERROR_IRQ(v)   (((v) << 8) & BM_APBX_CTRL2_CH8_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH8_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH8_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH7_ERROR_IRQ

#define BP_APBX_CTRL2_CH7_ERROR_IRQ      7
#define BM_APBX_CTRL2_CH7_ERROR_IRQ      0x00000080

#define BF_APBX_CTRL2_CH7_ERROR_IRQ(v)   (((v) << 7) & BM_APBX_CTRL2_CH7_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH7_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH7_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH6_ERROR_IRQ

#define BP_APBX_CTRL2_CH6_ERROR_IRQ      6
#define BM_APBX_CTRL2_CH6_ERROR_IRQ      0x00000040

#define BF_APBX_CTRL2_CH6_ERROR_IRQ(v)   (((v) << 6) & BM_APBX_CTRL2_CH6_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH6_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH6_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH5_ERROR_IRQ

#define BP_APBX_CTRL2_CH5_ERROR_IRQ      5
#define BM_APBX_CTRL2_CH5_ERROR_IRQ      0x00000020

#define BF_APBX_CTRL2_CH5_ERROR_IRQ(v)   (((v) << 5) & BM_APBX_CTRL2_CH5_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH5_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH5_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH4_ERROR_IRQ

#define BP_APBX_CTRL2_CH4_ERROR_IRQ      4
#define BM_APBX_CTRL2_CH4_ERROR_IRQ      0x00000010

#define BF_APBX_CTRL2_CH4_ERROR_IRQ(v)   (((v) << 4) & BM_APBX_CTRL2_CH4_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH4_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH4_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH3_ERROR_IRQ

#define BP_APBX_CTRL2_CH3_ERROR_IRQ      3
#define BM_APBX_CTRL2_CH3_ERROR_IRQ      0x00000008

#define BF_APBX_CTRL2_CH3_ERROR_IRQ(v)   (((v) << 3) & BM_APBX_CTRL2_CH3_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH3_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH3_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH2_ERROR_IRQ

#define BP_APBX_CTRL2_CH2_ERROR_IRQ      2
#define BM_APBX_CTRL2_CH2_ERROR_IRQ      0x00000004

#define BF_APBX_CTRL2_CH2_ERROR_IRQ(v)   (((v) << 2) & BM_APBX_CTRL2_CH2_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH2_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH2_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH1_ERROR_IRQ

#define BP_APBX_CTRL2_CH1_ERROR_IRQ      1
#define BM_APBX_CTRL2_CH1_ERROR_IRQ      0x00000002

#define BF_APBX_CTRL2_CH1_ERROR_IRQ(v)   (((v) << 1) & BM_APBX_CTRL2_CH1_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH1_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH1_ERROR_IRQ, v)
#endif

//--- Register HW_APBX_CTRL2, field CH0_ERROR_IRQ

#define BP_APBX_CTRL2_CH0_ERROR_IRQ      0
#define BM_APBX_CTRL2_CH0_ERROR_IRQ      0x00000001

#define BF_APBX_CTRL2_CH0_ERROR_IRQ(v)   (((v) << 0) & BM_APBX_CTRL2_CH0_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CTRL2_CH0_ERROR_IRQ(v)   BF_CS1(APBX_CTRL2, CH0_ERROR_IRQ, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_APBX_CHANNEL_CTRL - AHB to APBX Bridge Channel Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FREEZE_CHANNEL  : 16;
        unsigned RESET_CHANNEL   : 16;
    } B;
} hw_apbx_channel_ctrl_t;
#endif


//
// constants & macros for entire HW_APBX_CHANNEL_CTRL register
//

#define HW_APBX_CHANNEL_CTRL_ADDR      (REGS_APBX_BASE + 0x00000030)
#define HW_APBX_CHANNEL_CTRL_SET_ADDR  (REGS_APBX_BASE + 0x00000034)
#define HW_APBX_CHANNEL_CTRL_CLR_ADDR  (REGS_APBX_BASE + 0x00000038)
#define HW_APBX_CHANNEL_CTRL_TOG_ADDR  (REGS_APBX_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CHANNEL_CTRL           (*(volatile hw_apbx_channel_ctrl_t *) HW_APBX_CHANNEL_CTRL_ADDR)
#define HW_APBX_CHANNEL_CTRL_RD()      (HW_APBX_CHANNEL_CTRL.U)
#define HW_APBX_CHANNEL_CTRL_WR(v)     (HW_APBX_CHANNEL_CTRL.U = (v))
#define HW_APBX_CHANNEL_CTRL_SET(v)    ((*(volatile reg32_t *) HW_APBX_CHANNEL_CTRL_SET_ADDR) = (v))
#define HW_APBX_CHANNEL_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_APBX_CHANNEL_CTRL_CLR_ADDR) = (v))
#define HW_APBX_CHANNEL_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_APBX_CHANNEL_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_APBX_CHANNEL_CTRL bitfields
//

//--- Register HW_APBX_CHANNEL_CTRL, field RESET_CHANNEL

#define BP_APBX_CHANNEL_CTRL_RESET_CHANNEL      16
#define BM_APBX_CHANNEL_CTRL_RESET_CHANNEL      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CHANNEL_CTRL_RESET_CHANNEL(v)   ((((reg32_t) v) << 16) & BM_APBX_CHANNEL_CTRL_RESET_CHANNEL)
#else
#define BF_APBX_CHANNEL_CTRL_RESET_CHANNEL(v)   (((v) << 16) & BM_APBX_CHANNEL_CTRL_RESET_CHANNEL)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CHANNEL_CTRL_RESET_CHANNEL(v)   (HW_APBX_CHANNEL_CTRL.B.RESET_CHANNEL = (v))
#endif

#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__AUDIOIN   0x0001
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__AUDIOOUT  0x0002
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__SPDIF_TX  0x0004
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__I2C       0x0008
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__SAIF1     0x0010
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__DRI       0x0020
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__IRDA_RX   0x0040
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__UART0_RX  0x0040
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__IRDA_TX   0x0080
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__UART0_TX  0x0080
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__UART1_RX  0x0100
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__UART1_TX  0x0200
#define BV_APBX_CHANNEL_CTRL_RESET_CHANNEL__SAIF2     0x0400

//--- Register HW_APBX_CHANNEL_CTRL, field FREEZE_CHANNEL

#define BP_APBX_CHANNEL_CTRL_FREEZE_CHANNEL      0
#define BM_APBX_CHANNEL_CTRL_FREEZE_CHANNEL      0x0000FFFF

#define BF_APBX_CHANNEL_CTRL_FREEZE_CHANNEL(v)   (((v) << 0) & BM_APBX_CHANNEL_CTRL_FREEZE_CHANNEL)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CHANNEL_CTRL_FREEZE_CHANNEL(v)   (HW_APBX_CHANNEL_CTRL.B.FREEZE_CHANNEL = (v))
#endif

#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__AUDIOIN   0x0001
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__AUDIOOUT  0x0002
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__SPDIF_TX  0x0004
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__I2C       0x0008
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__SAIF1     0x0010
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__DRI       0x0020
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__IRDA_RX   0x0040
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__UART0_RX  0x0040
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__IRDA_TX   0x0080
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__UART0_TX  0x0080
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__UART1_RX  0x0100
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__UART1_TX  0x0200
#define BV_APBX_CHANNEL_CTRL_FREEZE_CHANNEL__SAIF2     0x0400


////////////////////////////////////////////////////////////////////////////////
//// HW_APBX_DEVSEL - AHB to APBX DMA Device Assignment Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CH0   :  2;
        unsigned CH1   :  2;
        unsigned CH2   :  2;
        unsigned CH3   :  2;
        unsigned CH4   :  2;
        unsigned CH5   :  2;
        unsigned CH6   :  2;
        unsigned CH7   :  2;
        unsigned CH8   :  2;
        unsigned CH9   :  2;
        unsigned CH10  :  2;
        unsigned CH11  :  2;
        unsigned CH12  :  2;
        unsigned CH13  :  2;
        unsigned CH14  :  2;
        unsigned CH15  :  2;
    } B;
} hw_apbx_devsel_t;
#endif


//
// constants & macros for entire HW_APBX_DEVSEL register
//

#define HW_APBX_DEVSEL_ADDR      (REGS_APBX_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_APBX_DEVSEL           (*(volatile hw_apbx_devsel_t *) HW_APBX_DEVSEL_ADDR)
#define HW_APBX_DEVSEL_RD()      (HW_APBX_DEVSEL.U)
#define HW_APBX_DEVSEL_WR(v)     (HW_APBX_DEVSEL.U = (v))
#define HW_APBX_DEVSEL_SET(v)    (HW_APBX_DEVSEL_WR(HW_APBX_DEVSEL_RD() |  (v)))
#define HW_APBX_DEVSEL_CLR(v)    (HW_APBX_DEVSEL_WR(HW_APBX_DEVSEL_RD() & ~(v)))
#define HW_APBX_DEVSEL_TOG(v)    (HW_APBX_DEVSEL_WR(HW_APBX_DEVSEL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_APBX_DEVSEL bitfields
//

//--- Register HW_APBX_DEVSEL, field CH15

#define BP_APBX_DEVSEL_CH15      30
#define BM_APBX_DEVSEL_CH15      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_APBX_DEVSEL_CH15(v)   ((((reg32_t) v) << 30) & BM_APBX_DEVSEL_CH15)
#else
#define BF_APBX_DEVSEL_CH15(v)   (((v) << 30) & BM_APBX_DEVSEL_CH15)
#endif

//--- Register HW_APBX_DEVSEL, field CH14

#define BP_APBX_DEVSEL_CH14      28
#define BM_APBX_DEVSEL_CH14      0x30000000

#define BF_APBX_DEVSEL_CH14(v)   (((v) << 28) & BM_APBX_DEVSEL_CH14)

//--- Register HW_APBX_DEVSEL, field CH13

#define BP_APBX_DEVSEL_CH13      26
#define BM_APBX_DEVSEL_CH13      0x0C000000

#define BF_APBX_DEVSEL_CH13(v)   (((v) << 26) & BM_APBX_DEVSEL_CH13)

//--- Register HW_APBX_DEVSEL, field CH12

#define BP_APBX_DEVSEL_CH12      24
#define BM_APBX_DEVSEL_CH12      0x03000000

#define BF_APBX_DEVSEL_CH12(v)   (((v) << 24) & BM_APBX_DEVSEL_CH12)

//--- Register HW_APBX_DEVSEL, field CH11

#define BP_APBX_DEVSEL_CH11      22
#define BM_APBX_DEVSEL_CH11      0x00C00000

#define BF_APBX_DEVSEL_CH11(v)   (((v) << 22) & BM_APBX_DEVSEL_CH11)

//--- Register HW_APBX_DEVSEL, field CH10

#define BP_APBX_DEVSEL_CH10      20
#define BM_APBX_DEVSEL_CH10      0x00300000

#define BF_APBX_DEVSEL_CH10(v)   (((v) << 20) & BM_APBX_DEVSEL_CH10)

//--- Register HW_APBX_DEVSEL, field CH9

#define BP_APBX_DEVSEL_CH9      18
#define BM_APBX_DEVSEL_CH9      0x000C0000

#define BF_APBX_DEVSEL_CH9(v)   (((v) << 18) & BM_APBX_DEVSEL_CH9)

//--- Register HW_APBX_DEVSEL, field CH8

#define BP_APBX_DEVSEL_CH8      16
#define BM_APBX_DEVSEL_CH8      0x00030000

#define BF_APBX_DEVSEL_CH8(v)   (((v) << 16) & BM_APBX_DEVSEL_CH8)

//--- Register HW_APBX_DEVSEL, field CH7

#define BP_APBX_DEVSEL_CH7      14
#define BM_APBX_DEVSEL_CH7      0x0000C000

#define BF_APBX_DEVSEL_CH7(v)   (((v) << 14) & BM_APBX_DEVSEL_CH7)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_DEVSEL_CH7(v)   BF_CS1(APBX_DEVSEL, CH7, v)
#endif

#define BV_APBX_DEVSEL_CH7__USE_I2C1  0x0
#define BV_APBX_DEVSEL_CH7__USE_IRDA  0x1

//--- Register HW_APBX_DEVSEL, field CH6

#define BP_APBX_DEVSEL_CH6      12
#define BM_APBX_DEVSEL_CH6      0x00003000

#define BF_APBX_DEVSEL_CH6(v)   (((v) << 12) & BM_APBX_DEVSEL_CH6)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_DEVSEL_CH6(v)   BF_CS1(APBX_DEVSEL, CH6, v)
#endif

#define BV_APBX_DEVSEL_CH6__USE_SAIF1  0x0
#define BV_APBX_DEVSEL_CH6__USE_IRDA   0x1

//--- Register HW_APBX_DEVSEL, field CH5

#define BP_APBX_DEVSEL_CH5      10
#define BM_APBX_DEVSEL_CH5      0x00000C00

#define BF_APBX_DEVSEL_CH5(v)   (((v) << 10) & BM_APBX_DEVSEL_CH5)

//--- Register HW_APBX_DEVSEL, field CH4

#define BP_APBX_DEVSEL_CH4      8
#define BM_APBX_DEVSEL_CH4      0x00000300

#define BF_APBX_DEVSEL_CH4(v)   (((v) << 8) & BM_APBX_DEVSEL_CH4)

//--- Register HW_APBX_DEVSEL, field CH3

#define BP_APBX_DEVSEL_CH3      6
#define BM_APBX_DEVSEL_CH3      0x000000C0

#define BF_APBX_DEVSEL_CH3(v)   (((v) << 6) & BM_APBX_DEVSEL_CH3)

//--- Register HW_APBX_DEVSEL, field CH2

#define BP_APBX_DEVSEL_CH2      4
#define BM_APBX_DEVSEL_CH2      0x00000030

#define BF_APBX_DEVSEL_CH2(v)   (((v) << 4) & BM_APBX_DEVSEL_CH2)

//--- Register HW_APBX_DEVSEL, field CH1

#define BP_APBX_DEVSEL_CH1      2
#define BM_APBX_DEVSEL_CH1      0x0000000C

#define BF_APBX_DEVSEL_CH1(v)   (((v) << 2) & BM_APBX_DEVSEL_CH1)

//--- Register HW_APBX_DEVSEL, field CH0

#define BP_APBX_DEVSEL_CH0      0
#define BM_APBX_DEVSEL_CH0      0x00000003

#define BF_APBX_DEVSEL_CH0(v)   (((v) << 0) & BM_APBX_DEVSEL_CH0)


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_APBX_CHn_CURCMDAR : base 0x80024100 : count 16 : offset 0x70
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CMD_ADDR  : 32;
    } B;
} hw_apbx_chn_curcmdar_t;
#endif


//
// constants & macros for entire HW_APBX_CHn_CURCMDAR multi-register
//

#define HW_APBX_CHn_CURCMDAR_COUNT        16
#define HW_APBX_CHn_CURCMDAR_ADDR(n)      (REGS_APBX_BASE + 0x00000100 + ((n) * 0x70))

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CHn_CURCMDAR(n)           (*(volatile hw_apbx_chn_curcmdar_t *) HW_APBX_CHn_CURCMDAR_ADDR(n))
#define HW_APBX_CHn_CURCMDAR_RD(n)        (HW_APBX_CHn_CURCMDAR(n).U)
#endif


//
// constants & macros for individual HW_APBX_CHn_CURCMDAR multi-register bitfields
//

//--- Register HW_APBX_CHn_CURCMDAR, field CMD_ADDR

#define BP_APBX_CHn_CURCMDAR_CMD_ADDR      0
#define BM_APBX_CHn_CURCMDAR_CMD_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CHn_CURCMDAR_CMD_ADDR(v)   ((reg32_t) v)
#else
#define BF_APBX_CHn_CURCMDAR_CMD_ADDR(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_APBX_CHn_NXTCMDAR : base 0x80024110 : count 16 : offset 0x70
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CMD_ADDR  : 32;
    } B;
} hw_apbx_chn_nxtcmdar_t;
#endif


//
// constants & macros for entire HW_APBX_CHn_NXTCMDAR multi-register
//

#define HW_APBX_CHn_NXTCMDAR_COUNT        16
#define HW_APBX_CHn_NXTCMDAR_ADDR(n)      (REGS_APBX_BASE + 0x00000110 + ((n) * 0x70))

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CHn_NXTCMDAR(n)           (*(volatile hw_apbx_chn_nxtcmdar_t *) HW_APBX_CHn_NXTCMDAR_ADDR(n))
#define HW_APBX_CHn_NXTCMDAR_RD(n)        (HW_APBX_CHn_NXTCMDAR(n).U)
#define HW_APBX_CHn_NXTCMDAR_WR(n, v)     (HW_APBX_CHn_NXTCMDAR(n).U = (v))
#define HW_APBX_CHn_NXTCMDAR_SET(n, v)    (HW_APBX_CHn_NXTCMDAR_WR(n, HW_APBX_CHn_NXTCMDAR_RD(n) |  (v)))
#define HW_APBX_CHn_NXTCMDAR_CLR(n, v)    (HW_APBX_CHn_NXTCMDAR_WR(n, HW_APBX_CHn_NXTCMDAR_RD(n) & ~(v)))
#define HW_APBX_CHn_NXTCMDAR_TOG(n, v)    (HW_APBX_CHn_NXTCMDAR_WR(n, HW_APBX_CHn_NXTCMDAR_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_APBX_CHn_NXTCMDAR multi-register bitfields
//

//--- Register HW_APBX_CHn_NXTCMDAR, field CMD_ADDR

#define BP_APBX_CHn_NXTCMDAR_CMD_ADDR      0
#define BM_APBX_CHn_NXTCMDAR_CMD_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CHn_NXTCMDAR_CMD_ADDR(v)   ((reg32_t) v)
#else
#define BF_APBX_CHn_NXTCMDAR_CMD_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CHn_NXTCMDAR_CMD_ADDR(n, v)  (HW_APBX_CHn_NXTCMDAR(n).B.CMD_ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_APBX_CHn_CMD : base 0x80024120 : count 16 : offset 0x70
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COMMAND          :  2;
        unsigned CHAIN            :  1;
        unsigned IRQONCMPLT       :  1;
        unsigned RSVD0            :  2;
        unsigned SEMAPHORE        :  1;
        unsigned WAIT4ENDCMD      :  1;
        unsigned HALTONTERMINATE  :  1;
        unsigned RSVD1            :  3;
        unsigned CMDWORDS         :  4;
        unsigned XFER_COUNT       : 16;
    } B;
} hw_apbx_chn_cmd_t;
#endif


//
// constants & macros for entire HW_APBX_CHn_CMD multi-register
//

#define HW_APBX_CHn_CMD_COUNT        16
#define HW_APBX_CHn_CMD_ADDR(n)      (REGS_APBX_BASE + 0x00000120 + ((n) * 0x70))

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CHn_CMD(n)           (*(volatile hw_apbx_chn_cmd_t *) HW_APBX_CHn_CMD_ADDR(n))
#define HW_APBX_CHn_CMD_RD(n)        (HW_APBX_CHn_CMD(n).U)
#endif


//
// constants & macros for individual HW_APBX_CHn_CMD multi-register bitfields
//

//--- Register HW_APBX_CHn_CMD, field XFER_COUNT

#define BP_APBX_CHn_CMD_XFER_COUNT      16
#define BM_APBX_CHn_CMD_XFER_COUNT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CHn_CMD_XFER_COUNT(v)   ((((reg32_t) v) << 16) & BM_APBX_CHn_CMD_XFER_COUNT)
#else
#define BF_APBX_CHn_CMD_XFER_COUNT(v)   (((v) << 16) & BM_APBX_CHn_CMD_XFER_COUNT)
#endif

//--- Register HW_APBX_CHn_CMD, field CMDWORDS

#define BP_APBX_CHn_CMD_CMDWORDS      12
#define BM_APBX_CHn_CMD_CMDWORDS      0x0000F000

#define BF_APBX_CHn_CMD_CMDWORDS(v)   (((v) << 12) & BM_APBX_CHn_CMD_CMDWORDS)

//--- Register HW_APBX_CHn_CMD, field HALTONTERMINATE

#define BP_APBX_CHn_CMD_HALTONTERMINATE      8
#define BM_APBX_CHn_CMD_HALTONTERMINATE      0x00000100

#define BF_APBX_CHn_CMD_HALTONTERMINATE(v)   (((v) << 8) & BM_APBX_CHn_CMD_HALTONTERMINATE)

//--- Register HW_APBX_CHn_CMD, field WAIT4ENDCMD

#define BP_APBX_CHn_CMD_WAIT4ENDCMD      7
#define BM_APBX_CHn_CMD_WAIT4ENDCMD      0x00000080

#define BF_APBX_CHn_CMD_WAIT4ENDCMD(v)   (((v) << 7) & BM_APBX_CHn_CMD_WAIT4ENDCMD)

//--- Register HW_APBX_CHn_CMD, field SEMAPHORE

#define BP_APBX_CHn_CMD_SEMAPHORE      6
#define BM_APBX_CHn_CMD_SEMAPHORE      0x00000040

#define BF_APBX_CHn_CMD_SEMAPHORE(v)   (((v) << 6) & BM_APBX_CHn_CMD_SEMAPHORE)

//--- Register HW_APBX_CHn_CMD, field IRQONCMPLT

#define BP_APBX_CHn_CMD_IRQONCMPLT      3
#define BM_APBX_CHn_CMD_IRQONCMPLT      0x00000008

#define BF_APBX_CHn_CMD_IRQONCMPLT(v)   (((v) << 3) & BM_APBX_CHn_CMD_IRQONCMPLT)

//--- Register HW_APBX_CHn_CMD, field CHAIN

#define BP_APBX_CHn_CMD_CHAIN      2
#define BM_APBX_CHn_CMD_CHAIN      0x00000004

#define BF_APBX_CHn_CMD_CHAIN(v)   (((v) << 2) & BM_APBX_CHn_CMD_CHAIN)

//--- Register HW_APBX_CHn_CMD, field COMMAND

#define BP_APBX_CHn_CMD_COMMAND      0
#define BM_APBX_CHn_CMD_COMMAND      0x00000003

#define BF_APBX_CHn_CMD_COMMAND(v)   (((v) << 0) & BM_APBX_CHn_CMD_COMMAND)

#define BV_APBX_CHn_CMD_COMMAND__NO_DMA_XFER  0x0
#define BV_APBX_CHn_CMD_COMMAND__DMA_WRITE    0x1
#define BV_APBX_CHn_CMD_COMMAND__DMA_READ     0x2


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_APBX_CHn_BAR : base 0x80024130 : count 16 : offset 0x70
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDRESS  : 32;
    } B;
} hw_apbx_chn_bar_t;
#endif


//
// constants & macros for entire HW_APBX_CHn_BAR multi-register
//

#define HW_APBX_CHn_BAR_COUNT        16
#define HW_APBX_CHn_BAR_ADDR(n)      (REGS_APBX_BASE + 0x00000130 + ((n) * 0x70))

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CHn_BAR(n)           (*(volatile hw_apbx_chn_bar_t *) HW_APBX_CHn_BAR_ADDR(n))
#define HW_APBX_CHn_BAR_RD(n)        (HW_APBX_CHn_BAR(n).U)
#endif


//
// constants & macros for individual HW_APBX_CHn_BAR multi-register bitfields
//

//--- Register HW_APBX_CHn_BAR, field ADDRESS

#define BP_APBX_CHn_BAR_ADDRESS      0
#define BM_APBX_CHn_BAR_ADDRESS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CHn_BAR_ADDRESS(v)   ((reg32_t) v)
#else
#define BF_APBX_CHn_BAR_ADDRESS(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_APBX_CHn_SEMA : base 0x80024140 : count 16 : offset 0x70
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INCREMENT_SEMA  :  8;
        unsigned RSVD1           :  8;
        unsigned PHORE           :  8;
        unsigned RSVD2           :  8;
    } B;
} hw_apbx_chn_sema_t;
#endif


//
// constants & macros for entire HW_APBX_CHn_SEMA multi-register
//

#define HW_APBX_CHn_SEMA_COUNT        16
#define HW_APBX_CHn_SEMA_ADDR(n)      (REGS_APBX_BASE + 0x00000140 + ((n) * 0x70))

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CHn_SEMA(n)           (*(volatile hw_apbx_chn_sema_t *) HW_APBX_CHn_SEMA_ADDR(n))
#define HW_APBX_CHn_SEMA_RD(n)        (HW_APBX_CHn_SEMA(n).U)
#define HW_APBX_CHn_SEMA_WR(n, v)     (HW_APBX_CHn_SEMA(n).U = (v))
#define HW_APBX_CHn_SEMA_SET(n, v)    (HW_APBX_CHn_SEMA_WR(n, HW_APBX_CHn_SEMA_RD(n) |  (v)))
#define HW_APBX_CHn_SEMA_CLR(n, v)    (HW_APBX_CHn_SEMA_WR(n, HW_APBX_CHn_SEMA_RD(n) & ~(v)))
#define HW_APBX_CHn_SEMA_TOG(n, v)    (HW_APBX_CHn_SEMA_WR(n, HW_APBX_CHn_SEMA_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_APBX_CHn_SEMA multi-register bitfields
//

//--- Register HW_APBX_CHn_SEMA, field PHORE

#define BP_APBX_CHn_SEMA_PHORE      16
#define BM_APBX_CHn_SEMA_PHORE      0x00FF0000

#define BF_APBX_CHn_SEMA_PHORE(v)   (((v) << 16) & BM_APBX_CHn_SEMA_PHORE)

//--- Register HW_APBX_CHn_SEMA, field INCREMENT_SEMA

#define BP_APBX_CHn_SEMA_INCREMENT_SEMA      0
#define BM_APBX_CHn_SEMA_INCREMENT_SEMA      0x000000FF

#define BF_APBX_CHn_SEMA_INCREMENT_SEMA(v)   (((v) << 0) & BM_APBX_CHn_SEMA_INCREMENT_SEMA)

#ifndef __LANGUAGE_ASM__
#define BW_APBX_CHn_SEMA_INCREMENT_SEMA(n, v)  (HW_APBX_CHn_SEMA(n).B.INCREMENT_SEMA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_APBX_CHn_DEBUG1 : base 0x80024150 : count 16 : offset 0x70
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STATEMACHINE      :  5;
        unsigned RSVD1             : 15;
        unsigned WR_FIFO_FULL      :  1;
        unsigned WR_FIFO_EMPTY     :  1;
        unsigned RD_FIFO_FULL      :  1;
        unsigned RD_FIFO_EMPTY     :  1;
        unsigned NEXTCMDADDRVALID  :  1;
        unsigned RSVD2             :  3;
        unsigned END               :  1;
        unsigned KICK              :  1;
        unsigned BURST             :  1;
        unsigned REQ               :  1;
    } B;
} hw_apbx_chn_debug1_t;
#endif


//
// constants & macros for entire HW_APBX_CHn_DEBUG1 multi-register
//

#define HW_APBX_CHn_DEBUG1_COUNT        16
#define HW_APBX_CHn_DEBUG1_ADDR(n)      (REGS_APBX_BASE + 0x00000150 + ((n) * 0x70))

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CHn_DEBUG1(n)           (*(volatile hw_apbx_chn_debug1_t *) HW_APBX_CHn_DEBUG1_ADDR(n))
#define HW_APBX_CHn_DEBUG1_RD(n)        (HW_APBX_CHn_DEBUG1(n).U)
#endif


//
// constants & macros for individual HW_APBX_CHn_DEBUG1 multi-register bitfields
//

//--- Register HW_APBX_CHn_DEBUG1, field REQ

#define BP_APBX_CHn_DEBUG1_REQ      31
#define BM_APBX_CHn_DEBUG1_REQ      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CHn_DEBUG1_REQ(v)   ((((reg32_t) v) << 31) & BM_APBX_CHn_DEBUG1_REQ)
#else
#define BF_APBX_CHn_DEBUG1_REQ(v)   (((v) << 31) & BM_APBX_CHn_DEBUG1_REQ)
#endif

//--- Register HW_APBX_CHn_DEBUG1, field BURST

#define BP_APBX_CHn_DEBUG1_BURST      30
#define BM_APBX_CHn_DEBUG1_BURST      0x40000000

#define BF_APBX_CHn_DEBUG1_BURST(v)   (((v) << 30) & BM_APBX_CHn_DEBUG1_BURST)

//--- Register HW_APBX_CHn_DEBUG1, field KICK

#define BP_APBX_CHn_DEBUG1_KICK      29
#define BM_APBX_CHn_DEBUG1_KICK      0x20000000

#define BF_APBX_CHn_DEBUG1_KICK(v)   (((v) << 29) & BM_APBX_CHn_DEBUG1_KICK)

//--- Register HW_APBX_CHn_DEBUG1, field END

#define BP_APBX_CHn_DEBUG1_END      28
#define BM_APBX_CHn_DEBUG1_END      0x10000000

#define BF_APBX_CHn_DEBUG1_END(v)   (((v) << 28) & BM_APBX_CHn_DEBUG1_END)

//--- Register HW_APBX_CHn_DEBUG1, field NEXTCMDADDRVALID

#define BP_APBX_CHn_DEBUG1_NEXTCMDADDRVALID      24
#define BM_APBX_CHn_DEBUG1_NEXTCMDADDRVALID      0x01000000

#define BF_APBX_CHn_DEBUG1_NEXTCMDADDRVALID(v)   (((v) << 24) & BM_APBX_CHn_DEBUG1_NEXTCMDADDRVALID)

//--- Register HW_APBX_CHn_DEBUG1, field RD_FIFO_EMPTY

#define BP_APBX_CHn_DEBUG1_RD_FIFO_EMPTY      23
#define BM_APBX_CHn_DEBUG1_RD_FIFO_EMPTY      0x00800000

#define BF_APBX_CHn_DEBUG1_RD_FIFO_EMPTY(v)   (((v) << 23) & BM_APBX_CHn_DEBUG1_RD_FIFO_EMPTY)

//--- Register HW_APBX_CHn_DEBUG1, field RD_FIFO_FULL

#define BP_APBX_CHn_DEBUG1_RD_FIFO_FULL      22
#define BM_APBX_CHn_DEBUG1_RD_FIFO_FULL      0x00400000

#define BF_APBX_CHn_DEBUG1_RD_FIFO_FULL(v)   (((v) << 22) & BM_APBX_CHn_DEBUG1_RD_FIFO_FULL)

//--- Register HW_APBX_CHn_DEBUG1, field WR_FIFO_EMPTY

#define BP_APBX_CHn_DEBUG1_WR_FIFO_EMPTY      21
#define BM_APBX_CHn_DEBUG1_WR_FIFO_EMPTY      0x00200000

#define BF_APBX_CHn_DEBUG1_WR_FIFO_EMPTY(v)   (((v) << 21) & BM_APBX_CHn_DEBUG1_WR_FIFO_EMPTY)

//--- Register HW_APBX_CHn_DEBUG1, field WR_FIFO_FULL

#define BP_APBX_CHn_DEBUG1_WR_FIFO_FULL      20
#define BM_APBX_CHn_DEBUG1_WR_FIFO_FULL      0x00100000

#define BF_APBX_CHn_DEBUG1_WR_FIFO_FULL(v)   (((v) << 20) & BM_APBX_CHn_DEBUG1_WR_FIFO_FULL)

//--- Register HW_APBX_CHn_DEBUG1, field STATEMACHINE

#define BP_APBX_CHn_DEBUG1_STATEMACHINE      0
#define BM_APBX_CHn_DEBUG1_STATEMACHINE      0x0000001F

#define BF_APBX_CHn_DEBUG1_STATEMACHINE(v)   (((v) << 0) & BM_APBX_CHn_DEBUG1_STATEMACHINE)

#define BV_APBX_CHn_DEBUG1_STATEMACHINE__IDLE           0x00
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__REQ_CMD1       0x01
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__REQ_CMD3       0x02
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__REQ_CMD2       0x03
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__XFER_DECODE    0x04
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__REQ_WAIT       0x05
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__REQ_CMD4       0x06
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__PIO_REQ        0x07
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__READ_FLUSH     0x08
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__READ_WAIT      0x09
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__WRITE          0x0C
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__READ_REQ       0x0D
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__CHECK_CHAIN    0x0E
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__XFER_COMPLETE  0x0F
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__WAIT_END       0x15
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__WRITE_WAIT     0x1C
#define BV_APBX_CHn_DEBUG1_STATEMACHINE__CHECK_WAIT     0x1E


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_APBX_CHn_DEBUG2 : base 0x80024160 : count 16 : offset 0x70
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AHB_BYTES  : 16;
        unsigned APB_BYTES  : 16;
    } B;
} hw_apbx_chn_debug2_t;
#endif


//
// constants & macros for entire HW_APBX_CHn_DEBUG2 multi-register
//

#define HW_APBX_CHn_DEBUG2_COUNT        16
#define HW_APBX_CHn_DEBUG2_ADDR(n)      (REGS_APBX_BASE + 0x00000160 + ((n) * 0x70))

#ifndef __LANGUAGE_ASM__
#define HW_APBX_CHn_DEBUG2(n)           (*(volatile hw_apbx_chn_debug2_t *) HW_APBX_CHn_DEBUG2_ADDR(n))
#define HW_APBX_CHn_DEBUG2_RD(n)        (HW_APBX_CHn_DEBUG2(n).U)
#endif


//
// constants & macros for individual HW_APBX_CHn_DEBUG2 multi-register bitfields
//

//--- Register HW_APBX_CHn_DEBUG2, field APB_BYTES

#define BP_APBX_CHn_DEBUG2_APB_BYTES      16
#define BM_APBX_CHn_DEBUG2_APB_BYTES      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_APBX_CHn_DEBUG2_APB_BYTES(v)   ((((reg32_t) v) << 16) & BM_APBX_CHn_DEBUG2_APB_BYTES)
#else
#define BF_APBX_CHn_DEBUG2_APB_BYTES(v)   (((v) << 16) & BM_APBX_CHn_DEBUG2_APB_BYTES)
#endif

//--- Register HW_APBX_CHn_DEBUG2, field AHB_BYTES

#define BP_APBX_CHn_DEBUG2_AHB_BYTES      0
#define BM_APBX_CHn_DEBUG2_AHB_BYTES      0x0000FFFF

#define BF_APBX_CHn_DEBUG2_AHB_BYTES(v)   (((v) << 0) & BM_APBX_CHn_DEBUG2_AHB_BYTES)


////////////////////////////////////////////////////////////////////////////////
//// HW_APBX_VERSION - APBX Bridge Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_apbx_version_t;
#endif


//
// constants & macros for entire HW_APBX_VERSION register
//

#define HW_APBX_VERSION_ADDR      (REGS_APBX_BASE + 0x00000800)

#ifndef __LANGUAGE_ASM__
#define HW_APBX_VERSION           (*(volatile hw_apbx_version_t *) HW_APBX_VERSION_ADDR)
#define HW_APBX_VERSION_RD()      (HW_APBX_VERSION.U)
#endif


//
// constants & macros for individual HW_APBX_VERSION bitfields
//

//--- Register HW_APBX_VERSION, field MAJOR

#define BP_APBX_VERSION_MAJOR      24
#define BM_APBX_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_APBX_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_APBX_VERSION_MAJOR)
#else
#define BF_APBX_VERSION_MAJOR(v)   (((v) << 24) & BM_APBX_VERSION_MAJOR)
#endif

//--- Register HW_APBX_VERSION, field MINOR

#define BP_APBX_VERSION_MINOR      16
#define BM_APBX_VERSION_MINOR      0x00FF0000

#define BF_APBX_VERSION_MINOR(v)   (((v) << 16) & BM_APBX_VERSION_MINOR)

//--- Register HW_APBX_VERSION, field STEP

#define BP_APBX_VERSION_STEP      0
#define BM_APBX_VERSION_STEP      0x0000FFFF

#define BF_APBX_VERSION_STEP(v)   (((v) << 0) & BM_APBX_VERSION_STEP)


#endif // _REGSAPBX_H

////////////////////////////////////////////////////////////////////////////////
