import { PlatformAccessory, Service } from 'homebridge';
import { Zigbee2mqttPlatform } from './platform';
import { ServiceCreatorManager } from './converters/creators';
import { BasicAccessory, ServiceHandler } from './converters/interfaces';
import { BasicLogger } from './logger';
import { DeviceListEntry } from './z2mModels';
import { BaseDeviceConfiguration } from './configModels';
export declare class Zigbee2mqttAccessory implements BasicAccessory {
    private readonly platform;
    readonly accessory: PlatformAccessory;
    private readonly additionalConfig;
    private readonly updateTimer;
    private readonly serviceCreatorManager;
    private readonly serviceHandlers;
    private readonly serviceIds;
    private pendingPublishData;
    private publishIsScheduled;
    private readonly pendingGetKeys;
    private getIsScheduled;
    get log(): BasicLogger;
    get displayName(): string;
    get deviceTopic(): string;
    get groupId(): number | undefined;
    get serialNumber(): string;
    constructor(platform: Zigbee2mqttPlatform, accessory: PlatformAccessory, additionalConfig: BaseDeviceConfiguration, serviceCreatorManager?: ServiceCreatorManager);
    getConverterConfiguration(tag: string): unknown | undefined;
    isExperimentalFeatureEnabled(feature: string): boolean;
    registerServiceHandler(handler: ServiceHandler): void;
    isServiceHandlerIdKnown(identifier: string): boolean;
    isPropertyExcluded(property: string | undefined): boolean;
    isValueAllowedForProperty(property: string, value: string): boolean;
    private doesValueMatchPattern;
    private queueAllKeysForGet;
    private publishPendingGetKeys;
    queueKeyForGetAction(key: string | string[]): void;
    static getUniqueIdForService(service: Service): string;
    getOrAddService(service: Service): Service;
    queueDataForSetAction(data: Record<string, unknown>): void;
    private publishPendingSetData;
    get UUID(): string;
    get ieeeAddress(): string;
    matchesIdentifier(id: string): boolean;
    updateDeviceInformation(info: DeviceListEntry | undefined, force_update?: boolean): void;
    private cleanStaleServices;
    private updateServiceNames;
    private getMqttQosLevel;
    updateStates(state: Record<string, unknown>): void;
    getDefaultServiceDisplayName(subType: string | undefined): string;
}
//# sourceMappingURL=platformAccessory.d.ts.map