"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VibrationSensorHandler = void 0;
const hap_1 = require("../../hap");
const binary_1 = require("./binary");
class VibrationSensorHandler extends binary_1.BinarySensorHandler {
    constructor(expose, otherExposes, accessory) {
        super(accessory, expose, otherExposes, VibrationSensorHandler.generateIdentifier, 'Motion Sensor (vibration)', (n, t) => new hap_1.hap.Service.MotionSensor(n, (VibrationSensorHandler.exposesName + ' ' + (t !== null && t !== void 0 ? t : '')).trim()), hap_1.hap.Characteristic.MotionDetected, true, false);
    }
    static generateIdentifier(endpoint) {
        let identifier = VibrationSensorHandler.exposesName + '_' + hap_1.hap.Service.MotionSensor.UUID;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.VibrationSensorHandler = VibrationSensorHandler;
VibrationSensorHandler.exposesName = 'vibration';
//# sourceMappingURL=vibration.js.map