"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GasLeakSensorHandler = exports.WaterLeakSensorHandler = void 0;
const hap_1 = require("../../hap");
const binary_1 = require("./binary");
class LeakSensorHandler extends binary_1.BinarySensorHandler {
    constructor(subType, identifierGen, expose, otherExposes, accessory) {
        super(accessory, expose, otherExposes, identifierGen, subType + ' LeakSensor', (n, t) => new hap_1.hap.Service.LeakSensor(n, t), hap_1.hap.Characteristic.LeakDetected, hap_1.hap.Characteristic.LeakDetected.LEAK_DETECTED, hap_1.hap.Characteristic.LeakDetected.LEAK_NOT_DETECTED, subType);
    }
    static generateIdentifier(endpoint, additionalSubType) {
        let identifier = `${additionalSubType}_${hap_1.hap.Service.LeakSensor.UUID}`;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
class WaterLeakSensorHandler extends LeakSensorHandler {
    constructor(expose, otherExposes, accessory) {
        super(WaterLeakSensorHandler.SUBTYPE, WaterLeakSensorHandler.generateIdentifier, expose, otherExposes, accessory);
    }
    static generateIdentifier(endpoint) {
        return LeakSensorHandler.generateIdentifier(endpoint, WaterLeakSensorHandler.SUBTYPE);
    }
}
exports.WaterLeakSensorHandler = WaterLeakSensorHandler;
WaterLeakSensorHandler.exposesName = 'water_leak';
WaterLeakSensorHandler.SUBTYPE = 'water';
class GasLeakSensorHandler extends LeakSensorHandler {
    constructor(expose, otherExposes, accessory) {
        super(GasLeakSensorHandler.SUBTYPE, GasLeakSensorHandler.generateIdentifier, expose, otherExposes, accessory);
    }
    static generateIdentifier(endpoint) {
        return LeakSensorHandler.generateIdentifier(endpoint, GasLeakSensorHandler.SUBTYPE);
    }
}
exports.GasLeakSensorHandler = GasLeakSensorHandler;
GasLeakSensorHandler.exposesName = 'gas';
GasLeakSensorHandler.SUBTYPE = 'gas';
//# sourceMappingURL=leak.js.map