"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AirPressureSensorHandler = void 0;
const z2mModels_1 = require("../../z2mModels");
const monitor_1 = require("../monitor");
const hap_1 = require("../../hap");
const basic_1 = require("./basic");
class AirPressureSensorHandler extends basic_1.BasicSensorHandler {
    constructor(expose, allExposes, accessory) {
        super(accessory, expose, allExposes, AirPressureSensorHandler.generateIdentifier, (n, t) => AirPressureSensorHandler.AirPressureSensor(n, t));
        accessory.log.debug(`Configuring AirPressureSensor for ${this.serviceName}`);
        this.monitors.push(new monitor_1.PassthroughCharacteristicMonitor(expose.property, this.service, AirPressureSensorHandler.CharacteristicName));
    }
    static AirPressureSensor(displayName, subtype) {
        const service = new hap_1.hap.Service(displayName, AirPressureSensorHandler.ServiceUUID, subtype);
        service.addCharacteristic(AirPressureSensorHandler.AirPressure);
        return service;
    }
    static get AirPressure() {
        const characteristic = new hap_1.hap.Characteristic(AirPressureSensorHandler.CharacteristicName, AirPressureSensorHandler.CharacteristicUUID, {
            format: "uint16" /* hap.Formats.UINT16 */,
            perms: ["pr" /* hap.Perms.PAIRED_READ */, "ev" /* hap.Perms.NOTIFY */],
            minValue: 700,
            maxValue: 1100,
            minStep: 1,
        });
        characteristic.value = 1013;
        return characteristic;
    }
    static generateIdentifier(endpoint) {
        let identifier = AirPressureSensorHandler.ServiceUUID;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.AirPressureSensorHandler = AirPressureSensorHandler;
AirPressureSensorHandler.exposesName = 'pressure';
AirPressureSensorHandler.exposesType = z2mModels_1.ExposesKnownTypes.NUMERIC;
AirPressureSensorHandler.ServiceUUID = 'E863F00A-079E-48FF-8F27-9C2605A29F52';
AirPressureSensorHandler.CharacteristicUUID = 'E863F10F-079E-48FF-8F27-9C2605A29F52';
AirPressureSensorHandler.CharacteristicName = 'Air Pressure';
//# sourceMappingURL=air_pressure.js.map