"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmokeSensorHandler = void 0;
const hap_1 = require("../../hap");
const binary_1 = require("./binary");
class SmokeSensorHandler extends binary_1.BinarySensorHandler {
    constructor(expose, otherExposes, accessory) {
        super(accessory, expose, otherExposes, SmokeSensorHandler.generateIdentifier, 'SmokeSensor', (n, t) => new hap_1.hap.Service.SmokeSensor(n, t), hap_1.hap.Characteristic.SmokeDetected, hap_1.hap.Characteristic.SmokeDetected.SMOKE_DETECTED, hap_1.hap.Characteristic.SmokeDetected.SMOKE_NOT_DETECTED);
    }
    static generateIdentifier(endpoint) {
        let identifier = hap_1.hap.Service.SmokeSensor.UUID;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.SmokeSensorHandler = SmokeSensorHandler;
SmokeSensorHandler.exposesName = 'smoke';
//# sourceMappingURL=smoke.js.map