"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LightSensorHandler = void 0;
const z2mModels_1 = require("../../z2mModels");
const monitor_1 = require("../monitor");
const helpers_1 = require("../../helpers");
const hap_1 = require("../../hap");
const basic_1 = require("./basic");
class LightSensorHandler extends basic_1.BasicSensorHandler {
    constructor(expose, allExposes, accessory) {
        super(accessory, expose, allExposes, LightSensorHandler.generateIdentifier, (n, t) => new hap_1.hap.Service.LightSensor(n, t));
        accessory.log.debug(`Configuring LightSensor for ${this.serviceName}`);
        const characteristic = (0, helpers_1.getOrAddCharacteristic)(this.service, hap_1.hap.Characteristic.CurrentAmbientLightLevel);
        if (!(0, helpers_1.copyExposesRangeToCharacteristic)(expose, characteristic)) {
            // Cannot take over range from exposes entry -> Set default props
            characteristic.setProps({
                minValue: 0,
            });
        }
        this.monitors.push(new monitor_1.PassthroughCharacteristicMonitor(expose.property, this.service, hap_1.hap.Characteristic.CurrentAmbientLightLevel));
    }
    static generateIdentifier(endpoint) {
        let identifier = hap_1.hap.Service.LightSensor.UUID;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.LightSensorHandler = LightSensorHandler;
LightSensorHandler.exposesName = 'illuminance_lux';
LightSensorHandler.exposesType = z2mModels_1.ExposesKnownTypes.NUMERIC;
//# sourceMappingURL=light.js.map