"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicServiceCreatorManager = void 0;
const basic_sensors_1 = require("./basic_sensors");
const battery_1 = require("./battery");
const cover_1 = require("./cover");
const light_1 = require("./light");
const lock_1 = require("./lock");
const switch_1 = require("./switch");
const action_1 = require("./action");
const climate_1 = require("./climate");
const air_quality_1 = require("./air_quality");
class BasicServiceCreatorManager {
    constructor() {
        this.creators = BasicServiceCreatorManager.constructors.map(c => new c());
    }
    static getInstance() {
        if (BasicServiceCreatorManager.instance === undefined) {
            BasicServiceCreatorManager.instance = new BasicServiceCreatorManager();
        }
        return BasicServiceCreatorManager.instance;
    }
    createHomeKitEntitiesFromExposes(accessory, exposes) {
        for (const c of this.creators) {
            try {
                c.createServicesFromExposes(accessory, exposes);
            }
            catch (e) {
                accessory.log.error(`Exception occurred when creating services for ${accessory.displayName}: ${e}`);
            }
        }
    }
}
exports.BasicServiceCreatorManager = BasicServiceCreatorManager;
BasicServiceCreatorManager.constructors = [
    light_1.LightCreator,
    switch_1.SwitchCreator,
    cover_1.CoverCreator,
    lock_1.LockCreator,
    basic_sensors_1.BasicSensorCreator,
    air_quality_1.AirQualitySensorCreator,
    action_1.StatelessProgrammableSwitchCreator,
    climate_1.ThermostatCreator,
    battery_1.BatteryCreator,
];
//# sourceMappingURL=creators.js.map