"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupController = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const swagger_1 = require("@nestjs/swagger");
const backup_service_1 = require("./backup.service");
const admin_guard_1 = require("../../core/auth/guards/admin.guard");
const logger_service_1 = require("../../core/logger/logger.service");
let BackupController = class BackupController {
    constructor(backupService, logger) {
        this.backupService = backupService;
        this.logger = logger;
    }
    async downloadBackup(reply) {
        try {
            return await this.backupService.downloadBackup(reply);
        }
        catch (e) {
            console.error(e);
            this.logger.error('Backup Failed ' + e);
            throw new common_1.InternalServerErrorException(e.message);
        }
    }
    async getNextBackupTime() {
        return this.backupService.getNextBackupTime();
    }
    async listScheduledBackups() {
        return this.backupService.listScheduledBackups();
    }
    async getScheduledBackup(backupId) {
        return this.backupService.getScheduledBackup(backupId);
    }
    restoreBackup(req, res) {
        req.multipart(async (field, file, filename, encoding, mimetype) => {
            this.backupService.uploadBackupRestore(file);
        }, (err) => {
            if (err) {
                return res.send(500).send(err.message);
            }
            return res.code(200).send();
        });
    }
    restoreHbfx(req, res) {
        req.multipart(async (field, file, filename, encoding, mimetype) => {
            this.backupService.uploadHbfxRestore(file);
        }, (err) => {
            if (err) {
                return res.send(500).send(err.message);
            }
            return res.code(200).send();
        });
    }
    postBackupRestoreRestart() {
        return this.backupService.postBackupRestoreRestart();
    }
};
__decorate([
    common_1.UseGuards(admin_guard_1.AdminGuard),
    swagger_1.ApiOperation({ summary: 'Download a .tar.gz of the Homebridge instance.' }),
    common_1.Get('/download'),
    __param(0, common_1.Res()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], BackupController.prototype, "downloadBackup", null);
__decorate([
    common_1.UseGuards(admin_guard_1.AdminGuard),
    swagger_1.ApiOperation({ summary: 'Return the date and time of the next scheduled backup.' }),
    common_1.Get('/scheduled-backups/next'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], BackupController.prototype, "getNextBackupTime", null);
__decorate([
    common_1.UseGuards(admin_guard_1.AdminGuard),
    swagger_1.ApiOperation({ summary: 'List available system generated instance backups.' }),
    common_1.Get('/scheduled-backups'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], BackupController.prototype, "listScheduledBackups", null);
__decorate([
    common_1.UseGuards(admin_guard_1.AdminGuard),
    swagger_1.ApiOperation({ summary: 'Download a system generated instance backup.' }),
    swagger_1.ApiParam({ name: 'backupId', type: 'string' }),
    common_1.Get('/scheduled-backups/:backupId'),
    __param(0, common_1.Param('backupId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], BackupController.prototype, "getScheduledBackup", null);
__decorate([
    common_1.UseGuards(admin_guard_1.AdminGuard),
    common_1.Post('/restore'),
    swagger_1.ApiOperation({
        summary: 'Upload a .tar.gz of the Homebridge instance.',
        description: 'NOTE: This endpoint does not trigger the restore process.',
    }),
    swagger_1.ApiConsumes('multipart/form-data'),
    swagger_1.ApiBody({
        schema: {
            type: 'object',
            properties: {
                file: {
                    type: 'string',
                    format: 'binary',
                },
            },
        },
    }),
    __param(0, common_1.Req()), __param(1, common_1.Res()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], BackupController.prototype, "restoreBackup", null);
__decorate([
    common_1.UseGuards(admin_guard_1.AdminGuard),
    swagger_1.ApiOperation({
        summary: 'Upload a .hbfx backup file created by third party apps.',
        description: 'NOTE: This endpoint does not trigger the restore process.',
    }),
    swagger_1.ApiConsumes('multipart/form-data'),
    swagger_1.ApiBody({
        schema: {
            type: 'object',
            properties: {
                file: {
                    type: 'string',
                    format: 'binary',
                },
            },
        },
    }),
    common_1.Post('/restore/hbfx'),
    __param(0, common_1.Req()), __param(1, common_1.Res()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], BackupController.prototype, "restoreHbfx", null);
__decorate([
    common_1.UseGuards(admin_guard_1.AdminGuard),
    common_1.Put('/restart'),
    swagger_1.ApiOperation({ summary: 'Trigger a hard restart of Homebridge (use after restoring backup).' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], BackupController.prototype, "postBackupRestoreRestart", null);
BackupController = __decorate([
    swagger_1.ApiTags('Backup & Restore'),
    swagger_1.ApiBearerAuth(),
    common_1.UseGuards(passport_1.AuthGuard()),
    common_1.Controller('backup'),
    __metadata("design:paramtypes", [backup_service_1.BackupService,
        logger_service_1.Logger])
], BackupController);
exports.BackupController = BackupController;
//# sourceMappingURL=backup.controller.js.map