/* 
 * GStreamer
 * Copyright (C) 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gstgleffectscurves.h"

/* CURVE for the heat signature effect */
const GstGLEffectsCurve xpro_curve = {
  256, 1, 3,
  "\0\0\37\0\0\37\0\1\40\0\2!\0\2\"\0\3\"\1\4%\1\4%\1\5%\1\5'\1\7'\1\7(\1\7"
      "(\1\10*\1\11+\1\11,\1\12,\1\13/\1\14/\1\14" "1\2\15" "1\2\15" "1\2\16"
      "4\2\17" "" "4\3\17" "5\3\22" "7\3\22" "7\3\23" "8\3\24"
      "9\3\25;\3\26;\3\27<\3\27=\4\31"
      "=\4\33?\4\34@\5\34B\5\35C\5\36D\5\40D\5\40G\5!G\6\"H\6$H\7&J\7&K\7*M\7*M"
      "\10+N\10-P\11-P\11/R\11" "3R\11" "3T\12" "4U\12" "5U\13" "7W\14" "8Y\14"
      "9Y\14"
      "<Y\16=[\16@^\16@^\17C^\17D`\20F`\20Jb\22Jb\22Kc\23Me\24Nf\25Qg\26Rg\27Ti"
      "\27Wj\30Xl\31Yl\33\\m\34^p\35`p\40bp\40fq!fr$gt$lt%lu'mv(px*qy-ty/uz/x|0"
      "y}3|}4}~5\177\2018\203\2019\203\201;\204\202=\207\203?\210\204@\214\204C"
      "\214\206D\216\207G\217\210H\223\211K\223\211M\225\212P\226\214Q\231\215T"
      "\232\215U\234\216X\235\217Y\240\220\\\241\220^\243\221`\244\223b\246\224"
      "e\250\224f\252\225i\253\226l\255\227m\256\231p\261\231q\262\232t\264\233"
      "v\265\234x\267\234z\270\235|\271\236~\274\240\201\275\240\202\277\241\204"
      "\300\242\207\302\243\210\303\243\212\305\244\214\306\245\216\307\246\220"
      "\311\250\221\313\250\224\315\251\226\316\252\227\317\253\232\321\253\234"
      "\322\254\235\323\255\240\325\256\242\326\256\242\330\256\245\331\261\250"
      "\331\262\251\332\262\253\334\263\255\335\264\256\336\265\261\340\266\263"
      "\341\266\264\342\267\266\343\270\270\344\271\271\344\271\271\346\273\276"
      "\347\274\277\350\275\277\351\275\302\352\276\304\353\277\306\353\300\307"
      "\355\300\311\356\301\314\356\302\315\357\303\317\360\304\320\360\304\322"
      "\361\305\323\362\306\325\362\307\327\363\307\330\363\310\330\364\311\333"
      "\364\313\334\365\313\336\365\314\340\365\314\342\366\316\342\366\316\346"
      "\367\317\347\367\320\351\367\320\353\370\322\354\370\322\356\370\323\356"
      "\370\324\360\371\325\360\371\325\363\371\326\363\371\327\363\372\330\365"
      "\372\330\366\372\331\366\372\331\370\372\332\371\373\332\371\373\333\372"
      "\373\334\373\373\335\373\373\336\374\373\336\374\374\337\374\374\340\375"
      "\374\341\375\374\341\376\374\342\376\374\343\376\374\344\376\374\344\377"
      "\374\345\377\374\346\377\375\346\377\375\346\377\375\347\377\375\350\377"
      "\375\351\377\375\352\377\375\352\377\375\352\377\375\353\377\375\353\377"
      "\376\354\377\376\354\377\376\356\377\376\356\377\376\356\377\376\357\377"
      "\376\360\377\376\360\377\376\360\377\376\360\377\376\362\377\376\362\377"
      "\376\363\377\376\363\377\376\363\377\376\363\377\376\364\377\376\364\377"
      "\376\365\377\377\365\377\377\366\377\377\366\377\377\366\377\377\367\377"
      "\377\367\377\377\367\377\377\370",
};

const GstGLEffectsCurve luma_xpro_curve = {
  256, 1, 3,
  "\0\0\1\0\1\1\0\1\2\0\1\2\0\1\2\0\1\2\0\1\3\0\2\3\0\2\4\0\2\4\0\2\5\0\2\6"
      "\0\3\6\0\3\6\0\3\7\0\3\10\0\4\10\0\4\11\0\4\12\0\4\12\1\4\13\1\5\14\1\5\15"
      "\1\5\15\1\5\16\1\5\17\1\6\17\1\6\20\1\7\21\1\7\23\2\10\23\2\10\24\2\10\24"
      "\2\11\26\2\11\27\2\11\30\3\11\31\3\12\31\3\13\32\3\13\33\4\13\34\4\14\35"
      "\4\14\36\4\15\37\5\15\40\5\15\"\6\16#\6\17#\6\20$\7\20%\7\20%\10\21&\10\22"
      "'\10\22)\11\24*\11\24*\12\24+\12\26.\13\26.\14\27.\14\30/\15\31"
      "1\15\31" "" "2\16\32" "3\16\33" "3\20\33" "5\20\35" "6\20\36" "7\22\37"
      "7\23\"9\23#9\24$" ":\25$<\27&<\27'=\31'?\31)?\32*@\35+B\35-C\36.C\37"
      "1E\"2F#3H$5H&6I'7I)7K"
      "+:M-<N-<N1@N1BQ2BQ6CQ6EU7HU<IU=IV@NX@NXBQZCS[FU[HU]IV_MZ_N[_Q]`S_bU`dXbe"
      "Zbe]gg]ig`ji`jjdljenlgpljqnpwppwpqxqszqw|sx}u|\201u}\203w\177\204x\177\206"
      "x\204\210x\204\212z\212\213|\212\217}\217\221}\221\222}\222\224\177\226\224"
      "\201\226\226\203\230\233\203\235\235\204\236\235\204\236\236\210\244\242"
      "\210\244\242\210\245\244\212\251\245\213\252\251\213\254\252\215\257\254"
      "\215\261\256\217\261\257\221\266\261\221\267\261\222\273\264\224\273\267"
      "\224\274\267\224\276\273\230\301\273\230\302\274\231\304\276\231\307\302"
      "\233\312\302\235\312\304\235\314\306\236\316\307\240\320\311\240\321\314"
      "\242\324\315\242\325\316\244\327\320\245\332\321\245\333\321\245\334\323"
      "\251\335\325\251\335\330\252\341\332\254\341\332\256\344\334\256\346\334"
      "\256\347\337\257\347\340\261\350\340\263\351\342\263\352\344\264\354\345"
      "\266\355\346\266\356\347\267\357\350\271\360\351\273\361\352\273\362\352"
      "\274\362\355\276\364\356\277\364\357\277\365\360\277\365\360\302\366\361"
      "\302\367\361\304\370\363\304\370\363\307\370\364\307\371\364\311\371\366"
      "\312\372\367\312\372\367\314\372\367\316\373\370\316\373\370\320\373\371"
      "\320\374\371\321\374\372\323\374\372\324\375\372\325\375\372\325\375\373"
      "\327\375\373\330\375\374\332\375\374\333\375\375\334\376\375\334\376\375"
      "\335\376\375\337\376\375\337\376\375\340\376\376\342\376\376\344\376\376"
      "\344\376\376\345\376\376\346\376\376\347\376\376\350\377\376\351\377\377"
      "\353\377\377\354\377\377\356\377\377\357\377\377\361\377\377\361\377\377"
      "\361\377\377\364\377\377\365\377\377\366\377\377\367\377\377\367\377\377"
      "\371\377\377\371\377\377\372\377\377\373\377\377\373\377\377\374\377\377"
      "\375\377\377\375\377\377\375\377\377\376",
};

/* CURVE for the heat signature effect */
const GstGLEffectsCurve heat_curve = {
  256, 1, 3,
  "\0\0\0\0\0\0\0\1\0\0\1\0\0\1\1\0\2\1\0\2\1\1\2\1\1\2\2\1\2\2\1\3\2\1\3\3"
      "\1\3\3\1\4\3\1\4\4\1\5\4\1\5\5\2\5\6\2\6\6\2\6\7\2\6\7\2\7\7\2\7\11\2\10"
      "\11\2\10\12\3\11\13\3\11\13\3\11\14\3\12\15\3\12\17\3\13\17\3\14\20\3\14"
      "\22\4\15\23\4\16\24\4\16\26\4\16\27\4\17\31\4\20\34\4\21\34\5\21\40\5\22"
      "\40\5\22$\5\23$\5\25&\6\25(\6\26-\6\26-\6\27" "0\6\31" "2\7\31"
      "5\7\32;\7\34"
      ";\7\34?\10\35C\10\36G\10\37L\10\40V\11!V\11\"[\11$a\11&l\12&l\12'r\12(~\13"
      "*~\13,\204\14,\213\14.\221\14/\227\14" "1\236\15" "2\244\15" "4\252\15"
      "5\260" "\16" "7\267\16"
      "8\275\17:\302\17;\310\17=\323\20?\323\21@\330\21D\335\21D"
      "\342\22E\346\22I\353\23I\356\23K\362\24M\365\24N\370\25P\372\26R\374\26T"
      "\376\26V\377\27X\377\27Z\377\30\\\376\31`\376\31`\375\32b\373\32d\371\33"
      "f\366\34j\363\34j\360\35l\354\36n\350\36r\344\37r\337\40t\333\40w\326!y\321"
      "\"|\314#~\307$\201\301$\204\267%\207\267&\212\261'\214\254(\217\247(\222"
      "\241)\226\234*\231\227+\234\222,\237\216-\242\211.\245\205/\251\2010\254"
      "}1\257z2\262w3\266t4\271p5\274m6\277j7\302f8\305c9\310`:\314\\;\317Y<\321"
      "V>\324S?\327P@\332LA\335IB\337FC\342CE\344@F\347=G\351;I\3538I\3558M\357"
      "3P\3610S\363.V\365+Y\366)\\\370'`\371%d\372#g\373\"l\374\40p\374\37t\374"
      "\35t\375\34}\376\33\202\376\32\202\375\31\213\375\30\220\375\27\225\375\27"
      "\232\373\26\237\372\25\244\371\24\251\370\23\256\367\23\262\367\22\267\364"
      "\21\274\362\20\300\361\20\305\357\17\311\355\16\311\353\16\322\351\15\326"
      "\346\15\332\346\14\336\344\14\341\337\13\341\335\13\350\332\12\353\330\11"
      "\356\330\11\360\322\10\362\320\10\364\320\10\364\312\7\366\307\7\366\304"
      "\7\367\302\6\367\277\6\370\274\5\367\271\5\367\271\5\367\263\4\365\260\4"
      "\364\255\4\363\253\3\362\250\3\361\245\3\360\242\3\357\240\3\357\235\2\355"
      "\232\2\355\227\2\354\225\2\353\221\1\353\216\1\353\216\1\353\213\1\353\204"
      "\1\353\201\1\354}\1\354y\0\354v\0\355r\0\355n\0\355j\0\356f\0\356b\0\357"
      "_\0\357[\0\357W\0\357S\0\360O\0\360O\0\361K\0\361C\0\362@\0\363<\0\3638\0"
      "\3648\0\3641\0\365.\0\366+\0\366'\0\367'\0\370!\0\370\36\0\370\33\0\371\30"
      "\0\371\26\0\373\26\0\373\23\0\374\15\0\374\13\0\375\10\0\375\5\0\376\3\0",
};

const GstGLEffectsCurve sepia_curve = {
  256, 1, 3,
  "\0\0\0\0\0\0\0\0\0\0\1\0\1\1\0\1\1\0\1\1\1\2\1\1\2\2\1\3\2\1\3\2\1\3\2\1"
      "\4\3\2\4\3\2\4\3\2\6\4\2\6\4\2\6\4\2\7\5\2\7\5\3\11\6\3\11\6\3\12\7\3\13"
      "\10\3\15\10\4\16\11\4\17\11\4\21\12\4\22\13\4\22\13\5\23\14\5\24\15\5\26"
      "\16\6\31\20\6\31\21\6\32\22\7\34\22\7\35\23\7\40\24\10\40\26\10!\26\11#\30"
      "\11&\31\12&\32\12'\34\13)\34\13*\37\13,\37\13-\40\14.\"\15" "0\"\15"
      "2#\17" "" "3&\17" "4&\17" "5'\20" "8(\21"
      "9)\21:*\23<,\23=-\23A.\24A0\25B0\25C2\26D3"
      "\30H4\30H7\31K7\32K8\32L9\33M:\34P<\34Q=\35S>\37T?\37UA\40VB!XC!ZD#\\F#^"
      "G#^J$`J&bK'bM'eM(fO)gP)iQ*kS,mT-mU-nV.oX/rY0sZ2u]2v]3w^3x`4za5{c7|c8~e8\177"
      "f9\200i:\203i<\204j<\206k=\207m>\210n?\211o?\213qA\214rC\215sC\217uD\220"
      "vD\221wF\223xG\224zH\225{J\227|K\230~K\231\177L\232\200M\234\202O\235\203"
      "P\236\204Q\240\206Q\241\207S\242\210T\243\211U\245\213V\246\214X\247\215"
      "Y\250\217Y\252\220Z\253\221\\\254\223]\254\224^\255\225`\257\227a\260\230"
      "b\261\231c\262\232e\264\234e\265\235f\266\236g\267\240i\267\241i\272\242"
      "k\273\243m\274\245n\274\246o\276\247q\277\250r\300\252s\301\253u\302\254"
      "v\304\255w\305\257x\306\257z\306\261{\307\262|\310\264~\310\265\177\313\266"
      "\200\314\267\202\315\267\203\316\272\204\317\273\206\317\274\207\320\276"
      "\210\322\277\211\323\277\213\324\301\214\325\302\215\326\304\217\326\305"
      "\220\327\306\221\327\307\223\331\310\224\333\311\225\334\311\227\334\313"
      "\227\335\315\231\335\316\231\337\317\234\340\320\235\341\320\235\341\323"
      "\240\342\324\241\343\324\242\343\326\243\345\327\245\345\330\245\346\331"
      "\250\346\333\252\347\334\253\351\335\254\351\335\255\351\337\257\352\340"
      "\260\353\341\260\354\342\262\355\343\264\355\344\265\355\345\266\356\346"
      "\266\356\347\272\357\350\273\360\351\274\360\351\276\361\352\277\361\353"
      "\300\362\353\301\362\354\302\362\355\304\362\356\305\364\357\305\364\357"
      "\310\364\360\311\365\361\313\365\361\314\366\362\315\366\362\316\366\363"
      "\316\367\364\320\367\364\320\367\365\324\367\365\324\370\366\326\370\366"
      "\327\371\366\330\371\367\331\371\367\333\371\370\333\372\370\336\372\370"
      "\336\372\371\340\373\371\341\373\372\342\373\372\343\374\372\344\374\373"
      "\344\374\373\347\374\374\350\375\374\351\375\374\351\375\374\352\375\375"
      "\352\376\375\353\376\376\355\376\376\356\376\376\357\377\377\357",
};

const GstGLEffectsCurve xray_curve = {
  256, 1, 3,
  "\377\377\377\377\377\377\376\376\376\375\375\376\374\375\375\373\374\375"
      "\372\374\374\371\374\374\370\373\373\366\373\372\366\372\372\365\372\371"
      "\363\371\371\363\371\370\362\370\370\360\370\367\360\367\366\357\367\365"
      "\356\366\365\355\366\364\353\365\363\353\365\363\352\364\362\351\363\362"
      "\347\363\361\346\362\361\345\362\361\344\362\360\343\361\357\343\361\356"
      "\342\360\356\341\360\356\340\357\355\336\356\354\336\356\354\335\355\353"
      "\334\355\353\333\355\352\331\354\351\331\353\351\330\353\350\327\353\350"
      "\325\352\347\325\351\347\324\350\346\323\350\345\322\347\344\321\347\344"
      "\320\347\344\317\346\343\316\346\342\315\345\341\314\344\341\313\344\340"
      "\312\344\340\311\343\337\310\342\337\307\342\335\306\341\335\305\341\335"
      "\303\340\334\303\337\333\302\337\333\301\337\332\300\336\331\276\335\331"
      "\276\334\330\274\334\330\274\334\327\273\333\327\272\333\326\271\332\325"
      "\270\332\325\267\331\324\266\330\323\265\330\323\264\327\322\263\327\321"
      "\262\326\320\261\325\320\257\325\317\257\324\317\256\324\316\254\323\315"
      "\254\322\315\253\322\314\252\321\313\251\321\313\250\320\312\246\317\311"
      "\245\317\311\245\316\310\244\316\307\243\315\307\242\314\306\241\314\305"
      "\240\312\305\237\312\304\236\312\303\235\311\303\234\311\302\233\307\301"
      "\232\307\300\231\307\300\230\306\277\227\305\276\226\305\276\225\304\275"
      "\224\303\274\223\303\273\222\302\273\221\301\272\220\301\271\217\300\270"
      "\216\277\270\215\277\267\214\276\266\213\275\265\212\275\265\211\274\264"
      "\210\273\263\207\273\262\206\272\262\205\271\261\204\270\260\203\270\257"
      "\202\267\257\201\266\256\200\266\255\177\265\254~\264\253}\263\253|\263\252"
      "{\262\251z\261\250y\260\247x\260\247w\257\246v\256\245u\255\244t\255\243"
      "s\254\243r\253\242q\252\241p\252\240o\251\237n\250\236m\247\235l\246\235"
      "l\246\235j\245\233i\244\232h\243\231g\242\230f\242\227e\241\226d\240\226"
      "c\237\225b\236\224a\235\223`\234\222_\234\221_\233\220]\232\217\\\231\216"
      "\\\230\215Z\227\214Y\226\214X\226\213W\225\212V\224\211U\223\210T\222\207"
      "S\221\206R\221\205Q\217\204P\216\203O\215\202N\215\201M\214\200M\213\177"
      "K\212~J\211}I\211|H\210|G\206zG\205zE\204xD\203vC\203vB\201tA\200s@\200q"
      "@~p>}o>|o<{l<yk;xi9wh8wg8te6sd5qd4pa3n_2m]1k\\0j\\0hY.fW-dU,cT+aR*_P)_O("
      "]M'YK'XI%VI$TF$RD\"OB!M@\40K?\37I=\37G=\35E9\34C9\34A5\33>5\31<2\31<0\27"
      ":.\27" "5,\26" "3*\24"
      "1*\23.&\22.&\22*\"\21'\40\17%\36\16\"\34\15\"\32\14"
      "\36\32\13\33\26\13\31\24\11\26\22\11\24\20\7\24\16\6\21\16\5\14\14\4\12\10"
      "\3\7\6\3\5\4\1\2\2",
};
