# Generated by Django 3.1 on 2020-09-07 07:54

from django.db import migrations

from django_etebase.models import AccessLevels


def change_access_level_to_int(apps, schema_editor):
    CollectionMember = apps.get_model("django_etebase", "CollectionMember")
    CollectionInvitation = apps.get_model("django_etebase", "CollectionInvitation")

    for member in CollectionMember.objects.all():
        if member.accessLevelOld == "adm":
            member.accessLevel = AccessLevels.ADMIN
        elif member.accessLevelOld == "rw":
            member.accessLevel = AccessLevels.READ_WRITE
        elif member.accessLevelOld == "ro":
            member.accessLevel = AccessLevels.READ_ONLY
        member.save()

    for invitation in CollectionInvitation.objects.all():
        if invitation.accessLevelOld == "adm":
            invitation.accessLevel = AccessLevels.ADMIN
        elif invitation.accessLevelOld == "rw":
            invitation.accessLevel = AccessLevels.READ_WRITE
        elif invitation.accessLevelOld == "ro":
            invitation.accessLevel = AccessLevels.READ_ONLY
        invitation.save()


class Migration(migrations.Migration):

    dependencies = [
        ("django_etebase", "0027_auto_20200907_0752"),
    ]

    operations = [
        migrations.RunPython(change_access_level_to_int),
    ]
