/*
   Copyright (C) 2001-2021 Graeme Walker <graeme_walker@users.sourceforge.net>
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

//
// fakemc.c
//
// A nasty little utility to create the files normally
// generated by microsoft's "mc" message compiler. This
// is intended to be used when the Windows development
// environment (eg. MinGW) does not come with a message
// compiler of its own.
//
// usage: fakemc [<messages_mc_path>]
//
// The output files are put into the same directory as
// the given file, but otherwise the command-line
// parameter is not used.
//

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

static char * dirname( const char * path )
{
	char * dir  = strdup( path ) ; // leak
	char * p = strrchr( dir , '\\' ) ;
	if( p ) *p = '\0' ;
	return p ? dir : "." ;
}

static char * join( const char * dir , const char * filename )
{
	char * p = malloc( strlen(dir) + strlen(filename) + 2U ) ; // leak
	if( p == NULL ) abort() ;
	if( 0 != strcmp(dir,".") )
	{
		strcpy( p , dir ) ;
		strcat( p , "\\" ) ;
	}
	strcat( p , filename ) ;
	return p ;
}

int main( int argc , char * argv [] )
{
	// data for message ids 1001, 1002, 1003, 1011, 1012, 1013
	static unsigned int i , bin[] = {
		0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
		0xe9, 0x03, 0x00, 0x40, 0xe9, 0x03, 0x00, 0x40, 0x70, 0x00, 0x00, 0x00, 0xf3, 0x03, 0x00, 0x40,
		0xf3, 0x03, 0x00, 0x40, 0x84, 0x00, 0x00, 0x00, 0xea, 0x03, 0x00, 0x80, 0xea, 0x03, 0x00, 0x80,
		0x94, 0x00, 0x00, 0x00, 0xf4, 0x03, 0x00, 0x80, 0xf4, 0x03, 0x00, 0x80, 0xa8, 0x00, 0x00, 0x00,
		0xeb, 0x03, 0x00, 0xc0, 0xeb, 0x03, 0x00, 0xc0, 0xb8, 0x00, 0x00, 0x00, 0xf5, 0x03, 0x00, 0xc0,
		0xf5, 0x03, 0x00, 0xc0, 0xcc, 0x00, 0x00, 0x00, 0x18, 0x00, 0x01, 0x00, 0x47, 0x00, 0x65, 0x00,
		0x6e, 0x00, 0x65, 0x00, 0x72, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x0d, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x14, 0x00, 0x01, 0x00, 0x25, 0x00, 0x31, 0x00, 0x21, 0x00, 0x53, 0x00, 0x21, 0x00, 0x0d, 0x00,
		0x0a, 0x00, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00, 0x25, 0x00, 0x31, 0x00, 0x0d, 0x00, 0x0a, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x01, 0x00, 0x25, 0x00, 0x31, 0x00, 0x21, 0x00, 0x53, 0x00,
		0x21, 0x00, 0x0d, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00, 0x25, 0x00, 0x31, 0x00,
		0x0d, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x01, 0x00, 0x25, 0x00, 0x31, 0x00,
		0x21, 0x00, 0x53, 0x00, 0x21, 0x00, 0x0d, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00,
		0x25, 0x00, 0x31, 0x00, 0x0d, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 } ;

	char * dir = dirname( argc > 1 ? argv[1] : ".\\messages.mc" ) ;
	FILE * fp_rc = fopen( join(dir,"messages.rc") , "wt" ) ;
	FILE * fp_bin = fopen( join(dir,"MSG00001.bin") , "wb" ) ;
	if( !fp_rc || !fp_bin )
	{
		fprintf( stderr , "%s: failed\n" , argv[0] ) ;
		return 1 ;
	}
	for( i = 0 ; i < (sizeof(bin)/sizeof(bin[0])) ; i++ )
	{
		fprintf( fp_bin , "%c" , (char)(bin[i]) ) ;
	}
	fprintf( fp_rc , "%s\n" , "LANGUAGE 0x9,0x1" ) ;
	fprintf( fp_rc , "%s\n" , "1 11 \"MSG00001.bin\"" ) ;
	fclose( fp_rc ) ;
	fclose( fp_bin ) ;
	return 0 ;
}

