# 0.8.14 Release

- guid: 519cbfac-6db5-4594-8a38-dec4c84b134f
- author: Markus Raab
- pubDate: Thu, 19 Nov 2015 17:48:14 +0100
- shortDesc: adds massive documentation improvements & new or overhauled plugins

Again we managed to release with many new features and plugins (lua, enum,
list, crypto, csvstorage, conditionals, mathcheck, filecheck, logchange)
many fixes, and especially with a vastly improved polished documentation.

## Documentation Initiative

The Documentation Initiative is a huge success and now the documentation
of Elektra is in a state where someone (preferable a linux guru),
never heard of Elektra, still can use Elektra only by reading man pages.

There are now many ways to show a man page:

- [on github](https://master.libelektra.org/doc/help/kdb.md)
- [in the API docu](https://doc.libelektra.org/api/master/html/doc_help_kdb_md.html)
- by using `kdb --help` or `kdb help <command>`
- by using `man kdb`

### Help system

Ian Donnelly wrote man pages for all the tools delivered with Elektra.
Additionally, nearly all README.md are now also converted to man pages
and also to Doxygen.

### Doxygen Filter

Kurt Micheli did an amazing work with a new doxygen filter.
The filter allows all Elektra markdown pages to be also included
in the doxygen documentation. Thus all technical concepts are now
explained in Markdown pages, this filter is essential.

But even more, the filter also includes all man pages written
for the tools, giving a nice html view for them. (In addition to
the markdown rendering on github).

Enjoy the [result](https://doc.libelektra.org/api/0.8.14/html/).

A big thanks to Kurt Micheli!

### Further Docu fixes

- getenv debugging docu was improved
- typo fix: Specify, thanks to Pino Toscano
- [Design decisions](https://master.libelektra.org/doc/decisions)
  Definition of Bool, capabilities and
  Publish Subscribe (thanks to Daniel Bugl)
- Improve iconv docu
- usage examples for many plugins
- improve README for line plugin (thanks to Ian Donnelly)
- add docu about dependencies for some plugins (thanks to Ian Donnelly)
- create many new links within the documentation

## Simplicity

We shifted our [goals](https://git.libelektra.org/blob/master/doc/GOALS.md)
a bit: We want to prefer simplicity to flexibility. Not because we
do no like flexibility, but because we think we achieved enough of it.
Currently (and in future) you can use Elektra:

- obviously as primitive key-value storage
- with specifications and dozens of plugins driven by it
- with code generation
- ...

But we cut flexibility regarding:

- namespaces are only useful for configuration (not for arbitrary key-value)
- the semantics of [metadata](https://git.libelektra.org/blob/master/doc/METADATA.ini)
- mounting functionality
- error code meanings are fixed, if a resolver detects a conflict, our defined
  error must be used
- of course ABI, API

## Qt-gui 0.0.9

Raffael Pancheri again updated his qt-gui to version 0.0.9 (beta)
with important of fixes and improvements:

- Fixes for Qt 5.5
- Handling of merge-conflicts improved
- Avoid rewriting on merge-conflicts
- Allow QML to destroy C++ owned model
- Dialog at startup
- Reduce memory footprint
- add man page

A bit thanks to Raffael Pancheri!

## Compatibility

As always, the API and API is fully forward-compatible, i.e. programs
compiled against an older 0.8 versions of Elektra will continue to work.

The behaviour of some plugins, however, changed:

- the INI plugin, the section handling was improved.
- in the NI plugin, the symbol Ni_GetVersion vanished
- in the resolver plugin files of other namespaces which are not
  mounted are not resolved anymore

### Build System

ENABLE_CXX11 does not exist anymore, it is always on.
We do not care about 199711L compilers anymore, which
makes development easier, without losing any actually
used platform.

Some programs that are only used in-source are not installed
anymore. (by Pino Toscano)

Python and Lua plugins are enabled now in `-DPLUGINS=ALL`.

Python3 plugin was renamed to python.

## Lua Plugin

Manuel Mausz add a lightweight alternative to the python plugin:
[the lua plugin](https://master.libelektra.org/src/plugins/lua/).
In a similar way, someone can write scripts, which are executed on every
access to the
[key database](https://master.libelektra.org/doc/help/elektra-glossary.md).

To mount a lua based filter, you can use:

```sh
kdb mount file.ini /lua ini lua script=/path/to/lua/lua_filter.lua
```

Even though it works well, it is classified as technical preview.

Thanks to Manuel Mausz for this plugin!

## Cryptography Plugin

In this technical preview, Peter Nirschl
[demonstrates how a plugin](https://master.libelektra.org/src/plugins/crypto/)
can encrypt Elektra’s values. In test cases it is already able to do so,
but for the end user an easy way for key derivation is missing.

A big thanks to Peter Nirschl!

## INI Plugin

The INI plugin got a near rewrite. Now it handles many situations better,
has many more options and features, including:

- preserving the order
- using keys as metadata
- many new test cases
- fix escaping

Thanks to Thomas Waser for this work!

## Mathcheck plugin

This plugin allows you to check and even calculate keys from
other keys using an polish prefix notation.
It supports the typical operations `+ - / *` and
`<, <=, ==, !=, =>, >, :=`. To mount, check and
calculate values, one would use:

```sh
kdb mount mathcheck.dump /example/mathcheck dump mathcheck
kdb setmeta user/example/mathcheck/k check/math "== + a b"
kdb setmeta user/example/mathcheck/k check/math ":= + a b"
```

For details [see the documentation](https://master.libelektra.org/src/plugins/mathcheck/).

Thanks to Thomas Waser for this important plugin!

## List Plugin

Currently, Elektra has some limitations on how many plugins can be
added to certain
[placement](https://master.libelektra.org/doc/dev/plugins-ordering.md).
Because of the rapidly growing number of plugins, some combinations
are not possible anymore.

This plugin tackles the issue, by delegating the work to an arbitrary
number of subplugins. As a bonus, it works lazily and thus might avoid
the loading of some plugins all together.

Thanks to Thomas Waser for this plugin!

## Conditionals

Brings `if` inside Elektra. It lets you check if some keys have
the values they should have.

```sh
kdb mount conditionals.dump /tmount/conditionals conditionals dump
kdb set user/tmount/conditionals/fkey 3.0
kdb set user/tmount/conditionals/hkey hello
kdb setmeta user/tmount/conditionals/key check/condition "(hkey == 'hello') ? (fkey == '3.0')" # success
kdb setmeta user/tmount/conditionals/key check/condition "(hkey == 'hello') ? (fkey == '5.0')" # fail
```

For details [see the documentation](https://master.libelektra.org/src/plugins/conditionals/).

Again, thanks to Thomas Waser for this plugin!

## Csvstorage Plugin

You can now mount csv-files. To mount `test.csv` simply use:

```sh
kdb mount test.csv /csv csvstorage
```

There are many options, e.g. changing the delimiter, use header
for the key names or predefine how the columns should be named.
For details [see the documentation](https://master.libelektra.org/src/plugins/csvstorage/).

Thanks to Thomas Waser!

## Filecheck plugin

This plugin lets you validate lineendings, encodings, null, bom and
unprintable characters.

The also new plugin lineendings is already superseded by the filecheck
plugin.

Thanks to Thomas Waser!

## Enum plugin

The Enum plugin checks string values of Keys by comparing it against a
list of valid values.

Thanks to Thomas Waser!

## Elektrify Machinekit.io

We are proud that [Machinekit](http://www.machinekit.io/) starts using
Elektra.

Alexander Rössler is digging into all details, and already enhanced
the DBUS Plugin for their needs. DBus now can emit a message for every
changed key.

A big thanks to Alexander Rössler!

## Bugfixes

- libgetenv did not reinitalized its mutexes on forks
- add needSync also in C++ binding
- handle removed current working directories (fallback to /)
- avoid segfault on missing version keys (when doing `kdb rm system/elektra/version`)
- fix glob plugin + kdb mount with
  [config/needs usage](https://master.libelektra.org/doc/help/elektra-contracts.md)
- fix different handling of strerror_r in macOS (thanks to Daniel Bugl)
- do not change the users parentKey in early-error scenarios
- do not try to interpret some binary keys as function keys

## Other Gems

- getenv example: do not link to elektra/elektratools,
  thanks to Pino Toscano
- fixes in other examples
- avoid useless UTF-8 chars and fix typos, thanks to Kurt Micheli
- fix kdb check return code (open fail)
- pdf now also allows UTF-8 characters if added to
  elektraSpecialCharacters.sty, thanks to Kurt Micheli
- libgetenv: lookup also used for layers
- handle wrong arguments of metals better, thanks to Ian Donnelly
- Improvement of error messages in the augeas plugin
- `kdb set` avoids fetching unnecessary namespaces
- verbose unmount
- logchange: small demonstration plugin to show how to log added,
  removed and changed keys
- setmeta will use spec as default
- libtools: avoid useless getName, add verbosity flag for findBackend
- Improve iconv error messages
- That mount needs permissions to /etc should now really be obvious
  with new error message
- many fixes in the template for new plugins

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.14.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.14.tar.gz)

- name: elektra-0.8.14.tar.gz
- size: 2252008
- md5sum: a87cd3845e590bf413959dfd555e3704
- sha1: 2360603c347ae3f3a28e827eb9260ff0b9881e46
- sha256: af681a38c9c2921b8d249f98ab851c3d51371735471d8a1f833a224c4446fe2e

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.14.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.14/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/519cbfac-6db5-4594-8a38-dec4c84b134f.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Btw. the whole release happened with
[elektrify-getenv](https://master.libelektra.org/src/libs/getenv/README.md)
enabled.

Best regards,
Markus
