function (elektra_export_plugin_symbols)
	cmake_parse_arguments (ARG "" "SOURCE;HEADER;RESOLVER;STORAGE" "PLUGINS" ${ARGN})

	if (NOT ARG_SOURCE)
		message (FATAL_ERROR "HEADER must be provided")
	endif ()

	if (NOT ARG_HEADER)
		message (FATAL_ERROR "HEADER must be provided")
	endif ()

	if (NOT ARG_RESOLVER)
		message (FATAL_ERROR "HEADER must be provided")
	endif ()

	if (NOT ARG_STORAGE)
		message (FATAL_ERROR "HEADER must be provided")
	endif ()

	file (
		WRITE ${ARG_HEADER}
		"/* exported_symbols.h generated by exportsymbols \n"
		" *\n"
		" * The static case\n"
		" *\n"
		" * Struct which contain export symbols\n"
		" *  Format :\n"
		" *  --------\n"
		" *\n"
		" *  filename, NULL\n"
		" *  symbol1, &func1,\n"
		" *  symbol2, &func2,\n"
		" *  filename2, NULL\n"
		" *  symbol1, &func1,\n"
		" *  symbol2, &func2,\n"
		" *  ....\n"
		" *  symboln, &funcn,\n"
		" *  NULL, NULL\n"
		" */\n\n"
		"typedef struct {\n"
		"	const char *name;\n"
		"	void (*function)(void);\n"
		"} kdblib_symbol;\n\n"
		"extern kdblib_symbol kdb_exported_syms[];\n\n")

	file (APPEND ${ARG_HEADER} "extern void libelektra_${ARG_RESOLVER}_LTX_elektraPluginSymbol (void);\n")
	file (APPEND ${ARG_HEADER} "extern void libelektra_${ARG_STORAGE}_LTX_elektraPluginSymbol (void);\n")

	file (WRITE ${ARG_SOURCE} "/* exported_symbols.c generated by exportsymbols.sh */\n\n" "#include <exported_symbols.h>\n\n"
				  "kdblib_symbol kdb_exported_syms[] =\n" "{\n")

	file (APPEND ${ARG_SOURCE} "\t{\"resolver\", 0},\n"
				   "\t{\"elektraPluginSymbol\", &libelektra_${ARG_RESOLVER}_LTX_elektraPluginSymbol},\n")
	file (APPEND ${ARG_SOURCE} "\t{\"storage\", 0},\n"
				   "\t{\"elektraPluginSymbol\", &libelektra_${ARG_STORAGE}_LTX_elektraPluginSymbol},\n")
	file (APPEND ${ARG_SOURCE} "\t{\"${ARG_STORAGE}\", 0},\n"
				   "\t{\"elektraPluginSymbol\", &libelektra_${ARG_STORAGE}_LTX_elektraPluginSymbol},\n")

	foreach (PLUGIN ${ARG_PLUGINS})
		file (APPEND ${ARG_HEADER} "extern void libelektra_${PLUGIN}_LTX_elektraPluginSymbol (void);\n")

		file (APPEND ${ARG_SOURCE} "\t{\"${PLUGIN}\", 0},\n"
					   "\t{\"elektraPluginSymbol\", &libelektra_${PLUGIN}_LTX_elektraPluginSymbol},\n")
	endforeach ()

	file (APPEND ${ARG_SOURCE} "\t{ 0 , 0 }\n" "};\n")
endfunction (elektra_export_plugin_symbols)
