#ifndef _drv_vmmc_con_H
#define _drv_vmmc_con_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************/

/**
   \file drv_vmmc_con.h
   This file contains the declaration of the connection module.
*/

/* ============================= */
/* Includes                      */
/* ============================= */
#include "drv_vmmc_api.h"
#include "drv_tapi_ll_interface.h"

/* ============================= */
/* Global Defines                */
/* ============================= */

/* ============================= */
/* Global Types                  */
/* ============================= */

/** defines which output of the signaling module is to be used
    ALM, PCM and AUDIO are normally attached on local side and COD on remote side */
typedef enum
{
   REMOTE_SIG_OUT = 0,
   LOCAL_SIG_OUT = 1
} SIG_OUTPUT_SIDE;

/** which signaling input is used for local (with auto suppression) and remote
    (with event playout) connections. This is fixed by firmware */
enum
{
   REMOTE_SIG_IN = 1,
   LOCAL_SIG_IN = 0
};

/** Module types of the firmware */
typedef enum
{
   VMMCDSP_MT_ALM,
   VMMCDSP_MT_SIG,
   VMMCDSP_MT_COD,
   VMMCDSP_MT_AUDIO,
   VMMCDSP_MT_PCM,
   VMMCDSP_MT_DECT,
   VMMCDSP_MT_AUDIO_AUX,
   VMMCDSP_MT_AUDIO_DIAG0_IN,
   VMMCDSP_MT_AUDIO_DIAG0_OUT,
   VMMCDSP_MT_AUDIO_DIAG1_IN,
   VMMCDSP_MT_AUDIO_DIAG1_OUT,
   VMMCDSP_MT_AUDIO_LOOP0,
   VMMCDSP_MT_AUDIO_LOOP1,
   VMMCDSP_MT_LIN
} VMMCDSP_MT;

/** Defines module sampling operation mode */
typedef enum
{
   /** Module sampling is disabled */
   VMMC_CON_SMPL_OFF,
   /** Module can only operate in narrowband mode */
   VMMC_CON_SMPL_NB,
   /** Module can only operate in wideband mode */
   VMMC_CON_SMPL_WB,
   /** Module can operate in both - NB and WB - mode. Actual mode is
       determined by the operation mode of conference this module belongs to. */
   VMMC_CON_SMPL_AUTO
} VMMC_CON_SAMPLING;

/* ============================= */
/* Global Variables              */
/* ============================= */

/* ============================= */
/* Global function declaration   */
/* ============================= */

extern IFX_int32_t VMMC_CON_Allocate_Ch_Structures (VMMC_CHANNEL *pCh);
extern IFX_void_t VMMC_CON_Free_Ch_Structures (VMMC_CHANNEL *pCh);

extern IFX_void_t VMMC_CON_Init_AlmCh (VMMC_CHANNEL *pCh);
extern IFX_void_t VMMC_CON_Init_PcmCh (VMMC_CHANNEL *pCh, IFX_uint8_t pcmCh);
extern IFX_void_t VMMC_CON_Init_CodCh (VMMC_CHANNEL *pCh);
extern IFX_void_t VMMC_CON_Init_SigCh (VMMC_CHANNEL *pCh);
#ifdef DECT_SUPPORT
extern IFX_void_t VMMC_CON_Init_DectCh (VMMC_CHANNEL *pCh);
#endif /* DECT_SUPPORT */
#if (VMMC_CFG_FEATURES & VMMC_FEAT_AUDIO)
extern IFX_void_t VMMC_CON_Init_AudioCh (VMMC_CHANNEL *pCh);
#endif /* (VMMC_CFG_FEATURES & VMMC_FEAT_AUDIO) */
extern IFX_void_t VMMC_CON_Init_LinCh (VMMC_CHANNEL *pCh);


extern IFX_uint8_t       VMMC_CON_Get_ALM_SignalInput   (VMMC_CHANNEL *pCh,
                                                         IFX_uint8_t index);

extern IFX_uint8_t       VMMC_CON_Get_PCM_SignalInput   (VMMC_CHANNEL *pCh,
                                                         IFX_uint8_t index);

extern IFX_uint8_t       VMMC_CON_Get_COD_SignalInput   (VMMC_CHANNEL *pCh,
                                                         IFX_uint8_t index);

extern IFX_uint8_t       VMMC_CON_Get_SIG_SignalInput   (VMMC_CHANNEL *pCh,
                                                         IFX_uint8_t index);

#ifdef DECT_SUPPORT
extern IFX_uint8_t       VMMC_CON_Get_DECT_SignalInput   (VMMC_CHANNEL *pCh,
                                                          IFX_uint8_t index);
#endif /* DECT_SUPPORT */

#if (VMMC_CFG_FEATURES & VMMC_FEAT_AUDIO)
extern IFX_uint8_t       VMMC_CON_Get_AUDIO_SignalInput (VMMC_DEVICE *pDev,
                                                         IFX_uint8_t ch,
                                                         IFX_uint8_t index);
extern IFX_uint8_t       VMMC_CON_Get_AUDIO_SignalStatus(VMMC_DEVICE *pDev,
                                                         IFX_uint8_t ch);
extern IFX_return_t      VMMC_CON_Set_AUDIO_SignalStatus(VMMC_DEVICE *pDev,
                                                         IFX_uint8_t ch,
                                                         IFX_uint8_t status);
extern IFX_uint8_t  VMMC_CON_Get_AUDIO_AUX_SignalInput  (VMMC_DEVICE *pDev,
                                                         IFX_uint8_t ch);
extern IFX_uint8_t  VMMC_CON_Get_AUDIO_AUX_SignalStatus (VMMC_DEVICE *pDev,
                                                         IFX_uint8_t ch);
extern IFX_return_t VMMC_CON_Set_AUDIO_AUX_SignalStatus (VMMC_DEVICE *pDev,
                                                         IFX_uint8_t ch,
                                                         IFX_uint8_t status);
extern IFX_return_t VMMC_CON_Interchange_AudioDataChannels(VMMC_DEVICE *pDev);
extern IFX_uint8_t VMMC_CON_Get_AUDIO_Loop0_SignalInput(VMMC_DEVICE *pDev,
                                                      IFX_uint8_t ch);
extern IFX_uint8_t VMMC_CON_Get_AUDIO_Loop0_SignalStatus( VMMC_DEVICE *pDev,
                                                        IFX_uint8_t ch);
extern IFX_return_t VMMC_CON_Set_AUDIO_Loop0_SignalStatus(VMMC_DEVICE *pDev,
                                                         IFX_uint8_t ch,
                                                         IFX_uint8_t status);
extern IFX_uint8_t VMMC_CON_Get_AUDIO_Loop1_SignalInput(VMMC_DEVICE *pDev,
                                                      IFX_uint8_t ch);
extern IFX_uint8_t VMMC_CON_Get_AUDIO_Loop1_SignalStatus( VMMC_DEVICE *pDev,
                                                        IFX_uint8_t ch);
extern IFX_return_t VMMC_CON_Set_AUDIO_Loop1_SignalStatus(VMMC_DEVICE *pDev,
                                                         IFX_uint8_t ch,
                                                         IFX_uint8_t status);
#endif /* (VMMC_CFG_FEATURES & VMMC_FEAT_AUDIO) */

#ifdef LIN_SUPPORT
extern IFX_uint8_t       VMMC_CON_Get_LIN_SignalInput   (VMMC_CHANNEL *pCh,
                                                         IFX_uint8_t index);
#endif /* LIN_SUPPORT */


extern IFX_void_t   VMMC_CON_Func_Register (IFX_TAPI_DRV_CTX_CON_t *pCON);

extern IFX_return_t VMMC_CON_ConnectPrepare    (VMMC_CHANNEL *pSrcCh,
                                                VMMCDSP_MT src,
                                                VMMC_CHANNEL *pDstCh,
                                                VMMCDSP_MT dst,
                                                SIG_OUTPUT_SIDE nSide);
#if 0
extern IFX_return_t VMMC_CON_DisconnectPrepare (VMMC_CHANNEL *pSrcCh,
                                                VMMCDSP_MT src,
                                                VMMC_CHANNEL *pDstCh,
                                                VMMCDSP_MT dst,
                                                SIG_OUTPUT_SIDE nSide);
#endif
extern IFX_return_t VMMC_CON_ConnectConfigure  (VMMC_DEVICE *pDev);


extern IFX_int32_t VMMC_CON_MatchConfSmplRate (VMMC_CHANNEL *pCh,
                                               VMMCDSP_MT start_module);

extern IFX_void_t VMMC_CON_ModuleSamplingModeSet (VMMC_CHANNEL *pCh,
                                                  VMMCDSP_MT src,
                                                  VMMC_CON_SAMPLING sampling_mode);

#endif /* _drv_vmmc_con_H */
