#ifndef _DRV_VMMC_COD_H
#define _DRV_VMMC_COD_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************/

/**
   \file drv_vmmc_cod.h  Header file of the CODer module.
   This file contains the defines and the global functions declarations
   of the coder module.
*/

/* ============================= */
/* Includes                      */
/* ============================= */
#include "drv_tapi_ll_interface.h"

/* ============================= */
/* Global Defines                */
/* ============================= */

/* ============================= */
/* Global Types                  */
/* ============================= */

/* ============================= */
/* Global function declaration   */
/* ============================= */
extern IFX_int32_t VMMC_COD_InitCh (VMMC_CHANNEL *pCh);
extern IFX_int32_t VMMC_COD_Set_Inputs (VMMC_CHANNEL *pCh);
extern IFX_int32_t VMMC_COD_baseConf (VMMC_CHANNEL *pCh);
extern IFX_int32_t VMMC_COD_ChStop (VMMC_CHANNEL *pCh);

extern IFX_void_t  VMMC_COD_Func_Register (IFX_TAPI_DRV_CTX_COD_t *pCOD);
extern IFX_int32_t VMMC_COD_Allocate_Ch_Structures (VMMC_CHANNEL *pCh);
extern IFX_void_t  VMMC_COD_Free_Ch_Structures (VMMC_CHANNEL *pCh);

extern IFX_int32_t VMMC_COD_SamplingMode (VMMC_CHANNEL *pCh,
                                          SM_ACTION action,
                                          OPMODE_SMPL mode);

IFX_TAPI_COD_TYPE_t VMMC_COD_trans_cod_fw2tapi (IFX_int8_t nCoder);

extern IFX_enDis_t  VMMC_COD_ChStatusGet (VMMC_CHANNEL *pCh);

extern IFX_int32_t VMMC_COD_ENC_Hold(VMMC_CHANNEL     *pCh,
                                     IFX_operation_t  nOnHold);

#endif /* _DRV_VMMC_COD_H */
