#ifndef _DRV_VMMC_ALM_H
#define _DRV_VMMC_ALM_H
/****************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

 ****************************************************************************
   Module      : drv_vmmc_alm.h
   Description : This file contains the defines, the function prototype
                  declarations for ALM module.
*******************************************************************************/

/* BBD coefficient block for sampling rate coefficients */
typedef struct
{
   IFX_uint16_t  blk0_offset;
   IFX_uint16_t  blk0_data0;
   IFX_uint16_t  blk0_data1;
   IFX_uint16_t  blk0_data2;
   IFX_uint16_t  blk0_data3;
   IFX_uint16_t  blk1_offset;
   IFX_uint16_t  blk1_data0;
   IFX_uint16_t  blk2_offset;
   IFX_uint16_t  blk2_data0;
} VMMC_ALM_SAMPLING_COEFS_t;

/* ALM line type */
typedef enum
{
   VMMC_ALM_LINE_FXS = 0,
   VMMC_ALM_LINE_FXO
} VMMC_ALM_LINE_TYPE_t;

#define MAX_ALM_NUM 3

/* function prototypes */

extern IFX_void_t  VMMC_ALM_Func_Register (IFX_TAPI_DRV_CTX_ALM_t *pAlm);
extern IFX_int32_t VMMC_ALM_Allocate_Ch_Structures (VMMC_CHANNEL *pCh);
extern IFX_void_t  VMMC_ALM_Free_Ch_Structures (VMMC_CHANNEL *pCh);
extern IFX_void_t  VMMC_ALM_InitCh (VMMC_CHANNEL *pCh);
extern IFX_int32_t VMMC_ALM_Set_Inputs (VMMC_CHANNEL *pCh);
extern IFX_int32_t VMMC_ALM_ChStop (VMMC_CHANNEL *pCh);

extern IFX_int32_t  VMMC_ALM_baseConf (VMMC_CHANNEL *pCh);

extern IFX_int32_t VMMC_ALM_SamplingMode (
                        VMMC_CHANNEL *pCh,
                        SM_ACTION action,
                        OPMODE_SMPL sigarray_mode,
                        OPMODE_SMPL module_mode);

extern IFX_int32_t VMMC_ALM_SamplingModeCoefficientStore (
                        VMMC_CHANNEL *pCh,
                        OPMODE_SMPL   mode,
                        VMMC_ALM_SAMPLING_COEFS_t *pSampl);

extern IFX_void_t irq_VMMC_ALM_LineDisable (VMMC_CHANNEL *pCh);

extern IFX_void_t VMMC_ALM_CorrectLinemodeCache (VMMC_CHANNEL *pCh,
                                                 IFX_uint16_t lm);

#if defined(SYSTEM_AR9) || defined(SYSTEM_VR9)
extern IFX_boolean_t VMMC_ALM_SmartSLIC_IsConnected (
                        VMMC_DEVICE *pDev);

extern IFX_int32_t   VMMC_ALM_SmartSLIC_ChGet (
                        VMMC_DEVICE *pDev,
                        IFX_uint8_t *nChannels,
                        IFX_uint8_t *nFXOChannels);
#endif /*SYSTEM_AR9 || SYSTEM_VR9*/

#endif /* _DRV_VMMC_ALM_H */
