#ifndef DRV_TAPI_IOCTL_H
#define DRV_TAPI_IOCTL_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

 *****************************************************************************
   \file
   \remarks
 *******************************************************************/

/* ============================= */
/* Includes                      */
/* ============================= */

/* ============================= */
/* Global structure definition   */
/* ============================= */

/** Generic structure for ioctl addressing. */
typedef struct
{
   /** Device index */
   IFX_uint16_t dev;
   /** Channel "module" index */
   IFX_uint16_t ch;
   /** Any parameter used by ioctls */
   IFX_uint32_t param;
} IFX_TAPI_IOCTL_t;

typedef struct
{
   /* Pointer to the TAPI device struct */
   TAPI_DEV            *pTapiDev;
   /* File descriptor number (IFX_TAPI_DEVICE_CH_NUMBER: device file descriptor
                              <>IFX_TAPI_DEVICE_CH_NUMBER: channel fds) */
   IFX_uint16_t         nFds;
   /** Parameter size if available, otherwise 0. The parameter size is given by the
      ioctl definition */
   IFX_uint32_t nParamSize;
   /** if IFX_TRUE it was copied from user space */
   IFX_uint32_t bUsrCpy : 1;
   /** the file descriptor is a single dev node without information
      about the channe and the device. The context is queried from the
      given ioctl structure */
   IFX_uint32_t bSingleFd : 1;
   /* linear channel fd */
   IFX_uint32_t bLinChFd : 1;
} IFX_TAPI_ioctlCtx_t;

/* ============================= */
/* Global function declaration   */
/* ============================= */

extern IFX_int32_t TAPI_Ioctl (
                        IFX_TAPI_ioctlCtx_t *pCtx,
                        IFX_uint32_t cmd,
                        IFX_ulong_t arg);

extern void IFX_TAPI_ioctlContextGet (
                        IFX_TAPI_DRV_CTX_t *pDrvCtx,
                        IFX_int32_t nMinor,
                        IFX_TAPI_ioctlCtx_t *pCtx);


extern IFX_int32_t  TAPI_OS_IoctlCh (
                        IFX_TAPI_DRV_CTX_t *pDrvCtx,
                        IFX_TAPI_ioctlCtx_t *pCtx,
                        TAPI_CHANNEL *pChannel,
                        IFX_uint32_t iocmd,
                        IFX_ulong_t ioarg,
                        IFX_int32_t *retLL);

#endif /* DRV_TAPI_IOCTL_H */

