#ifndef _DRV_TAPI_ANNOUNCEMENTS_H
#define _DRV_TAPI_ANNOUNCEMENTS_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

*******************************************************************************/

/**
   \file drv_tapi_announcements.h
   Interface of the TAPI announcements implementation.
   This file contains the declaration of the functions for the announcemets
   module.
*/

#include <ifx_types.h>
#include "drv_tapi.h"

extern IFX_int32_t IFX_TAPI_Ann_Cfg (TAPI_CHANNEL *pChannel,
   IFX_TAPI_COD_ANNOUNCE_CFG_t *pCfg);
extern IFX_int32_t IFX_TAPI_Ann_Start (TAPI_CHANNEL *pChannel,
   IFX_TAPI_COD_ANNOUNCE_START_t *pStart);
extern IFX_int32_t IFX_TAPI_Ann_Stop (TAPI_CHANNEL *pChannel);
extern IFX_int32_t IFX_TAPI_Ann_Free (TAPI_CHANNEL *pChannel,
   IFX_TAPI_COD_ANNOUNCE_BUFFER_FREE_t *pFree);
extern IFX_return_t IFX_TAPI_Ann_Init (IFX_void_t);
extern IFX_void_t IFX_TAPI_Ann_Cleanup (IFX_void_t);
extern IFX_void_t IFX_TAPI_AnnEndEventServe(TAPI_CHANNEL* pChannel);

#endif /* _DRV_TAPI_ANNOUNCEMENTS_H */
