"use strict";

var fs = require("fs");

// Max Analog value for your IrSensor from 0 to 1023
var max = 605,
    // This would most likely always be 0, but check datasheet
    // for min Vo and convert to 0-1023
    min = 0,
    // Check Datasheet for Max Vo generated by the sensor.
    maxVo = 3.1,
    // Substitute irModel for the model of your IR sensor like: gp2y0a41sk0f
    irSensorModel = "GP2Y0A02YK".toLowerCase();

console.log("Generating Analog and Vo Ranges ...");

var fileBegin = "module.exports = {\n" +
                "analogRange: { max: " + max + ", min: " + min + "},\n" +
                "rangeDistances:{\n";

var fileEnd = "};\n";

fs.writeFileSync(
  "" + irSensorModel + ".js",
  fileBegin, { flag: "a"},
  function(err){
    if (err) { throw err; }
  }
);

var errHandler = function(err){
  if (err) { throw err; }
};

var res = 0;
var data = "";

for (var i = max; i > 0; i = i- 5){
  res = (i / max) * maxVo;
  data = "" + i + ": {\n  dist: ?,\n  vo: " + res + "\n},\n";
  fs.writeFileSync(
    "" + irSensorModel + ".js",
    data,
    { flag: "a"},
  errHandler);
}

fs.writeFileSync(
  "" + irSensorModel + ".js",
  fileEnd, { flag: "a"},
  function(err){
    if (err) { throw err; }
  }
);
