// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/configitem"
)

// ConfigItemCreate is the builder for creating a ConfigItem entity.
type ConfigItemCreate struct {
	config
	mutation *ConfigItemMutation
	hooks    []Hook
}

// SetCreatedAt sets the "created_at" field.
func (cic *ConfigItemCreate) SetCreatedAt(t time.Time) *ConfigItemCreate {
	cic.mutation.SetCreatedAt(t)
	return cic
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (cic *ConfigItemCreate) SetNillableCreatedAt(t *time.Time) *ConfigItemCreate {
	if t != nil {
		cic.SetCreatedAt(*t)
	}
	return cic
}

// SetUpdatedAt sets the "updated_at" field.
func (cic *ConfigItemCreate) SetUpdatedAt(t time.Time) *ConfigItemCreate {
	cic.mutation.SetUpdatedAt(t)
	return cic
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (cic *ConfigItemCreate) SetNillableUpdatedAt(t *time.Time) *ConfigItemCreate {
	if t != nil {
		cic.SetUpdatedAt(*t)
	}
	return cic
}

// SetName sets the "name" field.
func (cic *ConfigItemCreate) SetName(s string) *ConfigItemCreate {
	cic.mutation.SetName(s)
	return cic
}

// SetValue sets the "value" field.
func (cic *ConfigItemCreate) SetValue(s string) *ConfigItemCreate {
	cic.mutation.SetValue(s)
	return cic
}

// Mutation returns the ConfigItemMutation object of the builder.
func (cic *ConfigItemCreate) Mutation() *ConfigItemMutation {
	return cic.mutation
}

// Save creates the ConfigItem in the database.
func (cic *ConfigItemCreate) Save(ctx context.Context) (*ConfigItem, error) {
	var (
		err  error
		node *ConfigItem
	)
	cic.defaults()
	if len(cic.hooks) == 0 {
		if err = cic.check(); err != nil {
			return nil, err
		}
		node, err = cic.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*ConfigItemMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = cic.check(); err != nil {
				return nil, err
			}
			cic.mutation = mutation
			if node, err = cic.sqlSave(ctx); err != nil {
				return nil, err
			}
			mutation.id = &node.ID
			mutation.done = true
			return node, err
		})
		for i := len(cic.hooks) - 1; i >= 0; i-- {
			if cic.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = cic.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, cic.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*ConfigItem)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from ConfigItemMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (cic *ConfigItemCreate) SaveX(ctx context.Context) *ConfigItem {
	v, err := cic.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (cic *ConfigItemCreate) Exec(ctx context.Context) error {
	_, err := cic.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (cic *ConfigItemCreate) ExecX(ctx context.Context) {
	if err := cic.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (cic *ConfigItemCreate) defaults() {
	if _, ok := cic.mutation.CreatedAt(); !ok {
		v := configitem.DefaultCreatedAt()
		cic.mutation.SetCreatedAt(v)
	}
	if _, ok := cic.mutation.UpdatedAt(); !ok {
		v := configitem.DefaultUpdatedAt()
		cic.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (cic *ConfigItemCreate) check() error {
	if _, ok := cic.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New(`ent: missing required field "ConfigItem.name"`)}
	}
	if _, ok := cic.mutation.Value(); !ok {
		return &ValidationError{Name: "value", err: errors.New(`ent: missing required field "ConfigItem.value"`)}
	}
	return nil
}

func (cic *ConfigItemCreate) sqlSave(ctx context.Context) (*ConfigItem, error) {
	_node, _spec := cic.createSpec()
	if err := sqlgraph.CreateNode(ctx, cic.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	return _node, nil
}

func (cic *ConfigItemCreate) createSpec() (*ConfigItem, *sqlgraph.CreateSpec) {
	var (
		_node = &ConfigItem{config: cic.config}
		_spec = &sqlgraph.CreateSpec{
			Table: configitem.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: configitem.FieldID,
			},
		}
	)
	if value, ok := cic.mutation.CreatedAt(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: configitem.FieldCreatedAt,
		})
		_node.CreatedAt = &value
	}
	if value, ok := cic.mutation.UpdatedAt(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: configitem.FieldUpdatedAt,
		})
		_node.UpdatedAt = &value
	}
	if value, ok := cic.mutation.Name(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: configitem.FieldName,
		})
		_node.Name = value
	}
	if value, ok := cic.mutation.Value(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: configitem.FieldValue,
		})
		_node.Value = value
	}
	return _node, _spec
}

// ConfigItemCreateBulk is the builder for creating many ConfigItem entities in bulk.
type ConfigItemCreateBulk struct {
	config
	builders []*ConfigItemCreate
}

// Save creates the ConfigItem entities in the database.
func (cicb *ConfigItemCreateBulk) Save(ctx context.Context) ([]*ConfigItem, error) {
	specs := make([]*sqlgraph.CreateSpec, len(cicb.builders))
	nodes := make([]*ConfigItem, len(cicb.builders))
	mutators := make([]Mutator, len(cicb.builders))
	for i := range cicb.builders {
		func(i int, root context.Context) {
			builder := cicb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*ConfigItemMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, cicb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, cicb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{msg: err.Error(), wrap: err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				mutation.done = true
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, cicb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (cicb *ConfigItemCreateBulk) SaveX(ctx context.Context) []*ConfigItem {
	v, err := cicb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (cicb *ConfigItemCreateBulk) Exec(ctx context.Context) error {
	_, err := cicb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (cicb *ConfigItemCreateBulk) ExecX(ctx context.Context) {
	if err := cicb.Exec(ctx); err != nil {
		panic(err)
	}
}
