// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/decision"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/event"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/machine"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/meta"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// AlertUpdate is the builder for updating Alert entities.
type AlertUpdate struct {
	config
	hooks    []Hook
	mutation *AlertMutation
}

// Where appends a list predicates to the AlertUpdate builder.
func (au *AlertUpdate) Where(ps ...predicate.Alert) *AlertUpdate {
	au.mutation.Where(ps...)
	return au
}

// SetCreatedAt sets the "created_at" field.
func (au *AlertUpdate) SetCreatedAt(t time.Time) *AlertUpdate {
	au.mutation.SetCreatedAt(t)
	return au
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (au *AlertUpdate) SetNillableCreatedAt(t *time.Time) *AlertUpdate {
	if t != nil {
		au.SetCreatedAt(*t)
	}
	return au
}

// SetUpdatedAt sets the "updated_at" field.
func (au *AlertUpdate) SetUpdatedAt(t time.Time) *AlertUpdate {
	au.mutation.SetUpdatedAt(t)
	return au
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (au *AlertUpdate) SetNillableUpdatedAt(t *time.Time) *AlertUpdate {
	if t != nil {
		au.SetUpdatedAt(*t)
	}
	return au
}

// SetScenario sets the "scenario" field.
func (au *AlertUpdate) SetScenario(s string) *AlertUpdate {
	au.mutation.SetScenario(s)
	return au
}

// SetBucketId sets the "bucketId" field.
func (au *AlertUpdate) SetBucketId(s string) *AlertUpdate {
	au.mutation.SetBucketId(s)
	return au
}

// SetNillableBucketId sets the "bucketId" field if the given value is not nil.
func (au *AlertUpdate) SetNillableBucketId(s *string) *AlertUpdate {
	if s != nil {
		au.SetBucketId(*s)
	}
	return au
}

// ClearBucketId clears the value of the "bucketId" field.
func (au *AlertUpdate) ClearBucketId() *AlertUpdate {
	au.mutation.ClearBucketId()
	return au
}

// SetMessage sets the "message" field.
func (au *AlertUpdate) SetMessage(s string) *AlertUpdate {
	au.mutation.SetMessage(s)
	return au
}

// SetNillableMessage sets the "message" field if the given value is not nil.
func (au *AlertUpdate) SetNillableMessage(s *string) *AlertUpdate {
	if s != nil {
		au.SetMessage(*s)
	}
	return au
}

// ClearMessage clears the value of the "message" field.
func (au *AlertUpdate) ClearMessage() *AlertUpdate {
	au.mutation.ClearMessage()
	return au
}

// SetEventsCount sets the "eventsCount" field.
func (au *AlertUpdate) SetEventsCount(i int32) *AlertUpdate {
	au.mutation.ResetEventsCount()
	au.mutation.SetEventsCount(i)
	return au
}

// SetNillableEventsCount sets the "eventsCount" field if the given value is not nil.
func (au *AlertUpdate) SetNillableEventsCount(i *int32) *AlertUpdate {
	if i != nil {
		au.SetEventsCount(*i)
	}
	return au
}

// AddEventsCount adds i to the "eventsCount" field.
func (au *AlertUpdate) AddEventsCount(i int32) *AlertUpdate {
	au.mutation.AddEventsCount(i)
	return au
}

// ClearEventsCount clears the value of the "eventsCount" field.
func (au *AlertUpdate) ClearEventsCount() *AlertUpdate {
	au.mutation.ClearEventsCount()
	return au
}

// SetStartedAt sets the "startedAt" field.
func (au *AlertUpdate) SetStartedAt(t time.Time) *AlertUpdate {
	au.mutation.SetStartedAt(t)
	return au
}

// SetNillableStartedAt sets the "startedAt" field if the given value is not nil.
func (au *AlertUpdate) SetNillableStartedAt(t *time.Time) *AlertUpdate {
	if t != nil {
		au.SetStartedAt(*t)
	}
	return au
}

// ClearStartedAt clears the value of the "startedAt" field.
func (au *AlertUpdate) ClearStartedAt() *AlertUpdate {
	au.mutation.ClearStartedAt()
	return au
}

// SetStoppedAt sets the "stoppedAt" field.
func (au *AlertUpdate) SetStoppedAt(t time.Time) *AlertUpdate {
	au.mutation.SetStoppedAt(t)
	return au
}

// SetNillableStoppedAt sets the "stoppedAt" field if the given value is not nil.
func (au *AlertUpdate) SetNillableStoppedAt(t *time.Time) *AlertUpdate {
	if t != nil {
		au.SetStoppedAt(*t)
	}
	return au
}

// ClearStoppedAt clears the value of the "stoppedAt" field.
func (au *AlertUpdate) ClearStoppedAt() *AlertUpdate {
	au.mutation.ClearStoppedAt()
	return au
}

// SetSourceIp sets the "sourceIp" field.
func (au *AlertUpdate) SetSourceIp(s string) *AlertUpdate {
	au.mutation.SetSourceIp(s)
	return au
}

// SetNillableSourceIp sets the "sourceIp" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSourceIp(s *string) *AlertUpdate {
	if s != nil {
		au.SetSourceIp(*s)
	}
	return au
}

// ClearSourceIp clears the value of the "sourceIp" field.
func (au *AlertUpdate) ClearSourceIp() *AlertUpdate {
	au.mutation.ClearSourceIp()
	return au
}

// SetSourceRange sets the "sourceRange" field.
func (au *AlertUpdate) SetSourceRange(s string) *AlertUpdate {
	au.mutation.SetSourceRange(s)
	return au
}

// SetNillableSourceRange sets the "sourceRange" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSourceRange(s *string) *AlertUpdate {
	if s != nil {
		au.SetSourceRange(*s)
	}
	return au
}

// ClearSourceRange clears the value of the "sourceRange" field.
func (au *AlertUpdate) ClearSourceRange() *AlertUpdate {
	au.mutation.ClearSourceRange()
	return au
}

// SetSourceAsNumber sets the "sourceAsNumber" field.
func (au *AlertUpdate) SetSourceAsNumber(s string) *AlertUpdate {
	au.mutation.SetSourceAsNumber(s)
	return au
}

// SetNillableSourceAsNumber sets the "sourceAsNumber" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSourceAsNumber(s *string) *AlertUpdate {
	if s != nil {
		au.SetSourceAsNumber(*s)
	}
	return au
}

// ClearSourceAsNumber clears the value of the "sourceAsNumber" field.
func (au *AlertUpdate) ClearSourceAsNumber() *AlertUpdate {
	au.mutation.ClearSourceAsNumber()
	return au
}

// SetSourceAsName sets the "sourceAsName" field.
func (au *AlertUpdate) SetSourceAsName(s string) *AlertUpdate {
	au.mutation.SetSourceAsName(s)
	return au
}

// SetNillableSourceAsName sets the "sourceAsName" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSourceAsName(s *string) *AlertUpdate {
	if s != nil {
		au.SetSourceAsName(*s)
	}
	return au
}

// ClearSourceAsName clears the value of the "sourceAsName" field.
func (au *AlertUpdate) ClearSourceAsName() *AlertUpdate {
	au.mutation.ClearSourceAsName()
	return au
}

// SetSourceCountry sets the "sourceCountry" field.
func (au *AlertUpdate) SetSourceCountry(s string) *AlertUpdate {
	au.mutation.SetSourceCountry(s)
	return au
}

// SetNillableSourceCountry sets the "sourceCountry" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSourceCountry(s *string) *AlertUpdate {
	if s != nil {
		au.SetSourceCountry(*s)
	}
	return au
}

// ClearSourceCountry clears the value of the "sourceCountry" field.
func (au *AlertUpdate) ClearSourceCountry() *AlertUpdate {
	au.mutation.ClearSourceCountry()
	return au
}

// SetSourceLatitude sets the "sourceLatitude" field.
func (au *AlertUpdate) SetSourceLatitude(f float32) *AlertUpdate {
	au.mutation.ResetSourceLatitude()
	au.mutation.SetSourceLatitude(f)
	return au
}

// SetNillableSourceLatitude sets the "sourceLatitude" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSourceLatitude(f *float32) *AlertUpdate {
	if f != nil {
		au.SetSourceLatitude(*f)
	}
	return au
}

// AddSourceLatitude adds f to the "sourceLatitude" field.
func (au *AlertUpdate) AddSourceLatitude(f float32) *AlertUpdate {
	au.mutation.AddSourceLatitude(f)
	return au
}

// ClearSourceLatitude clears the value of the "sourceLatitude" field.
func (au *AlertUpdate) ClearSourceLatitude() *AlertUpdate {
	au.mutation.ClearSourceLatitude()
	return au
}

// SetSourceLongitude sets the "sourceLongitude" field.
func (au *AlertUpdate) SetSourceLongitude(f float32) *AlertUpdate {
	au.mutation.ResetSourceLongitude()
	au.mutation.SetSourceLongitude(f)
	return au
}

// SetNillableSourceLongitude sets the "sourceLongitude" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSourceLongitude(f *float32) *AlertUpdate {
	if f != nil {
		au.SetSourceLongitude(*f)
	}
	return au
}

// AddSourceLongitude adds f to the "sourceLongitude" field.
func (au *AlertUpdate) AddSourceLongitude(f float32) *AlertUpdate {
	au.mutation.AddSourceLongitude(f)
	return au
}

// ClearSourceLongitude clears the value of the "sourceLongitude" field.
func (au *AlertUpdate) ClearSourceLongitude() *AlertUpdate {
	au.mutation.ClearSourceLongitude()
	return au
}

// SetSourceScope sets the "sourceScope" field.
func (au *AlertUpdate) SetSourceScope(s string) *AlertUpdate {
	au.mutation.SetSourceScope(s)
	return au
}

// SetNillableSourceScope sets the "sourceScope" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSourceScope(s *string) *AlertUpdate {
	if s != nil {
		au.SetSourceScope(*s)
	}
	return au
}

// ClearSourceScope clears the value of the "sourceScope" field.
func (au *AlertUpdate) ClearSourceScope() *AlertUpdate {
	au.mutation.ClearSourceScope()
	return au
}

// SetSourceValue sets the "sourceValue" field.
func (au *AlertUpdate) SetSourceValue(s string) *AlertUpdate {
	au.mutation.SetSourceValue(s)
	return au
}

// SetNillableSourceValue sets the "sourceValue" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSourceValue(s *string) *AlertUpdate {
	if s != nil {
		au.SetSourceValue(*s)
	}
	return au
}

// ClearSourceValue clears the value of the "sourceValue" field.
func (au *AlertUpdate) ClearSourceValue() *AlertUpdate {
	au.mutation.ClearSourceValue()
	return au
}

// SetCapacity sets the "capacity" field.
func (au *AlertUpdate) SetCapacity(i int32) *AlertUpdate {
	au.mutation.ResetCapacity()
	au.mutation.SetCapacity(i)
	return au
}

// SetNillableCapacity sets the "capacity" field if the given value is not nil.
func (au *AlertUpdate) SetNillableCapacity(i *int32) *AlertUpdate {
	if i != nil {
		au.SetCapacity(*i)
	}
	return au
}

// AddCapacity adds i to the "capacity" field.
func (au *AlertUpdate) AddCapacity(i int32) *AlertUpdate {
	au.mutation.AddCapacity(i)
	return au
}

// ClearCapacity clears the value of the "capacity" field.
func (au *AlertUpdate) ClearCapacity() *AlertUpdate {
	au.mutation.ClearCapacity()
	return au
}

// SetLeakSpeed sets the "leakSpeed" field.
func (au *AlertUpdate) SetLeakSpeed(s string) *AlertUpdate {
	au.mutation.SetLeakSpeed(s)
	return au
}

// SetNillableLeakSpeed sets the "leakSpeed" field if the given value is not nil.
func (au *AlertUpdate) SetNillableLeakSpeed(s *string) *AlertUpdate {
	if s != nil {
		au.SetLeakSpeed(*s)
	}
	return au
}

// ClearLeakSpeed clears the value of the "leakSpeed" field.
func (au *AlertUpdate) ClearLeakSpeed() *AlertUpdate {
	au.mutation.ClearLeakSpeed()
	return au
}

// SetScenarioVersion sets the "scenarioVersion" field.
func (au *AlertUpdate) SetScenarioVersion(s string) *AlertUpdate {
	au.mutation.SetScenarioVersion(s)
	return au
}

// SetNillableScenarioVersion sets the "scenarioVersion" field if the given value is not nil.
func (au *AlertUpdate) SetNillableScenarioVersion(s *string) *AlertUpdate {
	if s != nil {
		au.SetScenarioVersion(*s)
	}
	return au
}

// ClearScenarioVersion clears the value of the "scenarioVersion" field.
func (au *AlertUpdate) ClearScenarioVersion() *AlertUpdate {
	au.mutation.ClearScenarioVersion()
	return au
}

// SetScenarioHash sets the "scenarioHash" field.
func (au *AlertUpdate) SetScenarioHash(s string) *AlertUpdate {
	au.mutation.SetScenarioHash(s)
	return au
}

// SetNillableScenarioHash sets the "scenarioHash" field if the given value is not nil.
func (au *AlertUpdate) SetNillableScenarioHash(s *string) *AlertUpdate {
	if s != nil {
		au.SetScenarioHash(*s)
	}
	return au
}

// ClearScenarioHash clears the value of the "scenarioHash" field.
func (au *AlertUpdate) ClearScenarioHash() *AlertUpdate {
	au.mutation.ClearScenarioHash()
	return au
}

// SetSimulated sets the "simulated" field.
func (au *AlertUpdate) SetSimulated(b bool) *AlertUpdate {
	au.mutation.SetSimulated(b)
	return au
}

// SetNillableSimulated sets the "simulated" field if the given value is not nil.
func (au *AlertUpdate) SetNillableSimulated(b *bool) *AlertUpdate {
	if b != nil {
		au.SetSimulated(*b)
	}
	return au
}

// SetOwnerID sets the "owner" edge to the Machine entity by ID.
func (au *AlertUpdate) SetOwnerID(id int) *AlertUpdate {
	au.mutation.SetOwnerID(id)
	return au
}

// SetNillableOwnerID sets the "owner" edge to the Machine entity by ID if the given value is not nil.
func (au *AlertUpdate) SetNillableOwnerID(id *int) *AlertUpdate {
	if id != nil {
		au = au.SetOwnerID(*id)
	}
	return au
}

// SetOwner sets the "owner" edge to the Machine entity.
func (au *AlertUpdate) SetOwner(m *Machine) *AlertUpdate {
	return au.SetOwnerID(m.ID)
}

// AddDecisionIDs adds the "decisions" edge to the Decision entity by IDs.
func (au *AlertUpdate) AddDecisionIDs(ids ...int) *AlertUpdate {
	au.mutation.AddDecisionIDs(ids...)
	return au
}

// AddDecisions adds the "decisions" edges to the Decision entity.
func (au *AlertUpdate) AddDecisions(d ...*Decision) *AlertUpdate {
	ids := make([]int, len(d))
	for i := range d {
		ids[i] = d[i].ID
	}
	return au.AddDecisionIDs(ids...)
}

// AddEventIDs adds the "events" edge to the Event entity by IDs.
func (au *AlertUpdate) AddEventIDs(ids ...int) *AlertUpdate {
	au.mutation.AddEventIDs(ids...)
	return au
}

// AddEvents adds the "events" edges to the Event entity.
func (au *AlertUpdate) AddEvents(e ...*Event) *AlertUpdate {
	ids := make([]int, len(e))
	for i := range e {
		ids[i] = e[i].ID
	}
	return au.AddEventIDs(ids...)
}

// AddMetaIDs adds the "metas" edge to the Meta entity by IDs.
func (au *AlertUpdate) AddMetaIDs(ids ...int) *AlertUpdate {
	au.mutation.AddMetaIDs(ids...)
	return au
}

// AddMetas adds the "metas" edges to the Meta entity.
func (au *AlertUpdate) AddMetas(m ...*Meta) *AlertUpdate {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return au.AddMetaIDs(ids...)
}

// Mutation returns the AlertMutation object of the builder.
func (au *AlertUpdate) Mutation() *AlertMutation {
	return au.mutation
}

// ClearOwner clears the "owner" edge to the Machine entity.
func (au *AlertUpdate) ClearOwner() *AlertUpdate {
	au.mutation.ClearOwner()
	return au
}

// ClearDecisions clears all "decisions" edges to the Decision entity.
func (au *AlertUpdate) ClearDecisions() *AlertUpdate {
	au.mutation.ClearDecisions()
	return au
}

// RemoveDecisionIDs removes the "decisions" edge to Decision entities by IDs.
func (au *AlertUpdate) RemoveDecisionIDs(ids ...int) *AlertUpdate {
	au.mutation.RemoveDecisionIDs(ids...)
	return au
}

// RemoveDecisions removes "decisions" edges to Decision entities.
func (au *AlertUpdate) RemoveDecisions(d ...*Decision) *AlertUpdate {
	ids := make([]int, len(d))
	for i := range d {
		ids[i] = d[i].ID
	}
	return au.RemoveDecisionIDs(ids...)
}

// ClearEvents clears all "events" edges to the Event entity.
func (au *AlertUpdate) ClearEvents() *AlertUpdate {
	au.mutation.ClearEvents()
	return au
}

// RemoveEventIDs removes the "events" edge to Event entities by IDs.
func (au *AlertUpdate) RemoveEventIDs(ids ...int) *AlertUpdate {
	au.mutation.RemoveEventIDs(ids...)
	return au
}

// RemoveEvents removes "events" edges to Event entities.
func (au *AlertUpdate) RemoveEvents(e ...*Event) *AlertUpdate {
	ids := make([]int, len(e))
	for i := range e {
		ids[i] = e[i].ID
	}
	return au.RemoveEventIDs(ids...)
}

// ClearMetas clears all "metas" edges to the Meta entity.
func (au *AlertUpdate) ClearMetas() *AlertUpdate {
	au.mutation.ClearMetas()
	return au
}

// RemoveMetaIDs removes the "metas" edge to Meta entities by IDs.
func (au *AlertUpdate) RemoveMetaIDs(ids ...int) *AlertUpdate {
	au.mutation.RemoveMetaIDs(ids...)
	return au
}

// RemoveMetas removes "metas" edges to Meta entities.
func (au *AlertUpdate) RemoveMetas(m ...*Meta) *AlertUpdate {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return au.RemoveMetaIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (au *AlertUpdate) Save(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(au.hooks) == 0 {
		affected, err = au.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*AlertMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			au.mutation = mutation
			affected, err = au.sqlSave(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(au.hooks) - 1; i >= 0; i-- {
			if au.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = au.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, au.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// SaveX is like Save, but panics if an error occurs.
func (au *AlertUpdate) SaveX(ctx context.Context) int {
	affected, err := au.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (au *AlertUpdate) Exec(ctx context.Context) error {
	_, err := au.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (au *AlertUpdate) ExecX(ctx context.Context) {
	if err := au.Exec(ctx); err != nil {
		panic(err)
	}
}

func (au *AlertUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   alert.Table,
			Columns: alert.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: alert.FieldID,
			},
		},
	}
	if ps := au.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := au.mutation.CreatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: alert.FieldCreatedAt,
		})
	}
	if value, ok := au.mutation.UpdatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: alert.FieldUpdatedAt,
		})
	}
	if value, ok := au.mutation.Scenario(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldScenario,
		})
	}
	if value, ok := au.mutation.BucketId(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldBucketId,
		})
	}
	if au.mutation.BucketIdCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldBucketId,
		})
	}
	if value, ok := au.mutation.Message(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldMessage,
		})
	}
	if au.mutation.MessageCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldMessage,
		})
	}
	if value, ok := au.mutation.EventsCount(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: alert.FieldEventsCount,
		})
	}
	if value, ok := au.mutation.AddedEventsCount(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: alert.FieldEventsCount,
		})
	}
	if au.mutation.EventsCountCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Column: alert.FieldEventsCount,
		})
	}
	if value, ok := au.mutation.StartedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: alert.FieldStartedAt,
		})
	}
	if au.mutation.StartedAtCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: alert.FieldStartedAt,
		})
	}
	if value, ok := au.mutation.StoppedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: alert.FieldStoppedAt,
		})
	}
	if au.mutation.StoppedAtCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: alert.FieldStoppedAt,
		})
	}
	if value, ok := au.mutation.SourceIp(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceIp,
		})
	}
	if au.mutation.SourceIpCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceIp,
		})
	}
	if value, ok := au.mutation.SourceRange(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceRange,
		})
	}
	if au.mutation.SourceRangeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceRange,
		})
	}
	if value, ok := au.mutation.SourceAsNumber(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceAsNumber,
		})
	}
	if au.mutation.SourceAsNumberCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceAsNumber,
		})
	}
	if value, ok := au.mutation.SourceAsName(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceAsName,
		})
	}
	if au.mutation.SourceAsNameCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceAsName,
		})
	}
	if value, ok := au.mutation.SourceCountry(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceCountry,
		})
	}
	if au.mutation.SourceCountryCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceCountry,
		})
	}
	if value, ok := au.mutation.SourceLatitude(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Value:  value,
			Column: alert.FieldSourceLatitude,
		})
	}
	if value, ok := au.mutation.AddedSourceLatitude(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Value:  value,
			Column: alert.FieldSourceLatitude,
		})
	}
	if au.mutation.SourceLatitudeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Column: alert.FieldSourceLatitude,
		})
	}
	if value, ok := au.mutation.SourceLongitude(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Value:  value,
			Column: alert.FieldSourceLongitude,
		})
	}
	if value, ok := au.mutation.AddedSourceLongitude(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Value:  value,
			Column: alert.FieldSourceLongitude,
		})
	}
	if au.mutation.SourceLongitudeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Column: alert.FieldSourceLongitude,
		})
	}
	if value, ok := au.mutation.SourceScope(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceScope,
		})
	}
	if au.mutation.SourceScopeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceScope,
		})
	}
	if value, ok := au.mutation.SourceValue(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceValue,
		})
	}
	if au.mutation.SourceValueCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceValue,
		})
	}
	if value, ok := au.mutation.Capacity(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: alert.FieldCapacity,
		})
	}
	if value, ok := au.mutation.AddedCapacity(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: alert.FieldCapacity,
		})
	}
	if au.mutation.CapacityCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Column: alert.FieldCapacity,
		})
	}
	if value, ok := au.mutation.LeakSpeed(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldLeakSpeed,
		})
	}
	if au.mutation.LeakSpeedCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldLeakSpeed,
		})
	}
	if value, ok := au.mutation.ScenarioVersion(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldScenarioVersion,
		})
	}
	if au.mutation.ScenarioVersionCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldScenarioVersion,
		})
	}
	if value, ok := au.mutation.ScenarioHash(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldScenarioHash,
		})
	}
	if au.mutation.ScenarioHashCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldScenarioHash,
		})
	}
	if value, ok := au.mutation.Simulated(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: alert.FieldSimulated,
		})
	}
	if au.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   alert.OwnerTable,
			Columns: []string{alert.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: machine.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   alert.OwnerTable,
			Columns: []string{alert.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: machine.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if au.mutation.DecisionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: decision.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.RemovedDecisionsIDs(); len(nodes) > 0 && !au.mutation.DecisionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: decision.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.DecisionsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: decision.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if au.mutation.EventsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: event.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.RemovedEventsIDs(); len(nodes) > 0 && !au.mutation.EventsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: event.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.EventsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: event.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if au.mutation.MetasCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: meta.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.RemovedMetasIDs(); len(nodes) > 0 && !au.mutation.MetasCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: meta.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.MetasIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: meta.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, au.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{alert.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{err.Error(), err}
		}
		return 0, err
	}
	return n, nil
}

// AlertUpdateOne is the builder for updating a single Alert entity.
type AlertUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *AlertMutation
}

// SetCreatedAt sets the "created_at" field.
func (auo *AlertUpdateOne) SetCreatedAt(t time.Time) *AlertUpdateOne {
	auo.mutation.SetCreatedAt(t)
	return auo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableCreatedAt(t *time.Time) *AlertUpdateOne {
	if t != nil {
		auo.SetCreatedAt(*t)
	}
	return auo
}

// SetUpdatedAt sets the "updated_at" field.
func (auo *AlertUpdateOne) SetUpdatedAt(t time.Time) *AlertUpdateOne {
	auo.mutation.SetUpdatedAt(t)
	return auo
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableUpdatedAt(t *time.Time) *AlertUpdateOne {
	if t != nil {
		auo.SetUpdatedAt(*t)
	}
	return auo
}

// SetScenario sets the "scenario" field.
func (auo *AlertUpdateOne) SetScenario(s string) *AlertUpdateOne {
	auo.mutation.SetScenario(s)
	return auo
}

// SetBucketId sets the "bucketId" field.
func (auo *AlertUpdateOne) SetBucketId(s string) *AlertUpdateOne {
	auo.mutation.SetBucketId(s)
	return auo
}

// SetNillableBucketId sets the "bucketId" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableBucketId(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetBucketId(*s)
	}
	return auo
}

// ClearBucketId clears the value of the "bucketId" field.
func (auo *AlertUpdateOne) ClearBucketId() *AlertUpdateOne {
	auo.mutation.ClearBucketId()
	return auo
}

// SetMessage sets the "message" field.
func (auo *AlertUpdateOne) SetMessage(s string) *AlertUpdateOne {
	auo.mutation.SetMessage(s)
	return auo
}

// SetNillableMessage sets the "message" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableMessage(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetMessage(*s)
	}
	return auo
}

// ClearMessage clears the value of the "message" field.
func (auo *AlertUpdateOne) ClearMessage() *AlertUpdateOne {
	auo.mutation.ClearMessage()
	return auo
}

// SetEventsCount sets the "eventsCount" field.
func (auo *AlertUpdateOne) SetEventsCount(i int32) *AlertUpdateOne {
	auo.mutation.ResetEventsCount()
	auo.mutation.SetEventsCount(i)
	return auo
}

// SetNillableEventsCount sets the "eventsCount" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableEventsCount(i *int32) *AlertUpdateOne {
	if i != nil {
		auo.SetEventsCount(*i)
	}
	return auo
}

// AddEventsCount adds i to the "eventsCount" field.
func (auo *AlertUpdateOne) AddEventsCount(i int32) *AlertUpdateOne {
	auo.mutation.AddEventsCount(i)
	return auo
}

// ClearEventsCount clears the value of the "eventsCount" field.
func (auo *AlertUpdateOne) ClearEventsCount() *AlertUpdateOne {
	auo.mutation.ClearEventsCount()
	return auo
}

// SetStartedAt sets the "startedAt" field.
func (auo *AlertUpdateOne) SetStartedAt(t time.Time) *AlertUpdateOne {
	auo.mutation.SetStartedAt(t)
	return auo
}

// SetNillableStartedAt sets the "startedAt" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableStartedAt(t *time.Time) *AlertUpdateOne {
	if t != nil {
		auo.SetStartedAt(*t)
	}
	return auo
}

// ClearStartedAt clears the value of the "startedAt" field.
func (auo *AlertUpdateOne) ClearStartedAt() *AlertUpdateOne {
	auo.mutation.ClearStartedAt()
	return auo
}

// SetStoppedAt sets the "stoppedAt" field.
func (auo *AlertUpdateOne) SetStoppedAt(t time.Time) *AlertUpdateOne {
	auo.mutation.SetStoppedAt(t)
	return auo
}

// SetNillableStoppedAt sets the "stoppedAt" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableStoppedAt(t *time.Time) *AlertUpdateOne {
	if t != nil {
		auo.SetStoppedAt(*t)
	}
	return auo
}

// ClearStoppedAt clears the value of the "stoppedAt" field.
func (auo *AlertUpdateOne) ClearStoppedAt() *AlertUpdateOne {
	auo.mutation.ClearStoppedAt()
	return auo
}

// SetSourceIp sets the "sourceIp" field.
func (auo *AlertUpdateOne) SetSourceIp(s string) *AlertUpdateOne {
	auo.mutation.SetSourceIp(s)
	return auo
}

// SetNillableSourceIp sets the "sourceIp" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSourceIp(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetSourceIp(*s)
	}
	return auo
}

// ClearSourceIp clears the value of the "sourceIp" field.
func (auo *AlertUpdateOne) ClearSourceIp() *AlertUpdateOne {
	auo.mutation.ClearSourceIp()
	return auo
}

// SetSourceRange sets the "sourceRange" field.
func (auo *AlertUpdateOne) SetSourceRange(s string) *AlertUpdateOne {
	auo.mutation.SetSourceRange(s)
	return auo
}

// SetNillableSourceRange sets the "sourceRange" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSourceRange(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetSourceRange(*s)
	}
	return auo
}

// ClearSourceRange clears the value of the "sourceRange" field.
func (auo *AlertUpdateOne) ClearSourceRange() *AlertUpdateOne {
	auo.mutation.ClearSourceRange()
	return auo
}

// SetSourceAsNumber sets the "sourceAsNumber" field.
func (auo *AlertUpdateOne) SetSourceAsNumber(s string) *AlertUpdateOne {
	auo.mutation.SetSourceAsNumber(s)
	return auo
}

// SetNillableSourceAsNumber sets the "sourceAsNumber" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSourceAsNumber(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetSourceAsNumber(*s)
	}
	return auo
}

// ClearSourceAsNumber clears the value of the "sourceAsNumber" field.
func (auo *AlertUpdateOne) ClearSourceAsNumber() *AlertUpdateOne {
	auo.mutation.ClearSourceAsNumber()
	return auo
}

// SetSourceAsName sets the "sourceAsName" field.
func (auo *AlertUpdateOne) SetSourceAsName(s string) *AlertUpdateOne {
	auo.mutation.SetSourceAsName(s)
	return auo
}

// SetNillableSourceAsName sets the "sourceAsName" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSourceAsName(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetSourceAsName(*s)
	}
	return auo
}

// ClearSourceAsName clears the value of the "sourceAsName" field.
func (auo *AlertUpdateOne) ClearSourceAsName() *AlertUpdateOne {
	auo.mutation.ClearSourceAsName()
	return auo
}

// SetSourceCountry sets the "sourceCountry" field.
func (auo *AlertUpdateOne) SetSourceCountry(s string) *AlertUpdateOne {
	auo.mutation.SetSourceCountry(s)
	return auo
}

// SetNillableSourceCountry sets the "sourceCountry" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSourceCountry(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetSourceCountry(*s)
	}
	return auo
}

// ClearSourceCountry clears the value of the "sourceCountry" field.
func (auo *AlertUpdateOne) ClearSourceCountry() *AlertUpdateOne {
	auo.mutation.ClearSourceCountry()
	return auo
}

// SetSourceLatitude sets the "sourceLatitude" field.
func (auo *AlertUpdateOne) SetSourceLatitude(f float32) *AlertUpdateOne {
	auo.mutation.ResetSourceLatitude()
	auo.mutation.SetSourceLatitude(f)
	return auo
}

// SetNillableSourceLatitude sets the "sourceLatitude" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSourceLatitude(f *float32) *AlertUpdateOne {
	if f != nil {
		auo.SetSourceLatitude(*f)
	}
	return auo
}

// AddSourceLatitude adds f to the "sourceLatitude" field.
func (auo *AlertUpdateOne) AddSourceLatitude(f float32) *AlertUpdateOne {
	auo.mutation.AddSourceLatitude(f)
	return auo
}

// ClearSourceLatitude clears the value of the "sourceLatitude" field.
func (auo *AlertUpdateOne) ClearSourceLatitude() *AlertUpdateOne {
	auo.mutation.ClearSourceLatitude()
	return auo
}

// SetSourceLongitude sets the "sourceLongitude" field.
func (auo *AlertUpdateOne) SetSourceLongitude(f float32) *AlertUpdateOne {
	auo.mutation.ResetSourceLongitude()
	auo.mutation.SetSourceLongitude(f)
	return auo
}

// SetNillableSourceLongitude sets the "sourceLongitude" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSourceLongitude(f *float32) *AlertUpdateOne {
	if f != nil {
		auo.SetSourceLongitude(*f)
	}
	return auo
}

// AddSourceLongitude adds f to the "sourceLongitude" field.
func (auo *AlertUpdateOne) AddSourceLongitude(f float32) *AlertUpdateOne {
	auo.mutation.AddSourceLongitude(f)
	return auo
}

// ClearSourceLongitude clears the value of the "sourceLongitude" field.
func (auo *AlertUpdateOne) ClearSourceLongitude() *AlertUpdateOne {
	auo.mutation.ClearSourceLongitude()
	return auo
}

// SetSourceScope sets the "sourceScope" field.
func (auo *AlertUpdateOne) SetSourceScope(s string) *AlertUpdateOne {
	auo.mutation.SetSourceScope(s)
	return auo
}

// SetNillableSourceScope sets the "sourceScope" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSourceScope(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetSourceScope(*s)
	}
	return auo
}

// ClearSourceScope clears the value of the "sourceScope" field.
func (auo *AlertUpdateOne) ClearSourceScope() *AlertUpdateOne {
	auo.mutation.ClearSourceScope()
	return auo
}

// SetSourceValue sets the "sourceValue" field.
func (auo *AlertUpdateOne) SetSourceValue(s string) *AlertUpdateOne {
	auo.mutation.SetSourceValue(s)
	return auo
}

// SetNillableSourceValue sets the "sourceValue" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSourceValue(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetSourceValue(*s)
	}
	return auo
}

// ClearSourceValue clears the value of the "sourceValue" field.
func (auo *AlertUpdateOne) ClearSourceValue() *AlertUpdateOne {
	auo.mutation.ClearSourceValue()
	return auo
}

// SetCapacity sets the "capacity" field.
func (auo *AlertUpdateOne) SetCapacity(i int32) *AlertUpdateOne {
	auo.mutation.ResetCapacity()
	auo.mutation.SetCapacity(i)
	return auo
}

// SetNillableCapacity sets the "capacity" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableCapacity(i *int32) *AlertUpdateOne {
	if i != nil {
		auo.SetCapacity(*i)
	}
	return auo
}

// AddCapacity adds i to the "capacity" field.
func (auo *AlertUpdateOne) AddCapacity(i int32) *AlertUpdateOne {
	auo.mutation.AddCapacity(i)
	return auo
}

// ClearCapacity clears the value of the "capacity" field.
func (auo *AlertUpdateOne) ClearCapacity() *AlertUpdateOne {
	auo.mutation.ClearCapacity()
	return auo
}

// SetLeakSpeed sets the "leakSpeed" field.
func (auo *AlertUpdateOne) SetLeakSpeed(s string) *AlertUpdateOne {
	auo.mutation.SetLeakSpeed(s)
	return auo
}

// SetNillableLeakSpeed sets the "leakSpeed" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableLeakSpeed(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetLeakSpeed(*s)
	}
	return auo
}

// ClearLeakSpeed clears the value of the "leakSpeed" field.
func (auo *AlertUpdateOne) ClearLeakSpeed() *AlertUpdateOne {
	auo.mutation.ClearLeakSpeed()
	return auo
}

// SetScenarioVersion sets the "scenarioVersion" field.
func (auo *AlertUpdateOne) SetScenarioVersion(s string) *AlertUpdateOne {
	auo.mutation.SetScenarioVersion(s)
	return auo
}

// SetNillableScenarioVersion sets the "scenarioVersion" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableScenarioVersion(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetScenarioVersion(*s)
	}
	return auo
}

// ClearScenarioVersion clears the value of the "scenarioVersion" field.
func (auo *AlertUpdateOne) ClearScenarioVersion() *AlertUpdateOne {
	auo.mutation.ClearScenarioVersion()
	return auo
}

// SetScenarioHash sets the "scenarioHash" field.
func (auo *AlertUpdateOne) SetScenarioHash(s string) *AlertUpdateOne {
	auo.mutation.SetScenarioHash(s)
	return auo
}

// SetNillableScenarioHash sets the "scenarioHash" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableScenarioHash(s *string) *AlertUpdateOne {
	if s != nil {
		auo.SetScenarioHash(*s)
	}
	return auo
}

// ClearScenarioHash clears the value of the "scenarioHash" field.
func (auo *AlertUpdateOne) ClearScenarioHash() *AlertUpdateOne {
	auo.mutation.ClearScenarioHash()
	return auo
}

// SetSimulated sets the "simulated" field.
func (auo *AlertUpdateOne) SetSimulated(b bool) *AlertUpdateOne {
	auo.mutation.SetSimulated(b)
	return auo
}

// SetNillableSimulated sets the "simulated" field if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableSimulated(b *bool) *AlertUpdateOne {
	if b != nil {
		auo.SetSimulated(*b)
	}
	return auo
}

// SetOwnerID sets the "owner" edge to the Machine entity by ID.
func (auo *AlertUpdateOne) SetOwnerID(id int) *AlertUpdateOne {
	auo.mutation.SetOwnerID(id)
	return auo
}

// SetNillableOwnerID sets the "owner" edge to the Machine entity by ID if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableOwnerID(id *int) *AlertUpdateOne {
	if id != nil {
		auo = auo.SetOwnerID(*id)
	}
	return auo
}

// SetOwner sets the "owner" edge to the Machine entity.
func (auo *AlertUpdateOne) SetOwner(m *Machine) *AlertUpdateOne {
	return auo.SetOwnerID(m.ID)
}

// AddDecisionIDs adds the "decisions" edge to the Decision entity by IDs.
func (auo *AlertUpdateOne) AddDecisionIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.AddDecisionIDs(ids...)
	return auo
}

// AddDecisions adds the "decisions" edges to the Decision entity.
func (auo *AlertUpdateOne) AddDecisions(d ...*Decision) *AlertUpdateOne {
	ids := make([]int, len(d))
	for i := range d {
		ids[i] = d[i].ID
	}
	return auo.AddDecisionIDs(ids...)
}

// AddEventIDs adds the "events" edge to the Event entity by IDs.
func (auo *AlertUpdateOne) AddEventIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.AddEventIDs(ids...)
	return auo
}

// AddEvents adds the "events" edges to the Event entity.
func (auo *AlertUpdateOne) AddEvents(e ...*Event) *AlertUpdateOne {
	ids := make([]int, len(e))
	for i := range e {
		ids[i] = e[i].ID
	}
	return auo.AddEventIDs(ids...)
}

// AddMetaIDs adds the "metas" edge to the Meta entity by IDs.
func (auo *AlertUpdateOne) AddMetaIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.AddMetaIDs(ids...)
	return auo
}

// AddMetas adds the "metas" edges to the Meta entity.
func (auo *AlertUpdateOne) AddMetas(m ...*Meta) *AlertUpdateOne {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return auo.AddMetaIDs(ids...)
}

// Mutation returns the AlertMutation object of the builder.
func (auo *AlertUpdateOne) Mutation() *AlertMutation {
	return auo.mutation
}

// ClearOwner clears the "owner" edge to the Machine entity.
func (auo *AlertUpdateOne) ClearOwner() *AlertUpdateOne {
	auo.mutation.ClearOwner()
	return auo
}

// ClearDecisions clears all "decisions" edges to the Decision entity.
func (auo *AlertUpdateOne) ClearDecisions() *AlertUpdateOne {
	auo.mutation.ClearDecisions()
	return auo
}

// RemoveDecisionIDs removes the "decisions" edge to Decision entities by IDs.
func (auo *AlertUpdateOne) RemoveDecisionIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.RemoveDecisionIDs(ids...)
	return auo
}

// RemoveDecisions removes "decisions" edges to Decision entities.
func (auo *AlertUpdateOne) RemoveDecisions(d ...*Decision) *AlertUpdateOne {
	ids := make([]int, len(d))
	for i := range d {
		ids[i] = d[i].ID
	}
	return auo.RemoveDecisionIDs(ids...)
}

// ClearEvents clears all "events" edges to the Event entity.
func (auo *AlertUpdateOne) ClearEvents() *AlertUpdateOne {
	auo.mutation.ClearEvents()
	return auo
}

// RemoveEventIDs removes the "events" edge to Event entities by IDs.
func (auo *AlertUpdateOne) RemoveEventIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.RemoveEventIDs(ids...)
	return auo
}

// RemoveEvents removes "events" edges to Event entities.
func (auo *AlertUpdateOne) RemoveEvents(e ...*Event) *AlertUpdateOne {
	ids := make([]int, len(e))
	for i := range e {
		ids[i] = e[i].ID
	}
	return auo.RemoveEventIDs(ids...)
}

// ClearMetas clears all "metas" edges to the Meta entity.
func (auo *AlertUpdateOne) ClearMetas() *AlertUpdateOne {
	auo.mutation.ClearMetas()
	return auo
}

// RemoveMetaIDs removes the "metas" edge to Meta entities by IDs.
func (auo *AlertUpdateOne) RemoveMetaIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.RemoveMetaIDs(ids...)
	return auo
}

// RemoveMetas removes "metas" edges to Meta entities.
func (auo *AlertUpdateOne) RemoveMetas(m ...*Meta) *AlertUpdateOne {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return auo.RemoveMetaIDs(ids...)
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (auo *AlertUpdateOne) Select(field string, fields ...string) *AlertUpdateOne {
	auo.fields = append([]string{field}, fields...)
	return auo
}

// Save executes the query and returns the updated Alert entity.
func (auo *AlertUpdateOne) Save(ctx context.Context) (*Alert, error) {
	var (
		err  error
		node *Alert
	)
	if len(auo.hooks) == 0 {
		node, err = auo.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*AlertMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			auo.mutation = mutation
			node, err = auo.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(auo.hooks) - 1; i >= 0; i-- {
			if auo.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = auo.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, auo.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX is like Save, but panics if an error occurs.
func (auo *AlertUpdateOne) SaveX(ctx context.Context) *Alert {
	node, err := auo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (auo *AlertUpdateOne) Exec(ctx context.Context) error {
	_, err := auo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (auo *AlertUpdateOne) ExecX(ctx context.Context) {
	if err := auo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (auo *AlertUpdateOne) sqlSave(ctx context.Context) (_node *Alert, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   alert.Table,
			Columns: alert.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: alert.FieldID,
			},
		},
	}
	id, ok := auo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "ID", err: fmt.Errorf("missing Alert.ID for update")}
	}
	_spec.Node.ID.Value = id
	if fields := auo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, alert.FieldID)
		for _, f := range fields {
			if !alert.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != alert.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := auo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := auo.mutation.CreatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: alert.FieldCreatedAt,
		})
	}
	if value, ok := auo.mutation.UpdatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: alert.FieldUpdatedAt,
		})
	}
	if value, ok := auo.mutation.Scenario(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldScenario,
		})
	}
	if value, ok := auo.mutation.BucketId(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldBucketId,
		})
	}
	if auo.mutation.BucketIdCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldBucketId,
		})
	}
	if value, ok := auo.mutation.Message(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldMessage,
		})
	}
	if auo.mutation.MessageCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldMessage,
		})
	}
	if value, ok := auo.mutation.EventsCount(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: alert.FieldEventsCount,
		})
	}
	if value, ok := auo.mutation.AddedEventsCount(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: alert.FieldEventsCount,
		})
	}
	if auo.mutation.EventsCountCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Column: alert.FieldEventsCount,
		})
	}
	if value, ok := auo.mutation.StartedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: alert.FieldStartedAt,
		})
	}
	if auo.mutation.StartedAtCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: alert.FieldStartedAt,
		})
	}
	if value, ok := auo.mutation.StoppedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: alert.FieldStoppedAt,
		})
	}
	if auo.mutation.StoppedAtCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: alert.FieldStoppedAt,
		})
	}
	if value, ok := auo.mutation.SourceIp(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceIp,
		})
	}
	if auo.mutation.SourceIpCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceIp,
		})
	}
	if value, ok := auo.mutation.SourceRange(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceRange,
		})
	}
	if auo.mutation.SourceRangeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceRange,
		})
	}
	if value, ok := auo.mutation.SourceAsNumber(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceAsNumber,
		})
	}
	if auo.mutation.SourceAsNumberCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceAsNumber,
		})
	}
	if value, ok := auo.mutation.SourceAsName(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceAsName,
		})
	}
	if auo.mutation.SourceAsNameCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceAsName,
		})
	}
	if value, ok := auo.mutation.SourceCountry(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceCountry,
		})
	}
	if auo.mutation.SourceCountryCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceCountry,
		})
	}
	if value, ok := auo.mutation.SourceLatitude(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Value:  value,
			Column: alert.FieldSourceLatitude,
		})
	}
	if value, ok := auo.mutation.AddedSourceLatitude(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Value:  value,
			Column: alert.FieldSourceLatitude,
		})
	}
	if auo.mutation.SourceLatitudeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Column: alert.FieldSourceLatitude,
		})
	}
	if value, ok := auo.mutation.SourceLongitude(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Value:  value,
			Column: alert.FieldSourceLongitude,
		})
	}
	if value, ok := auo.mutation.AddedSourceLongitude(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Value:  value,
			Column: alert.FieldSourceLongitude,
		})
	}
	if auo.mutation.SourceLongitudeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat32,
			Column: alert.FieldSourceLongitude,
		})
	}
	if value, ok := auo.mutation.SourceScope(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceScope,
		})
	}
	if auo.mutation.SourceScopeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceScope,
		})
	}
	if value, ok := auo.mutation.SourceValue(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldSourceValue,
		})
	}
	if auo.mutation.SourceValueCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldSourceValue,
		})
	}
	if value, ok := auo.mutation.Capacity(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: alert.FieldCapacity,
		})
	}
	if value, ok := auo.mutation.AddedCapacity(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: alert.FieldCapacity,
		})
	}
	if auo.mutation.CapacityCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Column: alert.FieldCapacity,
		})
	}
	if value, ok := auo.mutation.LeakSpeed(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldLeakSpeed,
		})
	}
	if auo.mutation.LeakSpeedCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldLeakSpeed,
		})
	}
	if value, ok := auo.mutation.ScenarioVersion(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldScenarioVersion,
		})
	}
	if auo.mutation.ScenarioVersionCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldScenarioVersion,
		})
	}
	if value, ok := auo.mutation.ScenarioHash(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: alert.FieldScenarioHash,
		})
	}
	if auo.mutation.ScenarioHashCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: alert.FieldScenarioHash,
		})
	}
	if value, ok := auo.mutation.Simulated(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: alert.FieldSimulated,
		})
	}
	if auo.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   alert.OwnerTable,
			Columns: []string{alert.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: machine.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   alert.OwnerTable,
			Columns: []string{alert.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: machine.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if auo.mutation.DecisionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: decision.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.RemovedDecisionsIDs(); len(nodes) > 0 && !auo.mutation.DecisionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: decision.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.DecisionsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: decision.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if auo.mutation.EventsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: event.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.RemovedEventsIDs(); len(nodes) > 0 && !auo.mutation.EventsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: event.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.EventsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: event.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if auo.mutation.MetasCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: meta.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.RemovedMetasIDs(); len(nodes) > 0 && !auo.mutation.MetasCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: meta.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.MetasIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: meta.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &Alert{config: auo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, auo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{alert.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{err.Error(), err}
		}
		return nil, err
	}
	return _node, nil
}
