// Code generated by capnpc-go. DO NOT EDIT.

package tunnelrpc

import (
	context "golang.org/x/net/context"
	strconv "strconv"
	capnp "zombiezen.com/go/capnproto2"
	text "zombiezen.com/go/capnproto2/encoding/text"
	schemas "zombiezen.com/go/capnproto2/schemas"
	server "zombiezen.com/go/capnproto2/server"
)

type Authentication struct{ capnp.Struct }

// Authentication_TypeID is the unique identifier for the type Authentication.
const Authentication_TypeID = 0xc082ef6e0d42ed1d

func NewAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func NewRootAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func ReadRootAuthentication(msg *capnp.Message) (Authentication, error) {
	root, err := msg.RootPtr()
	return Authentication{root.Struct()}, err
}

func (s Authentication) String() string {
	str, _ := text.Marshal(0xc082ef6e0d42ed1d, s.Struct)
	return str
}

func (s Authentication) Key() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Authentication) HasKey() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Authentication) KeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Authentication) SetKey(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Authentication) Email() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Authentication) HasEmail() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Authentication) EmailBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Authentication) SetEmail(v string) error {
	return s.Struct.SetText(1, v)
}

func (s Authentication) OriginCAKey() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s Authentication) HasOriginCAKey() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s Authentication) OriginCAKeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s Authentication) SetOriginCAKey(v string) error {
	return s.Struct.SetText(2, v)
}

// Authentication_List is a list of Authentication.
type Authentication_List struct{ capnp.List }

// NewAuthentication creates a new list of Authentication.
func NewAuthentication_List(s *capnp.Segment, sz int32) (Authentication_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return Authentication_List{l}, err
}

func (s Authentication_List) At(i int) Authentication { return Authentication{s.List.Struct(i)} }

func (s Authentication_List) Set(i int, v Authentication) error { return s.List.SetStruct(i, v.Struct) }

func (s Authentication_List) String() string {
	str, _ := text.MarshalList(0xc082ef6e0d42ed1d, s.List)
	return str
}

// Authentication_Promise is a wrapper for a Authentication promised by a client call.
type Authentication_Promise struct{ *capnp.Pipeline }

func (p Authentication_Promise) Struct() (Authentication, error) {
	s, err := p.Pipeline.Struct()
	return Authentication{s}, err
}

type TunnelRegistration struct{ capnp.Struct }

// TunnelRegistration_TypeID is the unique identifier for the type TunnelRegistration.
const TunnelRegistration_TypeID = 0xf41a0f001ad49e46

func NewTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func NewRootTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func ReadRootTunnelRegistration(msg *capnp.Message) (TunnelRegistration, error) {
	root, err := msg.RootPtr()
	return TunnelRegistration{root.Struct()}, err
}

func (s TunnelRegistration) String() string {
	str, _ := text.Marshal(0xf41a0f001ad49e46, s.Struct)
	return str
}

func (s TunnelRegistration) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelRegistration) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelRegistration) Url() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelRegistration) HasUrl() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) UrlBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetUrl(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelRegistration) LogLines() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(2)
	return capnp.TextList{List: p.List()}, err
}

func (s TunnelRegistration) HasLogLines() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetLogLines(v capnp.TextList) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewLogLines sets the logLines field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TunnelRegistration) NewLogLines(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

func (s TunnelRegistration) PermanentFailure() bool {
	return s.Struct.Bit(0)
}

func (s TunnelRegistration) SetPermanentFailure(v bool) {
	s.Struct.SetBit(0, v)
}

func (s TunnelRegistration) TunnelID() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelRegistration) HasTunnelID() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) TunnelIDBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetTunnelID(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelRegistration) RetryAfterSeconds() uint16 {
	return s.Struct.Uint16(2)
}

func (s TunnelRegistration) SetRetryAfterSeconds(v uint16) {
	s.Struct.SetUint16(2, v)
}

func (s TunnelRegistration) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(4)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasEventDigest() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetEventDigest(v []byte) error {
	return s.Struct.SetData(4, v)
}

func (s TunnelRegistration) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasConnDigest() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetConnDigest(v []byte) error {
	return s.Struct.SetData(5, v)
}

// TunnelRegistration_List is a list of TunnelRegistration.
type TunnelRegistration_List struct{ capnp.List }

// NewTunnelRegistration creates a new list of TunnelRegistration.
func NewTunnelRegistration_List(s *capnp.Segment, sz int32) (TunnelRegistration_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6}, sz)
	return TunnelRegistration_List{l}, err
}

func (s TunnelRegistration_List) At(i int) TunnelRegistration {
	return TunnelRegistration{s.List.Struct(i)}
}

func (s TunnelRegistration_List) Set(i int, v TunnelRegistration) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelRegistration_List) String() string {
	str, _ := text.MarshalList(0xf41a0f001ad49e46, s.List)
	return str
}

// TunnelRegistration_Promise is a wrapper for a TunnelRegistration promised by a client call.
type TunnelRegistration_Promise struct{ *capnp.Pipeline }

func (p TunnelRegistration_Promise) Struct() (TunnelRegistration, error) {
	s, err := p.Pipeline.Struct()
	return TunnelRegistration{s}, err
}

type RegistrationOptions struct{ capnp.Struct }

// RegistrationOptions_TypeID is the unique identifier for the type RegistrationOptions.
const RegistrationOptions_TypeID = 0xc793e50592935b4a

func NewRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func NewRootRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func ReadRootRegistrationOptions(msg *capnp.Message) (RegistrationOptions, error) {
	root, err := msg.RootPtr()
	return RegistrationOptions{root.Struct()}, err
}

func (s RegistrationOptions) String() string {
	str, _ := text.Marshal(0xc793e50592935b4a, s.Struct)
	return str
}

func (s RegistrationOptions) ClientId() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s RegistrationOptions) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) ClientIdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetClientId(v string) error {
	return s.Struct.SetText(0, v)
}

func (s RegistrationOptions) Version() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s RegistrationOptions) HasVersion() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetVersion(v string) error {
	return s.Struct.SetText(1, v)
}

func (s RegistrationOptions) Os() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s RegistrationOptions) HasOs() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OsBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOs(v string) error {
	return s.Struct.SetText(2, v)
}

func (s RegistrationOptions) ExistingTunnelPolicy() ExistingTunnelPolicy {
	return ExistingTunnelPolicy(s.Struct.Uint16(0))
}

func (s RegistrationOptions) SetExistingTunnelPolicy(v ExistingTunnelPolicy) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s RegistrationOptions) PoolName() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s RegistrationOptions) HasPoolName() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) PoolNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetPoolName(v string) error {
	return s.Struct.SetText(3, v)
}

func (s RegistrationOptions) Tags() (Tag_List, error) {
	p, err := s.Struct.Ptr(4)
	return Tag_List{List: p.List()}, err
}

func (s RegistrationOptions) HasTags() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetTags(v Tag_List) error {
	return s.Struct.SetPtr(4, v.List.ToPtr())
}

// NewTags sets the tags field to a newly
// allocated Tag_List, preferring placement in s's segment.
func (s RegistrationOptions) NewTags(n int32) (Tag_List, error) {
	l, err := NewTag_List(s.Struct.Segment(), n)
	if err != nil {
		return Tag_List{}, err
	}
	err = s.Struct.SetPtr(4, l.List.ToPtr())
	return l, err
}

func (s RegistrationOptions) ConnectionId() uint8 {
	return s.Struct.Uint8(2)
}

func (s RegistrationOptions) SetConnectionId(v uint8) {
	s.Struct.SetUint8(2, v)
}

func (s RegistrationOptions) OriginLocalIp() (string, error) {
	p, err := s.Struct.Ptr(5)
	return p.Text(), err
}

func (s RegistrationOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OriginLocalIpBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOriginLocalIp(v string) error {
	return s.Struct.SetText(5, v)
}

func (s RegistrationOptions) IsAutoupdated() bool {
	return s.Struct.Bit(24)
}

func (s RegistrationOptions) SetIsAutoupdated(v bool) {
	s.Struct.SetBit(24, v)
}

func (s RegistrationOptions) RunFromTerminal() bool {
	return s.Struct.Bit(25)
}

func (s RegistrationOptions) SetRunFromTerminal(v bool) {
	s.Struct.SetBit(25, v)
}

func (s RegistrationOptions) CompressionQuality() uint64 {
	return s.Struct.Uint64(8)
}

func (s RegistrationOptions) SetCompressionQuality(v uint64) {
	s.Struct.SetUint64(8, v)
}

func (s RegistrationOptions) Uuid() (string, error) {
	p, err := s.Struct.Ptr(6)
	return p.Text(), err
}

func (s RegistrationOptions) HasUuid() bool {
	p, err := s.Struct.Ptr(6)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) UuidBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(6)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetUuid(v string) error {
	return s.Struct.SetText(6, v)
}

func (s RegistrationOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(4)
}

func (s RegistrationOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(4, v)
}

func (s RegistrationOptions) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(7)
	return capnp.TextList{List: p.List()}, err
}

func (s RegistrationOptions) HasFeatures() bool {
	p, err := s.Struct.Ptr(7)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(7, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s RegistrationOptions) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(7, l.List.ToPtr())
	return l, err
}

// RegistrationOptions_List is a list of RegistrationOptions.
type RegistrationOptions_List struct{ capnp.List }

// NewRegistrationOptions creates a new list of RegistrationOptions.
func NewRegistrationOptions_List(s *capnp.Segment, sz int32) (RegistrationOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8}, sz)
	return RegistrationOptions_List{l}, err
}

func (s RegistrationOptions_List) At(i int) RegistrationOptions {
	return RegistrationOptions{s.List.Struct(i)}
}

func (s RegistrationOptions_List) Set(i int, v RegistrationOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationOptions_List) String() string {
	str, _ := text.MarshalList(0xc793e50592935b4a, s.List)
	return str
}

// RegistrationOptions_Promise is a wrapper for a RegistrationOptions promised by a client call.
type RegistrationOptions_Promise struct{ *capnp.Pipeline }

func (p RegistrationOptions_Promise) Struct() (RegistrationOptions, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationOptions{s}, err
}

type Tag struct{ capnp.Struct }

// Tag_TypeID is the unique identifier for the type Tag.
const Tag_TypeID = 0xcbd96442ae3bb01a

func NewTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func NewRootTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func ReadRootTag(msg *capnp.Message) (Tag, error) {
	root, err := msg.RootPtr()
	return Tag{root.Struct()}, err
}

func (s Tag) String() string {
	str, _ := text.Marshal(0xcbd96442ae3bb01a, s.Struct)
	return str
}

func (s Tag) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Tag) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Tag) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Tag) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Tag) Value() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Tag) HasValue() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Tag) ValueBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Tag) SetValue(v string) error {
	return s.Struct.SetText(1, v)
}

// Tag_List is a list of Tag.
type Tag_List struct{ capnp.List }

// NewTag creates a new list of Tag.
func NewTag_List(s *capnp.Segment, sz int32) (Tag_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return Tag_List{l}, err
}

func (s Tag_List) At(i int) Tag { return Tag{s.List.Struct(i)} }

func (s Tag_List) Set(i int, v Tag) error { return s.List.SetStruct(i, v.Struct) }

func (s Tag_List) String() string {
	str, _ := text.MarshalList(0xcbd96442ae3bb01a, s.List)
	return str
}

// Tag_Promise is a wrapper for a Tag promised by a client call.
type Tag_Promise struct{ *capnp.Pipeline }

func (p Tag_Promise) Struct() (Tag, error) {
	s, err := p.Pipeline.Struct()
	return Tag{s}, err
}

type ExistingTunnelPolicy uint16

// ExistingTunnelPolicy_TypeID is the unique identifier for the type ExistingTunnelPolicy.
const ExistingTunnelPolicy_TypeID = 0x84cb9536a2cf6d3c

// Values of ExistingTunnelPolicy.
const (
	ExistingTunnelPolicy_ignore     ExistingTunnelPolicy = 0
	ExistingTunnelPolicy_disconnect ExistingTunnelPolicy = 1
	ExistingTunnelPolicy_balance    ExistingTunnelPolicy = 2
)

// String returns the enum's constant name.
func (c ExistingTunnelPolicy) String() string {
	switch c {
	case ExistingTunnelPolicy_ignore:
		return "ignore"
	case ExistingTunnelPolicy_disconnect:
		return "disconnect"
	case ExistingTunnelPolicy_balance:
		return "balance"

	default:
		return ""
	}
}

// ExistingTunnelPolicyFromString returns the enum value with a name,
// or the zero value if there's no such value.
func ExistingTunnelPolicyFromString(c string) ExistingTunnelPolicy {
	switch c {
	case "ignore":
		return ExistingTunnelPolicy_ignore
	case "disconnect":
		return ExistingTunnelPolicy_disconnect
	case "balance":
		return ExistingTunnelPolicy_balance

	default:
		return 0
	}
}

type ExistingTunnelPolicy_List struct{ capnp.List }

func NewExistingTunnelPolicy_List(s *capnp.Segment, sz int32) (ExistingTunnelPolicy_List, error) {
	l, err := capnp.NewUInt16List(s, sz)
	return ExistingTunnelPolicy_List{l.List}, err
}

func (l ExistingTunnelPolicy_List) At(i int) ExistingTunnelPolicy {
	ul := capnp.UInt16List{List: l.List}
	return ExistingTunnelPolicy(ul.At(i))
}

func (l ExistingTunnelPolicy_List) Set(i int, v ExistingTunnelPolicy) {
	ul := capnp.UInt16List{List: l.List}
	ul.Set(i, uint16(v))
}

type ServerInfo struct{ capnp.Struct }

// ServerInfo_TypeID is the unique identifier for the type ServerInfo.
const ServerInfo_TypeID = 0xf2c68e2547ec3866

func NewServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func NewRootServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func ReadRootServerInfo(msg *capnp.Message) (ServerInfo, error) {
	root, err := msg.RootPtr()
	return ServerInfo{root.Struct()}, err
}

func (s ServerInfo) String() string {
	str, _ := text.Marshal(0xf2c68e2547ec3866, s.Struct)
	return str
}

func (s ServerInfo) LocationName() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ServerInfo) HasLocationName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ServerInfo) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ServerInfo) SetLocationName(v string) error {
	return s.Struct.SetText(0, v)
}

// ServerInfo_List is a list of ServerInfo.
type ServerInfo_List struct{ capnp.List }

// NewServerInfo creates a new list of ServerInfo.
func NewServerInfo_List(s *capnp.Segment, sz int32) (ServerInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return ServerInfo_List{l}, err
}

func (s ServerInfo_List) At(i int) ServerInfo { return ServerInfo{s.List.Struct(i)} }

func (s ServerInfo_List) Set(i int, v ServerInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ServerInfo_List) String() string {
	str, _ := text.MarshalList(0xf2c68e2547ec3866, s.List)
	return str
}

// ServerInfo_Promise is a wrapper for a ServerInfo promised by a client call.
type ServerInfo_Promise struct{ *capnp.Pipeline }

func (p ServerInfo_Promise) Struct() (ServerInfo, error) {
	s, err := p.Pipeline.Struct()
	return ServerInfo{s}, err
}

type AuthenticateResponse struct{ capnp.Struct }

// AuthenticateResponse_TypeID is the unique identifier for the type AuthenticateResponse.
const AuthenticateResponse_TypeID = 0x82c325a07ad22a65

func NewAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func NewRootAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func ReadRootAuthenticateResponse(msg *capnp.Message) (AuthenticateResponse, error) {
	root, err := msg.RootPtr()
	return AuthenticateResponse{root.Struct()}, err
}

func (s AuthenticateResponse) String() string {
	str, _ := text.Marshal(0x82c325a07ad22a65, s.Struct)
	return str
}

func (s AuthenticateResponse) PermanentErr() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s AuthenticateResponse) HasPermanentErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) PermanentErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetPermanentErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s AuthenticateResponse) RetryableErr() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s AuthenticateResponse) HasRetryableErr() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) RetryableErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetRetryableErr(v string) error {
	return s.Struct.SetText(1, v)
}

func (s AuthenticateResponse) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s AuthenticateResponse) HasJwt() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) SetJwt(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s AuthenticateResponse) HoursUntilRefresh() uint8 {
	return s.Struct.Uint8(0)
}

func (s AuthenticateResponse) SetHoursUntilRefresh(v uint8) {
	s.Struct.SetUint8(0, v)
}

// AuthenticateResponse_List is a list of AuthenticateResponse.
type AuthenticateResponse_List struct{ capnp.List }

// NewAuthenticateResponse creates a new list of AuthenticateResponse.
func NewAuthenticateResponse_List(s *capnp.Segment, sz int32) (AuthenticateResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return AuthenticateResponse_List{l}, err
}

func (s AuthenticateResponse_List) At(i int) AuthenticateResponse {
	return AuthenticateResponse{s.List.Struct(i)}
}

func (s AuthenticateResponse_List) Set(i int, v AuthenticateResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s AuthenticateResponse_List) String() string {
	str, _ := text.MarshalList(0x82c325a07ad22a65, s.List)
	return str
}

// AuthenticateResponse_Promise is a wrapper for a AuthenticateResponse promised by a client call.
type AuthenticateResponse_Promise struct{ *capnp.Pipeline }

func (p AuthenticateResponse_Promise) Struct() (AuthenticateResponse, error) {
	s, err := p.Pipeline.Struct()
	return AuthenticateResponse{s}, err
}

type ClientInfo struct{ capnp.Struct }

// ClientInfo_TypeID is the unique identifier for the type ClientInfo.
const ClientInfo_TypeID = 0x83ced0145b2f114b

func NewClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func NewRootClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func ReadRootClientInfo(msg *capnp.Message) (ClientInfo, error) {
	root, err := msg.RootPtr()
	return ClientInfo{root.Struct()}, err
}

func (s ClientInfo) String() string {
	str, _ := text.Marshal(0x83ced0145b2f114b, s.Struct)
	return str
}

func (s ClientInfo) ClientId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ClientInfo) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetClientId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ClientInfo) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.TextList{List: p.List()}, err
}

func (s ClientInfo) HasFeatures() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s ClientInfo) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s ClientInfo) Version() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s ClientInfo) HasVersion() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s ClientInfo) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s ClientInfo) SetVersion(v string) error {
	return s.Struct.SetText(2, v)
}

func (s ClientInfo) Arch() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s ClientInfo) HasArch() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s ClientInfo) ArchBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s ClientInfo) SetArch(v string) error {
	return s.Struct.SetText(3, v)
}

// ClientInfo_List is a list of ClientInfo.
type ClientInfo_List struct{ capnp.List }

// NewClientInfo creates a new list of ClientInfo.
func NewClientInfo_List(s *capnp.Segment, sz int32) (ClientInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4}, sz)
	return ClientInfo_List{l}, err
}

func (s ClientInfo_List) At(i int) ClientInfo { return ClientInfo{s.List.Struct(i)} }

func (s ClientInfo_List) Set(i int, v ClientInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ClientInfo_List) String() string {
	str, _ := text.MarshalList(0x83ced0145b2f114b, s.List)
	return str
}

// ClientInfo_Promise is a wrapper for a ClientInfo promised by a client call.
type ClientInfo_Promise struct{ *capnp.Pipeline }

func (p ClientInfo_Promise) Struct() (ClientInfo, error) {
	s, err := p.Pipeline.Struct()
	return ClientInfo{s}, err
}

type ConnectionOptions struct{ capnp.Struct }

// ConnectionOptions_TypeID is the unique identifier for the type ConnectionOptions.
const ConnectionOptions_TypeID = 0xb4bf9861fe035d04

func NewConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func NewRootConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func ReadRootConnectionOptions(msg *capnp.Message) (ConnectionOptions, error) {
	root, err := msg.RootPtr()
	return ConnectionOptions{root.Struct()}, err
}

func (s ConnectionOptions) String() string {
	str, _ := text.Marshal(0xb4bf9861fe035d04, s.Struct)
	return str
}

func (s ConnectionOptions) Client() (ClientInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ClientInfo{Struct: p.Struct()}, err
}

func (s ConnectionOptions) HasClient() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetClient(v ClientInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewClient sets the client field to a newly
// allocated ClientInfo struct, preferring placement in s's segment.
func (s ConnectionOptions) NewClient() (ClientInfo, error) {
	ss, err := NewClientInfo(s.Struct.Segment())
	if err != nil {
		return ClientInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionOptions) OriginLocalIp() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s ConnectionOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetOriginLocalIp(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s ConnectionOptions) ReplaceExisting() bool {
	return s.Struct.Bit(0)
}

func (s ConnectionOptions) SetReplaceExisting(v bool) {
	s.Struct.SetBit(0, v)
}

func (s ConnectionOptions) CompressionQuality() uint8 {
	return s.Struct.Uint8(1)
}

func (s ConnectionOptions) SetCompressionQuality(v uint8) {
	s.Struct.SetUint8(1, v)
}

func (s ConnectionOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(2)
}

func (s ConnectionOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(2, v)
}

// ConnectionOptions_List is a list of ConnectionOptions.
type ConnectionOptions_List struct{ capnp.List }

// NewConnectionOptions creates a new list of ConnectionOptions.
func NewConnectionOptions_List(s *capnp.Segment, sz int32) (ConnectionOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return ConnectionOptions_List{l}, err
}

func (s ConnectionOptions_List) At(i int) ConnectionOptions {
	return ConnectionOptions{s.List.Struct(i)}
}

func (s ConnectionOptions_List) Set(i int, v ConnectionOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionOptions_List) String() string {
	str, _ := text.MarshalList(0xb4bf9861fe035d04, s.List)
	return str
}

// ConnectionOptions_Promise is a wrapper for a ConnectionOptions promised by a client call.
type ConnectionOptions_Promise struct{ *capnp.Pipeline }

func (p ConnectionOptions_Promise) Struct() (ConnectionOptions, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionOptions{s}, err
}

func (p ConnectionOptions_Promise) Client() ClientInfo_Promise {
	return ClientInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionResponse struct{ capnp.Struct }
type ConnectionResponse_result ConnectionResponse
type ConnectionResponse_result_Which uint16

const (
	ConnectionResponse_result_Which_error             ConnectionResponse_result_Which = 0
	ConnectionResponse_result_Which_connectionDetails ConnectionResponse_result_Which = 1
)

func (w ConnectionResponse_result_Which) String() string {
	const s = "errorconnectionDetails"
	switch w {
	case ConnectionResponse_result_Which_error:
		return s[0:5]
	case ConnectionResponse_result_Which_connectionDetails:
		return s[5:22]

	}
	return "ConnectionResponse_result_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// ConnectionResponse_TypeID is the unique identifier for the type ConnectionResponse.
const ConnectionResponse_TypeID = 0xdbaa9d03d52b62dc

func NewConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func NewRootConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func ReadRootConnectionResponse(msg *capnp.Message) (ConnectionResponse, error) {
	root, err := msg.RootPtr()
	return ConnectionResponse{root.Struct()}, err
}

func (s ConnectionResponse) String() string {
	str, _ := text.Marshal(0xdbaa9d03d52b62dc, s.Struct)
	return str
}

func (s ConnectionResponse) Result() ConnectionResponse_result { return ConnectionResponse_result(s) }

func (s ConnectionResponse_result) Which() ConnectionResponse_result_Which {
	return ConnectionResponse_result_Which(s.Struct.Uint16(0))
}
func (s ConnectionResponse_result) Error() (ConnectionError, error) {
	if s.Struct.Uint16(0) != 0 {
		panic("Which() != error")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionError{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasError() bool {
	if s.Struct.Uint16(0) != 0 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetError(v ConnectionError) error {
	s.Struct.SetUint16(0, 0)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewError sets the error field to a newly
// allocated ConnectionError struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewError() (ConnectionError, error) {
	s.Struct.SetUint16(0, 0)
	ss, err := NewConnectionError(s.Struct.Segment())
	if err != nil {
		return ConnectionError{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionResponse_result) ConnectionDetails() (ConnectionDetails, error) {
	if s.Struct.Uint16(0) != 1 {
		panic("Which() != connectionDetails")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionDetails{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasConnectionDetails() bool {
	if s.Struct.Uint16(0) != 1 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetConnectionDetails(v ConnectionDetails) error {
	s.Struct.SetUint16(0, 1)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewConnectionDetails sets the connectionDetails field to a newly
// allocated ConnectionDetails struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewConnectionDetails() (ConnectionDetails, error) {
	s.Struct.SetUint16(0, 1)
	ss, err := NewConnectionDetails(s.Struct.Segment())
	if err != nil {
		return ConnectionDetails{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// ConnectionResponse_List is a list of ConnectionResponse.
type ConnectionResponse_List struct{ capnp.List }

// NewConnectionResponse creates a new list of ConnectionResponse.
func NewConnectionResponse_List(s *capnp.Segment, sz int32) (ConnectionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return ConnectionResponse_List{l}, err
}

func (s ConnectionResponse_List) At(i int) ConnectionResponse {
	return ConnectionResponse{s.List.Struct(i)}
}

func (s ConnectionResponse_List) Set(i int, v ConnectionResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionResponse_List) String() string {
	str, _ := text.MarshalList(0xdbaa9d03d52b62dc, s.List)
	return str
}

// ConnectionResponse_Promise is a wrapper for a ConnectionResponse promised by a client call.
type ConnectionResponse_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_Promise) Struct() (ConnectionResponse, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse{s}, err
}

func (p ConnectionResponse_Promise) Result() ConnectionResponse_result_Promise {
	return ConnectionResponse_result_Promise{p.Pipeline}
}

// ConnectionResponse_result_Promise is a wrapper for a ConnectionResponse_result promised by a client call.
type ConnectionResponse_result_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_result_Promise) Struct() (ConnectionResponse_result, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse_result{s}, err
}

func (p ConnectionResponse_result_Promise) Error() ConnectionError_Promise {
	return ConnectionError_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p ConnectionResponse_result_Promise) ConnectionDetails() ConnectionDetails_Promise {
	return ConnectionDetails_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionError struct{ capnp.Struct }

// ConnectionError_TypeID is the unique identifier for the type ConnectionError.
const ConnectionError_TypeID = 0xf5f383d2785edb86

func NewConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func NewRootConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func ReadRootConnectionError(msg *capnp.Message) (ConnectionError, error) {
	root, err := msg.RootPtr()
	return ConnectionError{root.Struct()}, err
}

func (s ConnectionError) String() string {
	str, _ := text.Marshal(0xf5f383d2785edb86, s.Struct)
	return str
}

func (s ConnectionError) Cause() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ConnectionError) HasCause() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionError) CauseBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ConnectionError) SetCause(v string) error {
	return s.Struct.SetText(0, v)
}

func (s ConnectionError) RetryAfter() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s ConnectionError) SetRetryAfter(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

func (s ConnectionError) ShouldRetry() bool {
	return s.Struct.Bit(64)
}

func (s ConnectionError) SetShouldRetry(v bool) {
	s.Struct.SetBit(64, v)
}

// ConnectionError_List is a list of ConnectionError.
type ConnectionError_List struct{ capnp.List }

// NewConnectionError creates a new list of ConnectionError.
func NewConnectionError_List(s *capnp.Segment, sz int32) (ConnectionError_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return ConnectionError_List{l}, err
}

func (s ConnectionError_List) At(i int) ConnectionError { return ConnectionError{s.List.Struct(i)} }

func (s ConnectionError_List) Set(i int, v ConnectionError) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionError_List) String() string {
	str, _ := text.MarshalList(0xf5f383d2785edb86, s.List)
	return str
}

// ConnectionError_Promise is a wrapper for a ConnectionError promised by a client call.
type ConnectionError_Promise struct{ *capnp.Pipeline }

func (p ConnectionError_Promise) Struct() (ConnectionError, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionError{s}, err
}

type ConnectionDetails struct{ capnp.Struct }

// ConnectionDetails_TypeID is the unique identifier for the type ConnectionDetails.
const ConnectionDetails_TypeID = 0xb5f39f082b9ac18a

func NewConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func NewRootConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func ReadRootConnectionDetails(msg *capnp.Message) (ConnectionDetails, error) {
	root, err := msg.RootPtr()
	return ConnectionDetails{root.Struct()}, err
}

func (s ConnectionDetails) String() string {
	str, _ := text.Marshal(0xb5f39f082b9ac18a, s.Struct)
	return str
}

func (s ConnectionDetails) Uuid() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ConnectionDetails) HasUuid() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) SetUuid(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ConnectionDetails) LocationName() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s ConnectionDetails) HasLocationName() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s ConnectionDetails) SetLocationName(v string) error {
	return s.Struct.SetText(1, v)
}

// ConnectionDetails_List is a list of ConnectionDetails.
type ConnectionDetails_List struct{ capnp.List }

// NewConnectionDetails creates a new list of ConnectionDetails.
func NewConnectionDetails_List(s *capnp.Segment, sz int32) (ConnectionDetails_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return ConnectionDetails_List{l}, err
}

func (s ConnectionDetails_List) At(i int) ConnectionDetails {
	return ConnectionDetails{s.List.Struct(i)}
}

func (s ConnectionDetails_List) Set(i int, v ConnectionDetails) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionDetails_List) String() string {
	str, _ := text.MarshalList(0xb5f39f082b9ac18a, s.List)
	return str
}

// ConnectionDetails_Promise is a wrapper for a ConnectionDetails promised by a client call.
type ConnectionDetails_Promise struct{ *capnp.Pipeline }

func (p ConnectionDetails_Promise) Struct() (ConnectionDetails, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionDetails{s}, err
}

type TunnelAuth struct{ capnp.Struct }

// TunnelAuth_TypeID is the unique identifier for the type TunnelAuth.
const TunnelAuth_TypeID = 0x9496331ab9cd463f

func NewTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func NewRootTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func ReadRootTunnelAuth(msg *capnp.Message) (TunnelAuth, error) {
	root, err := msg.RootPtr()
	return TunnelAuth{root.Struct()}, err
}

func (s TunnelAuth) String() string {
	str, _ := text.Marshal(0x9496331ab9cd463f, s.Struct)
	return str
}

func (s TunnelAuth) AccountTag() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelAuth) HasAccountTag() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) AccountTagBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelAuth) SetAccountTag(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelAuth) TunnelSecret() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelAuth) HasTunnelSecret() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) SetTunnelSecret(v []byte) error {
	return s.Struct.SetData(1, v)
}

// TunnelAuth_List is a list of TunnelAuth.
type TunnelAuth_List struct{ capnp.List }

// NewTunnelAuth creates a new list of TunnelAuth.
func NewTunnelAuth_List(s *capnp.Segment, sz int32) (TunnelAuth_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return TunnelAuth_List{l}, err
}

func (s TunnelAuth_List) At(i int) TunnelAuth { return TunnelAuth{s.List.Struct(i)} }

func (s TunnelAuth_List) Set(i int, v TunnelAuth) error { return s.List.SetStruct(i, v.Struct) }

func (s TunnelAuth_List) String() string {
	str, _ := text.MarshalList(0x9496331ab9cd463f, s.List)
	return str
}

// TunnelAuth_Promise is a wrapper for a TunnelAuth promised by a client call.
type TunnelAuth_Promise struct{ *capnp.Pipeline }

func (p TunnelAuth_Promise) Struct() (TunnelAuth, error) {
	s, err := p.Pipeline.Struct()
	return TunnelAuth{s}, err
}

type RegistrationServer struct{ Client capnp.Client }

// RegistrationServer_TypeID is the unique identifier for the type RegistrationServer.
const RegistrationServer_TypeID = 0xf71695ec7fe85497

func (c RegistrationServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c RegistrationServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type RegistrationServer_Server interface {
	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error
}

func RegistrationServer_ServerToClient(s RegistrationServer_Server) RegistrationServer {
	c, _ := s.(server.Closer)
	return RegistrationServer{Client: server.New(RegistrationServer_Methods(nil, s), c)}
}

func RegistrationServer_Methods(methods []server.Method, s RegistrationServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 2)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// RegistrationServer_registerConnection holds the arguments for a server call to RegistrationServer.registerConnection.
type RegistrationServer_registerConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_registerConnection_Params
	Results RegistrationServer_registerConnection_Results
}

// RegistrationServer_unregisterConnection holds the arguments for a server call to RegistrationServer.unregisterConnection.
type RegistrationServer_unregisterConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_unregisterConnection_Params
	Results RegistrationServer_unregisterConnection_Results
}

type RegistrationServer_registerConnection_Params struct{ capnp.Struct }

// RegistrationServer_registerConnection_Params_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Params.
const RegistrationServer_registerConnection_Params_TypeID = 0xe6646dec8feaa6ee

func NewRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func NewRootRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func ReadRootRegistrationServer_registerConnection_Params(msg *capnp.Message) (RegistrationServer_registerConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) String() string {
	str, _ := text.Marshal(0xe6646dec8feaa6ee, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Params) Auth() (TunnelAuth, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelAuth{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasAuth() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetAuth(v TunnelAuth) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewAuth sets the auth field to a newly
// allocated TunnelAuth struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewAuth() (TunnelAuth, error) {
	ss, err := NewTunnelAuth(s.Struct.Segment())
	if err != nil {
		return TunnelAuth{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s RegistrationServer_registerConnection_Params) TunnelId() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s RegistrationServer_registerConnection_Params) HasTunnelId() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetTunnelId(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s RegistrationServer_registerConnection_Params) ConnIndex() uint8 {
	return s.Struct.Uint8(0)
}

func (s RegistrationServer_registerConnection_Params) SetConnIndex(v uint8) {
	s.Struct.SetUint8(0, v)
}

func (s RegistrationServer_registerConnection_Params) Options() (ConnectionOptions, error) {
	p, err := s.Struct.Ptr(2)
	return ConnectionOptions{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetOptions(v ConnectionOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated ConnectionOptions struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewOptions() (ConnectionOptions, error) {
	ss, err := NewConnectionOptions(s.Struct.Segment())
	if err != nil {
		return ConnectionOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Params_List is a list of RegistrationServer_registerConnection_Params.
type RegistrationServer_registerConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Params creates a new list of RegistrationServer_registerConnection_Params.
func NewRegistrationServer_registerConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return RegistrationServer_registerConnection_Params_List{l}, err
}

func (s RegistrationServer_registerConnection_Params_List) At(i int) RegistrationServer_registerConnection_Params {
	return RegistrationServer_registerConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Params_List) Set(i int, v RegistrationServer_registerConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xe6646dec8feaa6ee, s.List)
	return str
}

// RegistrationServer_registerConnection_Params_Promise is a wrapper for a RegistrationServer_registerConnection_Params promised by a client call.
type RegistrationServer_registerConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Params_Promise) Struct() (RegistrationServer_registerConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Params{s}, err
}

func (p RegistrationServer_registerConnection_Params_Promise) Auth() TunnelAuth_Promise {
	return TunnelAuth_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p RegistrationServer_registerConnection_Params_Promise) Options() ConnectionOptions_Promise {
	return ConnectionOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type RegistrationServer_registerConnection_Results struct{ capnp.Struct }

// RegistrationServer_registerConnection_Results_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Results.
const RegistrationServer_registerConnection_Results_TypeID = 0xea50d822450d1f17

func NewRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func NewRootRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func ReadRootRegistrationServer_registerConnection_Results(msg *capnp.Message) (RegistrationServer_registerConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) String() string {
	str, _ := text.Marshal(0xea50d822450d1f17, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Results) Result() (ConnectionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return ConnectionResponse{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Results) SetResult(v ConnectionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ConnectionResponse struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Results) NewResult() (ConnectionResponse, error) {
	ss, err := NewConnectionResponse(s.Struct.Segment())
	if err != nil {
		return ConnectionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Results_List is a list of RegistrationServer_registerConnection_Results.
type RegistrationServer_registerConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Results creates a new list of RegistrationServer_registerConnection_Results.
func NewRegistrationServer_registerConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RegistrationServer_registerConnection_Results_List{l}, err
}

func (s RegistrationServer_registerConnection_Results_List) At(i int) RegistrationServer_registerConnection_Results {
	return RegistrationServer_registerConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Results_List) Set(i int, v RegistrationServer_registerConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xea50d822450d1f17, s.List)
	return str
}

// RegistrationServer_registerConnection_Results_Promise is a wrapper for a RegistrationServer_registerConnection_Results promised by a client call.
type RegistrationServer_registerConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Results_Promise) Struct() (RegistrationServer_registerConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Results{s}, err
}

func (p RegistrationServer_registerConnection_Results_Promise) Result() ConnectionResponse_Promise {
	return ConnectionResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type RegistrationServer_unregisterConnection_Params struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Params_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Params.
const RegistrationServer_unregisterConnection_Params_TypeID = 0xf9cb7f4431a307d0

func NewRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Params(msg *capnp.Message) (RegistrationServer_unregisterConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Params) String() string {
	str, _ := text.Marshal(0xf9cb7f4431a307d0, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Params_List is a list of RegistrationServer_unregisterConnection_Params.
type RegistrationServer_unregisterConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Params creates a new list of RegistrationServer_unregisterConnection_Params.
func NewRegistrationServer_unregisterConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Params_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Params_List) At(i int) RegistrationServer_unregisterConnection_Params {
	return RegistrationServer_unregisterConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Params_List) Set(i int, v RegistrationServer_unregisterConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xf9cb7f4431a307d0, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Params_Promise is a wrapper for a RegistrationServer_unregisterConnection_Params promised by a client call.
type RegistrationServer_unregisterConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Params_Promise) Struct() (RegistrationServer_unregisterConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Params{s}, err
}

type RegistrationServer_unregisterConnection_Results struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Results_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Results.
const RegistrationServer_unregisterConnection_Results_TypeID = 0xb046e578094b1ead

func NewRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Results(msg *capnp.Message) (RegistrationServer_unregisterConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Results) String() string {
	str, _ := text.Marshal(0xb046e578094b1ead, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Results_List is a list of RegistrationServer_unregisterConnection_Results.
type RegistrationServer_unregisterConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Results creates a new list of RegistrationServer_unregisterConnection_Results.
func NewRegistrationServer_unregisterConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Results_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Results_List) At(i int) RegistrationServer_unregisterConnection_Results {
	return RegistrationServer_unregisterConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Results_List) Set(i int, v RegistrationServer_unregisterConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xb046e578094b1ead, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Results_Promise is a wrapper for a RegistrationServer_unregisterConnection_Results promised by a client call.
type RegistrationServer_unregisterConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Results_Promise) Struct() (RegistrationServer_unregisterConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Results{s}, err
}

type TunnelServer struct{ Client capnp.Client }

// TunnelServer_TypeID is the unique identifier for the type TunnelServer.
const TunnelServer_TypeID = 0xea58385c65416035

func (c TunnelServer) RegisterTunnel(ctx context.Context, params func(TunnelServer_registerTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_registerTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_registerTunnel_Params{Struct: s}) }
	}
	return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) GetServerInfo(ctx context.Context, params func(TunnelServer_getServerInfo_Params) error, opts ...capnp.CallOption) TunnelServer_getServerInfo_Results_Promise {
	if c.Client == nil {
		return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_getServerInfo_Params{Struct: s}) }
	}
	return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterTunnel(ctx context.Context, params func(TunnelServer_unregisterTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_unregisterTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_unregisterTunnel_Params{Struct: s}) }
	}
	return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ObsoleteDeclarativeTunnelConnect(ctx context.Context, params func(TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error, opts ...capnp.CallOption) TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise {
	if c.Client == nil {
		return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error {
			return params(TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: s})
		}
	}
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) Authenticate(ctx context.Context, params func(TunnelServer_authenticate_Params) error, opts ...capnp.CallOption) TunnelServer_authenticate_Results_Promise {
	if c.Client == nil {
		return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_authenticate_Params{Struct: s}) }
	}
	return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ReconnectTunnel(ctx context.Context, params func(TunnelServer_reconnectTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_reconnectTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 5}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_reconnectTunnel_Params{Struct: s}) }
	}
	return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type TunnelServer_Server interface {
	RegisterTunnel(TunnelServer_registerTunnel) error

	GetServerInfo(TunnelServer_getServerInfo) error

	UnregisterTunnel(TunnelServer_unregisterTunnel) error

	ObsoleteDeclarativeTunnelConnect(TunnelServer_obsoleteDeclarativeTunnelConnect) error

	Authenticate(TunnelServer_authenticate) error

	ReconnectTunnel(TunnelServer_reconnectTunnel) error

	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error
}

func TunnelServer_ServerToClient(s TunnelServer_Server) TunnelServer {
	c, _ := s.(server.Closer)
	return TunnelServer{Client: server.New(TunnelServer_Methods(nil, s), c)}
}

func TunnelServer_Methods(methods []server.Method, s TunnelServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 8)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_registerTunnel{c, opts, TunnelServer_registerTunnel_Params{Struct: p}, TunnelServer_registerTunnel_Results{Struct: r}}
			return s.RegisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_getServerInfo{c, opts, TunnelServer_getServerInfo_Params{Struct: p}, TunnelServer_getServerInfo_Results{Struct: r}}
			return s.GetServerInfo(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_unregisterTunnel{c, opts, TunnelServer_unregisterTunnel_Params{Struct: p}, TunnelServer_unregisterTunnel_Results{Struct: r}}
			return s.UnregisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_obsoleteDeclarativeTunnelConnect{c, opts, TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: p}, TunnelServer_obsoleteDeclarativeTunnelConnect_Results{Struct: r}}
			return s.ObsoleteDeclarativeTunnelConnect(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_authenticate{c, opts, TunnelServer_authenticate_Params{Struct: p}, TunnelServer_authenticate_Results{Struct: r}}
			return s.Authenticate(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_reconnectTunnel{c, opts, TunnelServer_reconnectTunnel_Params{Struct: p}, TunnelServer_reconnectTunnel_Results{Struct: r}}
			return s.ReconnectTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// TunnelServer_registerTunnel holds the arguments for a server call to TunnelServer.registerTunnel.
type TunnelServer_registerTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_registerTunnel_Params
	Results TunnelServer_registerTunnel_Results
}

// TunnelServer_getServerInfo holds the arguments for a server call to TunnelServer.getServerInfo.
type TunnelServer_getServerInfo struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_getServerInfo_Params
	Results TunnelServer_getServerInfo_Results
}

// TunnelServer_unregisterTunnel holds the arguments for a server call to TunnelServer.unregisterTunnel.
type TunnelServer_unregisterTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_unregisterTunnel_Params
	Results TunnelServer_unregisterTunnel_Results
}

// TunnelServer_obsoleteDeclarativeTunnelConnect holds the arguments for a server call to TunnelServer.obsoleteDeclarativeTunnelConnect.
type TunnelServer_obsoleteDeclarativeTunnelConnect struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_obsoleteDeclarativeTunnelConnect_Params
	Results TunnelServer_obsoleteDeclarativeTunnelConnect_Results
}

// TunnelServer_authenticate holds the arguments for a server call to TunnelServer.authenticate.
type TunnelServer_authenticate struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_authenticate_Params
	Results TunnelServer_authenticate_Results
}

// TunnelServer_reconnectTunnel holds the arguments for a server call to TunnelServer.reconnectTunnel.
type TunnelServer_reconnectTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_reconnectTunnel_Params
	Results TunnelServer_reconnectTunnel_Results
}

type TunnelServer_registerTunnel_Params struct{ capnp.Struct }

// TunnelServer_registerTunnel_Params_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Params.
const TunnelServer_registerTunnel_Params_TypeID = 0xb70431c0dc014915

func NewTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func NewRootTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func ReadRootTunnelServer_registerTunnel_Params(msg *capnp.Message) (TunnelServer_registerTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) String() string {
	str, _ := text.Marshal(0xb70431c0dc014915, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_registerTunnel_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_registerTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_registerTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_registerTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_registerTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Params_List is a list of TunnelServer_registerTunnel_Params.
type TunnelServer_registerTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Params creates a new list of TunnelServer_registerTunnel_Params.
func NewTunnelServer_registerTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_registerTunnel_Params_List{l}, err
}

func (s TunnelServer_registerTunnel_Params_List) At(i int) TunnelServer_registerTunnel_Params {
	return TunnelServer_registerTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Params_List) Set(i int, v TunnelServer_registerTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xb70431c0dc014915, s.List)
	return str
}

// TunnelServer_registerTunnel_Params_Promise is a wrapper for a TunnelServer_registerTunnel_Params promised by a client call.
type TunnelServer_registerTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Params_Promise) Struct() (TunnelServer_registerTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Params{s}, err
}

func (p TunnelServer_registerTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_registerTunnel_Results struct{ capnp.Struct }

// TunnelServer_registerTunnel_Results_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Results.
const TunnelServer_registerTunnel_Results_TypeID = 0xf2c122394f447e8e

func NewTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func NewRootTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func ReadRootTunnelServer_registerTunnel_Results(msg *capnp.Message) (TunnelServer_registerTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) String() string {
	str, _ := text.Marshal(0xf2c122394f447e8e, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Results_List is a list of TunnelServer_registerTunnel_Results.
type TunnelServer_registerTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Results creates a new list of TunnelServer_registerTunnel_Results.
func NewTunnelServer_registerTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_registerTunnel_Results_List{l}, err
}

func (s TunnelServer_registerTunnel_Results_List) At(i int) TunnelServer_registerTunnel_Results {
	return TunnelServer_registerTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Results_List) Set(i int, v TunnelServer_registerTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xf2c122394f447e8e, s.List)
	return str
}

// TunnelServer_registerTunnel_Results_Promise is a wrapper for a TunnelServer_registerTunnel_Results promised by a client call.
type TunnelServer_registerTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Results_Promise) Struct() (TunnelServer_registerTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Results{s}, err
}

func (p TunnelServer_registerTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_getServerInfo_Params struct{ capnp.Struct }

// TunnelServer_getServerInfo_Params_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Params.
const TunnelServer_getServerInfo_Params_TypeID = 0xdc3ed6801961e502

func NewTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func NewRootTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func ReadRootTunnelServer_getServerInfo_Params(msg *capnp.Message) (TunnelServer_getServerInfo_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Params{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Params) String() string {
	str, _ := text.Marshal(0xdc3ed6801961e502, s.Struct)
	return str
}

// TunnelServer_getServerInfo_Params_List is a list of TunnelServer_getServerInfo_Params.
type TunnelServer_getServerInfo_Params_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Params creates a new list of TunnelServer_getServerInfo_Params.
func NewTunnelServer_getServerInfo_Params_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_getServerInfo_Params_List{l}, err
}

func (s TunnelServer_getServerInfo_Params_List) At(i int) TunnelServer_getServerInfo_Params {
	return TunnelServer_getServerInfo_Params{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Params_List) Set(i int, v TunnelServer_getServerInfo_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Params_List) String() string {
	str, _ := text.MarshalList(0xdc3ed6801961e502, s.List)
	return str
}

// TunnelServer_getServerInfo_Params_Promise is a wrapper for a TunnelServer_getServerInfo_Params promised by a client call.
type TunnelServer_getServerInfo_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Params_Promise) Struct() (TunnelServer_getServerInfo_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Params{s}, err
}

type TunnelServer_getServerInfo_Results struct{ capnp.Struct }

// TunnelServer_getServerInfo_Results_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Results.
const TunnelServer_getServerInfo_Results_TypeID = 0xe3e37d096a5b564e

func NewTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func NewRootTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func ReadRootTunnelServer_getServerInfo_Results(msg *capnp.Message) (TunnelServer_getServerInfo_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Results{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) String() string {
	str, _ := text.Marshal(0xe3e37d096a5b564e, s.Struct)
	return str
}

func (s TunnelServer_getServerInfo_Results) Result() (ServerInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ServerInfo{Struct: p.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_getServerInfo_Results) SetResult(v ServerInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ServerInfo struct, preferring placement in s's segment.
func (s TunnelServer_getServerInfo_Results) NewResult() (ServerInfo, error) {
	ss, err := NewServerInfo(s.Struct.Segment())
	if err != nil {
		return ServerInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_getServerInfo_Results_List is a list of TunnelServer_getServerInfo_Results.
type TunnelServer_getServerInfo_Results_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Results creates a new list of TunnelServer_getServerInfo_Results.
func NewTunnelServer_getServerInfo_Results_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_getServerInfo_Results_List{l}, err
}

func (s TunnelServer_getServerInfo_Results_List) At(i int) TunnelServer_getServerInfo_Results {
	return TunnelServer_getServerInfo_Results{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Results_List) Set(i int, v TunnelServer_getServerInfo_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Results_List) String() string {
	str, _ := text.MarshalList(0xe3e37d096a5b564e, s.List)
	return str
}

// TunnelServer_getServerInfo_Results_Promise is a wrapper for a TunnelServer_getServerInfo_Results promised by a client call.
type TunnelServer_getServerInfo_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Results_Promise) Struct() (TunnelServer_getServerInfo_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Results{s}, err
}

func (p TunnelServer_getServerInfo_Results_Promise) Result() ServerInfo_Promise {
	return ServerInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_unregisterTunnel_Params struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Params_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Params.
const TunnelServer_unregisterTunnel_Params_TypeID = 0x9b87b390babc2ccf

func NewTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Params(msg *capnp.Message) (TunnelServer_unregisterTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Params) String() string {
	str, _ := text.Marshal(0x9b87b390babc2ccf, s.Struct)
	return str
}

func (s TunnelServer_unregisterTunnel_Params) GracePeriodNanoSec() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s TunnelServer_unregisterTunnel_Params) SetGracePeriodNanoSec(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

// TunnelServer_unregisterTunnel_Params_List is a list of TunnelServer_unregisterTunnel_Params.
type TunnelServer_unregisterTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Params creates a new list of TunnelServer_unregisterTunnel_Params.
func NewTunnelServer_unregisterTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Params_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Params_List) At(i int) TunnelServer_unregisterTunnel_Params {
	return TunnelServer_unregisterTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Params_List) Set(i int, v TunnelServer_unregisterTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0x9b87b390babc2ccf, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Params_Promise is a wrapper for a TunnelServer_unregisterTunnel_Params promised by a client call.
type TunnelServer_unregisterTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Params_Promise) Struct() (TunnelServer_unregisterTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Params{s}, err
}

type TunnelServer_unregisterTunnel_Results struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Results_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Results.
const TunnelServer_unregisterTunnel_Results_TypeID = 0xa29a916d4ebdd894

func NewTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Results(msg *capnp.Message) (TunnelServer_unregisterTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Results) String() string {
	str, _ := text.Marshal(0xa29a916d4ebdd894, s.Struct)
	return str
}

// TunnelServer_unregisterTunnel_Results_List is a list of TunnelServer_unregisterTunnel_Results.
type TunnelServer_unregisterTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Results creates a new list of TunnelServer_unregisterTunnel_Results.
func NewTunnelServer_unregisterTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Results_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Results_List) At(i int) TunnelServer_unregisterTunnel_Results {
	return TunnelServer_unregisterTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Results_List) Set(i int, v TunnelServer_unregisterTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xa29a916d4ebdd894, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Results_Promise is a wrapper for a TunnelServer_unregisterTunnel_Results promised by a client call.
type TunnelServer_unregisterTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Results_Promise) Struct() (TunnelServer_unregisterTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Results{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Params struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID = 0xa766b24d4fe5da35

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params) String() string {
	str, _ := text.Marshal(0xa766b24d4fe5da35, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Params {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) String() string {
	str, _ := text.MarshalList(0xa766b24d4fe5da35, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Params promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Results struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID = 0xfeac5c8f4899ef7c

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results) String() string {
	str, _ := text.Marshal(0xfeac5c8f4899ef7c, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Results {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) String() string {
	str, _ := text.MarshalList(0xfeac5c8f4899ef7c, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Results promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s}, err
}

type TunnelServer_authenticate_Params struct{ capnp.Struct }

// TunnelServer_authenticate_Params_TypeID is the unique identifier for the type TunnelServer_authenticate_Params.
const TunnelServer_authenticate_Params_TypeID = 0x85c8cea1ab1894f3

func NewTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func NewRootTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func ReadRootTunnelServer_authenticate_Params(msg *capnp.Message) (TunnelServer_authenticate_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Params{root.Struct()}, err
}

func (s TunnelServer_authenticate_Params) String() string {
	str, _ := text.Marshal(0x85c8cea1ab1894f3, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_authenticate_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_authenticate_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_authenticate_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_authenticate_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_authenticate_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Params_List is a list of TunnelServer_authenticate_Params.
type TunnelServer_authenticate_Params_List struct{ capnp.List }

// NewTunnelServer_authenticate_Params creates a new list of TunnelServer_authenticate_Params.
func NewTunnelServer_authenticate_Params_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_authenticate_Params_List{l}, err
}

func (s TunnelServer_authenticate_Params_List) At(i int) TunnelServer_authenticate_Params {
	return TunnelServer_authenticate_Params{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Params_List) Set(i int, v TunnelServer_authenticate_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Params_List) String() string {
	str, _ := text.MarshalList(0x85c8cea1ab1894f3, s.List)
	return str
}

// TunnelServer_authenticate_Params_Promise is a wrapper for a TunnelServer_authenticate_Params promised by a client call.
type TunnelServer_authenticate_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Params_Promise) Struct() (TunnelServer_authenticate_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Params{s}, err
}

func (p TunnelServer_authenticate_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_authenticate_Results struct{ capnp.Struct }

// TunnelServer_authenticate_Results_TypeID is the unique identifier for the type TunnelServer_authenticate_Results.
const TunnelServer_authenticate_Results_TypeID = 0xfc5edf80e39c0796

func NewTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func NewRootTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func ReadRootTunnelServer_authenticate_Results(msg *capnp.Message) (TunnelServer_authenticate_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Results{root.Struct()}, err
}

func (s TunnelServer_authenticate_Results) String() string {
	str, _ := text.Marshal(0xfc5edf80e39c0796, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Results) Result() (AuthenticateResponse, error) {
	p, err := s.Struct.Ptr(0)
	return AuthenticateResponse{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Results) SetResult(v AuthenticateResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated AuthenticateResponse struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Results) NewResult() (AuthenticateResponse, error) {
	ss, err := NewAuthenticateResponse(s.Struct.Segment())
	if err != nil {
		return AuthenticateResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Results_List is a list of TunnelServer_authenticate_Results.
type TunnelServer_authenticate_Results_List struct{ capnp.List }

// NewTunnelServer_authenticate_Results creates a new list of TunnelServer_authenticate_Results.
func NewTunnelServer_authenticate_Results_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_authenticate_Results_List{l}, err
}

func (s TunnelServer_authenticate_Results_List) At(i int) TunnelServer_authenticate_Results {
	return TunnelServer_authenticate_Results{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Results_List) Set(i int, v TunnelServer_authenticate_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Results_List) String() string {
	str, _ := text.MarshalList(0xfc5edf80e39c0796, s.List)
	return str
}

// TunnelServer_authenticate_Results_Promise is a wrapper for a TunnelServer_authenticate_Results promised by a client call.
type TunnelServer_authenticate_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Results_Promise) Struct() (TunnelServer_authenticate_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Results{s}, err
}

func (p TunnelServer_authenticate_Results_Promise) Result() AuthenticateResponse_Promise {
	return AuthenticateResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_reconnectTunnel_Params struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Params_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Params.
const TunnelServer_reconnectTunnel_Params_TypeID = 0xa353a3556df74984

func NewTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Params(msg *capnp.Message) (TunnelServer_reconnectTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) String() string {
	str, _ := text.Marshal(0xa353a3556df74984, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Params) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasJwt() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetJwt(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_reconnectTunnel_Params) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasEventDigest() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetEventDigest(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s TunnelServer_reconnectTunnel_Params) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasConnDigest() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetConnDigest(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s TunnelServer_reconnectTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelServer_reconnectTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelServer_reconnectTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelServer_reconnectTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(4)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(4, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(4, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Params_List is a list of TunnelServer_reconnectTunnel_Params.
type TunnelServer_reconnectTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Params creates a new list of TunnelServer_reconnectTunnel_Params.
func NewTunnelServer_reconnectTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5}, sz)
	return TunnelServer_reconnectTunnel_Params_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Params_List) At(i int) TunnelServer_reconnectTunnel_Params {
	return TunnelServer_reconnectTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Params_List) Set(i int, v TunnelServer_reconnectTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xa353a3556df74984, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Params_Promise is a wrapper for a TunnelServer_reconnectTunnel_Params promised by a client call.
type TunnelServer_reconnectTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Params_Promise) Struct() (TunnelServer_reconnectTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Params{s}, err
}

func (p TunnelServer_reconnectTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(4)}
}

type TunnelServer_reconnectTunnel_Results struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Results_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Results.
const TunnelServer_reconnectTunnel_Results_TypeID = 0xd4d18de97bb12de3

func NewTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Results(msg *capnp.Message) (TunnelServer_reconnectTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) String() string {
	str, _ := text.Marshal(0xd4d18de97bb12de3, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Results_List is a list of TunnelServer_reconnectTunnel_Results.
type TunnelServer_reconnectTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Results creates a new list of TunnelServer_reconnectTunnel_Results.
func NewTunnelServer_reconnectTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_reconnectTunnel_Results_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Results_List) At(i int) TunnelServer_reconnectTunnel_Results {
	return TunnelServer_reconnectTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Results_List) Set(i int, v TunnelServer_reconnectTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xd4d18de97bb12de3, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Results_Promise is a wrapper for a TunnelServer_reconnectTunnel_Results promised by a client call.
type TunnelServer_reconnectTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Results_Promise) Struct() (TunnelServer_reconnectTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Results{s}, err
}

func (p TunnelServer_reconnectTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type RegisterUdpSessionResponse struct{ capnp.Struct }

// RegisterUdpSessionResponse_TypeID is the unique identifier for the type RegisterUdpSessionResponse.
const RegisterUdpSessionResponse_TypeID = 0xab6d5210c1f26687

func NewRegisterUdpSessionResponse(s *capnp.Segment) (RegisterUdpSessionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegisterUdpSessionResponse{st}, err
}

func NewRootRegisterUdpSessionResponse(s *capnp.Segment) (RegisterUdpSessionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegisterUdpSessionResponse{st}, err
}

func ReadRootRegisterUdpSessionResponse(msg *capnp.Message) (RegisterUdpSessionResponse, error) {
	root, err := msg.RootPtr()
	return RegisterUdpSessionResponse{root.Struct()}, err
}

func (s RegisterUdpSessionResponse) String() string {
	str, _ := text.Marshal(0xab6d5210c1f26687, s.Struct)
	return str
}

func (s RegisterUdpSessionResponse) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s RegisterUdpSessionResponse) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegisterUdpSessionResponse) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s RegisterUdpSessionResponse) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

// RegisterUdpSessionResponse_List is a list of RegisterUdpSessionResponse.
type RegisterUdpSessionResponse_List struct{ capnp.List }

// NewRegisterUdpSessionResponse creates a new list of RegisterUdpSessionResponse.
func NewRegisterUdpSessionResponse_List(s *capnp.Segment, sz int32) (RegisterUdpSessionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RegisterUdpSessionResponse_List{l}, err
}

func (s RegisterUdpSessionResponse_List) At(i int) RegisterUdpSessionResponse {
	return RegisterUdpSessionResponse{s.List.Struct(i)}
}

func (s RegisterUdpSessionResponse_List) Set(i int, v RegisterUdpSessionResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegisterUdpSessionResponse_List) String() string {
	str, _ := text.MarshalList(0xab6d5210c1f26687, s.List)
	return str
}

// RegisterUdpSessionResponse_Promise is a wrapper for a RegisterUdpSessionResponse promised by a client call.
type RegisterUdpSessionResponse_Promise struct{ *capnp.Pipeline }

func (p RegisterUdpSessionResponse_Promise) Struct() (RegisterUdpSessionResponse, error) {
	s, err := p.Pipeline.Struct()
	return RegisterUdpSessionResponse{s}, err
}

type SessionManager struct{ Client capnp.Client }

// SessionManager_TypeID is the unique identifier for the type SessionManager.
const SessionManager_TypeID = 0x839445a59fb01686

func (c SessionManager) RegisterUdpSession(ctx context.Context, params func(SessionManager_registerUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_registerUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 16, PointerCount: 2}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_registerUdpSession_Params{Struct: s}) }
	}
	return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c SessionManager) UnregisterUdpSession(ctx context.Context, params func(SessionManager_unregisterUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_unregisterUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 2}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_unregisterUdpSession_Params{Struct: s}) }
	}
	return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type SessionManager_Server interface {
	RegisterUdpSession(SessionManager_registerUdpSession) error

	UnregisterUdpSession(SessionManager_unregisterUdpSession) error
}

func SessionManager_ServerToClient(s SessionManager_Server) SessionManager {
	c, _ := s.(server.Closer)
	return SessionManager{Client: server.New(SessionManager_Methods(nil, s), c)}
}

func SessionManager_Methods(methods []server.Method, s SessionManager_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 2)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_registerUdpSession{c, opts, SessionManager_registerUdpSession_Params{Struct: p}, SessionManager_registerUdpSession_Results{Struct: r}}
			return s.RegisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_unregisterUdpSession{c, opts, SessionManager_unregisterUdpSession_Params{Struct: p}, SessionManager_unregisterUdpSession_Results{Struct: r}}
			return s.UnregisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// SessionManager_registerUdpSession holds the arguments for a server call to SessionManager.registerUdpSession.
type SessionManager_registerUdpSession struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  SessionManager_registerUdpSession_Params
	Results SessionManager_registerUdpSession_Results
}

// SessionManager_unregisterUdpSession holds the arguments for a server call to SessionManager.unregisterUdpSession.
type SessionManager_unregisterUdpSession struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  SessionManager_unregisterUdpSession_Params
	Results SessionManager_unregisterUdpSession_Results
}

type SessionManager_registerUdpSession_Params struct{ capnp.Struct }

// SessionManager_registerUdpSession_Params_TypeID is the unique identifier for the type SessionManager_registerUdpSession_Params.
const SessionManager_registerUdpSession_Params_TypeID = 0x904e297b87fbecea

func NewSessionManager_registerUdpSession_Params(s *capnp.Segment) (SessionManager_registerUdpSession_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return SessionManager_registerUdpSession_Params{st}, err
}

func NewRootSessionManager_registerUdpSession_Params(s *capnp.Segment) (SessionManager_registerUdpSession_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return SessionManager_registerUdpSession_Params{st}, err
}

func ReadRootSessionManager_registerUdpSession_Params(msg *capnp.Message) (SessionManager_registerUdpSession_Params, error) {
	root, err := msg.RootPtr()
	return SessionManager_registerUdpSession_Params{root.Struct()}, err
}

func (s SessionManager_registerUdpSession_Params) String() string {
	str, _ := text.Marshal(0x904e297b87fbecea, s.Struct)
	return str
}

func (s SessionManager_registerUdpSession_Params) SessionId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s SessionManager_registerUdpSession_Params) HasSessionId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Params) SetSessionId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s SessionManager_registerUdpSession_Params) DstIp() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s SessionManager_registerUdpSession_Params) HasDstIp() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Params) SetDstIp(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s SessionManager_registerUdpSession_Params) DstPort() uint16 {
	return s.Struct.Uint16(0)
}

func (s SessionManager_registerUdpSession_Params) SetDstPort(v uint16) {
	s.Struct.SetUint16(0, v)
}

func (s SessionManager_registerUdpSession_Params) CloseAfterIdleHint() int64 {
	return int64(s.Struct.Uint64(8))
}

func (s SessionManager_registerUdpSession_Params) SetCloseAfterIdleHint(v int64) {
	s.Struct.SetUint64(8, uint64(v))
}

// SessionManager_registerUdpSession_Params_List is a list of SessionManager_registerUdpSession_Params.
type SessionManager_registerUdpSession_Params_List struct{ capnp.List }

// NewSessionManager_registerUdpSession_Params creates a new list of SessionManager_registerUdpSession_Params.
func NewSessionManager_registerUdpSession_Params_List(s *capnp.Segment, sz int32) (SessionManager_registerUdpSession_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2}, sz)
	return SessionManager_registerUdpSession_Params_List{l}, err
}

func (s SessionManager_registerUdpSession_Params_List) At(i int) SessionManager_registerUdpSession_Params {
	return SessionManager_registerUdpSession_Params{s.List.Struct(i)}
}

func (s SessionManager_registerUdpSession_Params_List) Set(i int, v SessionManager_registerUdpSession_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_registerUdpSession_Params_List) String() string {
	str, _ := text.MarshalList(0x904e297b87fbecea, s.List)
	return str
}

// SessionManager_registerUdpSession_Params_Promise is a wrapper for a SessionManager_registerUdpSession_Params promised by a client call.
type SessionManager_registerUdpSession_Params_Promise struct{ *capnp.Pipeline }

func (p SessionManager_registerUdpSession_Params_Promise) Struct() (SessionManager_registerUdpSession_Params, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_registerUdpSession_Params{s}, err
}

type SessionManager_registerUdpSession_Results struct{ capnp.Struct }

// SessionManager_registerUdpSession_Results_TypeID is the unique identifier for the type SessionManager_registerUdpSession_Results.
const SessionManager_registerUdpSession_Results_TypeID = 0x8635c6b4f45bf5cd

func NewSessionManager_registerUdpSession_Results(s *capnp.Segment) (SessionManager_registerUdpSession_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_registerUdpSession_Results{st}, err
}

func NewRootSessionManager_registerUdpSession_Results(s *capnp.Segment) (SessionManager_registerUdpSession_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_registerUdpSession_Results{st}, err
}

func ReadRootSessionManager_registerUdpSession_Results(msg *capnp.Message) (SessionManager_registerUdpSession_Results, error) {
	root, err := msg.RootPtr()
	return SessionManager_registerUdpSession_Results{root.Struct()}, err
}

func (s SessionManager_registerUdpSession_Results) String() string {
	str, _ := text.Marshal(0x8635c6b4f45bf5cd, s.Struct)
	return str
}

func (s SessionManager_registerUdpSession_Results) Result() (RegisterUdpSessionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return RegisterUdpSessionResponse{Struct: p.Struct()}, err
}

func (s SessionManager_registerUdpSession_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Results) SetResult(v RegisterUdpSessionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated RegisterUdpSessionResponse struct, preferring placement in s's segment.
func (s SessionManager_registerUdpSession_Results) NewResult() (RegisterUdpSessionResponse, error) {
	ss, err := NewRegisterUdpSessionResponse(s.Struct.Segment())
	if err != nil {
		return RegisterUdpSessionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// SessionManager_registerUdpSession_Results_List is a list of SessionManager_registerUdpSession_Results.
type SessionManager_registerUdpSession_Results_List struct{ capnp.List }

// NewSessionManager_registerUdpSession_Results creates a new list of SessionManager_registerUdpSession_Results.
func NewSessionManager_registerUdpSession_Results_List(s *capnp.Segment, sz int32) (SessionManager_registerUdpSession_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return SessionManager_registerUdpSession_Results_List{l}, err
}

func (s SessionManager_registerUdpSession_Results_List) At(i int) SessionManager_registerUdpSession_Results {
	return SessionManager_registerUdpSession_Results{s.List.Struct(i)}
}

func (s SessionManager_registerUdpSession_Results_List) Set(i int, v SessionManager_registerUdpSession_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_registerUdpSession_Results_List) String() string {
	str, _ := text.MarshalList(0x8635c6b4f45bf5cd, s.List)
	return str
}

// SessionManager_registerUdpSession_Results_Promise is a wrapper for a SessionManager_registerUdpSession_Results promised by a client call.
type SessionManager_registerUdpSession_Results_Promise struct{ *capnp.Pipeline }

func (p SessionManager_registerUdpSession_Results_Promise) Struct() (SessionManager_registerUdpSession_Results, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_registerUdpSession_Results{s}, err
}

func (p SessionManager_registerUdpSession_Results_Promise) Result() RegisterUdpSessionResponse_Promise {
	return RegisterUdpSessionResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type SessionManager_unregisterUdpSession_Params struct{ capnp.Struct }

// SessionManager_unregisterUdpSession_Params_TypeID is the unique identifier for the type SessionManager_unregisterUdpSession_Params.
const SessionManager_unregisterUdpSession_Params_TypeID = 0x96b74375ce9b0ef6

func NewSessionManager_unregisterUdpSession_Params(s *capnp.Segment) (SessionManager_unregisterUdpSession_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return SessionManager_unregisterUdpSession_Params{st}, err
}

func NewRootSessionManager_unregisterUdpSession_Params(s *capnp.Segment) (SessionManager_unregisterUdpSession_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return SessionManager_unregisterUdpSession_Params{st}, err
}

func ReadRootSessionManager_unregisterUdpSession_Params(msg *capnp.Message) (SessionManager_unregisterUdpSession_Params, error) {
	root, err := msg.RootPtr()
	return SessionManager_unregisterUdpSession_Params{root.Struct()}, err
}

func (s SessionManager_unregisterUdpSession_Params) String() string {
	str, _ := text.Marshal(0x96b74375ce9b0ef6, s.Struct)
	return str
}

func (s SessionManager_unregisterUdpSession_Params) SessionId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s SessionManager_unregisterUdpSession_Params) HasSessionId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_unregisterUdpSession_Params) SetSessionId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s SessionManager_unregisterUdpSession_Params) Message() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s SessionManager_unregisterUdpSession_Params) HasMessage() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s SessionManager_unregisterUdpSession_Params) MessageBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s SessionManager_unregisterUdpSession_Params) SetMessage(v string) error {
	return s.Struct.SetText(1, v)
}

// SessionManager_unregisterUdpSession_Params_List is a list of SessionManager_unregisterUdpSession_Params.
type SessionManager_unregisterUdpSession_Params_List struct{ capnp.List }

// NewSessionManager_unregisterUdpSession_Params creates a new list of SessionManager_unregisterUdpSession_Params.
func NewSessionManager_unregisterUdpSession_Params_List(s *capnp.Segment, sz int32) (SessionManager_unregisterUdpSession_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return SessionManager_unregisterUdpSession_Params_List{l}, err
}

func (s SessionManager_unregisterUdpSession_Params_List) At(i int) SessionManager_unregisterUdpSession_Params {
	return SessionManager_unregisterUdpSession_Params{s.List.Struct(i)}
}

func (s SessionManager_unregisterUdpSession_Params_List) Set(i int, v SessionManager_unregisterUdpSession_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_unregisterUdpSession_Params_List) String() string {
	str, _ := text.MarshalList(0x96b74375ce9b0ef6, s.List)
	return str
}

// SessionManager_unregisterUdpSession_Params_Promise is a wrapper for a SessionManager_unregisterUdpSession_Params promised by a client call.
type SessionManager_unregisterUdpSession_Params_Promise struct{ *capnp.Pipeline }

func (p SessionManager_unregisterUdpSession_Params_Promise) Struct() (SessionManager_unregisterUdpSession_Params, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_unregisterUdpSession_Params{s}, err
}

type SessionManager_unregisterUdpSession_Results struct{ capnp.Struct }

// SessionManager_unregisterUdpSession_Results_TypeID is the unique identifier for the type SessionManager_unregisterUdpSession_Results.
const SessionManager_unregisterUdpSession_Results_TypeID = 0xf24ec4ab5891b676

func NewSessionManager_unregisterUdpSession_Results(s *capnp.Segment) (SessionManager_unregisterUdpSession_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return SessionManager_unregisterUdpSession_Results{st}, err
}

func NewRootSessionManager_unregisterUdpSession_Results(s *capnp.Segment) (SessionManager_unregisterUdpSession_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return SessionManager_unregisterUdpSession_Results{st}, err
}

func ReadRootSessionManager_unregisterUdpSession_Results(msg *capnp.Message) (SessionManager_unregisterUdpSession_Results, error) {
	root, err := msg.RootPtr()
	return SessionManager_unregisterUdpSession_Results{root.Struct()}, err
}

func (s SessionManager_unregisterUdpSession_Results) String() string {
	str, _ := text.Marshal(0xf24ec4ab5891b676, s.Struct)
	return str
}

// SessionManager_unregisterUdpSession_Results_List is a list of SessionManager_unregisterUdpSession_Results.
type SessionManager_unregisterUdpSession_Results_List struct{ capnp.List }

// NewSessionManager_unregisterUdpSession_Results creates a new list of SessionManager_unregisterUdpSession_Results.
func NewSessionManager_unregisterUdpSession_Results_List(s *capnp.Segment, sz int32) (SessionManager_unregisterUdpSession_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return SessionManager_unregisterUdpSession_Results_List{l}, err
}

func (s SessionManager_unregisterUdpSession_Results_List) At(i int) SessionManager_unregisterUdpSession_Results {
	return SessionManager_unregisterUdpSession_Results{s.List.Struct(i)}
}

func (s SessionManager_unregisterUdpSession_Results_List) Set(i int, v SessionManager_unregisterUdpSession_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_unregisterUdpSession_Results_List) String() string {
	str, _ := text.MarshalList(0xf24ec4ab5891b676, s.List)
	return str
}

// SessionManager_unregisterUdpSession_Results_Promise is a wrapper for a SessionManager_unregisterUdpSession_Results promised by a client call.
type SessionManager_unregisterUdpSession_Results_Promise struct{ *capnp.Pipeline }

func (p SessionManager_unregisterUdpSession_Results_Promise) Struct() (SessionManager_unregisterUdpSession_Results, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_unregisterUdpSession_Results{s}, err
}

type UpdateConfigurationResponse struct{ capnp.Struct }

// UpdateConfigurationResponse_TypeID is the unique identifier for the type UpdateConfigurationResponse.
const UpdateConfigurationResponse_TypeID = 0xdb58ff694ba05cf9

func NewUpdateConfigurationResponse(s *capnp.Segment) (UpdateConfigurationResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return UpdateConfigurationResponse{st}, err
}

func NewRootUpdateConfigurationResponse(s *capnp.Segment) (UpdateConfigurationResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return UpdateConfigurationResponse{st}, err
}

func ReadRootUpdateConfigurationResponse(msg *capnp.Message) (UpdateConfigurationResponse, error) {
	root, err := msg.RootPtr()
	return UpdateConfigurationResponse{root.Struct()}, err
}

func (s UpdateConfigurationResponse) String() string {
	str, _ := text.Marshal(0xdb58ff694ba05cf9, s.Struct)
	return str
}

func (s UpdateConfigurationResponse) LatestAppliedVersion() int32 {
	return int32(s.Struct.Uint32(0))
}

func (s UpdateConfigurationResponse) SetLatestAppliedVersion(v int32) {
	s.Struct.SetUint32(0, uint32(v))
}

func (s UpdateConfigurationResponse) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s UpdateConfigurationResponse) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s UpdateConfigurationResponse) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s UpdateConfigurationResponse) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

// UpdateConfigurationResponse_List is a list of UpdateConfigurationResponse.
type UpdateConfigurationResponse_List struct{ capnp.List }

// NewUpdateConfigurationResponse creates a new list of UpdateConfigurationResponse.
func NewUpdateConfigurationResponse_List(s *capnp.Segment, sz int32) (UpdateConfigurationResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return UpdateConfigurationResponse_List{l}, err
}

func (s UpdateConfigurationResponse_List) At(i int) UpdateConfigurationResponse {
	return UpdateConfigurationResponse{s.List.Struct(i)}
}

func (s UpdateConfigurationResponse_List) Set(i int, v UpdateConfigurationResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s UpdateConfigurationResponse_List) String() string {
	str, _ := text.MarshalList(0xdb58ff694ba05cf9, s.List)
	return str
}

// UpdateConfigurationResponse_Promise is a wrapper for a UpdateConfigurationResponse promised by a client call.
type UpdateConfigurationResponse_Promise struct{ *capnp.Pipeline }

func (p UpdateConfigurationResponse_Promise) Struct() (UpdateConfigurationResponse, error) {
	s, err := p.Pipeline.Struct()
	return UpdateConfigurationResponse{s}, err
}

type ConfigurationManager struct{ Client capnp.Client }

// ConfigurationManager_TypeID is the unique identifier for the type ConfigurationManager.
const ConfigurationManager_TypeID = 0xb48edfbdaa25db04

func (c ConfigurationManager) UpdateConfiguration(ctx context.Context, params func(ConfigurationManager_updateConfiguration_Params) error, opts ...capnp.CallOption) ConfigurationManager_updateConfiguration_Results_Promise {
	if c.Client == nil {
		return ConfigurationManager_updateConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xb48edfbdaa25db04,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:ConfigurationManager",
			MethodName:    "updateConfiguration",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 1}
		call.ParamsFunc = func(s capnp.Struct) error { return params(ConfigurationManager_updateConfiguration_Params{Struct: s}) }
	}
	return ConfigurationManager_updateConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type ConfigurationManager_Server interface {
	UpdateConfiguration(ConfigurationManager_updateConfiguration) error
}

func ConfigurationManager_ServerToClient(s ConfigurationManager_Server) ConfigurationManager {
	c, _ := s.(server.Closer)
	return ConfigurationManager{Client: server.New(ConfigurationManager_Methods(nil, s), c)}
}

func ConfigurationManager_Methods(methods []server.Method, s ConfigurationManager_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 1)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb48edfbdaa25db04,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:ConfigurationManager",
			MethodName:    "updateConfiguration",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := ConfigurationManager_updateConfiguration{c, opts, ConfigurationManager_updateConfiguration_Params{Struct: p}, ConfigurationManager_updateConfiguration_Results{Struct: r}}
			return s.UpdateConfiguration(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	return methods
}

// ConfigurationManager_updateConfiguration holds the arguments for a server call to ConfigurationManager.updateConfiguration.
type ConfigurationManager_updateConfiguration struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  ConfigurationManager_updateConfiguration_Params
	Results ConfigurationManager_updateConfiguration_Results
}

type ConfigurationManager_updateConfiguration_Params struct{ capnp.Struct }

// ConfigurationManager_updateConfiguration_Params_TypeID is the unique identifier for the type ConfigurationManager_updateConfiguration_Params.
const ConfigurationManager_updateConfiguration_Params_TypeID = 0xb177ca2526a3ca76

func NewConfigurationManager_updateConfiguration_Params(s *capnp.Segment) (ConfigurationManager_updateConfiguration_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConfigurationManager_updateConfiguration_Params{st}, err
}

func NewRootConfigurationManager_updateConfiguration_Params(s *capnp.Segment) (ConfigurationManager_updateConfiguration_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConfigurationManager_updateConfiguration_Params{st}, err
}

func ReadRootConfigurationManager_updateConfiguration_Params(msg *capnp.Message) (ConfigurationManager_updateConfiguration_Params, error) {
	root, err := msg.RootPtr()
	return ConfigurationManager_updateConfiguration_Params{root.Struct()}, err
}

func (s ConfigurationManager_updateConfiguration_Params) String() string {
	str, _ := text.Marshal(0xb177ca2526a3ca76, s.Struct)
	return str
}

func (s ConfigurationManager_updateConfiguration_Params) Version() int32 {
	return int32(s.Struct.Uint32(0))
}

func (s ConfigurationManager_updateConfiguration_Params) SetVersion(v int32) {
	s.Struct.SetUint32(0, uint32(v))
}

func (s ConfigurationManager_updateConfiguration_Params) Config() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ConfigurationManager_updateConfiguration_Params) HasConfig() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConfigurationManager_updateConfiguration_Params) SetConfig(v []byte) error {
	return s.Struct.SetData(0, v)
}

// ConfigurationManager_updateConfiguration_Params_List is a list of ConfigurationManager_updateConfiguration_Params.
type ConfigurationManager_updateConfiguration_Params_List struct{ capnp.List }

// NewConfigurationManager_updateConfiguration_Params creates a new list of ConfigurationManager_updateConfiguration_Params.
func NewConfigurationManager_updateConfiguration_Params_List(s *capnp.Segment, sz int32) (ConfigurationManager_updateConfiguration_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return ConfigurationManager_updateConfiguration_Params_List{l}, err
}

func (s ConfigurationManager_updateConfiguration_Params_List) At(i int) ConfigurationManager_updateConfiguration_Params {
	return ConfigurationManager_updateConfiguration_Params{s.List.Struct(i)}
}

func (s ConfigurationManager_updateConfiguration_Params_List) Set(i int, v ConfigurationManager_updateConfiguration_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConfigurationManager_updateConfiguration_Params_List) String() string {
	str, _ := text.MarshalList(0xb177ca2526a3ca76, s.List)
	return str
}

// ConfigurationManager_updateConfiguration_Params_Promise is a wrapper for a ConfigurationManager_updateConfiguration_Params promised by a client call.
type ConfigurationManager_updateConfiguration_Params_Promise struct{ *capnp.Pipeline }

func (p ConfigurationManager_updateConfiguration_Params_Promise) Struct() (ConfigurationManager_updateConfiguration_Params, error) {
	s, err := p.Pipeline.Struct()
	return ConfigurationManager_updateConfiguration_Params{s}, err
}

type ConfigurationManager_updateConfiguration_Results struct{ capnp.Struct }

// ConfigurationManager_updateConfiguration_Results_TypeID is the unique identifier for the type ConfigurationManager_updateConfiguration_Results.
const ConfigurationManager_updateConfiguration_Results_TypeID = 0x958096448eb3373e

func NewConfigurationManager_updateConfiguration_Results(s *capnp.Segment) (ConfigurationManager_updateConfiguration_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ConfigurationManager_updateConfiguration_Results{st}, err
}

func NewRootConfigurationManager_updateConfiguration_Results(s *capnp.Segment) (ConfigurationManager_updateConfiguration_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ConfigurationManager_updateConfiguration_Results{st}, err
}

func ReadRootConfigurationManager_updateConfiguration_Results(msg *capnp.Message) (ConfigurationManager_updateConfiguration_Results, error) {
	root, err := msg.RootPtr()
	return ConfigurationManager_updateConfiguration_Results{root.Struct()}, err
}

func (s ConfigurationManager_updateConfiguration_Results) String() string {
	str, _ := text.Marshal(0x958096448eb3373e, s.Struct)
	return str
}

func (s ConfigurationManager_updateConfiguration_Results) Result() (UpdateConfigurationResponse, error) {
	p, err := s.Struct.Ptr(0)
	return UpdateConfigurationResponse{Struct: p.Struct()}, err
}

func (s ConfigurationManager_updateConfiguration_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConfigurationManager_updateConfiguration_Results) SetResult(v UpdateConfigurationResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated UpdateConfigurationResponse struct, preferring placement in s's segment.
func (s ConfigurationManager_updateConfiguration_Results) NewResult() (UpdateConfigurationResponse, error) {
	ss, err := NewUpdateConfigurationResponse(s.Struct.Segment())
	if err != nil {
		return UpdateConfigurationResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// ConfigurationManager_updateConfiguration_Results_List is a list of ConfigurationManager_updateConfiguration_Results.
type ConfigurationManager_updateConfiguration_Results_List struct{ capnp.List }

// NewConfigurationManager_updateConfiguration_Results creates a new list of ConfigurationManager_updateConfiguration_Results.
func NewConfigurationManager_updateConfiguration_Results_List(s *capnp.Segment, sz int32) (ConfigurationManager_updateConfiguration_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return ConfigurationManager_updateConfiguration_Results_List{l}, err
}

func (s ConfigurationManager_updateConfiguration_Results_List) At(i int) ConfigurationManager_updateConfiguration_Results {
	return ConfigurationManager_updateConfiguration_Results{s.List.Struct(i)}
}

func (s ConfigurationManager_updateConfiguration_Results_List) Set(i int, v ConfigurationManager_updateConfiguration_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConfigurationManager_updateConfiguration_Results_List) String() string {
	str, _ := text.MarshalList(0x958096448eb3373e, s.List)
	return str
}

// ConfigurationManager_updateConfiguration_Results_Promise is a wrapper for a ConfigurationManager_updateConfiguration_Results promised by a client call.
type ConfigurationManager_updateConfiguration_Results_Promise struct{ *capnp.Pipeline }

func (p ConfigurationManager_updateConfiguration_Results_Promise) Struct() (ConfigurationManager_updateConfiguration_Results, error) {
	s, err := p.Pipeline.Struct()
	return ConfigurationManager_updateConfiguration_Results{s}, err
}

func (p ConfigurationManager_updateConfiguration_Results_Promise) Result() UpdateConfigurationResponse_Promise {
	return UpdateConfigurationResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type CloudflaredServer struct{ Client capnp.Client }

// CloudflaredServer_TypeID is the unique identifier for the type CloudflaredServer.
const CloudflaredServer_TypeID = 0xf548cef9dea2a4a1

func (c CloudflaredServer) RegisterUdpSession(ctx context.Context, params func(SessionManager_registerUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_registerUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 16, PointerCount: 2}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_registerUdpSession_Params{Struct: s}) }
	}
	return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c CloudflaredServer) UnregisterUdpSession(ctx context.Context, params func(SessionManager_unregisterUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_unregisterUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 2}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_unregisterUdpSession_Params{Struct: s}) }
	}
	return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c CloudflaredServer) UpdateConfiguration(ctx context.Context, params func(ConfigurationManager_updateConfiguration_Params) error, opts ...capnp.CallOption) ConfigurationManager_updateConfiguration_Results_Promise {
	if c.Client == nil {
		return ConfigurationManager_updateConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xb48edfbdaa25db04,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:ConfigurationManager",
			MethodName:    "updateConfiguration",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 1}
		call.ParamsFunc = func(s capnp.Struct) error { return params(ConfigurationManager_updateConfiguration_Params{Struct: s}) }
	}
	return ConfigurationManager_updateConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type CloudflaredServer_Server interface {
	RegisterUdpSession(SessionManager_registerUdpSession) error

	UnregisterUdpSession(SessionManager_unregisterUdpSession) error

	UpdateConfiguration(ConfigurationManager_updateConfiguration) error
}

func CloudflaredServer_ServerToClient(s CloudflaredServer_Server) CloudflaredServer {
	c, _ := s.(server.Closer)
	return CloudflaredServer{Client: server.New(CloudflaredServer_Methods(nil, s), c)}
}

func CloudflaredServer_Methods(methods []server.Method, s CloudflaredServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 3)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_registerUdpSession{c, opts, SessionManager_registerUdpSession_Params{Struct: p}, SessionManager_registerUdpSession_Results{Struct: r}}
			return s.RegisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_unregisterUdpSession{c, opts, SessionManager_unregisterUdpSession_Params{Struct: p}, SessionManager_unregisterUdpSession_Results{Struct: r}}
			return s.UnregisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb48edfbdaa25db04,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:ConfigurationManager",
			MethodName:    "updateConfiguration",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := ConfigurationManager_updateConfiguration{c, opts, ConfigurationManager_updateConfiguration_Params{Struct: p}, ConfigurationManager_updateConfiguration_Results{Struct: r}}
			return s.UpdateConfiguration(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	return methods
}

const schema_db8274f9144abc7e = "x\xda\xccZ{t\x14\xe7u\xbfwfW#\x81V" +
	"\xab\xf1\xac\xd1\x03T\xb5:P\x179\xd8\x06Jk\xab" +
	"9\xd1\xc3\x12\xb1d\x03\x9a]\x94\xe3cC\x8eG\xbb" +
	"\x9f\xa4Qwg\x96\x99Y\x19\x11\x130\x01c\xfb\xb8" +
	"\x8eq\xc0\xb1Ih0.\xed\x01\xdb\xad\x89\xdd\xa6\xee" +
	"1\xa7\xa6\xcd\xabq\xc0&\x87\xf4\x90@\x9a&\x84>" +
	"8\xb8\xae14\x876\xf1\xf4\xdc\x99\x9d\x87v\x17\x09" +
	"\x8c\xff\xc8\x7f\xab;\xdf\xe3\xde\xdf\xf7\xbb\x8f\xef~\xba" +
	"\xed\xe6\x9a.nq\xf4\xed:\x00\xf9\xa5h\x95\xcd\xda" +
	"\x7f\xb0a\xef\x82\x7f\xdc\x02r3\xa2\xfd\xf97\x06\x12" +
	"\x97\xad-\xa7 \xca\x0b\x00KW\x08\x1bPR\x04\x01" +
	"@Z+\xfc;\xa0\xfd\xc8\x9cW\xbe\xb6\xbfo\xe7\x17" +
	"@l\xe6\x83\xc1\x80K\xbb\xab\x07P\x1a\xaa\xa6\x91r" +
	"\xf5v\xe9\x10\xfd\xb2\xef\x16o\xbd?\xf1\xce1\x1a\x1d" +
	"^:BK?W\xdd\x8e\xd2\x01g\xc2\xfejZ\xfa" +
	"\x93\xb9\xb7\xf7\xfd\xc1\xae\xb7\xb6\x82\xd8\xccMYzG" +
	"\xcd\x06\x94\xf6\xd7\xd0\xc8\xe7kV\x01\xda\x1f\xecl|" +
	"\xf1\xf9c\xdf\xdd\x06\xe2M\x08EM_\xaf\xf91\x02" +
	"JGk\xfe\x0a\xd0>z\xe9\xfe\x8b\xaf}{\xd9#" +
	" .\xa4\x01H\x03r\xb3\xda8@i\xdb\xacN@" +
	"\xfb\xdc\xf9\xff\xdb\xfe\xb9\x85+\x9f\x02y!r\x00Q" +
	"\x8eF\xec\x9f\xd5L#\x0e\xcf\"m:\x97\x1f}\xbd" +
	"y\xe93;KTw\x06\xee\x99\xdd\x8e\xd2\xcb\xb3I" +
	"\xa1\x03\xb3\x1f\x04\xb4?\xf5\x87\xaf>\xd9\xfb\xcc\xe6]" +
	" \xde\xea\xef\x17\xab\xbd\x8fV[XK\xfb\xfdO\xdd" +
	"W\x8e\x15\xee\xfc\xc63E\x85\x9cU\xfak\xdbi\x80" +
	"RK+\xb4M,x\xe0\x1f\xbe\xf5\xea\x97A^\x84" +
	"h\x9f\x1e\xbe\xf9\x87\xfc\x9e\x83\xa7`\x08\x05\xd2o\xe9" +
	"\x91\xda}d\xddqg\xec\xdb\x9fx\xe3\xef\x9ezu" +
	"\xfbW@\xbe\x09\x11\xc0AsY\xec\x7fi@\x7f\x8c" +
	"v\xdby\xf2\xf0\xca\xdc\x8e\xdd\xfb\\|\x9c\xef\xebb" +
	"\x1c\x07\x11{k\xff/sC/\xa4^(\"\x17\xa5" +
	"O,v\x01\x01\x97N\xc6Z\x11\xd0^\xf6\xe3\xb3\xab" +
	"V|}\xe4/Bsw\xd5m\xa0\xb9\xdbG.\x1c" +
	"\xa9O\xe6^,A\xc41vG\xddA\x94\x0e\xd49" +
	"\x87YG*\xbc\xfc[w\xd7\xac?\xbb\xfc\x15\x10\x17" +
	"y\xcb|\xab.I\xcbL|\xef\x85\xdf]\xf0\xbd\x07" +
	"\x0f\x81|+\xfa`\x1d\xa1o(\xfd\xa4\x8e\xec\x8b\x9c" +
	"Zp\xf0\xf0O\x9f|\xad\x8ccw\xc47\xa0\xb4\"" +
	"N\xbb\xf4\xc7?-M\xd2/;\xb2\x96\xffPy\xf6" +
	"\xef_+\xe5\xaf\x83\xb1\x12\x1fF\xa9\x10w\x10\x88;" +
	"\xf6=~d\xf7\xcd\xd5_\xfb\xe0\xaf+\x9d\xebs\xf5" +
	"\xc3(\xbd\\\xef\x9ck=irc?\x9e~sq" +
	"\xe4\x1ba\xa2\xd5\x88\xe7\x08\xe9\x16\x91\x88\xd6\xf2nO" +
	"L{o\xcb\x9b%\xab9\x03\x0f\x8b\x03(\x1d\x17i" +
	"\xb5\xa3\xce\xe0\x81\xfb\xbf\xf4t\xf4\xec\x97\xbeC\x9a\x86" +
	"\x18\x1e%\x1fX\xaa\xde`\xa0\xb4\xf1\x06\xfa9yC" +
	"\x03\x0fh7\xbf\xf2G\x7f\xd9\x93\xf9\xd1[\x154\x95" +
	".\xdfxA\x8a\xce\xa1_8\x87\x14=\xb3\xe8\xd0\xe7" +
	"\xfe\xf3O\x8e\x9f(*\xea`\xbav\x8eC\x89us" +
	"\xe8<.\xaf\xd9{\xb7j\xdf{\xaa\x14%\xf7\xf4\xe6" +
	"|\x1d\xa5\x03\xcer\xfb\x9d\xe5|\xfeU\x1a]\xd30" +
	"\x8eRK\x03\x8dnj\xa0\xb5\xb9\xb3J\xd3\xe6\x7f\xfe" +
	"\xd4\xe9\x10eZ\x1a~\x8e\x10\xb1W~\xe6\xfe\xf1\x9a" +
	"\x8dg\xce\x84\xd5\x12\x1b\x1c\xfc\x168S\xff\xeb\xcf\xcf" +
	"}\xf1|.\xf3o\x0e\xed=\x84\xfb\x1a:\x88\x0ck" +
	"\x1b\xc8\x0f\x1bZc}m'\x07\xcf\xb9Dr\x97\xb8" +
	"\xa3\xb1\x87\x06\xc8\x8d\xb4\xc4\xb2\x07\xba\xd9\x9a\xdb\xef=" +
	"W\xc6\x96u\x8d\x1d(=\xdcH\x1366nGi" +
	"WS\x03\x80=\xf17;\xee}\xf1\x9b+/\xb8\x9e" +
	"\xe8(\xbb\xadi\x09\x11\xf3\xc9\xcf\xf7\xae\xba\xa3\xed\xc8" +
	"\x85\xb0\xb2\x1b\x9b\xc87\xa4\x1dM\xb4\xd3\xc8\xed\xe7?" +
	"\xbd\xe0\xc9o_\xa8\xe4\x00\x87\x9a\xdaQ:\xd2D\xa0" +
	"\x1c\xa6\xc1\xef-\xff\xd3\x13\xcd\xf1\xe6\x8b%\x00V\xd1" +
	"\xd8\x9f5\x8d\xa3t\x89\xc6.}\xbf\xe9;D\xca\xe7" +
	"\xffl\xdf\xbf\\>v\xd7\xa52\x1b\xce\xce\x1dF\xe9" +
	"\xf2\\Z\xf6\xd2\\A\xba4\xf7&\x00\xfb\x91S\x9f" +
	"]\xff\x83/|p\xa9\x94G\x8e\"\xef\xceM\xa2\x84" +
	"\xf3h\xc6\xaf\xe7\x12\xeb\xbe\xbc\xfa?6\x9d\xdf5\xe7" +
	"\x97ek\xef\x997\x8e\xd2!g\xe4\xcb\xf3\xb6K\xb1" +
	"\x16\xf2\xa6w\x84\x17\x16\xf7nz\xebr\xc8o/\xcd" +
	"\x1b x\x9e\x11\xbezf\xf3O?\xfb\xab0<\xef" +
	"\xcf\xfb9\xc1\x13m!x\x1ez\xef\xb9\xbb\xbe\xb8\xe6" +
	"\xa5\x0fC4X\xd0\xb2\x85\xa6Z\x05McY#\x1f" +
	"I\xdf\xea\xfdL\xdf\x92V\xf2Z\xbe\xa3\xbb`\x8d1" +
	"\xcdR\xd3\x8a\xc5\x92\xac\xd3\xcc\xeb\x9a\xc9\x06\x11\xe5z" +
	">\x02\x10A\x00Q\x19\x07\x90\x1f\xe0Q\xcer(\"" +
	"&\x88(\xa2J\xc21\x1ee\x8bC\x91\xe3\x12\x14%" +
	"\xc5um\x00r\x96Gy=\x87\xc8'\x90\x07\x10\x0b" +
	"O\x03\xc8\xeby\x94\xb7rh\xe7\x99\x91S4\xa6A" +
	"\xdc\xea3\x0c\xac\x05\x0ek\x01m\x83Y\xc6\xa42\x9c" +
	"\x858\x0b\x89\x85\xf1\x07-\x8c\x01\x871@{L/" +
	"\x18\xe6\x90f\xa1\x9aM\xb2\x11\x83\x998\x86U\xc0a" +
	"\x15\xe0t\xe6\xa5\x98i\xaa\xba\xb6B\xd1\x94Qf\x00" +
	"\x90e\xd5|\x14\xc0\xcf@\xe8\xe5*q\xf1n\xe0\xc4" +
	"E\x02\x06\xd9\x02=\xb2\x8a\xbfs\x108\xb1E\xb0\x0d" +
	"6\xaa\x9a\x163p(\x93w\xd6\xe6u\xad\x0b\xed\x82" +
	"\xe6~@f\xb8\x1f\xe2\xb4k\x17\x0eb\xa0\x1d_\xae" +
	"\xdd\x9dY\x95iV\xbc_\x1b\xd1K \x1f\xa8\x04\xf9" +
	"@\x11\xf2\xad!\xc8\x1f\xee\x01\x90\x1f\xe2Q~\x94C" +
	"\x91/b\xbe\xad\x1d@\xde\xcc\xa3\xfc\x04\x87v\xda\xd9" +
	"\xa4?\x03\x00>\x9a#L\xb1\x0a\x063IV\x078" +
	"\xc8\xa3\x03z\x1d\xe0\xa6\x09f\x90\xee\xde!\xc4\x15#" +
	"=\xe6\x1f\xd44H\xf7\xadWMK\xd5FW;\xf2" +
	"\xceA=\xab\xa6'\xc9\xaaZG\xcf\x96\x0e\x00D\xf1" +
	"\xc6\xfb\x00\x90\x13\xc5\x1e\x80NuT\xd3\x0dfgT" +
	"3\xadk\x1a\x03>mm\x1aV\xb2\x8a\x96f\xfeF" +
	"U\xe5\x1b\xb9\x1b\xa4\x981\xc1\x8c[\x94\x10}\xe7\x0f" +
	"*\x86\xc2\xe7L\xb9\xd6\xc7\xb1\xef>\x00\xb9\x97Gy" +
	"0\x84\xe3\x0a\xc2\xf1\x1e\x1e\xe5{C8\x0e\x11\x8e\x83" +
	"<\xcak8\xb4uC\x1dU\xb5;\x19\xf0F\x98\x81" +
	"\xa6\xa5)9F\x98\x15\xf1\xd8\xa4\xe7-U\xd7L\xac" +
	"\x0fr\x0b \xd6\x87\x90\x12f\xe2\xe4-\x1e\xa5<F" +
	"\xe9\xda\xfc$3\x0bB\xd62\xe5\x88oI\xac\x03@" +
	"\xae\xe6QNp\xd8i0\xb3\x90\xb5\xb0>(\x09>" +
	"\x8e]=\xf8B4LV\xa2\xe1\x12\x009\xc3\xa3\x9c" +
	"\xe7\x10\x8b\xe8\xe5zB\xd1\x80G\x97\x85\xebv\x03\xc8" +
	"\x16\x8f\xf2f\x0em\xd3\xdd\xa4\x1f0\xe3!\xda\x9a1" +
	"\xad\xfe\xbc\xf7\xd7\xa6\x8ci\x0d\xea\x86\x85\x02p(\x00" +
	"\xf1V7Y\xf7\x08\xf9T\x7f&\xcb\xeeRy\xcd\xc2" +
	"(p\x18\x85i\x9d\xca\xe5G\x9c\x02\x9b\xeb\xed\x9e5" +
	"\x0b\x89\x0c\xbf\xc7\xa3\xfc\xfb!k\x16S\x1c\xbb\x8dG" +
	"\xf9\x93\x1c\xdaJ:\xad\x174k5\xf0\xcah\x09\xe7" +
	"S\x0c\xe2i\x83\x05t\xf0\xb6\xad\xae\xe0\xd6\xba6\xa2" +
	"\x8e\x16\x0c\xc5\x0a\x01^\xc8g\x14\x8bM\xf9\xe4\x9cs" +
	"\x96\xbf\x8as\xf6\xab\x87k>g/2\x95\x9ct\xdc" +
	"Prf\x18\x9bd%l\xe8T?\xc1\xa3|{\xe5" +
	"\x03\xdc\x94c\xa6\xa9\x8c\xb2\xb2\xf0\x10\xad\x88\x89\xc6\xd2" +
	"du\x92\xb9I\xe6\x16\x83\x99B!k\x91\x16\xb5\xb6" +
	"\xed\xaaA\xdc\x9a\xcf\xa3|\x1b\x871\xfc\xd0v\xf5X" +
	"\xf4tpF\xad\xcc0t\x03\xeb\x83$\\\x84$]" +
	"\xdc\x00u\xad\x97Y\x8a\x9aErK\xbf\xda,\x01n" +
	"\xa6\xb8\x12\xc0\xe6\x8a\xe7w\x92w\xe4\xa6\x9c\x14\xd1\xbb" +
	"\x9eGy\x1e\x87\xf6\xa8\xa1\xa4\xd9 3P\xd53+" +
	"\x15MO\xf1,]F\xd6\xbak\xdd\xd4\xe1\x87e\x82" +
	"?k\xfa\xf9\x06+\x82P\x9c>\xd8\xea\xea\x9c\xf0u" +
	"\xde\xd8\x16$c\xff\x98\x1f\x1e\x0e\xb2\x85\x1f\x0f\x1f#" +
	"gy\x94Gyg(\xaf\xec\xa0\xc8\xf9\x14\x8f\xf2W" +
	"9\x14#\x91\x04F\x00\xc4\xe7\x88%;y\x94\xf7r" +
	"SS6\x9b`\x9a\xd5\xab\x8e\x82\xc0\xcc@J*\xf6" +
	"\xaa\xa3\x0cx\xf3zck\xf5\x0cx\xe8\xc3\xa6\x9ee" +
	"\x16\xebe\xe9\xacB.7\xc1\xdc\xefE2z\x87:" +
	"\x1do\x93e\xdeC\xfc\x8d{UR\x88\x0em\x81\xe3" +
	"\x0a,T\xdcL\xa3\xad\xbb\xb8\x1b\x0c\xca8\x10xL" +
	"\x91\x07h~,A\xc7\xb1\x19\xa78\x7fO\xe0u\x1e" +
	")\x16u\x04\x01\xc1\xaf\x09\"\xc0a\x04\xb03\xed," +
	"X\x16\x0a#3i\xd5\xe9\xaa\xe5\x02GE\x98w\x17" +
	"E\xef\x02/\x8a\xfb\x80\x13c\x82\xedi\x8e\xde|\xa1" +
	"\xac\xa0\x8aL\x17eV\xe5-U\xd05\x93\xf6\x0a\xf1" +
	"\xbf\xa3\x12\xff\x8d\x80\xff^B{lK\x98\xfe\xc5\x84" +
	"\xb6cw\xc0t1\xc2\xb9\xf4\xdf\xb3\x0f@\xde\xcb\xa3" +
	"\xfc\x12\x87\x9dn\xad\x85\xf5A\xe3\xa5HY\xb7\xa2\xb8" +
	"G\x87\xd6\xb4\x92\x0d\x92\x9em\xb0|VI\xb3>," +
	"VO\x80\x08\x1c\xa2\xe3'\xb9\xbc\xc1L\x13U]\x93" +
	"\x0bJV\xe5\xadI\xbf\xe2\xd5\x0a\xb9A\x83M\xa8\xa8" +
	"\x17\xccn\xcbb9!o\x99WS\x0f\x07\x00Q\x90" +
	"\x14\xd4\xacY\x92#\xdb\x03*\xf8\x00-\x1a\x0f\xf2@" +
	"\xbcPP\xfd\x04`g\xf5\xb4s\xb2\x10_\xa9\xe4\xca" +
	"\xf3@\xd5\x8c\x01kJ\xb8\xf3\xd2\xd2oR\xfd6\xfd" +
	"\x95\x89Lw\xee\x14!\x95)\x0et\xf1(\xdf\x13R" +
	"\xb9\x7fI\xc8\x0eO\xe5\x15\xc3\x81\x1d\xc2\x1f\xb3IO" +
	"\xabV\x96\xa3\xf4\xe5\x81Y4\xa6\x1b\x84\xbb\x831\xd3" +
	"\xe9\x17\x8e*\xab\xf2\xad\x8e\x85\xa4\xe3\xed\x9e\x8e\xd2$" +
	"\x0e\x00\xa4\xd6#\x8f\xa9\xad\x18\xa8)=\x8c=\x00\xa9" +
	"\x87H\xfe(\x06\x9aJ\xdb\xb0\x19 \xb5\x99\xe4O\xa0" +
	"\x7f\xb5\x93\x1e\xc3\x83\x00\xa9'H\xfc,\x0d\x8f\xf0\x8e" +
	"KH\xbb\x9c\xe5w\x92|/\xc9\xa3\x91\x04F\x01\xa4" +
	"=\xd8\x0e\x90z\x96\xe4\xaf\x91\xbc\x8aK`\x15\x80t" +
	"\x08\xc7\x01R\xaf\x90\xfc\x0d\x92\x0b\xd1\x04\xddn\xa5\xd7" +
	"\xd1\x00H\xfd-\xc9\xbfI\xf2\xea\xc6\x04V\x03HG" +
	"\x1c\xf9\x9b$\xff>\xc9k\x9a\x12X\x03 \xfd\x13n" +
	"\x01H}\x97\xe4'H>\x0b\x138\x0b@:\x8e\xbb" +
	"\x01R'H\xfe\xaf$\x9f]\x95\xc0\xd9\x00\xd2O\x1c" +
	"}N\x92\xfc\x17$\xaf\x8d$\xb0\x16@\xfa\x19\xee\x03" +
	"H\xfd\x82\xe4\xffM\xf2\x98\x90\xc0\x18\x80\xf4\xaec\xd7" +
	"y\x92Ws%7+\x8fQ%\xd7'^7\xfd#" +
	"cE\x1fG\x97\xee\x83z\x9c\xaeH\x18\x0f\x1a\xaf\x80" +
	"\x18\x07\xb4\xf3\xba\x9e]9\x95\xa9qK\x195\xbd\xab" +
	"Z}\xd0\x9a\x02$\xa1_\xfc@\\\xd7\xfa3~ " +
	"(\x8d:\x9e&\xaa\xd9]\xb0\xf4B\x1eZ)\xc8f" +
	"\xfc\x98c\x14\xb4\xe5\x86\x9e[\x8d\xcc\xc8\xa9\x9a\x92\x9d" +
	"!\x1a\xd5\x00\x875P\x0c\x09\xde\xda\xd3\x87\xa6+_" +
	"<}Fs\xa5\x8cn\xcdw\xacVF\xaf&N-" +
	"\x09rV\\\x0b\x05\xa4\xd6\x09%[\xf8(\xe1ij" +
	"=\x95\xect\xeb\xb1\x99\xcau\xaf\xf7T\x12J*T" +
	"\x17C\xe5\xf99\xc9\xccV\xbf\x09\x132\xf8`\x10\x83" +
	"={\x97\xb5\x85\xee.Y\xc5b\xa6\xd5\x9d\xc7|V" +
	"e\x99\xcf0#\x1eN\xd9\x15+\x92\xc8Le\xfa\xd4" +
	"2\x07C]r2\x9c+\x1a|\xd5x\x8e2\xcb\xfd" +
	"\xd5\xaf\x8d\xe8T\x87\x08\xe1\xe2\xeb\xdaf'\x99\x19\xbf" +
	"\x9a\xb3\x08\x9a\x863_\x9d*\x94c\x15\x8a1\xef&" +
	"\x10\xba&\x13\x19\xd7\xf0(\x8f\x85\xc8\xc8\x06*\\\x93" +
	"\x93A\x7fL\xe4\xb9b\x83\x8c2W\x9eG\xf9!\x0e" +
	"\xe3J\xc1\x1a\xc3\xfa\xe0\xf1c\x8a\xd2S{8\xc4\xcd" +
	"~-\xc3\x00\xd7{\xee\x15\xcag~W~\xe6\x9a\xf9" +
	"\xea\xcc\xf6\xee\"3\x02\xee\xf7\xaeKv\xbe\xe2U\xbd" +
	"\xd3\xdd\x94x\xd6\xe8T\x85^\xd7\x1f\xbd\x8e\xb0xh" +
	"\x03p\xe2\x01\x01\x83^7z\xadmq\x8f\x01\x9c\xb8" +
	"K@\xce\x7f\x97A\xef\xfdE|\xecq\xe0\xc4m\x02" +
	"\xf2\xfe\xb3\x0az]\xd2\xc5\x93\xb3\x108q\xa3\x80\x11" +
	"\xff=\x0b\xbd\x1e\xab\xb8n\x1c8Q\x150\xea\xbf\xd8" +
	"\xa0\xd7\xe2\x17\xd7n\x01N\x1c\x0az\x81\xd0\xe9\xda\xd1" +
	"\x85\xb6\xc7QhuX:\xb53\xe8\x8e\x02\xe8B\xdb" +
	"\xbb\x99\xf0W\xba\x9a8\xa3\xbc\xe6\x16\xc4\xd3\x8a\xc5\xba" +
	"\xa8Zt\x03\x12\x16#\x12t\xa1\x1c\xc1P\x8b\x19\xe0" +
	"z[\x03I\xd6\xea\x9c\xf3G\xad\xe1\xbc\xf9\x1f1F" +
	"\xf2\x95\xb4\xa6}\xfc&ih]*Kky\x94\x1b" +
	"\xb9\x19+\xd1\xc8\x95\xac\xf0\xc8\x1f\xa7\xc9\xb4\xfeo\xfb" +
	"\xeb\x1f\xa7\xf0\xfa}\x1e\xe5\x93!\xb7\xfe!\x09\xdf\xe1" +
	"Q>\x1d\xaa\xe4~D\xbe~\x92G\xf9b\xd0\xf7~" +
	"\xffq\x00\xf9\"\x8f\xc9Pe$\xfe\x9a\x06\xfe\x8a\xea" +
	"\x07\xa7.B\xb7.\x8a\xe2\xd3\x00\xa9j\xaa+\x12N" +
	"]\x14q\xeb\"\x11\x87\x01R\xf5$\x9f\x17\xae\x8b\x9a" +
	"\xf0>\x80T#\xc9\xe7\xe3\xd4\xdb\xa6P0\x82\xca1" +
	"\xab\x8f\xde\xa3j\x15\x93\xad\xd7\x88Gk\xb9\xa2f\x0b" +
	"\x06\x83 \xd7\x17\x83Mo\xa8\xfcp;\xf4n3." +
	"E$\xcc\xa0\xe97\xea\xae\xe1\x9e?]\xe6\xc9\xea\x85" +
	"\xccHV1X&\xc5\x0c\xc1\x0d\x08\x83|T\xae\xc6" +
	"\xd0\xab7@\xf0:\x19\"\xfb\xb4\x99\xac\xcf0t4" +
	"J\xaa\xf4%A\x95\xee\x17\xe9t\xd9\xb8\x8bGy5" +
	"\x1dm\x97{\xb4\xf2pp\xafhM+\x05\x93\x95a" +
	"\x02<3\xfc^\x8f9\xa6\x17\xb2\x99$\x03\xc12&" +
	"K \x9d\xb1ZO\xb1\xb8\x17\x09\xddG\x0a\xefy\x0e" +
	"\xbdW\xb8\xd0#\x85\xf7R\x84\xdeSo\xf9#\x85\x87" +
	"A\xd9#\x85\xfb\xc1\xe1\xfc\xd4;\xf5u4)\xdc\xb4" +
	"\x18:\x94k\xea\xdd_u\xcb\xdb\xffw\x89\x92\xc8Q" +
	"s\xbd\xcd /\xc1\xfd\x7f\x00\x00\x00\xff\xff\xf1\xc3d" +
	"\xc6"

func init() {
	schemas.Register(schema_db8274f9144abc7e,
		0x82c325a07ad22a65,
		0x839445a59fb01686,
		0x83ced0145b2f114b,
		0x84cb9536a2cf6d3c,
		0x85c8cea1ab1894f3,
		0x8635c6b4f45bf5cd,
		0x904e297b87fbecea,
		0x9496331ab9cd463f,
		0x958096448eb3373e,
		0x96b74375ce9b0ef6,
		0x97b3c5c260257622,
		0x9b87b390babc2ccf,
		0xa29a916d4ebdd894,
		0xa353a3556df74984,
		0xa766b24d4fe5da35,
		0xab6d5210c1f26687,
		0xb046e578094b1ead,
		0xb177ca2526a3ca76,
		0xb48edfbdaa25db04,
		0xb4bf9861fe035d04,
		0xb5f39f082b9ac18a,
		0xb70431c0dc014915,
		0xc082ef6e0d42ed1d,
		0xc793e50592935b4a,
		0xcbd96442ae3bb01a,
		0xd4d18de97bb12de3,
		0xdb58ff694ba05cf9,
		0xdbaa9d03d52b62dc,
		0xdc3ed6801961e502,
		0xe3e37d096a5b564e,
		0xe6646dec8feaa6ee,
		0xea50d822450d1f17,
		0xea58385c65416035,
		0xf24ec4ab5891b676,
		0xf2c122394f447e8e,
		0xf2c68e2547ec3866,
		0xf41a0f001ad49e46,
		0xf548cef9dea2a4a1,
		0xf5f383d2785edb86,
		0xf71695ec7fe85497,
		0xf9cb7f4431a307d0,
		0xfc5edf80e39c0796,
		0xfeac5c8f4899ef7c)
}
