import { GlobLists, IncludedExcludedArgs } from '../types';
export interface GlobberPicoOptions {
    dot?: boolean;
    regex?: boolean;
    nocase?: boolean;
    ignore?: string | string[];
    cwd?: string;
}
export declare type GlobFunc = (filePath: string, test?: boolean) => boolean;
export declare function makeGlobMatcher(globs: string | string[], picoOptions?: GlobberPicoOptions): GlobFunc;
export declare function updateGlobLists(globLists: GlobLists, updateFunc: (globs: string[], key: keyof GlobLists) => string[]): GlobLists;
export declare function mergeGlobLists(globListsA: GlobLists, globListsB: GlobLists): GlobLists;
export declare function toPosixPath(pathStr: string): string;
export declare function toAbsoluteGlobLists(globLists: GlobLists, absoluteNodeModulesPath: string): GlobLists;
export declare function wrapGlobs(globs: string[], prefix?: string): string;
export declare function optimizeGlobs(globs: string[]): string[];
export declare function optimizeGlobLists(globLists: GlobLists): GlobLists;
export declare function formatGlob(glob: string): string;
export declare function processGlobs(globs: string[], excludedOnlyGlobs?: string[]): GlobLists;
export declare function parseGlobsFile(filePath: string): Promise<GlobLists>;
export declare function parseDefaultGlobsFile(): Promise<GlobLists>;
export interface ParseGlobsOptions {
    argGlobs: IncludedExcludedArgs;
    useDefaultGlobs: boolean;
    userGlobsFilePath: string;
}
export declare function getGlobLists({ argGlobs, useDefaultGlobs, userGlobsFilePath, }: ParseGlobsOptions): Promise<GlobLists>;
