"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyzeCommand = void 0;
const analyze_1 = require("../../analyze");
const glob_1 = require("../../utils/glob");
async function analyzeCommand({ argGlobs, nodeModulesPath, userGlobsFilePath, useDefaultGlobs, }) {
    const globLists = await (0, glob_1.getGlobLists)({
        argGlobs,
        useDefaultGlobs,
        userGlobsFilePath,
    });
    const analyzeResults = await (0, analyze_1.analyzeIncluded)(nodeModulesPath, globLists);
    console.log(JSON.stringify(analyzeResults, null, 2));
}
exports.analyzeCommand = analyzeCommand;
