/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.accessories;

import com.charliemouse.cambozola.Accessory;
import com.charliemouse.cambozola.ViewerAttributeInterface;
import com.charliemouse.cambozola.shared.AppID;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;

public class InfoAccessory
extends Accessory {
    protected InfoFrame m_infoFrame = null;
    protected Point m_frameLoc = new Point(20, 20);

    public String getName() {
        return "Information";
    }

    public String getDescription() {
        return "Display information on the stream";
    }

    public String getIconLocation() {
        return "info.gif";
    }

    public void actionPerformed(Point p, ViewerAttributeInterface vfi) {
        if (this.m_infoFrame == null) {
            this.m_infoFrame = new InfoFrame(vfi);
        } else {
            this.m_infoFrame.close();
        }
    }

    class InfoFrame
    extends Frame
    implements ActionListener,
    Runnable {
        TextField fpsValue;
        ViewerAttributeInterface m_vfi;

        public InfoFrame(ViewerAttributeInterface vfi) {
            this.m_vfi = vfi;
            AppID props = AppID.getAppID();
            this.setTitle(props.getAppName());
            this.setLayout(new BorderLayout());
            Panel appPanel = new Panel();
            appPanel.setLayout(new GridLayout(3, 1));
            appPanel.add(new Label(props.getAppName() + " " + props.getFullVersion(), 1));
            appPanel.add(new Label(props.getCopyright(), 1));
            appPanel.add(new Label(props.getLocURL(), 1));
            this.add((Component)appPanel, "North");
            Panel mp = new Panel();
            mp.setLayout(new GridLayout(2, 1));
            Panel url_panel = new Panel();
            url_panel.setLayout(new FlowLayout());
            url_panel.add(new Label("URL:"));
            TextField urlField = new TextField("" + vfi.getStream().getStreamURL(), 30);
            urlField.setEditable(false);
            url_panel.add(urlField);
            mp.add(url_panel);
            Panel fps_panel = new Panel();
            fps_panel.add(new Label("FPS:"));
            fps_panel.setLayout(new FlowLayout());
            this.fpsValue = new TextField(30);
            this.fpsValue.setEditable(false);
            this.updateFPS();
            fps_panel.add(this.fpsValue);
            mp.add(fps_panel);
            this.add((Component)mp, "Center");
            Button closeButt = new Button("Close");
            closeButt.addActionListener(this);
            Panel buttPanel = new Panel();
            buttPanel.setLayout(new FlowLayout());
            buttPanel.add(closeButt);
            this.add((Component)buttPanel, "South");
            this.pack();
            this.validate();
            if (InfoAccessory.this.m_frameLoc != null) {
                this.setLocation(InfoAccessory.this.m_frameLoc);
            }
            this.setVisible(true);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    InfoFrame.this.close();
                }
            });
            new Thread(this).start();
        }

        public void run() {
            do {
                this.updateFPS();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.isVisible());
        }

        private void updateFPS() {
            String fps = null;
            fps = this.m_vfi.getStream() == null ? "No image stream yet." : NumberFormat.getInstance().format(this.m_vfi.getStream().getFPS());
            this.fpsValue.setText(fps);
        }

        public void actionPerformed(ActionEvent ae) {
            this.close();
        }

        public void close() {
            InfoAccessory.this.m_frameLoc = this.getLocation();
            this.setVisible(false);
            InfoAccessory.this.m_infoFrame = null;
            this.dispose();
        }
    }
}

