"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const client_oauth2_1 = __importDefault(require("client-oauth2"));
const https_1 = require("https");
const credential_1 = require("./credential");
function createRequestFunction(rejectUnauthorized) {
    return (method, url, body, headers) => {
        return new Promise((resolve, reject) => {
            const parsedURL = new URL(url);
            const options = {
                method: method,
                host: parsedURL.hostname,
                port: parseInt(parsedURL.port),
                path: parsedURL.pathname + parsedURL.search,
                headers: headers,
            };
            options.rejectUnauthorized = rejectUnauthorized;
            const req = (0, https_1.request)(options);
            req.on("response", (response) => {
                response.setEncoding("utf8");
                const body = [];
                response.on("data", (data) => {
                    body.push(data);
                });
                response.on("end", () => {
                    resolve({
                        status: response.statusCode,
                        body: body.toString(),
                    });
                });
            });
            req.on("error", (er) => {
                reject(er);
            });
            req.write(body);
            req.end();
        });
    };
}
class OAuthManager {
    constructor() {
        this.tokenStore = new Map();
    }
    handleClient(securityScheme, credentials) {
        const clientFlow = new client_oauth2_1.default({
            clientId: credentials.clientId,
            clientSecret: credentials.clientSecret,
            accessTokenUri: securityScheme.token,
            scopes: securityScheme.scopes,
            body: {},
        }, createRequestFunction(false));
        const token = clientFlow.credentials.getToken();
        return new credential_1.OAuthCredential(token, clientFlow.credentials.getToken.bind(clientFlow.credentials));
    }
    handleResourceOwnerCredential(securityScheme, credentials) {
        const clientFlow = new client_oauth2_1.default({
            clientId: credentials.clientId,
            clientSecret: credentials.clientSecret,
            accessTokenUri: securityScheme.token,
            scopes: securityScheme.scopes,
        }, createRequestFunction(false));
        const token = clientFlow.owner.getToken(credentials.username, credentials.password);
        return new credential_1.OAuthCredential(token);
    }
}
exports.default = OAuthManager;
//# sourceMappingURL=oauth-manager.js.map