"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const http_client_1 = __importDefault(require("./http-client"));
class HttpsClientFactory {
    constructor(config = null) {
        this.scheme = "https";
        this.config = null;
        this.config = config;
    }
    getClient() {
        if (this.config && this.config.proxy && this.config.proxy.href && this.config.proxy.href.startsWith("http:")) {
            console.warn(`"[binding-http]",HttpsClientFactory creating client for 'http' due to insecure proxy configuration`);
            return new http_client_1.default(this.config);
        }
        else {
            console.debug("[binding-http]", `HttpsClientFactory creating client for '${this.scheme}'`);
            return new http_client_1.default(this.config, true);
        }
    }
    init() {
        return true;
    }
    destroy() {
        return true;
    }
}
exports.default = HttpsClientFactory;
//# sourceMappingURL=https-client-factory.js.map