"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Subscription_1 = require("rxjs/Subscription");
const core_1 = require("@node-wot/core");
const coap_1 = require("./coap");
const node_coap_client_1 = require("node-coap-client");
const stream_1 = require("stream");
class CoapsClient {
    toString() {
        return "[CoapsClient]";
    }
    readResource(form) {
        return new Promise((resolve, reject) => {
            this.generateRequest(form, "GET")
                .then((res) => {
                console.debug("[binding-coap]", `CoapsClient received ${res.code} from ${form.href}`);
                let contentType;
                if (!contentType)
                    contentType = form.contentType;
                resolve({ type: contentType, body: stream_1.Readable.from(res.payload) });
            })
                .catch((err) => {
                reject(err);
            });
        });
    }
    writeResource(form, content) {
        return new Promise((resolve, reject) => {
            this.generateRequest(form, "PUT", content)
                .then((res) => {
                console.debug("[binding-coap]", `CoapsClient received ${res.code} from ${form.href}`);
                resolve();
            })
                .catch((err) => {
                reject(err);
            });
        });
    }
    invokeResource(form, content) {
        return new Promise((resolve, reject) => {
            this.generateRequest(form, "POST", content)
                .then((res) => {
                console.debug("[binding-coap]", `CoapsClient received ${res.code} from ${form.href}`);
                let contentType;
                if (!contentType)
                    contentType = form.contentType;
                resolve({ type: contentType, body: stream_1.Readable.from(res.payload) });
            })
                .catch((err) => {
                reject(err);
            });
        });
    }
    unlinkResource(form) {
        return new Promise((resolve, reject) => {
            this.generateRequest(form, "DELETE")
                .then((res) => {
                console.debug("[binding-coap]", `CoapsClient received ${res.code} from ${form.href}`);
                console.debug("[binding-coap]", `CoapsClient received headers: ${JSON.stringify(res.format)}`);
                resolve();
            })
                .catch((err) => {
                reject(err);
            });
        });
    }
    subscribeResource(form, next, error, complete) {
        return new Promise((resolve, reject) => {
            const requestUri = new URL(form.href.replace(/$coaps/, "https"));
            node_coap_client_1.CoapClient.setSecurityParams(requestUri.hostname, this.authorization);
            const callback = (resp) => {
                if (resp.payload != null) {
                    next({ type: form === null || form === void 0 ? void 0 : form.contentType, body: stream_1.Readable.from(resp.payload) });
                }
            };
            node_coap_client_1.CoapClient
                .observe(form.href, "get", callback)
                .then(() => {
                resolve(new Subscription_1.Subscription(() => {
                    node_coap_client_1.CoapClient.stopObserving(form.href);
                    complete();
                }));
            })
                .catch((err) => {
                error(err);
                reject(err);
            });
        });
    }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    setSecurity(metadata, credentials) {
        if (metadata === undefined || !Array.isArray(metadata) || metadata.length === 0) {
            console.warn("[binding-coap]", `CoapsClient received empty security metadata`);
            return false;
        }
        const security = metadata[0];
        if (security.scheme === "psk") {
            this.authorization = { psk: {} };
            this.authorization.psk[credentials.identity] = credentials.psk;
        }
        else if (security.scheme === "apikey") {
            console.error("[binding-coap]", `CoapsClient cannot use Apikey: Not implemented`);
            return false;
        }
        else {
            console.error("[binding-coap]", `CoapsClient cannot set security scheme '${security.scheme}'`);
            console.dir(metadata);
            return false;
        }
        console.debug("[binding-coap]", `CoapsClient using security scheme '${security.scheme}'`);
        return true;
    }
    determineRequestMethod(formMethod, defaultMethod) {
        if ((0, coap_1.isSupportedCoapMethod)(formMethod)) {
            return formMethod;
        }
        else if ((0, coap_1.isValidCoapMethod)(formMethod)) {
            console.debug(`[binding-coap] Method ${formMethod} is not supported yet.`, `Using default method ${defaultMethod} instead.`);
        }
        else {
            console.debug(`[binding-coap] Unknown method ${formMethod} found.`, `Using default method ${defaultMethod} instead.`);
        }
        return defaultMethod;
    }
    generateRequest(form, defaultMethod, content) {
        return __awaiter(this, void 0, void 0, function* () {
            const requestUri = new URL(form.href.replace(/$coaps/, "https"));
            node_coap_client_1.CoapClient.setSecurityParams(requestUri.hostname, this.authorization);
            let method;
            if (form["cov:methodName"] != null) {
                const formMethodName = form["cov:methodName"];
                console.debug(`[binding-coap] CoapClient got Form "methodName" ${formMethodName}`);
                method = this.determineRequestMethod(formMethodName, defaultMethod);
            }
            else {
                method = defaultMethod;
            }
            console.debug("[binding-coap]", `CoapsClient sending ${method} to ${form.href}`);
            const body = content.body ? yield core_1.ProtocolHelpers.readStreamFully(content.body) : undefined;
            const req = node_coap_client_1.CoapClient.request(form.href, method.toLowerCase(), body);
            return req;
        });
    }
}
exports.default = CoapsClient;
//# sourceMappingURL=coaps-client.js.map