"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const url = __importStar(require("url"));
const net = __importStar(require("net"));
const Subscription_1 = require("rxjs/Subscription");
const core_1 = require("@node-wot/core");
const coap_1 = require("./coap");
const stream_1 = require("stream");
const coap_2 = require("coap");
class CoapClient {
    constructor(server) {
        this.setSecurity = (metadata) => true;
        this.agent = new coap_2.Agent(server ? { socket: server.getSocket() } : undefined);
        this.agentOptions = server ? { socket: server.getSocket() } : {};
        (0, coap_2.registerFormat)(core_1.ContentSerdes.JSON_LD, 2100);
    }
    toString() {
        return "[CoapClient]";
    }
    readResource(form) {
        return __awaiter(this, void 0, void 0, function* () {
            const req = yield this.generateRequest(form, "GET");
            console.debug("[binding-coap]", `CoapClient sending ${req.statusCode} to ${form.href}`);
            return new Promise((resolve, reject) => {
                req.on("response", (res) => {
                    console.debug("[binding-coap]", `CoapClient received ${res.code} from ${form.href}`);
                    console.debug("[binding-coap]", `CoapClient received Content-Format: ${res.headers["Content-Format"]}`);
                    let contentType = res.headers["Content-Format"];
                    if (!contentType)
                        contentType = form.contentType;
                    resolve({ type: contentType, body: stream_1.Readable.from(res.payload) });
                });
                req.on("error", (err) => reject(err));
                req.end();
            });
        });
    }
    writeResource(form, content) {
        return new Promise((resolve, reject) => {
            core_1.ProtocolHelpers.readStreamFully(content.body)
                .then((buffer) => {
                const req = this.generateRequest(form, "PUT");
                console.debug("[binding-coap]", `CoapClient sending ${req.statusCode} to ${form.href}`);
                req.on("response", (res) => {
                    console.debug("[binding-coap]", `CoapClient received ${res.code} from ${form.href}`);
                    console.debug("[binding-coap]", `CoapClient received headers: ${JSON.stringify(res.headers)}`);
                    resolve();
                });
                req.on("error", (err) => reject(err));
                req.setOption("Content-Format", content.type);
                req.write(buffer);
                req.end();
            })
                .catch(reject);
        });
    }
    invokeResource(form, content) {
        return new Promise((resolve, reject) => {
            const req = this.generateRequest(form, "POST");
            console.debug("[binding-coap]", `CoapClient sending ${req.statusCode} to ${form.href}`);
            req.on("response", (res) => {
                console.debug("[binding-coap]", `CoapClient received ${res.code} from ${form.href}`);
                console.debug("[binding-coap]", `CoapClient received Content-Format: ${res.headers["Content-Format"]}`);
                console.debug("[binding-coap]", `CoapClient received headers: ${JSON.stringify(res.headers)}`);
                const contentType = res.headers["Content-Format"];
                resolve({ type: contentType !== null && contentType !== void 0 ? contentType : "", body: stream_1.Readable.from(res.payload) });
            });
            req.on("error", (err) => reject(err));
            (() => __awaiter(this, void 0, void 0, function* () {
                if (content && content.body) {
                    const buffer = yield core_1.ProtocolHelpers.readStreamFully(content.body);
                    req.setOption("Content-Format", content.type);
                    req.write(buffer);
                }
                req.end();
            }))();
        });
    }
    unlinkResource(form) {
        return new Promise((resolve, reject) => {
            const req = this.generateRequest(form, "GET", false);
            console.debug("[binding-coap]", `CoapClient sending ${req.statusCode} to ${form.href}`);
            req.on("response", (res) => {
                console.debug("[binding-coap]", `CoapClient received ${res.code} from ${form.href}`);
                console.debug("[binding-coap]", `CoapClient received headers: ${JSON.stringify(res.headers)}`);
                resolve();
            });
            req.on("error", (err) => reject(err));
            req.end();
        });
    }
    subscribeResource(form, next, error, complete) {
        return new Promise((resolve, reject) => {
            const req = this.generateRequest(form, "GET", true);
            console.debug("[binding-coap]", `CoapClient sending ${req.statusCode} to ${form.href}`);
            req.on("response", (res) => {
                console.debug("[binding-coap]", `CoapClient received ${res.code} from ${form.href}`);
                console.debug("[binding-coap]", `CoapClient received Content-Format: ${res.headers["Content-Format"]}`);
                let contentType = res.headers["Content-Format"];
                if (!contentType)
                    contentType = form.contentType;
                res.on("data", (data) => {
                    next({ type: `${contentType}`, body: stream_1.Readable.from(res.payload) });
                });
                resolve(new Subscription_1.Subscription(() => {
                    res.close();
                    if (complete)
                        complete();
                }));
            });
            req.on("error", (err) => {
                if (error) {
                    error(err);
                }
            });
            req.end();
        });
    }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            this.agent.close();
        });
    }
    uriToOptions(uri) {
        var _a;
        const requestUri = url.parse(uri);
        const agentOptions = this.agentOptions;
        agentOptions.type = net.isIPv6((_a = requestUri.hostname) !== null && _a !== void 0 ? _a : "") ? "udp6" : "udp4";
        this.agent = new coap_2.Agent(agentOptions);
        const options = {
            agent: this.agent,
            hostname: requestUri.hostname || "",
            port: requestUri.port ? parseInt(requestUri.port, 10) : 5683,
            pathname: requestUri.pathname || "",
            query: requestUri.query || "",
            observe: false,
            multicast: false,
            confirmable: true,
        };
        return options;
    }
    determineRequestMethod(formMethod, defaultMethod) {
        if ((0, coap_1.isSupportedCoapMethod)(formMethod)) {
            return formMethod;
        }
        else if ((0, coap_1.isValidCoapMethod)(formMethod)) {
            console.debug(`[binding-coap] Method ${formMethod} is not supported yet.`, `Using default method ${defaultMethod} instead.`);
        }
        else {
            console.debug(`[binding-coap] Unknown method ${formMethod} found.`, `Using default method ${defaultMethod} instead.`);
        }
        return defaultMethod;
    }
    generateRequest(form, defaultMethod, observable = false) {
        const options = this.uriToOptions(form.href);
        if (form["cov:methodName"] != null) {
            const formMethodName = form["cov:methodName"];
            console.debug(`[binding-coap] CoapClient got Form "methodName" ${formMethodName}`);
            options.method = this.determineRequestMethod(formMethodName, defaultMethod);
        }
        else {
            options.method = defaultMethod;
        }
        options.observe = observable;
        const req = this.agent.request(options);
        if (typeof form.contentType === "string") {
            console.debug("[binding-coap]", "CoapClient got Form 'contentType'", form.contentType);
            req.setOption("Accept", form.contentType);
        }
        if (Array.isArray(form["cov:options"])) {
            console.debug("[binding-coap]", "CoapClient got Form 'options'", form["cov:options"]);
            const options = form["cov:options"];
            for (const option of options) {
                req.setOption(option["cov:optionName"], option["cov:optionValue"]);
            }
        }
        else if (typeof form["cov:options"] === "object") {
            console.warn("[binding-coap]", "CoapClient got Form SINGLE-ENTRY 'options'", form["cov:options"]);
            const option = form["cov:options"];
            req.setHeader(option["cov:optionName"], option["cov:optionValue"]);
        }
        return req;
    }
}
exports.default = CoapClient;
//# sourceMappingURL=coap-client.js.map