# Station Simulation Example

Station comes with a simulation framework for testing and developing individual Station components. The framework consists of mock implementations of the required backend services as well as a simulation of radio hardware. This allows to run and control Station inside a complete, local, hardware-independent test harness in Python. Tests can also be composed of the individual building blocks, for instance using real hardware against mock backend components or simulated hardware against real backend components.

```
                                      pysys/tcutils.py
                             +---------------+--------------+
                     +-------|  CUPS mockup  |  LNS mockup  |
                     |       +-------+-------+-------+------+
                     |               |               |
                     |               |               |
                     |               +-------+-------+       WebSocket
    sim.py           |                       |
+--------------+     |             +---------+---------+
|     Test     |     |             |      Station      |
|   sequence   |-----|             + - - - - - - - - - +
+--------------+     |             |      LGW-sim      |
                     |             +---------+---------+
                     |                       |
                     |                       |           Unix domain socket
                     |                       |
                     |             +---------+---------+
                     +-------------|  LGW-sim Server   |
                                   +-------------------+
                                     pysys/simutils.py
```

This example shows how to make use of the simulation framework for building a simple uplink/downlink test case with simulated radio hardware. Every 10 seconds an uplink is generated by the `ExampleLgwSimServer`. The `ExampleMuxs` responds with a downlink in the first downlink slot.

## Prerequisites

The simulation example requires

* Python 3.5+
* Python packages according to `requirements.txt`
* Optional: tmux

A possible way to setup a compatible python environment is using `virtualenv` and `pip`:

```
virtualenv -p python3.6 pyenv
. pyenv/bin/activate
pip install -r requirements.txt
```

## Usage

The simulation example is controlled via a makefile with multiple targets:

* `make station`: Build the `testsim` station variant which provides a Unix domain socket adapter to the lgw API
* `make sim`: Run the simulation in a single process. Log output of all components is interleaved in one terminal
* `make tmux`: Run the simulation in multiple processes inside different panes of a tmux split window.
* `make clean`: Clean local directory of temporary files
