"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BulkRegistry = void 0;
const msRest = require("@azure/ms-rest-js");
const Mappers = require("../models/bulkRegistryMappers");
const Parameters = require("../models/parameters");
/** Class representing a BulkRegistry. */
class BulkRegistry {
    /**
     * Create a BulkRegistry.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client) {
        this.client = client;
    }
    updateRegistry(devices, options, callback) {
        return this.client.sendOperationRequest({
            devices,
            options
        }, updateRegistryOperationSpec, callback);
    }
}
exports.BulkRegistry = BulkRegistry;
// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const updateRegistryOperationSpec = {
    httpMethod: "POST",
    path: "devices",
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "devices",
        mapper: {
            required: true,
            serializedName: "devices",
            type: {
                name: "Sequence",
                element: {
                    type: {
                        name: "Composite",
                        className: "ExportImportDevice"
                    }
                }
            }
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.BulkRegistryOperationResult
        },
        400: {
            bodyMapper: Mappers.BulkRegistryOperationResult
        },
        default: {}
    },
    serializer
};
//# sourceMappingURL=bulkRegistry.js.map