/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import * as Mappers from "../models/devicesMappers";
import * as Parameters from "../models/parameters";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";

/** Class representing a Devices. */
export class Devices {
  private readonly client: IotHubGatewayServiceAPIsContext;

  /**
   * Create a Devices.
   * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
   */
  constructor(client: IotHubGatewayServiceAPIsContext) {
    this.client = client;
  }

  /**
   * Gets the identities of multiple devices from the IoT Hub identity registry. Not recommended. Use
   * the IoT Hub query API to retrieve device twin and device identity information. See
   * https://docs.microsoft.com/en-us/rest/api/iothub/service/queryiothub and
   * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-query-language for more
   * information.
   * @param [options] The optional parameters
   * @returns Promise<Models.DevicesGetDevicesResponse>
   */
  getDevices(options?: Models.DevicesGetDevicesOptionalParams): Promise<Models.DevicesGetDevicesResponse>;
  /**
   * @param callback The callback
   */
  getDevices(callback: msRest.ServiceCallback<Models.Device[]>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  getDevices(options: Models.DevicesGetDevicesOptionalParams, callback: msRest.ServiceCallback<Models.Device[]>): void;
  getDevices(options?: Models.DevicesGetDevicesOptionalParams | msRest.ServiceCallback<Models.Device[]>, callback?: msRest.ServiceCallback<Models.Device[]>): Promise<Models.DevicesGetDevicesResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      getDevicesOperationSpec,
      callback) as Promise<Models.DevicesGetDevicesResponse>;
  }

  /**
   * Gets a device from the identity registry of the IoT Hub.
   * @param id The unique identifier of the device.
   * @param [options] The optional parameters
   * @returns Promise<Models.DevicesGetIdentityResponse>
   */
  getIdentity(id: string, options?: msRest.RequestOptionsBase): Promise<Models.DevicesGetIdentityResponse>;
  /**
   * @param id The unique identifier of the device.
   * @param callback The callback
   */
  getIdentity(id: string, callback: msRest.ServiceCallback<Models.Device>): void;
  /**
   * @param id The unique identifier of the device.
   * @param options The optional parameters
   * @param callback The callback
   */
  getIdentity(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Device>): void;
  getIdentity(id: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.Device>, callback?: msRest.ServiceCallback<Models.Device>): Promise<Models.DevicesGetIdentityResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      getIdentityOperationSpec,
      callback) as Promise<Models.DevicesGetIdentityResponse>;
  }

  /**
   * Creates or updates the identity of a device in the identity registry of the IoT Hub.
   * @param id The unique identifier of the device.
   * @param device The contents of the device identity.
   * @param [options] The optional parameters
   * @returns Promise<Models.DevicesCreateOrUpdateIdentityResponse>
   */
  createOrUpdateIdentity(id: string, device: Models.Device, options?: Models.DevicesCreateOrUpdateIdentityOptionalParams): Promise<Models.DevicesCreateOrUpdateIdentityResponse>;
  /**
   * @param id The unique identifier of the device.
   * @param device The contents of the device identity.
   * @param callback The callback
   */
  createOrUpdateIdentity(id: string, device: Models.Device, callback: msRest.ServiceCallback<Models.Device>): void;
  /**
   * @param id The unique identifier of the device.
   * @param device The contents of the device identity.
   * @param options The optional parameters
   * @param callback The callback
   */
  createOrUpdateIdentity(id: string, device: Models.Device, options: Models.DevicesCreateOrUpdateIdentityOptionalParams, callback: msRest.ServiceCallback<Models.Device>): void;
  createOrUpdateIdentity(id: string, device: Models.Device, options?: Models.DevicesCreateOrUpdateIdentityOptionalParams | msRest.ServiceCallback<Models.Device>, callback?: msRest.ServiceCallback<Models.Device>): Promise<Models.DevicesCreateOrUpdateIdentityResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        device,
        options
      },
      createOrUpdateIdentityOperationSpec,
      callback) as Promise<Models.DevicesCreateOrUpdateIdentityResponse>;
  }

  /**
   * Deletes the identity of a device from the identity registry of the IoT Hub.
   * @param id The unique identifier of the device.
   * @param [options] The optional parameters
   * @returns Promise<msRest.RestResponse>
   */
  deleteIdentity(id: string, options?: Models.DevicesDeleteIdentityOptionalParams): Promise<msRest.RestResponse>;
  /**
   * @param id The unique identifier of the device.
   * @param callback The callback
   */
  deleteIdentity(id: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param id The unique identifier of the device.
   * @param options The optional parameters
   * @param callback The callback
   */
  deleteIdentity(id: string, options: Models.DevicesDeleteIdentityOptionalParams, callback: msRest.ServiceCallback<void>): void;
  deleteIdentity(id: string, options?: Models.DevicesDeleteIdentityOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<msRest.RestResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      deleteIdentityOperationSpec,
      callback);
  }

  /**
   * Gets the device twin. See https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-device-twins
   * for more information.
   * @param id The unique identifier of the device.
   * @param [options] The optional parameters
   * @returns Promise<Models.DevicesGetTwinResponse>
   */
  getTwin(id: string, options?: msRest.RequestOptionsBase): Promise<Models.DevicesGetTwinResponse>;
  /**
   * @param id The unique identifier of the device.
   * @param callback The callback
   */
  getTwin(id: string, callback: msRest.ServiceCallback<Models.Twin>): void;
  /**
   * @param id The unique identifier of the device.
   * @param options The optional parameters
   * @param callback The callback
   */
  getTwin(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Twin>): void;
  getTwin(id: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.Twin>, callback?: msRest.ServiceCallback<Models.Twin>): Promise<Models.DevicesGetTwinResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      getTwinOperationSpec,
      callback) as Promise<Models.DevicesGetTwinResponse>;
  }

  /**
   * Replaces the tags and desired properties of a device twin. See
   * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-device-twins for more information.
   * @param id The unique identifier of the device.
   * @param deviceTwinInfo The device twin info that will replace the existing info.
   * @param [options] The optional parameters
   * @returns Promise<Models.DevicesReplaceTwinResponse>
   */
  replaceTwin(id: string, deviceTwinInfo: Models.Twin, options?: Models.DevicesReplaceTwinOptionalParams): Promise<Models.DevicesReplaceTwinResponse>;
  /**
   * @param id The unique identifier of the device.
   * @param deviceTwinInfo The device twin info that will replace the existing info.
   * @param callback The callback
   */
  replaceTwin(id: string, deviceTwinInfo: Models.Twin, callback: msRest.ServiceCallback<Models.Twin>): void;
  /**
   * @param id The unique identifier of the device.
   * @param deviceTwinInfo The device twin info that will replace the existing info.
   * @param options The optional parameters
   * @param callback The callback
   */
  replaceTwin(id: string, deviceTwinInfo: Models.Twin, options: Models.DevicesReplaceTwinOptionalParams, callback: msRest.ServiceCallback<Models.Twin>): void;
  replaceTwin(id: string, deviceTwinInfo: Models.Twin, options?: Models.DevicesReplaceTwinOptionalParams | msRest.ServiceCallback<Models.Twin>, callback?: msRest.ServiceCallback<Models.Twin>): Promise<Models.DevicesReplaceTwinResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        deviceTwinInfo,
        options
      },
      replaceTwinOperationSpec,
      callback) as Promise<Models.DevicesReplaceTwinResponse>;
  }

  /**
   * Updates the tags and desired properties of a device twin. See
   * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-device-twins for more information.
   * @param id The unique identifier of the device.
   * @param deviceTwinInfo The device twin info containing the tags and desired properties to be
   * updated.
   * @param [options] The optional parameters
   * @returns Promise<Models.DevicesUpdateTwinResponse>
   */
  updateTwin(id: string, deviceTwinInfo: Models.Twin, options?: Models.DevicesUpdateTwinOptionalParams): Promise<Models.DevicesUpdateTwinResponse>;
  /**
   * @param id The unique identifier of the device.
   * @param deviceTwinInfo The device twin info containing the tags and desired properties to be
   * updated.
   * @param callback The callback
   */
  updateTwin(id: string, deviceTwinInfo: Models.Twin, callback: msRest.ServiceCallback<Models.Twin>): void;
  /**
   * @param id The unique identifier of the device.
   * @param deviceTwinInfo The device twin info containing the tags and desired properties to be
   * updated.
   * @param options The optional parameters
   * @param callback The callback
   */
  updateTwin(id: string, deviceTwinInfo: Models.Twin, options: Models.DevicesUpdateTwinOptionalParams, callback: msRest.ServiceCallback<Models.Twin>): void;
  updateTwin(id: string, deviceTwinInfo: Models.Twin, options?: Models.DevicesUpdateTwinOptionalParams | msRest.ServiceCallback<Models.Twin>, callback?: msRest.ServiceCallback<Models.Twin>): Promise<Models.DevicesUpdateTwinResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        deviceTwinInfo,
        options
      },
      updateTwinOperationSpec,
      callback) as Promise<Models.DevicesUpdateTwinResponse>;
  }

  /**
   * Invokes a direct method on a device. See
   * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-direct-methods for more information.
   * @param deviceId The unique identifier of the device.
   * @param directMethodRequest The parameters to execute a direct method on the device.
   * @param [options] The optional parameters
   * @returns Promise<Models.DevicesInvokeMethodResponse>
   */
  invokeMethod(deviceId: string, directMethodRequest: Models.CloudToDeviceMethod, options?: msRest.RequestOptionsBase): Promise<Models.DevicesInvokeMethodResponse>;
  /**
   * @param deviceId The unique identifier of the device.
   * @param directMethodRequest The parameters to execute a direct method on the device.
   * @param callback The callback
   */
  invokeMethod(deviceId: string, directMethodRequest: Models.CloudToDeviceMethod, callback: msRest.ServiceCallback<Models.CloudToDeviceMethodResult>): void;
  /**
   * @param deviceId The unique identifier of the device.
   * @param directMethodRequest The parameters to execute a direct method on the device.
   * @param options The optional parameters
   * @param callback The callback
   */
  invokeMethod(deviceId: string, directMethodRequest: Models.CloudToDeviceMethod, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.CloudToDeviceMethodResult>): void;
  invokeMethod(deviceId: string, directMethodRequest: Models.CloudToDeviceMethod, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.CloudToDeviceMethodResult>, callback?: msRest.ServiceCallback<Models.CloudToDeviceMethodResult>): Promise<Models.DevicesInvokeMethodResponse> {
    return this.client.sendOperationRequest(
      {
        deviceId,
        directMethodRequest,
        options
      },
      invokeMethodOperationSpec,
      callback) as Promise<Models.DevicesInvokeMethodResponse>;
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getDevicesOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "devices",
  queryParameters: [
    Parameters.top,
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: {
        serializedName: "parsedResponse",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "Device"
            }
          }
        }
      }
    },
    default: {}
  },
  serializer
};

const getIdentityOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "devices/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.Device
    },
    default: {}
  },
  serializer
};

const createOrUpdateIdentityOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "devices/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  headerParameters: [
    Parameters.ifMatch
  ],
  requestBody: {
    parameterPath: "device",
    mapper: {
      ...Mappers.Device,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.Device
    },
    default: {}
  },
  serializer
};

const deleteIdentityOperationSpec: msRest.OperationSpec = {
  httpMethod: "DELETE",
  path: "devices/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  headerParameters: [
    Parameters.ifMatch
  ],
  responses: {
    204: {},
    default: {}
  },
  serializer
};

const getTwinOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "twins/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.Twin
    },
    default: {}
  },
  serializer
};

const replaceTwinOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "twins/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  headerParameters: [
    Parameters.ifMatch
  ],
  requestBody: {
    parameterPath: "deviceTwinInfo",
    mapper: {
      ...Mappers.Twin,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.Twin
    },
    default: {}
  },
  serializer
};

const updateTwinOperationSpec: msRest.OperationSpec = {
  httpMethod: "PATCH",
  path: "twins/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  headerParameters: [
    Parameters.ifMatch
  ],
  requestBody: {
    parameterPath: "deviceTwinInfo",
    mapper: {
      ...Mappers.Twin,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.Twin
    },
    default: {}
  },
  serializer
};

const invokeMethodOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "twins/{deviceId}/methods",
  urlParameters: [
    Parameters.deviceId
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  requestBody: {
    parameterPath: "directMethodRequest",
    mapper: {
      ...Mappers.CloudToDeviceMethod,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.CloudToDeviceMethodResult
    },
    default: {}
  },
  serializer
};
