"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var msRest = require("@azure/ms-rest-js");
var Mappers = require("../models/cloudToDeviceMessagesMappers");
var Parameters = require("../models/parameters");
/** Class representing a CloudToDeviceMessages. */
var CloudToDeviceMessages = /** @class */ (function () {
    /**
     * Create a CloudToDeviceMessages.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    function CloudToDeviceMessages(client) {
        this.client = client;
    }
    CloudToDeviceMessages.prototype.purgeCloudToDeviceMessageQueue = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, purgeCloudToDeviceMessageQueueOperationSpec, callback);
    };
    CloudToDeviceMessages.prototype.receiveFeedbackNotification = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, receiveFeedbackNotificationOperationSpec, callback);
    };
    CloudToDeviceMessages.prototype.completeFeedbackNotification = function (lockToken, options, callback) {
        return this.client.sendOperationRequest({
            lockToken: lockToken,
            options: options
        }, completeFeedbackNotificationOperationSpec, callback);
    };
    CloudToDeviceMessages.prototype.abandonFeedbackNotification = function (lockToken, options, callback) {
        return this.client.sendOperationRequest({
            lockToken: lockToken,
            options: options
        }, abandonFeedbackNotificationOperationSpec, callback);
    };
    return CloudToDeviceMessages;
}());
exports.CloudToDeviceMessages = CloudToDeviceMessages;
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var purgeCloudToDeviceMessageQueueOperationSpec = {
    httpMethod: "DELETE",
    path: "devices/{id}/commands",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.PurgeMessageQueueResult
        },
        default: {}
    },
    serializer: serializer
};
var receiveFeedbackNotificationOperationSpec = {
    httpMethod: "GET",
    path: "messages/serviceBound/feedback",
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {},
        204: {},
        default: {}
    },
    serializer: serializer
};
var completeFeedbackNotificationOperationSpec = {
    httpMethod: "DELETE",
    path: "messages/serviceBound/feedback/{lockToken}",
    urlParameters: [
        Parameters.lockToken
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer: serializer
};
var abandonFeedbackNotificationOperationSpec = {
    httpMethod: "POST",
    path: "messages/serviceBound/feedback/{lockToken}/abandon",
    urlParameters: [
        Parameters.lockToken
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer: serializer
};
//# sourceMappingURL=cloudToDeviceMessages.js.map