import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";
/** Class representing a CloudToDeviceMessages. */
export declare class CloudToDeviceMessages {
    private readonly client;
    /**
     * Create a CloudToDeviceMessages.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client: IotHubGatewayServiceAPIsContext);
    /**
     * Deletes all the pending commands for a device in the IoT Hub.
     * @param id The unique identifier of the device.
     * @param [options] The optional parameters
     * @returns Promise<Models.CloudToDeviceMessagesPurgeCloudToDeviceMessageQueueResponse>
     */
    purgeCloudToDeviceMessageQueue(id: string, options?: msRest.RequestOptionsBase): Promise<Models.CloudToDeviceMessagesPurgeCloudToDeviceMessageQueueResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param callback The callback
     */
    purgeCloudToDeviceMessageQueue(id: string, callback: msRest.ServiceCallback<Models.PurgeMessageQueueResult>): void;
    /**
     * @param id The unique identifier of the device.
     * @param options The optional parameters
     * @param callback The callback
     */
    purgeCloudToDeviceMessageQueue(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.PurgeMessageQueueResult>): void;
    /**
     * Gets the feedback for cloud-to-device messages. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging for more information. This
     * capability is only available in the standard tier IoT Hub. For more information, see [Choose the
     * right IoT Hub tier](https://aka.ms/scaleyouriotsolution).
     * @param [options] The optional parameters
     * @returns Promise<msRest.RestResponse>
     */
    receiveFeedbackNotification(options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
    /**
     * @param callback The callback
     */
    receiveFeedbackNotification(callback: msRest.ServiceCallback<void>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    receiveFeedbackNotification(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
    /**
     * Completes the cloud-to-device feedback message. A completed message is deleted from the feedback
     * queue of the service. See https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
     * for more information.
     * @param lockToken The lock token obtained when the cloud-to-device message is received. This is
     * used to resolve race conditions when completing a feedback message.
     * @param [options] The optional parameters
     * @returns Promise<msRest.RestResponse>
     */
    completeFeedbackNotification(lockToken: string, options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
    /**
     * @param lockToken The lock token obtained when the cloud-to-device message is received. This is
     * used to resolve race conditions when completing a feedback message.
     * @param callback The callback
     */
    completeFeedbackNotification(lockToken: string, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param lockToken The lock token obtained when the cloud-to-device message is received. This is
     * used to resolve race conditions when completing a feedback message.
     * @param options The optional parameters
     * @param callback The callback
     */
    completeFeedbackNotification(lockToken: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
    /**
     * Abandons the lock on a cloud-to-device feedback message. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging for more information.
     * @param lockToken The lock token obtained when the cloud-to-device message is received.
     * @param [options] The optional parameters
     * @returns Promise<msRest.RestResponse>
     */
    abandonFeedbackNotification(lockToken: string, options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
    /**
     * @param lockToken The lock token obtained when the cloud-to-device message is received.
     * @param callback The callback
     */
    abandonFeedbackNotification(lockToken: string, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param lockToken The lock token obtained when the cloud-to-device message is received.
     * @param options The optional parameters
     * @param callback The callback
     */
    abandonFeedbackNotification(lockToken: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
}
