import { IotHubGatewayServiceAPIsModels as Models } from '../pl/iotHubGatewayServiceAPIs';
import { TripleValueCallback } from 'azure-iot-common';
import { IoTHubTokenCredentials } from '../auth/iothub_token_credentials';
import * as msRest from '@azure/ms-rest-js';
/**
 * @export
 * @type DigitalTwin   Type alias to simplify the auto generated type's name
 */
export declare type DigitalTwin = Models.DigitalTwinGetDigitalTwinHeaders | undefined;
/**
 * @export
 * @type DigitalTwinResponse   Type alias to simplify the auto generated type's name
 */
export declare type DigitalTwinResponse = Models.DigitalTwinGetDigitalTwinResponse | undefined;
/**
 * @export
 * @type DigitalTwinUpdateResponse   Type alias to simplify the auto generated type's name
 */
export declare type DigitalTwinUpdateResponse = Models.DigitalTwinUpdateDigitalTwinResponse | undefined;
/**
 * @export
 * @type DigitalTwinInvokeComponentCommandResponse   Type alias to simplify the auto generated type's name
 */
export declare type DigitalTwinInvokeComponentCommandResponse = Models.DigitalTwinInvokeComponentCommandResponse | undefined;
/**
 * @export
 * @type DigitalTwinInvokeRootLevelCommandResponse   Type alias to simplify the auto generated type's name
 */
export declare type DigitalTwinInvokeRootLevelCommandResponse = Models.DigitalTwinInvokeRootLevelCommandResponse | undefined;
/**
 * @export
 * @type DigitalTwinInvokeComponentCommandOptionalParams   Type alias to simplify the auto generated type's name
 */
export declare type DigitalTwinInvokeComponentCommandOptionalParams = Models.DigitalTwinInvokeComponentCommandOptionalParams;
/**
 * @export
 * @type DigitalTwinInvokeRootLevelCommandOptionalParams   Type alias to simplify the auto generated type's name
 */
export declare type DigitalTwinInvokeRootLevelCommandOptionalParams = Models.DigitalTwinInvokeRootLevelCommandOptionalParams;
/**
 * @export
 * @class DigitalTwinClient    Main class to implement Azure IoT Digital Twin Client API
 */
export declare class DigitalTwinClient {
    /**
     * @private
     * The IoTHub token credentials used for creating the Protocol Layer client.
     */
    private _creds;
    /**
     * @private
     * The Protocol Layer Client instance used by the DigitalTwinClient.
     */
    private _pl;
    /**
     * @private
     * The Azure IoT service's API version.
     */
    private _apiVersion;
    /**
     * Constructor which also creates an instance of the Protocol Layer Client used by the DigitalTwinClient.
     * @param {IoTHubTokenCredentials} creds    The IoTHub token credentials used for creating the Protocol Layer client.
     * @memberof DigitalTwinClient
     */
    constructor(creds: IoTHubTokenCredentials);
    /**
     * @method getDigitalTwin                      module: azure-iot-digitaltwins-service.DigitalTwinClient.getDigitalTwin
     * @description                                Retrieve the Digital Twin of a given device.
     * @param {string} digitalTwinId               The digital twin Id of the given device or module.
     *                                             Format of digitalTwinId is DeviceId[~ModuleId]. ModuleId is optional.
     * @returns DigitalTwinResponse                The return object containing the Digital Twin plus the HttpResponse.
     * @memberof DigitalTwinClient
     */
    getDigitalTwin(digitalTwinId: string): Promise<DigitalTwinResponse>;
    getDigitalTwin(digitalTwinId: string, callback: TripleValueCallback<DigitalTwin, msRest.HttpOperationResponse>): void;
    /**
     * @method updateDigitalTwin                          module: azure-iot-digitaltwins-service.DigitalTwinClient.updateDigitalTwin
     * @description                                       Update the Digital Twin of a given device using a patch object.
     * @param {string} digitalTwinId                      The digital twin Id of the given device.
     * @param {any[]} patch                               The patch objet contains the update part of a Digital Twin.
     * @param {string} eTag                               The eTag for identifying the patch.
     * @returns DigitalTwinUpdateResponse                 The HTTPesponse.
     * @memberof DigitalTwinClient
     */
    updateDigitalTwin(digitalTwinId: string, patch: any[], eTag?: string): Promise<DigitalTwinUpdateResponse>;
    updateDigitalTwin(digitalTwinId: string, patch: any[], eTagOrCallback?: string | TripleValueCallback<void, msRest.HttpOperationResponse>, callback?: TripleValueCallback<void, msRest.HttpOperationResponse>): void;
    /**
     * @method invokeComponentCommand                                         module: azure-iot-digitaltwins-service.DigitalTwinClient.invokeComponentCommand
     * @description                                                           Invoke a command on an component of a particular device and get the result of it.
     * @param {string} digitalTwinId                                          The digital twin Id of the given device.
     * @param {string} componentName                                          The component's name.
     * @param {string} commandName                                            The command's name.
     * @param {string|any} argument                                           The argument of a command.
     * @param {DigitalTwinInvokeComponentCommandOptionalParams} options       The optional parameter to set options including connectionTimeoutInSeconds and responseTimeoutInSeconds.
     *                                                                        The responseTimeoutInSeconds must be within [5; 300]
     * @returns DigitalTwinInvokeComponentCommandResponse                     The result of the invoked command containing the result, status code, request ID and the parsed HttpResponse.
     * @memberof DigitalTwinClient
     */
    invokeComponentCommand(digitalTwinId: string, componentName: string, commandName: string, argument: string | any, options?: DigitalTwinInvokeComponentCommandOptionalParams): Promise<DigitalTwinInvokeComponentCommandResponse>;
    /**
     * @method invokeCommand                                                  module: azure-iot-digitaltwins-service.DigitalTwinClient.invokeCommand
     * @description                                                           Invoke a command on an component of a particular device and get the result of it.
     * @param {string} digitalTwinId                                          The digital twin Id of the given device.
     * @param {string|any} argument                                           The argument of a command.
     * @param {DigitalTwinInvokeRootLevelCommandOptionalParams} options       The optional parameter to set options including connectionTimeoutInSeconds and responseTimeoutInSeconds.
     *                                                                        The responseTimeoutInSeconds must be within [5; 300]
     * @returns DigitalTwinInvokeRootLevelCommandResponse                     The result of the invoked command containing the result, status code, request ID and the parsed HttpResponse.
     * @memberof DigitalTwinClient
     */
    invokeCommand(digitalTwinId: string, commandName: string, argument: string | any, options?: DigitalTwinInvokeRootLevelCommandOptionalParams): Promise<DigitalTwinInvokeRootLevelCommandResponse>;
}
