/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import * as Mappers from "../models/jobsMappers";
import * as Parameters from "../models/parameters";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";

/** Class representing a Jobs. */
export class Jobs {
  private readonly client: IotHubGatewayServiceAPIsContext;

  /**
   * Create a Jobs.
   * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
   */
  constructor(client: IotHubGatewayServiceAPIsContext) {
    this.client = client;
  }

  /**
   * Creates a new import or export job on the IoT Hub. See
   * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
   * for more information.
   * @param jobProperties The job specifications.
   * @param [options] The optional parameters
   * @returns Promise<Models.JobsCreateImportExportJobResponse>
   */
  createImportExportJob(jobProperties: Models.JobProperties, options?: msRest.RequestOptionsBase): Promise<Models.JobsCreateImportExportJobResponse>;
  /**
   * @param jobProperties The job specifications.
   * @param callback The callback
   */
  createImportExportJob(jobProperties: Models.JobProperties, callback: msRest.ServiceCallback<Models.JobProperties>): void;
  /**
   * @param jobProperties The job specifications.
   * @param options The optional parameters
   * @param callback The callback
   */
  createImportExportJob(jobProperties: Models.JobProperties, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobProperties>): void;
  createImportExportJob(jobProperties: Models.JobProperties, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.JobProperties>, callback?: msRest.ServiceCallback<Models.JobProperties>): Promise<Models.JobsCreateImportExportJobResponse> {
    return this.client.sendOperationRequest(
      {
        jobProperties,
        options
      },
      createImportExportJobOperationSpec,
      callback) as Promise<Models.JobsCreateImportExportJobResponse>;
  }

  /**
   * Gets the status of all import and export jobs in the IoT Hub. See
   * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
   * for more information.
   * @param [options] The optional parameters
   * @returns Promise<Models.JobsGetImportExportJobsResponse>
   */
  getImportExportJobs(options?: msRest.RequestOptionsBase): Promise<Models.JobsGetImportExportJobsResponse>;
  /**
   * @param callback The callback
   */
  getImportExportJobs(callback: msRest.ServiceCallback<Models.JobProperties[]>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  getImportExportJobs(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobProperties[]>): void;
  getImportExportJobs(options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.JobProperties[]>, callback?: msRest.ServiceCallback<Models.JobProperties[]>): Promise<Models.JobsGetImportExportJobsResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      getImportExportJobsOperationSpec,
      callback) as Promise<Models.JobsGetImportExportJobsResponse>;
  }

  /**
   * Gets the status of an import or export job in the IoT Hub. See
   * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
   * for more information.
   * @param id The unique identifier of the job.
   * @param [options] The optional parameters
   * @returns Promise<Models.JobsGetImportExportJobResponse>
   */
  getImportExportJob(id: string, options?: msRest.RequestOptionsBase): Promise<Models.JobsGetImportExportJobResponse>;
  /**
   * @param id The unique identifier of the job.
   * @param callback The callback
   */
  getImportExportJob(id: string, callback: msRest.ServiceCallback<Models.JobProperties>): void;
  /**
   * @param id The unique identifier of the job.
   * @param options The optional parameters
   * @param callback The callback
   */
  getImportExportJob(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobProperties>): void;
  getImportExportJob(id: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.JobProperties>, callback?: msRest.ServiceCallback<Models.JobProperties>): Promise<Models.JobsGetImportExportJobResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      getImportExportJobOperationSpec,
      callback) as Promise<Models.JobsGetImportExportJobResponse>;
  }

  /**
   * Cancels an import or export job in the IoT Hub.
   * @param id The unique identifier of the job.
   * @param [options] The optional parameters
   * @returns Promise<Models.JobsCancelImportExportJobResponse>
   */
  cancelImportExportJob(id: string, options?: msRest.RequestOptionsBase): Promise<Models.JobsCancelImportExportJobResponse>;
  /**
   * @param id The unique identifier of the job.
   * @param callback The callback
   */
  cancelImportExportJob(id: string, callback: msRest.ServiceCallback<any>): void;
  /**
   * @param id The unique identifier of the job.
   * @param options The optional parameters
   * @param callback The callback
   */
  cancelImportExportJob(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<any>): void;
  cancelImportExportJob(id: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<any>, callback?: msRest.ServiceCallback<any>): Promise<Models.JobsCancelImportExportJobResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      cancelImportExportJobOperationSpec,
      callback) as Promise<Models.JobsCancelImportExportJobResponse>;
  }

  /**
   * Gets details of a scheduled job from the IoT Hub. See
   * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-jobs for more information.
   * @param id The unique identifier of the job.
   * @param [options] The optional parameters
   * @returns Promise<Models.JobsGetScheduledJobResponse>
   */
  getScheduledJob(id: string, options?: msRest.RequestOptionsBase): Promise<Models.JobsGetScheduledJobResponse>;
  /**
   * @param id The unique identifier of the job.
   * @param callback The callback
   */
  getScheduledJob(id: string, callback: msRest.ServiceCallback<Models.JobResponse>): void;
  /**
   * @param id The unique identifier of the job.
   * @param options The optional parameters
   * @param callback The callback
   */
  getScheduledJob(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobResponse>): void;
  getScheduledJob(id: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.JobResponse>, callback?: msRest.ServiceCallback<Models.JobResponse>): Promise<Models.JobsGetScheduledJobResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      getScheduledJobOperationSpec,
      callback) as Promise<Models.JobsGetScheduledJobResponse>;
  }

  /**
   * Creates a new job to schedule twin updates or direct methods on the IoT Hub at a scheduled time.
   * See https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-jobs for more information.
   * @param id The unique identifier of the job.
   * @param jobRequest The job request info.
   * @param [options] The optional parameters
   * @returns Promise<Models.JobsCreateScheduledJobResponse>
   */
  createScheduledJob(id: string, jobRequest: Models.JobRequest, options?: msRest.RequestOptionsBase): Promise<Models.JobsCreateScheduledJobResponse>;
  /**
   * @param id The unique identifier of the job.
   * @param jobRequest The job request info.
   * @param callback The callback
   */
  createScheduledJob(id: string, jobRequest: Models.JobRequest, callback: msRest.ServiceCallback<Models.JobResponse>): void;
  /**
   * @param id The unique identifier of the job.
   * @param jobRequest The job request info.
   * @param options The optional parameters
   * @param callback The callback
   */
  createScheduledJob(id: string, jobRequest: Models.JobRequest, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobResponse>): void;
  createScheduledJob(id: string, jobRequest: Models.JobRequest, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.JobResponse>, callback?: msRest.ServiceCallback<Models.JobResponse>): Promise<Models.JobsCreateScheduledJobResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        jobRequest,
        options
      },
      createScheduledJobOperationSpec,
      callback) as Promise<Models.JobsCreateScheduledJobResponse>;
  }

  /**
   * Cancels a scheduled job on the IoT Hub. See
   * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-jobs for more information.
   * @param id The unique identifier of the job.
   * @param [options] The optional parameters
   * @returns Promise<Models.JobsCancelScheduledJobResponse>
   */
  cancelScheduledJob(id: string, options?: msRest.RequestOptionsBase): Promise<Models.JobsCancelScheduledJobResponse>;
  /**
   * @param id The unique identifier of the job.
   * @param callback The callback
   */
  cancelScheduledJob(id: string, callback: msRest.ServiceCallback<Models.JobResponse>): void;
  /**
   * @param id The unique identifier of the job.
   * @param options The optional parameters
   * @param callback The callback
   */
  cancelScheduledJob(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobResponse>): void;
  cancelScheduledJob(id: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.JobResponse>, callback?: msRest.ServiceCallback<Models.JobResponse>): Promise<Models.JobsCancelScheduledJobResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      cancelScheduledJobOperationSpec,
      callback) as Promise<Models.JobsCancelScheduledJobResponse>;
  }

  /**
   * Gets the information about jobs using an IoT Hub query. See
   * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language for more information.
   * @param [options] The optional parameters
   * @returns Promise<Models.JobsQueryScheduledJobsResponse>
   */
  queryScheduledJobs(options?: Models.JobsQueryScheduledJobsOptionalParams): Promise<Models.JobsQueryScheduledJobsResponse>;
  /**
   * @param callback The callback
   */
  queryScheduledJobs(callback: msRest.ServiceCallback<Models.QueryResult>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  queryScheduledJobs(options: Models.JobsQueryScheduledJobsOptionalParams, callback: msRest.ServiceCallback<Models.QueryResult>): void;
  queryScheduledJobs(options?: Models.JobsQueryScheduledJobsOptionalParams | msRest.ServiceCallback<Models.QueryResult>, callback?: msRest.ServiceCallback<Models.QueryResult>): Promise<Models.JobsQueryScheduledJobsResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      queryScheduledJobsOperationSpec,
      callback) as Promise<Models.JobsQueryScheduledJobsResponse>;
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const createImportExportJobOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "jobs/create",
  queryParameters: [
    Parameters.apiVersion
  ],
  requestBody: {
    parameterPath: "jobProperties",
    mapper: {
      ...Mappers.JobProperties,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.JobProperties
    },
    default: {}
  },
  serializer
};

const getImportExportJobsOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "jobs",
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: {
        serializedName: "parsedResponse",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "JobProperties"
            }
          }
        }
      }
    },
    default: {}
  },
  serializer
};

const getImportExportJobOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "jobs/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.JobProperties
    },
    default: {}
  },
  serializer
};

const cancelImportExportJobOperationSpec: msRest.OperationSpec = {
  httpMethod: "DELETE",
  path: "jobs/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: {
        serializedName: "parsedResponse",
        type: {
          name: "Object"
        }
      }
    },
    204: {},
    default: {}
  },
  serializer
};

const getScheduledJobOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "jobs/v2/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.JobResponse
    },
    default: {}
  },
  serializer
};

const createScheduledJobOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "jobs/v2/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  requestBody: {
    parameterPath: "jobRequest",
    mapper: {
      ...Mappers.JobRequest,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.JobResponse
    },
    default: {}
  },
  serializer
};

const cancelScheduledJobOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "jobs/v2/{id}/cancel",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.JobResponse
    },
    default: {}
  },
  serializer
};

const queryScheduledJobsOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "jobs/v2/query",
  queryParameters: [
    Parameters.jobType,
    Parameters.jobStatus,
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.QueryResult
    },
    default: {}
  },
  serializer
};
