import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";
/** Class representing a Devices. */
export declare class Devices {
    private readonly client;
    /**
     * Create a Devices.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client: IotHubGatewayServiceAPIsContext);
    /**
     * Gets the identities of multiple devices from the IoT Hub identity registry. Not recommended. Use
     * the IoT Hub query API to retrieve device twin and device identity information. See
     * https://docs.microsoft.com/en-us/rest/api/iothub/service/queryiothub and
     * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-query-language for more
     * information.
     * @param [options] The optional parameters
     * @returns Promise<Models.DevicesGetDevicesResponse>
     */
    getDevices(options?: Models.DevicesGetDevicesOptionalParams): Promise<Models.DevicesGetDevicesResponse>;
    /**
     * @param callback The callback
     */
    getDevices(callback: msRest.ServiceCallback<Models.Device[]>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    getDevices(options: Models.DevicesGetDevicesOptionalParams, callback: msRest.ServiceCallback<Models.Device[]>): void;
    /**
     * Gets a device from the identity registry of the IoT Hub.
     * @param id The unique identifier of the device.
     * @param [options] The optional parameters
     * @returns Promise<Models.DevicesGetIdentityResponse>
     */
    getIdentity(id: string, options?: msRest.RequestOptionsBase): Promise<Models.DevicesGetIdentityResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param callback The callback
     */
    getIdentity(id: string, callback: msRest.ServiceCallback<Models.Device>): void;
    /**
     * @param id The unique identifier of the device.
     * @param options The optional parameters
     * @param callback The callback
     */
    getIdentity(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Device>): void;
    /**
     * Creates or updates the identity of a device in the identity registry of the IoT Hub.
     * @param id The unique identifier of the device.
     * @param device The contents of the device identity.
     * @param [options] The optional parameters
     * @returns Promise<Models.DevicesCreateOrUpdateIdentityResponse>
     */
    createOrUpdateIdentity(id: string, device: Models.Device, options?: Models.DevicesCreateOrUpdateIdentityOptionalParams): Promise<Models.DevicesCreateOrUpdateIdentityResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param device The contents of the device identity.
     * @param callback The callback
     */
    createOrUpdateIdentity(id: string, device: Models.Device, callback: msRest.ServiceCallback<Models.Device>): void;
    /**
     * @param id The unique identifier of the device.
     * @param device The contents of the device identity.
     * @param options The optional parameters
     * @param callback The callback
     */
    createOrUpdateIdentity(id: string, device: Models.Device, options: Models.DevicesCreateOrUpdateIdentityOptionalParams, callback: msRest.ServiceCallback<Models.Device>): void;
    /**
     * Deletes the identity of a device from the identity registry of the IoT Hub.
     * @param id The unique identifier of the device.
     * @param [options] The optional parameters
     * @returns Promise<msRest.RestResponse>
     */
    deleteIdentity(id: string, options?: Models.DevicesDeleteIdentityOptionalParams): Promise<msRest.RestResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param callback The callback
     */
    deleteIdentity(id: string, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param id The unique identifier of the device.
     * @param options The optional parameters
     * @param callback The callback
     */
    deleteIdentity(id: string, options: Models.DevicesDeleteIdentityOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * Gets the device twin. See https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-device-twins
     * for more information.
     * @param id The unique identifier of the device.
     * @param [options] The optional parameters
     * @returns Promise<Models.DevicesGetTwinResponse>
     */
    getTwin(id: string, options?: msRest.RequestOptionsBase): Promise<Models.DevicesGetTwinResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param callback The callback
     */
    getTwin(id: string, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * @param id The unique identifier of the device.
     * @param options The optional parameters
     * @param callback The callback
     */
    getTwin(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * Replaces the tags and desired properties of a device twin. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-device-twins for more information.
     * @param id The unique identifier of the device.
     * @param deviceTwinInfo The device twin info that will replace the existing info.
     * @param [options] The optional parameters
     * @returns Promise<Models.DevicesReplaceTwinResponse>
     */
    replaceTwin(id: string, deviceTwinInfo: Models.Twin, options?: Models.DevicesReplaceTwinOptionalParams): Promise<Models.DevicesReplaceTwinResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param deviceTwinInfo The device twin info that will replace the existing info.
     * @param callback The callback
     */
    replaceTwin(id: string, deviceTwinInfo: Models.Twin, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * @param id The unique identifier of the device.
     * @param deviceTwinInfo The device twin info that will replace the existing info.
     * @param options The optional parameters
     * @param callback The callback
     */
    replaceTwin(id: string, deviceTwinInfo: Models.Twin, options: Models.DevicesReplaceTwinOptionalParams, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * Updates the tags and desired properties of a device twin. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-device-twins for more information.
     * @param id The unique identifier of the device.
     * @param deviceTwinInfo The device twin info containing the tags and desired properties to be
     * updated.
     * @param [options] The optional parameters
     * @returns Promise<Models.DevicesUpdateTwinResponse>
     */
    updateTwin(id: string, deviceTwinInfo: Models.Twin, options?: Models.DevicesUpdateTwinOptionalParams): Promise<Models.DevicesUpdateTwinResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param deviceTwinInfo The device twin info containing the tags and desired properties to be
     * updated.
     * @param callback The callback
     */
    updateTwin(id: string, deviceTwinInfo: Models.Twin, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * @param id The unique identifier of the device.
     * @param deviceTwinInfo The device twin info containing the tags and desired properties to be
     * updated.
     * @param options The optional parameters
     * @param callback The callback
     */
    updateTwin(id: string, deviceTwinInfo: Models.Twin, options: Models.DevicesUpdateTwinOptionalParams, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * Invokes a direct method on a device. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-direct-methods for more information.
     * @param deviceId The unique identifier of the device.
     * @param directMethodRequest The parameters to execute a direct method on the device.
     * @param [options] The optional parameters
     * @returns Promise<Models.DevicesInvokeMethodResponse>
     */
    invokeMethod(deviceId: string, directMethodRequest: Models.CloudToDeviceMethod, options?: msRest.RequestOptionsBase): Promise<Models.DevicesInvokeMethodResponse>;
    /**
     * @param deviceId The unique identifier of the device.
     * @param directMethodRequest The parameters to execute a direct method on the device.
     * @param callback The callback
     */
    invokeMethod(deviceId: string, directMethodRequest: Models.CloudToDeviceMethod, callback: msRest.ServiceCallback<Models.CloudToDeviceMethodResult>): void;
    /**
     * @param deviceId The unique identifier of the device.
     * @param directMethodRequest The parameters to execute a direct method on the device.
     * @param options The optional parameters
     * @param callback The callback
     */
    invokeMethod(deviceId: string, directMethodRequest: Models.CloudToDeviceMethod, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.CloudToDeviceMethodResult>): void;
}
