/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated
 */

/**
 * @packageDocumentation
 * @module aws-iot-device-sdk
 */


/**
 * Data needed to perform a CreateCertificateFromCsr operation.
 *
 * @category IotIdentity
 */
export interface CreateCertificateFromCsrRequest {

    /**
     * The CSR, in PEM format.
     *
     */
    certificateSigningRequest?: string;

}

/**
 * Response payload to a CreateCertificateFromCsr request.
 *
 * @category IotIdentity
 */
export interface CreateCertificateFromCsrResponse {

    /**
     * The ID of the certificate.
     *
     */
    certificateId?: string;

    /**
     * The token to prove ownership of the certificate during provisioning.
     *
     */
    certificateOwnershipToken?: string;

    /**
     * The certificate data, in PEM format.
     *
     */
    certificatePem?: string;

}

/**
 * Data needed to subscribe to the responses of the CreateCertificateFromCsr operation.
 *
 * @category IotIdentity
 */
export interface CreateCertificateFromCsrSubscriptionRequest {

}

/**
 * Data needed to perform a CreateKeysAndCertificate operation.
 *
 * @category IotIdentity
 */
export interface CreateKeysAndCertificateRequest {

}

/**
 * Response payload to a CreateKeysAndCertificate request.
 *
 * @category IotIdentity
 */
export interface CreateKeysAndCertificateResponse {

    /**
     * The certificate id.
     *
     */
    certificateId?: string;

    /**
     * The token to prove ownership of the certificate during provisioning.
     *
     */
    certificateOwnershipToken?: string;

    /**
     * The certificate data, in PEM format.
     *
     */
    certificatePem?: string;

    /**
     * The private key.
     *
     */
    privateKey?: string;

}

/**
 * Data needed to subscribe to the responses of the CreateKeysAndCertificate operation.
 *
 * @category IotIdentity
 */
export interface CreateKeysAndCertificateSubscriptionRequest {

}

/**
 * Response document containing details about a failed request.
 *
 * @category IotIdentity
 */
export interface ErrorResponse {

    /**
     * Response status code
     *
     */
    statusCode?: number;

    /**
     * Response error message
     *
     */
    errorMessage?: string;

    /**
     * Response error code
     *
     */
    errorCode?: string;

}

/**
 * Data needed to perform a RegisterThing operation.
 *
 * @category IotIdentity
 */
export interface RegisterThingRequest {

    /**
     * The provisioning template name.
     *
     */
    templateName: string;

    /**
     * Optional. Key-value pairs from the device that are used by the pre-provisioning hooks to evaluate the registration request.
     *
     */
    parameters?: {[key: string]: string};

    /**
     * The token to prove ownership of the certificate. The token is generated by AWS IoT when you create a certificate over MQTT.
     *
     */
    certificateOwnershipToken?: string;

}

/**
 * Response payload to a RegisterThing request.
 *
 * @category IotIdentity
 */
export interface RegisterThingResponse {

    /**
     * The name of the IoT thing created during provisioning.
     *
     */
    thingName?: string;

    /**
     * The device configuration defined in the template.
     *
     */
    deviceConfiguration?: {[key: string]: string};

}

/**
 * Data needed to subscribe to the responses of the RegisterThing operation.
 *
 * @category IotIdentity
 */
export interface RegisterThingSubscriptionRequest {

    /**
     * Name of the provisioning template to listen for RegisterThing responses for.
     *
     */
    templateName: string;

}

