/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

#pragma once

/* The following macros can be concatanated to generate a SSLv2 ClientHello
 * message and record 
 */

#define SSLv2_CLIENT_HELLO_HEADER 0x80, 0xb3, 0x01, 0x03, 0x03

#define SSLv2_CLIENT_HELLO_PREFIX 0x00, 0x8a, 0x00, 0x00, 0x00, 0x20

#define SSLv2_CLIENT_HELLO_CIPHER_SUITES 0x00, 0xc0, 0x24, 0x00, 0xc0, 0x28, 0x00, 0x00, \
	    0x3d, 0x00, 0xc0, 0x26, 0x00, 0xc0, 0x2a, 0x00, \
	    0x00, 0x6b, 0x00, 0x00, 0x6a, 0x00, 0xc0, 0x0a, \
	    0x07, 0x00, 0xc0, 0x00, 0xc0, 0x14, 0x00, 0x00, \
	    0x35, 0x00, 0xc0, 0x05, 0x00, 0xc0, 0x0f, 0x00, \
	    0x00, 0x39, 0x00, 0x00, 0x38, 0x00, 0xc0, 0x23, \
	    0x00, 0xc0, 0x27, 0x00, 0x00, 0x3c, 0x00, 0xc0, \
	    0x25, 0x00, 0xc0, 0x29, 0x00, 0x00, 0x67, 0x00, \
	    0x00, 0x40, 0x00, 0xc0, 0x09, 0x06, 0x00, 0x40, \
	    0x00, 0xc0, 0x13, 0x00, 0x00, 0x2f, 0x00, 0xc0, \
	    0x04, 0x01, 0x00, 0x80, 0x00, 0xc0, 0x0e, 0x00, \
	    0x00, 0x33, 0x00, 0x00, 0x32, 0x00, 0xc0, 0x2c, \
	    0x00, 0xc0, 0x2b, 0x00, 0xc0, 0x30, 0x00, 0x00, \
	    0x9d, 0x00, 0xc0, 0x2e, 0x00, 0xc0, 0x32, 0x00, \
	    0x00, 0x9f, 0x00, 0x00, 0xa3, 0x00, 0xc0, 0x2f, \
	    0x00, 0x00, 0x9c, 0x00, 0xc0, 0x2d, 0x00, 0xc0, \
	    0x31, 0x00, 0x00, 0x9e, 0x00, 0x00, 0xa2, 0x00, \
	    0x00, 0xff

#define SSLv2_CLIENT_HELLO_CHALLENGE 0x5b, 0xe9, 0xcc, 0xad, 0xd6, 0xa5, 0x20, 0xac, \
	    0xa3, 0xf4, 0x8e, 0x88, 0x06, 0xb5, 0x95, 0x53, \
	    0x2d, 0x53, 0xfe, 0xd7, 0xa1, 0x00, 0x57, 0xc0, \
	    0x53, 0x9d, 0x84, 0x71, 0x80, 0x7f, 0x30, 0x7e

